package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;



/**
 * Session Bean implementation class DDProductWizEJB
 */
@Stateless
public class DDProductWizEJB extends ValidatorEJB implements DDProductWizRemote, DDProductWizLocal 
{
	//GenericUtility genericUtility = GenericUtility.getInstance();
	E12GenericUtility genericUtility = new E12GenericUtility(); //Added by Parikshit Kumbhar on 23/04/2015
	DistCommon discommon = new DistCommon();
    /**
     * Default constructor. 
     */
    public DDProductWizEJB() {
        // TODO Auto-generated constructor stub
    }
    
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		
		try
		{
			System.out.println("xmlString:::"+xmlString);
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : Cpp : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		
		return(errString);
	}
	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException 
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String userId = "";
		String errCode = "";
		String errorType = "";
		String errString = "";
		int ctr=0;
		int childNodeListLength;
		int currentFormNo = 0;
		long cnt = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		// Changed by Sneha on 23-06-2016 [Start]
		boolean flag = false; 
		String item_barcode = "", fieldValue = "", msgNo = "", msgStr1 = "", msgStr2 = ""; 
		// Changed by Sneha on 23-06-2016 [End]
		
		//ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					
					if (childNodeName.equalsIgnoreCase("item_parnt")) 
					{
						int paramName = 0;
						String item_parnt = genericUtility.getColumnValue("item_parnt", dom);
						String countSerSql = "SELECT COUNT(1) AS COUNT FROM ITEM WHERE TRIM(ITEM_CODE) = ?";
						PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
						pstmtParamName.setString(1, item_parnt);
						ResultSet rsCnt = pstmtParamName.executeQuery();
						
						System.out.println("countSerSql" + countSerSql);
						if (rsCnt.next()) 
						{
							paramName = rsCnt.getInt("COUNT");
						}
						// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [Start]
						if( pstmtParamName != null )
						{
							pstmtParamName.close();
							pstmtParamName = null;
						}
						if ( rsCnt != null )
						{
							rsCnt.close();
							rsCnt = null;
						}
						// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [End]
						
						if (paramName != 0) {
							
							errCode = "DUPITEMCD";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("item_parnt_desc")) 
					{
						int paramName = 0;
						String item_parnt_desc = genericUtility.getColumnValue("item_parnt_desc", dom);
						String countSerSql = "SELECT COUNT(1) AS COUNT FROM ITEM WHERE TRIM(DESCR) = ?";
						PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
						pstmtParamName.setString(1, item_parnt_desc);
						ResultSet rsCnt = pstmtParamName.executeQuery();
						
						System.out.println("countSerSql" + countSerSql);
						if (rsCnt.next()) 
						{
							paramName = rsCnt.getInt("COUNT");
						}
						// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [Start]
						if( pstmtParamName != null )
						{
							pstmtParamName.close();
							pstmtParamName = null;
						}
						if ( rsCnt != null )
						{
							rsCnt.close();
							rsCnt = null;
						}
						// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [End]
						
						if (paramName != 0) {
							
							errCode = "DUPITEMDES";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("item_type")) 
					{
						int paramName = 0;
						String itemType = genericUtility.getColumnValue("item_type", dom);
						String countSerSql = "SELECT COUNT(1) AS COUNT FROM ITEM_TYPE WHERE ITEM_TYPE = ?";//Added By Parikshit Kumbhar on 29/05/15 Changed pophelp query
						PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
						pstmtParamName.setString(1, itemType);
						ResultSet rsCnt = pstmtParamName.executeQuery();
						
						System.out.println("countSerSql" + countSerSql);
						if (rsCnt.next()) 
						{
							paramName = rsCnt.getInt("COUNT");
						}
						// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [Start]
						if( pstmtParamName != null )
						{
							pstmtParamName.close();
							pstmtParamName = null;
						}
						if ( rsCnt != null )
						{
							rsCnt.close();
							rsCnt = null;
						}
						// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [End]
						
						/*if (paramName == 0) {
							
							errCode = "INVSLSPERS";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}*/
					}
					else if (childNodeName.equalsIgnoreCase("item_ser")) 
					{
						int paramName = 0;
						String itemSer = genericUtility.getColumnValue("item_ser", dom);
						String countSerSql = "SELECT COUNT(1) AS COUNT FROM itemser WHERE item_ser = ?";//Added By Parikshit Kumbhar on 29/05/15 Changed pophelp query
						PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
						pstmtParamName.setString(1, itemSer);
						ResultSet rsCnt = pstmtParamName.executeQuery();
						
						System.out.println("countSerSql" + countSerSql);
						if (rsCnt.next()) 
						{
							paramName = rsCnt.getInt("COUNT");
						}
						// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [Start]
						if( pstmtParamName != null )
						{
							pstmtParamName.close();
							pstmtParamName = null;
						}
						if ( rsCnt != null )
						{
							rsCnt.close();
							rsCnt = null;
						}
						// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [End]
					}
					else if (childNodeName.equalsIgnoreCase("grp_code")) 
					{
						int paramName = 0;
						String gradeCode = genericUtility.getColumnValue("grp_code", dom);
						String countSerSql = "SELECT COUNT(1) AS COUNT FROM gencodes WHERE fld_name = 'GRP_CODE' and mod_name = 'W_DD_PRODUCTWIZ' AND fld_value = ?";
						PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
						pstmtParamName.setString(1, gradeCode);
						ResultSet rsCnt = pstmtParamName.executeQuery();
						
						System.out.println("countSerSql" + countSerSql);
						if (rsCnt.next()) 
						{
							paramName = rsCnt.getInt("COUNT");
						}
						// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [Start]
						if( pstmtParamName != null )
						{
							pstmtParamName.close();
							pstmtParamName = null;
						}
						if ( rsCnt != null )
						{
							rsCnt.close();
							rsCnt = null;
						}
						// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [End]
						
					}
					else if (childNodeName.equalsIgnoreCase("site_codes")) 
					{
						String siteCode = checkNullAndTrim(genericUtility.getColumnValue("site_codes", dom));
						
						if (!siteCode.equals(""))
						{
							String[] siteCodes = siteCode.split(",");
							
							for (int i = 0; i < siteCodes.length; i++)
							{
								int paramName = 0;
								
								String countSerSql = "SELECT COUNT(1) AS COUNT FROM SITE WHERE SITE_CODE = ?";
								PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
								pstmtParamName.setString(1, checkNullAndTrim(siteCodes[i]));
								ResultSet rsCnt = pstmtParamName.executeQuery();
								
								System.out.println("countSerSql" + countSerSql);
								if (rsCnt.next()) 
								{
									paramName = rsCnt.getInt("COUNT");
								}
								// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [Start]
								if( pstmtParamName != null )
								{
									pstmtParamName.close();
									pstmtParamName = null;
								}
								if ( rsCnt != null )
								{
									rsCnt.close();
									rsCnt = null;
								}
								// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [End]
								
								if (paramName == 0) 
								{
									errCode = "INVSITESEL";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("color_codes")) 
					{
						String colorCode = checkNullAndTrim(genericUtility.getColumnValue("color_codes", dom));
						
						if (!colorCode.equals(""))
						{
							String[] colorCodes = colorCode.split(",");
							
							for (int i = 0; i < colorCodes.length; i++)
							{
								int paramName = 0;
								String countSerSql = "SELECT COUNT(1) AS COUNT FROM ITM_ATTRIB_VAL WHERE ATTRIB_CODE ='COLOR' AND TRIM(ATTRIB_ID) = ?";//Added By Parikshit Kumbhar on 29/05/15 Changed pophelp query
								PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
								pstmtParamName.setString(1, checkNullAndTrim(colorCodes[i]));
								ResultSet rsCnt = pstmtParamName.executeQuery();
								
								System.out.println("countSerSql" + countSerSql);
								if (rsCnt.next()) 
								{
									paramName = rsCnt.getInt("COUNT");
								}
								// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [Start]
								if( pstmtParamName != null )
								{
									pstmtParamName.close();
									pstmtParamName = null;
								}
								if ( rsCnt != null )
								{
									rsCnt.close();
									rsCnt = null;
								}
								// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [End]
								
								if (paramName == 0) 
								{
									errCode = "INVCLRSEL";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("category_descr")) 
					{
						String category = checkNullAndTrim(genericUtility.getColumnValue("category_descr", dom));
						
						if (!category.equals(""))
						{
							String[] categoryCodes = category.split(",");
							
							for (int i = 0; i < categoryCodes.length; i++)
							{
								int paramName = 0;
								
								String countSerSql = "SELECT COUNT(1) AS COUNT FROM ITM_ATTRIB_VAL WHERE ATTRIB_CODE ='CATEGORY' AND TRIM(ATTRIB_ID) = ?";//Added By Parikshit Kumbhar on 29/05/15 Changed pophelp query
								PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
								pstmtParamName.setString(1, checkNullAndTrim(categoryCodes[i]));
								ResultSet rsCnt = pstmtParamName.executeQuery();
								
								System.out.println("countSerSql" + countSerSql);
								if (rsCnt.next()) 
								{
									paramName = rsCnt.getInt("COUNT");
								}
								// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [Start]
								if( pstmtParamName != null )
								{
									pstmtParamName.close();
									pstmtParamName = null;
								}
								if ( rsCnt != null )
								{
									rsCnt.close();
									rsCnt = null;
								}
								// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [End]
								
								if (paramName == 0) 
								{
									errCode = "INVCATSEL";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
					}
					// Changed by Sneha on 23-06-2016 for validation of dimension [Start]
					else if (childNodeName.equalsIgnoreCase("dimension_desc")) 
					{
						String dimensionDesc = checkNullAndTrim(genericUtility.getColumnValue("dimension_desc", dom));
						//System.out.println("dimensionDesc==========>>"+dimensionDesc);
						
						if (dimensionDesc.length() == 0) 
						{
							errCode = "INVDIMENSI";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					// Changed by Sneha on 23-06-2016 for validation of dimension [End]
					
					// Changed by Sneha on 24-10-2016 for validation of customer item reference [Start]
					else if (childNodeName.equalsIgnoreCase("phy_attrib_4")) 
					{
						String custItemRef = checkNullAndTrim(genericUtility.getColumnValue("phy_attrib_4", dom));
						System.out.println("custItemRef==========>>"+custItemRef);
						
						if (custItemRef.length() == 0) 
						{
							errCode = "VTINVCITEM";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							int count = 0;
							String countSerSql = "SELECT COUNT(1) AS COUNT FROM ITEM WHERE TRIM(PHY_ATTRIB_4) = ?";
							PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
							pstmtParamName.setString(1, custItemRef);
							ResultSet rsCnt = pstmtParamName.executeQuery();
							if (rsCnt.next()) 
							{
								count = rsCnt.getInt("COUNT");
							}
							if( pstmtParamName != null )
							{
								pstmtParamName.close();
								pstmtParamName = null;
							}
							if ( rsCnt != null )
							{
								rsCnt.close();
								rsCnt = null;
							}
							if (count > 0) 
							{
								errCode = "DUPCUSTITM";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					// Changed by Sneha on 24-10-2016 for validation of customer item reference [End]
					
				}
				break;
			case 2 :
				String customerName = "", custItemRef = "";
				int paramName = 0;
				
				System.out.println("DOM in case2 ---->>["+genericUtility.serializeDom(dom).toString()+"]");
				System.out.println("DOM1 in case2 ----->>["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2 in case2 ----->>["+genericUtility.serializeDom(dom2).toString()+"]");
				
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					
					   if (childNodeName.equalsIgnoreCase("item_barcode")) 
					   {
							
							// Changed by Sneha on 23-06-2016 for validation of item_barcode [Start]
							//String item_parnt = genericUtility.getColumnValue("item_barcode", dom);
							item_barcode = genericUtility.getColumnValue("item_barcode", dom);
							// Changed by Sneha on 23-06-2016 for validation of item_barcode [End]
							
							String countSerSql = "SELECT COUNT(1) AS COUNT FROM ITEM WHERE TRIM(udf__str2) = ?";
							PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
							
							// Changed by Sneha on 23-06-2016 for validation of item_barcode [Start]
							//pstmtParamName.setString(1, item_parnt);
							pstmtParamName.setString(1, item_barcode);
							// Changed by Sneha on 23-06-2016 for validation of item_barcode [End]
							ResultSet rsCnt = pstmtParamName.executeQuery();
							
							System.out.println("countSerSql" + countSerSql);
							if (rsCnt.next()) 
							{
								paramName = rsCnt.getInt("COUNT");
							}
							// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [Start]
							if( pstmtParamName != null )
							{
								pstmtParamName.close();
								pstmtParamName = null;
							}
							if ( rsCnt != null )
							{
								rsCnt.close();
								rsCnt = null;
							}
							// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [End]
							
							if (paramName != 0) 
							{
								// Changed by Sneha on 23-06-2016 for validation of item_barcode [Start]
								flag = true; 
								fieldValue = item_barcode;
								msgNo = "DUPITMBARC";
								msgStr1 = "Invalid Barcode for.";
								msgStr2 = "Barcode already exists in master for the barcode";
								
								/*errCode = "DUPITMBARC";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());*/
								// Changed by Sneha on 23-06-2016 for validation of item_barcode [Start]
							}
						}
					   
					   // Changed by Sneha on 23-06-2016 for duplicate validation for customer item references [Start]
					   else if (childNodeName.equalsIgnoreCase("phy_attrib_4"))
					   {
						   custItemRef = genericUtility.getColumnValue("phy_attrib_4", dom);

						   if (custItemRef.length() == 0) 
						   {
								errCode = "VTINVCITEM";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
						   }
						   else if (custItemRef.length() > 0) 
						   {
							    String countSerSql = "SELECT COUNT(1) AS COUNT FROM ITEM WHERE TRIM(PHY_ATTRIB_4) = ?";
								PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
								pstmtParamName.setString(1, custItemRef);
								ResultSet rsCnt = pstmtParamName.executeQuery();
								if (rsCnt.next()) 
								{
									paramName = rsCnt.getInt("COUNT");
								}
								if( pstmtParamName != null )
								{
									pstmtParamName.close();
									pstmtParamName = null;
								}
								if ( rsCnt != null )
								{
									rsCnt.close();
									rsCnt = null;
								}
								if (paramName != 0) 
								{
									flag = true; 
									fieldValue = custItemRef;
									msgNo = "DUPCUSTITM";
									msgStr1 = "Invalid Customer item reference for.";
									msgStr2 = "Customer item reference already exists in item master";
								} 
								
								
								
								
						   }
					   }
					   // Changed by Sneha on 23-06-2016 for duplicate validation for customer item references [End]
				}
				
				if( errString.indexOf("<Errors>")!=-1 )
				{
					if( errString.length() > 0 )
					{
						String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>")) + " for customer " + customerName ;

						errString = errString.substring(0, errString.indexOf("<description>")+("<description>").length()) + msgDescr + "" + errString.substring( errString.indexOf("</description>"), errString.length());
						return errString;
					}
								
				}
			}
			
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			// Changed by Sneha on 23-06-2016 for validation of item_barcode [Start]
			else
			{
				
				//errStringXml = new StringBuffer("");
				if(flag) 
				{
					//System.out.println("Inside flag=======>>"+flag);
					//return getError(item_barcode, "DUPITMBARC", conn); 
					return getError(fieldValue, msgNo, msgStr1, msgStr2, conn);
				}
				else
				{
					errStringXml = new StringBuffer("");
				}
			}
			// Changed by Sneha on 23-06-2016 for validation of item_barcode [End]
		}// End of try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//connDriver = null;
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}
	
	// Changed by Sneha on 23-06-2016 for validation of item_barcode [Start]
	//public  String getError(String item_barcode, String Code, Connection conn)  throws ITMException, Exception
	public  String getError(String fieldValue, String msgNo, String msgStr1, String msgStr2, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";
		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",msgNo,"","",conn);
			String begPart = errString.substring(0,errString.indexOf("<message>")+9);
			String endDesc = errString.substring(errString.indexOf("</description>"));
			mainStr= begPart+ msgStr1 +"</message><description>";
			mainStr= mainStr+ msgStr2 + " : ["+fieldValue+"]."+endDesc;
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	// Changed by Sneha on 23-06-2016 for validation of item_barcode [End]
	
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";
		
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			/*System.out.println("xmlString : ["+ xmlString+ "] \nxmlString1 : ["+ xmlString1 +"] \nxmlString2 : ["+ xmlString2 +"]");*/
			
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :DDProductWizEJB:itemChanged(String,String,String,String,String,String):" + e.getMessage() + ":");
			valueXmlString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		
		return (valueXmlString);
	}
	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		
		String userId = "";
		String currDate = "";
		int currentFormNo = 0;
		
		StringBuffer valueXmlString = new StringBuffer();
		//ConnDriver connDriver = new ConnDriver();
		String sqlQueryDisparam;
		String strLocId = "";
		String sqlQueryLocation;
		String locCode = "";
		String locDescr = "";
		String locType = "";
		String custItemRefVal = "", custItemRef = "", commodityNo = "", barcodeFlagVal = "";
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			System.out.println("user id is equal to ===============> "+userId);
			conn.setAutoCommit(false);
			//connDriver = null;
			String dateFormat = genericUtility.getApplDateFormat(); // Added by Parikshit Kumbhar on 08/07/2015 [to set date format]
			//Added by Chetan Mahajan on date:06/02/2015 [Getting loc_code from disparam table] Start
			sqlQueryDisparam = "select var_value from disparm where var_name='PGRL_INVSTAT'";
			pstmt = conn.prepareStatement(sqlQueryDisparam);
			rs = pstmt.executeQuery();		
			if(rs.next())
			{
				strLocId = rs.getString(1);
			}
			// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [Start]
			//pstmt=null;
			//rs=null;
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [End]

			if(!strLocId.equals(""))
			{
				sqlQueryLocation = "select loc_code, descr,loc_type from location where loc_code = ?";
				pstmt = conn.prepareStatement(sqlQueryLocation);
				pstmt.setString(1, strLocId);
				rs = pstmt.executeQuery();
				if(rs.next()) 
				{
					locCode = rs.getString(1);
					locDescr = rs.getString(2);
					locType = rs.getString(3);
				}
				// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [Start]
				//pstmt=null;
				//rs=null;
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				// Changed by Sneha on 21-07-2016, for Closing the Open Cusor [End]
			}
			System.out.println("Location code = "+locCode);
			System.out.println("Location Descr = "+locDescr);
			System.out.println("Location Type = "+locType);
			//Added by Chetan Mahajan on date:06/02/2015 [Getting loc_code from disparam table] End

			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?>\r\n<Root>\r\n<header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</header>\r\n");
			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			currDate = sdf.format(new java.util.Date());
			
			System.out.println("Xtra Params="+xtraParams);//Changed by Wasim on 14-03-2016 to print Extra Params
			
			dateFormat = genericUtility.getApplDateFormat();
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			String chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			String loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );//Changed by wasim on 14-03-2016 to get site code

			switch ( currentFormNo )
			{
				case 1:
				{   
					valueXmlString.append("<Detail1 domID='1' selected = 'N'>\r\n");
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						valueXmlString.append("<item_parnt>").append("<![CDATA[]]>").append("</item_parnt>\r\n");
						valueXmlString.append("<item_parnt_desc>").append("<![CDATA[]]>").append("</item_parnt_desc>\r\n");	
						valueXmlString.append("<item_type>").append("<![CDATA[]]>").append("</item_type>\r\n");
						valueXmlString.append("<item_type_desc>").append("<![CDATA[]]>").append("</item_type_desc>\r\n");
						valueXmlString.append("<item_ser>").append("<![CDATA[]]>").append("</item_ser>\r\n");	
						valueXmlString.append("<itemser_descr>").append("<![CDATA[]]>").append("</itemser_descr>\r\n");
						valueXmlString.append("<descr>").append("<![CDATA[]]>").append("</descr>\r\n");
						valueXmlString.append("<grp_code>").append("<![CDATA[]]>").append("</grp_code>\r\n");
						valueXmlString.append("<grp_code_desc>").append("<![CDATA[]]>").append("</grp_code_desc>\r\n");	
						valueXmlString.append("<loc_code>").append("<![CDATA["+ checkNullAndTrim(locCode) +"]]>").append("</loc_code>\r\n");
						valueXmlString.append("<stk_opt>").append("<![CDATA[]]>").append("</stk_opt>\r\n");
						valueXmlString.append("<site_codes>").append("<![CDATA[]]>").append("</site_codes>\r\n");	
						valueXmlString.append("<site_desc>").append("<![CDATA[]]>").append("</site_desc>\r\n");

						valueXmlString.append("<dimension_desc>").append("<![CDATA[]]>").append("</dimension_desc>\r\n");
						valueXmlString.append("<dim_code_desc>").append("<![CDATA[]]>").append("</dim_code_desc>\r\n");

						valueXmlString.append("<color_codes>").append("<![CDATA[]]>").append("</color_codes>\r\n");
						valueXmlString.append("<color_code_descr>").append("<![CDATA[]]>").append("</color_code_descr>\r\n");
						valueXmlString.append("<size_codes>").append("<![CDATA[]]>").append("</size_codes>\r\n");
						valueXmlString.append("<size_type>").append("<![CDATA[]]>").append("</size_type>\r\n");
						valueXmlString.append("<phy_attr4>").append("<![CDATA[]]>").append("</phy_attr4>\r\n");	
						valueXmlString.append("<phy_attr5>").append("<![CDATA[]]>").append("</phy_attr5>\r\n");
						//valueXmlString.append("<price>").append("<![CDATA[]]>").append("</price>\r\n");
						//valueXmlString.append("<curr_code>").append("<![CDATA[]]>").append("</curr_code>\r\n");	
						valueXmlString.append("<unit>").append("<![CDATA[NOS]]>").append("</unit>\r\n");
						
						valueXmlString.append("<track_shelf_life>").append("<![CDATA[N]]>").append("</track_shelf_life>\r\n");
						valueXmlString.append("<unit_rate>").append("<![CDATA[]]>").append("</unit_rate>\r\n");
						
						valueXmlString.append("<item_category>").append("<![CDATA[]]>").append("</item_category>\r\n");
						valueXmlString.append("<category_descr>").append("<![CDATA[]]>").append("</category_descr>\r\n");
						valueXmlString.append("<price_list_dtl>").append("<![CDATA[]]>").append("</price_list_dtl>\r\n");
						valueXmlString.append("<item_length>").append("<![CDATA[0.000]]>").append("</item_length>\r\n");	
						valueXmlString.append("<item_width>").append("<![CDATA[0.000]]>").append("</item_width>\r\n");
						valueXmlString.append("<item_height>").append("<![CDATA[0.000]]>").append("</item_height>\r\n");
						valueXmlString.append("<item_gross_wt>").append("<![CDATA[0.000]]>").append("</item_gross_wt>\r\n");
						
						valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");
						valueXmlString.append("<supplier_desc>").append("<![CDATA[]]>").append("</supplier_desc>\r\n");
						valueXmlString.append("<supp_item_desc>").append("<![CDATA[]]>").append("</supp_item_desc>\r\n");
						
						valueXmlString.append("<img_path>").append("<![CDATA[]]>").append("</img_path>\r\n");
						valueXmlString.append("<item_sh_descr>").append("<![CDATA[]]>").append("</item_sh_descr>\r\n");
						valueXmlString.append("<long_desc>").append("<![CDATA[]]>").append("</long_desc>\r\n");
						valueXmlString.append("<meta_desc>").append("<![CDATA[]]>").append("</meta_desc>\r\n");
						valueXmlString.append("<meta_keywords>").append("<![CDATA[]]>").append("</meta_keywords>\r\n");	
						valueXmlString.append("<meta_title>").append("<![CDATA[]]>").append("</meta_title>\r\n");
						
						valueXmlString.append("<login_code>").append("<![CDATA["+ userId +"]]>").append("</login_code>\r\n");
						valueXmlString.append("<chg_date>").append("<![CDATA["+ currDate +"]]>").append("</chg_date>\r\n");	
						valueXmlString.append("<chg_user>").append("<![CDATA["+ userId +"]]>").append("</chg_user>\r\n");
						valueXmlString.append("<chg_term>").append("<![CDATA["+ chgTerm +"]]>").append("</chg_term>\r\n");
						//Added by Chetan Mahajan on date:06/02/2015 [Added purchase lead time,location description, location ] Start
						valueXmlString.append("<pur_lead_time>").append("<![CDATA[0]]>").append("</pur_lead_time>\r\n");                     
						valueXmlString.append("<location_descr>").append("<![CDATA["+ checkNullAndTrim(locDescr) +"]]>").append("</location_descr>\r\n");   
						valueXmlString.append("<loc_type>").append("<![CDATA["+ checkNullAndTrim(locType) +"]]>").append("</loc_type>\r\n");  
						//Added by Chetan Mahajan on date:06/02/2015 [Added purchase lead time,location description, location ] End
						//Added by Parikshit Kumbhar on date:20/04/2015 [Added shipper_size, case_length, case_width,size_height, case_gross_weight, case_net_weight, pack_size_dtl,lang fields] Starts 
						valueXmlString.append("<shipper_size>").append("<![CDATA[0.000]]>").append("</shipper_size>\r\n"); 
						valueXmlString.append("<case_length>").append("<![CDATA[0.000]]>").append("</case_length>\r\n"); 
						valueXmlString.append("<case_width>").append("<![CDATA[0.000]]>").append("</case_width>\r\n"); 
						valueXmlString.append("<size_height>").append("<![CDATA[0.000]]>").append("</size_height>\r\n"); 
						valueXmlString.append("<case_gross_weight>").append("<![CDATA[0.000]]>").append("</case_gross_weight>\r\n"); 
						valueXmlString.append("<case_net_weight>").append("<![CDATA[0.000]]>").append("</case_net_weight>\r\n"); 
						//valueXmlString.append("<language>").append("<![CDATA[]]>").append("</language>\r\n");
					    //valueXmlString.append("<language_desc>").append("<![CDATA[]]>").append("</language_desc>\r\n");
                        valueXmlString.append("<pack_size_dtl>").append("<![CDATA[]]>").append("</pack_size_dtl>\r\n"); 
                        valueXmlString.append("<size_type_desc>").append("<![CDATA[]]>").append("</size_type_desc>\r\n"); 
                       // valueXmlString.append("<language_dtl>").append("<![CDATA[]]>").append("</language_dtl>\r\n");
                        valueXmlString.append("<tax>").append("<![CDATA[]]>").append("</tax>\r\n");
                        valueXmlString.append("<tax_desc>").append("<![CDATA[]]>").append("</tax_desc>\r\n");
                        //Changed by wasin on 14-07-2016 to set login site code [START]
                        valueXmlString.append("<site_code>").append("<![CDATA["+checkNullAndTrim(loginSiteCode)+"]]>").append("</site_code>\r\n");
                        //Changed by wasin on 14-07-2016 to set login site code [END]
						valueXmlString.append("<site_descr>").append("<![CDATA[]]>").append("</site_descr>\r\n");
						valueXmlString.append("<supp_code>").append("<![CDATA[]]>").append("</supp_code>\r\n");	
						valueXmlString.append("<supp_descr>").append("<![CDATA[]]>").append("</supp_descr>\r\n");
						//Added by Parikshit Kumbhar on date:20/04/2015 [Added shipper_size, case_length, case_width,size_height, case_gross_weight, case_net_weight, pack_size_dtl,lang fields] Ends
						valueXmlString.append("<date_format>").append("<![CDATA["+ checkNullAndTrim(dateFormat) +"]]>").append("</date_format>\r\n");//Added by parikshit kumbhar on 08/07/2015 [To set date format]
						valueXmlString.append("<tax_chap>").append("<![CDATA[]]>").append("</tax_chap>\r\n");//Added by parikshit kumbhar on 08/07/2015 [To set date format]

						//Changed by Sneha on 26-09-2016, to add new field trade mark [Start]
						valueXmlString.append("<trade_mark>").append("<![CDATA[]]>").append("</trade_mark>\r\n");
						//Changed by Sneha on 26-09-2016, to add new field trade mark [End]
						
						//Changed by Sneha on 24-10-2016, to add new field customer item references  [Start]
						valueXmlString.append("<phy_attrib_4>").append("<![CDATA[]]>").append("</phy_attrib_4>\r\n");
						//Changed by Sneha on 24-10-2016, to add new field customer item references  [End]
						
						valueXmlString.append("<item_commodity>").append("<![CDATA[]]>").append("</item_commodity>\r\n");	//Changed by Sneha on 24-11-2016, to add new field commodity no.
						valueXmlString.append("<date_format><![CDATA["+dateFormat+"]]></date_format>");
						valueXmlString.append(getLanguages(conn));						
					}
					valueXmlString.append("</Detail1>\r\n");
				}
				break;
				case 2 :
				{
					/*System.out.println("DOM in case2 ---->>["+genericUtility.serializeDom(dom).toString()+"]");
					System.out.println("DOM1 in case2 ----->>["+genericUtility.serializeDom(dom1).toString()+"]");
					System.out.println("DOM2 in case2 ----->>["+genericUtility.serializeDom(dom2).toString()+"]");*/
					
					custItemRefVal = getCustItemRefFlagVal();	//Changed by Sneha on 24-10-2016, to add new field customer item references 					
					//System.out.println("custItemRefVal =========>>"+custItemRefVal);
					
					/*barcodeFlagVal = getDefaultBarcodeFlagVal();
					System.out.println("barcodeFlagVal =========>>"+barcodeFlagVal);*/

					String item_parnt 		= genericUtility.getColumnValue("item_parnt", dom1);
					String item_parnt_desc 	= genericUtility.getColumnValue("item_parnt_desc", dom1);
					String item_type 		= genericUtility.getColumnValue("item_type", dom1);
					String item_type_desc 	= genericUtility.getColumnValue("item_type_desc", dom1);
					String item_ser 		= genericUtility.getColumnValue("item_ser", dom1);
					String itemser_descr 	= genericUtility.getColumnValue("itemser_descr", dom1);
					String descr 			= genericUtility.getColumnValue("descr", dom1);
					String grp_code 		= genericUtility.getColumnValue("grp_code", dom1);
					String grp_code_desc 	= genericUtility.getColumnValue("grp_code_desc", dom1);
					String loc_code 		= genericUtility.getColumnValue("loc_code", dom1);
					
					String stk_opt 			= genericUtility.getColumnValue("stk_opt", dom1);
					String site_codes 		= genericUtility.getColumnValue("site_codes", dom1);
					String site_desc 		= genericUtility.getColumnValue("site_desc", dom1);
					String size_codes 		= genericUtility.getColumnValue("size_codes", dom1);
					String size_type 		= genericUtility.getColumnValue("size_type", dom1);
					String dimension_desc 	= genericUtility.getColumnValue("dimension_desc", dom1);
					String dim_code_desc 	= genericUtility.getColumnValue("dim_code_desc", dom1);
					String color_codes 		= genericUtility.getColumnValue("color_codes", dom1);
					String color_code_descr = genericUtility.getColumnValue("color_code_descr", dom1);
					String phy_attr4 		= genericUtility.getColumnValue("phy_attr4", dom1);
					String phy_attr5 		= genericUtility.getColumnValue("phy_attr5", dom1);
					
					String item_category 	= genericUtility.getColumnValue("item_category", dom1);
					String category_descr 	= genericUtility.getColumnValue("category_descr", dom1);
					
					//String price 			= genericUtility.getColumnValue("price", dom1);
					//String curr_code 		= genericUtility.getColumnValue("curr_code", dom1);
					
					String unit 			= genericUtility.getColumnValue("unit", dom1);
					String loc_type 		= genericUtility.getColumnValue("loc_type", dom1);
					String track_shelf_life = genericUtility.getColumnValue("track_shelf_life", dom1);
					String unit_rate 		= genericUtility.getColumnValue("unit_rate", dom1);
					
					String price_list_dtl 	= genericUtility.getColumnValue("price_list_dtl", dom1);
					String item_length 		= genericUtility.getColumnValue("item_length", dom1);
					String item_width 		= genericUtility.getColumnValue("item_width", dom1);
					String item_height 		= genericUtility.getColumnValue("item_height", dom1);
					String item_gross_wt 	= genericUtility.getColumnValue("item_gross_wt", dom1);
					
					String img_path 		= genericUtility.getColumnValue("img_path", dom1);
					String item_sh_descr 	= genericUtility.getColumnValue("item_sh_descr", dom1);
					String long_desc 		= genericUtility.getColumnValue("long_desc", dom1);
					String meta_desc 		= genericUtility.getColumnValue("meta_desc", dom1);
					String meta_keywords 	= genericUtility.getColumnValue("meta_keywords", dom1);
					String meta_title 		= genericUtility.getColumnValue("meta_title", dom1);
					
					String supp_code 		= genericUtility.getColumnValue("supp_code", dom1);
					String supplier_desc 	= genericUtility.getColumnValue("supplier_desc", dom1);
					String supp_item_desc 	= genericUtility.getColumnValue("supp_item_desc", dom1);
					//Added by Chetan Mahajan on date:06/02/2015 [Added purchase lead time,location description ] Start
					String pur_lead_time    = genericUtility.getColumnValue("pur_lead_time", dom1); 
					String location_descr 	= genericUtility.getColumnValue("location_descr", dom1); 
					//Added by Chetan Mahajan on date:06/02/2015 [Added purchase lead time,location description ] End
					//Added by Parikshit Kumbhar on date:16/04/2015 [Added shipper_size, case_length, case_width,size_height, case_gross_weight, case_net_weight, pack_size_dtl,lang fields] Starts 
					String shipper_size 	= genericUtility.getColumnValue("shipper_size", dom1);
					String case_length 	    = genericUtility.getColumnValue("case_length", dom1);
					String case_width 		= genericUtility.getColumnValue("case_width", dom1);
					String size_height 		= genericUtility.getColumnValue("size_height", dom1);
					String case_gross_weight= genericUtility.getColumnValue("case_gross_weight", dom1);
					String case_net_weight 	= genericUtility.getColumnValue("case_net_weight", dom1);
					String pack_size_dtl 	= genericUtility.getColumnValue("pack_size_dtl", dom1);
					String language 		= genericUtility.getColumnValue("language", dom1);
					String language_desc 	= genericUtility.getColumnValue("language_desc", dom1);
					String size_type_desc   = genericUtility.getColumnValue("size_type_desc", dom1);
					String language_dtl     = genericUtility.getColumnValue("language_dtl", dom1);
					String tax              = genericUtility.getColumnValue("tax", dom1);
					String tax_desc         = genericUtility.getColumnValue("tax_desc", dom1);
					//Added by Parikshit Kumbhar on date:20/04/2015 [Added shipper_size, case_length, case_width,size_height, case_gross_weight, case_net_weight, pack_size_dtl,lang fields] Ends
					//Added by Samadhan on 22/12/2015 [To set Limited Edition,brand] Start
					String item_usage_type  = genericUtility.getColumnValue("item_usage_type", dom1);
					String brandCode        = genericUtility.getColumnValue("item_phy_attrib_24", dom1);
					String brandDescr       = genericUtility.getColumnValue("brand_descr", dom1);
					//Added by Samadhan on 22/12/2015 [To set Limited Edition,brand] Start
					
					//Changed by wasim on 27-07-2016 to add tax chapter [START]
					String taxChap       = genericUtility.getColumnValue("tax_chap", dom1);
					//Changed by wasim on 27-07-2016 to add tax chapter [START]
					
					//Changed by Sneha on 26-09-2016, to add new field trade mark [Start]
					String tradeMark = genericUtility.getColumnValue("trade_mark", dom1);
					//Changed by Sneha on 26-09-2016, to add new field trade mark [End]
					
					//Changed by Sneha on 24-10-2016, to add new field customer item references  [Start]
					custItemRef = genericUtility.getColumnValue("phy_attrib_4", dom1);
					//Changed by Sneha on 24-10-2016, to add new field customer item references  [End]
				
					commodityNo = genericUtility.getColumnValue("item_commodity", dom1);	// Changed by Sneha on 24-11-2016 for commodity no 
					
					valueXmlString.append("<Detail2 domID='0' selected = 'N'>\r\n");
					
					if(currentColumn.equalsIgnoreCase("itm_default"))
					{ 
						valueXmlString.append("<item_parnt>").append("<![CDATA["+ checkNullAndTrim(item_parnt) +"]]>").append("</item_parnt>\r\n");
						valueXmlString.append("<item_parnt_desc>").append("<![CDATA["+ checkNullAndTrim(item_parnt_desc) +"]]>").append("</item_parnt_desc>\r\n");	
						valueXmlString.append("<item_type>").append("<![CDATA["+ checkNullAndTrim(item_type) +"]]>").append("</item_type>\r\n");
						valueXmlString.append("<item_type_desc>").append("<![CDATA["+ checkNullAndTrim(item_type_desc) +"]]>").append("</item_type_desc>\r\n");
						valueXmlString.append("<item_ser>").append("<![CDATA["+ checkNullAndTrim(item_ser) +"]]>").append("</item_ser>\r\n");	
						valueXmlString.append("<itemser_descr>").append("<![CDATA["+ checkNullAndTrim(itemser_descr) +"]]>").append("</itemser_descr>\r\n");
						valueXmlString.append("<descr>").append("<![CDATA["+ checkNullAndTrim(descr) +"]]>").append("</descr>\r\n");
						valueXmlString.append("<grp_code>").append("<![CDATA["+ checkNullAndTrim(grp_code) +"]]>").append("</grp_code>\r\n");
						valueXmlString.append("<grp_code_desc>").append("<![CDATA["+ checkNullAndTrim(grp_code_desc) +"]]>").append("</grp_code_desc>\r\n");	
						valueXmlString.append("<loc_code>").append("<![CDATA["+ checkNullAndTrim(loc_code) +"]]>").append("</loc_code>\r\n");
						
						valueXmlString.append("<stk_opt>").append("<![CDATA["+ checkNullAndTrim(stk_opt) +"]]>").append("</stk_opt>\r\n");
						valueXmlString.append("<site_codes>").append("<![CDATA["+ checkNullAndTrim(site_codes) +"]]>").append("</site_codes>\r\n");	
						valueXmlString.append("<site_desc>").append("<![CDATA["+ checkNullAndTrim(site_desc) +"]]>").append("</site_desc>\r\n");
						valueXmlString.append("<dimension_desc>").append("<![CDATA["+ checkNullAndTrim(dimension_desc) +"]]>").append("</dimension_desc>\r\n");
						
						valueXmlString.append("<dim_code_desc>").append("<![CDATA["+ checkNullAndTrim(dim_code_desc) +"]]>").append("</dim_code_desc>\r\n");
						valueXmlString.append("<color_codes>").append("<![CDATA["+ checkNullAndTrim(color_codes) +"]]>").append("</color_codes>\r\n");
						valueXmlString.append("<color_code_descr>").append("<![CDATA["+ checkNullAndTrim(color_code_descr) +"]]>").append("</color_code_descr>\r\n");
						valueXmlString.append("<size_codes>").append("<![CDATA["+ checkNullAndTrim(size_codes) +"]]>").append("</size_codes>\r\n");
						valueXmlString.append("<size_type>").append("<![CDATA["+ checkNullAndTrim(size_type) +"]]>").append("</size_type>\r\n");
						valueXmlString.append("<phy_attr4>").append("<![CDATA["+ checkNullAndTrim(phy_attr4) +"]]>").append("</phy_attr4>\r\n");	
						valueXmlString.append("<phy_attr5>").append("<![CDATA["+ checkNullAndTrim(phy_attr5) +"]]>").append("</phy_attr5>\r\n");
						
						//valueXmlString.append("<price>").append("<![CDATA[]]>").append("</price>\r\n");
						//valueXmlString.append("<curr_code>").append("<![CDATA[]]>").append("</curr_code>\r\n");
						
						valueXmlString.append("<unit>").append("<![CDATA["+ checkNullAndTrim(unit) +"]]>").append("</unit>\r\n");
						valueXmlString.append("<loc_type>").append("<![CDATA["+ checkNullAndTrim(loc_type) +"]]>").append("</loc_type>\r\n");
						valueXmlString.append("<track_shelf_life>").append("<![CDATA["+ checkNullAndTrim(track_shelf_life) +"]]>").append("</track_shelf_life>\r\n");
						valueXmlString.append("<unit_rate>").append("<![CDATA["+ checkNullAndTrim(unit_rate) +"]]>").append("</unit_rate>\r\n");
						
						valueXmlString.append("<price_list_dtl>").append("<![CDATA["+ checkNullAndTrim(price_list_dtl) +"]]>").append("</price_list_dtl>\r\n");
						valueXmlString.append("<item_length>").append("<![CDATA["+ checkNullAndTrim(item_length) +"]]>").append("</item_length>\r\n");	
						valueXmlString.append("<item_width>").append("<![CDATA["+ checkNullAndTrim(item_width) +"]]>").append("</item_width>\r\n");
						valueXmlString.append("<item_height>").append("<![CDATA["+ checkNullAndTrim(item_height) +"]]>").append("</item_height>\r\n");
						valueXmlString.append("<item_gross_wt>").append("<![CDATA["+ checkNullAndTrim(item_gross_wt) +"]]>").append("</item_gross_wt>\r\n");
						
						valueXmlString.append("<supp_code>").append("<![CDATA["+ checkNullAndTrim(supp_code) +"]]>").append("</supp_code>\r\n");
						valueXmlString.append("<supplier_desc>").append("<![CDATA["+ checkNullAndTrim(supplier_desc) +"]]>").append("</supplier_desc>\r\n");
						valueXmlString.append("<supp_item_desc>").append("<![CDATA["+ checkNullAndTrim(supp_item_desc) +"]]>").append("</supp_item_desc>\r\n");
						
						valueXmlString.append("<item_category>").append("<![CDATA["+ checkNullAndTrim(item_category) +"]]>").append("</item_category>\r\n");
						valueXmlString.append("<category_descr>").append("<![CDATA["+ checkNullAndTrim(category_descr) +"]]>").append("</category_descr>\r\n");
						
						valueXmlString.append("<img_path>").append("<![CDATA["+ checkNullAndTrim(img_path) +"]]>").append("</img_path>\r\n");
						valueXmlString.append("<item_sh_descr>").append("<![CDATA["+ checkNullAndTrim(item_sh_descr) +"]]>").append("</item_sh_descr>\r\n");
						valueXmlString.append("<long_desc>").append("<![CDATA["+ checkNullAndTrim(long_desc) +"]]>").append("</long_desc>\r\n");
						valueXmlString.append("<meta_desc>").append("<![CDATA["+ checkNullAndTrim(meta_desc) +"]]>").append("</meta_desc>\r\n");
						valueXmlString.append("<meta_keywords>").append("<![CDATA["+ checkNullAndTrim(meta_keywords) +"]]>").append("</meta_keywords>\r\n");	
						valueXmlString.append("<meta_title>").append("<![CDATA["+ checkNullAndTrim(meta_title) +"]]>").append("</meta_title>\r\n");
						
						valueXmlString.append("<login_code>").append("<![CDATA["+ userId +"]]>").append("</login_code>\r\n");
						valueXmlString.append("<chg_date>").append("<![CDATA["+ currDate +"]]>").append("</chg_date>\r\n");	
						valueXmlString.append("<chg_user>").append("<![CDATA["+ userId +"]]>").append("</chg_user>\r\n");
						valueXmlString.append("<chg_term>").append("<![CDATA["+ chgTerm +"]]>").append("</chg_term>\r\n");
						//Added by Chetan Mahajan on date:06/02/2015 [Added purchase lead time,location description ] Start
						valueXmlString.append("<pur_lead_time>").append("<![CDATA["+ checkNullAndTrim(pur_lead_time)+"]]>").append("</pur_lead_time>\r\n");  /*Added by Chetan Mahajan on date:04/02/2015..*/
						valueXmlString.append("<location_descr>").append("<![CDATA["+ checkNullAndTrim(location_descr) +"]]>").append("</location_descr>\r\n");  /*Added by Chetan Mahajan on date:05/02/2015..*/
						//Added by Chetan Mahajan on date:06/02/2015 [Added purchase lead time,location description ] End
						
						//Added by Parikshit Kumbhar on date:16/04/2015 [Added shipper_size, case_length, case_width,size_height, case_gross_weight, case_net_weight, pack_size_dtl,lang fields] Starts 
						valueXmlString.append("<shipper_size>").append("<![CDATA["+ checkNullAndTrim(shipper_size) +"]]>").append("</shipper_size>\r\n"); 
						valueXmlString.append("<case_length>").append("<![CDATA["+ checkNullAndTrim(case_length) +"]]>").append("</case_length>\r\n"); 
						valueXmlString.append("<case_width>").append("<![CDATA["+ checkNullAndTrim(case_width) +"]]>").append("</case_width>\r\n"); 
						valueXmlString.append("<size_height>").append("<![CDATA["+ checkNullAndTrim(size_height) +"]]>").append("</size_height>\r\n"); 
						valueXmlString.append("<case_gross_weight>").append("<![CDATA["+ checkNullAndTrim(case_gross_weight) +"]]>").append("</case_gross_weight>\r\n"); 
						valueXmlString.append("<case_net_weight>").append("<![CDATA["+ checkNullAndTrim(case_net_weight) +"]]>").append("</case_net_weight>\r\n"); 
						valueXmlString.append("<pack_size_dtl>").append("<![CDATA["+ checkNullAndTrim(pack_size_dtl) +"]]>").append("</pack_size_dtl>\r\n"); 
						valueXmlString.append("<language>").append("<![CDATA["+ checkNullAndTrim(language) +"]]>").append("</language>\r\n");   
						valueXmlString.append("<language_desc>").append("<![CDATA["+ checkNullAndTrim(language_desc) +"]]>").append("</language_desc>\r\n"); 
						valueXmlString.append("<size_type_desc>").append("<![CDATA["+ checkNullAndTrim(size_type_desc) +"]]>").append("</size_type_desc>\r\n");
						valueXmlString.append("<language_dtl>").append("<![CDATA["+ checkNullAndTrim(language_dtl) +"]]>").append("</language_dtl>\r\n"); 
						valueXmlString.append("<tax>").append("<![CDATA["+ checkNullAndTrim(tax) +"]]>").append("</tax>\r\n"); 
						valueXmlString.append("<tax_desc>").append("<![CDATA["+ checkNullAndTrim(tax_desc) +"]]>").append("</tax_desc>\r\n"); 
						//Added by Parikshit Kumbhar on date:16/04/2015 [Added shipper_size, case_length, case_width,size_height, case_gross_weight, case_net_weight, pack_size_dtl,lang fields] Ends 
						valueXmlString.append("<date_format>").append("<![CDATA["+ checkNullAndTrim(dateFormat) +"]]>").append("</date_format>\r\n");//Added by parikshit kumbhar on 08/07/2015 [To set date format]
						//Added by Samadhan on 22/12/2015 [To set Limited Edition,brand] Start
						valueXmlString.append("<item_usage_type>").append("<![CDATA["+ checkNullAndTrim(item_usage_type) +"]]>").append("</item_usage_type>\r\n");
						valueXmlString.append("<item_phy_attrib_24>").append("<![CDATA["+ checkNullAndTrim(brandCode) +"]]>").append("</item_phy_attrib_24>\r\n");
						valueXmlString.append("<brand_descr>").append("<![CDATA["+ checkNullAndTrim(brandDescr) +"]]>").append("</brand_descr>\r\n");
						//Added by Samadhan on 22/12/2015 [To set Limited Edition,brand] End
						//Changed by wasim on 14-07-2016 to set login site code [START]
						valueXmlString.append("<site_code>").append("<![CDATA["+checkNullAndTrim(loginSiteCode)+"]]>").append("</site_code>\r\n");
						//Changed by wasim on 14-07-2016 to set login site code [END]
						
						//Changed by wasim on 27-07-2016 to add tax chapter [START]
						valueXmlString.append("<tax_chap>").append("<![CDATA["+ checkNullAndTrim(taxChap) +"]]>").append("</tax_chap>\r\n");
						//Changed by wasim on 27-07-2016 to add tax chapter [END]
						
						//Changed by Sneha on 26-09-2016, to add new field trade mark [Start]
						valueXmlString.append("<trade_mark>").append("<![CDATA["+ checkNullAndTrim(tradeMark) +"]]>").append("</trade_mark>\r\n");
						//Changed by Sneha on 26-09-2016, to add new field trade mark [End]
						
						//Changed by Sneha on 24-10-2016, to add new field customer item references  [Start]
						valueXmlString.append("<phy_attrib_4>").append("<![CDATA["+ checkNullAndTrim(custItemRef) +"]]>").append("</phy_attrib_4>\r\n");
						//Changed by Sneha on 24-10-2016, to add new field customer item references  [End]
						
						valueXmlString.append("<item_commodity>").append("<![CDATA["+ checkNullAndTrim(commodityNo) +"]]>").append("</item_commodity>\r\n"); // Changed by Sneha on 24-11-2016, to display the value for commodity no
						valueXmlString.append("<date_format><![CDATA["+dateFormat+"]]></date_format>");
					}
					valueXmlString.append("</Detail2>\r\n");
				    
				    String[] size = checkNullAndTrim(size_type_desc).split(",");
				    String[] color = checkNullAndTrim(color_codes).split(",");
					String[] dimension = checkNullAndTrim(dimension_desc).split(",");
					//String[] color1= checkNullAndTrim(color_codes).split(",");
					String[] size1 = checkNullAndTrim(size_type).split(",");
					String[] color1= checkNullAndTrim(color_code_descr).split(",");
					String[] dimension1 = checkNullAndTrim(dim_code_desc).split(",");
					String[] sizeDesc = checkNullAndTrim(size_type_desc).split(",");
					String[] dimensionDesc = checkNullAndTrim(dimension_desc).split(",");
					
					int no = 0;
					
					String itemDesc = "", custItemRefStr = "";
					
					for (int i = 0; i < dimension.length; i++)
					{
						for (int j = 0; j < color.length; j++)
						{
							for (int k = 0; k < size.length; k++)
							{
								no++;
								//Changed by Samadhan on 21/12/2015 for Set Size Descr instede of size id.
								//itemDesc = descr + " " + sizeDesc[k] + " " + color1[j] + " " + dimensionDesc[i];
								
								// Changed by Sneha on 22-06-2016, for Dimension NA in item description [Start]
								//itemDesc = descr + " " + size1[k] + " " + color1[j] + " " + dimensionDesc[i];

								if(dimensionDesc[i].equalsIgnoreCase("NA"))
								{
									//itemDesc = descr + "  " + size1[k] + " " + color1[j];
									itemDesc = descr + " - " + color1[j] + " - " + size1[k];
								}
								else
								{
									//itemDesc = descr + " " + size1[k] + " " + color1[j] + " " + dimensionDesc[i];
									itemDesc = descr + " - " + dimensionDesc[i] + " - " + color1[j] + " - " + size1[k];
								}
								// Changed by Sneha on 22-06-2016, for Dimension NA in item description [End]
								
								custItemRefStr = item_parnt + "-" + color[j] + "-" + size1[k];	//Changed by Sneha on 24-10-2016, to add new field customer item references 
								
								valueXmlString.append("<Detail2 domID='"+ no +"' selected = 'Y'>\r\n");
								
								if(currentColumn.equalsIgnoreCase("itm_default"))
								{
									valueXmlString.append("<item_descr>").append("<![CDATA["+ checkNullAndTrim(itemDesc) +"]]>").append("</item_descr>\r\n");
									valueXmlString.append("<phy_attrib_1>").append("<![CDATA["+ checkNullAndTrim(size[k]) +"]]>").append("</phy_attrib_1>\r\n");	
									valueXmlString.append("<phy_attrib_2>").append("<![CDATA["+ checkNullAndTrim(color[j]) +"]]>").append("</phy_attrib_2>\r\n");
									valueXmlString.append("<phy_attrib_3>").append("<![CDATA["+ checkNullAndTrim(dimension[i]) +"]]>").append("</phy_attrib_3>\r\n");
									
									
									valueXmlString.append("<phy_att1>").append("<![CDATA["+ checkNullAndTrim(size1[k]) +"]]>").append("</phy_att1>\r\n");
									valueXmlString.append("<phy_att2>").append("<![CDATA["+ checkNullAndTrim(color1[j]) +"]]>").append("</phy_att2>\r\n");
									valueXmlString.append("<phy_att3>").append("<![CDATA["+ checkNullAndTrim(dimension1[i]) +"]]>").append("</phy_att3>\r\n");
	
									valueXmlString.append("<item_category>").append("<![CDATA["+ checkNullAndTrim(item_category) +"]]>").append("</item_category>\r\n");
									valueXmlString.append("<category_descr>").append("<![CDATA["+ checkNullAndTrim(category_descr) +"]]>").append("</category_descr>\r\n");
									valueXmlString.append("<item_length>").append("<![CDATA["+ checkNullAndTrim(item_length) +"]]>").append("</item_length>\r\n");	
									valueXmlString.append("<item_width>").append("<![CDATA["+ checkNullAndTrim(item_width) +"]]>").append("</item_width>\r\n");
									valueXmlString.append("<item_height>").append("<![CDATA["+ checkNullAndTrim(item_height) +"]]>").append("</item_height>\r\n");
									valueXmlString.append("<item_gross_wt>").append("<![CDATA["+ checkNullAndTrim(item_gross_wt) +"]]>").append("</item_gross_wt>\r\n");
									//valueXmlString.append("<item_barcode>").append("<![CDATA[]]>").append("</item_barcode>\r\n");
									//Added by Chetan Mahajan on date:06/02/2015 [Added purchase lead time,location description] Start
									valueXmlString.append("<loc_code>").append("<![CDATA["+ checkNullAndTrim(loc_code) +"]]>").append("</loc_code>\r\n");        /*Added by Chetan Mahajan on date:05/02/2015..*/
									valueXmlString.append("<loc_type>").append("<![CDATA["+ checkNullAndTrim(loc_type) +"]]>").append("</loc_type>\r\n");		 /*Added by Chetan Mahajan on date:05/02/2015..*/
									//Added by Chetan Mahajan on date:06/02/2015 [Added purchase lead time,location description] End
									//Added by Parikshit Kumbhar on date 20/04/2015 [Added shipper_size, case_length, case_width,size_height, case_gross_weight, case_net_weight, pack_size_dtl,lang fields] Starts 
									valueXmlString.append("<shipper_size>").append("<![CDATA["+ checkNullAndTrim(shipper_size) +"]]>").append("</shipper_size>\r\n"); 
									valueXmlString.append("<case_length>").append("<![CDATA["+ checkNullAndTrim(case_length) +"]]>").append("</case_length>\r\n"); 
									valueXmlString.append("<case_width>").append("<![CDATA["+ checkNullAndTrim(case_width) +"]]>").append("</case_width>\r\n"); 
									valueXmlString.append("<size_height>").append("<![CDATA["+ checkNullAndTrim(size_height) +"]]>").append("</size_height>\r\n"); 
									valueXmlString.append("<case_gross_weight>").append("<![CDATA["+ checkNullAndTrim(case_gross_weight) +"]]>").append("</case_gross_weight>\r\n"); 
									valueXmlString.append("<case_net_weight>").append("<![CDATA["+ checkNullAndTrim(case_net_weight) +"]]>").append("</case_net_weight>\r\n"); 
									valueXmlString.append("<pack_size_dtl>").append("<![CDATA["+ checkNullAndTrim(pack_size_dtl) +"]]>").append("</pack_size_dtl>\r\n"); 
									valueXmlString.append("<language>").append("<![CDATA["+ checkNullAndTrim(language) +"]]>").append("</language>\r\n"); 
									valueXmlString.append("<language_desc>").append("<![CDATA["+ checkNullAndTrim(language_desc) +"]]>").append("</language_desc>\r\n");
									valueXmlString.append("<size_type_desc>").append("<![CDATA["+ checkNullAndTrim(size_type_desc) +"]]>").append("</size_type_desc>\r\n");
									valueXmlString.append("<language_dtl>").append("<![CDATA["+ checkNullAndTrim(language_dtl) +"]]>").append("</language_dtl>\r\n");
									valueXmlString.append("<tax>").append("<![CDATA["+ checkNullAndTrim(tax) +"]]>").append("</tax>\r\n");
									valueXmlString.append("<tax_desc>").append("<![CDATA["+ checkNullAndTrim(tax_desc) +"]]>").append("</tax_desc>\r\n");
									valueXmlString.append("<item_commodity>").append("<![CDATA["+ checkNullAndTrim(commodityNo) +"]]>").append("</item_commodity>\r\n");
									//Added by Parikshit Kumbhar on date 20/04/2015 [Added shipper_size, case_length, case_width,size_height, case_gross_weight, case_net_weight, pack_size_dtl,lang  fields] Ends
									
									valueXmlString.append("<price_list_dtl>").append("<![CDATA["+ checkNullAndTrim(price_list_dtl) +"]]>").append("</price_list_dtl>\r\n");
									valueXmlString.append("<supp_item_desc>").append("<![CDATA["+ checkNullAndTrim(supp_item_desc) +"]]>").append("</supp_item_desc>\r\n");
									//Changed by wasim on 14-07-2016 to set login site code [START]
									valueXmlString.append("<site_code>").append("<![CDATA["+ checkNullAndTrim(loginSiteCode) +"]]>").append("</site_code>\r\n");
									//Changed by wasim on 14-07-2016 to set login site code [END]
									
									//Changed by wasim on 27-07-2016 to add tax chapter [START]
									valueXmlString.append("<tax_chap>").append("<![CDATA["+ checkNullAndTrim(taxChap) +"]]>").append("</tax_chap>\r\n");
									//Changed by wasim on 27-07-2016 to add tax chapter [END]
									
									//Changed by Sneha on 26-09-2019, to add new field trade mark [Start]
									valueXmlString.append("<trade_mark>").append("<![CDATA["+ checkNullAndTrim(tradeMark) +"]]>").append("</trade_mark>\r\n");
									//Changed by Sneha on 26-09-2019, to add new field trade mark [End]
									
									//Changed by Sneha on 24-10-2016, to add new field customer item references [Start]
									if(custItemRefVal.equalsIgnoreCase("Y"))
									{
										valueXmlString.append("<phy_attrib_4>").append("<![CDATA["+ checkNullAndTrim(custItemRefStr) +"]]>").append("</phy_attrib_4>\r\n");
										
									}
									else if(custItemRefVal.equalsIgnoreCase("N"))
									{
										valueXmlString.append("<phy_attrib_4>").append("<![CDATA[]]>").append("</phy_attrib_4>\r\n");
									}
									//Changed by Sneha on 24-10-2016, to add new field customer item references [End]	
									
									valueXmlString.append("<item_barcode>").append("<![CDATA[]]>").append("</item_barcode>\r\n");
									
								}
								
								valueXmlString.append("</Detail2>\r\n");
							}
						}
					}
				}
				break;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//connDriver = null;
				if(conn != null)
				{
					if(rs != null)
						rs.close();
					if(pstmt != null)
						pstmt.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}			
		}

		valueXmlString.append("</Root>");
		System.out.println("valueXmlString ::"+valueXmlString.toString());

		return valueXmlString.toString();
	}
	
	public String getLanguages(Connection conn) 
	{
		StringBuffer valueXmlString = new StringBuffer();
		try
		{
		String languageDtl = "";
		String langCode ="";
		String langDesc ="";

		PreparedStatement pstmt1 = null ; 
		ResultSet rs1 = null;
		String sqlLanguage = "SELECT FLD_VALUE, TRIM(Descr) FROM GENCODES WHERE FLD_NAME='LANGUAGE' AND FLD_VALUE <>'EN' ";
		pstmt1 = conn.prepareStatement(sqlLanguage);
		rs1 = pstmt1.executeQuery();		
		while(rs1.next())
		{
			langCode += rs1.getString(1) + ", ";
			langDesc += rs1.getString(2) + ", " ;
			languageDtl += "||" + rs1.getString(1) + ":null:null:null:null";
		}
		languageDtl = languageDtl.substring(2, languageDtl.length());
		langCode = langCode.trim().substring(0, langCode.length()-2);
		langDesc = langDesc.trim().substring(0, langDesc.length()-2);
		
		valueXmlString.append("<language>").append("<![CDATA["+ langDesc +"]]>").append("</language>\r\n");
		valueXmlString.append("<language_desc>").append("<![CDATA["+ langCode +"]]>").append("</language_desc>\r\n");
		valueXmlString.append("<language_dtl>").append("<![CDATA["+ languageDtl +"]]>").append("</language_dtl>\r\n");
		
		rs1.close(); rs1 = null;
		pstmt1.close(); pstmt1 = null;
		}
		catch (SQLException ex)
		{
			// TODO Auto-generated catch block
			ex.printStackTrace();
		}
		return valueXmlString.toString();
	}

	/**
	 * select error description from MESSAGES
	 * @param conn
	 * @param errorCode
	 * @return
	 */
	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	
	@Override
	public String getList(String loginCode, String field, String[] values)	 throws RemoteException, ITMException 
	{
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer("<?xml version = \"1.0\" encoding = \"UTF-8\"?> \r\n <Root>\r\n");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		//GenericUtility genericUtility = GenericUtility.getInstance();

		try 
		{
			System.out.println("Inside getList---->loginCode["+loginCode+"]FIeld["+field+"]Values["+values+"]");//Changed by wasim on 14-07-2016 to print parameter values

			//Changed and Commented By Santosh on 14-06-2016 :[START]
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");*/
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			if (field.equals("item_parnt"))
			{
				sql = " SELECT ITEM_CODE, DESCR FROM ITEM WHERE ITEM_PARNT IS NULL";
			}
			// Added By Parikshit Kumbhar changed item_type & item_ser pophelp from respective table on 29/05/15 Start
			else if (field.equals("item_code"))
			{
				sql = " select item_code, DESCR from item where item_parnt is null ";
			}
			else if (field.equals("item_type"))
			{
				sql = "SELECT ITEM_TYPE,DESCR FROM ITEM_TYPE ORDER BY ITEM_TYPE";
			}
			else if (field.equals("item_ser"))
			{
				sql = "SELECT ITEM_SER, DESCR FROM ITEMSER WHERE BUSINESS_TYPE = 'T' ORDER BY ITEM_SER";
			}
			// Added By Parikshit Kumbhar changed item_type & item_ser pophelp from respective table on 29/05/15 End

			else if (field.equals("grp_code"))
			{
				sql = "SELECT FLD_VALUE, DESCR FROM GENCODES WHERE FLD_NAME = 'GRP_CODE' AND MOD_NAME = 'W_DD_PRODUCTWIZ' ORDER BY FLD_VALUE";
			}
			// Added by Parikshit Kumbhar on 07/05/2015 [to change pophelp of color, size, dimension & language field] Start
			else if (field.equals("site_codes"))
			{
				/*sql = " SELECT TRIM(site.SITE_CODE), TRIM(site.DESCR), TRIM(gencds.DESCR) || ':' || TRIM(fint.curr_code) " +
					  " FROM FINENT fint INNER JOIN SITE site ON site.FIN_ENTITY = fint.FIN_ENTITY " +
					  " LEFT OUTER JOIN GENCODES gencds ON TRIM(site.SITE_CODE) = TRIM(gencds.FLD_VALUE) " +
					  " AND gencds.fld_name='SITE_PRICE' AND gencds.mod_name='W_DD_PRODUCTWIZ' ORDER BY site.SITE_CODE ";*/
		    // Updated Query by Parikshit Kumbhar on 27/06/2015 [D15CKAT031] Start  
				sql = " SELECT TRIM(site.SITE_CODE), TRIM(site.DESCR), TRIM(gencds.DESCR) || ':' || TRIM(gencds.UDF_STR1)" +
			   		 " FROM SITE site LEFT OUTER JOIN GENCODES gencds ON TRIM(site.SITE_CODE) = TRIM(gencds.FLD_VALUE) " +
			   		 " AND gencds.fld_name='SITE_PRICE' AND gencds.mod_name='W_DD_PRODUCTWIZ' ORDER BY site.SITE_CODE ";
        	// Updated Query by Parikshit Kumbhar on 27/06/2015 [D15CKAT031] End
			}
			else if (field.equals("dimension_desc"))
			{
				sql = "SELECT Attrib_Id, TRIM(Descr) FROM itm_attrib_val WHERE Attrib_Code ='DIMENSION' ORDER BY sort_order";
			}			
			else if (field.equals("color_codes"))
			{
				sql = "SELECT Attrib_Id, TRIM(Descr) FROM itm_attrib_val WHERE Attrib_Code='COLOR' ORDER BY sort_order";
			}
			else if (field.equals("size_codes"))
			{
				//sql = "SELECT Attrib_Id, TRIM(Descr) FROM itm_attrib_val WHERE Attrib_Code='SIZE_TYPE' ORDER BY sort_order;"
				//Added by parikshit on 28/07/15 [commented above query & added new query] start
				sql = " SELECT itmAttVal.ATTRIB_ID, itmAtt.DESCR FROM ITEM_ATTRIBUTE itmAtt,ITM_ATTRIB_VAL itmAttVal " +
					  " WHERE itmAttVal.Attrib_Code= 'SIZE_TYPE' and itmAttVal.ATTRIB_ID=itmAtt.ATTRIB_CODE ORDER BY itmAttVal.sort_order ";
				//Added by parikshit on 28/07/15 [commented above query & added new query] end
			}
			else if (field.equals("language_desc"))
			{
				sql = "SELECT FLD_VALUE, TRIM(Descr) FROM GENCODES WHERE FLD_NAME='LANGUAGE' ORDER BY FLD_VALUE";
			}
			else if (field.equals("tax"))
			{
				sql = "SELECT Attrib_Id, TRIM(Descr) FROM itm_attrib_val WHERE Attrib_Code='Tax' ORDER BY sort_order";
			}
			// Added by Parikshit Kumbhar on 07/05/2015 [to change pophelp of color, size, dimension & language field] End
			else if (field.equals("item_category"))
			{
				sql = "SELECT Attrib_Id, TRIM(Descr) FROM itm_attrib_val WHERE Attrib_Code='CATEGORY' ORDER BY sort_order";
			}
			else if (field.equals("pricelist"))
			{
				sql = "SELECT PRICE_LIST, DESCR FROM PRICELIST_MST ORDER BY PRICE_LIST";
			}
			else if (field.equals("supplier_code"))
			{
				sql = "SELECT SUPP_CODE, TRIM(SUPP_NAME), PRICE_LIST|| ':'||TRIM(curr_code) FROM SUPPLIER ORDER BY SUPP_CODE"; // Changed by Parikshit Kumbhar on 11/06/15 added curr_code
			}
			//Added by Chetan Mahajan on date:06/02/2015 [Added loc_code] Start
			else if (field.equals("loc_code"))
			{
				//Changed by wasim on 11-03-2016 to get only empty location 
				//sql = "SELECT LOC_CODE, DESCR,loc_type FROM location ORDER BY LOC_CODE";
				sql = " SELECT A.LOC_CODE, A.DESCR, A.LOC_TYPE FROM LOCATION A ,INVSTAT B ,SITE S WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
	                    + " AND A.LOC_TYPE = 'N' AND S.SITE_CODE = ? AND (S.FACILITY_CODE = A.FACILITY_CODE or nvl(s.facility_code ,'N') = 'N') "
	                    + " AND A.INV_STAT IN ('ACTPK', 'CASPK') AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' and "
	                    + " nvl((SELECT sum(quantity) FROM STOCK WHERE  SITE_CODE = ? AND  stock.loc_code = a.loc_code),0) = 0 AND ROWNUM < 50 "
	                    + " ORDER BY A.LOC_CODE ";
			}
			//Added by Chetan Mahajan on date:06/02/2015 [Added loc_code] End
			//Changed by Samadhan on 22/12/2015 for Brand Start
			else if (field.equals("item_phy_attrib_24"))
			{
				sql = "SELECT Attrib_Id, TRIM(Descr) FROM itm_attrib_val WHERE Attrib_Code='BRAND' ORDER BY sort_order";
			}
			else if (field.equals("phy_attrib_24"))
			{
				sql = "SELECT Attrib_Id, TRIM(Descr) FROM itm_attrib_val WHERE Attrib_Code='BRAND' ORDER BY sort_order";
			}
			//Changed by Samadhan on 22/12/2015 for Brand End
			
			// Changed by Sneha on 01-04-2016, for Size Availability [Start]
			else if(field.equals("size_code_descr"))
			{				
				String phyAttrib22 = "";
				sql = "SELECT PHY_ATTRIB_22 FROM ITEM WHERE ITEM_CODE='"+values[0]+"' ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					phyAttrib22 = rs.getString("PHY_ATTRIB_22");
				}
				if (rs != null) 
				{					
					rs.close();
					rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();
					pstmt = null;
				}
				
				sql = "SELECT ATTRIB_ID, TRIM(DESCR),TRIM(SH_DESCR) FROM ITM_ATTRIB_VAL WHERE ATTRIB_CODE='"+phyAttrib22+"' ORDER BY SORT_ORDER ";
				values[0] = "";
				values[1] = "";

			}
			// Changed by Sneha on 01-04-2016, for Size Availability [End] 
			
			// Changed by Sneha on 14-10-2016, for Purchase tax pophelp [Start] 
			//Changed by wasim on 02-08-2016 for tax chapter pop help [START]
			else if(field.equals("tax_chap"))
			{
				String purchaseTaxList = checkNullAndTrim(discommon.getDisparams("999999", "PURCHASE_TAX_LIST", conn));
				//System.out.println("purchaseTaxList ============>>["+purchaseTaxList+"]");

				if("NULLFOUND".equalsIgnoreCase(purchaseTaxList) || "".equalsIgnoreCase(purchaseTaxList) || purchaseTaxList.length() == 0 || purchaseTaxList.equalsIgnoreCase(null))
				{
					sql = "SELECT TAX_CHAP,DESCR FROM TAXCHAP";
				}
				else
				{
					purchaseTaxList = purchaseTaxList.replace(",","','");
					sql = "SELECT TAX_CHAP,DESCR FROM TAXCHAP WHERE TAX_CHAP IN ('"+purchaseTaxList+"')";
				}
			}
			//Changed by wasim on 02-08-2016 for tax chapter pop help [END]
			// Changed by Sneha on 14-10-2016, for Purchase tax pophelp [End] 
			
			//Changed by Sneha on 17-10-2016, for trade mark pophelp [Start] 
			else if(field.equals("trade_mark"))
			{
				
				sql = "SELECT FLD_VALUE, TRIM(Descr) FROM GENCODES WHERE FLD_NAME = 'TRADE_MARK' ORDER BY FLD_VALUE ";
			}
			
			//Changed by Sneha on 17-10-2016, for trade mark pophelp [End] 
			
			// Changed by Sneha on 03-11-2016, for size code and color code pophelp [Start]
			else if(field.equals("size_code_edit"))
			{				
				/*sql = "SELECT PHY_ATTRIB_1, PHY_ATTRIB_6 AS SIZES, FROM ITEM WHERE " +
						"ITEM_CODE IN (SELECT ITEM_CODE FROM ITEM WHERE ITEM_PARNT = '"+values[0]+"' ) ORDER BY PHY_ATTRIB_6 ";*/
				
				sql = " SELECT DISTINCT PHY_ATTRIB_1, PHY_ATTRIB_6 AS SIZES, A.DESCR FROM ITEM I, ITM_ATTRIB_VAL A WHERE " 
					+ " ITEM_CODE IN (SELECT ITEM_CODE FROM ITEM WHERE ITEM_PARNT = '"+values[0]+"' ) AND PHY_ATTRIB_1 = ATTRIB_ID " 
					+ " AND ATTRIB_CODE=PHY_ATTRIB_22 ORDER BY PHY_ATTRIB_6";
				//values[0] = values[1];
				values[0] = "";
			}
			else if(field.equals("color_code_edit"))
			{				
				sql = "SELECT DISTINCT PHY_ATTRIB_2, A.DESCR FROM ITEM I, ITM_ATTRIB_VAL A WHERE " +
					"I.ITEM_CODE IN (SELECT ITEM_CODE FROM ITEM WHERE ITEM_PARNT = '"+values[0]+"' ) AND A.ATTRIB_CODE='COLOR' " +
					"AND I.PHY_ATTRIB_2 = A.ATTRIB_ID ORDER BY PHY_ATTRIB_2 ";
				//values[0] = values[1];
				values[0] = "";
			}
			
			// Changed by Sneha on 03-11-2016, for size code and color code pophelp [End] 
			
			pstmt = conn.prepareStatement(sql);
			//Changed by wasim on 14-07-2016 to set site code in loc_code query [START]
			if ("loc_code".equalsIgnoreCase(field.trim()))
			{
				pstmt.setString(1,loginCode);
				pstmt.setString(2,loginCode);
			}
			//Changed by wasim on 14-07-2016 to set site code in loc_code query [END]
			rs = pstmt.executeQuery();
			
			int num = 1;
			while (rs.next())
			{
				String fieldId = checkNullAndTrim(rs.getString(1));
				String fieldValue = checkNullAndTrim(rs.getString(2));
				String otherField = "";
				
				if (field.equals("site_codes") || field.equals("supplier_code") || field.equals("loc_code") || field.equals("size_code_edit"))
				{
					otherField = checkNullAndTrim(rs.getString(3));
				}
				
				/*if (field.equals("item_category"))
				{
					valueXmlString.append("<PROD_TYPE domID='" + num + "' selected = '" + useLoop(values, fieldValue) + "'>\r\n");
				}
				else
				{
					valueXmlString.append("<PROD_TYPE domID='" + num + "' selected = '" + useLoop(values, fieldId) + "'>\r\n");
				}*/
				
				valueXmlString.append("<PROD_TYPE domID='" + num + "' selected = '" + useLoop(values, fieldId) + "'>\r\n");
				
				valueXmlString.append("<fieldId><![CDATA[").append(fieldId).append("]]></fieldId>\r\n");
				valueXmlString.append("<fieldValue><![CDATA[").append(fieldValue).append("]]></fieldValue>\r\n");
				valueXmlString.append("<otherField><![CDATA[").append(otherField).append("]]></otherField>\r\n");
				valueXmlString.append("</PROD_TYPE>\r\n");
				num++;
			}
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception :ITMWizardStatefulEJB :getList(String):"	+ e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		} 
		finally 
		{
			try 
			{
				if (rs != null) 
				{					
					rs.close();
					rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();
					pstmt = null;
				}
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :ITMWizardStatefulEJB :getProdTypeList(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString.toString()	+ ":********");
		
		return valueXmlString.toString();
	}
	
	//Changed by Sneha on 24-10-2016, for field customer item references, disparm value  [Start]
	public String getCustItemRefFlagVal() throws RemoteException, ITMException 
	{
		Connection conn = null;
		String custItemRefVal = "";
		
		try 
		{
			conn = getConnection();
			custItemRefVal = checkNullAndTrim(discommon.getDisparams("999999", "CUST_ITEM_REF", conn));
			
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception : getCustItemRefFlagVal():"	+ e.getMessage() + ":");
		}
		finally 
		{
			try 
			{
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :getCustItemRefFlagVal(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Return Value for disparm for CUST_ITEM_REF =========>>"+custItemRefVal);
		return custItemRefVal;
	}
	//Changed by Sneha on 24-10-2016, for field customer item references, disparm value  [End]
	
	
	// Changed by Sneha on 23-11-2016, to default values flag [Start]
	public String defaultValueFlag() throws RemoteException, ITMException 
	{
		Connection conn = null;
		String val = "";
		
		try 
		{
			conn = getConnection();
			val = checkNullAndTrim(discommon.getDisparams("999999", "PRODUCT_DEFAULT_VALUES", conn));			
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception : getDefaultValuesFlagVal():"	+ e.getMessage() + ":");
		}
		finally 
		{
			try 
			{
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :defaultValueFlag(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Return Value for disparm for PRODUCT_DEFAULT_VALUES =========>>"+val);
		return val;
	}
	
	public JSONObject getDefaultValuesfromJSON() throws RemoteException, ITMException 
	{
		JSONArray jsonArray = new JSONArray();
		JSONObject jsonObject = new JSONObject();
		JSONParser jsonParser = new JSONParser();
        int count = 1;

		String jsonFileName = "";
        try 
        { 
        	System.out.println("CommonConstants.APPLICATION_CONTEXT-->>["+CommonConstants.APPLICATION_CONTEXT+"]");   
    		System.out.println("CommonConstants.JBOSSHOME-->>["+CommonConstants.JBOSSHOME+"]");   
    		if(CommonConstants.APPLICATION_CONTEXT != null)
    		{
    			jsonFileName = CommonConstants.APPLICATION_CONTEXT + "setting" + File.separator + "productWizDefault.json";
    		}
    		else
    		{
    			jsonFileName = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator +"setting" + File.separator +"productWizDefault.json";
    		}
    		System.out.print("jsonFileName path ========>>"+jsonFileName);
    		
        	jsonArray = (JSONArray) jsonParser.parse(new FileReader(jsonFileName));
            //System.out.print("jsonArray---->>"+jsonArray);

            for (Object obj : jsonArray)
            {
                JSONObject tempJson = (JSONObject) obj;
                //System.out.print("tempJson JSONObject ---->> " + tempJson);

                jsonObject.put(count, tempJson);
				count++;
           }
        } 
	    catch (FileNotFoundException e)
	    {
	    	e.printStackTrace();
	    }
        catch (IOException e) 
        {
        	e.printStackTrace();
        }
        catch (ParseException e) 
        {
        	e.printStackTrace();
        }
        catch (Exception e) 
        {
        	e.printStackTrace();
        	System.out.println("Exception : getDefaultValuesfromJSON():"	+ e.getMessage() + ":");
		}        
		System.out.println("Return Value for getDefaultValuesfromJSON =========>>"+jsonObject);
		return jsonObject;
	}

	public String getDefaultBarcodeFlagVal() throws RemoteException, ITMException 
	{
		Connection conn = null;
		String returnVal = "";
		
		try 
		{
			conn = getConnection();
			returnVal = checkNullAndTrim(discommon.getDisparams("999999", "PRODWIZ_AUTOBARCODE", conn));			
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception : getDefaultBarcodeFlagVal():"	+ e.getMessage() + ":");
		}
		finally 
		{
			try 
			{
				if (conn != null && !conn.isClosed()) 
				{					
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :getDefaultBarcodeFlagVal(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("Return Value for disparm for PRODWIZ_AUTOBARCODE =========>>"+returnVal);
		return returnVal;
	}
	
	public String generateTranId( String windowName, String siteCode, Connection conn )throws ITMException
	{
		System.out.println("windowName inside generateTranId =========>>"+windowName);
		System.out.println("siteCode inside generateTranId =========>>"+siteCode);
		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";
		String paySiteCode = "";
		String effectiveDate = "";
		java.sql.Timestamp currDate = null;
		java.sql.Date effDate = null;
		E12GenericUtility genericUtility = new E12GenericUtility();

		try
		{
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());

			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			String currDateStr = sdfAppl.format(currDate);

			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";

			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +        "<tran_id></tran_id>";
			xmlValues = xmlValues +        "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +        "<tran_date>" + currDateStr + "</tran_date>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);
		}
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e){}
		}
		return checkNullAndTrim(tranId);
	}
	
	// Changed by Sneha on 23-11-2016, to default values flag  [End]

	

	/**
	 * 
	 * @param input
	 * @return
	 */
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	/**
	 * 
	 * @param arr
	 * @param targetValue
	 * @return
	 */
	public static String useLoop(String[] arr, String targetValue)
	{
		for(String s: arr)
		{
			String str = checkNullAndTrim(s);
			if(str.equals(targetValue))
				return "Y";
		}
		
		return "N";
	}

}
