<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>

<script type="text/javascript" src="/ibase/webitm/js/MRPWizard.js"></script>

<script language="JavaScript" type="text/javascript">
<![CDATA[
    var maxId = 0;
    
    function resetOrderOfVisit(obj)
    {
	for(cnt=1;cnt <=maxId;cnt++)
	{
		var selBoxID ="Detail2."+cnt+"."+ "selectbox";
		var visitOrderID ="Detail2."+cnt+"."+ "order_of_visit";
		if ( document.getElementById(selBoxID) != null && document.getElementById(selBoxID).value=='true' )
		{
			document.getElementById(selBoxID).value = false;
			document.getElementById(selBoxID).checked = false;
			
			if(document.getElementById(visitOrderID) != null)
			{
			      document.getElementById(visitOrderID).value = "";
			}
		}
		
	}
	orderVisit = 0;
    }
]]>

</script>
<body>


<style type="text/css">

.tableClass
{margin-left:10px;margin-top:10px}

.tableClass_rep
{margin-left:0px}

.header_td
{border:inset 0;background:#FFCCCC;font-family:verdana;font-size:9pt}

.reset
{border:inset 1;font-family:verdana;font-size:9pt; font-weight:bold}

.input_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

.input_num_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

.td_leftAlign
{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

.td_leftAlign2
{text-align:left;font-family:verdana;font-size:9pt}
.hide
{display:none }
					
</style>

<form name = "Wizard_Travel" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet" onSubmit="javascript:return validatePlace('2');">
	<table id="travelTable" width="90%" class="tableClass" border="0" cellspacing="1" cellpadding="1">
		<xsl:for-each select="//Detail2">
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			<SCRIPT>
				<![CDATA[ 
				var detCnt ;  
				detCnt ="]]><xsl:value-of select="$dbID"/><![CDATA[";
					maxId= detCnt; 												
				]]>
			</SCRIPT>
		</xsl:for-each>
		<tr>
			<td width="1%" class="header_td" nowrap="true" valign="bottom">
			<input  type="checkbox"  name="Detail2.selectAllbox" id="Detail2.selectAllbox" onClick="selectAllbox()"/>
			</td>		
			<td width="10%" class="header_td" nowrap="true" valign="bottom">
				<strong>Order Number</strong>
			</td>
			<td width="3%" class="header_td" nowrap="true" valign="bottom">
				<strong>Line No</strong>
			</td>
			  
			<td width="5%" class="header_td" nowrap="true" valign="bottom">
				<strong>Location Group</strong>
			</td>
			
			<td width="5%" class="header_td" nowrap="true" valign="bottom">
				<strong>Site Code</strong>
			</td>
			<td width="10%" class="header_td" nowrap="true" valign="bottom">
				<strong>Item Code</strong>
			</td>
			<td width="30%" class="header_td" nowrap="true" valign="bottom">
				<strong>Item Description</strong>
			</td>	
			
			<td width="30%" class="header_td" nowrap="true" valign="bottom">
				<strong>Mfg Type</strong>
			</td>
			
			<td width="10%" class="header_td" nowrap="true" valign="bottom">
				<strong>Cust Code</strong>
			</td>
			<td width="30%" class="header_td" nowrap="true" valign="bottom">
				<strong>Cust Name</strong>
			</td>	
			<td width="10%" class="header_td" nowrap="true" valign="bottom">
				<strong>Quantity</strong>
			</td>
			<td width="10%" class="header_td" nowrap="true" valign="bottom">
				<strong>Unit</strong>
			</td>	
			<td width="10%" class="header_td" nowrap="true" valign="bottom">
				<strong>Type</strong>
			</td>
			<td width="5%" class="header_td" nowrap="true" valign="bottom">
				<strong>Due Date</strong>
			</td>	
			<td width="5%" class="header_td" nowrap="true" valign="bottom">
				<strong>Order Date</strong>
			</td>	
		</tr>
		
		<xsl:for-each select="//Detail2">
		<xsl:variable name="sale_order"><xsl:value-of select="sale_order"/></xsl:variable>
		<xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
		<xsl:variable name="item_code"><xsl:value-of select="item_code"/></xsl:variable>
		<xsl:variable name="site_code"><xsl:value-of select="site_code"/></xsl:variable>
		<xsl:variable name="item_code_descr"><xsl:value-of select="item_code_descr"/></xsl:variable>   
		<xsl:variable name="cust_code"><xsl:value-of select="cust_code"/></xsl:variable>
		<xsl:variable name="cust_name"><xsl:value-of select="cust_name"/></xsl:variable>  
		<xsl:variable name="quantity"><xsl:value-of select="quantity"/></xsl:variable>
		<xsl:variable name="unit"><xsl:value-of select="unit"/></xsl:variable>     
		<xsl:variable name="order_type"><xsl:value-of select="order_type"/></xsl:variable> 
		<xsl:variable name="due_date"><xsl:value-of select="due_date"/></xsl:variable>
		<xsl:variable name="order_date"><xsl:value-of select="order_date"/></xsl:variable>
		
			<xsl:variable name="loc_group"><xsl:value-of select="loc_group"/></xsl:variable>
			<xsl:variable name="mfg_type"><xsl:value-of select="mfg_type"/></xsl:variable>
		
		     <xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
		     <xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>
		     <tr>
			
			<td class="td_leftAlign">
			        <xsl:choose>
				<xsl:when test="$chkbox ='Y'">
					<script>
						<![CDATA[ orderVisit = parseInt("]]> <xsl:value-of select="order_of_visit"/><![CDATA[");]]>
					</script>
					<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" checked = 'Y' value="true" onClick="setCheckedPlace(this, '{normalize-space($dbID)}' )"/>
				</xsl:when>	
				<xsl:otherwise>
					<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" value="false" onClick="setCheckedPlace(this, '{normalize-space($dbID)}' ),deselectbox()"/>
				</xsl:otherwise>
				</xsl:choose>
			</td>

            <td class="td_leftAlign"  align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.sale_order" id="Detail2.{normalize-space($dbID)}.sale_order" value="{$sale_order}" size="10" ISCHANGED="false"/>
				<xsl:value-of select="sale_order"/>
			</td>

			<td class="td_leftAlign"  align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.line_no" id="Detail2.{normalize-space($dbID)}.line_no" value="{$line_no}" size="03" ISCHANGED="false"/>
				<xsl:value-of select="line_no"/>
			</td>

			<td class="td_leftAlign"  align="left">
				<input  type="text"  class="input_editable" name="Detail2.{normalize-space($dbID)}.loc_group" id="Detail2.{normalize-space($dbID)}.loc_group" value="" size="10" />
			</td>
			
			<td class="td_leftAlign"  align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.site_code" id="Detail2.{normalize-space($dbID)}.site_code" value="{$site_code}" size="05" ISCHANGED="false"/>
				<xsl:value-of select="site_code"/>
			</td>
			
			<td class="td_leftAlign"  align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.item_code" id="Detail2.{normalize-space($dbID)}.item_code" value="{$item_code}" size="10" ISCHANGED="false"/>
				<xsl:value-of select="item_code"/>  
			</td>

			<td class="td_leftAlign"  align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.item_code_descr" id="Detail2.{normalize-space($dbID)}.item_code_descr" value="{$item_code_descr}" size="20" ISCHANGED="false"/>
				<xsl:value-of select="item_code_descr"/>
			</td>
			
			<td class="td_leftAlign"  align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.mfg_type" id="Detail2.{normalize-space($dbID)}.mfg_type" value="{$mfg_type}" size="20" ISCHANGED="false"/>
				<xsl:value-of select="mfg_type"/>
			</td>
			
			<td class="td_leftAlign"  align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.cust_code" id="Detail2.{normalize-space($dbID)}.cust_code" value="{$cust_code}" size="10" ISCHANGED="false"/>
				<xsl:value-of select="cust_code"/>
			</td>
			<td class="td_leftAlign"  align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.cust_name" id="Detail2.{normalize-space($dbID)}.cust_name" value="{$cust_name}" size="20" ISCHANGED="false"/>
				<xsl:value-of select="cust_name"/>
			</td>
			<td class="td_leftAlign"  align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.quantity" id="Detail2.{normalize-space($dbID)}.quantity" value="{$quantity}" size="10" ISCHANGED="false"/>
				<xsl:value-of select="quantity"/>
			</td>
			<td class="td_leftAlign"  align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.unit" id="Detail2.{normalize-space($dbID)}.unit" value="{$unit}" size="10" ISCHANGED="false"/>
				<xsl:value-of select="unit"/>
			</td>
			<td class="td_leftAlign"  align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.order_type" id="Detail2.{normalize-space($dbID)}.order_type" value="{$order_type}" size="10" ISCHANGED="false"/>
				<xsl:value-of select="order_type"/>
			</td>
			<td class="td_leftAlign"  align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.due_date" id="Detail2.{normalize-space($dbID)}.due_date" value="{$due_date}" size="10" ISCHANGED="false"/>
				<xsl:value-of select="due_date"/>
			</td>
			<td class="td_leftAlign"  align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.order_date" id="Detail2.{normalize-space($dbID)}.order_date" value="{$order_date}" size="10" ISCHANGED="false"/>
				<xsl:value-of select="order_date"/>
			</td>
		    </tr>
		    
        </xsl:for-each>
	</table>
	<div id="repeatPlacesDiv" style="margin-left:10px"></div>
	<table>
		<tr>
		    <td>
			<input  type="hidden"  value="2" name="FORM_NO" ID="FORM_NO" />
			<input  type="hidden"  value="mrp_run_wiz" name="OBJ_NAME" />
			<input  type="hidden"  value="" name="action" id="action" />

			<input type="submit" style="cursor:hand" value="Cancel" id="Cancel" name="Cancel" title='' onclick="javascript:setActionVal('previous')"/>
			
			<input type="submit" style="cursor:hand" value="Next" id="Next" name="Next" title=''  
			  onclick="javascript:setActionVal('next')"/>
			
		    </td>
                </tr>
	</table>
	<table id="errorTravelTable" width="85%" class="tableClass" border="0" cellspacing="1" cellpadding="1">
	<xsl:for-each select="//error">
			<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
			<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
			<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
			<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
			<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
			<xsl:if test="position() = 1">
					<tr>	
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Message :
						</td>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Description :
						</td>
					</tr>
			</xsl:if>
			<tr>
				<td class="td_leftAlign" nowrap="true">
					<xsl:value-of select="message"/>
				</td>
				<td class="td_leftAlign" nowrap="true">
					<xsl:value-of select="description"/>
				</td>
			</tr>
	</xsl:for-each>
	<xsl:for-each select="//error">
			<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
			<xsl:if test="position() = 1">
				<xsl:if test="$type = 'W'">
				<tr>
					<td class="td_leftAlign" nowrap="true" valign="bottom">
						Override Warnings :
					</td>
					<td class="td_leftAlign" nowrap="true" valign="bottom">
						<input  type="checkbox"  name="forceSave"  value="false" onClick="javascript:setChecked(this)"/>
					</td>
				</tr>
				</xsl:if>
			</xsl:if>	
	</xsl:for-each>
	</table>
						
</form>
</body>

</html>
</xsl:template>
</xsl:stylesheet>
