<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<body>
<style type="text/css">

.tableClass
{margin-left:0px;margin-top:0px}

.header_td
{border:inset 0;background:#FFCCCC;font-family:verdana;font-size:9pt}

.input_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

.input_num_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

.td_leftAlign
{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

.td_rightAlign
{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

</style>

	<form name="Wizard_Activity" action="/ibase/webitm/jsp/othersDetailInfo.jsp" method="post">

	<table class="tableClass" border="0" cellspacing="1" cellpadding="1">
	
		<tr>
			
			<td class="header_td" nowrap="true" valign="bottom" width="20%">
				<strong>Sale Order</strong>
			</td>
			<td class="header_td" nowrap="true" valign="bottom" width="20%">
				<strong>Item Code</strong>
			</td>
			<td class="header_td" nowrap="true" valign="bottom" width="20%">
				<strong>Demand</strong>
			</td>
			<td class="header_td" nowrap="true" valign="bottom" width="20%">
				<strong>Due Date</strong>
			</td>
		</tr>

		<xsl:for-each select="//OTHERSDETAILS">
		  <xsl:sort select="SALE_ORDER" />	
			<xsl:variable name="SALE_ORDER"><xsl:value-of select="SALE_ORDER"/></xsl:variable>
			<xsl:variable name="LINE_NO"><xsl:value-of select="LINE_NO"/></xsl:variable>
			<xsl:variable name="DEMAND"><xsl:value-of select="DEMAND"/></xsl:variable>
			<xsl:variable name="DUE_DATE"><xsl:value-of select="DUE_DATE"/></xsl:variable>
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable> 
			<tr>
				<td class="td_leftAlign">
					<xsl:value-of select="SALE_ORDER"/>
					<input  type="hidden"  name="Detail4.{normalize-space($dbID)}.SALE_ORDER" id = "DetailActCode.{normalize-space($dbID)}.SALE_ORDER" value="{normalize-space($SALE_ORDER)}" size="20" class="fieldcell_items" ISCHANGED="false"/>
				</td>
				<td class="td_leftAlign">
					<xsl:value-of select="LINE_NO"/>
					<input  type="hidden"  name="Detail4.{normalize-space($dbID)}.LINE_NO" id = "DetailActCode.{normalize-space($dbID)}.LINE_NO" value="{normalize-space($LINE_NO)}" size="20" class="fieldcell_items" ISCHANGED="false"/>
				</td>
				<td class="td_leftAlign"  style="text-align:right">
					<xsl:value-of select="format-number(DEMAND, '######.000')" />
					<input  type="hidden"  name="Detail4.{normalize-space($dbID)}.DEMAND" id = "DetailActCode.{normalize-space($dbID)}.DEMAND" value="{normalize-space($DEMAND)}" size="20" class="fieldcell_items" ISCHANGED="false"/>
				</td>
				<td class="td_leftAlign">
					<xsl:value-of select="DUE_DATE"/>
					<input  type="hidden"  name="Detail4.{normalize-space($dbID)}.DUE_DATE" id = "DetailActCode.{normalize-space($dbID)}.DUE_DATE" value="{normalize-space($DUE_DATE)}" size="20" class="fieldcell_items" ISCHANGED="false"/>
				</td>
			</tr>
		</xsl:for-each>
</table>
<table cellSpacing="1" cellPadding="1" width="50%" border="0">
	<tr>
	      <td>
			<input  type="hidden"  value="1" name="FORM_NO" />
			<input  type="hidden"  value="mrp_run_wiz" name="OBJ_NAME" />
			<input  type="hidden"  value="" name="action" id="action" />

		
			<input type ="button" value="Cancel" title='' onclick="window.close()"/>
	      </td>
	</tr>
</table>
</form>
</body>

</html>
</xsl:template>
</xsl:stylesheet>

