/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.adm;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.ejb.adm.PerkClaimICLocal;
import ibase.webitm.ejb.adm.PerkClaimICRemote;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class PerkClaimIC
extends ValidatorEJB
implements PerkClaimICLocal,
PerkClaimICRemote {
    @Override
    public String wfValData(String currFrmXmlStr, String hdrFrmXmlStr, String allFrmXmlStr, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
        Document currDom = null;
        Document hdrDom = null;
        Document allDom = null;
        String errString = "";
        System.out.println("curr xml=" + currFrmXmlStr);
        System.out.println("hdr xml=" + hdrFrmXmlStr);
        System.out.println("all xml=" + allFrmXmlStr);
        try {
            if (currFrmXmlStr != null && currFrmXmlStr.trim().length() != 0) {
                currDom = this.parseString(currFrmXmlStr);
            }
            if (hdrFrmXmlStr != null && hdrFrmXmlStr.trim().length() != 0) {
                hdrDom = this.parseString(hdrFrmXmlStr);
            }
            if (allFrmXmlStr != null && allFrmXmlStr.trim().length() != 0) {
                allDom = this.parseString(allFrmXmlStr);
            }
            errString = this.wfValData(currDom, hdrDom, allDom, objContext, editFlag, xtraParams);
        }
        catch (Exception e) {
            System.out.println("Exception : [PerlClaimIc][wfValData(String currFrmXmlStr)] : ==>\n" + e.getMessage());
            e.printStackTrace();
            throw new ITMException(e);
        }
        return errString;
    }

    @Override
    public String wfValData(Document currDom, Document hdrDom, Document allDom, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
        String errString = "";
        String columnValue = "";
        String sql = "";
        String adCode = "";
        String balOpt = "";
        String payable = "";
        String varValue = "";
        String empCode = "";
        String bankCode = "";
        String adjLoan = "";
        String fullAmt = "";
        String paySite = "";
        String cadre = "";
        String grade = "";
        String payrollVoucher = "";
        String payrollPrd = "";
        String childNodeName = "";
        int noOfChilds = 0;
        int noOfParent = 0;
        boolean count = false;
        java.util.Date claimDate = null;
        Timestamp relieveDate = null;
        ResultSet rs = null;
        Connection conn = null;
        Statement pstmt = null;
        GenericUtility genericUtility = GenericUtility.getInstance();
        StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
        String errorType = "";
        String errCode = "";
        ArrayList<String> errList = new ArrayList<String>();
        ArrayList<String> errFields = new ArrayList<String>();
        AdmCommon admCommon = new AdmCommon();
        SimpleDateFormat simpleDateFormat = null;
        try {
            try {
                int currentFormNo = 0;
                int cnt = 0;
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB("DriverITM");
                simpleDateFormat = new SimpleDateFormat("dd/MM/yy");
                Node childNode = null;
                String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
                if (objContext != null && objContext.trim().length() > 0) {
                    currentFormNo = Integer.parseInt(objContext);
                }
                NodeList parentList = currDom.getElementsByTagName("Detail" + currentFormNo);
                NodeList childList = null;
                noOfParent = parentList.getLength();
                switch (currentFormNo) {
                    case 1: {
                        System.out.println("Case 1 Validation");
                        childList = parentList.item(0).getChildNodes();
                        noOfChilds = childList.getLength();
                        int ctr = 0;
                        while (ctr < noOfChilds) {
                            childNode = childList.item(ctr);
                            if (childNode.getNodeType() == 1) {
                                childNodeName = childNode.getNodeName();
                                if (childNode != null && childNode.getFirstChild() != null) {
                                    columnValue = childNode.getFirstChild().getNodeValue();
                                }
                                System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
                                if ("ad_code".equalsIgnoreCase(childNodeName)) {
                                    adCode = this.checkNull(genericUtility.getColumnValue("ad_code", currDom));
                                    System.out.println("adCode=" + adCode);
                                    varValue = admCommon.getEnv("999999", "CLAIMAD_WO_LOANADJ", conn);
                                    System.out.println("varValue=" + varValue);
                                    if (varValue != null && varValue.trim().length() > 0 && "NULLFOUND".equalsIgnoreCase(varValue) && (varValue = String.valueOf(varValue.trim()) + ",").indexOf(String.valueOf(adCode.trim()) + ",") > 0) {
                                        errList.add("VPPERKAD1");
                                        errFields.add(childNodeName.toLowerCase());
                                    }
                                    sql = " select count(*) from allwdedn where ad_code = ? ";
                                    pstmt = conn.prepareStatement(sql);
                                    pstmt.setString(1, adCode);
                                    rs = pstmt.executeQuery();
                                    if (rs.next()) {
                                        cnt = rs.getInt(1);
                                    }
                                    rs.close();
                                    rs = null;
                                    pstmt.close();
                                    pstmt = null;
                                    if (cnt == 0) {
                                        errList.add("VMADC1");
                                        errFields.add(childNodeName.toLowerCase());
                                    } else {
                                        sql = " select bal_opt,payable from allwdedn where ad_code = ? ";
                                        pstmt = conn.prepareStatement(sql);
                                        pstmt.setString(1, adCode);
                                        rs = pstmt.executeQuery();
                                        if (rs.next()) {
                                            balOpt = this.checkNull(rs.getString("bal_opt"));
                                            payable = this.checkNull(rs.getString("payable"));
                                        }
                                        rs.close();
                                        rs = null;
                                        pstmt.close();
                                        pstmt = null;
                                        if ("D".equalsIgnoreCase(payable)) {
                                            errList.add("VTADTYPE");
                                            errFields.add(childNodeName.toLowerCase());
                                        }
                                    }
                                } else if ("claim_date".equalsIgnoreCase(childNodeName)) {
                                    System.out.println("claim date = " + genericUtility.getColumnValue("claim_date", currDom) == null);
                                    if (genericUtility.getColumnValue("claim_date", currDom) == null) {
                                        errList.add("VMDATENULL");
                                        errFields.add(childNodeName.toLowerCase());
                                    }
                                } else if ("bank_code".equalsIgnoreCase(childNodeName)) {
                                    bankCode = this.checkNull(genericUtility.getColumnValue("bank_code", currDom));
                                    System.out.println("bankCode=" + bankCode);
                                    if (bankCode != null && bankCode.trim().length() > 0) {
                                        sql = " select count(*) from bank where bank_code = ? ";
                                        pstmt = conn.prepareStatement(sql);
                                        pstmt.setString(1, bankCode);
                                        rs = pstmt.executeQuery();
                                        if (rs.next()) {
                                            cnt = rs.getInt(1);
                                        }
                                        rs.close();
                                        rs = null;
                                        pstmt.close();
                                        pstmt = null;
                                        if (cnt == 0) {
                                            errList.add("VMBANK1");
                                            errFields.add(childNodeName.toLowerCase());
                                        }
                                    }
                                } else if ("emp_code".equalsIgnoreCase(childNodeName)) {
                                    empCode = this.checkNull(genericUtility.getColumnValue("emp_code", currDom));
                                    System.out.println("empCode=" + empCode);
                                    sql = " select count(*) from employee where emp_code = ? ";
                                    pstmt = conn.prepareStatement(sql);
                                    pstmt.setString(1, empCode);
                                    rs = pstmt.executeQuery();
                                    if (rs.next()) {
                                        cnt = rs.getInt(1);
                                    }
                                    rs.close();
                                    rs = null;
                                    pstmt.close();
                                    pstmt = null;
                                    if (cnt == 0) {
                                        errList.add("VMEMP1");
                                        errFields.add(childNodeName.toLowerCase());
                                    } else {
                                        sql = " Select count(*)  from loans   Where emp_code = ?  \tand (status = 'U' or (status = 'A' and start_dedn <> 'Y')) \tand accrual_amt > 0 ";
                                        pstmt = conn.prepareStatement(sql);
                                        pstmt.setString(1, empCode);
                                        rs = pstmt.executeQuery();
                                        if (rs.next()) {
                                            cnt = rs.getInt(1);
                                        }
                                        rs.close();
                                        rs = null;
                                        pstmt.close();
                                        pstmt = null;
                                        if (cnt > 0) {
                                            errList.add("VTLOAN7");
                                            errFields.add(childNodeName.toLowerCase());
                                        }
                                    }
                                    System.out.println("case 1 val for process tab");
                                    empCode = this.checkNull(genericUtility.getColumnValue("emp_code", currDom));
                                    adCode = this.checkNull(genericUtility.getColumnValue("ad_code", currDom));
                                    fullAmt = this.checkNull(genericUtility.getColumnValue("full_amt", currDom));
                                    adjLoan = this.checkNull(genericUtility.getColumnValue("adjust_loan", currDom));
                                    System.out.println("empCode=" + empCode);
                                    System.out.println("adCode=" + adCode);
                                    System.out.println("fullAmt=" + fullAmt);
                                    System.out.println("adjLoan=" + adjLoan);
                                    claimDate = genericUtility.getColumnValue("claim_date", currDom) == null ? null : simpleDateFormat.parse(genericUtility.getColumnValue("claim_date", currDom));
                                    System.out.println("claimDate=" + claimDate);
                                    sql = "select relieve_date,pay_site,cadre,grade  from employee where emp_code = ? ";
                                    pstmt = conn.prepareStatement(sql);
                                    pstmt.setString(1, empCode);
                                    rs = pstmt.executeQuery();
                                    if (rs.next()) {
                                        relieveDate = rs.getTimestamp("relieve_date");
                                        paySite = this.checkNull(rs.getString("pay_site"));
                                        cadre = this.checkNull(rs.getString("cadre"));
                                        grade = this.checkNull(rs.getString("grade"));
                                    }
                                    rs.close();
                                    rs = null;
                                    pstmt.close();
                                    pstmt = null;
                                    String envName = String.valueOf(adCode.trim().toUpperCase()) + "_CLAIMCURRPRD";
                                    System.out.println("envName=" + envName);
                                    String canClaimInsameYear = admCommon.getAdmEnv(paySite, cadre, grade, envName, relieveDate, conn);
                                    System.out.println("canClaimInsameYear=" + canClaimInsameYear);
                                    if ("NULLFOUND".equalsIgnoreCase(canClaimInsameYear)) {
                                        canClaimInsameYear = admCommon.getEnv("999999", envName, conn);
                                        System.out.println("canClaimInsameYear=" + canClaimInsameYear);
                                        if ("NULLFOUND".equalsIgnoreCase(canClaimInsameYear)) {
                                            errList.add("VSENVAR1");
                                            errFields.add(childNodeName.toLowerCase());
                                        }
                                    }
                                } else if ("payroll_voucher".equalsIgnoreCase(childNodeName)) {
                                    payrollVoucher = this.checkNull(genericUtility.getColumnValue("payroll_voucher", currDom));
                                    payrollPrd = this.checkNull(genericUtility.getColumnValue("payroll_prd", currDom));
                                    if ("P".equalsIgnoreCase(payrollVoucher) && (payrollPrd == null || payrollPrd.trim().length() == 0)) {
                                        errList.add("VMPRDCD");
                                        errFields.add(childNodeName.toLowerCase());
                                    }
                                }
                            }
                            ++ctr;
                        }
                        break;
                    }
                    case 2: {
                        System.out.println("Case 2 Validation");
                        NodeList parentNodeList = null;
                        Node parentNode = null;
                        int parentNodeListLength = 0;
                        double claimAmount = 0.0;
                        double balAmount = 0.0;
                        parentNodeList = allDom.getElementsByTagName("Detail2");
                        parentNodeListLength = parentNodeList.getLength();
                        System.out.println("Detail2 length = " + parentNodeListLength);
                        if (parentNodeListLength < 1) {
                            errList.add("VTNOSEL");
                            errFields.add(" ");
                            break;
                        }
                        fullAmt = this.checkNull(genericUtility.getColumnValue("full_amt", hdrDom));
                        int ctr = 0;
                        while (ctr < parentNodeListLength) {
                            System.out.println("TEST LENGTH=" + parentNodeListLength);
                            parentNode = parentNodeList.item(ctr);
                            claimAmount = Double.parseDouble(genericUtility.getColumnValueFromNode("claim_amt", parentNodeList.item(ctr)) == null ? "0" : genericUtility.getColumnValueFromNode("claim_amt", parentNodeList.item(ctr)));
                            balAmount = Double.parseDouble(genericUtility.getColumnValueFromNode("amt_bal", parentNodeList.item(ctr)) == null ? "0" : genericUtility.getColumnValueFromNode("amt_bal", parentNodeList.item(ctr)));
                            System.out.println("Full amy==" + fullAmt + "   " + balAmount + "   " + claimAmount);
                            if ("Y".equalsIgnoreCase(fullAmt)) {
                                if (balAmount != claimAmount) {
                                    errList.add("VTPERK1");
                                    errFields.add("claim_amt");
                                }
                            } else if (claimAmount > balAmount) {
                                errList.add("VMADJAMT2");
                                errFields.add("claim_amt");
                            }
                            ++ctr;
                        }
                        break;
                    }
                    case 3: {
                        System.out.println("Case 3 Validation");
                        childList = parentList.item(0).getChildNodes();
                        noOfChilds = childList.getLength();
                        int ctr = 0;
                        while (ctr < noOfChilds) {
                            childNode = childList.item(ctr);
                            if (childNode.getNodeType() == 1) {
                                childNodeName = childNode.getNodeName();
                                if (childNode != null && childNode.getFirstChild() != null) {
                                    columnValue = childNode.getFirstChild().getNodeValue();
                                }
                                System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
                                "xyz".equalsIgnoreCase(childNodeName);
                            }
                            ++ctr;
                        }
                        break;
                    }
                }
                int errListSize = errList.size();
                cnt = 0;
                String errFldName = null;
                if (errList != null && errListSize > 0) {
                    cnt = 0;
                    while (cnt < errListSize) {
                        errCode = (String)errList.get(cnt);
                        errFldName = (String)errFields.get(cnt);
                        System.out.println("errCode .........." + errCode);
                        errString = this.getErrorString(errFldName, errCode, userId);
                        errorType = this.errorType(conn, errCode);
                        if (errString.length() > 0) {
                            String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
                            bifurErrString = String.valueOf(bifurErrString) + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
                            errStringXml.append(bifurErrString);
                            System.out.println("errStringXml .........." + errStringXml);
                            errString = "";
                        }
                        if (errorType.equalsIgnoreCase("E")) break;
                        ++cnt;
                    }
                    errList.clear();
                    errList = null;
                    errFields.clear();
                    errFields = null;
                    errStringXml.append("</Errors></Root>\r\n");
                } else {
                    errStringXml = new StringBuffer("");
                }
                errString = errStringXml.toString();
            }
            catch (Exception e) {
                System.out.println("Exception in PerlClaimIc  == >");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception e) {
                System.out.println("Exception :PerlClaimIc:wfValData :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return errString;
    }

    private String errorType(Connection conn, String errorCode) {
        String msgType = "";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, errorCode);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    msgType = rs.getString("MSG_TYPE");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return msgType;
    }

    @Override
    public String itemChanged(String currFrmXmlStr, String hdrFrmXmlStr, String allFrmXmlStr, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
        Document currDom = null;
        Document hdrDom = null;
        Document allDom = null;
        String errString = null;
        System.out.println("currFrmXmlStr::" + currFrmXmlStr);
        System.out.println("hdrFrmXmlStr::" + hdrFrmXmlStr);
        System.out.println("allFrmXmlStr::" + allFrmXmlStr);
        GenericUtility genericUtility = GenericUtility.getInstance();
        try {
            if (currFrmXmlStr != null && currFrmXmlStr.trim().length() != 0) {
                currDom = genericUtility.parseString(currFrmXmlStr);
            }
            if (hdrFrmXmlStr != null && hdrFrmXmlStr.trim().length() != 0) {
                hdrDom = genericUtility.parseString(hdrFrmXmlStr);
            }
            if (allFrmXmlStr != null && allFrmXmlStr.trim().length() != 0) {
                allDom = genericUtility.parseString(allFrmXmlStr);
            }
            errString = this.itemChanged(currDom, hdrDom, allDom, objContext, currentColumn, editFlag, xtraParams);
            System.out.println("ErrString :" + errString);
        }
        catch (Exception e) {
            System.out.println("Exception : PerlClaimIc:defaul_ItemChanged(String,String):" + e.getMessage() + ":");
            errString = genericUtility.createErrorString(e);
            throw new ITMException(e);
        }
        System.out.println("returning from PerlClaimIc default_Itemchanged");
        return errString;
    }

    @Override
    public String itemChanged(Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
        String retValue = "";
        try {
            retValue = this.default_ItemChanged(currDom, hdrDom, allDom, objContext, currentColumn, editFlag, xtraParams);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return retValue;
    }

    public String default_ItemChanged(Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
        String sql = "";
        String empCode = "";
        String adCode = "";
        String adjLoan = "";
        String paySite = "";
        String cadre = "";
        String grade = "";
        String descr = "";
        String adDescr = "";
        String payMode = "";
        String bankCode = "";
        String payrollVoucher = "";
        String payrollPrd = "";
        String fullAmt = "";
        String fName = "";
        String lName = "";
        String loanRefNo = "";
        String loanAdCode = "";
        String schemeNo = "";
        String loanNo = "";
        int currentFormNo = 0;
        int domID = 0;
        int count = 0;
        double balanceAmt = 0.0;
        double claimAmount = 0.0;
        double amount = 0.0;
        double balAmount = 0.0;
        double loanAdjPerc = 0.0;
        double loanBalAmt = 0.0;
        double loanMonInst = 0.0;
        double loanInterest = 0.0;
        double loanAmt = 0.0;
        java.util.Date claimDate = null;
        Date startDate = null;
        Date endDate = null;
        Timestamp relieveDate = null;
        NodeList parentNodeList = null;
        Node parentNode = null;
        int parentNodeListLength = 0;
        ResultSet rs = null;
        ResultSet rs1 = null;
        Connection conn = null;
        Statement pstmt = null;
        PreparedStatement pstmt1 = null;
        StringBuffer valueXmlString = new StringBuffer();
        GenericUtility genericUtility = GenericUtility.getInstance();
        AdmCommon admCommon = new AdmCommon();
        try {
            try {
                String applDateFormat = genericUtility.getApplDateFormat();
                SimpleDateFormat sdf = new SimpleDateFormat(applDateFormat);
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB("DriverITM");
                if (objContext != null && objContext.trim().length() > 0) {
                    currentFormNo = Integer.parseInt(objContext);
                }
                valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
                valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
                switch (currentFormNo) {
                    case 1: {
                        System.out.println("case 1 IC...");
                        valueXmlString.append("<Detail1 domID='1' selected=\"Y\">\r\n");
                        valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n");
                        if (currentColumn.trim().equalsIgnoreCase("itm_default")) {
                            valueXmlString.append("<claim_date><![CDATA[" + sdf.format(new java.util.Date()).toString() + "]]></claim_date>");
                        } else if (currentColumn.trim().equalsIgnoreCase("emp_code")) {
                            empCode = this.checkNull(genericUtility.getColumnValue("emp_code", currDom));
                            valueXmlString.append("<emp_code><![CDATA[").append(empCode).append("]]></emp_code>\r\n");
                            empCode = this.checkNull(genericUtility.getColumnValue("claim_date", currDom));
                            valueXmlString.append("<claim_date><![CDATA[").append(empCode).append("]]></claim_date>\r\n");
                            adCode = this.checkNull(genericUtility.getColumnValue("ad_code", currDom));
                            valueXmlString.append("<ad_code><![CDATA[").append(adCode).append("]]></ad_code>\r\n");
                            adjLoan = this.checkNull(genericUtility.getColumnValue("adjust_loan", currDom));
                            valueXmlString.append("<adjust_loan><![CDATA[").append(adjLoan).append("]]></adjust_loan>\r\n");
                            fullAmt = this.checkNull(genericUtility.getColumnValue("full_amt", currDom));
                            valueXmlString.append("<full_amt><![CDATA[").append(fullAmt).append("]]></full_amt>\r\n");
                            payrollVoucher = this.checkNull(genericUtility.getColumnValue("payroll_voucher", currDom));
                            valueXmlString.append("<payroll_voucher><![CDATA[").append(payrollVoucher).append("]]></payroll_voucher>\r\n");
                            payrollPrd = this.checkNull(genericUtility.getColumnValue("payroll_prd", currDom));
                            valueXmlString.append("<payroll_prd><![CDATA[").append(payrollPrd).append("]]></payroll_prd>\r\n");
                            bankCode = this.checkNull(genericUtility.getColumnValue("bank_code", currDom));
                            valueXmlString.append("<bank_code><![CDATA[").append(bankCode).append("]]></bank_code>\r\n");
                            payMode = this.checkNull(genericUtility.getColumnValue("pay_mode", currDom));
                            valueXmlString.append("<pay_mode><![CDATA[").append(payMode).append("]]></pay_mode>\r\n");
                            adDescr = this.checkNull(genericUtility.getColumnValue("ad_descr", currDom));
                            valueXmlString.append("<ad_descr><![CDATA[").append(adDescr).append("]]></ad_descr>\r\n");
                            descr = "";
                            empCode = genericUtility.getColumnValue("emp_code", currDom);
                            sql = " select emp_fname from employee where emp_code = ? ";
                            System.out.println("empCode =" + empCode);
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, empCode);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                descr = this.checkNull(rs.getString("emp_fname"));
                            }
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                            valueXmlString.append("<emp_name><![CDATA[").append(descr).append("]]></emp_name>\r\n");
                        } else if (currentColumn.trim().equalsIgnoreCase("ad_code")) {
                            empCode = this.checkNull(genericUtility.getColumnValue("emp_code", currDom));
                            valueXmlString.append("<emp_code><![CDATA[").append(empCode).append("]]></emp_code>\r\n");
                            empCode = this.checkNull(genericUtility.getColumnValue("claim_date", currDom));
                            valueXmlString.append("<claim_date><![CDATA[").append(empCode).append("]]></claim_date>\r\n");
                            adCode = this.checkNull(genericUtility.getColumnValue("ad_code", currDom));
                            valueXmlString.append("<ad_code><![CDATA[").append(adCode).append("]]></ad_code>\r\n");
                            adjLoan = this.checkNull(genericUtility.getColumnValue("adjust_loan", currDom));
                            valueXmlString.append("<adjust_loan><![CDATA[").append(adjLoan).append("]]></adjust_loan>\r\n");
                            fullAmt = this.checkNull(genericUtility.getColumnValue("full_amt", currDom));
                            valueXmlString.append("<full_amt><![CDATA[").append(fullAmt).append("]]></full_amt>\r\n");
                            payrollVoucher = this.checkNull(genericUtility.getColumnValue("payroll_voucher", currDom));
                            valueXmlString.append("<payroll_voucher><![CDATA[").append(payrollVoucher).append("]]></payroll_voucher>\r\n");
                            payrollPrd = this.checkNull(genericUtility.getColumnValue("payroll_prd", currDom));
                            valueXmlString.append("<payroll_prd><![CDATA[").append(payrollPrd).append("]]></payroll_prd>\r\n");
                            bankCode = this.checkNull(genericUtility.getColumnValue("bank_code", currDom));
                            valueXmlString.append("<bank_code><![CDATA[").append(bankCode).append("]]></bank_code>\r\n");
                            payMode = this.checkNull(genericUtility.getColumnValue("pay_mode", currDom));
                            valueXmlString.append("<pay_mode><![CDATA[").append(payMode).append("]]></pay_mode>\r\n");
                            descr = this.checkNull(genericUtility.getColumnValue("emp_name", currDom));
                            valueXmlString.append("<emp_name><![CDATA[").append(descr).append("]]></emp_name>\r\n");
                            adDescr = "";
                            adCode = genericUtility.getColumnValue("ad_code", currDom);
                            sql = " select descr from allwdedn where ad_code = ? ";
                            System.out.println("adCode =" + adCode);
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, adCode);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                adDescr = this.checkNull(rs.getString("descr"));
                            }
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                            valueXmlString.append("<ad_descr><![CDATA[").append(adDescr).append("]]></ad_descr>\r\n");
                        } else if (currentColumn.trim().equalsIgnoreCase("payroll_voucher")) {
                            empCode = this.checkNull(genericUtility.getColumnValue("emp_code", currDom));
                            valueXmlString.append("<emp_code><![CDATA[").append(empCode).append("]]></emp_code>\r\n");
                            empCode = this.checkNull(genericUtility.getColumnValue("claim_date", currDom));
                            valueXmlString.append("<claim_date><![CDATA[").append(empCode).append("]]></claim_date>\r\n");
                            adCode = this.checkNull(genericUtility.getColumnValue("ad_code", currDom));
                            valueXmlString.append("<ad_code><![CDATA[").append(adCode).append("]]></ad_code>\r\n");
                            adjLoan = this.checkNull(genericUtility.getColumnValue("adjust_loan", currDom));
                            valueXmlString.append("<adjust_loan><![CDATA[").append(adjLoan).append("]]></adjust_loan>\r\n");
                            fullAmt = this.checkNull(genericUtility.getColumnValue("full_amt", currDom));
                            valueXmlString.append("<full_amt><![CDATA[").append(fullAmt).append("]]></full_amt>\r\n");
                            bankCode = this.checkNull(genericUtility.getColumnValue("bank_code", currDom));
                            valueXmlString.append("<bank_code><![CDATA[").append(bankCode).append("]]></bank_code>\r\n");
                            payMode = this.checkNull(genericUtility.getColumnValue("pay_mode", currDom));
                            valueXmlString.append("<pay_mode><![CDATA[").append(payMode).append("]]></pay_mode>\r\n");
                            descr = this.checkNull(genericUtility.getColumnValue("emp_name", currDom));
                            valueXmlString.append("<emp_name><![CDATA[").append(descr).append("]]></emp_name>\r\n");
                            adDescr = "";
                            adCode = genericUtility.getColumnValue("ad_code", currDom);
                            sql = " select descr from allwdedn where ad_code = ? ";
                            System.out.println("adCode =" + adCode);
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, adCode);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                adDescr = this.checkNull(rs.getString("descr"));
                            }
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                            valueXmlString.append("<ad_descr><![CDATA[").append(adDescr).append("]]></ad_descr>\r\n");
                            payrollVoucher = this.checkNull(genericUtility.getColumnValue("payroll_voucher", currDom));
                            payrollPrd = this.checkNull(genericUtility.getColumnValue("payroll_prd", currDom));
                            if ("V".equalsIgnoreCase(payrollVoucher)) {
                                valueXmlString.append("<payroll_prd protect = '1'><![CDATA[").append("").append("]]></payroll_prd>\r\n");
                            } else {
                                valueXmlString.append("<payroll_prd protect = '0'><![CDATA[").append(payrollPrd).append("]]></payroll_prd>\r\n");
                            }
                            valueXmlString.append("<payroll_voucher><![CDATA[").append(payrollVoucher).append("]]></payroll_voucher>\r\n");
                        }
                        valueXmlString.append("</Detail1>\r\n");
                        break;
                    }
                    case 2: {
                        System.out.println("case 2 IC...");
                        if (currentColumn.trim().equalsIgnoreCase("itm_default")) {
                            empCode = this.checkNull(genericUtility.getColumnValue("emp_code", hdrDom));
                            adCode = this.checkNull(genericUtility.getColumnValue("ad_code", hdrDom));
                            fullAmt = this.checkNull(genericUtility.getColumnValue("full_amt", hdrDom));
                            adjLoan = this.checkNull(genericUtility.getColumnValue("adjust_loan", hdrDom));
                            System.out.println("empCode=" + empCode);
                            System.out.println("adCode=" + adCode);
                            System.out.println("fullAmt=" + fullAmt);
                            System.out.println("adjLoan=" + adjLoan);
                            claimDate = genericUtility.getColumnValue("claim_date", hdrDom) == null ? null : sdf.parse(genericUtility.getColumnValue("claim_date", hdrDom));
                            System.out.println("claimDate=" + claimDate);
                            if ("Y".equalsIgnoreCase(adjLoan)) {
                                sql = "select sum(balance_amt) \tfrom allowdedn_bal,loans where ref_no = loan_no  and allowdedn_bal.emp_code = ?  and ad_code between '0' and 'z' and amt_bal > 0 \tand ref_type = 'L' \tand adjustable = 'Y'";
                                pstmt = conn.prepareStatement(sql);
                                pstmt.setString(1, empCode);
                                rs = pstmt.executeQuery();
                                if (rs.next()) {
                                    balanceAmt = rs.getDouble(1);
                                }
                                rs.close();
                                rs = null;
                                pstmt.close();
                                pstmt = null;
                            } else {
                                System.out.println("loan tab diable");
                            }
                            sql = "select relieve_date,pay_site,cadre,grade  from employee where emp_code = ? ";
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, empCode);
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                relieveDate = rs.getTimestamp("relieve_date");
                                paySite = this.checkNull(rs.getString("pay_site"));
                                cadre = this.checkNull(rs.getString("cadre"));
                                grade = this.checkNull(rs.getString("grade"));
                            }
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                            String envName = String.valueOf(adCode.trim().toUpperCase()) + "_CLAIMCURRPRD";
                            String canClaimInsameYear = admCommon.getAdmEnv(paySite, cadre, grade, envName, relieveDate, conn);
                            if ("NULLFOUND".equalsIgnoreCase(canClaimInsameYear)) {
                                canClaimInsameYear = admCommon.getEnv("999999", envName, conn);
                                "NULLFOUND".equalsIgnoreCase(canClaimInsameYear);
                            }
                            if (!"Y".equals(canClaimInsameYear = canClaimInsameYear.trim().toUpperCase())) {
                                canClaimInsameYear = "N";
                            }
                            if (relieveDate != null) {
                                canClaimInsameYear = "Y";
                            }
                            sql = " SELECT allowdedn_bal.emp_code, employee.emp_fname, employee.emp_lname, allowdedn_bal.ad_code, allowdedn_bal.start_date, allowdedn_bal.end_date,  allowdedn_bal.amount, allowdedn_bal.amt_bal, amt_bal claim_amt   FROM allowdedn_bal, employee  WHERE ( allowdedn_bal.emp_code = employee.emp_code ) and   ( allowdedn_bal.emp_code = ? ) AND  ( allowdedn_bal.ad_code = ? ) AND  ( allowdedn_bal.amt_bal <> 0 ) AND  ( allowdedn_bal.ref_type = 'K' ) AND    ( decode(?,'Y',allowdedn_bal.start_date,allowdedn_bal.end_date)  < ? ) AND  (allowdedn_bal.exp_date is null OR   allowdedn_bal.exp_date >= ? )   ORDER BY allowdedn_bal.start_date ASC   ";
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, empCode);
                            pstmt.setString(2, adCode);
                            pstmt.setString(3, canClaimInsameYear);
                            pstmt.setDate(4, new Date(claimDate.getTime()));
                            pstmt.setDate(5, new Date(claimDate.getTime()));
                            rs = pstmt.executeQuery();
                            while (rs.next()) {
                                empCode = this.checkNull(rs.getString("emp_code"));
                                fName = this.checkNull(rs.getString("emp_fname"));
                                lName = this.checkNull(rs.getString("emp_lname"));
                                adCode = this.checkNull(rs.getString("ad_code"));
                                startDate = rs.getDate("start_date");
                                endDate = rs.getDate("end_date");
                                amount = rs.getDouble("amount");
                                balAmount = rs.getDouble("amt_bal");
                                claimAmount = rs.getDouble("claim_amt");
                                valueXmlString.append("<Detail2 domID='" + ++domID + "'  selected=\"N\">\r\n");
                                valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\"  status=\"N\" pkNames=\"\" />\r\n");
                                valueXmlString.append("<emp_code><![CDATA[").append(empCode).append("]]></emp_code>\r\n");
                                valueXmlString.append("<emp_fname><![CDATA[").append(fName).append("]]></emp_fname>\r\n");
                                valueXmlString.append("<emp_lname><![CDATA[").append(lName).append("]]></emp_lname>\r\n");
                                valueXmlString.append("<amount><![CDATA[").append(amount).append("]]></amount>\r\n");
                                valueXmlString.append("<amt_bal><![CDATA[").append(balAmount).append("]]></amt_bal>\r\n");
                                if ("Y".equalsIgnoreCase(fullAmt)) {
                                    valueXmlString.append("<claim_amt protect ='1'><![CDATA[").append(claimAmount).append("]]></claim_amt>\r\n");
                                } else {
                                    valueXmlString.append("<claim_amt protect ='0'><![CDATA[").append(claimAmount).append("]]></claim_amt>\r\n");
                                }
                                valueXmlString.append("<start_date><![CDATA[").append(sdf.format(startDate)).append("]]></start_date>\r\n");
                                valueXmlString.append("<end_date><![CDATA[").append(sdf.format(endDate)).append("]]></end_date>\r\n");
                                valueXmlString.append("</Detail2>\r\n");
                            }
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                        }
                        break;
                    }
                    case 3: {
                        System.out.println("case 3 IC...");
                        domID = 0;
                        if (!currentColumn.trim().equalsIgnoreCase("itm_default")) break;
                        adjLoan = this.checkNull(genericUtility.getColumnValue("adjust_loan", hdrDom));
                        System.out.println("adjLoan" + adjLoan);
                        if ("Y".equalsIgnoreCase(adjLoan)) {
                            empCode = this.checkNull(genericUtility.getColumnValue("emp_code", hdrDom));
                            adCode = this.checkNull(genericUtility.getColumnValue("ad_code", hdrDom));
                            claimDate = genericUtility.getColumnValue("claim_date", hdrDom) == null ? null : sdf.parse(genericUtility.getColumnValue("claim_date", hdrDom));
                            parentNodeList = allDom.getElementsByTagName("Detail2");
                            parentNodeListLength = parentNodeList.getLength();
                            double claimTotalAmt = 0.0;
                            int case1 = 0;
                            int case2 = 0;
                            System.out.println("DETAIL2 TEST LENGTH=" + parentNodeListLength);
                            int ctr = 0;
                            while (ctr < parentNodeListLength) {
                                parentNode = parentNodeList.item(ctr);
                                Element parentNode1 = (Element)parentNodeList.item(ctr);
                                System.out.println("Claim amt=" + genericUtility.getColumnValue("claim_amt", allDom, "2"));
                                claimAmount = Double.parseDouble(genericUtility.getColumnValue("claim_amt", allDom, "2") == null ? "0" : genericUtility.getColumnValue("claim_amt", allDom, "2"));
                                System.out.println("claimAmount=" + claimAmount);
                                claimTotalAmt += claimAmount;
                                ++ctr;
                            }
                            System.out.println("claimTotalAmount=" + claimTotalAmt);
                            balanceAmt = claimTotalAmt;
                            sql = "select loan_no from \tloans where emp_code = ? and  loans.balance_amt > 0  and loans.adjustable = 'Y' and status ='A' ";
                            pstmt = conn.prepareStatement(sql);
                            pstmt.setString(1, empCode);
                            rs = pstmt.executeQuery();
                            if (rs == null) {
                                valueXmlString.append("<Detail3 domID='1' selected=\"N\">n</Detail3>");
                            }
                            while (rs.next()) {
                                loanNo = this.checkNull(rs.getString("loan_no"));
                                sql = "select count(*)   from loan_adj \twhere loan_no = ? ";
                                pstmt1 = conn.prepareStatement(sql);
                                pstmt1.setString(1, loanNo);
                                rs1 = pstmt1.executeQuery();
                                if (rs1.next()) {
                                    count = rs1.getInt(1);
                                }
                                rs1.close();
                                rs1 = null;
                                pstmt1.close();
                                pstmt1 = null;
                                if (count > 0) {
                                    sql = " Select allowdedn_bal.ad_code, loan_adj.adj_perc, allowdedn_bal.ref_no,\tallowdedn_bal.start_date, allowdedn_bal.end_date,  loans.scheme_no, loans.loan_amt, loans.balance_amt,\t\tloans.mon_inst,loans.interest  from allowdedn_bal,loans,loan_adj\t\t\twhere (allowdedn_bal.ref_no = loans.loan_no)  and (loans.loan_no = loan_adj.loan_no)\t\tand (allowdedn_bal.ref_no = ? )  and (loan_adj.ad_code = ? )  \tand (allowdedn_bal.ad_code between '0' and 'Z')  and  ( ?  between loan_adj.eff_date and loan_adj.exp_date) \t\tand (allowdedn_bal.amt_bal > 0)  and (allowdedn_bal.ref_type = 'L') \tand (loans.adjustable = 'Y') \tOrder by end_date ";
                                    pstmt1 = conn.prepareStatement(sql);
                                    pstmt1.setString(1, loanNo);
                                    pstmt1.setString(2, adCode);
                                    pstmt1.setDate(3, new Date(claimDate.getTime()));
                                    ++case1;
                                } else {
                                    sql = " Select ad_code, adj_perc, ref_no, start_date, end_date,  scheme_no, loan_amt, balance_amt, mon_inst, interest  from allowdedn_bal,loans Where ref_no = loan_no and allowdedn_bal.ref_no = ? and ad_code between '0' and 'z'  and amt_bal > 0 \tand ref_type = 'L' \t\tand adjustable = 'Y' \t\tOrder by start_date ";
                                    pstmt1 = conn.prepareStatement(sql);
                                    pstmt1.setString(1, loanNo);
                                    ++case2;
                                }
                                rs1 = pstmt1.executeQuery();
                                while (rs1.next()) {
                                    ++domID;
                                    loanAdCode = rs1.getString("ad_code");
                                    loanAdjPerc = rs1.getDouble("adj_perc");
                                    loanRefNo = rs1.getString("ref_no");
                                    startDate = rs1.getDate("start_date");
                                    endDate = rs1.getDate("end_date");
                                    schemeNo = rs1.getString("scheme_no");
                                    loanAmt = rs1.getDouble("loan_amt");
                                    loanBalAmt = rs1.getDouble("balance_amt");
                                    loanMonInst = rs1.getDouble("mon_inst");
                                    loanInterest = rs1.getDouble("interest");
                                    valueXmlString.append("<Detail3 domID='" + domID + "' selected=\"Y\">\r\n");
                                    valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n");
                                    valueXmlString.append("<tran_id/>");
                                    valueXmlString.append("<ref_no><![CDATA[").append(loanRefNo).append("]]></ref_no>\r\n");
                                    valueXmlString.append("<ad_code><![CDATA[").append(loanAdCode).append("]]></ad_code>\r\n");
                                    valueXmlString.append("<eff_date><![CDATA[").append(sdf.format(startDate)).append("]]></eff_date>\r\n");
                                    valueXmlString.append("<bal_amt><![CDATA[").append(loanBalAmt).append("]]></bal_amt>\r\n");
                                    if (balanceAmt > 0.0) {
                                        double temp = claimTotalAmt * loanAdjPerc / 100.0;
                                        if (temp > loanBalAmt) {
                                            temp = loanBalAmt;
                                        }
                                        if (temp >= balanceAmt) {
                                            valueXmlString.append("<adj_amt><![CDATA[").append(balanceAmt).append("]]></adj_amt>\r\n");
                                        } else {
                                            valueXmlString.append("<adj_amt><![CDATA[").append(temp).append("]]></adj_amt>\r\n");
                                        }
                                        balanceAmt -= temp;
                                    } else {
                                        valueXmlString.append("<adj_amt><![CDATA[0]]></adj_amt>\r\n");
                                    }
                                    valueXmlString.append("<line_no><![CDATA[").append(domID).append("]]></line_no>\r\n");
                                    valueXmlString.append("<ref_type><![CDATA[").append("L").append("]]></ref_type>\r\n");
                                    valueXmlString.append("<scheme_no><![CDATA[").append(schemeNo).append("]]></scheme_no>\r\n");
                                    valueXmlString.append("<start_date><![CDATA[").append(sdf.format(startDate)).append("]]></start_date>\r\n");
                                    valueXmlString.append("<end_date><![CDATA[").append(sdf.format(endDate)).append("]]></end_date>\r\n");
                                    valueXmlString.append("<loan_amt><![CDATA[").append(loanAmt).append("]]></loan_amt>\r\n");
                                    valueXmlString.append("<adj_perc><![CDATA[").append(loanAdjPerc).append("]]></adj_perc>\r\n");
                                    valueXmlString.append("<mon_inst><![CDATA[").append(loanMonInst).append("]]></mon_inst>\r\n");
                                    valueXmlString.append("<interest><![CDATA[").append(loanInterest).append("]]></interest>\r\n");
                                    valueXmlString.append("</Detail3>\r\n");
                                }
                                rs1.close();
                                rs1 = null;
                                pstmt1.close();
                                pstmt1 = null;
                            }
                            rs.close();
                            rs = null;
                            pstmt.close();
                            pstmt = null;
                            break;
                        }
                        System.out.println("loan tab diable");
                        valueXmlString.append("<Detail3 domID='1' selected=\"N\">n</Detail3>");
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Exception :PerlClaimIc :default_ItemChanged(Document,String):" + e.getMessage() + ":");
                valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                System.out.println("Exception :PerlClaimIc:default_ItemChanged :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        valueXmlString.append("</Root>\r\n");
        System.out.println("\n****ValueXmlString :" + valueXmlString.toString() + ":********");
        return valueXmlString.toString();
    }

    private String checkNull(String inputVal) {
        if (inputVal == null) {
            inputVal = "";
        }
        return inputVal;
    }

    private String getAttribValue(Node detailNode, String nodeName, String attribStr) {
        String attribValue = "";
        try {
            String domStr = GenericUtility.getInstance().serializeDom(detailNode);
            Document dom = GenericUtility.getInstance().parseString(domStr);
            if (dom != null) {
                Node attributeNode = dom.getElementsByTagName(nodeName).item(0);
                attribValue = this.getAttribValue(attributeNode, attribStr);
            }
        }
        catch (Exception e) {
            System.out.println("Exception : getAttribValue :" + e.getMessage());
        }
        return attribValue;
    }

    private String getAttribValue(Node detailNode, String attribStr) {
        String attribValue = "";
        try {
            Node attribNode;
            if (detailNode != null && detailNode.getAttributes() != null && (attribNode = detailNode.getAttributes().getNamedItem(attribStr)) != null) {
                attribValue = this.checkNull(attribNode.getNodeValue());
            }
        }
        catch (Exception e) {
            System.out.println("Exception : getAttribValue :" + e.getMessage());
        }
        return attribValue;
    }
}

