package ibase.webitm.ejb.adm;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

import ibase.system.config.ConnDriver;
import ibase.utility.GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Session Bean implementation class BusinessUnits
 */
@Stateless
public class EmpMaritalStatusIC extends ValidatorEJB implements EmpMaritalStatusICLocal, EmpMaritalStatusICRemote 
{
	public String itemChanged() throws RemoteException, ITMException 
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";

		try 
		{
			if (xmlString != null && xmlString.trim().length() != 0) 
			{
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) 
			{
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) 
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception : BusinessUnits : [itemChanged(String, xmlString)] :==>\n" + e.getMessage());
			e.printStackTrace();
		}
		return valueXmlString;
	}
	
	public String itemChanged(Document dom, Document dom1, Document dom2,
			String objContext, String currentColumn, String editFlag,
			String xtraParams) throws RemoteException, ITMException 
	{
		System.out.println("@V@ In Item change...");
		GenericUtility genericUtility = null;
		Connection conn = null;
		int currentFormNo = 0;
		ResultSet rs = null;
		String empCodeHead = "", empFName = "", empMName = "", empLName = "",empMaritalChgEmpFname="",empMaritalChgEmpMname="",empMaritalChgEmpLname="",
				shortName="",empFnameO="",empMnameO="",empLnameO="",shortNameO="",lsSex="",lsNewStatus="",empCode="",sql="",mStatus="",sex="",
						spouseName="",mStatDate="";
		String mStatDateStr="";
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString;
		try 
		{
			valueXmlString = new StringBuffer();
			genericUtility = GenericUtility.getInstance();
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDateStr = sdf.format(currentDate.getTime());

			valueXmlString = new StringBuffer(
					"<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			switch (currentFormNo) 
			{
				case 1:
					valueXmlString.append("<Detail1>\r\n");
					if(currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
					{
						//Modified by Ahmed on 03/May/2017 to only replace for null value [start]
/*						empMaritalChgEmpFname=checkNull(genericUtility.getColumnValue("emp_maritalchg_emp_fname", dom));
						empMaritalChgEmpMname=checkNull(genericUtility.getColumnValue("emp_maritalchg_emp_mname", dom));
						empMaritalChgEmpLname=checkNull(genericUtility.getColumnValue("emp_maritalchg_emp_lname", dom));
						shortName=checkNull(genericUtility.getColumnValue("short_name", dom));
						empFnameO=checkNull(genericUtility.getColumnValue("emp_fname__o", dom));
						empMnameO=checkNull(genericUtility.getColumnValue("emp_mname__o", dom));
						empLnameO=checkNull(genericUtility.getColumnValue("emp_lname__o", dom));
						shortNameO=checkNull(genericUtility.getColumnValue("short_name__o", dom));
						spouseName=checkNull(genericUtility.getColumnValue("spouse_name", dom));*/
						empMaritalChgEmpFname=replaceNull(genericUtility.getColumnValue("emp_maritalchg_emp_fname", dom));
						empMaritalChgEmpMname=replaceNull(genericUtility.getColumnValue("emp_maritalchg_emp_mname", dom));
						empMaritalChgEmpLname=replaceNull(genericUtility.getColumnValue("emp_maritalchg_emp_lname", dom));
						shortName=replaceNull(genericUtility.getColumnValue("short_name", dom));
						empFnameO=replaceNull(genericUtility.getColumnValue("emp_fname__o", dom));
						empMnameO=replaceNull(genericUtility.getColumnValue("emp_mname__o", dom));
						empLnameO=replaceNull(genericUtility.getColumnValue("emp_lname__o", dom));
						shortNameO=replaceNull(genericUtility.getColumnValue("short_name__o", dom));
						spouseName=replaceNull(genericUtility.getColumnValue("spouse_name", dom));
						//Modified by Ahmed on 03/AMY/2017 to only replace for null value[end]
						
						valueXmlString.append("<emp_maritalchg_emp_fname protect=\"1\">").append("<![CDATA[" + empMaritalChgEmpFname+ "]]>").append("</emp_maritalchg_emp_fname>");
						valueXmlString.append("<emp_maritalchg_emp_mname protect=\"1\">").append("<![CDATA[" + empMaritalChgEmpMname+ "]]>").append("</emp_maritalchg_emp_mname>");
						valueXmlString.append("<emp_maritalchg_emp_lname protect=\"1\">").append("<![CDATA[" + empMaritalChgEmpLname+ "]]>").append("</emp_maritalchg_emp_lname>");
						valueXmlString.append("<short_name protect=\"1\">").append("<![CDATA[" + shortName+ "]]>").append("</short_name>");
						valueXmlString.append("<emp_fname__o protect=\"1\">").append("<![CDATA[" + empFnameO+ "]]>").append("</emp_fname__o>");
						valueXmlString.append("<emp_mname__o protect=\"1\">").append("<![CDATA[" + empMnameO+ "]]>").append("</emp_mname__o>");
						valueXmlString.append("<emp_lname__o protect=\"1\">").append("<![CDATA[" + empLnameO+ "]]>").append("</emp_lname__o>");
						valueXmlString.append("<short_name__o protect=\"1\">").append("<![CDATA[" + shortNameO+ "]]>").append("</short_name__o>");
						
						lsSex=checkNull(genericUtility.getColumnValue("sex", dom));
						lsNewStatus=checkNull(genericUtility.getColumnValue("new_status", dom));
						System.out.println("@V@ SEX of employee :- ["+lsSex+"]");
						if((lsSex!=null && lsSex.trim().length()>0) && ("F".equalsIgnoreCase(lsSex)))
						{
//							if((lsNewStatus!=null && lsNewStatus.trim().length()>0) && ("M".equalsIgnoreCase(lsNewStatus) || "D".equalsIgnoreCase(lsNewStatus)))
							if((lsNewStatus!=null && lsNewStatus.trim().length()>0) && ("M".equalsIgnoreCase(lsNewStatus))) // CHANGE done as per suggested by P Jain.
							{
								valueXmlString.append("<emp_maritalchg_emp_fname protect=\"0\">").append("<![CDATA[" + empMaritalChgEmpFname+ "]]>").append("</emp_maritalchg_emp_fname>");
								valueXmlString.append("<emp_maritalchg_emp_mname protect=\"0\">").append("<![CDATA[" + empMaritalChgEmpMname+ "]]>").append("</emp_maritalchg_emp_mname>");
								valueXmlString.append("<emp_maritalchg_emp_lname protect=\"0\">").append("<![CDATA[" + empMaritalChgEmpLname+ "]]>").append("</emp_maritalchg_emp_lname>");
								valueXmlString.append("<short_name protect=\"0\">").append("<![CDATA[" + shortName+ "]]>").append("</short_name>");
								valueXmlString.append("<spouse_name protect=\"0\">").append("<![CDATA["+spouseName+"]]>").append("</spouse_name>");
							}
							else
							{
								valueXmlString.append("<emp_maritalchg_emp_fname protect=\"1\">").append("<![CDATA[" + empMaritalChgEmpFname+ "]]>").append("</emp_maritalchg_emp_fname>");
								valueXmlString.append("<emp_maritalchg_emp_mname protect=\"1\">").append("<![CDATA[" + empMaritalChgEmpMname+ "]]>").append("</emp_maritalchg_emp_mname>");
								valueXmlString.append("<emp_maritalchg_emp_lname protect=\"1\">").append("<![CDATA[" + empMaritalChgEmpLname+ "]]>").append("</emp_maritalchg_emp_lname>");
								valueXmlString.append("<short_name protect=\"1\">").append("<![CDATA[" + shortName+ "]]>").append("</short_name>");
								valueXmlString.append("<spouse_name protect=\"1\">").append("<![CDATA["+spouseName+"]]>").append("</spouse_name>");
							}
						}
						else
						{
							if((lsNewStatus!=null && lsNewStatus.trim().length()>0) && ("M".equalsIgnoreCase(lsNewStatus))) // Chnage done as per suggested by P Jain,
							{
								valueXmlString.append("<spouse_name protect=\"0\">").append("<![CDATA["+spouseName+"]]>").append("</spouse_name>");
							}
							else
							{
								valueXmlString.append("<spouse_name protect=\"1\">").append("<![CDATA["+spouseName+"]]>").append("</spouse_name>");
							}
						}
					}
					else if(currentColumn.trim().equalsIgnoreCase("itm_default"))
					{
						System.out.println("@V@ In Item default ..");
						valueXmlString.append("<tran_date >").append("<![CDATA[" + sysDateStr+ "]]>").append("</tran_date>");
						valueXmlString.append("<emp_maritalchg_emp_fname protect=\"1\">").append("<![CDATA[]]>").append("</emp_maritalchg_emp_fname>");
						valueXmlString.append("<emp_maritalchg_emp_mname protect=\"1\">").append("<![CDATA[]]>").append("</emp_maritalchg_emp_mname>");
						valueXmlString.append("<emp_maritalchg_emp_lname protect=\"1\">").append("<![CDATA[]]>").append("</emp_maritalchg_emp_lname>");
						valueXmlString.append("<short_name protect=\"1\">").append("<![CDATA[]]>").append("</short_name>");
						valueXmlString.append("<emp_fname__o protect=\"1\">").append("<![CDATA[]]>").append("</emp_fname__o>");
						valueXmlString.append("<emp_mname__o protect=\"1\">").append("<![CDATA[]]>").append("</emp_mname__o>");
						valueXmlString.append("<emp_lname__o protect=\"1\">").append("<![CDATA[]]>").append("</emp_lname__o>");
						valueXmlString.append("<short_name__o protect=\"1\">").append("<![CDATA[]]>").append("</short_name__o>");
					}
					else if(currentColumn.trim().equalsIgnoreCase("emp_code"))
					{
						System.out.println("@V@ In emp code Item change ..");
						empCode=checkNull(genericUtility.getColumnValue("emp_code", dom));
						
						sql="select emp_lname, emp_fname,m_status, emp_mname, short_name,sex,m_status_date from employee where emp_code =?";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1, empCode);
						rs=pstmt.executeQuery();
						if(rs.next())
						{
							empLName=rs.getString("emp_lname");
							empFName=rs.getString("emp_fname");
							empMName=rs.getString("emp_mname");
							mStatus=rs.getString("m_status");
							shortName=rs.getString("short_name");
							sex=rs.getString("sex");
							mStatDate=rs.getString("m_status_date");
						}
						pstmt.close();
						pstmt=null;
						rs.close();
						rs=null;
						
						System.out.println("@V@ At emp code item change fname:- ["+empFName+"]");
						System.out.println("@V@ At emp code item change empMName:- ["+empMName+"]");
						System.out.println("@V@ At emp code item change empLName:- ["+empLName+"]");
						System.out.println("@V@ At emp code item change mStatus:- ["+mStatus+"]");
						System.out.println("@V@ At emp code item change shortName:- ["+shortName+"]");
						System.out.println("@V@ At emp code item change sex:- ["+sex+"]");
						
						valueXmlString.append("<emp_fname protect=\"1\">").append("<![CDATA[" + empFName+ "]]>").append("</emp_fname>");
						valueXmlString.append("<emp_lname protect=\"1\">").append("<![CDATA[" + empLName+ "]]>").append("</emp_lname>");
						valueXmlString.append("<old_status protect=\"1\">").append("<![CDATA[" + mStatus+ "]]>").append("</old_status>");
						valueXmlString.append("<emp_maritalchg_emp_fname protect=\"1\">").append("<![CDATA[" + empFName+ "]]>").append("</emp_maritalchg_emp_fname>");
						valueXmlString.append("<emp_maritalchg_emp_mname protect=\"1\">").append("<![CDATA[" + empMName+ "]]>").append("</emp_maritalchg_emp_mname>");
						valueXmlString.append("<emp_maritalchg_emp_lname protect=\"1\">").append("<![CDATA[" + empLName+ "]]>").append("</emp_maritalchg_emp_lname>");
						valueXmlString.append("<short_name protect=\"1\">").append("<![CDATA[" + shortName+ "]]>").append("</short_name>");
						
						if(mStatDate!=null && mStatDate.trim().length()>0)
						{
							mStatDateStr=genericUtility.getValidDateString(mStatDate,  genericUtility.getDBDateFormat(),
									genericUtility.getApplDateFormat());
							valueXmlString.append("<status_date__o protect=\"1\">").append("<![CDATA[" + mStatDateStr+ "]]>").append("</status_date__o>");
						}
						else
						{
							valueXmlString.append("<status_date__o protect=\"1\">").append("<![CDATA[]]>").append("</status_date__o>");
						}
						
						valueXmlString.append("<emp_fname__o protect=\"1\">").append("<![CDATA[" + empFName+ "]]>").append("</emp_fname__o>");
						valueXmlString.append("<emp_mname__o protect=\"1\">").append("<![CDATA[" + empMName+ "]]>").append("</emp_mname__o>");
						valueXmlString.append("<emp_lname__o protect=\"1\">").append("<![CDATA[" + empLName+ "]]>").append("</emp_lname__o>");
						valueXmlString.append("<short_name__o protect=\"1\">").append("<![CDATA[" + shortName+ "]]>").append("</short_name__o>");
						
						valueXmlString.append("<sex >").append("<![CDATA[" + sex+ "]]>").append("</sex>");
					}
					else if(currentColumn.trim().equalsIgnoreCase("new_status"))
					{
						lsNewStatus=checkNull(genericUtility.getColumnValue("new_status", dom));
						//Modified by Ahmed on 03/MAY/2017 to only replace for null value[start]
						/*empMaritalChgEmpFname=checkNull(genericUtility.getColumnValue("emp_maritalchg_emp_fname", dom));
						empMaritalChgEmpMname=checkNull(genericUtility.getColumnValue("emp_maritalchg_emp_mname", dom));
						empMaritalChgEmpLname=checkNull(genericUtility.getColumnValue("emp_maritalchg_emp_lname", dom));
						shortName=checkNull(genericUtility.getColumnValue("short_name", dom));
						spouseName=checkNull(genericUtility.getColumnValue("spouse_name", dom));*/
						empMaritalChgEmpFname=replaceNull(genericUtility.getColumnValue("emp_maritalchg_emp_fname", dom));
						empMaritalChgEmpMname=replaceNull(genericUtility.getColumnValue("emp_maritalchg_emp_mname", dom));
						empMaritalChgEmpLname=replaceNull(genericUtility.getColumnValue("emp_maritalchg_emp_lname", dom));
						shortName=replaceNull(genericUtility.getColumnValue("short_name", dom));
						spouseName=replaceNull(genericUtility.getColumnValue("spouse_name", dom));
						//Modified by Ahmed on 03/MAY/2017 to only replace for null value[end]
						sex=checkNull(genericUtility.getColumnValue("sex", dom));
						if("U".equalsIgnoreCase(lsNewStatus))
						{
							valueXmlString.append("<spouse_name >").append("<![CDATA[]]>").append("</spouse_name>");
						}
						if((sex!=null && sex.trim().length()>0) && ("F".equalsIgnoreCase(sex)))
						{
//							if((lsNewStatus!=null && lsNewStatus.trim().length()>0) && ("M".equalsIgnoreCase(lsNewStatus) || "D".equalsIgnoreCase(lsNewStatus)))
							if((lsNewStatus!=null && lsNewStatus.trim().length()>0) && ("M".equalsIgnoreCase(lsNewStatus))) // Chnage done as per suggested by P Jain,
							{
								valueXmlString.append("<emp_maritalchg_emp_fname protect=\"0\">").append("<![CDATA["+empMaritalChgEmpFname+"]]>").append("</emp_maritalchg_emp_fname>");
								valueXmlString.append("<emp_maritalchg_emp_mname protect=\"0\">").append("<![CDATA["+empMaritalChgEmpMname+"]]>").append("</emp_maritalchg_emp_mname>");
								valueXmlString.append("<emp_maritalchg_emp_lname protect=\"0\">").append("<![CDATA["+empMaritalChgEmpLname+"]]>").append("</emp_maritalchg_emp_lname>");
								valueXmlString.append("<short_name protect=\"0\">").append("<![CDATA["+shortName+"]]>").append("</short_name>");
								valueXmlString.append("<spouse_name protect=\"0\">").append("<![CDATA["+spouseName+"]]>").append("</spouse_name>");
							}
							else
							{
								empCode=checkNull(genericUtility.getColumnValue("emp_code", dom));
								
								sql="select emp_lname, emp_fname,m_status, emp_mname, short_name,sex,m_status_date from employee where emp_code =?";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1, empCode);
								rs=pstmt.executeQuery();
								if(rs.next())
								{
									empLName=rs.getString("emp_lname");
									empFName=rs.getString("emp_fname");
									empMName=rs.getString("emp_mname");
									mStatus=rs.getString("m_status");
									shortName=rs.getString("short_name");
									sex=rs.getString("sex");
									mStatDate=rs.getString("m_status_date");
								}
								pstmt.close();
								pstmt=null;
								rs.close();
								rs=null;
								
								valueXmlString.append("<emp_maritalchg_emp_fname protect=\"1\">").append("<![CDATA["+empFName+"]]>").append("</emp_maritalchg_emp_fname>");
								valueXmlString.append("<emp_maritalchg_emp_mname protect=\"1\">").append("<![CDATA["+empMName+"]]>").append("</emp_maritalchg_emp_mname>");
								valueXmlString.append("<emp_maritalchg_emp_lname protect=\"1\">").append("<![CDATA["+empLName+"]]>").append("</emp_maritalchg_emp_lname>");
								valueXmlString.append("<short_name protect=\"1\">").append("<![CDATA["+shortName+"]]>").append("</short_name>");
								valueXmlString.append("<spouse_name protect=\"1\">").append("<![CDATA["+spouseName+"]]>").append("</spouse_name>");
							}
						}
						else
						{
							if((lsNewStatus!=null && lsNewStatus.trim().length()>0) && ("M".equalsIgnoreCase(lsNewStatus))) // Chnage done as per suggested by P Jain,
							{
								valueXmlString.append("<spouse_name protect=\"0\">").append("<![CDATA["+spouseName+"]]>").append("</spouse_name>");
							}
							else
							{
								valueXmlString.append("<spouse_name protect=\"1\">").append("<![CDATA["+spouseName+"]]>").append("</spouse_name>");
							}
						}
					}
					valueXmlString.append ("</Detail1>\r\n");
					break;
				}
				
			} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		} 
		finally 
		{
			try 
			{
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			} catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("@V@ valueXmlString :- ["+valueXmlString+"]");
		return valueXmlString.toString();
	}
	
	public String wfValData() throws RemoteException, ITMException 
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try 
		{
			if (xmlString != null && xmlString.trim().length() != 0) 
			{
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) 
			{
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) 
			{
				dom2 = parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception : StdPayStru : wfValData(String xmlString) : ==>" + e.getMessage());
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		return (errString);
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2,
			String objContext, String editFlag, String xtraParams)
			throws RemoteException, ITMException 
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int currentFormNo = 0, childNodeListLength = 0;
		String userId = "";
		String childNodeName = null;
		String errString = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		String msgType = "",empCode="",tranDateStr="",sql="",lsSite="",newStatus="",oldStatus="",lsStatus="",empCodeAprv="",relieveDate="";
		int count=0;
		Timestamp tranDate=null;

		GenericUtility genericUtility = null;

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();

		try 
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);		
			
			genericUtility = GenericUtility.getInstance();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo) 
			{
				case 1:
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for (int ctr = 0; ctr < childNodeListLength; ctr++) 
					{
						childNode = childNodeList.item(ctr);
						if (childNode.getNodeType() != Node.ELEMENT_NODE) 
						{
							continue;
						}
						childNodeName = childNode.getNodeName();

						System.out.println("childNodeName.editFlag." + childNodeName + ".." + editFlag);
						System.out.println("@V@ Edit flag :- ["+editFlag+"");

						if (childNodeName.equalsIgnoreCase("emp_code")) 
						{
							empCode = checkNull(genericUtility.getColumnValue("emp_code", dom));
							tranDateStr=checkNull(genericUtility.getColumnValue("tran_date", dom));
							tranDate= Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDateStr, genericUtility.getApplDateFormat()
					        		,genericUtility.getDBDateFormat()));
							
							if("A".equalsIgnoreCase(editFlag))
							{
								/**
								 * Check un-confirmed transaction exist
								 * for employee 
								 * */
								sql = "select count(*) as cnt from emp_maritalchg" +
										" where (case when confirm is null then 'N' else confirm END ='N') and emp_code=?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, empCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt("cnt");
								}
								pstmt.close();
								pstmt=null;
								rs.close();
								rs=null;
								
								if(count>0)
								{
									errList.add("VTUNCFPND");
									errFields.add("emp_code");
								}
								
								/**
								 * Check already transaction exist 
								 * for emp_code and tran_date
								 * for employee 
								 * */
								sql="select count(*) as cnt from emp_maritalchg where emp_code =? and tran_date=?";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1, empCode);
								pstmt.setTimestamp(2, tranDate);
								rs=pstmt.executeQuery();
								if(rs.next())
								{
									count=rs.getInt("cnt");
								}
								pstmt.close();
								pstmt=null;
								rs.close();
								rs=null;
								if(count>0)
								{
									errList.add("VTALEXIST");
									errFields.add("emp_code");
								}
							}
							
							sql="select emp_site from employee where emp_code =?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1, empCode);
							rs=pstmt.executeQuery();
							if(rs.next())
							{
								lsSite=rs.getString("emp_site");
							}
							pstmt.close();
							pstmt=null;
							rs.close();
							rs=null;
							// Need method to find out.
							String errCode=gbfEmp(empCode,tranDate,lsSite,conn);
							if(errCode!=null && errCode.trim().length()>0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						} 
						else if (childNodeName.equalsIgnoreCase("new_status")) 
						{
							newStatus = checkNull(genericUtility.getColumnValue("new_status", dom));
							oldStatus = checkNull(genericUtility.getColumnValue("old_status", dom));
							empCode = checkNull(genericUtility.getColumnValue("emp_code", dom));
							
							if(newStatus!=null && newStatus.trim().length()>0)
							{
								if("U".equalsIgnoreCase(oldStatus))
								{
									if("D".equalsIgnoreCase(newStatus) || "S".equalsIgnoreCase(newStatus) || "K".equalsIgnoreCase(newStatus))
									{
										errList.add("VTSTAT1");
										errFields.add(childNodeName.toLowerCase());
									}
								}
								else
								{
									if("M".equalsIgnoreCase(oldStatus) || "D".equalsIgnoreCase(oldStatus) || "S".equalsIgnoreCase(oldStatus))
									{
										if("U".equalsIgnoreCase(newStatus) || "K".equalsIgnoreCase(newStatus))
										{
											errList.add("VTSTAT2");
											errFields.add(childNodeName.toLowerCase());
										}										
									}
								}
								if(newStatus.equalsIgnoreCase(oldStatus))
								{
									errList.add("VTSTATE3");
									errFields.add(childNodeName.toLowerCase());
								}
							}
							else
							{
								errList.add("VTSTAT");
								errFields.add(childNodeName.toLowerCase());
							}
							if(errList.size()==0)
							{
								sql="select case when status is null then ' ' else status end from employee where EMP_CODE =?";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1, empCode);
								rs=pstmt.executeQuery();
								if(rs.next())
								{
									lsStatus=rs.getString("status");
								}
								pstmt.close();
								pstmt=null;
								rs.close();
								rs=null;
								
								if(lsStatus!=null && lsStatus.trim().length() !=0)
								{
									errList.add("VTINAEMP");
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
						else if (childNodeName.equalsIgnoreCase("emp_code__aprv")) 
						{
							empCodeAprv = checkNull(genericUtility.getColumnValue("emp_code__aprv", dom));
							empCode = checkNull(genericUtility.getColumnValue("emp_code", dom));
							
							if(empCodeAprv!=null && empCodeAprv.trim().length()>0)
							{
								sql="select count(*) as cnt,RELIEVE_DATE from employee where emp_code = ? group by RELIEVE_DATE";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1, empCodeAprv);
								rs=pstmt.executeQuery();
								if(rs.next())
								{
									count=rs.getInt("cnt");
									relieveDate=rs.getString("RELIEVE_DATE");
								}
								pstmt.close();
								pstmt=null;
								rs.close();
								rs=null;
								
								if(count==0)
								{
									errList.add("VMEMP1");
									errFields.add(childNodeName.toLowerCase());
								}
								if(relieveDate!=null && relieveDate.trim().length()!=0)
								{
									errList.add("VMEMPV");
									errFields.add(childNodeName.toLowerCase());
								}
								if(empCodeAprv.equalsIgnoreCase(empCode))
								{
									errList.add("VMEMP4");
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
					}
					break;
				}

				int errListSize = errList.size();
				StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");

				//ERRORLIST
				if (errList != null && errListSize > 0) 
				{
					for (int cnt = 0; cnt < errListSize; cnt++) 
					{
						String errCode = (String) errList.get(cnt);
						String errFldName = (String) errFields.get(cnt);
						System.out.println("errCode .........." + errCode);

						errString = getErrorString(errFldName, errCode, userId);
						System.out.println("errString is : ::::>>>> " + errString);
						msgType = errorType(conn, errCode);
						if (errString.length() > 0)
						{
							String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
							bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							System.out.println("errStringXml .........." + errStringXml);
							errString = "";
						}
						if (msgType.equalsIgnoreCase("E")) 
						{
							break;
						}
					}
					errList.clear();
					errList = null;
					errFields.clear();
					errFields = null;

					errStringXml.append("</Errors></Root>\r\n");
				} 
				else 
				{
					errStringXml = new StringBuffer("");
				}
				errString = errStringXml.toString();
			} 
			
			catch (Exception e) 
			{
				System.out.println("Exception ::" + e);
				e.printStackTrace();
				errString = e.getMessage();
			} 
			finally 
			{
				try 
				{
					if (conn != null) 
					{
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						conn.close();
					}
					conn = null;
				} 
				catch (Exception d) 
				{
					d.printStackTrace();
				}
			}
			System.out.println("ErrString ::" + errString);
			return errString;
	}
	
	private String gbfEmp(String empCode, Timestamp tranDate, String lsSite, Connection conn) 
	{
		// TODO Auto-generated method stub
		String errCode="",sql="",status="";
		Timestamp relieveDate=null;
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		
		try {
			sql="select relieve_date, status from employee where emp_code = ?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				relieveDate=rs.getTimestamp("relieve_date");
				status=rs.getString("status");
			}
			else
			{
				errCode="VMEMP1";
			}
			pstmt.close();
			pstmt=null;
			rs.close();
			rs=null;
			
			if(relieveDate !=null && relieveDate.before(tranDate) && "S".equalsIgnoreCase(status))
			{
				errCode="VMEMP2";
			}
			
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return errCode;
	}

	private String errorType(Connection conn, String errorCode) throws ITMException 
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try 
		{
			String sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next()) 
			{
				msgType = rs.getString("MSG_TYPE");
			}
		} 
		catch (Exception ex) 
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		finally 
		{
			try 
			{
				if (rs != null) 
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}
	
	private String checkNull(String input) 
	{
		if (input == null) 
		{
			input = "";
		} 
		else 
		{
			input = input.trim();
		}
		return input;
	}
	
	//Modified by Ahmed on 03/MAY/2017[This method is used to only replace for null value][START]
		private String replaceNull(String input)
		{
			if (input == null)
			{
				input = "";
			}
			return input;
		}
		//Modified by Ahmed on 03/MAY/2017[This method is used to only replace for null value][END]
	
}
