/*
 * Copyright 2007
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gwtwidgets.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.ui.HTML;


/**
 * Renders the contents of an HTML file as a widget.
 * HTMLInclude is a simple subclass of the GWT provided
 * HTML widget, the difference being that you provide a URL
 * to the content in the constructor instead of supplying
 * the actual content in your code. The intended purpose is
 * to keep code clean by keeping verbose HTML content
 * out of the Java source and in seperate HTML files that
 * can be included at run time.
 * 
 * @author rhanson
 */
public class HTMLInclude extends HTML
{
    public HTMLInclude (final String url)
    {
        super();
        final HTMLInclude widget = this;
        try {
            new RequestBuilder(RequestBuilder.GET, url).sendRequest("", new RequestCallback()
            {
                public void onError (Request request, Throwable exception)
                {
                    GWT.log("HTMLInclude: error fetching " + url, exception);
                }

                public void onResponseReceived (Request request, Response response)
                {
                    if (response.getStatusCode() == 200) {
                        widget.setHTML(response.getText());
                    }
                    else {
                        GWT.log("HTMLInclude: bad code when fetching " + url + "[" + response.getStatusCode() + "]",
                                null);
                    }
                }
            });
        }
        catch (RequestException e) {
            GWT.log("HTMLInclude: exception thrown fetching " + url, e);
        }
    }
}
