 /* 
	Developed by : Niraja
	Company : Base Information Management Pvt. Ltd
	Version : 1.0
	Date : 28/09/2005
	Window Name : w_voucher
    Button Name : Release
	Action      : Hold on voucher will be released .e it will update MISC_PAYABLES Table
				  as per the conditions.	.
*/
package ibase.webitm.ejb.fin.adv;

import java.rmi.RemoteException;
import java.sql.*;
import javax.ejb.*;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3

public class VoucherRls extends ActionHandlerEJB implements VoucherRlsLocal,VoucherRlsRemote //SessionBean
{
	/*public void ejbCreate() throws RemoteException, CreateException 
	{
	}

	public void ejbRemove()
	{
	}

	public void ejbActivate() 
	{
	}

	public void ejbPassivate() 
	{
	}*/

	public String actionHandler() throws RemoteException,ITMException
	{
		return "";
	}

	public String actionHandler(String tranID, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("VoucherRlsEJB:actionHandler called");
		String  retString = null;
		try
		{
			retString = actionRelease(tranID,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :VoucherRlsEJB :actionHandler:" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning from VoucherRlsEJB actionHandler"+retString);
		return (retString);
	}

	private String actionRelease(String tranID,  String xtraParams)throws ITMException
	{
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		String errCode="";
		String errString="";
		String sql = "";
		String updSql = "";
		String confirmed = null;
		int rows=0;
		float totAmt=0;
		float adjAmt=0;
		float holdAmt=0;
		float balAmt=0;
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		ConnDriver connDriver = new ConnDriver();
		try
		{	
			conn = connDriver.getConnectDB("DriverITM");		
			stmt = conn.createStatement();
			sql="SELECT CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END CONF FROM VOUCHER WHERE TRAN_ID = '"+tranID+"'";
			rs = stmt.executeQuery(sql);
			if(rs.next())
			{
				confirmed = rs.getString("CONF");
			}
			if (confirmed.equalsIgnoreCase("Y"))
			{
				sql="SELECT TOT_AMT, ADJ_AMT, CASE WHEN HOLD_AMT IS NULL THEN 0 ELSE HOLD_AMT END AS HOLD_AMT  "+
				     " FROM MISC_PAYABLES WHERE TRAN_SER = 'VOUCH' and ref_no = '"+tranID+"'";
				rs = stmt.executeQuery(sql);
				if(rs.next())
				{
					totAmt=rs.getFloat("TOT_AMT");
					adjAmt=rs.getFloat("ADJ_AMT");
					holdAmt=rs.getFloat("HOLD_AMT");
				}
				balAmt = totAmt-adjAmt;
				if(balAmt == 0)
				{
					errCode = "VTBAL2";  // already paid off
				}
				else if(adjAmt != 0 && adjAmt != totAmt)
				{
					errCode = "VTBAL2"; // partly paid off
				}			
				else if (holdAmt > 0) 
				{
					updSql="UPDATE MISC_PAYABLES SET HOLD_AMT = 0 WHERE TRAN_SER = 'VOUCH' AND REF_NO = '"+tranID+"'";
					rows=stmt.executeUpdate(updSql) ;					
				}
				else
				{
					errCode="VTHOLD3";
				}
			}//end if confirmed "Y"
			else
			{
				errCode="UNCONTRAN";
			}
			if(errCode.trim().length() == 0 && rows > 0)
			{
				errCode="VTHOLD1";
				conn.commit();
				System.out.println("\n <==== Transaction Updated Successfully ====>");

			} 
			if (errCode != null  && errCode.trim().length() > 0)
			{
				errString = itmDBAccessEJB.getErrorString("", errCode, "", "", conn);
			}
			
		}
		catch(Exception e)
		{
			System.out.println("Exception :VoucherRlsEJB :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Closing Connection.......");
				conn.close();
				conn = null;
			}catch(Exception e){}			
		}
		return errString;
	}
}