
/********************************************************
	Title : QcOrderAprvIc
	Date  : 06/07/11
	Author: Janardhan.B
 ********************************************************/

package ibase.webitm.ejb.mfg;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless // added for ejb3

// QcOrderAprvIc is for the item change of site code in Qc Order Filter window

public class QcOrderAprvIc extends ValidatorEJB implements QcOrderAprvIcLocal, QcOrderAprvIcRemote 
{

	GenericUtility genericUtility = GenericUtility.getInstance();

	public String itemChanged(String xmlString, String xmlString1, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("In itemChanged QcOrderAprvIc:");
		Document dom = null;
		Document dom1 = null;
		String valueXmlString = "";
		try
		{
			dom = genericUtility.parseString(xmlString);
			dom1 = genericUtility.parseString(xmlString1);
			System.out.println("In itemChangeddom:"+dom);
			System.out.println("In itemChangeddom1:"+dom1);
			valueXmlString = itemChanged(dom,dom1,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : In Itemchange of QcOrderAprvIc ::"+e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, String objContext,String currentColumn, String editFlag, String xtraParams)throws RemoteException, ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String columnValue = null;
		String loginSiteCode = "";

		Connection conn = null;
		int ctr=0;
		int currentFormNo = 0 ;
		ConnDriver connDriver = new ConnDriver();

		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver=null;
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			valueXmlString.append("<Detail>");

			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				int childNodeListLength = childNodeList.getLength();
				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));

				// START - itmchange for site code
				if (currentColumn.trim().equals("itm_default") )
				{
					loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
					System.out.println("login site code is::"+loginSiteCode);
					valueXmlString.append("<site_code protect =\"1\">").append("<![CDATA["+loginSiteCode.trim()+"]]>").append("</site_code>");
				}
				valueXmlString.append("</Detail>");
				break;
			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception in QcOrderAprvIc ::"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}

			}catch(Exception d)
			{
				d.printStackTrace();
			}
		}
		return valueXmlString.toString();
	}

	@Override
	public String wfValData(String arg0, String arg1, String arg2, String arg3,
			String arg4) throws RemoteException, ITMException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String wfValData(Document arg0, Document arg1, String arg2,
			String arg3, String arg4) throws RemoteException, ITMException {
		// TODO Auto-generated method stub
		return null;
	}
}
