
package ibase.webitm.ejb.dis;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class SecSalesGenIc extends ValidatorEJB implements SecSalesGenIcRemote,SecSalesGenIcLocal {

	GenericUtility genericUtility = GenericUtility.getInstance();
	
	public String wfValData(String currFrmXmlStr, String hdrFrmXmlStr,String allFrmXmlStr, String objContext, String editFlag,String xtraParams) throws RemoteException 
	{
		System.out.println("In wfValData");
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = "";
		try 
		{
			System.out.println("currFrmXmlStr..." + currFrmXmlStr);
			System.out.println("hdrFrmXmlStr..." + hdrFrmXmlStr);
			System.out.println("allFrmXmlStr..." + allFrmXmlStr);
			if ((currFrmXmlStr != null) && (currFrmXmlStr.trim().length() != 0)) 
			{
				currDom = parseString(currFrmXmlStr);
			}
			if ((hdrFrmXmlStr != null) && (hdrFrmXmlStr.trim().length() != 0)) 
			{
				hdrDom = parseString(hdrFrmXmlStr);
			}
			if ((allFrmXmlStr != null) && (allFrmXmlStr.trim().length() != 0)) 
			{
				allDom = parseString(allFrmXmlStr);
			}
			errString = validate(currDom, hdrDom, allDom, objContext, editFlag, xtraParams);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception : [SecSalesGenIc][wfValData(String currFrmXmlStr)] : ==>\n" + e.getMessage());
		}
		return errString;
	}

	public String validate(Document currDom, Document hdrDom, Document allDom,String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException 
	{
		System.out.println("In validate Data");
		GenericUtility genericUtility = GenericUtility.getInstance();

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		int count = 0;
		String errString = "";
		String errorType = "";
		String errCode = "";
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String childNodeName = "";
		String sql = "";
		int noOfChilds = 0;
		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		int currentFormNo = 0;
		int cnt = 0;
		ConnDriver connDriver = null;
		Node childNode = null;
		Timestamp frDate=null,toDate=null;
		String itemSer="",prdCode="",loginSiteCode = "",countryCode="",isPrdClosed="";
		try {
			System.out.println("************xtraParams*************" + xtraParams);
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			System.out.println("In wfValData Distribution receipt:::");
			String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			loginSiteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode"));
			System.out.println("**************loginCode************" + userId);
			
			if ((objContext != null) && (objContext.trim().length() > 0)) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			NodeList parentList = currDom.getElementsByTagName("Detail"+ currentFormNo);
			NodeList childList = null;
			System.out.println("hdrDom..." + hdrDom.toString());
			switch (currentFormNo)
			{
			case 1:
			{
				childList = parentList.item(0).getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++) 
				{
					childNode = childList.item(ctr);
					if (childNode.getNodeType() != 1) 
					{
						continue;
					}
					childNodeName = childNode.getNodeName();
					System.out.println("Editflag =" + editFlag);
					System.out.println("parentList = " + parentList);
					System.out.println("childList = " + childList);
					if ("prd_code".equalsIgnoreCase(childNodeName) ) 
					{
						prdCode = checkNull(genericUtility.getColumnValue("prd_code", currDom));
						if(prdCode==null || prdCode.trim().length()==0)
						{
							errList.add("VTNULLPCG");//Invalid-Period code can not be blank 
							errFields.add(childNodeName.toLowerCase());
							break;
						}
					}
					if ("item_ser".equalsIgnoreCase(childNodeName) ) 
					{
						itemSer = checkNull(genericUtility.getColumnValue("item_ser", currDom));
						prdCode = checkNull(genericUtility.getColumnValue("prd_code", currDom));
						if(itemSer==null || itemSer.trim().length()==0)
						{
							errList.add("VTNULLDVG");//Invalid-Division can not be blank 
							errFields.add(childNodeName.toLowerCase());
							break;
						}
						else if(itemSer!=null || itemSer.trim().length()>0)
						{

							sql = "SELECT COUNT(*) AS COUNT FROM ITEMSER WHERE ITEM_SER = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, itemSer);
							rs = pstmt.executeQuery();
							if (rs.next()) 
							{
								count = rs.getInt("COUNT");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							System.out.println("Count: " + count);
							if (count == 0) 
							{
								errList.add("VTINVDVG");//Invalid-Division Does not exist
								errFields.add(childNodeName.toLowerCase());
								break;
							}
							
							sql= "select count_code from state where " +
									"state_code in (select state_code from site where site_code=?)";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, loginSiteCode );
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								countryCode = checkNull(rs.getString("count_code")).trim();
								System.out.println("countryCode >>> :"+countryCode);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							sql = "select count(*) from period_appl a,period_tbl b " +
									"where a.ref_code=a.prd_tblno and a.prd_tblno=b.prd_tblno " +
									" AND b.prd_code = ? " +
									"and b.prd_tblno=? " +
									"AND case when a.type is null then 'X' else a.type end='S' ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,prdCode.trim());
							pstmt.setString(2,countryCode+"_"+itemSer.trim());
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if (cnt == 0)
							{
								System.out.println("Error :Period not exist in period_tbl master ");
								errCode = "VTINVPCG";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								sql = "select b.FR_DATE as FR_DATE,b.TO_DATE as TO_DATE " +
										",b.entry_start_dt as entry_start_dt" +
										",b.entry_end_dt as entry_end_dt ,b.prd_closed" +
										" from period_appl a,period_tbl b " +
										"where a.ref_code=a.prd_tblno and a.prd_tblno=b.prd_tblno " +
										" AND b.prd_code = ? " +
										"and b.prd_tblno=? " +
										"AND case when a.type is null then 'X' else a.type end='S' ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,prdCode.trim());
								pstmt.setString(2,countryCode+"_"+itemSer.trim());	
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									frDate=rs.getTimestamp("FR_DATE");
									toDate=rs.getTimestamp("TO_DATE");
									isPrdClosed = rs.getString("prd_closed");
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								
								if("N".equalsIgnoreCase(isPrdClosed))
								{
									errCode = "VMPRDNCL";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						
						}
						
						if((itemSer!=null || itemSer.trim().length()>0) && (prdCode!=null || prdCode.trim().length()>0))
						{
							sql = "SELECT count(*) FROM" +
									" (SELECT POS_CODE,CUST_CODE FROM ORG_STRUCTURE_CUST WHERE VERSION_ID = (SELECT FN_GET_VERSION_ID FROM DUAL) AND TABLE_NO= ? " +
									" AND EFF_DATE < ?  AND VALID_UPTO > ? and case when source is null then 'Y' else source end <> 'A' " +
									" MINUS " +
									" SELECT POS_CODE,CUST_CODE FROM CUST_STOCK WHERE PRD_CODE = ? AND POS_CODE IS NOT NULL AND ITEM_SER = ? ) ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, itemSer);
									pstmt.setTimestamp(2, frDate);
									pstmt.setTimestamp(3, toDate);
									pstmt.setString(4, prdCode);
									pstmt.setString(5, itemSer);
									rs = pstmt.executeQuery();
								if (rs.next()) 
								{
									count = rs.getInt(1);
								}
								System.out.println("Count: " + count);
								if (count == 0) 
								{
									errList.add("VTINVSELG");//Record Not found
									errFields.add(childNodeName.toLowerCase());
									break;
								}
						}
					}
				}//for
			}//switch
			break;
			}
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = "";
			if ((errList != null) && (errListSize > 0)) 
			{
				for (cnt = 0; cnt < errListSize; cnt++) 
				{
					errCode = (String) errList.get(cnt);
					errFldName = (String) errFields.get(cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType = errorType(conn, errCode);
					if (errString.length() > 0) 
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........." + errStringXml);
						errString = "";
					}
					if (errorType.equalsIgnoreCase("E")) 
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors></Root>\r\n");
			}
			else 
			{
				errStringXml = new StringBuffer("");
			}
			errString = errStringXml.toString();
		}
		catch (Exception e) 
		{
			System.out.println("Exception in "+this.getClass().getSimpleName()+"  == >");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				callPstRs(pstmt, rs);
				if ((conn != null) && (!conn.isClosed()))
					conn.close();
			}
			catch (Exception e) 
			{
				System.out.println("Exception :"+this.getClass().getSimpleName()+":wfValData :==>\n" + e.getMessage());
				throw new ITMException(e);
			}
		}
		return errString;
	}
	
		
	public void callPstRs(PreparedStatement pstmt, ResultSet rs) 
	{
		try 
		{
			if (pstmt != null) 
			{
				pstmt.close();
				pstmt = null;
			}
			if (rs != null) 
			{
				rs.close();
				rs = null;
			}
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
		}
	}

	private String checkNull(String input)
	{
		return input == null ? "" : input.trim();
	}
	
	private String errorType(Connection conn, String errorCode) 
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try 
		{
			String sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next())
				msgType = rs.getString("MSG_TYPE");
		}
		catch (Exception ex) 
		{
			ex.printStackTrace();
			try 
			{
				callPstRs(pstmt, rs);
			}
			catch (Exception e) 
			{
				e.printStackTrace();
			}
			try 
			{
				callPstRs(pstmt, rs);
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		finally 
		{
			try 
			{
				callPstRs(pstmt, rs);
			}
			catch (Exception e) 
			{
				e.printStackTrace();
			}
		}
		return msgType;
	}
}
