package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.B2CS;

public class B2CSSerializer extends BaseSerializer<B2CS>
{
	@Override
	public void serialize(B2CS b2cs, JsonGenerator json, SerializerProvider serializerProvider)throws IOException, JsonProcessingException 
	{
		json.writeStartObject();
		
		json.writeStringField("state_cd", b2cs.stateCode);
		json.writeStringField("ty", b2cs.ty);
		json.writeStringField("hsn_sc", b2cs.itemOrServiceCode);
		json.writeNumberField("txval", b2cs.txval);
		json.writeNumberField("irt", b2cs.irt);
		json.writeNumberField("iamt", b2cs.iamt);
		json.writeNumberField("crt", b2cs.crt);
		json.writeNumberField("camt", b2cs.camt);
		json.writeNumberField("srt", b2cs.srt);
		json.writeNumberField("samt", b2cs.samt);
		json.writeNumberField("csrt", b2cs.csrt);
		json.writeNumberField("csamt", b2cs.csamt);
		
		json.writeStringField("prs", b2cs.prs ? "Y" : "N");
		if(b2cs.prs)
		{
			json.writeStringField("od_num", b2cs.od_num);
            json.writeStringField("od_dt", gstFmt.format(b2cs.od_dt));
		}
		if(b2cs.etin!=null)
        {
        	json.writeStringField("etin", b2cs.etin);
        }
		json.writeStringField("typ", b2cs.typ);
		
		json.writeEndObject();
	}
}
