package ibase.dashboard.sfa.servlet;
import ibase.dashboard.sfa.ejb.Compliance_NovaRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import javax.servlet.http.HttpSession;

public class ComplianceGridServlet_Nova extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData = null;
	JSONObject jsonMetaData = null;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		Compliance_NovaRemote complianceRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String personName ="";
		String period = "";
		
		try
		{
			response.setContentType("application/xml");

			dataSourceName = request.getParameter("dataSourceName");
			personName 	   = request.getParameter("personname");
			period 	   = request.getParameter("month");
			
			System.out.println("in ComplianceGridServlet  personName :"+personName+"===== period :"+period);
			context = new InitialContext(appConnectParm.getProperty());
			complianceRemote = (Compliance_NovaRemote) context.lookup("ibase/Compliance_Nova/remote");
			JSONObject jsonObjData = (JSONObject) complianceRemote.getComplianceGrid(period, personName, dataSourceName);
			OutputStream outputStream   = response.getOutputStream();
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("Final data set for ComplianceGridServlet build the Graph is ===" + jsonObjData);
 
		} catch (Exception e)
		{
			System.out.println("Exception : ComplianceGridServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

}