 package ibase.dashboard.epa.ejb;
 
import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;
 
@Stateless
public class EmpProductivity extends ValidatorEJB  implements EmpProductivityRemote, EmpProductivityLocal
{
/**** Start Of getEmployeeProfileData() Method
* Method Name  : getEmployeeProfileData(String,String)
* Metadata Xml : escoredistribution.xml
* Servlet Name : EmpProfileServlet
* 
*******/
SimpleDateFormat gridDateFormat = new SimpleDateFormat( "dd-MM-yy");
SimpleDateFormat convrtToTimStmDate= new SimpleDateFormat("dd/MM/yyyy");  
@SuppressWarnings("unchecked")
public JSONObject getEmployeeProfileData(String dataSourceName,  String empCode) throws RemoteException, ITMException
{
	JSONObject rawDataEmployeeScoreJson = new JSONObject();
	JSONObject rowData = null;
	String sql         = null;
	ResultSet rs       = null;
	PreparedStatement pstmt = null;
	Connection conn    = null;
	try
	{
		/*conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;*/
		/*add new code for connection DB on dated:16062016 by Nikhil*/
		conn = getConnection();
		SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
		if ((empCode != null) && (empCode.trim().length() > 0))
		{
			System.out.println("Inside of method getEmployeeProfileData() ::");
			sql = "select emp.designation as designation,emp.dept_code as dept_code ,dep.descr as descr,  emp.emp_fname as emp_fname, "
					+" emp.emp_lname as emp_lname ,emp.emp_type as emp_type, "
					+" g.descr as grade ,emp.M_STATUS, "
					+" to_char(emp.date_join,'DD/MM/YYYY')  as date_join , "
                	+" to_char(emp.birth_date,'DD/MM/YYYY')  as birth_date ,emp.sex as sex,emp.tot_exp as exp"
					+" from employee  emp LEFT OUTER JOIN GRADE G ON EMP.GRADE=G.GRADE_CODE  " +
					"inner join department dep on emp.dept_code=dep.dept_code "
					+" where trim(emp.emp_code)='"+empCode.trim()+"' "; 
			
			pstmt = conn.prepareStatement(sql);
			rs    = pstmt.executeQuery();
			int count = 0;
			Date jDate=null,cDate=null,bDate=null;
			String dojDate="",currDate="",dobDate="";
		        int expYear=0,expMonth=0,ageYear=0;
		        String ageYearStr="";
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("emp_name", (rs.getString("emp_fname")+" "+rs.getString("emp_lname")));
				rowData.put("dept_desc",       checkNull(rs.getString("descr")));
				rowData.put("emp_designation", checkNull(rs.getString("designation")));
				rowData.put("dept_code",       checkNull(rs.getString("dept_code")));
				rowData.put("m_status",        checkNull(rs.getString("M_STATUS")));
				rowData.put("emp_grade",       checkNull(rs.getString("grade")));
				rowData.put("emp_date_join", rs.getString("date_join"));
				dojDate=checkNull(rs.getString("date_join"));
				dobDate=checkNull(rs.getString("birth_date"));
				if(dojDate.trim().length()>0)
				{					
					Date date = new Date();
					jDate = format.parse(dojDate+" 09:00:58");
					currDate=format.format(date);					
					cDate = format.parse(currDate);
					long diff = cDate.getTime() - jDate.getTime();
					long diffDays = diff / (24 * 60 * 60 * 1000);
					expYear=Integer.parseInt(""+diffDays/365);
					expMonth=Integer.parseInt(""+(diffDays%365)/30);
				}
				if(dobDate.trim().length()>0)
				{					
					Date date = new Date();
					bDate = format.parse(dobDate+" 09:00:58");
					currDate=format.format(date);					
					cDate = format.parse(currDate);
					long diff = cDate.getTime() - bDate.getTime();
					long diffDays = diff / (24 * 60 * 60 * 1000);
					ageYear=Integer.parseInt(""+diffDays/365);
					ageYearStr=String.valueOf(ageYear);
					//expMonth=Integer.parseInt(""+(diffDays%365)/30);
				}
				else
				{
					ageYearStr="";
				}
				rowData.put("emp_birth_date", rs.getString("birth_date"));
				rowData.put("sex", checkNull(rs.getString("sex")));
				rowData.put("exp", expYear+"."+expMonth);
				rowData.put("age", ageYearStr);
				rawDataEmployeeScoreJson.put(Integer.valueOf(count), rowData);
				count++;
			}
		}
		
		System.out.println("fetch Data for getEmployeePerformanceDataDayWise() : " + rawDataEmployeeScoreJson.toString());
	}
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	}
	finally
	{
		try {
				if (conn != null)
					{
						if (rs != null)
							rs.close();
						rs = null;
						if (pstmt != null)
							pstmt.close();
						pstmt = null;
						conn.close();
						conn = null;
					}
				conn = null;
		}
		catch (Exception d) 
		{
			d.printStackTrace();
			System.out.println("Exception in :EmpEffectivenessEJB : getEmployeePerformanceDataDayWise():" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawDataEmployeeScoreJson;
}
		
/**** End of getEmployeeProfileData() Method ***/


	
/********** Start of method for Top Time Analysis 
* EJB Name           : EmpProductivity.java
* Method Name        : getTopTimeAnalysisServlet(String,String,String,String,String,String)
* Servlet Name       : TopTimeAnalysisServlet
* Metadata xml Name  : efftimeanalysis.xml
* 
* */
@SuppressWarnings("unchecked")
public JSONObject getTopTimeAnalysisServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
{
	JSONObject rawEffTimeJson = new JSONObject();
	JSONObject rowData = null;
	String sql         = "";
	ResultSet rs       = null;
	PreparedStatement pstmt = null;
	Connection conn    = null;
	String empCodeFilter="",deptCodeFilter="",topNosFilter="",empTaskFilter="";
	DashboardUtility dashbordUtil = new DashboardUtility();
	try
	{
		/*conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;*/	
		/*add new code for connection DB on dated:16062016 by Nikhil*/
		conn = getConnection();
       if ( (frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ) )
		{
    	   System.out.println(" Inside getTopTimeAnalysisServlet()  for Data Soruc Name ="+dataSourceName);
    	   deptCode=deptCode.trim();
    	   frmPrd=frmPrd.trim();
    	   toPrd=toPrd.trim();
    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));
    	   System.out.println("simple date frmPrd: "+frmPrd+"   toPrd: "+toPrd);
    	   int count = 0;
    	   if ((empTask != null) && (empTask.trim().length() > 0))
		   {
			   System.out.println("empTask" + empTask);
			   empTask = dashbordUtil.getCommaSeparated(empTask);
			   empTaskFilter = " AND TBLEPA_DAYSCORE.WINNAME in (" + empTask + ") ";
		   }
    	   if ((empCode != null) && (empCode.trim().length() > 0))
		   {
			   System.out.println("empCode" + empCode);
			   empCode = dashbordUtil.getCommaSeparated(empCode);
			   empCodeFilter = " AND EMPLOYEE.EMP_CODE IN (" + empCode + ") ";
		   }
    	   if ((deptCode != null) && (deptCode.trim().length() > 0))
		   {
			   System.out.println("deptCode" + deptCode);
			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
		   }
    	   if ((topNos != null) && (topNos.trim().length() > 0))
		   {
			   System.out.println("topNos" + topNos);
			   topNosFilter = " AND D.RANK<="+topNos;
		   }
   
    	   sql="select D.emp_code,D.emp_name,D.JOBID,D.servert,D.oht,D.jobt,D.tot_time_min,D.RANK from ( "
				+" select c.emp_code,c.emp_name,c.JOBID,c.servert,c.oht,c.jobt,c.tot_time_min, " 
				+" dense_rank () OVER (ORDER BY (c.tot_time_min) asc) AS RANK " 
				+" from( " 
				+" select b.emp_code,b.emp_name,sum(b.jobid) jobid,TRUNC(AVG(b.servert/60),2) servert , " 
				+" TRUNC(AVG(b.oht/60),2) OHT ,TRUNC(AVG(b.jobt/60),2) JOBT, TRUNC((AVG(B.OHT)/60+AVG(b.servert)/60+AVG(b.jobt)/60),2) tot_time_min, " 
				+" AVG(b.noatt) noatt,AVG(b.success) success, AVG(b.fail) fail " 
				+" from ( "
				+" select A.EMP_CODE,A.LOGDATE,"
				+" A.EMP_NAME,count(a.jobid) jobid,trunc(AVG(A.SERVERT),2) SERVERT,trunc(AVG(A.OHT),2) OHT,trunc(AVG(a.JOBT),2) JOBT , " 
				+" trunc(AVG(a.noatt),2) noatt,trunc(AVG(a.success),2) success,trunc(AVG(a.fail),2) fail " 
				+" from( " 
				+" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code,TBLEPA_DAYSCORE.WINNAME , "   
				+" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "  
				+" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "  
				+" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "  
				+" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "	
				+" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert, " 
				+" trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, "   
				+" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt , " 
				+" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt , " 
				+" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , " 
				+" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail "  
				+" from TBLEPA_DAYSCORE,EMPLOYEE,USERS,transetup " 
				+" where trim(tblEPA_dayScore.userid) =trim(USERS.CODE) "   
				+" and  USERS.entity_code = EMPLOYEE.EMP_CODE "	  
				+" and tblEPA_dayScore.logdate >= '"+frmPrd+"'"   
				+" and tblEPA_dayScore.logdate <= '"+toPrd+"'"      
				+" and transetup.function_type='"+functionType+"' "  
				+" and UPPER(TRIM(transetup.tran_window))='W_' ||UPPER(TRIM(TBLEPA_DAYSCORE.winname)) " 
				+" and USERS.usage_intensity='"+usageIntensity+"' " +empTaskFilter+empCodeFilter +deptCodeFilter
				+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW'  "
				+" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE,TBLEPA_DAYSCORE.WINNAME, " 
				+" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "
				+" )a  GROUP BY A.LOGDATE,A.EMP_CODE, A.EMP_NAME  " 				
				+" )b GROUP BY b.emp_code,b.emp_name) C) D where D.tot_time_min>0.04 "+topNosFilter+" order by D.RANK asc ";
    	   
    	   pstmt = conn.prepareStatement(sql);
		   rs = pstmt.executeQuery();
		   while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));
				rowData.put("tot_time_spent", checkNull(rs.getString("tot_time_min"))+"@"+checkNull(rs.getString("EMP_NAME"))+"{br}#Transactions: "+checkNull(rs.getString("JOBID"))+"{br}Avg.Total Time:");
				rawEffTimeJson.put(count, rowData);
				count++;
			}
		}
       System.out.println("fetch Data for getTopTimeAnalysisServlet() : " + rawEffTimeJson.toString());
	}
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	} finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				rs.close();
				rs = null;
				if (pstmt != null)
				pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :EmpProductivity : getTopTimeAnalysisServlet() :" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawEffTimeJson;
}
/********** End of method getTopTimeAnalysisServlet()  ******/
	
/********** Start of method for Worst Time Analysis 
* EJB Name           : EmpProductivity.java
* Method Name        : getWorstTimeAnalysisServlet(String,String,String,String,String,String)
* Servlet Name       : WorstTimeAnalysisServlet
* Metadata xml Name  : efftimeanalysis.xml
* 
* */
@SuppressWarnings("unchecked")
public JSONObject getWorstTimeAnalysisServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
{
	JSONObject rawEffTimeJson = new JSONObject();
	JSONObject rowData = null;
	String sql         = "";
	ResultSet rs       = null;
	PreparedStatement pstmt = null;
	Connection conn    = null;
	String empCodeFilter="",deptCodeFilter="",topNosFilter="",empTaskFilter="";
	DashboardUtility dashbordUtil = new DashboardUtility();
	try
	{
		/*conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;*/	
		/*add new code for connection DB on dated:16062016 by Nikhil*/
		conn = getConnection();
       if ( (frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ) )
		{
    	   System.out.println(" Inside getWorstTimeAnalysisServlet()  for Data Soruc Name ="+dataSourceName);
    	   deptCode=deptCode.trim();
    	   frmPrd=frmPrd.trim();
    	   toPrd=toPrd.trim();
    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));      	  
    	   int count = 0;
    	   if ((empTask != null) && (empTask.trim().length() > 0))
		   {
			   System.out.println("empTask" + empTask);
			   empTask = dashbordUtil.getCommaSeparated(empTask);
			   empTaskFilter = " AND TBLEPA_DAYSCORE.WINNAME in (" + empTask + ") ";
		   }
    	   if ((empCode != null) && (empCode.trim().length() > 0))
		   {
			   System.out.println("empCode" + empCode);
			   empCode = dashbordUtil.getCommaSeparated(empCode);
			   empCodeFilter = " AND employee.EMP_CODE IN (" + empCode + ") ";
		   }
    	   if ((deptCode != null) && (deptCode.trim().length() > 0))
		   {
			   System.out.println("deptCode" + deptCode);
			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
		   }
    	   if ((topNos != null) && (topNos.trim().length() > 0))
		   {
			   System.out.println("topNos" + topNos);
			   topNosFilter = " AND D.RANK<="+topNos;
		   }
    	   sql="select D.emp_code,D.emp_name,D.JOBID,D.servert,D.oht,D.jobt,D.tot_time_min,D.RANK from ( "
   				+" select c.emp_code,c.emp_name,c.JOBID,c.servert,c.oht,c.jobt,c.tot_time_min, " 
   				+" dense_rank () OVER (ORDER BY (c.tot_time_min) desc) AS RANK " 
   				+" from( " 
   				+" select b.emp_code,b.emp_name,sum(b.jobid) jobid,TRUNC(AVG(b.servert/60),2) servert , " 
   				+" TRUNC(AVG(b.oht/60),2) OHT ,TRUNC(AVG(b.jobt/60),2) JOBT, TRUNC((AVG(B.OHT)/60+AVG(b.servert)/60+AVG(b.jobt)/60),2) tot_time_min, " 
   				+" AVG(b.noatt) noatt,AVG(b.success) success, AVG(b.fail) fail " 
   				+" from ( "   			
   				+" select A.EMP_CODE,A.LOGDATE,  "
   				+" A.EMP_NAME,count(a.jobid) jobid,trunc(AVG(A.SERVERT),2) SERVERT,trunc(AVG(A.OHT),2) OHT,trunc(AVG(a.JOBT),2) JOBT , " 
   				+" trunc(AVG(a.noatt),2) noatt,trunc(AVG(a.success),2) success,trunc(AVG(a.fail),2) fail " 
   				+" from( " 
   				+" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code,TBLEPA_DAYSCORE.WINNAME , "   
   				+" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "  
   				+" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "  
   				+" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "  
   				+" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "	
   				+" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert, " 
   				+" trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, "   
   				+" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt , " 
   				+" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt , " 
   				+" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , " 
   				+" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail "  
   				+" from TBLEPA_DAYSCORE,EMPLOYEE,USERS,transetup " 
   				+" where trim(tblEPA_dayScore.userid) =trim(USERS.CODE) "   
   				+" and  USERS.entity_code = EMPLOYEE.EMP_CODE "	  
   				+" and tblEPA_dayScore.logdate >= '"+frmPrd+"'"  
   				+" and tblEPA_dayScore.logdate <= '"+toPrd+"'"   
   				+" and transetup.function_type='"+functionType+"' "  
   				+" and UPPER(TRIM(transetup.tran_window))='W_' ||UPPER(TRIM(TBLEPA_DAYSCORE.winname)) " 
   				+" and USERS.usage_intensity='"+usageIntensity+"' " +empTaskFilter+empCodeFilter +deptCodeFilter
   				+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW'  "
   				+" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE,TBLEPA_DAYSCORE.WINNAME, " 
   				+" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "
   				+" )a  GROUP BY A.LOGDATE,A.EMP_CODE, A.EMP_NAME " 
   				+" )b GROUP BY b.emp_code,b.emp_name) C) D where D.tot_time_min>0.04 "+topNosFilter+" order by D.RANK asc ";
			    	   
				   
    	   pstmt = conn.prepareStatement(sql);
		   rs = pstmt.executeQuery();
		   while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));
				rowData.put("tot_time_spent", checkNull(rs.getString("tot_time_min"))+"@"+checkNull(rs.getString("EMP_NAME"))+"{br}#Transactions: "+checkNull(rs.getString("JOBID"))+"{br}Avg.Total Time:");				
				rawEffTimeJson.put(count, rowData);
				count++;
			}
		}
       System.out.println("fetch Data for getWorstTimeAnalysisServlet() : " + rawEffTimeJson.toString());
	}
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	} finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				rs.close();
				rs = null;
				if (pstmt != null)
				pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :EmpProductivity : getWorstTimeAnalysisServlet() :" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawEffTimeJson;
}
/********** End of method getWorstTimeAnalysisServlet()  ******/




/********** Start of method for  Top Efficiency Analysis 
* EJB Name           : EmpProductivity.java
* Method Name        : getTopEfficiencyAnalysisServlet
* Servlet Name       : TopEfficiencyAnalysisServlet
* Metadata xml Name  : efftimeanalysis.xml
* 
* */
@SuppressWarnings("unchecked")
public JSONObject getTopEfficiencyAnalysisServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
{
	JSONObject rawEffTimeJson = new JSONObject();
	JSONObject rowData = null;
	String sql         = "";
	ResultSet rs       = null;
	PreparedStatement pstmt = null;
	Connection conn    = null;
	String empCodeFilter="",deptCodeFilter="",topNosFilter="",empTaskFilter="";
	DashboardUtility dashbordUtil = new DashboardUtility();
	try
	{
		/*conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;*/	
		/*add new code for connection DB on dated:16062016 by Nikhil*/
		conn = getConnection();
       if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
		{
    	   System.out.println(" Inside getTopEfficiencyAnalysisServlet()  for Data Soruc Name ="+dataSourceName);
    	   deptCode=deptCode.trim();
    	   frmPrd=frmPrd.trim();
    	   toPrd=toPrd.trim();
    	   
    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));     	  
    	   int count = 0;
    	   if ((empTask != null) && (empTask.trim().length() > 0))
		   {
			   System.out.println("empTask" + empTask);
			   empTask = dashbordUtil.getCommaSeparated(empTask);
			   empTaskFilter = " AND TBLEPA_DAYSCORE.WINNAME in (" + empTask + ") ";
		   }
    	   if ((empCode != null) && (empCode.trim().length() > 0))
		   {
			   System.out.println("empCode" + empCode);
			   empCode = dashbordUtil.getCommaSeparated(empCode);
			   empCodeFilter = " AND EMPLOYEE.EMP_CODE IN (" + empCode + ") ";
		   }
    	   if ((deptCode != null) && (deptCode.trim().length() > 0))
		   {
			   System.out.println("deptCode" + deptCode);
			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
		   }
    	   if ((topNos != null) && (topNos.trim().length() > 0))
		   {
			   System.out.println("topNos" + topNos);
			   topNosFilter = " where D.rank<="+topNos;
		   }
    	 
    	   sql="select d.emp_code,d.emp_name,d.JOBID, d.escore,d.rank " 
				+" from ( " 
				+" select c.emp_code,c.emp_name,c.JOBID, c.escore, "  
				+" dense_rank () OVER (ORDER BY (c.escore) desc) AS RANK "  
				+" from( "  
				+" select b.emp_code,b.emp_name,sum(b.jobid) jobid,trunc(AVG(b.escore),2) escore "  
				+" from ( " 
				+" select A.EMP_CODE,A.LOGDATE, "   
				+" A.EMP_NAME,count(a.jobid) jobid ,trunc(AVG(a.escore),2) escore"
				+" from( "  
				+" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code, " 
				+" TBLEPA_DAYSCORE.WINNAME , "  
				+" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "  
				+" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "    
				+" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "     
				+" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , " 
				+" trunc(AVG(nvl((tblEPA_dayScore.adjescore),0)),2) as escore " 
				+" from TBLEPA_DAYSCORE,EMPLOYEE,USERS,transetup "  
				+" where trim(tblEPA_dayScore.userid) =trim(USERS.CODE) "   
				+" and  USERS.entity_code = EMPLOYEE.EMP_CODE "
				+" and tblEPA_dayScore.logdate >= '"+frmPrd+"'"   
				+" and tblEPA_dayScore.logdate <= '"+toPrd+"'"   
				+" and transetup.function_type='"+functionType+"' " 
				+" and UPPER(TRIM(transetup.tran_window))='W_' ||UPPER(TRIM(TBLEPA_DAYSCORE.winname)) " 
				+" and USERS.usage_intensity='"+usageIntensity+"' and tblEPA_dayScore.escore>0 "
				+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' " 
				+empTaskFilter+empCodeFilter +deptCodeFilter 
				+" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE,TBLEPA_DAYSCORE.WINNAME, " 
				+" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "  
				+" )a  GROUP BY A.LOGDATE,A.EMP_CODE, A.EMP_NAME"				
				+" )b GROUP BY b.emp_code,b.emp_name)C )D "+topNosFilter+" order by D.rank asc ";
    	   
    	   pstmt = conn.prepareStatement(sql);
		   rs = pstmt.executeQuery();
		   while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("EMP_CODE",  checkNull(rs.getString("emp_code")));
				rowData.put("escore", checkNull(rs.getString("escore"))+"@"+checkNull(rs.getString("emp_name"))+"{br}#Transactions: "+checkNull(rs.getString("JOBID"))+"{br}Avg.E1-Score:");
				rawEffTimeJson.put(count, rowData);
				count++;
			}
		}
       System.out.println("fetch Data for getTopEfficiencyAnalysisServlet() : " + rawEffTimeJson.toString());
	}
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	} finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				rs.close();
				rs = null;
				if (pstmt != null)
				pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :EmpProductivity : getTopEfficiencyAnalysisServlet() :" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawEffTimeJson;
}
/********** End of method getTopEfficiencyAnalysisServlet()  ******/
	
/********** Start of method for  Worst Efficiency Analysis 
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : getWorstEfficiencyAnalysisServlet
	 * Servlet Name       : WorstEfficiencyAnalysisServlet
	 * Metadata xml Name  : efftimeanalysis.xml
	 * 
	 * */
	@SuppressWarnings("unchecked")
	public JSONObject getWorstEfficiencyAnalysisServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawEffTimeJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		String empCodeFilter="",deptCodeFilter="",topNosFilter="",empTaskFilter="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
           if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ) )
			{
        	   System.out.println(" Inside getWorstEfficiencyAnalysisServlet()  for Data Soruc Name ="+dataSourceName);
        	   deptCode=deptCode.trim();
       	   frmPrd=frmPrd.trim();
       	   toPrd=toPrd.trim();
       	   
       	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
       	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));          	  
        	   int count = 0;
        	   if ((empTask != null) && (empTask.trim().length() > 0))
    		   {
    			   System.out.println("empTask" + empTask);
    			   empTask = dashbordUtil.getCommaSeparated(empTask);
    			   empTaskFilter = " AND TBLEPA_DAYSCORE.WINNAME in (" + empTask + ") ";
    		   }
        	   if ((empCode != null) && (empCode.trim().length() > 0))
    		   {
    			   System.out.println("empCode" + empCode);
    			   empCode = dashbordUtil.getCommaSeparated(empCode);
    			   empCodeFilter = " AND employee.EMP_CODE IN (" + empCode + ") ";
    		   }
        	   if ((deptCode != null) && (deptCode.trim().length() > 0))
    		   {
    			   System.out.println("deptCode" + deptCode);
    			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
    			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
    		   }
        	   if ((topNos != null) && (topNos.trim().length() > 0))
    		   {
    			   System.out.println("topNos" + topNos);
    			   topNosFilter = " where D.Rank<="+topNos;
    		   }
        	   
        	   
        	   sql="select d.emp_code,d.emp_name,d.JOBID, d.escore,d.rank " 
       				+" from ( " 
       				+" select c.emp_code,c.emp_name,c.JOBID, c.escore, "  
       				+" dense_rank () OVER (ORDER BY (c.escore) asc) AS RANK "  
       				+" from( "  
       				+" select b.emp_code,b.emp_name,sum(b.jobid) jobid,trunc(AVG(b.escore),2) escore "  
       				+" from ( " 
       				+" select A.EMP_CODE,A.LOGDATE, "   
       				+" A.EMP_NAME,count(a.jobid) jobid ,trunc(AVG(a.escore),2) escore "
       				+" from( "  
       				+" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code, " 
       				+" TBLEPA_DAYSCORE.WINNAME , "  
       				+" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "  
       				+" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "    
       				+" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "     
       				+" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , " 
       				+" trunc(AVG(nvl((tblEPA_dayScore.adjescore),0)),2) as escore " 
       				+" from TBLEPA_DAYSCORE,EMPLOYEE,USERS,transetup "  
       				+" where trim(tblEPA_dayScore.userid) =trim(USERS.CODE) "   
       				+" and  USERS.entity_code = EMPLOYEE.EMP_CODE "
       				+" and tblEPA_dayScore.logdate >= '"+frmPrd+"'"   
       				+" and tblEPA_dayScore.logdate <= '"+toPrd+"'"   
       				+" and transetup.function_type='"+functionType+"' " 
       				+" and UPPER(TRIM(transetup.tran_window))='W_' ||UPPER(TRIM(TBLEPA_DAYSCORE.winname)) " 
       				+" and USERS.usage_intensity='"+usageIntensity+"' and tblEPA_dayScore.escore>0 "
       				+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' " 
       				+empTaskFilter+empCodeFilter +deptCodeFilter 
       				+" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE,TBLEPA_DAYSCORE.WINNAME, " 
       				+" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "  
       				+" )a  GROUP BY A.LOGDATE,A.EMP_CODE, A.EMP_NAME "       				
       				+" )b GROUP BY b.emp_code,b.emp_name)C )D "+topNosFilter+" order by D.rank asc ";
        	   pstmt = conn.prepareStatement(sql);
  			   rs = pstmt.executeQuery();
			   while (rs.next())
				{
					rowData = new JSONObject();
					rowData.put("EMP_CODE",  checkNull(rs.getString("emp_code")));					
					rowData.put("escore", checkNull(rs.getString("escore"))+"@"+checkNull(rs.getString("emp_name"))+"{br}#Transactions: "+checkNull(rs.getString("JOBID"))+"{br}Avg.E1-Score:");
					rawEffTimeJson.put(count, rowData);
					count++;
  				}
			}
           System.out.println("fetch Data for getWorstEfficiencyAnalysisServlet() : " + rawEffTimeJson.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getWorstEfficiencyAnalysisServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawEffTimeJson;
	}
	/********** End of method getWorstEfficiencyAnalysisServlet()  ******/
	
	
	/********** Start of method for  Top no of attempts Analysis 
	* EJB Name           : EmpProductivity.java
	* Method Name        : getTopNumAttemptAnalysisServlet
	* Servlet Name       : TopNumAttemptAnalysisServlet
	* Metadata xml Name  : efftimeanalysis.xml
	* 
	* */
	@SuppressWarnings("unchecked")
	public JSONObject getTopNumAttemptAnalysisServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawEffTimeJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		String empCodeFilter="",deptCodeFilter="",topNosFilter="",empTaskFilter="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
			
	       if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
			{
	    	   System.out.println(" Inside getTopNumAttemptAnalysisServlet()  for Data Soruc Name ="+dataSourceName);
	    	   deptCode=deptCode.trim();
	    	   frmPrd=frmPrd.trim();
	    	   toPrd=toPrd.trim();
	    	   
	    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
	    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));       	  
	    	   int count = 0;
	    	   if ((empTask != null) && (empTask.trim().length() > 0))
    		   {
    			   System.out.println("empTask" + empTask);
    			   empTask = dashbordUtil.getCommaSeparated(empTask);
    			   empTaskFilter = " AND TBLEPA_DAYSCORE.WINNAME in (" + empTask + ") ";
    		   }
	    	   if ((empCode != null) && (empCode.trim().length() > 0))
    		   {
    			   System.out.println("empCode" + empCode);
    			   empCode = dashbordUtil.getCommaSeparated(empCode);
    			   empCodeFilter = " AND EMPLOYEE.EMP_CODE IN (" + empCode + ") ";
    		   }
	    	   if ((deptCode != null) && (deptCode.trim().length() > 0))
    		   {
    			   System.out.println("deptCode" + deptCode);
    			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
    			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
    		   }
	    	   if ((topNos != null) && (topNos.trim().length() > 0))
    		   {
    			   System.out.println("topNos" + topNos);
    			   topNosFilter = " where D.RANK<="+topNos;
    		   }

	    	   sql=" select D.emp_code,D.emp_name,D.JOBID,D.noatt,D.success,D.fail,D.RANK from ( " 
						+" select c.emp_code,c.JOBID,c.emp_name,trunc(c.noatt,2) noatt,trunc(c.success,2) success,trunc(c.fail,2) fail,"
						+" dense_rank () OVER (ORDER BY (c.noatt) asc) AS RANK " 
						+" from( " 
						+" select b.emp_code,b.emp_name,sum(b.jobid) jobid, "
						+" trunc(AVG(b.noatt),2) noatt,trunc(AVG(b.success),2) success, trunc(AVG(b.fail),2) fail "
						+" from ( " 
						+" select A.EMP_CODE,A.LOGDATE," 
						+" A.EMP_NAME,count(a.jobid) jobid,trunc(AVG(A.SERVERT),2) SERVERT,trunc(AVG(A.OHT),2) OHT,trunc(AVG(a.JOBT),2) JOBT , " 
						+" trunc(AVG(a.noatt),2) noatt,trunc(AVG(a.success),2) success,trunc(AVG(a.fail),2) fail " 
						+" from( " 
						+" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code,TBLEPA_DAYSCORE.WINNAME , " 
						+" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || " 
						+" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "   
						+" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "   
						+" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "	 
						+" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert, "
						+" trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, "
						+" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt , " 
						+" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt ,"
						+" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , " 
						+" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail "
						+" from TBLEPA_DAYSCORE,EMPLOYEE,USERS,transetup "
						+" where trim(tblEPA_dayScore.userid) =trim(USERS.CODE) "   
						+" and  USERS.entity_code = EMPLOYEE.EMP_CODE "
						+" and tblEPA_dayScore.logdate >= '"+frmPrd+"'"   
						+" and tblEPA_dayScore.logdate <= '"+toPrd+"'" 
						+" and transetup.function_type='"+functionType+"'  and UPPER(TRIM(transetup.tran_window))='W_' ||UPPER(TRIM(TBLEPA_DAYSCORE.winname)) " 
						+" and USERS.usage_intensity='"+usageIntensity+"' "
						+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' " 
								+empTaskFilter+empCodeFilter +deptCodeFilter 
								+" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE,TBLEPA_DAYSCORE.WINNAME, " 
						+" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "
						+" )a  GROUP BY A.LOGDATE,A.EMP_CODE, A.EMP_NAME "					
						+" )b GROUP BY b.emp_code,b.emp_name "
						+" ) C )D  "+topNosFilter+" order by D.RANK asc ";
	    	  
	    	   pstmt = conn.prepareStatement(sql);
			   rs = pstmt.executeQuery();
			   while (rs.next())
				{
					rowData = new JSONObject();
					rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));
					rowData.put("no_of_attempt", checkNull(rs.getString("noatt"))+"@"+checkNull(rs.getString("EMP_NAME"))+"{br}#Transactions: "+checkNull(rs.getString("JOBID"))+"{br}Avg.No. of Attempts:");					
					rawEffTimeJson.put(count, rowData);
					count++;
				}
			}
	       System.out.println("fetch Data for getTopNumAttemptAnalysisServlet() : " + rawEffTimeJson.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getTopNumAttemptAnalysisServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawEffTimeJson;
	}
	/********** End of method getTopNumAttemptAnalysisServlet()  ******/
	
			
	/********** Start of method for  Worst no of attempts Analysis 
		 * EJB Name           : EmpProductivity.java
		 * Method Name        : getWorstNumAttemptAnalysisServlet
		 * Servlet Name       : WorstNumAttemptAnalysisServlet
		 * Metadata xml Name  : efftimeanalysis.xml
		 * 
		 * */
		@SuppressWarnings("unchecked")
		public JSONObject getWorstNumAttemptAnalysisServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
		{
			JSONObject rawEffTimeJson = new JSONObject();
			JSONObject rowData = null;
			String sql         = "";
			ResultSet rs       = null;
			PreparedStatement pstmt = null;
			Connection conn    = null;
			String empCodeFilter="",deptCodeFilter="",topNosFilter="",empTaskFilter="";
			DashboardUtility dashbordUtil = new DashboardUtility();
			try
			{
				/*conn = connDriver.getConnectDB(dataSourceName);
				connDriver = null;*/
				/*add new code for connection DB on dated:16062016 by Nikhil*/
				conn = getConnection();
	           if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ) )
				{
	        	   System.out.println(" Inside getWorstNumAttemptAnalysisServlet()  for Data Soruc Name ="+dataSourceName);
	        	   deptCode=deptCode.trim();
	       	       frmPrd=frmPrd.trim();
	       	       toPrd=toPrd.trim();
	       	   
	       	       frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
	       	       toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));         	  
	        	   int count = 0;
	        	   if ((empTask != null) && (empTask.trim().length() > 0))
	    		   {
	    			   System.out.println("empTask" + empTask);
	    			   empTask = dashbordUtil.getCommaSeparated(empTask);
	    			   empTaskFilter = " AND TBLEPA_DAYSCORE.WINNAME in (" + empTask + ") ";
	    		   }
	        	   if ((empCode != null) && (empCode.trim().length() > 0))
	    		   {
	    			   System.out.println("empCode" + empCode);
	    			   empCode = dashbordUtil.getCommaSeparated(empCode);
	    			   empCodeFilter = " AND EMPLOYEE.EMP_CODE IN (" + empCode + ") ";
	    		   }
	        	   if ((deptCode != null) && (deptCode.trim().length() > 0))
	    		   {
	    			   System.out.println("deptCode" + deptCode);
	    			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
	    			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
	    		   }
	        	   if ((topNos != null) && (topNos.trim().length() > 0))
	    		   {
	    			   System.out.println("topNos" + topNos);
	    			   topNosFilter = " where D.RANK<="+topNos;
	    		   }

	        	   sql=" select D.emp_code,D.emp_name,D.JOBID,D.noatt,D.success,D.fail,D.RANK from ( " 
		   					+" select c.emp_code,c.JOBID,c.emp_name,trunc(c.noatt,2) noatt,trunc(c.success,2) success,trunc(c.fail,2) fail,"
		   					+" dense_rank () OVER (ORDER BY (c.noatt) desc) AS RANK " 
		   					+" from( " 
		   					+" select b.emp_code,b.emp_name,sum(b.jobid) jobid, "
		   					+" trunc(AVG(b.noatt),2) noatt,trunc(AVG(b.success),2) success, trunc(AVG(b.fail),2) fail "
		   					+" from ( " 
		   					+" select A.EMP_CODE,A.LOGDATE," 
		   					+" A.EMP_NAME,count(a.jobid) jobid,trunc(AVG(A.SERVERT),2) SERVERT,trunc(AVG(A.OHT),2) OHT,trunc(AVG(a.JOBT),2) JOBT , " 
		   					+" trunc(AVG(a.noatt),2) noatt,trunc(AVG(a.success),2) success,trunc(AVG(a.fail),2) fail " 
		   					+" from( " 
		   					+" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code,TBLEPA_DAYSCORE.WINNAME , " 
		   					+" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || " 
		   					+" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "   
		   					+" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "   
		   					+" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "	 
		   					+" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert, "
		   					+" trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, "
		   					+" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt , " 
		   					+" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt ,"
		   					+" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , " 
		   					+" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail "
		   					+" from TBLEPA_DAYSCORE,EMPLOYEE,USERS,transetup "
		   					+" where trim(tblEPA_dayScore.userid) =trim(USERS.CODE) "   
		   					+" and  USERS.entity_code = EMPLOYEE.EMP_CODE "
		   					+" and tblEPA_dayScore.logdate >= '"+frmPrd+"' "   
		   					+" and tblEPA_dayScore.logdate <= '"+toPrd+"' " 
		   					+" and transetup.function_type='"+functionType+"'  and UPPER(TRIM(transetup.tran_window))='W_' ||UPPER(TRIM(TBLEPA_DAYSCORE.winname)) " 
		   					+" and USERS.usage_intensity='"+usageIntensity+"' "
		   					+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' " 
		   							+empTaskFilter+empCodeFilter +deptCodeFilter 
		   							+" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE,TBLEPA_DAYSCORE.WINNAME, " 
		   					+" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "
		   					+" )a  GROUP BY A.LOGDATE,A.EMP_CODE, A.EMP_NAME "	   					
		   					+" )b GROUP BY b.emp_code,b.emp_name "
		   					+" ) C )D  "+topNosFilter+" order by D.RANK asc ";
	        	   
	        	   pstmt = conn.prepareStatement(sql);
	  			   rs = pstmt.executeQuery();
				   while (rs.next())
					{
						rowData = new JSONObject();
						rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));					
						rowData.put("no_of_attempt", checkNull(rs.getString("noatt"))+"@"+checkNull(rs.getString("EMP_NAME"))+"{br}#Transactions: "+checkNull(rs.getString("JOBID"))+"{br}Avg.No. of Attempts:");					
						rawEffTimeJson.put(count, rowData);
						count++;
	  				}
				}
	           System.out.println("fetch Data for getWorstNumAttemptAnalysisServlet() : " + rawEffTimeJson.toString());
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			} finally
			{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						rs.close();
						rs = null;
						if (pstmt != null)
						pstmt.close();
						pstmt = null;
						conn.close();
						conn = null;
					}
					conn = null;
				} catch (Exception d)
				{
					d.printStackTrace();
					System.out.println("Exception in :EmpProductivity : getWorstNumAttemptAnalysisServlet() :" + d.getMessage());
					throw new ITMException(d);
				}
			}
			return rawEffTimeJson;
		}
		/********** End of method getWorstNumAttemptAnalysisServlet()  ******/


	
	
	/********** Start of method for  Task wise E score 
	* EJB Name           : EmpProductivity.java
	* Method Name        : getTaskWiseEscoreServlet(String,String,String,String)
	* Servlet Name       : TaskWiseEscoreServlet
	* Metadata xml Name  : efftimeanalysis.xml
	* 
	* */
	@SuppressWarnings("unchecked")
	public JSONObject getTaskWiseEscoreServlet(String dataSourceName,String frmPrd,String toPrd,String empCode,String deptCode,String usageIntensity,String empTask,String functionType,String topNos) throws RemoteException, ITMException
	{
		JSONObject rawDataEmpTopScoreJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		String deptCodeFilter="",empCodeFilter="",empTaskFilter="",topNosFilter="";
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
			DashboardUtility dashbordUtil = new DashboardUtility();
			 if ((frmPrd != null && frmPrd.trim().length()>0 )   && (toPrd != null && toPrd.trim().length()>0 ))
				{
		    	   frmPrd=frmPrd.trim();
		    	   toPrd=toPrd.trim();
		    	   
		    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
		    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
				 System.out.println(" Inside getTaskWiseEscoreServlet()  for Data Soruc Name ="+dataSourceName);
				 if ((empTask != null) && (empTask.trim().length() > 0))
				 {
	 			   System.out.println("empTask" + empTask);
	 			   empTask = dashbordUtil.getCommaSeparated(empTask);
	 			   empTaskFilter = " AND TBLEPA_DAYSCORE.WINNAME in (" + empTask + ") ";
				 }
				 if ((deptCode != null) && (deptCode.trim().length() > 0))
				 {
					 System.out.println("deptCode" + deptCode);
					 deptCode = dashbordUtil.getCommaSeparated(deptCode);
					 deptCodeFilter = " and Employee.DEPT_CODE in ("+deptCode+") ";
				 }
				 if ((empCode != null) && (empCode.trim().length() > 0))
				 {
	 			   System.out.println("empCode" + empCode);
	 			   empCode = dashbordUtil.getCommaSeparated(empCode);
	 			   empCodeFilter = " AND Employee.EMP_CODE IN (" + empCode + ") ";
				 }
				 if ((topNos != null) && (topNos.trim().length() > 0))
			  		{
				   System.out.println("topNos" + topNos);
				   topNosFilter = " where c.rank<="+topNos;
			  		}
        	   empCode=empCode.trim();
        	   int count = 0;
        	        	   
        	  
        	   sql=" select c.jobid,c.WINNAME,c.WIN_DESCR,c.ESCORE,c.rank "
					 +" from( "    
					 +" SELECT z.jobid,Z.WINNAME,SUBSTR(b.win_descr,INSTR(B.WIN_DESCR,'.')+1,length(b.win_descr)) WIN_DESCR,Z.ESCORE , "  
					 +"   dense_rank() OVER (ORDER BY (z.ESCORE) desc) AS RANK "     
					 +" from( "      
					 +" select sum(b.jobid) jobid ,b.winname,trunc(AVG(b.escore),2) escore "   
					 +" from ( "  
					 +"  select count(a.jobid) jobid,a.logdate,'w_' || a.winname as winname,trunc(AVG(escore),2) escore  "   
					 +" from( "    
					 +" select distinct tblEPA_dayScore.jobid  jobid,  tblEPA_dayScore.logdate, "
					 +" TBLEPA_DAYSCORE.WINNAME , "   
					 +"   trunc(AVG(nvl((tblEPA_dayScore.adjescore),0)),2) as escore   from TBLEPA_DAYSCORE,EMPLOYEE,USERS,transetup  "  
					 +"   where trim(tblEPA_dayScore.userid) =trim(USERS.CODE)   and  USERS.entity_code = EMPLOYEE.EMP_CODE  "    
					 +" and tblEPA_dayScore.logdate >= '"+frmPrd+"'  "  
					+"  and tblEPA_dayScore.logdate <= '"+toPrd+"' "   
					+" and transetup.function_type='"+functionType+"'    and UPPER(TRIM(transetup.tran_window))='W_' ||UPPER(TRIM(TBLEPA_DAYSCORE.winname))  " 
					+" and USERS.usage_intensity='"+usageIntensity+"'    and tblEPA_dayScore.escore>0  "+empTaskFilter+empCodeFilter
					+deptCodeFilter	+"  and tblEPA_dayScore.jobid !='NA'    and tblEPA_dayScore.ACtCode!='VIEW'    "
					+" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, TBLEPA_DAYSCORE.WINNAME "
					+"    )A group by a.logdate,a.winname )B group by b.winname )Z  LEFT OUTER JOIN   "
					+"  (SELECT WIN_NAME ,DESCR WIN_DESCR FROM ITM2MENU ) B   on Z.WINNAME=  B.WIN_NAME    )C "+topNosFilter+"  order by c.rank asc";

        	   pstmt = conn.prepareStatement(sql);
  			   rs = pstmt.executeQuery();
			   while (rs.next())
			   {
					rowData = new JSONObject();
					rowData.put("TASK_NAME", checkNull(rs.getString("WIN_DESCR"))+"["+checkNull(rs.getString("WINNAME"))+"]");
					rowData.put("task_code", checkNull(rs.getString("WINNAME")));					
					rowData.put("e_score", checkNull(rs.getString("ESCORE"))+"@"+"{br}#Transactions: "+checkNull(rs.getString("jobid"))+"{br}Avg.E-1 Score:");
					rawDataEmpTopScoreJson.put(Integer.valueOf(count), rowData);
					count++;
  				}
			}
			 System.out.println("fetch Data for getTaskWiseEscoreServlet() : " + rawDataEmpTopScoreJson.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getTaskWiseEscoreServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataEmpTopScoreJson;
	}
	
	/********** End of method getTaskWiseEscoreServlet()  ******/
	
	
	/********** Start of method for Task wise Time analysis
	* EJB Name           : EmpProductivity.java
	* Method Name        : getTaskWiseTimeServlet(String,String,String,String)
	* Servlet Name       : TaskWiseTimeServlet
	* Metadata xml Name  : efftimeanalysis.xml
	* 
	* */
	@SuppressWarnings("unchecked")
	public JSONObject getTaskWiseTimeServlet(String dataSourceName,String frmPrd,String toPrd,String empCode,String deptCode,String usageIntensity,String empTask,String functionType,String topNos) throws RemoteException, ITMException
	{
		JSONObject rawDataEmpTopScoreJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		String deptCodeFilter="",empCodeFilter="",empTaskFilter="",topNosFilter="";
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
			DashboardUtility dashbordUtil = new DashboardUtility();
			 if ( (frmPrd != null && frmPrd.trim().length()>0 )   && (toPrd != null && toPrd.trim().length()>0 ))
				{
		    	   frmPrd=frmPrd.trim();
		    	   toPrd=toPrd.trim();		    	   
		    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
		    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
	        	   System.out.println(" Inside getTaskWiseTimeServlet() for Data Soruc Name ="+dataSourceName);
			if ((empTask != null) && (empTask.trim().length() > 0))
	 		   {
	 			   System.out.println("empTask" + empTask);
	 			   empTask = dashbordUtil.getCommaSeparated(empTask);
	 			   empTaskFilter = " AND tblEPA_dayScore.WINNAME in (" + empTask + ") ";
	 		   }
			if ((deptCode != null) && (deptCode.trim().length() > 0))
	   		   {
	   			   System.out.println("deptCode" + deptCode);
	   			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
	   			   deptCodeFilter = " and Employee.DEPT_CODE in ("+deptCode+") ";
	   		   }
			if ((empCode != null) && (empCode.trim().length() > 0))
 		   {
 			   System.out.println("empCode" + empCode);
 			   empCode = dashbordUtil.getCommaSeparated(empCode);
 			   empCodeFilter = " AND Employee.EMP_CODE IN (" + empCode + ") ";
 		   }
			 if ((topNos != null) && (topNos.trim().length() > 0))
			   {
				   System.out.println("topNos" + topNos);
				   topNosFilter = " and c.rank<="+topNos;
			   }
        	   empCode=empCode.trim();
        	   int count = 0;
        	   
        	   sql="select c.jobid,c.WINNAME,c.WIN_DESCR,c.total_time,c.rank " 
					+" from( " 
					+" SELECT z.jobid,Z.WINNAME,SUBSTR(b.win_descr,INSTR(B.WIN_DESCR,'.')+1,length(b.win_descr)) WIN_DESCR,z.total_time, "   
					+" dense_rank() OVER (ORDER BY (z.total_time) desc) AS RANK "  
					+" from( "  
					+" select sum(b.jobid) jobid ,b.winname,trunc(AVG(b.total_time),2) total_time "  
					+" from " 
					+" (   select count(a.jobid) jobid,a.logdate,'w_' || a.winname as winname,trunc(AVG(A.SERVERT/60),2) SERVERT,trunc(AVG(A.OHT/60),2) OHT, "
					+" trunc(AVG(JOBT/60),2) JOBT ,trunc((AVG(A.SERVERT/60)+AVG(A.OHT/60)+AVG(JOBT/60)),2) total_time "  
					+" from( "  
					+" select distinct tblEPA_dayScore.jobid  jobid,  tblEPA_dayScore.logdate,  TBLEPA_DAYSCORE.WINNAME ,trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert,  trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, " 
					+" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt "      
					+" from TBLEPA_DAYSCORE,EMPLOYEE,USERS,transetup "    
					+" where trim(tblEPA_dayScore.userid) =trim(USERS.CODE)   and  USERS.entity_code = EMPLOYEE.EMP_CODE "   
					+" and tblEPA_dayScore.logdate >= '"+frmPrd+"' "    
					+" and tblEPA_dayScore.logdate <= '"+toPrd+"' " 
					+" and transetup.function_type='"+functionType+"'    and UPPER(TRIM(transetup.tran_window))='W_' ||UPPER(TRIM(TBLEPA_DAYSCORE.winname)) "  
					+" and USERS.usage_intensity='"+usageIntensity+"' " 
					+" and tblEPA_dayScore.jobid !='NA'    and tblEPA_dayScore.ACtCode!='VIEW' "  
					+empTaskFilter+empCodeFilter+deptCodeFilter
					+" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, TBLEPA_DAYSCORE.WINNAME "   
					+" )A group by a.logdate,a.winname " 
					+" )B group by b.winname "
					+" )Z  LEFT OUTER JOIN "  
					+" (SELECT WIN_NAME ,DESCR WIN_DESCR FROM ITM2MENU ) B   on Z.WINNAME=  B.WIN_NAME "   
					+" )C  where c.total_time>0.04 "+topNosFilter
					+" order by c.rank asc ";
        	   
        	   pstmt = conn.prepareStatement(sql);
  			   rs = pstmt.executeQuery();
			   while (rs.next())
				{
					rowData = new JSONObject();
					rowData.put("TASK_NAME", checkNull(rs.getString("WIN_DESCR"))+"["+checkNull(rs.getString("WINNAME"))+"]");
					rowData.put("task_code", checkNull(rs.getString("WINNAME")));					
					rowData.put("tot_time", checkNull(rs.getString("total_time"))+"@"+"{br}#Transactions: "+checkNull(rs.getString("jobid"))+"{br}Avg.Total Time:");
					rawDataEmpTopScoreJson.put(Integer.valueOf(count), rowData);
					count++;
				}
			}
			 System.out.println("fetch Data for getTaskWiseTimeServlet() : " + rawDataEmpTopScoreJson.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getTaskWiseTimeServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataEmpTopScoreJson;
	}
	
	/********** End of method getTaskWiseTimeServlet()  ******/
	
	
	
	/********** Start of method for  Worst E2-score Analysis 
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : getWorstE2ScoreAnalysisServlet
	 * Servlet Name       : WorstE2ScoreAnalysisServlet
	 * Metadata xml Name  : efftimeanalysis.xml
	 * 
	 * */
	@SuppressWarnings("unchecked")
	public JSONObject getWorstE2ScoreAnalysisServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawEffTimeJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		String empCodeFilter="",deptCodeFilter="",topNosFilter="",taskFilter="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
           if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ) )
			{
        	   System.out.println(" Inside getWorstE2ScoreAnalysisServlet()  for Data Soruc Name ="+dataSourceName);
        	   deptCode=deptCode.trim();
       	   frmPrd=frmPrd.trim();
       	   toPrd=toPrd.trim();
       	   
       	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
       	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));          	  
        	   int count = 0;
        	   if ((empTask != null) && (empTask.trim().length() > 0))
    		   {
    			   System.out.println("empTask" + empTask);
    			   empTask = dashbordUtil.getCommaSeparated(empTask);
    			   taskFilter = " AND TBLEPA_DAYSCORE.WINNAME IN (" + empTask + ") ";
    		   }
        	   if ((empCode != null) && (empCode.trim().length() > 0))
    		   {
    			   System.out.println("empCode" + empCode);
    			   empCode = dashbordUtil.getCommaSeparated(empCode);
    			   empCodeFilter = " AND employee.EMP_CODE IN (" + empCode + ") ";
    		   }
        	   if ((deptCode != null) && (deptCode.trim().length() > 0))
    		   {
    			   System.out.println("deptCode" + deptCode);
    			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
    			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
    		   }
        	   if ((topNos != null) && (topNos.trim().length() > 0))
    		   {
    			   System.out.println("topNos" + topNos);
    			   topNosFilter = " where D.RANK<="+topNos;
    		   }
        	   
        	   sql=" select  d.jobid ,d.emp_code,d.emp_name,d.e2score ,d.RANK "
					+" from ( "
					+" select sum(b.jobid) jobid,b.emp_code,b.emp_name,trunc(AVG(b.e2score),2) e2score ,dense_rank () OVER (ORDER BY (trunc(AVG(b.e2score),2)) asc) AS RANK "
					+" from ( "
					+" select count(z.jobid) jobid,z.logdate,z.emp_code,z.emp_name,trunc(AVG(z.e2score),2) e2score  from " 
					+" ( "
					+" select a.jobid,a.logdate,a.emp_code,a.emp_name,a.success,a.noatt,trunc(((a.success/a.noatt)*100 ),2) e2score from "
					+" ( "
					+" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code,TBLEPA_DAYSCORE.WINNAME ,   "
					+" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "  
					+" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "    
					+" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "    
					+" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "	   
					+" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt ,trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success " 
					+" from TBLEPA_DAYSCORE,EMPLOYEE,USERS,transetup " 
					+" where trim(tblEPA_dayScore.userid) =trim(USERS.CODE) "    
					+" and  USERS.entity_code = EMPLOYEE.EMP_CODE " 
					+" and tblEPA_dayScore.logdate >= '"+frmPrd+"' " 
							+" and tblEPA_dayScore.logdate <= '"+toPrd+"' "  
					+" and transetup.function_type='"+functionType+"'  and UPPER(TRIM(transetup.tran_window))='W_' ||UPPER(TRIM(TBLEPA_DAYSCORE.winname)) " 
					+" and USERS.usage_intensity='"+usageIntensity+"' " 
					+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' "
					+taskFilter+empCodeFilter+deptCodeFilter 
					+" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE,TBLEPA_DAYSCORE.WINNAME, " 
					+" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname " 
					+" )A )Z group by z.logdate,z.emp_code,z.emp_name "
					+" )B group by b.emp_code,b.emp_name ) D "+topNosFilter+"  order by d.RANK asc";
        	   pstmt = conn.prepareStatement(sql);
  			   rs = pstmt.executeQuery();
			   while (rs.next())
				{
					rowData = new JSONObject();
					rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));					
					rowData.put("e2_score", checkNull(rs.getString("e2score"))+"@"+checkNull(rs.getString("emp_name"))+"{br}#Transactions: "+checkNull(rs.getString("jobid"))+"{br}Avg.E2-Score:");					
					rawEffTimeJson.put(count, rowData);
					count++;
  				}
			}
           System.out.println("fetch Data for getWorstE2ScoreAnalysisServlet() : " + rawEffTimeJson.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getWorstE2ScoreAnalysisServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawEffTimeJson;
	}
	/********** End of method getWorstE2ScoreAnalysisServlet()  ******/
	
	/********** Start of method for  Top E2-score Analysis 
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : gettopE2ScoreAnalysisServlet
	 * Servlet Name       : TopE2ScoreAnalysisServlet
	 * Metadata xml Name  : efftimeanalysis.xml
	 * 
	 * */
	@SuppressWarnings("unchecked")
	public JSONObject getTopE2ScoreAnalysisServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawEffTimeJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		String empCodeFilter="",deptCodeFilter="",topNosFilter="",taskFilter="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
           if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ) )
			{
        	   System.out.println(" Inside getTopE2ScoreAnalysisServlet()  for Data Soruc Name ="+dataSourceName);
        	   deptCode=deptCode.trim();
       			frmPrd=frmPrd.trim();
       			toPrd=toPrd.trim();
       	   
       			frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
       			toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));        	  
        	   int count = 0;
        	   if ((empTask != null) && (empTask.trim().length() > 0))
    		   {
    			   System.out.println("empCode" + empTask);
    			   empTask = dashbordUtil.getCommaSeparated(empTask);
    			   taskFilter = " AND TBLEPA_DAYSCORE.WINNAME IN (" + empTask + ") ";
    		   }
        	   if ((empCode != null) && (empCode.trim().length() > 0))
    		   {
    			   System.out.println("empCode" + empCode);
    			   empCode = dashbordUtil.getCommaSeparated(empCode);
    			   empCodeFilter = " AND employee.EMP_CODE IN (" + empCode + ") ";
    		   }
        	   if ((deptCode != null) && (deptCode.trim().length() > 0))
    		   {
    			   System.out.println("deptCode" + deptCode);
    			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
    			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
    		   }
        	   if ((topNos != null) && (topNos.trim().length() > 0))
    		   {
    			   System.out.println("topNos" + topNos);
    			   topNosFilter = " where D.rank<="+topNos;
    		   }
        	 
        	   sql=" select  d.jobid ,d.emp_code,d.emp_name,d.e2score ,d.RANK "
   					+" from ( "
   					+" select sum(b.jobid) jobid,b.emp_code,b.emp_name,trunc(AVG(b.e2score),2) e2score ,dense_rank () OVER (ORDER BY (trunc(AVG(b.e2score),2)) desc) AS RANK "
   					+" from ( "
   					+" select count(z.jobid) jobid,z.logdate,z.emp_code,z.emp_name,trunc(AVG(z.e2score),2) e2score  from " 
   					+" ( "
   					+" select a.jobid,a.logdate,a.emp_code,a.emp_name,a.success,a.noatt,trunc(((a.success/a.noatt)*100 ),2) e2score from "
   					+" ( "
   					+" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code,TBLEPA_DAYSCORE.WINNAME ,   "
   					+" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "  
   					+" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "    
   					+" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "    
   					+" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "	   
   					+" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt ,trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success " 
   					+" from TBLEPA_DAYSCORE,EMPLOYEE,USERS,transetup " 
   					+" where trim(tblEPA_dayScore.userid) =trim(USERS.CODE) "    
   					+" and  USERS.entity_code = EMPLOYEE.EMP_CODE " 
   					+" and tblEPA_dayScore.logdate >= '"+frmPrd+"' " 
   					+" and tblEPA_dayScore.logdate <= '"+toPrd+"' "  
   					+" and transetup.function_type='"+functionType+"'  and UPPER(TRIM(transetup.tran_window))='W_' ||UPPER(TRIM(TBLEPA_DAYSCORE.winname)) " 
   					+" and USERS.usage_intensity='"+usageIntensity+"' " 
   					+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' "
   					+ taskFilter+empCodeFilter+deptCodeFilter 
   					+" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE,TBLEPA_DAYSCORE.WINNAME, " 
   					+" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname " 
   					+" )A )Z group by z.logdate,z.emp_code,z.emp_name "
   					+" )B group by b.emp_code,b.emp_name ) D "+topNosFilter+"  order by d.RANK asc";
        	   
        	   
        	   pstmt = conn.prepareStatement(sql);
  			   rs = pstmt.executeQuery();
			   while (rs.next())
				{
					rowData = new JSONObject();
					rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));					
					rowData.put("e2_score", checkNull(rs.getString("e2score"))+"@"+checkNull(rs.getString("emp_name"))+"{br}#Transactions: "+checkNull(rs.getString("jobid"))+"{br}Avg.E2-Score:");					
					rawEffTimeJson.put(count, rowData);
					count++;
  				}
			}
           System.out.println("fetch Data for getTopE2ScoreAnalysisServlet() : " + rawEffTimeJson.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getTopE2ScoreAnalysisServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawEffTimeJson;
	}
	/********** End of method getTopE2ScoreAnalysisServlet()  ******/
	
	/*-----START-------------DISTRIBUTION GRAPH [2ND LEVEL OF DRILL-DOWN]----------------------*/
	/********** Start of method for distribution of Time
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : getDistributionDetailServlet
	 * Servlet Name       : DistributionDetailServlet
	 * Metadata xml Name  : attemptdistribution.xml(SSGrid),timedistribution.xml
	 * 
	 * */
	@SuppressWarnings("unchecked")
	public JSONObject getDistributionDetailServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawEffTimeJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		double toj_per=0.0,suc_per=0.0,servert_per=0.0,oh_per=0.0;
		double tot_time    = 000.0;
		String fta_per     = "";
		double job_time=0,server_time=0.0,oh_time=0.0;
		String deptCodeFilter="",empTaskFilter="";
		String noAtt="",succAtt="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
		if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
		{
	    	   frmPrd=frmPrd.trim();
	    	   toPrd=toPrd.trim();
	    	   
	    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
	    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
			System.out.println(" Inside getDistributionDetailServlet()  for Data Soruc Name ="+dataSourceName);
			if ((empTask != null) && (empTask.trim().length() > 0))
 		   {
 			   System.out.println("empTask" + empTask);
 			   empTask = dashbordUtil.getCommaSeparated(empTask);
 			   empTaskFilter = " AND tblEPA_dayScore.WINNAME in (" + empTask + ") ";
 		   }
			 if ((deptCode != null) && (deptCode.trim().length() > 0))
  		   {
  			   System.out.println("deptCode" + deptCode);
  			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
  			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
  		   }
			 /*if ((topNos != null) && (topNos.trim().length() > 0))
  		   		{
  			   System.out.println("topNos" + topNos);
  			   topNosFilter = " where B.RN<="+topNos;
  		   	}*/
          
        	   deptCode=deptCode.trim();
        	   int count = 0;
        	   
        	   sql=" select b.emp_code,b.emp_name,TRUNC(AVG(b.servert/60),2) server_time , " 
   					+" TRUNC(AVG(b.oht/60),2) oh_time ,TRUNC(AVG(b.jobt/60),2) job_time, " 
   					+" TRUNC((AVG(B.OHT)/60+AVG(b.servert)/60+AVG(b.jobt)/60),2) TOTAL_TIME_MIN, " 
   					+" trunc(AVG(b.noatt),2) NOATTEMPTS,trunc(AVG(b.success),2) success , trunc(AVG(b.fail),2) fail " 
   					+" from ( "    					
   					+" select A.EMP_CODE,A.LOGDATE,"
   					+" A.EMP_NAME,trunc(AVG(A.SERVERT),2) SERVERT,trunc(AVG(A.OHT),2) OHT,trunc(AVG(a.JOBT),2) JOBT , " 
   					+" trunc(AVG(a.noatt),2) noatt,trunc(AVG(a.success),2) success,trunc(AVG(a.fail),2) fail "
   					+" from( " 
   					+" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code,TBLEPA_DAYSCORE.WINNAME , "
   					+" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || " 
   					+" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' " 
   					+" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else " 
   					+" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "
   					+" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert, " 
   					+" trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, " 
   					+" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt , " 
   					+" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt ,  "
   					+" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , "
   					+" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail " 
   					+" from TBLEPA_DAYSCORE,EMPLOYEE,USERS,transetup "
   					+" where trim(tblEPA_dayScore.userid) =trim(USERS.CODE) " 
   					+" and  USERS.entity_code = EMPLOYEE.EMP_CODE "	
   					+" and tblEPA_dayScore.logdate >= '"+frmPrd+"' "   
   					+" and tblEPA_dayScore.logdate <= '"+toPrd+"' "   
   					+" and transetup.function_type='"+functionType+"'  and UPPER(TRIM(transetup.tran_window))='W_' ||UPPER(TRIM(TBLEPA_DAYSCORE.winname)) " 
   					+" and USERS.usage_intensity='"+usageIntensity+"'  and TRIM(EMPLOYEE.EMP_CODE) ='"+empCode.trim()+"' " 					 
   					+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' " + empTaskFilter + deptCodeFilter 
   					+" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE,TBLEPA_DAYSCORE.WINNAME, " 
   					+" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname " 
   					+" )a  GROUP BY A.LOGDATE,A.EMP_CODE, A.EMP_NAME " 
   					+")b GROUP BY b.emp_code,b.emp_name ";
        	   
        	   pstmt = conn.prepareStatement(sql);
  			   rs = pstmt.executeQuery();
  			 while (rs.next())
				{
					rowData = new JSONObject();
					rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));
					rowData.put("no_of_attempt", checkNull(rs.getString("NOATTEMPTS")));					
					rowData.put("success", checkNull(rs.getString("success")));
					rowData.put("failure", checkNull(rs.getString("fail")));
					toj_per=0.0;
					servert_per=0.0;
					oh_per=0.0;

                    job_time=Double.parseDouble((checkZero(rs.getString("job_time"))));
                    server_time=Double.parseDouble((checkZero(rs.getString("server_time"))));
                    oh_time=Double.parseDouble((checkZero(rs.getString("oh_time"))));
					tot_time=Double.parseDouble((checkZero(rs.getString("TOTAL_TIME_MIN"))));

                    toj_per    = Math.round((job_time*100)/tot_time);
                    servert_per = Math.round((server_time*100)/tot_time);
				    oh_per      = Math.round((oh_time*100)/tot_time);

					rowData.put("overhead_time",oh_time+"@"+checkNull(rs.getString("EMP_NAME"))+","+oh_per+"%{br}Avg.Overhead Time:");
					rowData.put("job_time", job_time+"@"+checkNull(rs.getString("EMP_NAME"))+","+toj_per+"%{br}Avg.Job Time:");
					rowData.put("server_time", server_time+"@"+checkNull(rs.getString("EMP_NAME"))+","+servert_per+"%{br}Avg.Server Time:");
					
					noAtt = checkZero(rs.getString("NOATTEMPTS")) ;
					succAtt=checkNull(rs.getString("success"));
					fta_per=  checkZero(rs.getString("fail"));
					rowData.put("label", "Fail");
					rowData.put("value", fta_per);
					
					rawEffTimeJson.put(count, rowData);
					count++;
					System.out.println("fta_per: "+fta_per+"  suc_per: "+suc_per);
				}
			    rowData = new JSONObject();
			    rowData.put("EMP_CODE", "");
				rowData.put("no_of_attempt", "");					
				rowData.put("success", "");
				rowData.put("failure", "");
				rowData.put("overhead_time", "");
				rowData.put("job_time", "");
				rowData.put("server_time", "");				
				rowData.put("escore", "");
				rowData.put("job_time", "");
				rowData.put("label", "Sucess");
				rowData.put("value", succAtt);
				rawEffTimeJson.put(count, rowData);
				count++;
				rowData = new JSONObject();
			    rowData.put("EMP_CODE", "");
				rowData.put("no_of_attempt", "");					
				rowData.put("success", "");
				rowData.put("failure", "");
				rowData.put("overhead_time", "");
				rowData.put("job_time", "");
				rowData.put("server_time", "");				
				rowData.put("escore", "");
			    rowData.put("label", "No. Of Attempts");
				rowData.put("value", noAtt);
				rowData.put("toj_per", "");							
				rawEffTimeJson.put(count, rowData);
			}
		 System.out.println("fetch Data for getDistributionDetailServlet() : " + rawEffTimeJson.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getDistributionDetailServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawEffTimeJson;
	}
	/********** End of method getDistributionDetailServlet()  ******/
	
	/********** Start of method for overhead distribution of Time
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : getOHDistributionDetailServlet
	 * Servlet Name       : OHDistributionDetailServlet
	 * Metadata xml Name  : attemptdistribution.xml(SSGrid),timedistribution.xml
	 * 
	 * */
	//C1
	@SuppressWarnings("unchecked")
	public JSONObject getOHDistributionDetailServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawEffTimeJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		double toj_per=0.0,suc_per=0.0,servert_per=0.0,oh_per=0.0;
		double tot_time=000.0;
		String fta_per="";
		double job_time=0,server_time=0.0,oh_time=0.0;
		String deptCodeFilter="",empTaskFilter="",usgIntStr="";
		String noAtt="",succAtt="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
		if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
		{
	    	   frmPrd=frmPrd.trim();
	    	   toPrd=toPrd.trim();
	    	   
	    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
	    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
			System.out.println(" Inside getOHDistributionDetailServlet()  for Data Soruc Name ="+dataSourceName);
			if ((empTask != null) && (empTask.trim().length() > 0))
 		   {
 			   System.out.println("empTask" + empTask);
 			   empTask = dashbordUtil.getCommaSeparated(empTask);
 			   empTaskFilter = " AND tblEPA_dayScore.WINNAME in (" + empTask + ") ";
 		   }
			 if ((deptCode != null) && (deptCode.trim().length() > 0))
  		   {
  			   System.out.println("deptCode" + deptCode);
  			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
  			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
  		   }
			 /*if ((topNos != null) && (topNos.trim().length() > 0))
  		   		{
  			   System.out.println("topNos" + topNos);
  			   topNosFilter = " where B.RN<="+topNos;
  		   	}*/
			 /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
	    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
	    	   {
	    		   System.out.println("usage intensityin getOHDistributionDetailServlet :"+usageIntensity);
	    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
	    		   }
	    	   }
	    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
        	   deptCode=deptCode.trim();
        	   int count = 0;
        	   
        	  /* sql="select b.emp_code,b.emp_name,count(b.jobid) jobid, "
        			   +" TRUNC(AVG(b.servert/60),2) server_time ,  TRUNC(AVG(b.oht/60),2) oh_time ,TRUNC(AVG(b.jobt/60),2) job_time,  "
        			   +" TRUNC((AVG(B.OHT)/60+AVG(b.servert)/60+AVG(b.jobt)/60),2) TOTAL_TIME_MIN, "
        			   +" trunc(AVG(b.noatt),2) NOATTEMPTS,trunc(AVG(b.success),2) success , trunc(AVG(b.fail),2) fail "  
        			   +" from (  select distinct tblEPA_dayScore.jobid  jobid,EMPLOYEE.EMP_CODE as emp_code, "  
        			   +" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) ||  " 
        			   +" (CASE WHEN employee.emp_mname  IS  NULL  THEN ''  ELSE TRIM(Employee.emp_mname) || ' ' END) ||  "
        			   +" (case when EMPLOYEE.EMP_LNAME  is  null  then '' else  TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME ,  " 
        			   +" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert,  trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht,  " 
        			   +" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt    , "
        			   +" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt, "
        			   +" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success ,  " 
					   +" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail "
					   +" from tblEPA_dayScore LEFT OUTER JOIN transetup  "
					   +" ON ((transetup.TRAN_WINDOW = UPPER(tblEPA_dayScore.WINNAME)) "
					   +" OR (transetup.TRAN_WINDOW = 'w_' || tblEPA_dayScore.WINNAME) "
					   +" OR (transetup.TRAN_WINDOW = 't_' || tblEPA_dayScore.WINNAME)) "
					   +" inner join users on USERS.CODE = rpad(tblEPA_dayScore.userid,10,' ') " 
					   +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
					   +" where tblEPA_dayScore.logdate >= '"+frmPrd+"'  "
        			   +" and tblEPA_dayScore.logdate <= '"+toPrd+"'  " 
        			   +" and transetup.function_type='"+functionType+"'   "
        			   +" and UPPER(TRIM(transetup.tran_window))='W_' ||UPPER(TRIM(TBLEPA_DAYSCORE.winname) )   "
        			   +usgIntStr + empTaskFilter + deptCodeFilter
        			   +" and tblEPA_dayScore.ACtCode='VIEW'  and tblEPA_dayScore.oh > 0" 
        			   +" AND EMPLOYEE.EMP_CODE IN ('"+empCode.trim()+"')  " 
        			   +" group by tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, Employee.emp_mname,Employee.emp_lname,Employee.emp_fname  "
        			   +" )b GROUP BY b.emp_code,b.emp_name ";*/
        	   sql=" select b.emp_code,b.emp_name,count(b.jobid) jobid, "  
					+" TRUNC(AVG(b.servert/60),2) server_time ,  TRUNC(AVG(b.oht/60),2) oh_time ,TRUNC(AVG(b.jobt/60),2) job_time, "   
					+" TRUNC((AVG(B.OHT)/60+AVG(b.servert)/60+AVG(b.jobt)/60),2) TOTAL_TIME_MIN, "  
					+" trunc(AVG(b.noatt),2) NOATTEMPTS,trunc(AVG(b.success),2) success , trunc(AVG(b.fail),2) fail "    
					+" from (  select distinct tblEPA_dayScore.jobid  jobid,EMPLOYEE.EMP_CODE as emp_code, "    
					+" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "    
					+" (CASE WHEN employee.emp_mname  IS  NULL  THEN ''  ELSE TRIM(Employee.emp_mname) || ' ' END) || "   
					+" (case when EMPLOYEE.EMP_LNAME  is  null  then '' else  TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "    
					+" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert,  trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, "    
					+" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt, "
					+" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt, "  
					+" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , "    
					+" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail "  
					+" from tblEPA_dayScore "   
					+" inner join users on USERS.CODE = tblEPA_dayScore.userid "   
					+" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "  
					+" where " 
					+" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') "  
					+" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "        			   
				    +" and tblEPA_dayScore.transtype='"+functionType+"' "
					+ usgIntStr + empTaskFilter + deptCodeFilter +" and tblEPA_dayScore.ACtCode='VIEW'  and tblEPA_dayScore.oh > 0 "  
					+" AND EMPLOYEE.EMP_CODE IN ('"+empCode.trim()+"') "    
					+" group by tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "   
					+" )b GROUP BY b.emp_code,b.emp_name ";
        	   pstmt = conn.prepareStatement(sql);
  			   rs = pstmt.executeQuery();
  			 while (rs.next())
				{
					rowData = new JSONObject();
					rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));
					rowData.put("no_of_attempt", checkNull(rs.getString("NOATTEMPTS")));					
					rowData.put("success", checkNull(rs.getString("success")));
					rowData.put("failure", checkNull(rs.getString("fail")));
					toj_per=0.0;
					servert_per=0.0;
					oh_per=0.0;

                    job_time=Double.parseDouble((checkZero(rs.getString("job_time"))));
                    server_time=Double.parseDouble((checkZero(rs.getString("server_time"))));
                    oh_time=Double.parseDouble((checkZero(rs.getString("oh_time"))));
					tot_time=Double.parseDouble((checkZero(rs.getString("TOTAL_TIME_MIN"))));

                    toj_per    = Math.round((job_time*100)/tot_time);
                    servert_per = Math.round((server_time*100)/tot_time);
				    oh_per      = Math.round((oh_time*100)/tot_time);

					/*rowData.put("overhead_time",oh_time+"@"+checkNull(rs.getString("EMP_NAME"))+","+oh_per+"%{br}Avg.Overhead Time:");
					rowData.put("job_time", job_time+"@"+checkNull(rs.getString("EMP_NAME"))+","+toj_per+"%{br}Avg.Job Time:");
					rowData.put("server_time", server_time+"@"+checkNull(rs.getString("EMP_NAME"))+","+servert_per+"%{br}Avg.Server Time:");
					*/
					rowData.put("overhead_time",oh_time+"@"+checkNull(rs.getString("EMP_NAME"))+",{br}#Transactions: "+checkNull(rs.getString("jobid"))+",{br}Avg.Overhead Time:");
					rowData.put("job_time", job_time+"@"+checkNull(rs.getString("EMP_NAME"))+",{br}#Transactions: "+checkNull(rs.getString("jobid"))+",{br}Avg.Job Time:");
					rowData.put("server_time", server_time+"@"+checkNull(rs.getString("EMP_NAME"))+",{br}#Transactions: "+checkNull(rs.getString("jobid"))+",{br}Avg.Server Time:");
					
					
					noAtt = checkZero(rs.getString("NOATTEMPTS")) ;
					succAtt=checkNull(rs.getString("success"));
					fta_per=  checkZero(rs.getString("fail"));
					rowData.put("label", "Fail");
					rowData.put("value", fta_per);
					
					rawEffTimeJson.put(count, rowData);
					count++;
					System.out.println("fta_per: "+fta_per+"  suc_per: "+suc_per);
				}
			    rowData = new JSONObject();
			    rowData.put("EMP_CODE", "");
				rowData.put("no_of_attempt", "");					
				rowData.put("success", "");
				rowData.put("failure", "");
				rowData.put("overhead_time", "");
				rowData.put("job_time", "");
				rowData.put("server_time", "");				
				rowData.put("escore", "");
				rowData.put("job_time", "");
				rowData.put("label", "Sucess");
				rowData.put("value", succAtt);
				rawEffTimeJson.put(count, rowData);
				count++;
				rowData = new JSONObject();
			    rowData.put("EMP_CODE", "");
				rowData.put("no_of_attempt", "");					
				rowData.put("success", "");
				rowData.put("failure", "");
				rowData.put("overhead_time", "");
				rowData.put("job_time", "");
				rowData.put("server_time", "");				
				rowData.put("escore", "");
			    rowData.put("label", "No. Of Attempts");
				rowData.put("value", noAtt);
				rowData.put("toj_per", "");							
				rawEffTimeJson.put(count, rowData);
			}
		 System.out.println("fetch Data for getOHDistributionDetailServlet() : " + rawEffTimeJson.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getOHDistributionDetailServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawEffTimeJson;
	}
	/********** End of method getOHDistributionDetailServlet()  ******/

	/********** Start of method for  distribution of  Number of Attempts Pie chart
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : getPieChartDistributionDetailServlet
	 * Servlet Name       : PieChartDistributionDetailServlet
	 * Metadata xml Name  : attemptdistribution.xml(Pie-Chart)
	 * 
	 * */
	//c2
	@SuppressWarnings("unchecked")
	public JSONObject getPieChartDistributionDetailServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawEffTimeJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		double fta_per=0.0,suc_per=0.0;	
		String deptCodeFilter="",empTaskFilter="";
		String fail_att="",succ_att="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
			  if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
				{
		    	   frmPrd=frmPrd.trim();
		    	   toPrd=toPrd.trim();
		    	   
		    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
		    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
				  System.out.println(" Inside getPieChartDistributionDetailServlet()  for No of Attempts Data Soruc Name ="+dataSourceName);
			if ((empTask != null) && (empTask.trim().length() > 0))
 		   {
 			   System.out.println("empTask" + empTask);
 			   empTask = dashbordUtil.getCommaSeparated(empTask);
 			   empTaskFilter = " AND tblEPA_dayScore.WINNAME in (" + empTask + ") ";
 		   }
			 if ((deptCode != null) && (deptCode.trim().length() > 0))
  		   {
  			   System.out.println("deptCode" + deptCode);
  			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
  			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
  		   }
			 /*if ((topNos != null) && (topNos.trim().length() > 0))
  		   		{
  			   System.out.println("topNos" + topNos);
  			   topNosFilter = " where B.RN<="+topNos;
  		   		}*/
         
        	   deptCode=deptCode.trim();
        	   int count = 0;
        	   
        	   sql=" select b.emp_code,trunc(sum(b.success),2) success , trunc(sum(b.fail),2) fail "
 					  +" from ( " 				
 					  +" select A.EMP_CODE,A.LOGDATE, trunc(sum(a.success),2) success,trunc(sum(a.fail),2) fail " 
 					  +" from( " 
 					  +"  select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,employee.emp_code, " 
 					  +" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , "
 					  +" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail " 
 					  +" from TBLEPA_DAYSCORE,EMPLOYEE,USERS,transetup "
 					  +" where trim(tblEPA_dayScore.userid) =trim(USERS.CODE) "
 					  +" and  USERS.entity_code = EMPLOYEE.EMP_CODE " 
 					  +" and tblEPA_dayScore.logdate >= '"+frmPrd+"' "  
 					  +"  and tblEPA_dayScore.logdate <= '"+toPrd+"' "  
 					  +" and transetup.function_type='"+functionType+"'  and UPPER(TRIM(transetup.tran_window))='W_' ||UPPER(TRIM(TBLEPA_DAYSCORE.winname)) "  
 					  +" and USERS.usage_intensity='"+usageIntensity+"' " + empTaskFilter + deptCodeFilter
 					  +" and TRIM(EMPLOYEE.EMP_CODE) ='"+empCode.trim()+"' "		 
 					  +" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' " 
 					  +" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE " 
 					  +" )a  GROUP BY A.LOGDATE,A.EMP_CODE "	
 					  +" )b GROUP BY b.emp_code ";
        	   
        	   pstmt = conn.prepareStatement(sql);
  			   rs = pstmt.executeQuery();
			   while (rs.next())
				{
					rowData = new JSONObject();
					 fail_att = checkNull(rs.getString("fail"));
					 succ_att =  checkNull(rs.getString("success"));
					rowData.put("attempt", "Fail");
					rowData.put("fta_per", fail_att);
					rawEffTimeJson.put(count, rowData);
					count++;
					System.out.println("fta_per: "+fta_per+"  suc_per: "+suc_per);
  				}
			    rowData = new JSONObject();			    
			    rowData.put("attempt", "Sucess");
				rowData.put("fta_per", succ_att);
				rawEffTimeJson.put(count, rowData);
			}
			  System.out.println("fetch Data for getPieChartDistributionDetailServlet() : " + rawEffTimeJson.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getPieChartDistributionDetailServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawEffTimeJson;
	}
	/********** End of method getPieChartDistributionDetailServlet()  ******/
/*-----END-------------DISTRIBUTION GRAPH [2ND LEVEL OF DRILL-DOWN]----------------------*/
////////////////////////////////////////////////////////////////////////////////////////////
	

/*-----------------START-------- DATE WISE GRAPHS [3RD LEVEL OF DRILL DOWN]------------*/
	

	/********** Start of method for Employee date wise OverHead Distribution for Time
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : getDayWiseOHDistServlet
	 * Servlet Name       : DayWiseOHDistServlet
	 * Metadata xml Name  : overheadtimedistribution.xml,servertimedistribution.xml,tojdistribution.xml
	 * 
	 * */
	@SuppressWarnings("unchecked")
	public JSONObject getDayWiseOHDistServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String empCode,String deptCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawDayDistJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		String deptCodeFilter="",empTaskFilter="",empCodeFilter="",usgIntStr="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
        	  
        	   int count = 0;
        	   if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
   			   {
           	   frmPrd=frmPrd.trim();
           	   toPrd=toPrd.trim();
           	   
           	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
           	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
        		   System.out.println(" Inside method  for task time,time day wise details with overheads="+dataSourceName);
        	   if ((empCode != null && empCode.trim().length()>0 ))
        	   {
        		   empCode=empCode.trim();
        		   System.out.println("empCode" + empCode);
        		   empCode = dashbordUtil.getCommaSeparated(empCode);
        		   empCodeFilter = " and EMPLOYEE.EMP_CODE in ("+empCode+") ";
        	   }
        	   if ((empTask != null) && (empTask.trim().length() > 0))
     		   {
     			   System.out.println("empTask" + empTask);
     			   String tempArr [];
     			   if(empTask.indexOf(",")!=-1)
     			   {
     				  tempArr= empTask.split(",");
     				  empTask="";
     				  for(int i=0;i<tempArr.length;i++)
     				  {
     					  if(i==0)
     					    empTask="W_"+(tempArr[i]).toUpperCase();
     					  else 
     						 empTask=empTask+",W_"+(tempArr[i]).toUpperCase();
     				  }
     			   }
     			   else if(empTask.indexOf("[")!=-1 )
     			   {
     				  empTask=(empTask.substring((empTask.indexOf("[")+1),empTask.indexOf("]"))).toUpperCase();
     				  System.out.println("empTask for task wise : "+empTask);
               	   }
     			   else
     			   {
     				  empTask="W_"+empTask.toUpperCase();
     			   }
     			   empTask = dashbordUtil.getCommaSeparated(empTask);
     			   empTaskFilter = " AND 'W_'||UPPER(TRIM(tblEPA_dayScore.WINNAME)) in (" + empTask + ") ";
     		   }
        	   if ((deptCode != null) && (deptCode.trim().length() > 0))
      		   {
        		   deptCode=deptCode.trim();
      			   System.out.println("deptCode" + deptCode);
      			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
      			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
      		   }
        	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
	    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
	    	   {
	    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
	    		   }
	    	   }
	    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
        		 /*  sql=" select B.LOGDATE,B.EMP_CODE,B.EMP_NAME,b.SERVERT,b.oht,b.jobt,b.total_time,b.noatt,b.success,b.fail "
        		   +" from ( select A.LOGDATE,A.EMP_CODE,A.EMP_NAME,trunc(AVG(A.SERVERT/60),2) SERVERT,trunc(AVG(A.OHT/60),2) OHT," 
        		   +"trunc(AVG(JOBT/60),2) JOBT ,trunc((AVG(A.SERVERT/60)+AVG(A.OHT/60)+AVG(JOBT/60)),2) total_time , "
					+" trunc(AVG(a.noatt),2) noatt,trunc(AVG(a.success),2) success,trunc(AVG(a.fail),2) fail "
					+" From ( "
					+" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code,  " 
					+" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || " 
					+" (CASE WHEN employee.emp_mname  IS  NULL  THEN ''   "
					+" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else  " 
					+" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME ,	 "
					+" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert, "
					+" trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht,   "
					+" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt , "
					+" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt , "
					+" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , "
					+" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail  "
					 +" from tblEPA_dayScore LEFT OUTER JOIN transetup  "
					 +" ON ((transetup.TRAN_WINDOW = UPPER(tblEPA_dayScore.WINNAME)) "
					 +" OR (transetup.TRAN_WINDOW = 'w_' || tblEPA_dayScore.WINNAME) "
					 +" OR (transetup.TRAN_WINDOW = 't_' || tblEPA_dayScore.WINNAME)) "
					 +" inner join users on USERS.CODE = rpad(tblEPA_dayScore.userid,10,' ') " 
					 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
					 +" where tblEPA_dayScore.logdate >= '"+frmPrd+"'   "
					+" and tblEPA_dayScore.logdate <= '"+toPrd+"'  "
					+" and transetup.function_type='"+functionType+"' "
					+usgIntStr+" and TRIM(tblEPA_dayScore.ACtCode) ='VIEW' and tblEPA_dayScore.oh>0 " +empCodeFilter 
					+deptCodeFilter	 +empTaskFilter 				
					+" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, "
					+" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "
					+" ) A GROUP BY A.LOGDATE,A.EMP_CODE,A.EMP_NAME )B ORDER BY to_date(B.logdate,'DD/MM/YY') asc ";*/
        		   
        	   sql="select B.LOGDATE,B.EMP_CODE,B.EMP_NAME,b.SERVERT,b.oht,b.jobt,b.total_time,b.noatt,b.success,b.fail "  
        			   +" from ( select A.LOGDATE,A.EMP_CODE,A.EMP_NAME,trunc(AVG(A.SERVERT/60),2) SERVERT,trunc(AVG(A.OHT/60),2) OHT, "  
        			   +" trunc(AVG(JOBT/60),2) JOBT ,trunc((AVG(A.SERVERT/60)+AVG(A.OHT/60)+AVG(JOBT/60)),2) total_time , "  
        			   +" trunc(AVG(a.noatt),2) noatt,trunc(AVG(a.success),2) success,trunc(AVG(a.fail),2) fail "  
        			   +" From ( "  
        			   +" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code, "    
        			   +" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "   
        			   +" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "    
        			   +" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "    
        			   +" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "	  
        			   +" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert, "  
        			   +" trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, "    
        			   +" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt , "  
        			   +" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt , "  
        			   +" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , "  
        			   +" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail "   
        			   +" from tblEPA_dayScore "  
        			   +" inner join users on  USERS.CODE = tblEPA_dayScore.userid "   
        			   +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "  
        			   +" where to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') "  
					   +" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "        			   
					   +"  and tblEPA_dayScore.transtype='"+functionType+"' " +usgIntStr +empCodeFilter +deptCodeFilter	 +empTaskFilter 				
					   +" and TRIM(tblEPA_dayScore.ACtCode) ='VIEW' and tblEPA_dayScore.oh>0 " 			
					   +" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, "  
					  +" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "  
					  +" ) A GROUP BY A.LOGDATE,A.EMP_CODE,A.EMP_NAME )B ORDER BY to_date(B.logdate,'DD/MM/YY') asc ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				while (rs.next())
				   {
					rowData = new JSONObject();
					rowData.put("log_date", checkNull(rs.getString("LOGDATE")));
					rowData.put("oh_time" , checkNull(rs.getString("OHT")));
					rowData.put("server_time",checkNull(rs.getString("SERVERT")));
					rowData.put("job_time",checkNull(rs.getString("JOBT")));
					rowData.put("failure" ,checkNull(rs.getString("fail")));
					rowData.put("success" ,checkNull(rs.getString("success")));
					rowData.put("e2_score",checkNull(rs.getString("noatt")));
					rowData.put("total_time",checkNull(rs.getString("total_time")));
					rawDayDistJson.put(count, rowData);
					count++;
				   }
			   System.out.println("rawDayDistJson: "+rawDayDistJson);
   			}
        	   System.out.println("fetch Data for getDayWiseOHDistServlet() : " + rawDayDistJson.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getDayWiseOHDistServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}		
		return rawDayDistJson;
	}
	/********** End of method getDayWiseOHDistServlet()  ******/
	
	/********** Start of method for Employee date wise Distribution for Time
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : getDayWiseDistributionServlet
	 * Servlet Name       : DayWiseDistributionServlet
	 * Metadata xml Name  : overheadtimedistribution.xml,servertimedistribution.xml,tojdistribution.xml
	 * 
	 * */
	@SuppressWarnings("unchecked")
	public JSONObject getDayWiseDistributionServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String empCode,String deptCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawDayDistJson = new JSONObject();
		JSONObject rowData        = null;
		String sql                = "";
		ResultSet rs              = null;
		PreparedStatement pstmt   = null;
		Connection conn           = null;
		String deptCodeFilter="",empTaskFilter="",empCodeFilter="",usgIntStr="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
        	  
        	   int count = 0;
        	   if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
   			   {
           	   frmPrd=frmPrd.trim();
           	   toPrd=toPrd.trim();
           	   
           	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
           	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
        		   System.out.println(" Inside method  for task time,time day wise details ="+dataSourceName);
        	   if ((empCode != null && empCode.trim().length()>0 ))
        	   {
        		   empCode=empCode.trim();
        		   System.out.println("empCode" + empCode);
        		   empCode = dashbordUtil.getCommaSeparated(empCode);
        		   empCodeFilter = " and EMPLOYEE.EMP_CODE in ("+empCode+") ";
        	   }
        	   if ((empTask != null) && (empTask.trim().length() > 0))
     		   {
     			   System.out.println("empTask" + empTask);
     			   String tempArr [];
     			   if(empTask.indexOf(",")!=-1)
     			   {
     				  tempArr= empTask.split(",");
     				  empTask="";
     				  for(int i=0;i<tempArr.length;i++)
     				  {
     					  if(i==0)
     					    empTask="W_"+(tempArr[i]).toUpperCase();
     					  else 
     						 empTask=empTask+",W_"+(tempArr[i]).toUpperCase();
     				  }
     			   }
     			   else if(empTask.indexOf("[")!=-1 )
     			   {
     				  empTask=(empTask.substring((empTask.indexOf("[")+1),empTask.indexOf("]"))).toUpperCase();
     				  System.out.println("empTask for task wise : "+empTask);
               	   }
     			   else
     			   {
     				  empTask="W_"+empTask.toUpperCase();
     			   }
     			   empTask = dashbordUtil.getCommaSeparated(empTask);
     			   empTaskFilter = " AND 'W_'||UPPER(TRIM(tblEPA_dayScore.WINNAME)) in (" + empTask + ") ";
     		   }
        	   if ((deptCode != null) && (deptCode.trim().length() > 0))
      		   {
        		   deptCode=deptCode.trim();
      			   System.out.println("deptCode" + deptCode);
      			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
      			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
      		   }
        	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
	    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
	    	   {
	    		   System.out.println("usageIntensity in date wise : "+usageIntensity);
	    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
	    		   }
	    	   }
	    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
        		 /*  sql=" select B.LOGDATE,B.EMP_CODE,B.EMP_NAME,b.SERVERT,b.oht,b.jobt,b.total_time,b.noatt,b.success,b.fail "
        		   +" from ( select A.LOGDATE,A.EMP_CODE,A.EMP_NAME,trunc(AVG(A.SERVERT/60),2) SERVERT,trunc(AVG(A.OHT/60),2) OHT," 
        		   +"trunc(AVG(JOBT/60),2) JOBT ,trunc((AVG(A.SERVERT/60)+AVG(A.OHT/60)+AVG(JOBT/60)),2) total_time , "
					+" trunc(AVG(a.noatt),2) noatt,trunc(AVG(a.success),2) success,trunc(AVG(a.fail),2) fail "
					+" From ( "
					+" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code,TBLEPA_DAYSCORE.WINNAME ,  " 
					+" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || " 
					+" (CASE WHEN employee.emp_mname  IS  NULL  THEN ''   "
					+" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else  " 
					+" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME ,	 "
					+" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert, "
					+" trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht,   "
					+" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt , "
					+" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt , "
					+" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , "
					+" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail  "
					 +" from tblEPA_dayScore LEFT OUTER JOIN transetup  "
					 +" ON ((transetup.TRAN_WINDOW = UPPER(tblEPA_dayScore.WINNAME)) "
					 +" OR (transetup.TRAN_WINDOW = 'w_' || tblEPA_dayScore.WINNAME) "
					 +" OR (transetup.TRAN_WINDOW = 't_' || tblEPA_dayScore.WINNAME)) "
					 +" inner join users on USERS.CODE = rpad(tblEPA_dayScore.userid,10,' ') " 
					 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
					 +" where tblEPA_dayScore.logdate >= '"+frmPrd+"' "
					+" and tblEPA_dayScore.logdate <= '"+toPrd+"' "
					+" and transetup.function_type='"+functionType+"' "
					+usgIntStr+empCodeFilter 
					+deptCodeFilter	 +empTaskFilter +" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' "					
					+" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE,TBLEPA_DAYSCORE.WINNAME, "
					+" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "
					+" ) A GROUP BY A.LOGDATE,A.EMP_CODE,A.EMP_NAME )B where b.total_time>0.04 ORDER BY to_date(B.logdate,'DD/MM/YY') asc";
        		   */
        		   sql="select B.LOGDATE,B.EMP_CODE,B.EMP_NAME,b.SERVERT,b.oht,b.jobt,b.total_time,b.noatt,b.success,b.fail "  
        				   +" from ( select A.LOGDATE,A.EMP_CODE,A.EMP_NAME,trunc(AVG(A.SERVERT/60),2) SERVERT,trunc(AVG(A.OHT/60),2) OHT, "  
        				   +" trunc(AVG(JOBT/60),2) JOBT ,trunc((AVG(A.SERVERT/60)+AVG(A.OHT/60)+AVG(JOBT/60)),2) total_time , "  
        				   +" trunc(AVG(a.noatt),2) noatt,trunc(AVG(a.success),2) success,trunc(AVG(a.fail),2) fail "  
        				   +" From ( "  
        				   +" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code,TBLEPA_DAYSCORE.WINNAME , "    
        				   +" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "   
        				   +" (CASE WHEN employee.emp_mname  IS  NULL  THEN ''    "
        				   +" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "    
        				   +" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "	  
        				   +" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert, "  
        				   +" trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, "    
        				   +" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt , "  
        				   +" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt , "  
        				   +" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , "  
        				   +" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail "   
        				   +" from tblEPA_dayScore " 
        				   +" inner join users on  USERS.CODE = tblEPA_dayScore.userid "  
        				   +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "  
        				   +" where to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') "  
					       +" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "        			   
					       +"  and tblEPA_dayScore.transtype='"+functionType+" '" +usgIntStr+empCodeFilter +deptCodeFilter	 +empTaskFilter  
					       +" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' "  					
					       +" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE,TBLEPA_DAYSCORE.WINNAME, "  
					       +" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "  
					       +" ) A GROUP BY A.LOGDATE,A.EMP_CODE,A.EMP_NAME )B where b.total_time>0.04 ORDER BY to_date(B.logdate,'DD/MM/YY') asc ";
        	   
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				while (rs.next())
				   {
					rowData = new JSONObject();
					rowData.put("log_date", checkNull(rs.getString("LOGDATE")));
					rowData.put("oh_time" , checkNull(rs.getString("OHT")));
					rowData.put("server_time",checkNull(rs.getString("SERVERT")));
					rowData.put("job_time",checkNull(rs.getString("JOBT")));
					rowData.put("failure" ,checkNull(rs.getString("fail")));
					rowData.put("success" ,checkNull(rs.getString("success")));
					rowData.put("e2_score",checkNull(rs.getString("noatt")));
					rowData.put("total_time",checkNull(rs.getString("total_time")));
					rawDayDistJson.put(count, rowData);
					count++;
				   }
			   System.out.println("rawDayDistJson: "+rawDayDistJson);
   			}
        	   System.out.println("fetch Data for getDayWiseDistributionServlet() : " + rawDayDistJson.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getDayWiseDistributionServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}		
		return rawDayDistJson;
	}
	
	/********** End of method getDayWiseDistributionServlet()  ******/


	/********** Start of method for Employee date wise Distribution for Number of attempts
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : getDayWiseNoattDistServlet
	 * Servlet Name       : DayWiseNoattDistServlet
	 * Metadata xml Name  : successdistribution.xml.
	 * 
	 * */
	@SuppressWarnings("unchecked")
	public JSONObject getDayWiseNoattDistServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String empCode,String deptCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawDayDistJson = new JSONObject(); 
		JSONObject rowData        = null;
		String sql                = "";
		ResultSet rs              = null;
		PreparedStatement pstmt   = null;
		Connection conn           = null;
		String deptCodeFilter="",empTaskFilter="",empCodeFilter="",usgIntStr="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
        	  
        	   int count = 0;
        	   if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
   			   {
           	   frmPrd=frmPrd.trim();
           	   toPrd=toPrd.trim();
           	   
           	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
           	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
        		   System.out.println(" Inside method  for no of attempts day wise details ="+dataSourceName);
        	   if ((empCode != null && empCode.trim().length()>0 ))
        	   {
        		   empCode=empCode.trim();
        		   System.out.println("empCode" + empCode);
        		   empCode = dashbordUtil.getCommaSeparated(empCode);
        		   empCodeFilter = " and Employee.EMP_CODE in ("+empCode+") ";
        	   }
        	   if ((empTask != null) && (empTask.trim().length() > 0))
     		   {
     			   System.out.println("empTask" + empTask);
     			   String tempArr [];
     			   if(empTask.indexOf(",")!=-1)
     			   {
     				  tempArr= empTask.split(",");
     				  empTask="";
     				  for(int i=0;i<tempArr.length;i++)
     				  {
     					  if(i==0)
     					    empTask="W_"+(tempArr[i]).toUpperCase();
     					  else 
     						 empTask=empTask+",W_"+(tempArr[i]).toUpperCase();
     				  }
     			   }
     			   else if(empTask.indexOf("[")!=-1 )
     			   {
     				  empTask=(empTask.substring((empTask.indexOf("[")+1),empTask.indexOf("]"))).toUpperCase();
     				  System.out.println("empTask for task wise : "+empTask);
               	   }
     			   else
     			   {
     				  empTask="W_"+empTask.toUpperCase();
     			   }
     			   empTask = dashbordUtil.getCommaSeparated(empTask);
     			   empTaskFilter = " AND 'W_'||UPPER(TRIM(tblEPA_dayScore.WINNAME)) in (" + empTask + ") ";
     		   }
        	   if ((deptCode != null) && (deptCode.trim().length() > 0))
      		   {
        		   deptCode=deptCode.trim();
      			   System.out.println("deptCode" + deptCode);
      			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
      			   deptCodeFilter = " and Employee.DEPT_CODE in ("+deptCode+") ";
      		   }
        	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
	    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
	    	   {
	    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
	    		   }
	    	   }
	    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
        	
        		
        	   sql=" select B.LOGDATE,b.success,b.fail " 
				   +" from ( select A.LOGDATE,trunc(sum(a.success),2) success,trunc(sum(a.fail),2) fail " 
				   +" From ( " 
				   +" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE , "
				   +" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , " 
				   +" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail "  
				   +" from tblEPA_dayScore "
					 +" inner join users on USERS.CODE = tblEPA_dayScore.userid " 
					 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
					 +" where " 
				   +" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') "  
				   +" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "
				   +" and tblEPA_dayScore.transtype='"+functionType+"' " 
				   +usgIntStr +empCodeFilter +deptCodeFilter	 +empTaskFilter 
				   +" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' "					
				   +" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid "
				   +" ) A GROUP BY A.LOGDATE "
				   +" )B  ORDER BY to_date(B.logdate,'DD/MM/YY') asc ";
        	   
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				while (rs.next())
				   {
					rowData = new JSONObject();
					rowData.put("log_date", checkNull(rs.getString("logdate")));
					rowData.put("failure" ,checkNull(rs.getString("fail")));
					rowData.put("success" ,checkNull(rs.getString("success")));
					rawDayDistJson.put(count, rowData);
					count++;
				   }
				 System.out.println("fetch Data for getDayWiseNoattDistServlet() : " + rawDayDistJson.toString());
   			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getDayWiseNoattDistServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}		
		return rawDayDistJson;
	}
	
	/********** End of method getDayWiseNoattDistServlet()  ******/
	
	/********** Start of method for Employee E-Score date wise Distribution
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : getDayWiseEscoreDistributionServlet
	 * Servlet Name       : DayWiseEscoreDistributionServlet
	 * Metadata xml Name  : escoredistribution.xml
	 * 
	 * */
	@SuppressWarnings("unchecked")
	public JSONObject getDayWiseEscoreDistributionServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String empCode,String deptCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawDayDistJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		String deptCodeFilter="",empTaskFilter="",empCodeFilter="",usgIntStr="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
			if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
			   {
		    	   frmPrd=frmPrd.trim();
		    	   toPrd=toPrd.trim();
		    	   
		    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
		    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
        	   System.out.println("Inside getDayWiseEscoreDistributionServlet() for seperated method  for Data Soruc Name ="+dataSourceName);
        	   deptCode=deptCode.trim();
        	   empCode=empCode.trim();
        	   int count = 0;
        	   if ((empCode != null && empCode.trim().length()>0 ))
        	   {
        		   System.out.println("empCode" + empCode);
        		   empCode = dashbordUtil.getCommaSeparated(empCode);
        		   empCodeFilter = " and EMPLOYEE.EMP_CODE in ("+empCode+") ";
        	   }
        	   if ((deptCode != null) && (deptCode.trim().length() > 0))
      		   {
      			   System.out.println("deptCode" + deptCode);
      			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
      			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
      		   }
        	   if ((empTask != null) && (empTask.trim().length() > 0))
     		   {
     			   System.out.println("empTask" + empTask);
     			   String tempArr [];
     			   if(empTask.indexOf(",")!=-1)
     			   {
     				  tempArr= empTask.split(",");
     				  empTask="";
     				  for(int i=0;i<tempArr.length;i++)
     				  {
     					  if(i==0)
     					    empTask="W_"+(tempArr[i]).toUpperCase();
     					  else 
     						 empTask=empTask+",W_"+(tempArr[i]).toUpperCase();
     				  }
     				 System.out.println("empTask in , separated :" + empTask);
     			   }
     			   else if(empTask.indexOf("[")!=-1 )
     			   {
     				  empTask=(empTask.substring((empTask.indexOf("[")+1),empTask.indexOf("]"))).toUpperCase();
     				  System.out.println("empTask for task wise : "+empTask);
               	   }
     			   else
     			   {
     				  empTask="W_"+empTask.toUpperCase();
     			   }
     			   empTask = dashbordUtil.getCommaSeparated(empTask);
     			   empTaskFilter = " AND 'W_'||UPPER(TRIM(tblEPA_dayScore.WINNAME)) in (" + empTask + ") ";
     		   }
        	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
	    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
	    	   {
	    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
	    		   }
	    	   }
	    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
                 sql="select B.LOGDATE,B.EMP_CODE,B.EMP_NAME,b.escore "
					 +" from ( select A.LOGDATE,A.EMP_CODE,A.EMP_NAME,trunc(AVG(A.escore),2) escore  "
					 +" From (   " 					
					 +" select  tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code, "
					 +" TBLEPA_DAYSCORE.WINNAME ,   (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) ||  "
					 +"  (CASE WHEN employee.emp_mname  IS  NULL  THEN ''     ELSE TRIM(Employee.emp_mname) || ' ' END) || "
					 +" (case when EMPLOYEE.EMP_LNAME  is  null  then '' else   TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "  
					 +" trunc(AVG(nvl((tblEPA_dayScore.adjescore),0)),2) as escore  " 
					 +" from tblEPA_dayScore "
					 +" inner join users on USERS.CODE = tblEPA_dayScore.userid " 
					 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
					 +" where "
					 +" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') " 
					 +" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "   
					 +" and tblEPA_dayScore.transtype='"+functionType+"' " 
					 +usgIntStr+empCodeFilter +empTaskFilter +deptCodeFilter
					 +" and tblEPA_dayScore.jobid !='NA'  "
					 +" and tblEPA_dayScore.ACtCode!='VIEW' and tblEPA_dayScore.adjescore>0   "
					 +" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE,TBLEPA_DAYSCORE.WINNAME,  " 
					 +"  Employee.emp_mname,Employee.emp_lname,Employee.emp_fname" 					
					 +"  ) A GROUP BY A.LOGDATE,A.EMP_CODE,A.EMP_NAME )B  ORDER BY to_date(B.logdate,'DD/MM/YY') asc ";
        		   
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				while (rs.next())
				   {
					 rowData = new JSONObject();
					 rowData.put("log_date", checkNull(rs.getString("LOGDATE")));
					 rowData.put("escore"  , checkNull(rs.getString("escore")));
					 rawDayDistJson.put(count, rowData);
					 count++;
				   }
				System.out.println("fetch Data for getDayWiseEscoreDistributionServlet() : " + rawDayDistJson.toString());
   			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getDayWiseEscoreDistributionServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}		
		return rawDayDistJson;
	}
	/********** End of method getDayWiseEscoreDistributionServlet()  ******/
	
	
	
	/********** Start of method for Employee E-Score date Distribution for Task Analysis
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : getDateWiseTaskWiseEscoreDistServlet
	 * Servlet Name       : DateWiseTaskWiseEscoreDistServlet
	 * Metadata xml Name  : escoretaskdistribution.xml
	 * 
	 * */
	@SuppressWarnings("unchecked")
	public JSONObject getDateWiseTaskWiseEscoreDistServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String empCode,String deptCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawDayDistJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		String deptCodeFilter="",empCodeFilter="",usgIntStr="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/	
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
			  if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
  			   {
		    	   frmPrd=frmPrd.trim();
		    	   toPrd=toPrd.trim();
		    	   
		    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
		    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
        	   System.out.println("Inside getDateWiseTaskWiseEscoreDistServlet() for seperated method  for Data Soruc Name ="+dataSourceName);
        	   deptCode=deptCode.trim();
        	   empCode=empCode.trim();
        	   int count = 0;
        	   if ((empCode != null && empCode.trim().length()>0 ))
        	   {
        		   System.out.println("empCode" + empCode);
        		   empCode = dashbordUtil.getCommaSeparated(empCode);
        		   empCodeFilter = " and EMPLOYEE.EMP_CODE in ("+empCode+") ";
        	   }
        	   if ((deptCode != null) && (deptCode.trim().length() > 0))
      		   {
      			   System.out.println("deptCode" + deptCode);
      			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
      			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
      		   }
        	   if(empTask.indexOf("[")!=-1 )
 			   {
 				  empTask=(empTask.substring((empTask.indexOf("[")+1),empTask.indexOf("]"))).toUpperCase();
 				  System.out.println("empTask for task wise : "+empTask);
           	   }
        	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
	    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
	    	   {
	    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
	    		   }
	    	   }
	    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
        	 
                 sql="select A.LOGDATE,trunc(AVG(A.escore),2) as escore "
					+" From (  "   
					+" select distinct TBLEPA_DAYSCORE.jobid, TBLEPA_DAYSCORE.LOGDATE,  TBLEPA_DAYSCORE.WINNAME , "  
					+" trunc((nvl(AVG(tblEPA_dayScore.adjescore),0)),2) as escore " 
					 +" from tblEPA_dayScore "
					 +" inner join users on USERS.CODE = tblEPA_dayScore.userid " 
					 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
					 +" where "
					 +" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') " 
					 +" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "  
					+ "and tblEPA_dayScore.transtype='"+functionType+"' " 
					+usgIntStr  
					+" AND 'W_'||UPPER(TRIM(tblEPA_dayScore.WINNAME)) = UPPER('"+empTask+"') and tblEPA_dayScore.jobid !='NA' "   
					+" and tblEPA_dayScore.ACtCode!='VIEW' and tblEPA_dayScore.adjescore > 0  "  +empCodeFilter+ deptCodeFilter
					+" group by TBLEPA_DAYSCORE.logdate,TBLEPA_DAYSCORE.WINNAME,TBLEPA_DAYSCORE.jobid "  
					+"  ) A GROUP BY A.LOGDATE "
					+"  ORDER BY to_date(a.logdate,'DD/MM/YY') asc ";
        		   
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				while (rs.next())
				   {
					 rowData = new JSONObject();
					 rowData.put("log_date", checkNull(rs.getString("LOGDATE")));
					 rowData.put("escore"  , checkNull(rs.getString("escore")));
					 rawDayDistJson.put(count, rowData);
					 count++;
				   }
				 System.out.println("fetch Data for getDateWiseTaskWiseEscoreDistServlet() : " + rawDayDistJson.toString());
   			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getDateWiseTaskWiseEscoreDistServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}		
		return rawDayDistJson;
	}
	/********** End of method getDateWiseTaskWiseEscoreDistServlet()  ******/
	
	/********** Start of method for Employee Date wise Time Distribution for Task Analysis
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : getDateWiseTaskWiseTimeDistServlet
	 * Servlet Name       : DateWiseTaskWiseTimeDistServlet
	 * Metadata xml Name  : etaskwisetimedistribution.xml
	 * 
	 * */
	@SuppressWarnings("unchecked")
	public JSONObject getDateWiseTaskWiseTimeDistServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String empCode,String deptCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawDayDistJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		String deptCodeFilter="",empCodeFilter="",usgIntStr="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/	
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
			 if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
 			   {
		    	   frmPrd=frmPrd.trim();
		    	   toPrd=toPrd.trim();		    	   
		    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
		    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
        	   System.out.println("Inside getDateWiseTaskWiseTimeDistServlet() for seperated method  for Data Soruc Name ="+dataSourceName);
        	   deptCode=deptCode.trim();
        	   empCode=empCode.trim();
        	   int count = 0;
        	   if ((empCode != null && empCode.trim().length()>0 ))
        	   {
        		   System.out.println("empCode" + empCode);
        		   empCode = dashbordUtil.getCommaSeparated(empCode);
        		   empCodeFilter = " and EMPLOYEE.EMP_CODE in ("+empCode+") ";
        	   }
        	   if ((deptCode != null) && (deptCode.trim().length() > 0))
      		   {
      			   System.out.println("deptCode" + deptCode);
      			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
      			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
      		   }
        	   if(empTask.indexOf("[")!=-1 )
 			   {
 				  empTask=(empTask.substring((empTask.indexOf("[")+1),empTask.indexOf("]"))).toUpperCase();
 				  System.out.println("empTask for task wise : "+empTask);
           	   }
        	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
	    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
	    	   {
	    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
	    		   }
	    	   }
	    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
        		 sql="select count(a.jobid),A.LOGDATE,trunc(AVG(A.SERVERT/60),2) SERVERT,trunc(AVG(A.OHT/60),2) OHT,"
						+" trunc(AVG(JOBT/60),2) JOBT ,trunc((AVG(A.SERVERT/60)+AVG(A.OHT/60)+AVG(JOBT/60)),2) total_time" 
						+" From ("    
						+" select distinct TBLEPA_DAYSCORE.jobid, TBLEPA_DAYSCORE.LOGDATE,  TBLEPA_DAYSCORE.WINNAME ,"
						+" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert,  trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht," 
						+" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt" 
						+" from tblEPA_dayScore "
						+" inner join users on USERS.CODE = tblEPA_dayScore.userid " 
						+" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
						+" where "
						+" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') " 
					    +" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "  
						+ "  and tblEPA_dayScore.transtype='"+functionType+"'" +usgIntStr
						+" AND 'W_'||UPPER(TRIM(tblEPA_dayScore.WINNAME))  = UPPER('"+empTask+"')   and tblEPA_dayScore.jobid !='NA'  " 
						+" and tblEPA_dayScore.ACtCode!='VIEW'    "+empCodeFilter+ deptCodeFilter
						+" group by TBLEPA_DAYSCORE.logdate,TBLEPA_DAYSCORE.WINNAME,TBLEPA_DAYSCORE.jobid " 
						 +" ) A GROUP BY A.LOGDATE"
						 +" ORDER BY to_date(a.logdate,'DD/MM/YY') asc ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				while (rs.next())
				   {
					 rowData = new JSONObject();
					 rowData.put("log_date", checkNull(rs.getString("LOGDATE")));
					 rowData.put("total_time"  , checkNull(rs.getString("total_time")));
					 rawDayDistJson.put(count, rowData);
					 count++;
				   }
				 System.out.println("fetch Data for getDateWiseTaskWiseTimeDistServlet() : " + rawDayDistJson.toString());
   			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getDateWiseTaskWiseTimeDistServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}		
		return rawDayDistJson;
	}
	/********** End of method getDateWiseTaskWiseTimeDistServlet()  ******/
	
	/********** Start of method for Employee E2-Score date Distribution
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : getDateWiseE2scoreDistributionServlet
	 * Servlet Name       : DateWiseE2scoreDistributionServlet
	 * Metadata xml Name  : e2scoredistribution.xml
	 * 
	 * */
	@SuppressWarnings("unchecked")
	public JSONObject getDateWiseE2scoreDistributionServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String empCode,String deptCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawDayDistJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		String deptCodeFilter="",taskFilter="",empCodeFilter="",usgIntStr="";	   
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
			frmPrd=frmPrd.trim();
	    	   toPrd=toPrd.trim();		    	   
	    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
	    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
            if ((empCode != null && empCode.trim().length()>0 ))
			{
        	   System.out.println(" Inside getDateWiseE2scoreDistributionServlet() for seperated method  for Data Soruc Name ="+dataSourceName);
        	   deptCode=deptCode.trim();
        	   empCode=empCode.trim();
        	   int count = 0;
        	   if ((deptCode != null) && (deptCode.trim().length() > 0))
      		   {
      			   System.out.println("deptCode" + deptCode);
      			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
      			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
      		   }
        	   if ((empTask != null) && (empTask.trim().length() > 0))
    		   {
    			   System.out.println("empTask" + empTask);
    			   empTask = dashbordUtil.getCommaSeparated(empTask);
    			   taskFilter = " AND TBLEPA_DAYSCORE.WINNAME IN (" + empTask + ") ";
    		   }
        	   if ((empCode != null) && (empCode.trim().length() > 0))
    		   {
    			   System.out.println("empCode" + empCode);
    			   empCode = dashbordUtil.getCommaSeparated(empCode);
    			   empCodeFilter = " AND employee.EMP_CODE IN (" + empCode + ") ";
    		   }
        	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
	    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
	    	   {
	    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
	    		   }
	    	   }
	    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
        	   
        	   sql="select b.logdate,b.emp_code,b.emp_name,trunc(AVG(b.e2score),2) e2score "
					 +" from "
					 +" ( "
					 +" select a.logdate,a.emp_code,a.emp_name,a.success,a.noatt,trunc(((a.success/a.noatt)*100 ),2) e2score from "
					 +" ( "
					 +" select distinct tblEPA_dayScore.jobid  jobid,TBLEPA_DAYSCORE.LOGDATE,EMPLOYEE.EMP_CODE as emp_code,TBLEPA_DAYSCORE.WINNAME , " 
					 +" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) ||  "
					 +" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "   
					 +" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "   
					+" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME ,	"   
					+" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt ,trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success" 
					 +" from tblEPA_dayScore "
					 +" inner join users on USERS.CODE = tblEPA_dayScore.userid " 
					 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
					 +" where "
					 +" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') " 
					 +" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "  
					+" and tblEPA_dayScore.transtype='"+functionType+"' "
					+usgIntStr+ empCodeFilter + taskFilter + deptCodeFilter	
					+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' "
					+" group by TBLEPA_DAYSCORE.logdate,tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE,TBLEPA_DAYSCORE.WINNAME, " 
					+" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "
					+" )A "
					+" )B group by  b.logdate,b.emp_code,b.emp_name "
					+" order by to_date(b.logdate,'DD/MM/YY') ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				while (rs.next())
				   {
					rowData = new JSONObject();
					rowData.put("log_date", checkNull(rs.getString("logdate")));					
				    rowData.put("e2_score", checkNull(rs.getString("e2score")));
					rawDayDistJson.put(count, rowData);
					count++;
				   }
				 System.out.println("fetch Data for getDateWiseE2scoreDistributionServlet() : " + rawDayDistJson.toString());
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getDateWiseE2scoreDistributionServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}		
		return rawDayDistJson;
	}
	/********** End of method getDateWiseE2scoreDistributionServlet()  ******/	
	
/*-----------------END-------- DATE WISE GRAPHS [3RD LEVEL OF DRILL DOWN]------------*/
	
///////////////////////////////////////////*START OF JOB ID WISE GRAPHS*////////////////////////////////////////////////////////////////////
        
/*---------START------EMPLOYEE WISE GRAPH [1ST LEVEL OF DASHBOARD]--------------*/
 

/********** Start of method for Top Time Analysis 
* EJB Name           : EmpProductivity.java
* Method Name        : getTopTimeJobIdWiseServlet(String,String,String,String,String,String)
* Servlet Name       : TopTimeJobIdWiseServlet
* Metadata xml Name  : efftimeanalysis.xml
* 
* */
@SuppressWarnings("unchecked")
public JSONObject getTopTimeJobIdWiseServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
{
	JSONObject rawEffTimeJson = new JSONObject();
	JSONObject rowData        = null;
	String sql                = "";
	ResultSet rs              = null;
	PreparedStatement pstmt   = null;
	Connection conn = null;
	String empCodeFilter="",deptCodeFilter="",topNosFilter="",empTaskFilter="",usgIntStr="";
	DashboardUtility dashbordUtil = new DashboardUtility();
	try
	{
		/*conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;*/	
		/*add new code for connection DB on dated:16062016 by Nikhil*/
		conn = getConnection();
		
       if ( (frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ) )
		{
    	   System.out.println(" Inside getTopTimeJobIdWiseServlet()  for Data Soruc Name ="+dataSourceName);
    	   deptCode=deptCode.trim();
    	   frmPrd=frmPrd.trim();
    	   toPrd=toPrd.trim();		    	   
    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));        	  
    	   int count = 0;
    	   if ((empTask != null) && (empTask.trim().length() > 0))
		   {
			   System.out.println("empTask" + empTask);
			   empTask = dashbordUtil.getCommaSeparated(empTask);
			   empTaskFilter = " AND TBLEPA_DAYSCORE.WINNAME in (" + empTask + ") ";
		   }
    	   if ((empCode != null) && (empCode.trim().length() > 0))
		   {
			   System.out.println("empCode" + empCode);
			   empCode = dashbordUtil.getCommaSeparated(empCode);
			   empCodeFilter = " AND EMPLOYEE.EMP_CODE IN (" + empCode + ") ";
		   }
    	   if ((deptCode != null) && (deptCode.trim().length() > 0))
		   {
			   System.out.println("deptCode" + deptCode);
			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
		   }
    	   if ((topNos != null) && (topNos.trim().length() > 0))
		   {
			   System.out.println("topNos" + topNos);
			   topNosFilter = " AND D.RANK<="+topNos;
		   }
    	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
    	   {
    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
    		   }
    	   }
    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
    	   /*
    	   sql=" select D.emp_code,D.emp_name,D.JOBID,D.servert,D.oht,D.jobt,D.tot_time_min,D.RANK from ( "
					 +" select c.emp_code,c.emp_name,c.JOBID,c.servert,c.oht,c.jobt,c.tot_time_min, " 
					 +" dense_rank () OVER (ORDER BY (c.tot_time_min) asc) AS RANK " 
					 +" from( " 
					 +"  select b.emp_code,b.emp_name,count(b.jobid) jobid,TRUNC(AVG(b.servert/60),2) servert , " 
					 +" TRUNC(AVG(b.oht/60),2) OHT ,TRUNC(AVG(b.jobt/60),2) JOBT, TRUNC((AVG(B.OHT)/60+AVG(b.servert)/60+AVG(b.jobt)/60),2) tot_time_min "
					 +" from ( "  
					 +" select distinct tblEPA_dayScore.jobid  jobid,EMPLOYEE.EMP_CODE as emp_code, "
					 +" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "   
					 +" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "   
					 +" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else " 
					 +" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "	
					 +" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert, " 
					 +" trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, "   
					 +" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt "
					 +" from tblEPA_dayScore LEFT OUTER JOIN transetup  "
					 +" ON ((transetup.TRAN_WINDOW = UPPER(tblEPA_dayScore.WINNAME)) "
					 +" OR (transetup.TRAN_WINDOW = 'w_' || tblEPA_dayScore.WINNAME) "
					 +" OR (transetup.TRAN_WINDOW = 't_' || tblEPA_dayScore.WINNAME)) "
					 +" inner join users on USERS.CODE = rpad(tblEPA_dayScore.userid,10,' ') " 
					 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
					 +" where tblEPA_dayScore.logdate >= '" +frmPrd + "' " 
					 +" and tblEPA_dayScore.logdate <= '" +toPrd + "' "    
					 +" and transetup.function_type='"+functionType+"' " 
					 +usgIntStr+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' "  
					 +empTaskFilter+empCodeFilter +deptCodeFilter
					 +" group by tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "  		
					 +" )b GROUP BY b.emp_code,b.emp_name) C) D where D.tot_time_min>0.04 "+topNosFilter+" order by D.RANK asc ";
		*/
    	   sql=" select D.emp_code,D.emp_name,D.JOBID,D.servert,D.oht,D.jobt,D.tot_time_min,D.RANK from ( "  
			+" select c.emp_code,c.emp_name,c.JOBID,c.servert,c.oht,c.jobt,c.tot_time_min, "   
			+" dense_rank () OVER (ORDER BY (c.tot_time_min) asc) AS RANK "   
			+" from( "   
			+"  select b.emp_code,b.emp_name,count(b.jobid) jobid,TRUNC(AVG(b.servert/60),2) servert , "   
			+" TRUNC(AVG(b.oht/60),2) OHT ,TRUNC(AVG(b.jobt/60),2) JOBT,  TRUNC( (  TRUNC(AVG(b.oht/60),2)+TRUNC(AVG(b.servert/60),2) +TRUNC(AVG(b.jobt/60),2)  ) ,2) tot_time_min "  
			+" from ( "    
			+" select distinct tblEPA_dayScore.jobid  jobid,EMPLOYEE.EMP_CODE as emp_code, "  
			+" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "     
			+" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "     
			+" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "   
			+" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "  	
			+" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert, "   
			+" trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, "     
			+" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt "  
			+" from " 
			+" tblEPA_dayScore "  
			+" inner join users on USERS.CODE = tblEPA_dayScore.userid "  
			+" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code " 
			+" where "
			+" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('" +frmPrd + "','dd/mm/yy') "  
			+" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('" +toPrd + "','dd/mm/yy') " 
			+" and  tblEPA_dayScore.transtype='"+functionType+"' " +usgIntStr +empTaskFilter+empCodeFilter +deptCodeFilter
			+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' "  
			+" group by tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "    		
			+" )b GROUP BY b.emp_code,b.emp_name) C) D where D.tot_time_min>0.04 "+topNosFilter+"  order by D.RANK asc ";		 
    	   
    	   
    	   pstmt = conn.prepareStatement(sql);
		   rs = pstmt.executeQuery();
		   while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));
				rowData.put("tot_time_spent", checkNull(rs.getString("tot_time_min"))+"@"+checkNull(rs.getString("EMP_NAME"))+"{br}#Transactions: "+checkNull(rs.getString("JOBID"))+"{br}Avg.Total Time:");
				rawEffTimeJson.put(count, rowData);
				count++;
			}
		}
       System.out.println("fetch Data for getTopTimeJobIdWiseServlet() : " + rawEffTimeJson.toString());
	}
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	} finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				rs.close();
				rs = null;
				if (pstmt != null)
				pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :EmpProductivity : getTopTimeJobIdWiseServlet() :" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawEffTimeJson;
}
/********** End of method getTopTimeJobIdWiseServlet()  ******/

/********** Start of method for Worst Time Analysis 
* EJB Name           : EmpProductivity.java
* Method Name        : getWorstTimeJobIdWiseServlet(String,String,String,String,String,String)
* Servlet Name       : WorstTimeJobIdWiseServlet
* Metadata xml Name  : efftimeanalysis.xml
* 
* */
@SuppressWarnings("unchecked")
public JSONObject getWorstTimeJobIdWiseServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
{
	JSONObject rawEffTimeJson = new JSONObject();
	JSONObject rowData        = null;
	String sql                = "";
	ResultSet rs              = null;
	PreparedStatement pstmt   = null;
	Connection conn           = null;
	String empCodeFilter="",deptCodeFilter="",topNosFilter="",empTaskFilter="",usgIntStr="";
	DashboardUtility dashbordUtil = new DashboardUtility();
	try
	{
		/*conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;*/
		/*add new code for connection DB on dated:16062016 by Nikhil*/
		conn = getConnection();
		
       if ( (frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ) )
		{
    	   System.out.println(" Inside getWorstTimeJobIdWiseServlet()  for Data Soruc Name ="+dataSourceName);
    	   deptCode=deptCode.trim();
    	   frmPrd=frmPrd.trim();
    	   toPrd=toPrd.trim();		    	   
    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));         	  
    	   int count = 0;
    	   if ((empTask != null) && (empTask.trim().length() > 0))
		   {
			   System.out.println("empTask" + empTask);
			   empTask = dashbordUtil.getCommaSeparated(empTask);
			   empTaskFilter = " AND TBLEPA_DAYSCORE.WINNAME in (" + empTask + ") ";
		   }
    	   if ((empCode != null) && (empCode.trim().length() > 0))
		   {
			   System.out.println("empCode" + empCode);
			   empCode = dashbordUtil.getCommaSeparated(empCode);
			   empCodeFilter = " AND employee.EMP_CODE IN (" + empCode + ") ";
		   }
    	   if ((deptCode != null) && (deptCode.trim().length() > 0))
		   {
			   System.out.println("deptCode" + deptCode);
			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
		   }
    	   if ((topNos != null) && (topNos.trim().length() > 0))
		   {
			   System.out.println("topNos" + topNos);
			   topNosFilter = " AND D.RANK<="+topNos;
		   }
    	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
    	   {
    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
    		   }
    	   }
    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
    	   /*
    	   sql=" select D.emp_code,D.emp_name,D.JOBID,D.servert,D.oht,D.jobt,D.tot_time_min,D.RANK from ( "
					 +" select c.emp_code,c.emp_name,c.JOBID,c.servert,c.oht,c.jobt,c.tot_time_min, " 
					 +" dense_rank () OVER (ORDER BY (c.tot_time_min) desc) AS RANK " 
					 +" from( " 
					 +"  select b.emp_code,b.emp_name,count(b.jobid) jobid,TRUNC(AVG(b.servert/60),2) servert , " 
					 +" TRUNC(AVG(b.oht/60),2) OHT ,TRUNC(AVG(b.jobt/60),2) JOBT, TRUNC((AVG(B.OHT)/60+AVG(b.servert)/60+AVG(b.jobt)/60),2) tot_time_min "
					 +" from ( "  
					 +" select distinct tblEPA_dayScore.jobid  jobid,EMPLOYEE.EMP_CODE as emp_code, "
					 +" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "   
					 +" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "   
					 +" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else " 
					 +" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "	
					 +" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert, " 
					 +" trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, "   
					 +" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt "
					 +" from tblEPA_dayScore LEFT OUTER JOIN transetup  "
					 +" ON ((transetup.TRAN_WINDOW = UPPER(tblEPA_dayScore.WINNAME)) "
					 +" OR (transetup.TRAN_WINDOW = 'w_' || tblEPA_dayScore.WINNAME) "
					 +" OR (transetup.TRAN_WINDOW = 't_' || tblEPA_dayScore.WINNAME)) "
					 +" inner join users on USERS.CODE = rpad(tblEPA_dayScore.userid,10,' ') " 
					 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
					 +" where tblEPA_dayScore.logdate >= '"+frmPrd+ "' " 
					 +" and tblEPA_dayScore.logdate <= '"+toPrd+ "' "    
					 +" and transetup.function_type='"+functionType+"' " 
					 +usgIntStr+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' "  
					 +empTaskFilter+empCodeFilter +deptCodeFilter
					 +" group by tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "  		
					 +" )b GROUP BY b.emp_code,b.emp_name) C) D where D.tot_time_min>0.04 "+topNosFilter+" order by D.RANK asc ";
    	   */
    	   
    	   sql=" select D.emp_code,D.emp_name,D.JOBID,D.servert,D.oht,D.jobt,D.tot_time_min,D.RANK from ( "  
    				+" select c.emp_code,c.emp_name,c.JOBID,c.servert,c.oht,c.jobt,c.tot_time_min, "   
    				+" dense_rank () OVER (ORDER BY (c.tot_time_min) desc) AS RANK "   
    				+" from( "   
    				+"  select b.emp_code,b.emp_name,count(b.jobid) jobid,TRUNC(AVG(b.servert/60),2) servert , "   
    				+" TRUNC(AVG(b.oht/60),2) OHT ,TRUNC(AVG(b.jobt/60),2) JOBT, TRUNC( (  TRUNC(AVG(b.oht/60),2)+TRUNC(AVG(b.servert/60),2) +TRUNC(AVG(b.jobt/60),2)  ) ,2) tot_time_min "  
    				+" from ( "    
    				+" select distinct tblEPA_dayScore.jobid  jobid,EMPLOYEE.EMP_CODE as emp_code, "  
    				+" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "     
    				+" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "     
    				+" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "   
    				+" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "  	
    				+" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert, "   
    				+" trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, "     
    				+" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt "  
    				+" from " 
    				+" tblEPA_dayScore "  
    				+" inner join users on USERS.CODE = tblEPA_dayScore.userid "  
    				+" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code " 
    				+" where "
    				+" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('" +frmPrd + "','dd/mm/yy') "  
    				+" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('" +toPrd + "','dd/mm/yy') " 
    				+" and  tblEPA_dayScore.transtype='"+functionType+"' " +usgIntStr +empTaskFilter+empCodeFilter +deptCodeFilter
    				+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' "  
    				+" group by tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "    		
    				+" )b GROUP BY b.emp_code,b.emp_name) C) D where D.tot_time_min>0.04 "+topNosFilter+"  order by D.RANK asc ";		 
    	    	   
    	   pstmt = conn.prepareStatement(sql);
		   rs = pstmt.executeQuery();
		   while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));
				rowData.put("tot_time_spent", checkNull(rs.getString("tot_time_min"))+"@"+checkNull(rs.getString("EMP_NAME"))+"{br}#Transactions: "+checkNull(rs.getString("JOBID"))+"{br}Avg.Total Time:");				
				rawEffTimeJson.put(count, rowData);
				count++;
			}
		}
       System.out.println("fetch Data for getWorstTimeJobIdWiseServlet() : " + rawEffTimeJson.toString());
	}
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	} finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				rs.close();
				rs = null;
				if (pstmt != null)
				pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :EmpProductivity : getWorstTimeJobIdWiseServlet() :" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawEffTimeJson;
}
/********** End of method getWorstTimeJobIdWiseServlet()  ******/

/********** Start of method for  Top no of attempts Analysis 
* EJB Name           : EmpProductivity.java
* Method Name        : getTopNumAttemptJobIdWiseServlet
* Servlet Name       : TopNumAttemptJobIdWiseServlet
* Metadata xml Name  : efftimeanalysis.xml
* 
* */
@SuppressWarnings("unchecked")
public JSONObject getTopNumAttemptJobIdWiseServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
{
	JSONObject rawEffTimeJson = new JSONObject();
	JSONObject rowData = null;
	String sql         = "";
	ResultSet rs       = null;
	PreparedStatement pstmt = null;
	Connection conn    = null;
	String empCodeFilter="",deptCodeFilter="",topNosFilter="",empTaskFilter="",usgIntStr="";
	DashboardUtility dashbordUtil = new DashboardUtility();
	try
	{
		/*conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;*/	
		/*add new code for connection DB on dated:16062016 by Nikhil*/
		conn = getConnection();
       if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
		{
    	   System.out.println(" Inside getTopNumAttemptJobIdWiseServlet()  for Data Soruc Name ="+dataSourceName);
    	   deptCode=deptCode.trim();
    	   frmPrd=frmPrd.trim();
    	   toPrd=toPrd.trim();		    	   
    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));          	  
    	   int count = 0;
    	   if ((empTask != null) && (empTask.trim().length() > 0))
		   {
			   System.out.println("empTask" + empTask);
			   empTask = dashbordUtil.getCommaSeparated(empTask);
			   empTaskFilter = " AND TBLEPA_DAYSCORE.WINNAME in (" + empTask + ") ";
		   }
    	   if ((empCode != null) && (empCode.trim().length() > 0))
		   {
			   System.out.println("empCode" + empCode);
			   empCode = dashbordUtil.getCommaSeparated(empCode);
			   empCodeFilter = " AND EMPLOYEE.EMP_CODE IN (" + empCode + ") ";
		   }
    	   if ((deptCode != null) && (deptCode.trim().length() > 0))
		   {
			   System.out.println("deptCode" + deptCode);
			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
		   }
    	   if ((topNos != null) && (topNos.trim().length() > 0))
		   {
			   System.out.println("topNos" + topNos);
			   topNosFilter = " where D.RANK<="+topNos;
		   }
    	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
    	   {
    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
    		   }
    	   }
    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
    	   
    	   sql="select D.emp_code,D.emp_name,D.JOBID,D.noatt,D.success,D.fail,D.RANK from ( " 
					 +" select c.emp_code,c.JOBID,c.emp_name,trunc(c.noatt,2) noatt,trunc(c.success,2) success,trunc(c.fail,2) fail, "
					 +" dense_rank () OVER (ORDER BY (c.noatt) asc) AS RANK  "
					 +" from( " 
					 +" select b.emp_code,b.emp_name,count(b.jobid) jobid, " 
					 +" trunc(AVG(b.noatt),2) noatt,trunc(AVG(b.success),2) success, trunc(AVG(b.fail),2) fail "
					 +" from (  "
					 +" select distinct tblEPA_dayScore.jobid  jobid,EMPLOYEE.EMP_CODE as emp_code, "
					 +" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || " 
					 +" (CASE WHEN employee.emp_mname  IS  NULL  THEN ''  "
					 +" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else " 
					 +" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "   
					 +" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt , "
					 +" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , " 
					 +" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail " 
					 +" from tblEPA_dayScore "
					 +" inner join users on USERS.CODE = tblEPA_dayScore.userid " 
					 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
					 +" where" 
					 +" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('" +frmPrd + "','dd/mm/yy') "  
    				+" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('" +toPrd + "','dd/mm/yy') " 
					 +" and tblEPA_dayScore.transtype='"+functionType+"' " 
					 +usgIntStr +" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' " 	
					 +empTaskFilter+empCodeFilter +deptCodeFilter 
					 +" group by tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, "
					 +" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname " 			
					 +" )b GROUP BY b.emp_code,b.emp_name ) C )D "+topNosFilter+"  order by D.RANK asc "; 
    	  
    	   pstmt = conn.prepareStatement(sql);
		   rs = pstmt.executeQuery();
		   while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));
				rowData.put("no_of_attempt", checkNull(rs.getString("noatt"))+"@"+checkNull(rs.getString("EMP_NAME"))+"{br}#Transactions: "+checkNull(rs.getString("JOBID"))+"{br}Avg.No. of Attempts:");					
				rawEffTimeJson.put(count, rowData);
				count++;
			}
		}
       System.out.println("fetch Data for getTopNumAttemptJobIdWiseServlet() : " + rawEffTimeJson.toString());
	}
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	} finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				rs.close();
				rs = null;
				if (pstmt != null)
				pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :EmpProductivity : getTopNumAttemptJobIdWiseServlet() :" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawEffTimeJson;
}
/********** End of method getTopNumAttemptJobIdWiseServlet()  ******/
	

/********** Start of method for  Worst no of attempts Analysis 
 * EJB Name           : EmpProductivity.java
 * Method Name        : getWorstNumAttemptJobIdWiseServlet
 * Servlet Name       : WorstNumAttemptJobIdWiseServlet
 * Metadata xml Name  : efftimeanalysis.xml
 * 
 * */
@SuppressWarnings("unchecked")
public JSONObject getWorstNumAttemptJobIdWiseServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
{
	JSONObject rawEffTimeJson = new JSONObject();
	JSONObject rowData        = null;
	String sql                = "";
	ResultSet rs              = null;
	PreparedStatement pstmt   = null;
	Connection conn           = null;
	String empCodeFilter="",deptCodeFilter="",topNosFilter="",empTaskFilter="",usgIntStr="";
	DashboardUtility dashbordUtil = new DashboardUtility();
	try
	{
		/*conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;*/
		/*add new code for connection DB on dated:16062016 by Nikhil*/
		conn = getConnection();
       if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ) )
		{
    	   System.out.println(" Inside getWorstNumAttemptJobIdWiseServlet()  for Data Soruc Name ="+dataSourceName);
    	   deptCode=deptCode.trim();
    	   frmPrd=frmPrd.trim();
    	   toPrd=toPrd.trim();		    	   
    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));          	  
    	   int count = 0;
    	   if ((empTask != null) && (empTask.trim().length() > 0))
		   {
			   System.out.println("empTask" + empTask);
			   empTask = dashbordUtil.getCommaSeparated(empTask);
			   empTaskFilter = " AND TBLEPA_DAYSCORE.WINNAME in (" + empTask + ") ";
		   }
    	   if ((empCode != null) && (empCode.trim().length() > 0))
		   {
			   System.out.println("empCode" + empCode);
			   empCode = dashbordUtil.getCommaSeparated(empCode);
			   empCodeFilter = " AND EMPLOYEE.EMP_CODE IN (" + empCode + ") ";
		   }
    	   if ((deptCode != null) && (deptCode.trim().length() > 0))
		   {
			   System.out.println("deptCode" + deptCode);
			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in (" +deptCode+ ") ";
		   }
    	   if ((topNos != null) && (topNos.trim().length() > 0))
		   {
			   System.out.println("topNos" + topNos);
			   topNosFilter = " where D.RANK<="+topNos;
		   }

    	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
    	   {
    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
    		   }
    	   }
    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
    	   
    	   sql="select D.emp_code,D.emp_name,D.JOBID,D.noatt,D.success,D.fail,D.RANK from ( " 
					 +" select c.emp_code,c.JOBID,c.emp_name,trunc(c.noatt,2) noatt,trunc(c.success,2) success,trunc(c.fail,2) fail, "
					 +" dense_rank () OVER (ORDER BY (c.noatt) desc) AS RANK  "
					 +" from( " 
					 +" select b.emp_code,b.emp_name,count(b.jobid) jobid, " 
					 +" trunc(AVG(b.noatt),2) noatt,trunc(AVG(b.success),2) success, trunc(AVG(b.fail),2) fail "
					 +" from (  "
					 +" select distinct tblEPA_dayScore.jobid  jobid,EMPLOYEE.EMP_CODE as emp_code, "
					 +" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || " 
					 +" (CASE WHEN employee.emp_mname  IS  NULL  THEN ''  "
					 +" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else " 
					 +" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "   
					 +" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt , "
					 +" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , " 
					 +" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail " 
					 +" from tblEPA_dayScore "
					 +" inner join users on USERS.CODE = tblEPA_dayScore.userid " 
					 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
					 +" where "
					 +" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('" +frmPrd + "','dd/mm/yy') "  
    				+" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('" +toPrd + "','dd/mm/yy') " 
					 +" and tblEPA_dayScore.transtype='"+functionType+"' " 
					 +usgIntStr+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' " 	
					 +empTaskFilter+empCodeFilter +deptCodeFilter 
					 +" group by tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, "
					 +" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname " 			
					 +" )b GROUP BY b.emp_code,b.emp_name ) C )D "+topNosFilter+"  order by D.RANK asc "; 

    	   pstmt = conn.prepareStatement(sql);
			   rs = pstmt.executeQuery();
		   while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));					
				rowData.put("no_of_attempt", checkNull(rs.getString("noatt"))+"@"+checkNull(rs.getString("EMP_NAME"))+"{br}#Transactions: "+checkNull(rs.getString("JOBID"))+"{br}Avg.No. of Attempts:");					
				rawEffTimeJson.put(count, rowData);
				count++;
				}
		}
       System.out.println("fetch Data for getWorstNumAttemptJobIdWiseServlet() : " + rawEffTimeJson.toString());
	}
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	} finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				rs.close();
				rs = null;
				if (pstmt != null)
				pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :EmpProductivity : getWorstNumAttemptJobIdWiseServlet() :" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawEffTimeJson;
}
/********** End of method getWorstNumAttemptJobIdWiseServlet()  ******/


/********** Start of method for  Top E2-score Job Id wise 
 * EJB Name           : EmpProductivity.java
 * Method Name        : getTopE2ScoreJobIdWiseServlet
 * Servlet Name       : TopE2ScoreJobIdWiseServlet
 * Metadata xml Name  : efftimeanalysis.xml
 * 
 * */
@SuppressWarnings("unchecked")
public JSONObject getTopE2ScoreJobIdWiseServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
{
	JSONObject rawEffTimeJson = new JSONObject();
	JSONObject rowData = null;
	String sql         = "";
	ResultSet rs       = null;
	PreparedStatement pstmt = null;
	Connection conn    = null;
	String empCodeFilter="",deptCodeFilter="",topNosFilter="",taskFilter="",usgIntStr="";
	DashboardUtility dashbordUtil = new DashboardUtility();
	try
	{
		/*conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;	*/
		/*add new code for connection DB on dated:16062016 by Nikhil*/
		conn = getConnection();
       if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ) )
		{
    	   System.out.println(" Inside getTopE2ScoreJobIdWiseServlet()  for Data Soruc Name ="+dataSourceName);
    	   deptCode=deptCode.trim();
    	   frmPrd=frmPrd.trim();
    	   toPrd=toPrd.trim();		    	   
    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   	  
    	   int count = 0;
    	   if ((empTask != null) && (empTask.trim().length() > 0))
		   {
			   System.out.println("empCode" + empTask);
			   empTask = dashbordUtil.getCommaSeparated(empTask);
			   taskFilter = " AND TBLEPA_DAYSCORE.WINNAME IN (" + empTask + ") ";
		   }
    	   if ((empCode != null) && (empCode.trim().length() > 0))
		   {
			   System.out.println("empCode" + empCode);
			   empCode = dashbordUtil.getCommaSeparated(empCode);
			   empCodeFilter = " AND employee.EMP_CODE IN (" + empCode + ") ";
		   }
    	   if ((deptCode != null) && (deptCode.trim().length() > 0))
		   {
			   System.out.println("deptCode" + deptCode);
			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
		   }
    	   if ((topNos != null) && (topNos.trim().length() > 0))
		   {
			   System.out.println("topNos" + topNos);
			   topNosFilter = " where D.rank<="+topNos;
		   }
    	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
    	   {
    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
    		   }
    	   }
    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
    	   sql=" select  d.jobid ,d.emp_code,d.emp_name,d.e2score ,d.RANK " 
    			   +" from ( " 
    			   +"    select count(b.jobid) jobid,b.emp_code,b.emp_name,trunc(AVG(b.e2score),2) e2score , "
    			   +"   dense_rank () OVER (ORDER BY (trunc(AVG(b.e2score),2)) desc) AS RANK " 
    			   +"    from ( " 
    			   +"    select distinct  tblEPA_dayScore.jobid  jobid,count(*) jobid_cnt,EMPLOYEE.EMP_CODE as emp_code, "
    			   +" 	   (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "
    			   +"    (CASE WHEN employee.emp_mname  IS  NULL  THEN '' "
    			   +"    ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "  
    			   +"    TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , " 
    			   +"   trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt ,trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success, "
    			   +" 	  trunc((((avg(success) / avg(noatt) ) * 100 )/avg(noatt)),2) as e2score " 
    			   +" from tblEPA_dayScore "
				   +" inner join users on USERS.CODE = tblEPA_dayScore.userid " 
				   +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
				   +" where "
				   +" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') " 
					 +" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "  
    			   +"    and tblEPA_dayScore.transtype='"+functionType+"' "
    			   +usgIntStr+"    and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' " 
    			   + taskFilter+empCodeFilter+deptCodeFilter 
    			   +"    group by tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, "
    			   +"    Employee.emp_mname,Employee.emp_lname,Employee.emp_fname order by tblepa_dayscore.jobid "
    			   +"    )B group by b.emp_code,b.emp_name  ) D "+topNosFilter+" order by d.RANK asc  ";
    	   
    	   pstmt = conn.prepareStatement(sql);
			   rs = pstmt.executeQuery();
		   while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));					
				rowData.put("e2_score", checkNull(rs.getString("e2score"))+"@"+checkNull(rs.getString("emp_name"))+"{br}#Transactions: "+checkNull(rs.getString("jobid"))+"{br}Avg.E2-Score:");					
				rawEffTimeJson.put(count, rowData);
				count++;
				}
		}
       System.out.println("fetch Data for getTopE2ScoreJobIdWiseServlet() : " + rawEffTimeJson.toString());
	}
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	} finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				rs.close();
				rs = null;
				if (pstmt != null)
				pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :EmpProductivity : getTopE2ScoreJobIdWiseServlet() :" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawEffTimeJson;
}
/********** End of method getTopE2ScoreJobIdWiseServlet()  ******/

/********** Start of method for  Top E2-score Job Id wise 
 * EJB Name           : EmpProductivity.java
 * Method Name        : getWorstE2ScoreJobIdWiseServlet
 * Servlet Name       : WorstE2ScoreJobIdWiseServlet
 * Metadata xml Name  : efftimeanalysis.xml
 * 
 * */
@SuppressWarnings("unchecked")
public JSONObject getWorstE2ScoreJobIdWiseServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
{
	JSONObject rawEffTimeJson = new JSONObject();
	JSONObject rowData = null;
	String sql         = "";
	ResultSet rs       = null;
	PreparedStatement pstmt = null;
	Connection conn    = null;
	String empCodeFilter="",deptCodeFilter="",topNosFilter="",taskFilter="",usgIntStr="";
	DashboardUtility dashbordUtil = new DashboardUtility();
	try
	{
		/*conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;*/	
		/*add new code for connection DB on dated:16062016 by Nikhil*/
		conn = getConnection();
       if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ) )
		{
    	   System.out.println(" Inside getWorstE2ScoreJobIdWiseServlet()  for Data Soruc Name ="+dataSourceName);
    	   deptCode=deptCode.trim();
    	   frmPrd=frmPrd.trim();
    	   toPrd=toPrd.trim();		    	   
    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));       	  
    	   int count = 0;
    	   if ((empTask != null) && (empTask.trim().length() > 0))
		   {
			   System.out.println("empCode" + empTask);
			   empTask = dashbordUtil.getCommaSeparated(empTask);
			   taskFilter = " AND TBLEPA_DAYSCORE.WINNAME IN (" + empTask + ") ";
		   }
    	   if ((empCode != null) && (empCode.trim().length() > 0))
		   {
			   System.out.println("empCode" + empCode);
			   empCode = dashbordUtil.getCommaSeparated(empCode);
			   empCodeFilter = " AND employee.EMP_CODE IN (" + empCode + ") ";
		   }
    	   if ((deptCode != null) && (deptCode.trim().length() > 0))
		   {
			   System.out.println("deptCode" + deptCode);
			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
		   }
    	   if ((topNos != null) && (topNos.trim().length() > 0))
		   {
			   System.out.println("topNos" + topNos);
			   topNosFilter = " where D.rank<="+topNos;
		   }
    	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
    	   {
    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
    		   }
    	   }
    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
    	   sql=" select  d.jobid ,d.emp_code,d.emp_name,d.e2score ,d.RANK " 
    			   +" from ( " 
    			   +" select count(b.jobid) jobid,b.emp_code,b.emp_name,trunc(AVG(b.e2score),2) e2score , "
    			   +" dense_rank () OVER (ORDER BY (trunc(AVG(b.e2score),2)) asc) AS RANK " 
    			   +" from ( " 
    			   +" select distinct  tblEPA_dayScore.jobid  jobid,count(*) jobid_cnt,EMPLOYEE.EMP_CODE as emp_code, "
    			   +" ( CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "
    			   +" ( CASE WHEN employee.emp_mname  IS  NULL  THEN '' "
    			   +" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "  
    			   +" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , " 
    			   +" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt ,trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success, "
    			   +" trunc((((avg(success) / avg(noatt) ) * 100 )/avg(noatt)),2) as e2score " 
    			   +" from tblEPA_dayScore "
				   +" inner join users on USERS.CODE = tblEPA_dayScore.userid " 
				   +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
				   +" where "
				   +" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') " 
				   +" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "  
    			   +" and tblEPA_dayScore.transtype='"+functionType+"' "
    			   +usgIntStr+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' " 
    			   + taskFilter + empCodeFilter + deptCodeFilter 
    			   +" group by tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, "
    			   +" Employee.emp_mname,Employee.emp_lname,Employee.emp_fname order by tblepa_dayscore.jobid "
    			   +" )B group by b.emp_code,b.emp_name  ) D "+topNosFilter+" order by d.RANK asc  ";
    	   
    	   pstmt = conn.prepareStatement(sql);
			   rs = pstmt.executeQuery();
		   while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));					
				rowData.put("e2_score", checkNull(rs.getString("e2score"))+"@"+checkNull(rs.getString("emp_name"))+"{br}#Transactions: "+checkNull(rs.getString("jobid"))+"{br}Avg.E2-Score:");					
				rawEffTimeJson.put(count, rowData);
				count++;
				}
		}
       System.out.println("fetch Data for getWorstE2ScoreJobIdWiseServlet() : " + rawEffTimeJson.toString());
	}
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	} finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				rs.close();
				rs = null;
				if (pstmt != null)
				pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :EmpProductivity : getWorstE2ScoreJobIdWiseServlet() :" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawEffTimeJson;
}
/********** End of method getWorstE2ScoreJobIdWiseServlet()  ******/

/********** Start of method for  Top Efficiency Analysis Job id Wise
* EJB Name           : EmpProductivity.java
* Method Name        : getE1ScoreJobidWiseAnalysisServlet
* Servlet Name       : E1ScoreJobidWiseAnalysisServlet
* Metadata xml Name  : efftimeanalysis.xml
* 
* */
@SuppressWarnings("unchecked")
public JSONObject getE1ScoreJobidWiseAnalysisServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
{
	JSONObject rawEffTimeJson = new JSONObject();
	JSONObject rowData = null;
	String sql         = "";
	ResultSet rs       = null;
	PreparedStatement pstmt = null;
	Connection conn    = null;
	String empCodeFilter="",deptCodeFilter="",topNosFilter="",empTaskFilter="",usgIntStr="";
	DashboardUtility dashbordUtil = new DashboardUtility();
	try
	{
		/*conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;	*/
		/*add new code for connection DB on dated:16062016 by Nikhil*/
		conn = getConnection();
		
       if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
		{
    	   System.out.println(" Inside getE1ScoreJobidWiseAnalysisServlet()  for Data Soruc Name ="+dataSourceName);
    	   deptCode=deptCode.trim();
    	   frmPrd=frmPrd.trim();
    	   toPrd=toPrd.trim();		    	   
    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));         	  
    	   int count = 0;
    	   if ((empTask != null) && (empTask.trim().length() > 0))
		   {
			   System.out.println("empTask" + empTask);
			   empTask = dashbordUtil.getCommaSeparated(empTask);
			   empTaskFilter = " AND TBLEPA_DAYSCORE.WINNAME in (" + empTask + ") ";
		   }
    	   if ((empCode != null) && (empCode.trim().length() > 0))
		   {
			   System.out.println("empCode" + empCode);
			   empCode = dashbordUtil.getCommaSeparated(empCode);
			   empCodeFilter = " AND EMPLOYEE.EMP_CODE IN (" + empCode + ") ";
		   }
    	   if ((deptCode != null) && (deptCode.trim().length() > 0))
		   {
			   System.out.println("deptCode" + deptCode);
			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
		   }
    	   if ((topNos != null) && (topNos.trim().length() > 0))
		   {
			   System.out.println("topNos" + topNos);
			   topNosFilter = " where D.rank<="+topNos;
		   }    	 
    	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
    	   {
    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
    		   }
    	   }
    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
    	   sql=" select d.emp_code,d.emp_name,d.JOBID, d.escore,d.rank "
				 +" from ( " 
				 +" select c.emp_code,c.emp_name,c.JOBID, c.escore, "   
				 +" dense_rank () OVER (ORDER BY (c.escore) desc) AS RANK "  
				 +" from( "
						 +" select b.emp_code,b.emp_name,sum(b.jobid) jobid,trunc(AVG(b.escore),2) escore "   
						 +"  from ( "
						 +" select A.EMP_CODE, "
						 +" A.EMP_NAME,count(a.jobid) jobid ,trunc(AVG(a.escore),2) escore "
						 +" from( "
						 +" select distinct tblEPA_dayScore.jobid  jobid, " 
						 +" EMPLOYEE.EMP_CODE as emp_code, "							
						 +" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || " 
						 +" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' " 
						 +" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "  
						 +" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , " 
						 +" trunc(AVG(nvl((tblEPA_dayScore.adjescore),0)),2) as escore " 
						 +" from tblEPA_dayScore "
						 +" inner join users on USERS.CODE = tblEPA_dayScore.userid " 
						 +" inner join EMPLOYEE on EMPLOYEE.EMP_CODE  =  USERS.entity_code "
						 +" where "
						 +" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') " 
					 +" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "    
						 +" and tblEPA_dayScore.transtype='"+functionType+"' " 
						 +usgIntStr+" and tblEPA_dayScore.adjescore>0 " 
						 +" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' " 
						 +empTaskFilter+empCodeFilter +deptCodeFilter 
						 +" group by "
						 +" tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, "  
						 +"  Employee.emp_mname,Employee.emp_lname,Employee.emp_fname order by tblEPA_dayScore.jobid "
						 +" )a  GROUP BY A.EMP_CODE, A.EMP_NAME "		
						 +" )b GROUP BY b.emp_code,b.emp_name )C )D "+topNosFilter+" order by D.rank asc ";
    	   
    	   pstmt = conn.prepareStatement(sql);
		   rs = pstmt.executeQuery();
		   while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("EMP_CODE",  checkNull(rs.getString("emp_code")));
				rowData.put("escore", checkNull(rs.getString("escore"))+"@"+checkNull(rs.getString("emp_name"))+"{br}#Transactions: "+checkNull(rs.getString("JOBID"))+"{br}Avg.E1-Score:");
				rawEffTimeJson.put(count, rowData);
				count++;
			}
		}
       System.out.println("fetch Data for getE1ScoreJobidWiseAnalysisServlet() : " + rawEffTimeJson.toString());
	}
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	} finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				rs.close();
				rs = null;
				if (pstmt != null)
				pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :EmpProductivity : getE1ScoreJobidWiseAnalysisServlet() :" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawEffTimeJson;
}
/********** End of method getE1ScoreJobidWiseAnalysisServlet() Job id Wise  ******/

/********** Start of method for  worst Efficiency Analysis Job id Wise
* EJB Name           : EmpProductivity.java
* Method Name        : getWorstE1ScoreJobidWiseAnalysisServlet
* Servlet Name       : WorstE1ScoreJobidWiseAnalysisServlet
* Metadata xml Name  : efftimeanalysis.xml
* 
* */
@SuppressWarnings("unchecked")
public JSONObject getWorstE1ScoreJobidWiseAnalysisServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
{
	JSONObject rawEffTimeJson = new JSONObject();
	JSONObject rowData = null;
	String sql         = "";
	ResultSet rs       = null;
	PreparedStatement pstmt = null;
	Connection conn    = null;
	String empCodeFilter="",deptCodeFilter="",topNosFilter="",empTaskFilter="",usgIntStr="";
	DashboardUtility dashbordUtil = new DashboardUtility();
	try
	{
		/*conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;*/
		/*add new code for connection DB on dated:16062016 by Nikhil*/
		conn = getConnection();
		
       if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
		{
    	   System.out.println(" Inside getWorstE1ScoreJobidWiseAnalysisServlet()  for Data Soruc Name ="+dataSourceName);
    	   deptCode=deptCode.trim();
    	   frmPrd=frmPrd.trim();
    	   toPrd=toPrd.trim();		    	   
    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));          	  
    	   int count = 0;
    	   if ((empTask != null) && (empTask.trim().length() > 0))
		   {
			   System.out.println("empTask" + empTask);
			   empTask = dashbordUtil.getCommaSeparated(empTask);
			   empTaskFilter = " AND TBLEPA_DAYSCORE.WINNAME in (" + empTask + ") ";
		   }
    	   if ((empCode != null) && (empCode.trim().length() > 0))
		   {
			   System.out.println("empCode" + empCode);
			   empCode = dashbordUtil.getCommaSeparated(empCode);
			   empCodeFilter = " AND EMPLOYEE.EMP_CODE IN (" + empCode + ") ";
		   }
    	   if ((deptCode != null) && (deptCode.trim().length() > 0))
		   {
			   System.out.println("deptCode" + deptCode);
			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
		   }
    	   if ((topNos != null) && (topNos.trim().length() > 0))
		   {
			   System.out.println("topNos" + topNos);
			   topNosFilter = " where D.rank<="+topNos;
		   }
    	   /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
    	   {
    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
    		   }
    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
    		   {
    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
    		   }
    	   }
    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
    	   
    	   sql=" select d.emp_code,d.emp_name,d.JOBID, d.escore,d.rank "
				 +" from ( " 
				 +" select c.emp_code,c.emp_name,c.JOBID, c.escore, "   
				 +" dense_rank () OVER (ORDER BY (c.escore) asc) AS RANK "  
				 +" from( "
						 +" select b.emp_code,b.emp_name,sum(b.jobid) jobid,trunc(AVG(b.escore),2) escore "   
						 +"  from ( "
						 +" select A.EMP_CODE, "
						 +" A.EMP_NAME,count(a.jobid) jobid ,trunc(AVG(a.escore),2) escore "
						 +" from( "
						 +" select distinct tblEPA_dayScore.jobid  jobid, " 
						 +" EMPLOYEE.EMP_CODE as emp_code, "							
						 +" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || " 
						 +" (CASE WHEN employee.emp_mname  IS  NULL  THEN '' " 
						 +" ELSE TRIM(Employee.emp_mname) || ' ' END) || (case when EMPLOYEE.EMP_LNAME  is  null  then '' else "  
						 +" TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , " 
						 +" trunc(AVG(nvl((tblEPA_dayScore.adjescore),0)),2) as escore " 
						 +" from tblEPA_dayScore "
						 +" inner join users on USERS.CODE = tblEPA_dayScore.userid " 
						 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
						 +" where "
						 +" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') " 
					 +" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "  
						 +" and tblEPA_dayScore.transtype='"+functionType+"' " 
						 +usgIntStr+" and tblEPA_dayScore.adjescore>0 " 
						 +" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' " 
						 +empTaskFilter+empCodeFilter +deptCodeFilter 
						 +" group by "
						 +" tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, "  
						 +"  Employee.emp_mname,Employee.emp_lname,Employee.emp_fname order by tblEPA_dayScore.jobid "
						 +" )a  GROUP BY A.EMP_CODE, A.EMP_NAME "		
						 +" )b GROUP BY b.emp_code,b.emp_name )C )D "+topNosFilter+" order by D.rank asc ";
    	   
    	   pstmt = conn.prepareStatement(sql);
		   rs = pstmt.executeQuery();
		   while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("EMP_CODE",  checkNull(rs.getString("emp_code")));
				rowData.put("escore", checkNull(rs.getString("escore"))+"@"+checkNull(rs.getString("emp_name"))+"{br}#Transactions: "+checkNull(rs.getString("JOBID"))+"{br}Avg.E1-Score:");
				rawEffTimeJson.put(count, rowData);
				count++;
			}
		}
       System.out.println("fetch Data for getWorstE1ScoreJobidWiseAnalysisServlet() : " + rawEffTimeJson.toString());
	}
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	} finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				rs.close();
				rs = null;
				if (pstmt != null)
				pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :EmpProductivity : getWorstE1ScoreJobidWiseAnalysisServlet() :" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawEffTimeJson;
}
/********** End of method getWorstE1ScoreJobidWiseAnalysisServlet() Job id Wise  ******/


/********** Start of method for  Task wise Efficiency Analysis Job id Wise
* EJB Name           : EmpProductivity.java
* Method Name        : getTaskWiseJobIdWiseE1scoreServlet
* Servlet Name       : TaskWiseJobIdWiseE1scoreServlet
* Metadata xml Name  : efftimeanalysis.xml
* 
**********/
 	@SuppressWarnings("unchecked")
public JSONObject getTaskWiseJobIdWiseE1scoreServlet(String dataSourceName,String frmPrd,String toPrd,String empCode,String deptCode,String usageIntensity,String empTask,String functionType,String topNos) throws RemoteException, ITMException
{
	JSONObject rawDataEmpTopScoreJson = new JSONObject();
	JSONObject rowData = null;
	String sql         = "";
	ResultSet rs       = null;
	PreparedStatement pstmt = null;
	Connection conn    = null;
	String deptCodeFilter="",empCodeFilter="",empTaskFilter="",topNosFilter="",usgIntStr="";
	try
	{
		/*conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;*/
		/*add new code for connection DB on dated:16062016 by Nikhil*/
		conn = getConnection();
		DashboardUtility dashbordUtil = new DashboardUtility();
		 if ((frmPrd != null && frmPrd.trim().length()>0 )   && (toPrd != null && toPrd.trim().length()>0 ))
			{
			 frmPrd=frmPrd.trim();
	    	   toPrd=toPrd.trim();		    	   
	    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
	    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
			 System.out.println(" Inside getTaskWiseJobIdWiseE1scoreServlet()  for Data Soruc Name ="+dataSourceName);
		if ((empTask != null) && (empTask.trim().length() > 0))
		   {
			   System.out.println("empTask" + empTask);
			   empTask = dashbordUtil.getCommaSeparated(empTask);
			   empTaskFilter = " AND TBLEPA_DAYSCORE.WINNAME in (" + empTask + ") ";
		   }
		if ((deptCode != null) && (deptCode.trim().length() > 0))
	   {
		   System.out.println("deptCode" + deptCode);
		   deptCode = dashbordUtil.getCommaSeparated(deptCode);
		   deptCodeFilter = " and Employee.DEPT_CODE in ("+deptCode+") ";
	   }
		if ((empCode != null) && (empCode.trim().length() > 0))
		   {
			   System.out.println("empCode" + empCode);
			   empCode = dashbordUtil.getCommaSeparated(empCode);
			   empCodeFilter = " AND Employee.EMP_CODE IN (" + empCode + ") ";
		   }
		if ((topNos != null) && (topNos.trim().length() > 0))
		   {
			   System.out.println("topNos" + topNos);
			   topNosFilter = " where c.rank<="+topNos;
		   }
		 /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
 	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
 	   {
 		   if(usageIntensity.trim().equalsIgnoreCase("0"))
 		   {
 			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
 		   }
 		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
 		   {
 			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
 		   }
 		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
 		   {
 			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
 		   }
 	   }
 	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
 	   empCode=empCode.trim();
 	   int count = 0;
 	        	   
 	  
 	  
 	   sql=" select c.jobid,c.WINNAME,c.WIN_DESCR,c.ESCORE,c.rank "
				+" from( "      
				+" SELECT z.jobid,Z.WINNAME,SUBSTR(b.win_descr,INSTR(B.WIN_DESCR,'.')+1,length(B.win_descr)) WIN_DESCR,Z.ESCORE , "    
				+" dense_rank() OVER (ORDER BY (z.ESCORE) desc) AS RANK "       
				+" from( " 
				+" select count(a.jobid) jobid,'w_' || a.winname as winname,trunc(AVG(escore),2) escore "      
				+" from( "      
				+" select distinct tblEPA_dayScore.jobid  jobid,count(*) jobid_cnt, TBLEPA_DAYSCORE.WINNAME , "     
						+" trunc(AVG(nvl((tblEPA_dayScore.adjescore),0)),2) as escore  " 
						+" from tblEPA_dayScore "
						 +" inner join users on USERS.CODE = tblEPA_dayScore.userid " 
						 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
						 +" where "
						 +" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') " 
					 +" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "     
						+" and tblEPA_dayScore.transtype='"+functionType+"' "    
						+usgIntStr+" and tblEPA_dayScore.adjescore>0  "+empTaskFilter+empCodeFilter+deptCodeFilter	
						+" and tblEPA_dayScore.jobid !='NA'    and tblEPA_dayScore.ACtCode!='VIEW' "     
						+" group by tblEPA_dayScore.jobid, TBLEPA_DAYSCORE.WINNAME "  
						+" )A group by a.winname " 
						+" )Z  LEFT OUTER JOIN  (SELECT WIN_NAME ,DESCR WIN_DESCR FROM ITM2MENU )B   on Z.WINNAME=  b.WIN_NAME " 
						+" )C "+topNosFilter+" order by c.rank asc ";
 	   
 	          pstmt = conn.prepareStatement(sql);
		   rs = pstmt.executeQuery();
		   while (rs.next())
		   {
				rowData = new JSONObject();
				rowData.put("TASK_NAME", checkNull(rs.getString("WIN_DESCR"))+"["+checkNull(rs.getString("WINNAME"))+"]");
				rowData.put("task_code", checkNull(rs.getString("WINNAME")));					
				rowData.put("e_score", checkNull(rs.getString("ESCORE"))+"@"+"{br}#Transactions: "+checkNull(rs.getString("jobid"))+"{br}Avg.E-1 Score:");
				rawDataEmpTopScoreJson.put(Integer.valueOf(count), rowData);
				count++;
			}
		}
		 System.out.println("fetch Data for getTaskWiseJobIdWiseE1scoreServlet() : " + rawDataEmpTopScoreJson.toString());
	}
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	} finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				rs.close();
				rs = null;
				if (pstmt != null)
				pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :EmpProductivity : getTaskWiseJobIdWiseE1scoreServlet() :" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawDataEmpTopScoreJson;
}

 /********** End of method getTaskWiseJobIdWiseE1scoreServlet() Job id Wise  ******/


/********** Start of method for  Task wise Time Analysis Job id Wise
* EJB Name           : EmpProductivity.java
* Method Name        : getTaskWiseJobIdWiseTimeeServlet
* Servlet Name       : TaskWiseJobIdWiseTimeServlet
* Metadata xml Name  : efftimeanalysis.xml
* 
**********/
 @SuppressWarnings("unchecked")
public JSONObject getTaskWiseJobIdWiseTimeServlet(String dataSourceName,String frmPrd,String toPrd,String empCode,String deptCode,String usageIntensity,String empTask,String functionType,String topNos) throws RemoteException, ITMException
{
	JSONObject rawDataEmpTopScoreJson = new JSONObject();
	JSONObject rowData = null;
	String sql         = "";
	ResultSet rs       = null;
	PreparedStatement pstmt = null;
	Connection conn    = null;
	String deptCodeFilter="",empCodeFilter="",empTaskFilter="",topNosFilter="",usgIntStr="";
	try
	{
		/*conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;*/
		/*add new code for connection DB on dated:16062016 by Nikhil*/
		conn = getConnection();
		DashboardUtility dashbordUtil = new DashboardUtility();
		 if ( (frmPrd != null && frmPrd.trim().length()>0 )   && (toPrd != null && toPrd.trim().length()>0 ))
			{
			 frmPrd=frmPrd.trim();
	    	   toPrd=toPrd.trim();		    	   
	    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
	    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
     	   System.out.println(" Inside getTaskWiseJobIdWiseTimeServlet for Data Soruc Name ="+dataSourceName);
		if ((empTask != null) && (empTask.trim().length() > 0))
		   {
			   System.out.println("empTask" + empTask);
			   empTask = dashbordUtil.getCommaSeparated(empTask);
			   empTaskFilter = " AND tblEPA_dayScore.WINNAME in (" + empTask + ") ";
		   }
		if ((deptCode != null) && (deptCode.trim().length() > 0))
		   {
			   System.out.println("deptCode" + deptCode);
			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
			   deptCodeFilter = " and Employee.DEPT_CODE in ("+deptCode+") ";
		   }
		if ((empCode != null) && (empCode.trim().length() > 0))
	   {
		   System.out.println("empCode" + empCode);
		   empCode = dashbordUtil.getCommaSeparated(empCode);
		   empCodeFilter = " AND Employee.EMP_CODE IN (" + empCode + ") ";
	   }
		 if ((topNos != null) && (topNos.trim().length() > 0))
		   {
			   System.out.println("topNos" + topNos);
			   topNosFilter = " and c.rank<="+topNos;
		   }
		 /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
  	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
  	   {
  		   if(usageIntensity.trim().equalsIgnoreCase("0"))
  		   {
  			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
  		   }
  		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
  		   {
  			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
  		   }
  		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
  		   {
  			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
  		   }
  	   }
  	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
 	   empCode=empCode.trim();
 	   int count = 0;
 	   
 	   sql="select c.jobid,c.WINNAME,c.WIN_DESCR,c.total_time,c.rank "
				+" from( "      
				+" SELECT z.jobid,Z.WINNAME,SUBSTR(b.win_descr,INSTR(B.WIN_DESCR,'.')+1,length(B.win_descr)) WIN_DESCR "
				+" ,z.total_time, dense_rank() OVER (ORDER BY (z.total_time) desc) AS RANK "       
				+" from( "
				+" select count(a.jobid) jobid,'w_' || a.winname as winname, "
				+" trunc((AVG(A.SERVERT/60)+AVG(A.OHT/60)+AVG(JOBT/60)),2) total_time "       
				+" from( "      
				+" select distinct tblEPA_dayScore.jobid  jobid ,count(*) jobid_cnt, TBLEPA_DAYSCORE.WINNAME , "
				+" trunc(AVG(nvl ((tblEPA_dayScore.servert),0)),2) as servert,  trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, " 
				+" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt  " 
				+" from tblEPA_dayScore "
				 +" inner join users on USERS.CODE = tblEPA_dayScore.userid " 
				 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
				 +" where "
				 +" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') " 
				+" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "      
				+" and tblEPA_dayScore.transtype='"+functionType+"' "   
				+empTaskFilter+empCodeFilter+deptCodeFilter
				+usgIntStr+" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' "     
				+" group by tblEPA_dayScore.jobid, TBLEPA_DAYSCORE.WINNAME  )A group by a.winname " 
				+" )Z  LEFT OUTER JOIN  (SELECT WIN_NAME ,DESCR WIN_DESCR FROM ITM2MENU )B   on Z.WINNAME=  b.WIN_NAME " 
				+" )C  where c.total_time>0.04 "+topNosFilter+" order by c.rank asc ";
 	   
 	   pstmt = conn.prepareStatement(sql);
		   rs = pstmt.executeQuery();
		   while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("TASK_NAME", checkNull(rs.getString("WIN_DESCR"))+"["+checkNull(rs.getString("WINNAME"))+"]");
				rowData.put("task_code", checkNull(rs.getString("WINNAME")));					
				rowData.put("tot_time", checkNull(rs.getString("total_time"))+"@"+"{br}#Transactions: "+checkNull(rs.getString("jobid"))+"{br}Avg.Total Time:");
				rawDataEmpTopScoreJson.put(Integer.valueOf(count), rowData);
				count++;
			}
		}
		 System.out.println("fetch Data for getTaskWiseJobIdWiseTimeServlet() : " + rawDataEmpTopScoreJson.toString());
	}
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	} finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				rs.close();
				rs = null;
				if (pstmt != null)
				pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :EmpProductivity : getTaskWiseJobIdWiseTimeServlet() :" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawDataEmpTopScoreJson;
}
 /********** End of method getTaskWiseJobIdWiseTimeServlet() Job id Wise  ******/
 /*---------END------EMPLOYEE WISE GRAPH [1ST LEVEL OF DASHBOARD]--------------*/

 /*-----START-------------DISTRIBUTION GRAPH [2ND LEVEL OF DRILL-DOWN]----------------------*/
	/********** Start of method for distribution of Time
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : getJobWiseDistributionServlet
	 * Servlet Name       : JobWiseDistributionServlet
	 * Metadata xml Name  : attemptdistribution.xml(SSGrid),timedistribution.xml
	 * 
	 * */
	@SuppressWarnings("unchecked")
	public JSONObject getJobWiseDistributionServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawEffTimeJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		double toj_per=0.0,suc_per=0.0,servert_per=0.0,oh_per=0.0;
		double tot_time=000.0;
		String fta_per="";
		double job_time=0,server_time=0.0,oh_time=0.0;
		String deptCodeFilter="",empTaskFilter="",usgIntStr="";
		String noAtt="",succAtt="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
		if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
		{
			frmPrd=frmPrd.trim();
	    	   toPrd=toPrd.trim();		    	   
	    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
	    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
			System.out.println(" Inside getJobWiseDistributionServlet()  for Data Soruc Name ="+dataSourceName);
			if ((empTask != null) && (empTask.trim().length() > 0))
		   {
			   System.out.println("empTask" + empTask);
			   empTask = dashbordUtil.getCommaSeparated(empTask);
			   empTaskFilter = " AND tblEPA_dayScore.WINNAME in (" + empTask + ") ";
		   }
			 if ((deptCode != null) && (deptCode.trim().length() > 0))
		   {
			   System.out.println("deptCode" + deptCode);
			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
		   }
			 /*if ((topNos != null) && (topNos.trim().length() > 0))
		   		{
			   System.out.println("topNos" + topNos);
			   topNosFilter = " where B.RN<="+topNos;
		   	}*/
			 /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
	    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
	    	   {
	    		   System.out.println("usage intensityin getJobWiseDistributionServlet :"+usageIntensity);
	    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
	    		   }
	    	   }
	    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
     	   deptCode=deptCode.trim();
     	   int count = 0;
     	 
     	   
     	   /*sql="select b.emp_code,b.emp_name,count(b.jobid) jobid, "
     			   +" TRUNC(AVG(b.servert/60),2) server_time ,  TRUNC(AVG(b.oht/60),2) oh_time ,TRUNC(AVG(b.jobt/60),2) job_time,  "
     			   +" TRUNC((AVG(B.OHT)/60+AVG(b.servert)/60+AVG(b.jobt)/60),2) TOTAL_TIME_MIN, "
     			   +" trunc(AVG(b.noatt),2) NOATTEMPTS,trunc(AVG(b.success),2) success , trunc(AVG(b.fail),2) fail "  
     			   +" from (  select distinct tblEPA_dayScore.jobid  jobid,EMPLOYEE.EMP_CODE as emp_code, "  
     			   +" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) ||  " 
     			   +" (CASE WHEN employee.emp_mname  IS  NULL  THEN ''  ELSE TRIM(Employee.emp_mname) || ' ' END) ||  "
     			   +" (case when EMPLOYEE.EMP_LNAME  is  null  then '' else  TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME ,  " 
     			   +" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert,  trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht,  " 
     			   +" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt    , "
     			   +" trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt, "
     			   +" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success ,  " 
				   +" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail "
				   +" from tblEPA_dayScore LEFT OUTER JOIN transetup  "
					 +" ON ((transetup.TRAN_WINDOW = UPPER(tblEPA_dayScore.WINNAME)) "
					 +" OR (transetup.TRAN_WINDOW = 'w_' || tblEPA_dayScore.WINNAME) "
					 +" OR (transetup.TRAN_WINDOW = 't_' || tblEPA_dayScore.WINNAME)) "
					 +" inner join users on USERS.CODE = rpad(tblEPA_dayScore.userid,10,' ') " 
					 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
					 +" where tblEPA_dayScore.logdate >= '"+frmPrd+"'  "
     			   +" and tblEPA_dayScore.logdate <= '"+toPrd+"' " 
     			   +" and transetup.function_type='"+functionType+"'   "
     			   +usgIntStr+" and tblEPA_dayScore.jobid !='NA'  "+ empTaskFilter + deptCodeFilter
     			   +" and tblEPA_dayScore.ACtCode!='VIEW'  " 
     			   +" AND EMPLOYEE.EMP_CODE IN ('"+empCode.trim()+"')  " 
     			   +" group by tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, Employee.emp_mname,Employee.emp_lname,Employee.emp_fname  "
     			   +" )b GROUP BY b.emp_code,b.emp_name ";*/
     	   
     	   sql="select b.emp_code,b.emp_name,count(b.jobid) jobid, "      			   
			  +" TRUNC(AVG(b.servert/60),2) server_time ,  TRUNC(AVG(b.oht/60),2) oh_time ,TRUNC(AVG(b.jobt/60),2) job_time, "      			   
			  +" TRUNC((AVG(B.OHT)/60+AVG(b.servert)/60+AVG(b.jobt)/60),2) TOTAL_TIME_MIN, "       			   
			  +" trunc(AVG(b.noatt),2) NOATTEMPTS,trunc(AVG(b.success),2) success , trunc(AVG(b.fail),2) fail "     			   
			  +" from (  select distinct tblEPA_dayScore.jobid  jobid,EMPLOYEE.EMP_CODE as emp_code, "     			   
			  +" (CASE WHEN Employee.emp_fname IS NULL THEN '' ELSE TRIM(Employee.emp_fname) || ' ' END) || "         			   
			  +" (CASE WHEN employee.emp_mname  IS  NULL  THEN ''  ELSE TRIM(Employee.emp_mname) || ' ' END) || "       			   
			  +" (case when EMPLOYEE.EMP_LNAME  is  null  then '' else  TRIM(EMPLOYEE.EMP_LNAME) || ' ' end) as EMP_NAME , "         			   
			  +" trunc(AVG(nvl((tblEPA_dayScore.servert),0)),2) as servert,  trunc(AVG(nvl((tblEPA_dayScore.oh),0)),2) as oht, "         			   
			  +" trunc(AVG(nvl((tblEPA_dayScore.jobt),0)),2) as jobt, "
			  +"  trunc(AVG(nvl((tblEPA_dayScore.noatt),0)),2) as noatt, "       			   
			  +" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , "    				   
			  +" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail "  				   
			  +" from tblEPA_dayScore "  					 
			  +" inner join users on USERS.CODE = tblEPA_dayScore.userid "   					 
			  +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "  					 
			  +" where "
			  +" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') "  
			+" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "        			   
			  +" and tblEPA_dayScore.transtype='"+functionType+"' "+usgIntStr+ empTaskFilter + deptCodeFilter        			   
			  +" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' "         			   
			  +" AND EMPLOYEE.EMP_CODE IN ('"+empCode.trim()+"') "         			   
			  +" group by tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE, Employee.emp_mname,Employee.emp_lname,Employee.emp_fname "        			   
			  +"  )b GROUP BY b.emp_code,b.emp_name ";
     	   pstmt = conn.prepareStatement(sql);
			   rs = pstmt.executeQuery();
			 while (rs.next())
				{
					rowData = new JSONObject();
					rowData.put("EMP_CODE", checkNull(rs.getString("emp_code")));
					rowData.put("no_of_attempt", checkNull(rs.getString("NOATTEMPTS")));					
					rowData.put("success", checkNull(rs.getString("success")));
					rowData.put("failure", checkNull(rs.getString("fail")));
					toj_per=0.0;
					servert_per=0.0;
					oh_per=0.0;

                 job_time=Double.parseDouble((checkZero(rs.getString("job_time"))));
                 server_time=Double.parseDouble((checkZero(rs.getString("server_time"))));
                 oh_time=Double.parseDouble((checkZero(rs.getString("oh_time"))));
					tot_time=Double.parseDouble((checkZero(rs.getString("TOTAL_TIME_MIN"))));

                 toj_per    = Math.round((job_time*100)/tot_time);
                 servert_per = Math.round((server_time*100)/tot_time);
				    oh_per      = Math.round((oh_time*100)/tot_time);

					//rowData.put("overhead_time",oh_time+"@"+checkNull(rs.getString("EMP_NAME"))+","+oh_per+"%{br}Avg.Overhead Time:");
					//rowData.put("job_time", job_time+"@"+checkNull(rs.getString("EMP_NAME"))+","+toj_per+"%{br}Avg.Job Time:");
					//rowData.put("server_time", server_time+"@"+checkNull(rs.getString("EMP_NAME"))+","+servert_per+"%{br}Avg.Server Time:");
					
					rowData.put("overhead_time",oh_time+"@"+checkNull(rs.getString("EMP_NAME"))+",{br}#Transactions: "+checkNull(rs.getString("jobid"))+",{br}Avg.Overhead Time:");
					rowData.put("job_time", job_time+"@"+checkNull(rs.getString("EMP_NAME"))+",{br}#Transactions: "+checkNull(rs.getString("jobid"))+",{br}Avg.Job Time:");
					rowData.put("server_time", server_time+"@"+checkNull(rs.getString("EMP_NAME"))+",{br}#Transactions: "+checkNull(rs.getString("jobid"))+",{br}Avg.Server Time:");
					
					
					noAtt = checkZero(rs.getString("NOATTEMPTS")) ;
					succAtt=checkNull(rs.getString("success"));
					fta_per=  checkZero(rs.getString("fail"));
					rowData.put("label", "Fail");
					rowData.put("value", fta_per);
					
					rawEffTimeJson.put(count, rowData);
					count++;
					System.out.println("fta_per: "+fta_per+"  suc_per: "+suc_per);
				}
			    rowData = new JSONObject();
			    rowData.put("EMP_CODE", "");
				rowData.put("no_of_attempt", "");					
				rowData.put("success", "");
				rowData.put("failure", "");
				rowData.put("overhead_time", "");
				rowData.put("job_time", "");
				rowData.put("server_time", "");				
				rowData.put("escore", "");
				rowData.put("job_time", "");
				rowData.put("label", "Sucess");
				rowData.put("value", succAtt);
				rawEffTimeJson.put(count, rowData);
				count++;
				rowData = new JSONObject();
			    rowData.put("EMP_CODE", "");
				rowData.put("no_of_attempt", "");					
				rowData.put("success", "");
				rowData.put("failure", "");
				rowData.put("overhead_time", "");
				rowData.put("job_time", "");
				rowData.put("server_time", "");				
				rowData.put("escore", "");
			    rowData.put("label", "No. Of Attempts");
				rowData.put("value", noAtt);
				rowData.put("toj_per", "");							
				rawEffTimeJson.put(count, rowData);
			}
		 System.out.println("fetch Data for getJobWiseDistributionServlet() : " + rawEffTimeJson.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getJobWiseDistributionServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawEffTimeJson;
	}
	/********** End of method getJobWiseDistributionServlet()  ******/


	/********** Start of method for  distribution of  Number of Attempts Pie chart
	 * EJB Name           : EmpProductivity.java
	 * Method Name        : getPieChartJobWiseDistributionServlet
	 * Servlet Name       : PieChartJobWiseDistributionServlet
	 * Metadata xml Name  : attemptdistribution.xml(Pie-Chart)
	 * 
	 * */
	@SuppressWarnings("unchecked")
	public JSONObject getPieChartJobWiseDistributionServlet(String dataSourceName,String frmPrd,String toPrd,String empTask,String deptCode,String topNos,String empCode,String usageIntensity,String functionType) throws RemoteException, ITMException
	{
		JSONObject rawEffTimeJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		double fta_per=0.0,suc_per=0.0;	
		String deptCodeFilter="",empTaskFilter="",usgIntStr="";
		String fail_att="",succ_att="";
		DashboardUtility dashbordUtil = new DashboardUtility();
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:16062016 by Nikhil*/
			conn = getConnection();
			  if ((frmPrd != null && frmPrd.trim().length()>0 ) && (toPrd != null && toPrd.trim().length()>0 ))
				{
				  frmPrd=frmPrd.trim();
		    	   toPrd=toPrd.trim();		    	   
		    	   frmPrd = gridDateFormat.format(convrtToTimStmDate.parse(frmPrd));
		    	   toPrd = gridDateFormat.format(convrtToTimStmDate.parse(toPrd));   
				  System.out.println(" Inside getPieChartJobWiseDistributionServlet()  for No of Attempts Data Soruc Name ="+dataSourceName);
			if ((empTask != null) && (empTask.trim().length() > 0))
 		   {
 			   System.out.println("empTask" + empTask);
 			   empTask = dashbordUtil.getCommaSeparated(empTask);
 			   empTaskFilter = " AND tblEPA_dayScore.WINNAME in (" + empTask + ") ";
 		   }
			 if ((deptCode != null) && (deptCode.trim().length() > 0))
  		   {
  			   System.out.println("deptCode" + deptCode);
  			   deptCode = dashbordUtil.getCommaSeparated(deptCode);
  			   deptCodeFilter = " and EMPLOYEE.DEPT_CODE in ("+deptCode+") ";
  		   }
			 /*if ((topNos != null) && (topNos.trim().length() > 0))
  		   		{
  			   System.out.println("topNos" + topNos);
  			   topNosFilter = " where B.RN<="+topNos;
  		   		}*/
			 /*Added by swati for mltiple usage intensity date 09 Feb 2016*/
	    	   if((usageIntensity != null) && (usageIntensity.trim().length() > 0))
	    	   {
	    		   if(usageIntensity.trim().equalsIgnoreCase("0"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("1"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('1') ";
	    		   }
	    		   else if(usageIntensity.trim().equalsIgnoreCase("2"))
	    		   {
	    			 usgIntStr =  " and USERS.usage_intensity in ('0','1') ";
	    		   }
	    	   }
	    	   /*Ended by swati for mltiple usage intensity date 09 Feb 2016*/
        	   deptCode=deptCode.trim();
        	   frmPrd=frmPrd.trim();
        	   toPrd=toPrd.trim();        	  
        	   int count = 0;        	   
        	   
        	   sql="  select A.EMP_CODE, trunc(sum(a.success),2) success,trunc(sum(a.fail),2) fail " 
  					 +" from( "
  					 +" select distinct tblEPA_dayScore.jobid  jobid,employee.emp_code, " 
  					 +" trunc(AVG(nvl((tblEPA_dayScore.success),0)),2) as success , " 
  					 +" trunc(AVG(nvl((tblEPA_dayScore.fail),0)),2) as fail "  
  					+" from tblEPA_dayScore "
					 +" inner join users on USERS.CODE = tblEPA_dayScore.userid " 
					 +" inner join EMPLOYEE on  EMPLOYEE.EMP_CODE  =  USERS.entity_code "
					 +" where "
					 +" to_date(tblEPA_dayScore.logdate,'dd/mm/yy') >= to_date('"+frmPrd+"','dd/mm/yy') " 
					 +" and to_date(tblEPA_dayScore.logdate,'dd/mm/yy') <= to_date('"+toPrd+"','dd/mm/yy') "     
  					 +" and tblEPA_dayScore.transtype='"+functionType+"' " 
  					 +usgIntStr+" and TRIM(EMPLOYEE.EMP_CODE) ='"+empCode.trim()+"' " 
  					 +" and tblEPA_dayScore.jobid !='NA' and tblEPA_dayScore.ACtCode!='VIEW' " + empTaskFilter + deptCodeFilter
  					 +" group by tblEPA_dayScore.jobid, EMPLOYEE.EMP_CODE  )a  GROUP BY A.EMP_CODE  ";
        	   
        	   pstmt = conn.prepareStatement(sql);
  			   rs = pstmt.executeQuery();
			   while (rs.next())
				{
					rowData  =  new JSONObject();
					fail_att =  checkNull(rs.getString("fail"));
					succ_att =  checkNull(rs.getString("success"));
					rowData.put("attempt", "Fail");
					rowData.put("fta_per", fail_att);
					rawEffTimeJson.put(count, rowData);
					count++;
					System.out.println("fta_per: "+fta_per+"  suc_per: "+suc_per);
  				}
			    rowData = new JSONObject();			    
			    rowData.put("attempt", "Sucess");
				rowData.put("fta_per", succ_att);
				rawEffTimeJson.put(count, rowData);
			}
			  System.out.println("fetch Data for getPieChartJobWiseDistributionServlet() : " + rawEffTimeJson.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :EmpProductivity : getPieChartJobWiseDistributionServlet() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawEffTimeJson;
	}
	/********** End of method getPieChartJobWiseDistributionServlet()  ******/
	
/*-----------------END OF JOB ID WISE GRAPHS------------*/

	private String checkZero(String str)
    {
            if(str == null || str.equals(null) || str.equalsIgnoreCase(""))
            {
                    return "0";
            }
            else
            {
                    return str ;
            }

    }
	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}
	}

 }

