/********************************************
 * DrCrInvPostSave.java
 * VALLABH KADAM
 * 08/JAN/15
 *******************************************/
package ibase.webitm.ejb.fin;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

import org.w3c.dom.Document;
@javax.ejb.Stateless

public class DrCrInvPostSave extends ValidatorEJB implements DrCrInvPostSaveLocal, DrCrInvPostSaveRemote
{        

	FinCommon finCommon = new FinCommon();
	DistCommon distCommon = new DistCommon();

	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}

	public String postSave( String domString, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{

		System.out.println("In DrCrInvPostSave ... ");

		PreparedStatement pstmt = null;
		Document dom = null;                
		ResultSet rs =null;
		boolean isError = false;

		String tranId = "";
		String sql = null;

//		double hdrAmount=0.0;
				 
		int cnt1=0;
		try
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			dom = genericUtility.parseString(domString);

			tranId = GenericUtility.getInstance().getColumnValue("tran_id",dom);
			System.out.println("Tran id :- ["+tranId+"]");
			
			
			// CASE 1 :- Update the Net amount=(drcr_amt + tax_amt)  of Every Detail for respective tran_id.
			System.out.println("In CASE 1 #######");
			sql="update drcr_invdet set net_amt=(coalesce(drcr_amt,0) + coalesce(tax_amt,0)) where tran_id=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId );
			cnt1 = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;
			
			System.out.println("CASE 1 cnt :- ["+cnt1+"]");
			// CASE :- 1 FINISH 
			
			
			// CASE 2 :- Update Amount=(sum(net_amt)) for Header find sum of all net_amt from Details for respective tran_id.
			System.out.println("In CASE 2 #######");	
			sql="update drcr_inv set amount=(select sum(coalesce(net_amt,0)) as amount from drcr_invdet where tran_id=?) where tran_id=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			pstmt.setString(2,tranId );
			cnt1 = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;
			
			System.out.println("CASE 2 cnt :- ["+cnt1+"]");
			// CASE 2 :- FINISH
			
			
			// CASE 3 :- Update amount__bc=(amount * exch_rate) of Header for respective tran_id.
			System.out.println("In CASE 3 #######");
			sql="update drcr_inv set amount__bc=(coalesce(amount,0) * coalesce(exch_rate,0)) where tran_id=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId );
			cnt1 = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;
			
			System.out.println("CASE 3 cnt :- ["+cnt1+"]");
			// CASE 3 :- FINISH	 
		}
		catch(Exception e)
		{
			try {
				conn.rollback();
			} catch (SQLException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			isError = true;
			System.out.println("Exception :MiscVoucherPostSaveEJB : :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError ["+isError+"]");
				if( conn != null )
				{

					if( isError )
					{
						conn.rollback();
					}
					else
					{
						conn.commit();
					}
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :MiscVoucherPostSaveEJB : :==>\n"+e.getMessage());
				try
				{
					System.out.println("Before rollback");
					conn.rollback();
				}

				catch(SQLException sqle)
				{
					System.out.println(sqle);
				}
				throw new ITMException(e);
			}
		}
		System.out.println("Out MiscVoucherPostSaveEJB ... ");
		return "";                
	}
/*	private java.math.BigDecimal round(int scale ,double round)
	{
		return new java.math.BigDecimal(round).setScale(scale, java.math.BigDecimal.ROUND_UP);
	}

	private double roundVal(double round,int scale)
	{
		return Math.round(round*Math.pow(10, scale))/Math.pow(10, scale);
	}*/
}