package ibase.webitm.wms.reports;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.PrinterName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;



/**
 * Servlet implementation class TestServlet
 */
public class ReportRequesthandlerServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;

    /**
     * Default constructor. 
     * @return 
     */
	  public void RequestreportServlet() 
	  {
      }


	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException 
	{
		// TODO Auto-generated method stub	
		res.setContentType("text/xml");
		res.setHeader("Cache-Control", "no-store, no-cache");	
		JRPrintServiceExporter exporter = new JRPrintServiceExporter();
		
		String printerName = "";
		Connection con = null;
		String printServiceName = "";
		//Added by Santosh on 13-04-2016 [Start]
		int copiesNumner = 0;
		//Added by Santosh on 13-04-2016 [End]
		JasperPrint jasperPrint = null;
		String retString ="";
		 
		try
		{
			
			printServiceName = (String)req.getParameter("PRINTER_NAME");
			System.out.println("Server Side getting printer BName ::::::::::::["+printServiceName+"]:::::::::::");
			//Added by Santosh on 13-04-2016 [Start]
			copiesNumner = Integer.parseInt(req.getParameter("NUMBER_OF_COPIES"));
			System.out.println("Number of copies ::::::::::::["+copiesNumner+"]:::::::::::");
			//Added by Santosh on 13-04-2016 [End]
		
			
			DocFlavor psInFormat = DocFlavor.INPUT_STREAM.AUTOSENSE;
			PrintServiceAttributeSet printServiceAttributeSet = new HashPrintServiceAttributeSet();
			PrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();

			ObjectInputStream inputStream = null ;  
	        Object objectS = null;  
	          
	        try {  
	        	
	        	System.out.println("Request URL  " + req.getRequestURL());
	        	System.out.println("Request URL  " + req.getQueryString());
	        	System.out.println("Avilable bytes " + req.getInputStream().available());
	        		        	
	        	inputStream =  new ObjectInputStream(req.getInputStream());
	        	//objectS = (Object)inputStream.readObject();  
	        	
	        	System.out.println("------------------Reading Object================..");
	            
	            while ((objectS = inputStream.readObject()) != null) 
	            {
	                
	                if (objectS instanceof JasperPrint) {
	                
	                    System.out.println("Found  with Jasper Print Object");
	                    jasperPrint = (JasperPrint)objectS;
	                }
	                
	            }
	        } catch (EOFException ex) {  //This exception will be caught when EOF is reached
	            System.out.println("End of file reached.");
	        } catch (ClassNotFoundException ex) {
	            ex.printStackTrace();
	        } catch (FileNotFoundException ex) {
	            ex.printStackTrace();
	        } catch (IOException ex) {
	            ex.printStackTrace();
	        } finally {
	            //Close the ObjectInputStream
	            try {
	                if (inputStream != null) {
	                    inputStream.close();
	                }
	            } catch (IOException ex) {
	                ex.printStackTrace();
	            }
	        } 
	        
	        System.out.println("Total Page Size For Print["+jasperPrint.getPages().size() +"]");
			PrinterName name = new PrinterName(printServiceName, null);
			printServiceAttributeSet.add(name);
			exporter.setParameter(JRExporterParameter.JASPER_PRINT,jasperPrint);  
			exporter.setParameter  
			(JRPrintServiceExporterParameter.PRINT_REQUEST_ATTRIBUTE_SET,  
			printRequestAttributeSet);  
			exporter.setParameter  
			(JRPrintServiceExporterParameter.PRINT_SERVICE_ATTRIBUTE_SET,  
			printServiceAttributeSet);  
			exporter.setParameter(JRPrintServiceExporterParameter.DISPLAY_PAGE_DIALOG,  
			Boolean.FALSE);  
			exporter.setParameter(JRPrintServiceExporterParameter.DISPLAY_PRINT_DIALOG,  
			Boolean.FALSE);  
			
			for(int i=1;i<=copiesNumner;i++){
				exporter.exportReport();
				System.out.println("Loop number"+i);
			}
			

			
			
		}
		catch (Exception E)
		{
			 E.printStackTrace();
		}
		finally
		{
			try
			{
				
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}		
		}
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response)throws ServletException,IOException
	{
		doPost(request,response);
	}

}
