/**
 * PURPOSE : PalletOutIC component
 * AUTHOR : Jagruti Shinde
 * DATE : 07-01-2016
 * Normal Pallet         :Item_ser__rg1::other than 'FS',Location Group::other than Exempted,QC status::not in QC
 * Pallet with suffix 'Q':Item_ser__rg1::other than 'FS',Location Group::other than Exempted,QC status::pending in QC
 * Pallet with suffix 'X':Item_ser__rg1::other than 'FS',Location Group::Exempted           ,QC status::not in QC
 * Pallet with suffix 'M':Item_ser__rg1::other than 'FS',Location Group::Exempted           ,QC status::pending in QC
 * Pallet with suffix 'B':Item_ser__rg1::'FS'           ,Location Group::other than Exempted,QC status::not in QC
 * Pallet with suffix 'S':Item_ser__rg1::'FS'           ,Location Group::other than Exempted,QC status::pending in QC
 * Pallet with suffix 'P':Item_ser__rg1::'FS'           ,Location Group::Exempted           ,QC status::not in QC
 * Pallet with suffix 'U':Item_ser__rg1::'FS'           ,Location Group::Exempted           ,QC status::pending in QC
 * Pallet with suffix 'R':Rejected Pallet     
 */
 

package ibase.webitm.ejb.wms;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wms.CommonWmsUtil;

import java.rmi.RemoteException;
import java.sql.*;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.*;

import org.w3c.dom.*;

@javax.ejb.Stateless
public class PalletOutIC extends ValidatorEJB implements PalletOutICLocal, PalletOutICRemote 
{
	/**
	 * The method is defined without any parameter and returns blank string
	 */	
	DistCommon distComm = new DistCommon();
	@Override
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(DOM)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();    


		try
		{
			System.out.println( "xmlString ::" + xmlString);
			System.out.println( "xmlString1 ::" + xmlString1);
			System.out.println( "xmlString2 ::" + xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( dom, dom1, dom2, objContext, xtraParams);
			System.out.println( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return (errString); 
	}
	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String xtraParams) throws RemoteException, ITMException
	{   				
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		E12GenericUtility genericUtility;

		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String loginSite = "", userId = "", childNodeName = "", errorType = "", errCode = "", errString = "",itemCode="",
				palletNo = "", sql = "",locCodeSugg="",locCodeInput = "",itemSerRg="",sql1="",fld_value="",sqlU="",udf_str1="",bayNo="";
		int currentFormNo = 0, childNodeListLength = 0, cnt = 0, ctr = 0,cntP=0,locIcnt = 0,locScnt= 0;;
		ArrayList <String> errList = new ArrayList<String>();
		ArrayList <String> errFields = new ArrayList <String> ();
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 

		try
		{	
			genericUtility = new E12GenericUtility();	
			CommonWmsUtil commonWmsUtility = CommonWmsUtil.getInstance();

			System.out.println("xtraParam----->>["+xtraParams+"]");
			System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
			System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
			System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");	

			loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));

			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			conn.setAutoCommit(false);
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}	

			switch ( currentFormNo )  
			{
			case 1:
				System.out.println("------in detail1 validation----------------");
				System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
				System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");	


				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				bayNo = checkNullAndTrim(genericUtility.getColumnValue("pallet_no", dom));

				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{					
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					//System.out.println("childNodeName ------->>["+childNodeName+"]");

					if("pallet_no".equalsIgnoreCase(childNodeName))
					{
						System.out.println("ScanLoc in dom"+bayNo);
						if(bayNo.length() <= 0) 
						{
							System.out.println("Bay No length less than 0 :::::::::: ");
							errCode = "VMNLPALLET";//blank pallet no
							errList.add( errCode );
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							//	sql="SELECT COUNT(1) FROM SWMS_TO_AWMS S,WMS_TO_HOST W WHERE S.TRAN_ID = W.TRAN_ID AND S.SCHEDULE_STATUS = ? AND W.IN_OUT = ? AND W.BAY_NO = ? AND S.PALLET_NO = W.PALLET_NO AND S.IN_OUT = W.IN_OUT";

							sql="SELECT COUNT(1) FROM SWMS_TO_AWMS S,WMS_TO_HOST W WHERE S.REF_ID = W.REF_ID AND S.SCHEDULE_STATUS = ? AND W.IN_OUT = ? AND W.BAY_NO = ? AND S.PALLET_NO = W.PALLET_NO AND S.IN_OUT = W.IN_OUT";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "N");
							pstmt.setString(2, "O");
							pstmt.setString(3, bayNo);
							rs = pstmt.executeQuery();
							if(rs.next())
							{		
								cntP = rs.getInt(1);
								System.out.println("count bayloc>>>>>>>" +cntP);
								if(cntP==0)
								{
									System.out.println("loc_code exist");
									errCode = "VMPALLTEXT";//swms
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
									break;
								}
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
						}
					}
				}
				break;			

			case 2:
				System.out.println("------in detail2 validation----------------");
				System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
				System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");	


				parentNodeList = dom2.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				locCodeInput = checkNullAndTrim(genericUtility.getColumnValue("loc_code_input",dom));
				locCodeSugg = checkNullAndTrim(genericUtility.getColumnValue("loc_code_sugg",dom));
				bayNo = checkNullAndTrim(genericUtility.getColumnValue("pallet_no",dom));


				for (ctr = 0; ctr < childNodeListLength; ctr++) 
				{					
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					//System.out.println("childNodeName ------->>["+childNodeName+"]");

					if("loc_code_input".equalsIgnoreCase(childNodeName))
					{
						if(locCodeInput.length() <= 0) 
						{
							System.out.println("Input Location length less than 0 :::::::::: ");
							errCode = "VMLOCANULL";	//LOC NULL	
							errList.add( errCode );
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							// Change by Jagruti Shinde as site_code is not consider for location master
							//sql="SELECT  COUNT(1) FROM LOCATION WHERE INV_STAT NOT IN (?,?) AND LOC_CODE=? AND SITE_CODE=?";
							sql="SELECT  COUNT(1) FROM LOCATION WHERE INV_STAT NOT IN (?,?) AND LOC_CODE=? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "AWMS");
							pstmt.setString(2, "AWMSQ");
							pstmt.setString(3, locCodeInput);
							//	pstmt.setString(4, loginSite);
							rs = pstmt.executeQuery();
							if(rs.next())
							{		
								locIcnt = rs.getInt(1);
								System.out.println("count location>>>>>>>" +locIcnt);
								if(locIcnt==0)
								{
									System.out.println("loc_code exist");
									errCode = "VMLOCATEXT";//LOC CODE SHOULD PRESENT
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );
									break;
								}
							}
							if(pstmt != null)
							{ 
								pstmt.close();
								pstmt = null;
							}
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
						}
						if(locCodeInput.equalsIgnoreCase(locCodeSugg))
						{
							System.out.println("input location is same as suggested location");
						}
						else
						{
							System.out.println("input location is not same  as suggested location");
							errCode = "VMLOCATEXS";// not same
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
							break;
						}
					}

					if("loc_code_sugg".equalsIgnoreCase(childNodeName))
					{
						System.out.println("in loc_code sugg ");

					}
				}
				break;
			}

			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn, errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;

				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}	
			errString = errStringXml.toString();

		}
		catch ( Exception e )
		{
			System.out.println ( "Exception: PalletOutIC: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			throw new ITMException(e);		
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : PalletOutIC:wfValData : " + e.getMessage() );
				throw new ITMException(e);
			}
		}
		System.out.println( "errString>>>>>>>::" + errString );
		return errString;

	}

	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";

			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

	@Override
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			System.out.println ( "Calling  itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams )");
			errString = itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception : PalletOutIC:itemChanged(String,String):" + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		System.out.println ( "returning from PalletOutIC itemChanged \n[" + errString + "]" );

		return errString;
	}

	@Override
	public String itemChanged( Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String currentColumn,String editFlag, String xtraParams ) throws RemoteException,ITMException
	{	
		Connection conn = null;
		PreparedStatement pstmt = null, pstmt1 = null,pstmtGen=null,stkpstmt=null ,pstmtRef=null;
		ResultSet rs = null, rs1 = null,rsGen=null,stkrs=null,rsRef =null,rsRefId =null;		
		int currentFormNo = 0, domId = 0;
		String sql = "", tranId = "", chgUser = "", chgTerm = "", loginEmpCode = "", loginSite = "", locCodeInput = "",
				locCodeSuggest="",childNodeName="",sql1="",fld_value="",sqlU="",udf_str1="",bayNo="",lotNo="",lotSl="",invStat="",status=""
				,sqlGen="",udfStr="",udfStr1="",stkSql="",locCode ="",sqlDB ="",sqlRef ="",refSer ="" ,sqlLock ="",lockCode =""
				,sqlDamage ="",lockCodeDH ="",dispDamageLock="",dispHoldLock="",dispNexpLoc="",dispExpLoc="",sqlRej ="",refId ="",sqlDist ="",sqlRefId ="",availiableYn ="";//Added by Jagruti Shinde eq_id:[W16GSUN004]
		char lastChar;
		StringBuffer valueXmlString;
		ArrayList <String> errList = new ArrayList<String>();
		ArrayList <String> errFields = new ArrayList <String> ();


		System.out.println("xtraParams=["+xtraParams+"]");
		System.out.println("PalletOUTCalled........................... : ["+currentColumn+"]");

		E12GenericUtility genericUtility = new E12GenericUtility();		
		valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );
		try
		{
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(currentDate.getTime());	

			loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));			
			loginEmpCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));	
			chgUser = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
			chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));
			System.out.println("loginEmpCode---->>["+loginEmpCode+"] chgUser---->>["+chgUser+"]");	

			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB( "DriverITM" );
			conn = getConnection();
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
		
			dispDamageLock = checkNullAndTrim(distComm.getDisparams("999999", "DM_LOCKS", conn));
			dispHoldLock = checkNullAndTrim(distComm.getDisparams("999999", "HOLD_LOCKS", conn));
			dispNexpLoc = distComm.getDisparams("999999","NEAR_EXP_LOCK",conn);
			dispExpLoc = distComm.getDisparams("999999","EXP_LOCK",conn);
			String[] locD = dispDamageLock.split(",");
			System.out.println("Disparm Lenght for dispDamageLock="+locD.length);
			String[] locH = dispHoldLock.split(",");
			System.out.println("Disparm Lenght for dispHoldLock="+locH.length);
			String[] locN = dispNexpLoc.split(",");
			System.out.println("Disparm Lenght for dispNexpLoc="+locN.length);
			String[] locE = dispExpLoc.split(",");
			System.out.println("Disparm Lenght for dispExpLoc="+locE.length);

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			System.out.println("current form no["+currentFormNo+"]");
			valueXmlString.append("</editFlag>\r\n</Header>\r\n");

			switch ( currentFormNo )  
			{
			case 1:
			{
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					System.out.println("------------------ inside case 1 itemchange --------------- ");
				}
			} 
			break;

			case 2:
			{
				System.out.println("-------------- itemchanged in Details 2 ----------------------");

				System.out.println("hdrDataDom------->>["+genericUtility.serializeDom(hdrDataDom)+"]");	
				System.out.println("currFormDataDom------>>["+genericUtility.serializeDom(currFormDataDom)+"]");
				System.out.println("allFormDataDom------>>["+genericUtility.serializeDom(allFormDataDom)+"]");

				String palletNo = "",itemCode="",locCodeSugg="",itemSerRg="", errorType = "", errCode = "", errString = "";
				bayNo = checkNullAndTrim(genericUtility.getColumnValue("pallet_no", hdrDataDom));

				System.out.println("BayNo scanned is="+bayNo);

				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{	
					System.out.println("------------------ inside case 2 itemchange  ITEMDEFAULT--------------- ");

					//sql="SELECT DISTINCT(W.PALLET_NO) FROM SWMS_TO_AWMS S,WMS_TO_HOST W WHERE S.TRAN_ID = W.TRAN_ID AND S.SCHEDULE_STATUS = ? AND W.IN_OUT = ? AND W.BAY_NO = ? AND S.PALLET_NO = W.PALLET_NO AND S.IN_OUT = W.IN_OUT";
					sql="SELECT DISTINCT(W.PALLET_NO) FROM SWMS_TO_AWMS S,WMS_TO_HOST W WHERE S.REF_ID = W.REF_ID AND S.SCHEDULE_STATUS = ? AND W.IN_OUT = ? AND W.BAY_NO = ? AND S.PALLET_NO = W.PALLET_NO AND S.IN_OUT = W.IN_OUT";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, "N");
					pstmt.setString(2, "O");
					pstmt.setString(3, bayNo);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						palletNo = rs.getString("PALLET_NO");
						System.out.println( "palletNo:::"+palletNo);
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}

					sqlRef="SELECT REF_SER FROM SWMS_TO_AWMS WHERE PALLET_NO= ? AND IN_OUT=? AND SCHEDULE_STATUS =?";
					pstmt = conn.prepareStatement(sqlRef);
					pstmt.setString(1, palletNo);
					pstmt.setString(2, "O");
					pstmt.setString(3, "N");
					rsRef = pstmt.executeQuery();
					if(rsRef.next())
					{
						refSer = checkNullAndTrim(rsRef.getString("REF_SER"));
						System.out.println( "refSer:::["+refSer+"]");
					}
					if(pstmt != null)
					{ 
						pstmt.close();
						pstmt = null;
					}
					if(rsRef != null)
					{
						rsRef.close();
						rsRef = null;
					}

					if("D-SO".equalsIgnoreCase(checkNullAndTrim(refSer))||"S-ORD".equalsIgnoreCase(checkNullAndTrim(refSer)))
					{

						//Changed by Jagruti Shinde Request id:[W16GSUN004][Start]
						sqlRefId="SELECT REF_ID FROM SWMS_TO_AWMS WHERE PALLET_NO= ? AND IN_OUT=? AND SCHEDULE_STATUS =? AND REF_SER = ?";
						pstmt = conn.prepareStatement(sqlRefId);
						pstmt.setString(1, palletNo);
						pstmt.setString(2, "O");
						pstmt.setString(3, "N");
						pstmt.setString(4, refSer);
						rsRefId = pstmt.executeQuery();
						if(rsRefId.next())
						{
							refId = checkNullAndTrim(rsRefId.getString("REF_ID"));
							System.out.println( "refId:::["+refId+"]");
						}
						if(pstmt != null)
						{ 
							pstmt.close();
							pstmt = null;
						}
						if(rsRefId != null)
						{
							rsRefId.close();
							rsRefId = null;
						}

						sqlDist ="SELECT AVALIABLE_YN FROM DISTORDER WHERE DIST_ORDER = ? ";
						pstmt = conn.prepareStatement(sqlDist);
						pstmt.setString(1, refId);
						rsRefId = pstmt.executeQuery();
						if(rsRefId.next())
						{
							availiableYn = checkNullAndTrim(rsRefId.getString("AVALIABLE_YN"));
							System.out.println( "availiableYn:::["+availiableYn+"]");
						}
						if(pstmt != null)
						{ 
							pstmt.close();
							pstmt = null;
						}
						if(rsRefId != null)
						{
							rsRefId.close();
							rsRefId = null;
						}
						if("Y".equalsIgnoreCase(availiableYn))
						{
							sqlGen="SELECT UDF_STR1 FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? AND FLD_VALUE = ?";
							pstmtGen = conn.prepareStatement(sqlGen);
							pstmtGen.setString(1, "LOC_CODE_SUGG");
							pstmtGen.setString(2, "W_PALLETOUT");
							pstmtGen.setString(3, "DIST_ORD_APR");
							rsGen = pstmtGen.executeQuery();
							if(rsGen.next())
							{
								udfStr1 = checkNullAndTrim(rsGen.getString("UDF_STR1"));
							}
							if(pstmtGen != null)
							{
								pstmtGen.close();
								pstmtGen = null;
							}
							if(rsGen != null)
							{
								rsGen.close();
								rsGen = null;
							}

							System.out.println("UDF_STR1 from gencodes for DIST_ORD_APR["+udfStr1+"]");
							locCodeSugg = udfStr1 ;
						}
						else if("N".equalsIgnoreCase(availiableYn))
						{
							sqlGen="SELECT UDF_STR1 FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? AND FLD_VALUE = ?";
							pstmtGen = conn.prepareStatement(sqlGen);
							pstmtGen.setString(1, "LOC_CODE_SUGG");
							pstmtGen.setString(2, "W_PALLETOUT");
							pstmtGen.setString(3, "DIST_ORD_QUR");
							rsGen = pstmtGen.executeQuery();
							if(rsGen.next())
							{
								udfStr1 = checkNullAndTrim(rsGen.getString("UDF_STR1"));
							}
							if(pstmtGen != null)
							{
								pstmtGen.close();
								pstmtGen = null;
							}
							if(rsGen != null)
							{
								rsGen.close();
								rsGen = null;
							}

							System.out.println("UDF_STR1 from gencodes for DIST_ORD_QUR["+udfStr1+"]");
							locCodeSugg = udfStr1 ;
						}
						/*sqlGen="SELECT UDF_STR1 FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? AND FLD_VALUE = ?";
						pstmtGen = conn.prepareStatement(sqlGen);
						pstmtGen.setString(1, "LOC_CODE_SUGG");
						pstmtGen.setString(2, "W_PALLETOUT");
						pstmtGen.setString(3, "DIST_ORDER");
						rsGen = pstmtGen.executeQuery();
						if(rsGen.next())
						{
							udfStr1 = checkNullAndTrim(rsGen.getString("UDF_STR1"));
						}
						if(pstmtGen != null)
						{
							pstmtGen.close();
							pstmtGen = null;
						}
						if(rsGen != null)
						{
							rsGen.close();
							rsGen = null;
						}

						System.out.println("UDF_STR1 from gencodes["+udfStr1+"]");
						locCodeSugg = udfStr1 ;*/
						//Changed by Jagruti Shinde Request id:[W16GSUN004][End]
					}
					else
					{
						//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet request,Pallet request with stock details.Request id:[W16ASUN022][start]
						stkSql="SELECT LOC_CODE FROM STOCK WHERE  INV_STAT IN(?,?) AND LOC_CODE  IN(?,?,?,?,?,?,?,?,?) AND QUANTITY>0 AND SITE_CODE= ? ";

						stkpstmt = conn.prepareStatement(stkSql);
						stkpstmt.setString(1, "AWMS");
						stkpstmt.setString(2, "AWMSQ");
						stkpstmt.setString(3, palletNo);
						stkpstmt.setString(4, palletNo+"Q");
						stkpstmt.setString(5, palletNo+"B");
						stkpstmt.setString(6, palletNo+"X");
						stkpstmt.setString(7, palletNo+"M");
						stkpstmt.setString(8, palletNo+"U");
						stkpstmt.setString(9, palletNo+"P");
						stkpstmt.setString(10, palletNo+"S");
						stkpstmt.setString(11, palletNo+"R");
						stkpstmt.setString(12, loginSite);
						stkrs = stkpstmt.executeQuery();
						if(stkrs.next())
						{
							locCode = checkNullAndTrim(stkrs.getString("LOC_CODE"));
							System.out.println( "LOC CODE:::"+locCode);
						}
						if(stkpstmt != null)
						{ 
							stkpstmt.close();
							stkpstmt = null;
						}
						if(stkrs != null)
						{
							stkrs.close();
							stkrs = null;
						}

						lastChar=locCode.charAt(locCode.trim().length()-1);
						System.out.println("lastChar:"+lastChar); 

						sqlLock=" SELECT I.LOCK_CODE FROM INV_HOLD_DET D,INV_HOLD I ,STOCK S  WHERE S.ITEM_CODE = D.ITEM_CODE " +
								" AND S.LOC_CODE = D.LOC_CODE AND S.LOT_NO = D.LOT_NO AND S.LOT_SL = D.LOT_SL AND " +
								" S.SITE_CODE = D.SITE_CODE AND I.TRAN_ID = D.TRAN_ID   AND D.HOLD_STATUS != ?  " +
								" AND S.INV_STAT IN( ?,?) AND S.SITE_CODE= ? AND S.QUANTITY>0 AND " +
								" S.LOC_CODE= ? ";

						pstmt = conn.prepareStatement(sqlLock);
						pstmt.setString(1, "R");
						pstmt.setString(2, "AWMS");
						pstmt.setString(3, "AWMSQ");
						pstmt.setString(4, loginSite);
						pstmt.setString(5, locCode);

						rs = pstmt.executeQuery();
						if(rs.next())
						{
							lockCode = checkNullAndTrim(rs.getString("LOCK_CODE"));
							System.out.println( "LOCK CODE:::"+lockCode);
						}
						if(pstmt != null)
						{ 
							pstmt.close();
							pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						} 

						System.out.println("locCode from query::::::["+lockCode+"]");
						System.out.println("locCode from disparm for expiry::::::["+dispExpLoc+"]");
						System.out.println("locCode from disparm for near expiry::::::["+dispNexpLoc+"]");

						if('R'==(lastChar))
						{
							if(!lockCode.equalsIgnoreCase(checkNullAndTrim(dispExpLoc)) && !lockCode.equalsIgnoreCase(checkNullAndTrim(dispNexpLoc)))
							{
								sqlGen="SELECT UDF_STR1 FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? AND FLD_VALUE = ?";
								pstmtGen = conn.prepareStatement(sqlGen);
								pstmtGen.setString(1, "LOC_CODE_SUGG");
								pstmtGen.setString(2, "W_PALLETOUT");
								pstmtGen.setString(3, "REJECTED");
								rsGen = pstmtGen.executeQuery();
								if(rsGen.next())
								{
									udfStr1 = checkNullAndTrim(rsGen.getString("UDF_STR1"));
								}
								if(pstmtGen != null)
								{
									pstmtGen.close();
									pstmtGen = null;
								}
								if(rsGen != null)
								{
									rsGen.close();
									rsGen = null;
								}

								System.out.println("UDF_STR1 from gencodes for Rejected Pallet["+udfStr1+"]");
								locCodeSugg = udfStr1 ;
							}
							else 
							{
								for (int j = 0; j < locE.length; j++) 
								{
									if((dispExpLoc).equalsIgnoreCase(checkNullAndTrim(lockCode)))
									{
										sqlGen="SELECT UDF_STR1 FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? AND FLD_VALUE = ?";
										pstmtGen = conn.prepareStatement(sqlGen);
										pstmtGen.setString(1, "LOC_CODE_SUGG");
										pstmtGen.setString(2, "W_PALLETOUT");
										pstmtGen.setString(3, "EXPIRE");
										rsGen = pstmtGen.executeQuery();
										if(rsGen.next())
										{
											udfStr1 = checkNullAndTrim(rsGen.getString("UDF_STR1"));
										}
										if(pstmtGen != null)
										{
											pstmtGen.close();
											pstmtGen = null;
										}
										if(rsGen != null)
										{
											rsGen.close();
											rsGen = null;
										}

										System.out.println("UDF_STR1 from gencodes for Rejected Expire pallet["+udfStr1+"]");
										locCodeSugg = udfStr1 ;
										break;
									}
								}
								for (int k = 0; k < locN.length; k++) 
								{
									if((dispNexpLoc).equalsIgnoreCase(checkNullAndTrim(lockCode)))
									{
										sqlGen="SELECT UDF_STR1 FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? AND FLD_VALUE = ?";
										pstmtGen = conn.prepareStatement(sqlGen);
										pstmtGen.setString(1, "LOC_CODE_SUGG");
										pstmtGen.setString(2, "W_PALLETOUT");
										pstmtGen.setString(3, "NEAREXPIRE");
										rsGen = pstmtGen.executeQuery();
										if(rsGen.next())
										{
											udfStr1 = checkNullAndTrim(rsGen.getString("UDF_STR1"));
										}
										if(pstmtGen != null)
										{
											pstmtGen.close();
											pstmtGen = null;
										}
										if(rsGen != null)
										{
											rsGen.close();
											rsGen = null;
										}

										System.out.println("UDF_STR1 from gencodes for Rejected NearExpire pallet["+udfStr1+"]");
										locCodeSugg = udfStr1 ;
										break;
									}
								}
							}
						}
						//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet request,Pallet request with stock details.Request id:[W16ASUN022][end]
						else
						{
							for (int z = 0; z < locD.length; z++) 
							{
								dispDamageLock = locD[z].trim();
								if(lockCode.equalsIgnoreCase(checkNullAndTrim(dispDamageLock)))
								{
									sqlGen="SELECT UDF_STR1 FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? AND FLD_VALUE = ?";
									pstmtGen = conn.prepareStatement(sqlGen);
									pstmtGen.setString(1, "LOC_CODE_SUGG");
									pstmtGen.setString(2, "W_PALLETOUT");
									pstmtGen.setString(3, "DAMAGE");
									rsGen = pstmtGen.executeQuery();
									if(rsGen.next())
									{
										udfStr1 = checkNullAndTrim(rsGen.getString("UDF_STR1"));
									}
									if(pstmtGen != null)
									{
										pstmtGen.close();
										pstmtGen = null;
									}
									if(rsGen != null)
									{
										rsGen.close();
										rsGen = null;
									}

									System.out.println("UDF_STR1 from gencodes for damage pallet["+udfStr1+"]");
									locCodeSugg = udfStr1 ;
									break;
								}
							}
							for (int i = 0; i < locH.length; i++) 
							{
								dispHoldLock = locH[i].trim();
								if(lockCode.equalsIgnoreCase(checkNullAndTrim(dispHoldLock)))
								{
									sqlGen="SELECT UDF_STR1 FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? AND FLD_VALUE = ?";
									pstmtGen = conn.prepareStatement(sqlGen);
									pstmtGen.setString(1, "LOC_CODE_SUGG");
									pstmtGen.setString(2, "W_PALLETOUT");
									pstmtGen.setString(3, "HOLD");
									rsGen = pstmtGen.executeQuery();
									if(rsGen.next())
									{
										udfStr1 = checkNullAndTrim(rsGen.getString("UDF_STR1"));
									}
									if(pstmtGen != null)
									{
										pstmtGen.close();
										pstmtGen = null;
									}
									if(rsGen != null)
									{
										rsGen.close();
										rsGen = null;
									}

									System.out.println("UDF_STR1 from gencodes for hold pallet["+udfStr1+"]");
									locCodeSugg = udfStr1 ;
									break;
								}
							}

							for (int j = 0; j < locE.length; j++) 
							{
								if((dispExpLoc).equalsIgnoreCase(checkNullAndTrim(lockCode)))
								{
									sqlGen="SELECT UDF_STR1 FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? AND FLD_VALUE = ?";
									pstmtGen = conn.prepareStatement(sqlGen);
									pstmtGen.setString(1, "LOC_CODE_SUGG");
									pstmtGen.setString(2, "W_PALLETOUT");
									pstmtGen.setString(3, "EXPIRE");
									rsGen = pstmtGen.executeQuery();
									if(rsGen.next())
									{
										udfStr1 = checkNullAndTrim(rsGen.getString("UDF_STR1"));
									}
									if(pstmtGen != null)
									{
										pstmtGen.close();
										pstmtGen = null;
									}
									if(rsGen != null)
									{
										rsGen.close();
										rsGen = null;
									}

									System.out.println("UDF_STR1 from gencodes for Expire pallet["+udfStr1+"]");
									locCodeSugg = udfStr1 ;
									break;
								}
							}
							for (int k = 0; k < locN.length; k++) 
							{
								if((dispNexpLoc).equalsIgnoreCase(checkNullAndTrim(lockCode)))
								{
									sqlGen="SELECT UDF_STR1 FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? AND FLD_VALUE = ?";
									pstmtGen = conn.prepareStatement(sqlGen);
									pstmtGen.setString(1, "LOC_CODE_SUGG");
									pstmtGen.setString(2, "W_PALLETOUT");
									pstmtGen.setString(3, "NEAREXPIRE");
									rsGen = pstmtGen.executeQuery();
									if(rsGen.next())
									{
										udfStr1 = checkNullAndTrim(rsGen.getString("UDF_STR1"));
									}
									if(pstmtGen != null)
									{
										pstmtGen.close();
										pstmtGen = null;
									}
									if(rsGen != null)
									{
										rsGen.close();
										rsGen = null;
									}

									System.out.println("UDF_STR1 from gencodes for NearExpire pallet["+udfStr1+"]");
									locCodeSugg = udfStr1 ;
									break;
								}
							}
							if(locCodeSugg == null || locCodeSugg.length() == 0)
							{
								sql="SELECT ITEM_CODE,LOT_NO,LOT_SL FROM STOCK WHERE INV_STAT IN(?,?) AND LOC_CODE IN(?,?,?,?,?,?,?,?) AND QUANTITY>0 AND SITE_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, "AWMS");
								pstmt.setString(2, "AWMSQ");
								pstmt.setString(3, palletNo);
								pstmt.setString(4, palletNo+"Q");
								pstmt.setString(5, palletNo+"B");
								pstmt.setString(6, palletNo+"X");
								pstmt.setString(7, palletNo+"M");
								pstmt.setString(8, palletNo+"U");
								pstmt.setString(9, palletNo+"P");
								pstmt.setString(10, palletNo+"S");
								pstmt.setString(11, loginSite);
								rs = pstmt.executeQuery();
								while(rs.next())
								{
									itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
									lotNo = checkNullAndTrim(rs.getString("LOT_NO"));
									lotSl = checkNullAndTrim(rs.getString("LOT_SL"));
									System.out.println( "item code:::"+itemCode);
									System.out.println( "lotNo:::"+lotNo);
									System.out.println( "lotSl:::"+lotSl);

									sql1="SELECT STATUS FROM QC_ORDER WHERE ITEM_CODE=? AND SITE_CODE=? AND LOT_NO=?  ";
									pstmt1 = conn.prepareStatement(sql1);
									pstmt1.setString(1, itemCode);
									pstmt1.setString(2, loginSite);
									pstmt1.setString(3, lotNo);
									rs1 = pstmt1.executeQuery();
									while(rs1.next())
									{
										status = checkNullAndTrim(rs1.getString("STATUS"));
										System.out.println("Staus["+status+"]");

										if("U".equalsIgnoreCase(checkNullAndTrim(status)))
										{
											sqlGen="SELECT UDF_STR1 FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? AND FLD_VALUE = ?";
											pstmtGen = conn.prepareStatement(sqlGen);
											pstmtGen.setString(1, "LOC_CODE_SUGG");
											pstmtGen.setString(2, "W_PALLETOUT");
											pstmtGen.setString(3, "QC");
											rsGen = pstmtGen.executeQuery();
											if(rsGen.next())
											{
												udfStr1 = checkNullAndTrim(rsGen.getString("UDF_STR1"));
											}
											if(pstmtGen != null)
											{
												pstmtGen.close();
												pstmtGen = null;
											}
											if(rsGen != null)
											{
												rsGen.close();
												rsGen = null;
											}

											System.out.println("UDF_STR1 from gencodes for QC pending Pallets["+udfStr1+"]");
											locCodeSugg = udfStr1 ;
											break;

										}
										System.out.println("Finally ending code while loop QC Order");
										break;
									}
									if(pstmt1 != null)
									{
										pstmt1.close();
										pstmt1 = null;
									}
									if(rs1 != null)
									{
										rs1.close();
										rs1 = null;
									}

									System.out.println("Loc Code suggest Found from QC Order="+locCodeSugg);

									if(locCodeSugg == null || locCodeSugg.length() == 0)
									{		
										sql = "SELECT ITEM_SER__RG1 FROM SITEITEM WHERE ITEM_CODE = ? AND SITE_CODE=?";
										pstmtGen = conn.prepareStatement(sql);
										pstmtGen.setString(1, itemCode);
										pstmtGen.setString(2, loginSite);
										rsGen = pstmtGen.executeQuery();
										if(rsGen.next())
										{
											itemSerRg = checkNullAndTrim(rsGen.getString("ITEM_SER__RG1"));
											System.out.println("itemSerRg FROM SITEITEM::"+itemSerRg);
										}
										if(pstmtGen != null)
										{ 
											pstmtGen.close();
											pstmtGen = null;
										}
										if(rsGen != null)
										{
											rsGen.close();
											rsGen = null;
										}
										System.out.println("ITEM_SER__RG1["+itemSerRg+"]");

										//sql1="SELECT FLD_VALUE FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? ";
										sql1="SELECT UDF_STR1 FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? AND FLD_VALUE = ?";
										pstmtGen = conn.prepareStatement(sql1);
										pstmtGen.setString(1, "LOC_CODE_SUGG");
										pstmtGen.setString(2, "W_PALLETOUT");
										pstmtGen.setString(3, itemSerRg);
										rsGen = pstmtGen.executeQuery();
										//while(rsGen.next())
										if(rsGen.next())
										{
											udfStr = checkNullAndTrim(rsGen.getString("UDF_STR1"));
											System.out.println("udfStr FROM GENCODES for item_ser::"+udfStr);

											System.out.println("itemSerRg["+itemSerRg+"]");
											System.out.println("fld_value["+fld_value+"]");
											System.out.println("udf_str1 :"+udf_str1);
											locCodeSugg = udfStr ;
										}
										if(pstmtGen != null)
										{ 
											pstmtGen.close();
											pstmtGen = null;
										}
										if(rsGen != null)
										{
											rsGen.close();
											rsGen = null;
										}
									}

									System.out.println("Finally ending code of while loop");
									break;
								}
								if(pstmt != null)
								{ 
									pstmt.close();
									pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
							}
						}
					}


					valueXmlString.append("<Detail2 domID=\"1\" selected=\"Y\">\r\n");
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n");
					valueXmlString.append( "<pallet_no><![CDATA[" ).append( palletNo ).append( "]]></pallet_no>\r\n" );
					valueXmlString.append( "<loc_code_input><![CDATA[" ).append( locCodeInput ).append( "]]></loc_code_input>\r\n" );
					valueXmlString.append( "<loc_code_sugg><![CDATA[" ).append( locCodeSugg ).append( "]]></loc_code_sugg>\r\n" );
					valueXmlString.append("</Detail2>\r\n");

					if(locCodeInput.equalsIgnoreCase(locCodeSugg))
					{
						System.out.println("in itemchange input location is same as suggested location");
					}
					else
					{
						System.out.println(" in itemchange input location is not same  as suggested location");
						errCode = "VMLOCATEXS";//not same
						errList.add( errCode );
						errFields.add( childNodeName.toLowerCase() );
						break;
					}
				}
			} 
			break;
			}
			valueXmlString.append( "</Root>\r\n" );	 
		}
		catch (Exception e)
		{				
			e.printStackTrace();
		}
		finally
		{	
			try
			{				
				if(pstmt != null) 
				{ 
					pstmt.close();
					pstmt = null; 
				}
				if(rs != null)
				{ 
					rs.close();
					rs = null; 
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println( "XML String return from item change="+valueXmlString.toString());
		return valueXmlString.toString();
	}

	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}

	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}

}
