package ibase.webitm.ejb.wms;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ibase.webitm.ejb.wms.DDPorderWizPosEJB;
/**
 * Session Bean implementation class DDProductWizEditEJB
 */
@Stateless
public class DDProductWizEditEJB extends ValidatorEJB implements DDProductWizEditRemote, DDProductWizEditLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	
    /**
     * Default constructor. 
     */
    public DDProductWizEditEJB() 
    {
    	
    }

	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		
		try
		{
			System.out.println("xmlString:::"+xmlString);
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : DDProductWizEditEJB : wfValData(String xmlString) : ==>\n"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		
		return (errString);
	}
	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) 	throws RemoteException, ITMException 
	{
		System.out.println("================ Inside wfValData ============= "); 
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String userId = "";
		String errCode = "";
		String errorType = "";
		String errString = "";
		int ctr=0;
		int childNodeListLength;
		int currentFormNo = 0;
		long cnt = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		//ConnDriver connDriver = new ConnDriver();
		// Changed by Sneha on 23-06-2016 [Start]
		boolean flag = false; 
		String item_barcode = "", fieldValue = "", msgNo = "", msgStr1 = "", msgStr2 = ""; 
		// Changed by Sneha on 23-06-2016 [End]
				
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			switch(currentFormNo)
			{
			case 1 :
				System.out.println(" -------- Inside wfValData case 1 ----------- "); 
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					
					if (childNodeName.equalsIgnoreCase("item_code")) 
					{
						int paramName = 0;
						String item_parnt = genericUtility.getColumnValue("item_code", dom);
						String countSerSql = "SELECT COUNT(1) AS COUNT FROM ITEM WHERE TRIM(ITEM_CODE) = ?";
						PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
						pstmtParamName.setString(1, item_parnt);
						ResultSet rsCnt = pstmtParamName.executeQuery();
						
						System.out.println("countSerSql" + countSerSql);
						if (rsCnt.next()) 
						{
							paramName = rsCnt.getInt("COUNT");
						}
						// Changed by Sneha on 21-07-2016, for Closing the Open Cursor [Start]
						if( pstmtParamName != null )
						{
							pstmtParamName.close();
							pstmtParamName = null;
						}
						if ( rsCnt != null )
						{
							rsCnt.close();
							rsCnt = null;
						}
						// Changed by Sneha on 21-07-2016, for Closing the Open Cursor [End]
						
						if (paramName == 0) {
							
							errCode = "INPRNTCD";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					// Changed by Sneha on 24-10-2016 for validation of customer item reference [Start]
					else if (childNodeName.equalsIgnoreCase("phy_attrib_4")) 
					{
						String custItemRef = checkNullAndTrim(genericUtility.getColumnValue("phy_attrib_4", dom));
						//System.out.println("dimensionDesc==========>>"+dimensionDesc);
						
						if (custItemRef.length() == 0) 
						{
							errCode = "VTINVCITEM";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					// Changed by Sneha on 24-10-2016 for validation of customer item reference [End]
					
				}
				break;
			
			case 2 :
			{
				System.out.println(" -------- Inside wfValData case 2 ----------- "); 
				String phy_attrib_4 = "";
				int paramName = 0;
				
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					
					if (childNodeName.equalsIgnoreCase("phy_attrib_4"))
					{
						phy_attrib_4 = genericUtility.getColumnValue("phy_attrib_4", dom);
						String ITEM_CODE = genericUtility.getColumnValue("item_code", dom);
						
						if (phy_attrib_4.length() == 0) 
						{
							errCode = "VTINVCITEM";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else if (phy_attrib_4.length() > 0) 
						{
							String countSerSql = "SELECT COUNT(1) AS COUNT FROM ITEM WHERE TRIM(PHY_ATTRIB_4) = ? AND ITEM_PARNT != ?  ";
							PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
							pstmtParamName.setString(1, phy_attrib_4);
							pstmtParamName.setString(2, ITEM_CODE);
							ResultSet rsCnt = pstmtParamName.executeQuery();
							if (rsCnt.next()) 
							{
								paramName = rsCnt.getInt("COUNT");
							}
							if( pstmtParamName != null )
							{
								pstmtParamName.close();
								pstmtParamName = null;
							}
							if ( rsCnt != null )
							{
								rsCnt.close();
								rsCnt = null;
							}
							if (paramName != 0) 
							{
								flag = true; 
								fieldValue = phy_attrib_4;
								msgNo = "DUPCUSTITM";
								msgStr1 = "Invalid Customer item reference for.";
								msgStr2 = "Customer item reference already exists in item master";
							}
						}
					}
				}
			}
			break;
			
			case 3 :
				System.out.println(" -------- Inside wfValData case 3 ----------- "); 
				String customerName = "", phy_attrib_4 = "";
				int paramName = 0;
				
				parentNodeList = dom.getElementsByTagName("Detail3");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				
				//Added by Parikshit Kumbhar on 25/06/2015 to make error msg on barcode start
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					
					   if (childNodeName.equalsIgnoreCase("item_barcode")) 
						{
							item_barcode = genericUtility.getColumnValue("item_barcode", dom);
							String ITEM_CODE = genericUtility.getColumnValue("item_code", dom);

							String countSerSql = "SELECT COUNT(1) AS COUNT FROM ITEM WHERE TRIM(UDF__STR2) = ? AND ITEM_CODE != ? ";
							PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
							pstmtParamName.setString(1, item_barcode);
							pstmtParamName.setString(2, ITEM_CODE);
							ResultSet rsCnt = pstmtParamName.executeQuery();
							
							System.out.println("countSerSql" + countSerSql);
							if (rsCnt.next()) 
							{
								paramName = rsCnt.getInt("COUNT");
							}
							// Changed by Sneha on 21-07-2016, for Closing the Open Cursor [Start]
							if( pstmtParamName != null )
							{
								pstmtParamName.close();
								pstmtParamName = null;
							}
							if ( rsCnt != null )
							{
								rsCnt.close();
								rsCnt = null;
							}
							// Changed by Sneha on 21-07-2016, for Closing the Open Cursor [End]
							
							if (paramName != 0)
							{
								// Changed by Sneha on 23-06-2016 for validation of item_barcode [Start]
								flag = true; 
								fieldValue = item_barcode;
								msgNo = "DUPITMBARC";
								msgStr1 = "Invalid Barcode for.";
								msgStr2 = "Barcode already exists in master for the barcode";
								
								/*errCode = "DUPITMBARC";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());*/
								// Changed by Sneha on 23-06-2016 for validation of item_barcode [Start]
							}
						}
					   
					   // Changed by Sneha on 23-06-2016 for duplicate validation for customer item references [Start]
					   else if (childNodeName.equalsIgnoreCase("phy_attrib_4"))
					   {
						   phy_attrib_4 = genericUtility.getColumnValue("phy_attrib_4", dom);
						   String ITEM_CODE = genericUtility.getColumnValue("item_code", dom);
						   
						   if (phy_attrib_4.length() == 0) 
							{
								errCode = "VTINVCITEM";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else if (phy_attrib_4.length() > 0) 
							{
								String countSerSql = "SELECT COUNT(1) AS COUNT FROM ITEM WHERE TRIM(PHY_ATTRIB_4) = ? AND ITEM_CODE != ? ";
								PreparedStatement pstmtParamName = conn.prepareStatement(countSerSql);
								pstmtParamName.setString(1, phy_attrib_4);
								pstmtParamName.setString(2, ITEM_CODE);
								ResultSet rsCnt = pstmtParamName.executeQuery();
								if (rsCnt.next()) 
								{
									paramName = rsCnt.getInt("COUNT");
								}
								if( pstmtParamName != null )
								{
									pstmtParamName.close();
									pstmtParamName = null;
								}
								if ( rsCnt != null )
								{
									rsCnt.close();
									rsCnt = null;
								}
								if (paramName != 0) 
								{
									flag = true; 
									fieldValue = phy_attrib_4;
									msgNo = "DUPCUSTITM";
									msgStr1 = "Invalid Customer item reference for.";
									msgStr2 = "Customer item reference already exists in item master";
								}
							}
					   }
					   // Changed by Sneha on 23-06-2016 for duplicate validation for customer item references [End]
				}
				//Added by Parikshit Kumbhar on 25/06/2015 to make error msg on barcode End
			}
			
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			// Changed by Sneha on 23-06-2016 for validation of item_barcode [Start]
			else
			{
				//errStringXml = new StringBuffer("");
				if(flag) 
				{
					//System.out.println("Inside flag=======>>"+flag);
					//return getError(item_barcode, "DUPITMBARC", conn); 
					return getError(fieldValue, msgNo, msgStr1, msgStr2, conn);
				}
				else
				{
					errStringXml = new StringBuffer("");
				}
			}
			/*else
			{
				errStringXml = new StringBuffer("");
			}*/
			// Changed by Sneha on 23-06-2016 for validation of item_barcode [End]
			
		}// End of try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//connDriver = null;
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}

	// Changed by Sneha on 23-06-2016 for validation of item_barcode [Start]
	//public  String getError(String item_barcode, String Code, Connection conn)  throws ITMException, Exception
	public  String getError(String fieldValue, String msgNo, String msgStr1, String msgStr2, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";
		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",msgNo,"","",conn);
			String begPart = errString.substring(0,errString.indexOf("<message>")+9);
			String endDesc = errString.substring(errString.indexOf("</description>"));
			mainStr= begPart+ msgStr1 +"</message><description>";
			mainStr= mainStr+ msgStr2 + " : ["+fieldValue+"]."+endDesc;
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	// Changed by Sneha on 23-06-2016 for validation of item_barcode [End]
		
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, 	String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";
		
		try
		{
			System.out.println("xmlString:::"+xmlString);
			System.out.println("xmlString1:::"+xmlString1);
			System.out.println("xmlString2:::"+xmlString2);
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : DDProductWizEditEJB : itemChanged(String,String,String,String,String,String):\n" + e.getMessage() + ":");
			valueXmlString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		
		return (valueXmlString);
	}

	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		System.out.println("================ Inside itemChanged ============= "); 
		String userId = "";
		String currDate = "";
		String chgTerm = "";
		int currentFormNo = 0;
		
		StringBuffer valueXmlString = new StringBuffer();
		
		try 
		{
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			String dateFormat = genericUtility.getApplDateFormat();//Added by parikshit on 07/07/15 [for date format]
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			currDate = sdf.format(new java.util.Date());
			
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			
			valueXmlString = new StringBuffer("<?xml version = \"1.0\" encoding=\"ISO-8859-1\" ?>\r\n<Root>\r\n<header>\r\n<editFlag>");//Added by parikshit on 07/07/15 [for date format]
			valueXmlString.append(editFlag).append("</editFlag>\r\n</header>\r\n");
			
			switch ( currentFormNo )
			{
				case 1:
				{
					System.out.println("---------- Inside itemChanged Case1 --------- "); 
					valueXmlString.append("<Detail1 domID='1' selected = 'Y'>\r\n");
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						valueXmlString.append("<item_code>").append("<![CDATA[]]>").append("</item_code>\r\n");
						valueXmlString.append("<login_code>").append("<![CDATA["+ userId +"]]>").append("</login_code>\r\n");
						valueXmlString.append("<date_format>").append("<![CDATA["+ dateFormat +"]]>").append("</date_format>\r\n");//Added by Parikshit Kumbhar on 08/07/15 [to set date format]
					}
					valueXmlString.append("</Detail1>\r\n");
				}
				break;
				case 2:
				{
					System.out.println("---------- Inside itemChanged Case2 --------- "); 
					String itemCode = genericUtility.getColumnValue("item_code", dom1);
					
					valueXmlString.append("<Detail2 domID='1' selected = 'Y'>\r\n");
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						valueXmlString.append( getItemParentDetails( dom, itemCode) );
						valueXmlString.append("<login_code>").append("<![CDATA["+ userId +"]]>").append("</login_code>\r\n");
						valueXmlString.append("<date_format>").append("<![CDATA["+ dateFormat +"]]>").append("</date_format>\r\n");//Added by Parikshit Kumbhar on 08/07/15 [to set date format]
					}
					valueXmlString.append("</Detail2>\r\n");	
					//System.out.println("valueXmlString in case 2======>>"+valueXmlString.toString());
				}
				break;
				case 3:
				{
					System.out.println("---------- Inside itemChanged Case3 --------- "); 
				/*	System.out.println("DOM in case3 ---->>["+genericUtility.serializeDom(dom).toString()+"]");
					System.out.println("DOM1 in case3 ----->>["+genericUtility.serializeDom(dom1).toString()+"]");
					System.out.println("DOM2 in case3 ----->>["+genericUtility.serializeDom(dom2).toString()+"]");
					*/
					String itemCode = genericUtility.getColumnValue("item_code", dom1);
					String phy_attrib_4 = genericUtility.getColumnValue("phy_attrib_4", dom2);
					//System.out.println("phy_attrib_4 in case 3 ======>>"+phy_attrib_4);

					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						//Changed by Sneha on 30-03-2016, for login code [Start]
						//valueXmlString.append( getSKUDetails( dom, itemCode, dom1, dom2) );
						valueXmlString.append( getSKUDetails( dom,  dom1, dom2, itemCode, phy_attrib_4, userId) );
						//Changed by Sneha on 30-03-2016, for login code [End]
					}
					System.out.println("valueXmlString in case 3 ======>>"+valueXmlString.toString());
					
					
					/*String phyAttrib1Str = genericUtility.getColumnValue("phy_attrib_1", dom2, "2");
					String phyAttrib2Str = genericUtility.getColumnValue("phy_attrib_2", dom2, "2");
					String phyAttrib6Str = genericUtility.getColumnValue("phy_attrib_6", dom2, "2");
					
					System.out.println("itemCode inside itemChanged Case3 ---->> "+ itemCode);
					System.out.println("phy_attrib_1 @@@ inside itemChanged Case3 ---->> "+ phyAttrib1Str);
					System.out.println("phy_attrib_2  @@@ inside itemChanged Case3 ---->> "+ phyAttrib2Str);
					System.out.println("phy_attrib_6  @@@ inside itemChanged Case3 ---->> "+ phyAttrib6Str);
					*/

				}
				break;
			}
		}
		catch (NumberFormatException e) 
		{
			e.printStackTrace();
			System.out.println("NumberFormatException ::"+ e.getMessage());
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		valueXmlString.append("</Root>");
		System.out.println("valueXmlString ::"+valueXmlString.toString());
		
		return valueXmlString.toString();
	}
	
	private String getItemParentDetails( Document dom, String itemCode ) throws Exception 
	{
		System.out.println("--------- Inside getItemParentDetails for details 2 ----------");
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		Connection conn = null;
		StringBuffer valueXmlString = new StringBuffer();
		//Changed by samadhan on 23/12/2015 for get attrib val
		DDProductWizPosEJB prodPos=new DDProductWizPosEJB();
		try
		{
			if ( preDomExists( dom, "2" ) )
			{
				String preFormDet = getPrevFormValues( dom, "2" );
				Document preFormDom =  genericUtility.parseString("<Root>"+preFormDet+"</Root>");
				
				String item_code 	= checkNullAndTrim(genericUtility.getColumnValue("item_code", preFormDom));
				String descr 		= checkNullAndTrim(genericUtility.getColumnValue("descr", preFormDom));
				String item_type 	= checkNullAndTrim(genericUtility.getColumnValue("item_type", preFormDom));
				String item_type_descr = checkNullAndTrim(genericUtility.getColumnValue("item_type_descr", preFormDom));
				String item_ser 	= checkNullAndTrim(genericUtility.getColumnValue("item_ser", preFormDom));
				String item_ser_descr = checkNullAndTrim(genericUtility.getColumnValue("item_ser_descr", preFormDom));
				String grp_code 	= checkNullAndTrim(genericUtility.getColumnValue("grp_code", preFormDom));
				String grp_code_descr = checkNullAndTrim(genericUtility.getColumnValue("grp_code_descr", preFormDom));
				String loc_code 	= checkNullAndTrim(genericUtility.getColumnValue("loc_code", preFormDom));
				String loc_type 	= checkNullAndTrim(genericUtility.getColumnValue("loc_type", preFormDom));
				String loc_code_descr = checkNullAndTrim(genericUtility.getColumnValue("loc_code_descr", preFormDom));
				String sh_descr 	= checkNullAndTrim(genericUtility.getColumnValue("sh_descr", preFormDom));
				String long_descr 	= checkNullAndTrim(genericUtility.getColumnValue("long_descr", preFormDom));
				String meta_keywords = checkNullAndTrim(genericUtility.getColumnValue("meta_keywords", preFormDom));
				String meta_title 	= checkNullAndTrim(genericUtility.getColumnValue("meta_title", preFormDom));
				String meta_desc 	= checkNullAndTrim(genericUtility.getColumnValue("meta_desc", preFormDom));
				String img_path 	= checkNullAndTrim(genericUtility.getColumnValue("img_path", preFormDom));
				String pur_lead_time = checkNullAndTrim(genericUtility.getColumnValue("pur_lead_time", preFormDom));
				String tax 			= checkNullAndTrim(genericUtility.getColumnValue("tax", preFormDom));
				String tax_descr 	= checkNullAndTrim(genericUtility.getColumnValue("tax_descr", preFormDom));
				String language 	= checkNullAndTrim(genericUtility.getColumnValue("language", preFormDom));
				String language_desc = checkNullAndTrim(genericUtility.getColumnValue("language_desc", preFormDom));
				String language_dtl = checkNullAndTrim(genericUtility.getColumnValue("language_dtl", preFormDom));
				//Changed by Samadhan for brand,limited edition purchase stop start
				String phy_attrib_24 = checkNullAndTrim(genericUtility.getColumnValue("phy_attrib_24", preFormDom));//brand code
				String usage_type = checkNullAndTrim(genericUtility.getColumnValue("usage_type", preFormDom));//limited edition
				String brand_descr = checkNullAndTrim(genericUtility.getColumnValue("brand_descr", preFormDom));//Brand descr
				String stop_purchase = checkNullAndTrim(genericUtility.getColumnValue("stop_purchase", preFormDom));//Stop purchase
				//Changed by Samadhan for brand,limited edition purchase stop end
				// Changed by Sneha on 07-07-2016, to edit the item parent description [Start]
				String attr_value = checkNullAndTrim(genericUtility.getColumnValue("attr_value", preFormDom));//Stop purchase
				// Changed by Sneha on 07-07-2016, to edit the item parent description [End]
				
				//Changed by wasim on 02-08-2016 to add tax_chap field [START]
				String taxChap = checkNullAndTrim(genericUtility.getColumnValue("tax_chap", preFormDom));
				//Changed by wasim on 02-08-2016 to add tax_chap field [END]
				
				//Changed by Sneha on 26-09-2016, to add new field trade mark [Start]
				String tradeMark = checkNullAndTrim(genericUtility.getColumnValue("trade_mark", preFormDom));
				//Changed by Sneha on 26-09-2016, to add new field trade mark [End]
				
				//Changed by Sneha on 26-09-2016, to add new field trade mark [Start]
				String custItemRef = checkNullAndTrim(genericUtility.getColumnValue("phy_attrib_4", preFormDom));
				//Changed by Sneha on 26-09-2016, to add new field trade mark [End]

				//Changed by Sneha on 03-11-2016, to display size and color code [Start]
				String phy_attrib_1 = checkNullAndTrim(genericUtility.getColumnValue("phy_attrib_1", preFormDom));
				String phy_attrib_2 = checkNullAndTrim(genericUtility.getColumnValue("phy_attrib_2", preFormDom));
				String phy_attrib_6 = checkNullAndTrim(genericUtility.getColumnValue("phy_attrib_6", preFormDom));
				String color_code_descr = checkNullAndTrim(genericUtility.getColumnValue("color_code_descr", preFormDom));
				//Changed by Sneha on 03-11-2016, to display size and color code [End]
				
				valueXmlString.append("<item_code>").append("<![CDATA["+ checkNullAndTrim(item_code) +"]]>").append("</item_code>\r\n");
				valueXmlString.append("<descr>").append("<![CDATA["+ checkNullAndTrim(descr) +"]]>").append("</descr>\r\n");	
				
				valueXmlString.append("<item_type>").append("<![CDATA["+ checkNullAndTrim(item_type) +"]]>").append("</item_type>\r\n");
				valueXmlString.append("<item_type_descr>").append("<![CDATA["+ checkNullAndTrim(item_type_descr) +"]]>").append("</item_type_descr>\r\n");
				
				valueXmlString.append("<item_ser>").append("<![CDATA["+ checkNullAndTrim(item_ser) +"]]>").append("</item_ser>\r\n");
				valueXmlString.append("<item_ser_descr>").append("<![CDATA["+ checkNullAndTrim(item_ser_descr) +"]]>").append("</item_ser_descr>\r\n");
				
				valueXmlString.append("<grp_code>").append("<![CDATA["+ checkNullAndTrim(grp_code) +"]]>").append("</grp_code>\r\n");
				valueXmlString.append("<grp_code_descr>").append("<![CDATA["+ checkNullAndTrim(grp_code_descr) +"]]>").append("</grp_code_descr>\r\n");
				
				valueXmlString.append("<loc_code>").append("<![CDATA["+ checkNullAndTrim(loc_code) +"]]>").append("</loc_code>\r\n");
				valueXmlString.append("<loc_type>").append("<![CDATA["+ checkNullAndTrim(loc_type) +"]]>").append("</loc_type>\r\n");
				valueXmlString.append("<loc_code_descr>").append("<![CDATA["+ checkNullAndTrim(loc_code_descr) +"]]>").append("</loc_code_descr>\r\n");
				
				valueXmlString.append("<sh_descr>").append("<![CDATA["+ checkNullAndTrim(sh_descr) +"]]>").append("</sh_descr>\r\n");
				valueXmlString.append("<long_descr>").append("<![CDATA["+ checkNullAndTrim(long_descr) +"]]>").append("</long_descr>\r\n");
				valueXmlString.append("<meta_keywords>").append("<![CDATA["+ checkNullAndTrim(meta_keywords) +"]]>").append("</meta_keywords>\r\n");	
				valueXmlString.append("<meta_title>").append("<![CDATA["+ checkNullAndTrim(meta_title) +"]]>").append("</meta_title>\r\n");
				valueXmlString.append("<meta_desc>").append("<![CDATA["+ checkNullAndTrim(meta_desc) +"]]>").append("</meta_desc>\r\n");
				valueXmlString.append("<img_path>").append("<![CDATA["+ checkNullAndTrim(img_path) +"]]>").append("</img_path>\r\n");
				
				valueXmlString.append("<pur_lead_time>").append("<![CDATA["+ checkNullAndTrim(pur_lead_time) +"]]>").append("</pur_lead_time>\r\n");
				
				valueXmlString.append("<tax>").append("<![CDATA["+ checkNullAndTrim(tax) +"]]>").append("</tax>\r\n"); 
				valueXmlString.append("<tax_descr>").append("<![CDATA["+ checkNullAndTrim(tax_descr) +"]]>").append("</tax_descr>\r\n");
				
				valueXmlString.append("<language>").append("<![CDATA["+ checkNullAndTrim(language) +"]]>").append("</language>\r\n");
				valueXmlString.append("<language_desc>").append("<![CDATA["+ checkNullAndTrim(language_desc) +"]]>").append("</language_desc>\r\n");
				valueXmlString.append("<language_dtl>").append("<![CDATA["+ checkNullAndTrim(language_dtl) +"]]>").append("</language_dtl>\r\n");
			
				//Changed by Samadhan for brand,limited edition purchase stop start
				valueXmlString.append("<phy_attrib_24>").append("<![CDATA["+ phy_attrib_24 +"]]>").append("</phy_attrib_24>\r\n"); 
				valueXmlString.append("<usage_type>").append("<![CDATA["+ usage_type +"]]>").append("</usage_type>\r\n");
				
				valueXmlString.append("<brand_descr>").append("<![CDATA["+ brand_descr +"]]>").append("</brand_descr>\r\n"); 
				valueXmlString.append("<stop_purchase>").append("<![CDATA["+ stop_purchase +"]]>").append("</stop_purchase>\r\n");
				//Changed by Samadhan for brand,limited edition purchase stop end
		
				// Changed by Sneha on 07-07-2016, to edit the item parent description [Start]
				valueXmlString.append("<attr_value>").append("<![CDATA["+ attr_value +"]]>").append("</attr_value>\r\n");
				// Changed by Sneha on 07-07-2016, to edit the item parent description [End]
				
				//Changed by wasim on 02-08-2016 to add tax_chap field [START]
				valueXmlString.append("<tax_chap>").append("<![CDATA["+ taxChap +"]]>").append("</tax_chap>\r\n");
				//Changed by wasim on 02-08-2016 to add tax_chap field [END]
				
				//Changed by Sneha on 26-09-2016, to add new field trade mark [Start]
				valueXmlString.append("<trade_mark>").append("<![CDATA["+ checkNullAndTrim(tradeMark) +"]]>").append("</trade_mark>\r\n");
				//Changed by Sneha on 26-09-2016, to add new field trade mark [End]
				
				//Changed by Sneha on 27-10-2016, to add new customer item reference [Start]
				valueXmlString.append("<phy_attrib_4>").append("<![CDATA["+ checkNullAndTrim(custItemRef) +"]]>").append("</phy_attrib_4>\r\n");
				//Changed by Sneha on 27-10-2016, to add new customer item reference [End]
				
				//Changed by Sneha on 03-11-2016, to display size and color code [Start]
				valueXmlString.append("<phy_attrib_1>").append("<![CDATA["+ checkNullAndTrim(phy_attrib_1) +"]]>").append("</phy_attrib_1>\r\n");
				valueXmlString.append("<phy_attrib_2>").append("<![CDATA["+ checkNullAndTrim(phy_attrib_2) +"]]>").append("</phy_attrib_2>\r\n");
				valueXmlString.append("<phy_attrib_6>").append("<![CDATA["+ checkNullAndTrim(phy_attrib_6) +"]]>").append("</phy_attrib_6>\r\n");
				valueXmlString.append("<color_code_descr>").append("<![CDATA["+ checkNullAndTrim(color_code_descr) +"]]>").append("</color_code_descr>\r\n");
				//Changed by Sneha on 03-11-2016, to display size and color code [End]
			}
			else
			{
				//Changed and Commented By Santosh on 14-06-2016 :[START]
				/*ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				connDriver = null;*/
				conn = getConnection();
				//Changed and Commented By Santosh on 14-06-2016 :[END]
				
				String itemParentSelect = " SELECT ITEM_CODE, DESCR, SH_DESCR, ITEM_TYPE, " +
						                  " (SELECT DESCR FROM ITEM_TYPE WHERE ITEM_TYPE = ITEM.ITEM_TYPE) ITEM_TYPE_DESC, " +
						                  " ITEM_SER, (SELECT DESCR FROM ITEMSER WHERE ITEM_SER = ITEM.ITEM_SER) ITEM_SER_DESC, " +
						                  " GRP_CODE, (SELECT DESCR FROM GENCODES WHERE FLD_NAME = 'GRP_CODE' " +
						                  " AND MOD_NAME = 'W_DD_PRODUCTWIZ' AND FLD_VALUE = GRP_CODE) GRP_CODE_DESC, " +
						                  " LOC_CODE, (SELECT DESCR FROM LOCATION WHERE LOC_CODE = ITEM.LOC_CODE) LOC_CODE_DESC, " +
						                  " PHY_ATTRIB_18, PHY_ATTRIB_17, PHY_ATTRIB_19, PHY_ATTRIB_20, " +
						                  "  PHY_ATTRIB_21, PHY_ATTRIB_1, PHY_ATTRIB_2, PHY_ATTRIB_3, PUR_LEAD_TIME, LOC_TYPE, " +
						                  " UDF__STR1, (SELECT TRIM(DESCR) FROM ITM_ATTRIB_VAL WHERE ATTRIB_CODE='Tax' AND ATTRIB_ID = ITEM.UDF__STR1) TAX " +
						                  " ,PHY_ATTRIB_24,USAGE_TYPE " +//Added by samadhan on 23/12/2015 for brand and limited edition
						                  " ,TAX_CHAP "+ // Added by wasim on 02-08-2016 to get tax_chap
						                  " ,TRADE_MARK "+ // Added by Sneha on 27-09-2016 to get trade_mark
						                  " ,PHY_ATTRIB_4 "+ // Added by Sneha on 27-10-2016 to get customer item reference
						                  " ,PHY_ATTRIB_6, (SELECT A.DESCR FROM ITM_ATTRIB_VAL A WHERE A.ATTRIB_CODE='COLOR' AND ITEM.PHY_ATTRIB_2 = A.ATTRIB_ID) COLOR_DESC "+ // Added by Sneha on 03-11-2016 to get size description 
						                  " FROM ITEM  WHERE ITEM_CODE = '"+ itemCode +"'";
				
				pstmt = conn.prepareStatement(itemParentSelect);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					valueXmlString.append("<item_code>").append("<![CDATA["+ checkNullAndTrim(rs.getString(1)) +"]]>").append("</item_code>\r\n");
					valueXmlString.append("<descr>").append("<![CDATA["+ checkNullAndTrim(rs.getString(2)) +"]]>").append("</descr>\r\n");	
					
					valueXmlString.append("<item_type>").append("<![CDATA["+ checkNullAndTrim(rs.getString(4)) +"]]>").append("</item_type>\r\n");
					valueXmlString.append("<item_type_descr>").append("<![CDATA["+ checkNullAndTrim(rs.getString(5)) +"]]>").append("</item_type_descr>\r\n");
					
					valueXmlString.append("<item_ser>").append("<![CDATA["+ checkNullAndTrim(rs.getString(6)) +"]]>").append("</item_ser>\r\n");
					valueXmlString.append("<item_ser_descr>").append("<![CDATA["+ checkNullAndTrim(rs.getString(7)) +"]]>").append("</item_ser_descr>\r\n");
					
					valueXmlString.append("<grp_code>").append("<![CDATA["+ checkNullAndTrim(rs.getString(8)) +"]]>").append("</grp_code>\r\n");
					valueXmlString.append("<grp_code_descr>").append("<![CDATA["+ checkNullAndTrim(rs.getString(9)) +"]]>").append("</grp_code_descr>\r\n");
					
					valueXmlString.append("<loc_code>").append("<![CDATA["+ checkNullAndTrim(rs.getString(10)) +"]]>").append("</loc_code>\r\n");
					valueXmlString.append("<loc_type>").append("<![CDATA["+ checkNullAndTrim(rs.getString(21)) +"]]>").append("</loc_type>\r\n");
					valueXmlString.append("<loc_code_descr>").append("<![CDATA["+ checkNullAndTrim(rs.getString(11)) +"]]>").append("</loc_code_descr>\r\n");
					
					valueXmlString.append("<sh_descr>").append("<![CDATA["+ checkNullAndTrim(rs.getString(3)) +"]]>").append("</sh_descr>\r\n");
					valueXmlString.append("<long_descr>").append("<![CDATA["+ checkNullAndTrim(rs.getString(12)) +"]]>").append("</long_descr>\r\n");
					valueXmlString.append("<meta_keywords>").append("<![CDATA["+ checkNullAndTrim(rs.getString(15)) +"]]>").append("</meta_keywords>\r\n");	
					valueXmlString.append("<meta_title>").append("<![CDATA["+ checkNullAndTrim(rs.getString(16)) +"]]>").append("</meta_title>\r\n");
					valueXmlString.append("<meta_desc>").append("<![CDATA["+ checkNullAndTrim(rs.getString(14)) +"]]>").append("</meta_desc>\r\n");
					valueXmlString.append("<img_path>").append("<![CDATA["+ checkNullAndTrim(rs.getString(13)) +"]]>").append("</img_path>\r\n");
					
					valueXmlString.append("<pur_lead_time>").append("<![CDATA["+ checkNullAndTrim(rs.getString(20)) +"]]>").append("</pur_lead_time>\r\n");
					
					valueXmlString.append("<tax>").append("<![CDATA["+ checkNullAndTrim(rs.getString(22)) +"]]>").append("</tax>\r\n"); 
					valueXmlString.append("<tax_descr>").append("<![CDATA["+ checkNullAndTrim(rs.getString(23)) +"]]>").append("</tax_descr>\r\n");
					
					//Changed by Samadhan for brand,limited edition purchase stop start
					valueXmlString.append("<phy_attrib_24>").append("<![CDATA["+ checkNullAndTrim(rs.getString(24)) +"]]>").append("</phy_attrib_24>\r\n"); 
					valueXmlString.append("<usage_type>").append("<![CDATA["+ checkNullAndTrim(rs.getString(25)) +"]]>").append("</usage_type>\r\n");
					
					valueXmlString.append("<brand_descr>").append("<![CDATA["+ checkNullAndTrim(prodPos.getItemAttribVal("DESCR","BRAND",checkNullAndTrim(rs.getString(24)), conn)) +"]]>").append("</brand_descr>\r\n"); 
					valueXmlString.append("<stop_purchase>").append("<![CDATA["+ "" +"]]>").append("</stop_purchase>\r\n");
					//Changed by Samadhan for brand,limited edition purchase stop end
					
					//Changed by wasim on 02-08-2016 to add tax_chap field [START]
					valueXmlString.append("<tax_chap>").append("<![CDATA["+checkNullAndTrim(rs.getString("TAX_CHAP"))+"]]>").append("</tax_chap>\r\n");
					//Changed by wasim on 02-08-2016 to add tax_chap field [END]
					
					//Changed by Sneha on 26-09-2016, to add new field trade mark [Start]
					valueXmlString.append("<trade_mark>").append("<![CDATA["+ checkNullAndTrim(rs.getString("TRADE_MARK")) +"]]>").append("</trade_mark>\r\n");
					//Changed by Sneha on 26-09-2016, to add new field trade mark [End]
					
					//Changed by Sneha on 27-10-2016, to add new customer item reference [Start]
					valueXmlString.append("<phy_attrib_4>").append("<![CDATA["+ checkNullAndTrim(rs.getString("PHY_ATTRIB_4")) +"]]>").append("</phy_attrib_4>\r\n");
					//Changed by Sneha on 27-10-2016, to add new customer item reference [eND]
					
					/*//Changed by Sneha on 03-11-2016, to display size and color code [Start]
					valueXmlString.append("<phy_attrib_1>").append("<![CDATA["+ checkNullAndTrim(rs.getString("PHY_ATTRIB_1")) +"]]>").append("</phy_attrib_1>\r\n");
					valueXmlString.append("<phy_attrib_2>").append("<![CDATA["+ checkNullAndTrim(rs.getString("PHY_ATTRIB_2")) +"]]>").append("</phy_attrib_2>\r\n");
					valueXmlString.append("<phy_attrib_6>").append("<![CDATA["+ checkNullAndTrim(rs.getString("PHY_ATTRIB_6")) +"]]>").append("</phy_attrib_6>\r\n");
					valueXmlString.append("<color_code_descr>").append("<![CDATA["+ checkNullAndTrim(rs.getString("COLOR_DESC")) +"]]>").append("</color_code_descr>\r\n");
					//Changed by Sneha on 03-11-2016, to display size and color code [End]
*/				}		
				rs.close(); rs = null;
				pstmt.close(); pstmt = null;
					
				// Changed by Sneha on 07-07-2016, to edit the item parent description [Start]
				String attr_value = "";
				String itemDescr = " SELECT ATTR_VALUE FROM OBJ_ATTRIBUTE WHERE ITEM_ATTR_VAL = 'ITEM_CODE:'||'"+ itemCode +"' " +
						"AND LANGUAGES = 'EN' ";
				pstmt = conn.prepareStatement(itemDescr);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					attr_value = checkNullAndTrim(rs.getString(1));
				}
				rs.close(); rs = null;
				pstmt.close(); pstmt = null;
				valueXmlString.append("<attr_value>").append("<![CDATA["+ attr_value +"]]>").append("</attr_value>\r\n");
				// Changed by Sneha on 07-07-2016, to edit the item parent description [End]
				
				try
				{
					String languageSelect = " SELECT LANGUAGES, " +
							" (SELECT TRIM(DESCR) FROM GENCODES WHERE FLD_NAME='LANGUAGE' AND FLD_VALUE = LANGUAGES) LANG_DESCR, " +
							"  ATTR_VALUE, UDF_STR1, UDF_STR2 FROM OBJ_ATTRIBUTE " +
							"  WHERE ITEM_ATTR_VAL = 'ITEM_CODE:"+itemCode+"' " +
							"  AND OBJ_NAME = 'W_ITEM' " +
							"  AND LANGUAGES != 'EN'";
					pstmt = conn.prepareStatement(languageSelect);
					rs = pstmt.executeQuery();
					String languageDtl = "";
					String langDesc = "";
					String langCode = "";
					while(rs.next())
					{
						String langCodes = rs.getString(1);
						langCode += rs.getString(1) + ", ";
						langDesc += rs.getString(2) + ", ";
						String langCodeDescs = rs.getString(3);
						String langShDescs = rs.getString(4);
						String langLongDescs = rs.getString(5);
						
						languageDtl += "||" + langCodes + ":" + itemCode + ":" + langCodeDescs + ":" + langShDescs + ":" + langLongDescs;
					}
					String languageDtls = languageDtl.substring(2, languageDtl.length());
					langCode = langCode.trim().substring(0, langCode.length()-2);
					langDesc = langDesc.trim().substring(0, langDesc.length()-2);
					System.out.println("languageDtls = "+ languageDtls);
					System.out.println("langdesc = "+ langDesc +" langCode = "+ langCode);
					valueXmlString.append("<language>").append("<![CDATA["+ langDesc +"]]>").append("</language>\r\n");
					valueXmlString.append("<language_desc>").append("<![CDATA["+ langCode +"]]>").append("</language_desc>\r\n");
					valueXmlString.append("<language_dtl>").append("<![CDATA["+ languageDtls +"]]>").append("</language_dtl>\r\n");
				}
				catch(Exception ex)
				{
					ex.printStackTrace();
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new Exception(e);
		}	
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return valueXmlString.toString();
	}
	
	// Changed by Sneha on 30-03-2016, for login code [Start]
	//private String getSKUDetails( Document dom, String itemCode, Document dom1, Document dom2, String userId) throws Exception
	private String getSKUDetails( Document dom, Document dom1, Document dom2, String itemCode, String phy_attrib_4, String userId) throws Exception
	// Changed by Sneha on 30-03-2016, for login code [End]
	{
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		PreparedStatement pstmt1 = null ; 
		ResultSet rs1 = null;
		Connection conn = null;
		StringBuffer valueXmlString = new StringBuffer();
		String dateFormat = genericUtility.getApplDateFormat();//Added by parikshit on 07/07/15 [to set date format]
		int count = 1;
		HashMap<String, String> categoryMap = new HashMap<String, String>();
		//Changed and Commented By Santosh on 14-06-2016 :[START]
		/*ConnDriver connDriver = new ConnDriver();
		conn = connDriver.getConnectDB("DriverITM");
		connDriver = null;*/
		conn = getConnection();
		//Changed and Commented By Santosh on 14-06-2016 :[END]
		
		String taxChap = "", phy_attrib_6 = "", phy_attrib_2 = "";
		try
		{
	
				try
				{
					System.out.println("itemCode in getSKUDetails ============>>"+itemCode);
					String suppListDtl = " SELECT SUPP_CODE, (SELECT TRIM(SUPP_NAME) FROM SUPPLIER WHERE SUPP_CODE = SUPPLIERITEM.SUPP_CODE) SUPP_DESCR" +
							" FROM SUPPLIERITEM " +
							" WHERE ITEM_CODE IN (SELECT ITEM_CODE FROM ITEM WHERE ITEM_PARNT = '"+itemCode+"') "
									+ " GROUP BY SUPP_CODE";
					pstmt1 = conn.prepareStatement(suppListDtl);
					rs1 = pstmt1.executeQuery();
					String suppCodes = "";
					String suppdtls = "";
					if(rs1.next())
					{
						suppCodes += rs1.getString(1) + ",";
						suppdtls += rs1.getString(2) + ",";
					}
					//Added by parikshit on 07/07/15 [for check null value] start
					if ( suppCodes.trim().length() > 0 )
					{
						suppCodes = suppCodes.substring(0, suppCodes.length() - 1);
					}
					if ( suppdtls.trim().length() > 0 )
					{
						suppdtls = suppdtls.substring(0, suppdtls.length() - 1);
					}
					valueXmlString.append("<Detail3 domID='0' selected = 'N'>\r\n");
					// Changed by Sneha on 01-04-2016, for login code [Start]
					valueXmlString.append("<login_code>").append("<![CDATA["+ userId +"]]>").append("</login_code>\r\n");
					valueXmlString.append("<item_parent>").append("<![CDATA["+ itemCode +"]]>").append("</item_parent>\r\n");
					// Changed by Sneha on 01-04-2016, for login code [End]
					valueXmlString.append("<phy_attrib_4>").append("<![CDATA["+ phy_attrib_4 +"]]>").append("</phy_attrib_4>\r\n");
					valueXmlString.append("<supp_code>").append("<![CDATA["+ checkNullAndTrim(suppCodes) +"]]>").append("</supp_code>\r\n");
					valueXmlString.append("<supp_descr>").append("<![CDATA["+ checkNullAndTrim(suppdtls) +"]]>").append("</supp_descr>\r\n");
					//Added by parikshit on 07/07/15 [for check null value] end
					rs1.close(); rs1 = null;
					pstmt1.close(); pstmt1 = null;
				}
				catch(Exception ex)
				{
					ex.printStackTrace();
				}
				
				try
				{
					/*String siteListDtl = " SELECT DISTINCT SITEITEM.SITE_CODE, (SELECT TRIM(DESCR) FROM GENCODES WHERE FLD_NAME = 'SITE_PRICE' " +
							             " AND MOD_NAME = 'W_DD_PRODUCTWIZ' AND TRIM(FLD_VALUE) = TRIM(SITE.SITE_CODE))||':'||TRIM(SITE.DESCR)||':'||TRIM(FINENT.CURR_CODE) descr " +
							             " FROM SITEITEM, SITE LEFT OUTER JOIN FINENT ON SITE.FIN_ENTITY = FINENT.FIN_ENTITY WHERE SITE.SITE_CODE = SITEITEM.SITE_CODE " +
							             " AND SITEITEM.ITEM_CODE IN (SELECT ITEM_CODE FROM ITEM WHERE ITEM_PARNT = '"+itemCode+"') ";*/
					//Added by Parikshit Kumbhar on 25/06/2015 changed Query start
					String siteListDtl = " SELECT DISTINCT SITEITEM.SITE_CODE, (SELECT TRIM(GENCODES.DESCR) ||':'||TRIM(SITE.DESCR)||':'||TRIM(GENCODES.UDF_STR1) FROM GENCODES " +
							             " WHERE FLD_NAME = 'SITE_PRICE' AND GENCODES.MOD_NAME = 'W_DD_PRODUCTWIZ' AND TRIM(GENCODES.FLD_VALUE) = TRIM(SITE.SITE_CODE)) descr " +
							             " FROM SITEITEM, SITE	WHERE SITE.SITE_CODE = SITEITEM.SITE_CODE AND SITEITEM.ITEM_CODE IN (SELECT ITEM_CODE FROM ITEM WHERE ITEM_PARNT = '"+itemCode+"')";
					//Added by Parikshit Kumbhar on 25/06/2015 changed Query End 
					/*String siteListDtl = " SELECT SITE_CODE, (SELECT DESCR FROM SITE WHERE SITE_CODE = SITEITEM.SITE_CODE) SITE_DESCR " +
							" FROM SITEITEM " +
							" WHERE ITEM_CODE IN (SELECT ITEM_CODE FROM ITEM WHERE ITEM_PARNT = '"+itemCode+"') "
									+ " GROUP BY SITE_CODE";*/
					pstmt1 = conn.prepareStatement(siteListDtl);
					rs1 = pstmt1.executeQuery();
					String siteCodes = "";
					String siteDtls = "";
					while(rs1.next())
					{
						siteCodes += rs1.getString(1) + "," ;
						siteDtls += rs1.getString(2) + ",";
					}
					//Added by parikshit on 07/07/15 [for check null value] starts
					if ( siteCodes.trim().length() > 0 )
					{
						siteCodes = siteCodes.substring(0, siteCodes.length() - 1);
					}
					if ( siteDtls.trim().length() > 0 )
					{
						siteDtls = siteDtls.substring(0, siteDtls.length() - 1);
					}
					valueXmlString.append("<site_code>").append("<![CDATA["+ siteCodes +"]]>").append("</site_code>\r\n");
					valueXmlString.append("<site_descr>").append("<![CDATA["+ siteDtls +"]]>").append("</site_descr>\r\n");
					valueXmlString.append("<date_format>").append("<![CDATA["+ dateFormat +"]]>").append("</date_format>\r\n");//Added by Parikshit Kumbhar on 08/07/15 [to set date format]
					//Added by parikshit on 07/07/15 [for check null value] end
					rs1.close(); rs1 = null;
					pstmt1.close(); pstmt1 = null;
				}
				catch(Exception ex)
				{
					ex.printStackTrace();
				}
				valueXmlString.append("</Detail3>\r\n");
				
				NodeList parentNodeList = null;
				NodeList childNodeList = null;	
				Node parentNode = null;
				Node childNode = null;
				String childNodeName = null;
				int ctr=0;
				int childNodeListLength;
	
				parentNodeList = dom2.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				//Added by parikshit on 07/07/15 [variable declaration] start
				String loc_code = "";
				String loc_type = "";
				String loc_code_descr = "";
				//Added by parikshit on 07/07/15 [variable declaration] end
				
				String attr_value = "";
				
				if(parentNode != null)
				{
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					
					for(ctr = 0; ctr < childNodeListLength; ctr ++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						// Added by Parikshit Kumbhar on 08/07/2015 [to set location code] start
						if (childNodeName.equalsIgnoreCase("loc_code")) 
						{
							if ( childNode != null && childNode.getFirstChild() != null )
							{
								loc_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							}
							//System.out.println("******************** 1 loc_code ["+loc_code+"]");
						}
						else if (childNodeName.equalsIgnoreCase("loc_type")) 
						{
							if ( childNode != null && childNode.getFirstChild() != null )
							{
								loc_type = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							}
							//System.out.println("******************** 2 loc_type ["+loc_type);
						}
						else if (childNodeName.equalsIgnoreCase("loc_code_descr")) 
						{
							if ( childNode != null && childNode.getFirstChild() != null )
							{
								loc_code_descr = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							}
							//System.out.println("******************** 2 loc_code_descr ["+loc_code_descr);
						}
						// Added by Parikshit Kumbhar on 08/07/2015 [to location code] end
						
						// Changed by Sneha on 07-07-2016, to edit the item parent description [Start]
						else if (childNodeName.equalsIgnoreCase("attr_value")) 
						{
							if ( childNode != null && childNode.getFirstChild() != null )
							{
								attr_value = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							}
							//System.out.println("******************** attr_value ["+attr_value);
						}
						// Changed by Sneha on 07-07-2016, to edit the item parent description [End]
						
						// Changed by Sneha on 03-11-2016, for size and color code [Start]
						else if (childNodeName.equalsIgnoreCase("phy_attrib_6")) 
						{
							if ( childNode != null && childNode.getFirstChild() != null )
							{
								phy_attrib_6 = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							}
							//System.out.println("******************** phy_attrib_6 ["+phy_attrib_6);
						}
						else if (childNodeName.equalsIgnoreCase("phy_attrib_2")) 
						{
							if ( childNode != null && childNode.getFirstChild() != null )
							{
								phy_attrib_2 = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							}
							//System.out.println("******************** phy_attrib_2 ["+phy_attrib_2);
						}
						// Changed by Sneha on 03-11-2016, for size and color code [End]
						
					}
				}
				
				try
				{
					String categoryDtl = "SELECT ATTRIB_ID, TRIM(DESCR) FROM ITM_ATTRIB_VAL WHERE ATTRIB_CODE='CATEGORY'";
					pstmt1 = conn.prepareStatement(categoryDtl);
					rs1 = pstmt1.executeQuery();
					while(rs1.next())
					{
						categoryMap.put(rs1.getString(1), rs1.getString(2));
					}
					rs1.close(); rs1 = null;
					pstmt1.close(); pstmt1 = null;
				}
				catch(Exception ex)
				{
					ex.printStackTrace();
				}
				
				// Changed by Sneha on 03-11-2016, for size and color code [Start]
				System.out.println("******************** phy_attrib_6 ["+phy_attrib_6+"]");
				System.out.println("******************** phy_attrib_2 ["+phy_attrib_2+"]");
				
				String[] phyAttrib6 = phy_attrib_6.split(",");
				String[] phyAttrib2 = phy_attrib_2.split(",");
				System.out.println("phy_attrib_1 length inside itemChanged Case3 ---->> "+phyAttrib6.length);
				System.out.println("phy_attrib_2 length inside itemChanged Case3 ---->> "+phyAttrib2.length);
				
				for (int j = 0; j < phyAttrib6.length; j++)
				{
					for (int k = 0; k < phyAttrib2.length; k++)
					{
						String skuDetails = "SELECT ITEM_CODE, DESCR, LENGTH, WIDTH, HEIGHT, GROSS_WEIGHT, "
								+ " LOC_CODE, (SELECT DESCR FROM LOCATION WHERE LOC_CODE = ITEM.LOC_CODE) LOC_CODE_DESC, "
								+ " UDF__STR2, PHY_ATTRIB_23, LOC_TYPE, "
								+ " UDF__STR1, (SELECT TRIM(DESCR) FROM ITM_ATTRIB_VAL WHERE ATTRIB_CODE='Tax' AND TRIM(ATTRIB_ID) = ITEM.UDF__STR1) TAX, HSN_NO " 
								+ " ,USAGE_TYPE, CATALOG_NO "//Changed by samadhan for limited edition and stop purchase
								+ " ,TAX_CHAP "//Changed by wasim on 02-08-2016 for tax chapter
								+ " ,TRADE_MARK "//Changed by Sneha on 27-09-2016 for trade mark
								+ " ,PHY_ATTRIB_4, ACTIVE "//Changed by Sneha on 27-19-2016 for customer item reference
								+ " FROM ITEM "
								+ " WHERE ITEM_PARNT = '"+ itemCode +"'	";
						
						if(phyAttrib6[j] != "" && phyAttrib2[k] != "")
						{
							skuDetails = skuDetails.concat(" AND ITEM.PHY_ATTRIB_6 IN ('"+checkNullAndTrim(phyAttrib6[j])+"') AND ITEM.PHY_ATTRIB_2 IN ('"+checkNullAndTrim(phyAttrib2[k])+"')  ");
						}	
						else if(phyAttrib6[j] == "" && phyAttrib2[k] != "")
						{
							skuDetails = skuDetails.concat(" AND ITEM.PHY_ATTRIB_2 IN ('"+checkNullAndTrim(phyAttrib2[k])+"') ");
						}
						else if(phyAttrib6[j] != "" && phyAttrib2[k] == "")
						{
							skuDetails = skuDetails.concat(" AND ITEM.PHY_ATTRIB_6 IN ('"+checkNullAndTrim(phyAttrib6[j])+"') ");
						}
						// Changed by Sneha on 03-11-2016, for size and color code [End]
						
						pstmt = conn.prepareStatement( skuDetails );
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							valueXmlString.append("<Detail3 domID='"+ count +"' selected = 'Y'>\r\n");
							
							valueXmlString.append("<item_code>").append("<![CDATA["+ checkNullAndTrim(rs.getString(1)) +"]]>").append("</item_code>\r\n");
							valueXmlString.append("<descr>").append("<![CDATA["+ checkNullAndTrim(rs.getString(2)) +"]]>").append("</descr>\r\n");
							
							valueXmlString.append("<length>").append("<![CDATA["+ checkNullAndTrim(rs.getString(3)) +"]]>").append("</length>\r\n");	
							valueXmlString.append("<width>").append("<![CDATA["+ checkNullAndTrim(rs.getString(4)) +"]]>").append("</width>\r\n");
							valueXmlString.append("<height>").append("<![CDATA["+ checkNullAndTrim(rs.getString(5)) +"]]>").append("</height>\r\n");
							valueXmlString.append("<gross_weight>").append("<![CDATA["+ checkNullAndTrim(rs.getString(6)) +"]]>").append("</gross_weight>\r\n");
							
						    valueXmlString.append("<loc_code>").append("<![CDATA["+ checkNullAndTrim(loc_code) +"]]>").append("</loc_code>\r\n");
			     		    valueXmlString.append("<loc_type>").append("<![CDATA["+ checkNullAndTrim(loc_type) +"]]>").append("</loc_type>\r\n");
		  				    valueXmlString.append("<loc_code_descr>").append("<![CDATA["+ checkNullAndTrim(loc_code_descr) +"]]>").append("</loc_code_descr>\r\n");
							valueXmlString.append("<item_barcode>").append("<![CDATA["+ checkNullAndTrim(rs.getString(9)) +"]]>").append("</item_barcode>\r\n");
							
							valueXmlString.append("<item_category>").append("<![CDATA["+ checkNullAndTrim(rs.getString(10)) +"]]>").append("</item_category>\r\n");
							
							valueXmlString.append("<tax>").append("<![CDATA["+ checkNullAndTrim(rs.getString(12)) +"]]>").append("</tax>\r\n");
							valueXmlString.append("<tax_descr>").append("<![CDATA["+ checkNullAndTrim(rs.getString(13)) +"]]>").append("</tax_descr>\r\n");
							valueXmlString.append("<item_commodity>").append("<![CDATA["+ checkNullAndTrim(rs.getString(14)) +"]]>").append("</item_commodity>\r\n");
							
							//Changes by samadhan on 23/12/2015 for stop purchase and limited edition start
							valueXmlString.append("<usage_type>").append("<![CDATA["+ checkNullAndTrim(rs.getString(15)) +"]]>").append("</usage_type>\r\n");
							valueXmlString.append("<catalog_no>").append("<![CDATA["+ checkNullAndTrim(rs.getString(16)) +"]]>").append("</catalog_no>\r\n");
							//Changes by samadhan on 23/12/2015 for stop purchase and limited edition end
						
							// Changed by Sneha on 07-07-2016, to edit the item parent description [Start]
							valueXmlString.append("<attr_value>").append("<![CDATA["+ attr_value +"]]>").append("</attr_value>\r\n");
							// Changed by Sneha on 07-07-2016, to edit the item parent description [End]
							
							//Changed by wasim on 02-08-2016 for tax chapter [START]
							valueXmlString.append("<tax_chap>").append("<![CDATA["+ checkNullAndTrim(rs.getString("TAX_CHAP")) +"]]>").append("</tax_chap>\r\n");
							//Changed by wasim on 02-08-2016 for tax chapter [END]
							
							//Changed by Sneha on 26-09-2019, to add new field trade mark [Start]
							valueXmlString.append("<trade_mark>").append("<![CDATA["+ checkNullAndTrim(rs.getString("TRADE_MARK")) +"]]>").append("</trade_mark>\r\n");
							//Changed by Sneha on 26-09-2019, to add new field trade mark [End]
							
							//Changed by Sneha on 27-10-2016, to add new customer item reference [Start]
							valueXmlString.append("<phy_attrib_4>").append("<![CDATA["+ checkNullAndTrim(rs.getString("PHY_ATTRIB_4")) +"]]>").append("</phy_attrib_4>\r\n");
							valueXmlString.append("<active>").append("<![CDATA["+ checkNullAndTrim(rs.getString("ACTIVE")) +"]]>").append("</active>\r\n");
							//Changed by Sneha on 27-10-2016, to add new customer item reference [End]
							
							String categoryDescr = rs.getString(10);
							String[] categoryDescrs = categoryDescr.split(",");
							String categoryCode = "";
							for ( int i = 0; i < categoryDescrs.length; i++ )
							{
								categoryCode += getKeyFromValue(categoryMap,categoryDescrs[i].trim())+ ",";
							}
							if (categoryCode.length() > 1 )
							{
								categoryCode = categoryCode.substring(0, categoryCode.length() - 1);
							}
							valueXmlString.append("<item_category_descr>").append("<![CDATA["+ checkNullAndTrim(categoryCode) +"]]>").append("</item_category_descr>\r\n");
							
							try
							{
								String packSizeDtl = "SELECT SHIPPER_SIZE||':'||LENGTH||':'||WIDTH||':'||HEIGHT||':'||GROSS_WEIGHT||':'||NET_WEIGHT "
										+ " FROM ITEM_LOT_PACKSIZE "
										+ " WHERE ITEM_CODE ='"+ rs.getString(1)+"' ";
								pstmt1 = conn.prepareStatement(packSizeDtl);
								rs1 = pstmt1.executeQuery();
								if(rs1.next())
								{
									valueXmlString.append("<pack_size_descr>").append("<![CDATA["+ checkNullAndTrim(rs1.getString(1)) +"]]>").append("</pack_size_descr>\r\n");
								}
								else
								{
									valueXmlString.append("<pack_size_descr>").append("<![CDATA[]]>").append("</pack_size_descr>\r\n");
								}
								rs1.close(); rs1 = null;
								pstmt1.close(); pstmt1 = null;
							}
							catch(Exception ex)
							{
								ex.printStackTrace();
							}
							
							try
							{
								String attValues = "SELECT PHY_ATTRIB_1, "
										+ " (SELECT TRIM(DESCR) FROM ITM_ATTRIB_VAL WHERE ATTRIB_CODE= ITEM.PHY_ATTRIB_22 AND TRIM(ATTRIB_ID) = TRIM(ITEM.PHY_ATTRIB_1)) SIZE_DESCR, "
										+ " PHY_ATTRIB_2, "
										+ " (SELECT TRIM(DESCR) FROM ITM_ATTRIB_VAL WHERE ATTRIB_CODE='COLOR' AND TRIM(ATTRIB_ID) = TRIM(ITEM.PHY_ATTRIB_2)) COLOR_DESCR, "
										+ " PHY_ATTRIB_3, "
										+ " (SELECT TRIM(DESCR) FROM ITM_ATTRIB_VAL WHERE ATTRIB_CODE='DIMENSION' AND TRIM(ATTRIB_ID) = TRIM(ITEM.PHY_ATTRIB_3)) DIMENSION_DESCR "
										+ " FROM ITEM "
										+ " WHERE ITEM_CODE = '"+ rs.getString(1) +"' ";  //changed by parikshit on 24/07/15 [in query added ATTRIB_CODE= ITEM.PHY_ATTRIB_22]
								pstmt1 = conn.prepareStatement(attValues);
								rs1 = pstmt1.executeQuery();
								if(rs1.next())
								{
									valueXmlString.append("<phy_attrib_1>").append("<![CDATA["+ checkNullAndTrim(rs1.getString(1)) +"]]>").append("</phy_attrib_1>\r\n");	
									valueXmlString.append("<size_code_descr>").append("<![CDATA["+ checkNullAndTrim(rs1.getString(2)) +"]]>").append("</size_code_descr>\r\n");
									valueXmlString.append("<phy_attrib_2>").append("<![CDATA["+ checkNullAndTrim(rs1.getString(3)) +"]]>").append("</phy_attrib_2>\r\n");
									valueXmlString.append("<color_code_descr>").append("<![CDATA["+ checkNullAndTrim(rs1.getString(4)) +"]]>").append("</color_code_descr>\r\n");
									valueXmlString.append("<phy_attrib_3>").append("<![CDATA["+ checkNullAndTrim(rs1.getString(5)) +"]]>").append("</phy_attrib_3>\r\n");
									valueXmlString.append("<dimension_code_descr>").append("<![CDATA["+ checkNullAndTrim(rs1.getString(6)) +"]]>").append("</dimension_code_descr>\r\n");
								}
								else
								{
									valueXmlString.append("<phy_attrib_1>").append("<![CDATA[]]>").append("</phy_attrib_1>\r\n");	
									valueXmlString.append("<size_code_descr>").append("<![CDATA[]]>").append("</size_code_descr>\r\n");
									valueXmlString.append("<phy_attrib_2>").append("<![CDATA[]]>").append("</phy_attrib_2>\r\n");
									valueXmlString.append("<color_code_descr>").append("<![CDATA[]]>").append("</color_code_descr>\r\n");
									valueXmlString.append("<phy_attrib_3>").append("<![CDATA[]]>").append("</phy_attrib_3>\r\n");
									valueXmlString.append("<dimension_code_descr>").append("<![CDATA[]]>").append("</dimension_code_descr>\r\n");
								}
								rs1.close(); rs1 = null;
								pstmt1.close(); pstmt1 = null;
							}
							catch(Exception ex)
							{
								ex.printStackTrace();
							}
							
							try
							{
								String suppListDtl = "SELECT SUPP.SUPP_CODE, TRIM(SUPP.SUPP_NAME) SUPP_DESC, PRICELIST.PRICE_LIST, "
										+ " PRICELIST.RATE, PRICELIST.EFF_FROM, PRICELIST.VALID_UPTO, SUPP.curr_code "
										+ " FROM SUPPLIERITEM SUPPITM, SUPPLIER SUPP, PRICELIST "
										+ " WHERE SUPPITM.SUPP_CODE = SUPP.SUPP_CODE "
										+ " AND PRICELIST.PRICE_LIST = SUPP.PRICE_LIST "
										+ " AND SUPPITM.ITEM_CODE = PRICELIST.ITEM_CODE "
										+ " AND SUPPITM.ITEM_CODE = '"+ rs.getString(1) +"' " +
										" AND PRICELIST.SLAB_NO = (SELECT MAX(SLAB_NO) FROM PRICELIST P1 WHERE P1.ITEM_CODE = PRICELIST.ITEM_CODE " +
										" AND P1.PRICE_LIST = PRICELIST.PRICE_LIST)";
								pstmt1 = conn.prepareStatement(suppListDtl);
								rs1 = pstmt1.executeQuery();
								String suppDtl = "";
								if(rs1.next())
								{
									String fromDt = genericUtility.getValidDateString(
											rs1.getString(5), genericUtility.getDBDateFormat(), genericUtility.getDispDateFormat());
									String toDt = genericUtility.getValidDateString(
											rs1.getString(6), genericUtility.getDBDateFormat(), genericUtility.getDispDateFormat());
									
									suppDtl = ("1"+":"+ rs1.getString(1) +":"+ rs1.getString(3) +":"+ rs1.getString(4) +":"+ fromDt +":"+ toDt+":"+ rs1.getString(7) );
								}
								valueXmlString.append("<supp_item_dtl>").append("<![CDATA["+ suppDtl +"]]>").append("</supp_item_dtl>\r\n");
								
								rs1.close(); rs1 = null;
								pstmt1.close(); pstmt1 = null;
							}
							catch(Exception ex)
							{
								ex.printStackTrace();
							}
							
							try
							{
								String priceListDtl =  "SELECT TRIM(SITEITM.SITE_CODE), TRIM(SITE.DESCR), TRIM(GENCODES.DESCR), " + 
										" PRICELIST.RATE, PRICELIST.EFF_FROM, PRICELIST.VALID_UPTO, GENCODES.UDF_STR1" + //changed By parikshit GENCODES.UDF_STR1 instead of finentity on 29/06/2015
										" FROM SITEITEM SITEITM, SITE, GENCODES, PRICELIST " +
										" WHERE SITE.SITE_CODE = SITEITM.SITE_CODE " +
										" AND SITEITM.ITEM_CODE = PRICELIST.ITEM_CODE " +
										" AND GENCODES.FLD_NAME = 'SITE_PRICE' AND GENCODES.MOD_NAME = 'W_DD_PRODUCTWIZ' " +
										" AND TRIM(SITE.SITE_CODE) = TRIM(GENCODES.FLD_VALUE) AND TRIM(GENCODES.DESCR) = TRIM(PRICELIST.PRICE_LIST) " +
										" AND SITEITM.ITEM_CODE = '"+ rs.getString(1) +"' " +
										" AND PRICELIST.SLAB_NO = (SELECT MAX(P1.SLAB_NO) FROM PRICELIST P1 " +
										" WHERE P1.ITEM_CODE =  PRICELIST.ITEM_CODE AND P1.PRICE_LIST = PRICELIST.PRICE_LIST)";
								
								pstmt1 = conn.prepareStatement(priceListDtl);
								rs1 = pstmt1.executeQuery();
								String priceDtl = "";
								while(rs1.next())
								{
									String fromDt = genericUtility.getValidDateString(
											rs1.getString(5), genericUtility.getDBDateFormat(), genericUtility.getDispDateFormat());
									String toDt = genericUtility.getValidDateString(
											rs1.getString(6), genericUtility.getDBDateFormat(), genericUtility.getDispDateFormat());
									
									priceDtl += ("||1"+":"+ rs1.getString(1) +":"+ rs1.getString(3) +":"+ rs1.getString(4) +":0:"+ fromDt +":"+ toDt+":"+ rs1.getString(7));
								}
								if (priceDtl.length() > 2)
								{
									priceDtl = priceDtl.substring(2, priceDtl.length());
								}
								valueXmlString.append("<price_list_dtl>").append("<![CDATA["+ priceDtl +"]]>").append("</price_list_dtl>\r\n");
								
								rs1.close(); rs1 = null;
								pstmt1.close(); pstmt1 = null;
							}
							catch(Exception ex)
							{
								ex.printStackTrace();
							}
							
							try
							{
								String languageSelect = " SELECT LANGUAGES, " +
										" (SELECT TRIM(DESCR) FROM GENCODES WHERE FLD_NAME='LANGUAGE' AND FLD_VALUE = LANGUAGES) LANG_DESCR, " +
										"  ATTR_VALUE, UDF_STR1, UDF_STR2 FROM OBJ_ATTRIBUTE " +
										"  WHERE ITEM_ATTR_VAL = 'ITEM_CODE:"+rs.getString(1)+"' " +
										"  AND OBJ_NAME = 'W_ITEM' " +
										"  AND LANGUAGES != 'EN'";
								pstmt1 = conn.prepareStatement(languageSelect);
								rs1 = pstmt1.executeQuery();
								String languageDtl = "";
								String langDesc = "";
								String langCode = "";
								while(rs1.next())
								{
									String langCodes = rs1.getString(1);
									langCode += rs1.getString(1) + ", ";
									langDesc += rs1.getString(2) + ", ";
									String langCodeDescs = rs1.getString(3);
									String langShDescs = rs1.getString(4);
									String langLongDescs = rs1.getString(5);
									
									languageDtl += "||" + langCodes + ":" + rs.getString(1) + ":" + langCodeDescs + ":" + langShDescs + ":" + langLongDescs;
								}
								String languageDtls = languageDtl.substring(2, languageDtl.length());
								langCode = langCode.trim().substring(0, langCode.length()-2);
								langDesc = langDesc.trim().substring(0, langDesc.length()-2);
								System.out.println("languageDtls = "+ languageDtls);
								System.out.println("langdesc = "+ langDesc +" langCode = "+ langCode);
								
								valueXmlString.append("<language>").append("<![CDATA["+ langDesc +"]]>").append("</language>\r\n");
								valueXmlString.append("<language_desc>").append("<![CDATA["+ langCode +"]]>").append("</language_desc>\r\n");
								valueXmlString.append("<language_dtl>").append("<![CDATA["+ languageDtls +"]]>").append("</language_dtl>\r\n");
								rs1.close(); rs1 = null;
								pstmt1.close(); pstmt1 = null;
							}
							catch(Exception ex)
							{
								ex.printStackTrace();
							}
							
							valueXmlString.append("</Detail3>\r\n");
							count++;
						}
						// Changed by Sneha on 21-07-2016, for Closing the Open Cursor [Start]
						if( pstmt != null )
						{
						  pstmt.close();
						  pstmt = null;
						}
						if ( rs != null )
						{
						  rs.close();
						  rs = null;
						}
						// Changed by Sneha on 21-07-2016, for Closing the Open Cursor [End]
					}
					
				}	//  Changed by Sneha on 03-11-2016, for size and color code 
	}		
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new Exception(e);
		}
		finally
		{
			try
			{
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt1 != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		
		return valueXmlString.toString();
	}
	
	/**
	 * Check string is null
	 * @param input
	 * @return
	 */
	private static String checkNullAndTrim(String input)
	{
		if (input == null)
		{
			input = "";
		}
		return input.trim();
	}
	
	/**
	 * Checking previous document exist or not
	 */
	private boolean preDomExists(Document dom, String currentFormNo) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node childNode = null;
		boolean selected = false;

		try
		{
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			if ( parentList.item(0) != null )
			{
				childList = parentList.item(0).getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))					
					{
						System.out.println("Column found!!!>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>" + childNode.getNodeName());
						selected = true; 
						break;
					}
				}
			}
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :DDProductWizEditEJB :preDomExists :==>\n"+e.getMessage());
			throw new ITMException(e);
		}

		return selected;
	}
	
	private String getPrevFormValues( Document dom, String currentFormNo ) throws ITMException
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			System.out.println("currentFormNo ["+currentFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			System.out.println("parentlistlength["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{							
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))					
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						System.out.println("columnValue["+columnValue+"]");
						elementAttr = (Element)parentNode;
						if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
						{
							elementAttr.setAttribute( "domID" , "1" );
							elementAttr.setAttribute( "selected" , "Y" );
						}
						Node importedNode = chgPreDom.importNode( parentNode, true );
						chgPreDom.getDocumentElement().appendChild( importedNode );
						break;
					}
				}
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :DDProductWizEditEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;
	}
	
	private static Object getKeyFromValue(Map hm, Object value) 
	{
		for (Object o : hm.keySet()) 
		{
			if (hm.get(o).equals(value)) 
			{
				return o;
			}
		}
		return null;
	}
}
