package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.utility.UserInfoBean;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class ThreeWayMatchCond {
	public String confirm(String tranId, String empCodeAprv, String xmlDataAll, String processId, String keyFlag) throws RemoteException, ITMException {
		System.out.println("confirm workflow invocation");
		System.out.println("Parameters ::: tranId[" + tranId + "], empCodeAprv[" + empCodeAprv + "], xmlDataAll[" + xmlDataAll + "],processId["+processId+"],keyFlag["+keyFlag+"]");
		String loginCode = "";
		String loginSiteCode = "";
		String loginEmpCode = "";
		String xtraParams = "loginCode=" + loginCode + "~~" + "loginSiteCode=" + loginSiteCode + "~~" + "loginEmpCode=" + loginEmpCode;
		String retString = "";

		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		ConnDriver connDriver = new ConnDriver();
		Timestamp timestamp = null;
		int resultCnt = 0;
		
		try {
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			conn.setAutoCommit(false);
			timestamp = new Timestamp(System.currentTimeMillis());

			empCodeAprv = empCodeAprv == null ? "" : empCodeAprv.trim();
			
			if("UPDATEPAY3WAYSTAT".equalsIgnoreCase(keyFlag))
			{
				sql = "update Pay_3way_Stat set Status = '3', Status_Date = ? where Tran_Id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, timestamp);
				pstmt.setString(2, tranId);
				resultCnt += pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				System.out.println("Pay_3way_Stat Update Successfully:"+resultCnt);
				if(resultCnt > 0) {
					conn.commit();
					retString = "Y";
				} else {
					conn.rollback();
					retString = "N";
				}
			}
			else if("UPDATESUPPLIERBILL".equalsIgnoreCase(keyFlag))
			{
				String purcOrder = "", tranIdRcp = "", tranIdVch = "";
				boolean updateFlag = false;
				
				sql = "select tab1.cnt, coalesce(tab2.cnt,0) cnt2,tab1.purc_order, tab1.tran_id__rcp, tab1.tran_id__vch "
					+ "from ( "
					+ "  select count(a1.status) cnt,a1.purc_order,a1.tran_id__rcp,a1.tran_id__vch "
					+ "  from pay_3way_stat a1 "
					+ "  left outer join pay_3way_stat a2 on a1.purc_order = a2.purc_order and a1.tran_id__rcp = a2.tran_id__rcp and a1.tran_id__vch = a2.tran_id__vch "
					+ "  where a1.tran_id = ? "
					+ "  group by a1.tran_id,a1.purc_order,a1.tran_id__rcp,a1.tran_id__vch "
					+ ") tab1 "
					+ "left outer join ( "
					+ "  select count(a1.status) cnt,a1.purc_order,a1.tran_id__rcp,a1.tran_id__vch "
					+ "  from pay_3way_stat a1 "
					+ "  left outer join pay_3way_stat a2 on a1.purc_order = a2.purc_order and a1.tran_id__rcp = a2.tran_id__rcp and a1.tran_id__vch = a2.tran_id__vch "
					+ "  where a1.tran_id = ? and a2.status = '3' "
					+ "  group by a1.tran_id,a1.purc_order,a1.tran_id__rcp,a1.tran_id__vch "
					+ ") tab2 on tab1.purc_order = tab2.purc_order and tab1.tran_id__rcp = tab2.tran_id__rcp and tab1.tran_id__vch = tab2.tran_id__vch";
			
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				pstmt.setString(2, tranId);
				rs = pstmt.executeQuery();
				if (rs.next()) 
				{
					 if(rs.getInt("cnt") == rs.getInt("cnt2"))
					 {
						 updateFlag = true;
						 purcOrder = rs.getString("purc_order");
						 tranIdRcp = rs.getString("tran_id__rcp");
						 tranIdVch = rs.getString("tran_id__vch");
					 }
					 
				}
				System.out.println("updateFlag["+updateFlag+"],purcOrder["+purcOrder+"],tranIdRcp["+tranIdRcp+"],tranIdVch["+tranIdVch+"]");

				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				if(updateFlag)
				{
					sql = "update supplier_bill set match_status = '3' where porder_no = ? and voucher_no = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, purcOrder);
					pstmt.setString(2, tranIdVch);
					resultCnt += pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
					System.out.println("Supplier_Bill Update Successfully:"+resultCnt);
					if(resultCnt > 0) {
						conn.commit();
						retString = "Y";
					} else {
						conn.rollback();
						retString = "N";
					}
				}
			}
			else if("LEVEL1".equalsIgnoreCase(keyFlag) || "LEVEL2".equalsIgnoreCase(keyFlag) || "LEVEL3".equalsIgnoreCase(keyFlag) || "LEVEL_HOD".equalsIgnoreCase(keyFlag)|| "LEVEL_HHODS".equalsIgnoreCase(keyFlag))
			{
				String signStatus = "", userCode = "", processInfo[] = null, activityId = "", roleCode = "";
			
				if("LEVEL1".equalsIgnoreCase(keyFlag)) {
					activityId = "SIGN_TRANS_FL"; roleCode = "ROL01";
				}
				else if("LEVEL2".equalsIgnoreCase(keyFlag)) {
					activityId = "SIGN_TRANS_SL"; roleCode = "ROL02";
				}
				
				else if("LEVEL3".equalsIgnoreCase(keyFlag)) {
					activityId = "SIGN_TRANS_TL"; roleCode = "ROL03";
				}
				
				else if("LEVEL_HOD".equalsIgnoreCase(keyFlag)) {
					activityId = "SIGN_TRANS_HL"; roleCode = "ESCHOD";
				}
				else if("LEVEL_HHODS".equalsIgnoreCase(keyFlag)) {
					activityId = "SIGN_TRANS_HHL"; roleCode = "ESCHODHODS";
				}
				
				sql = "select SIGN_STATUS from OBJ_SIGN_TRANS "
						+ "WHERE ltrim(rtrim(REF_SER)) = 'S-MCH' AND ltrim(rtrim(REF_ID)) = ? AND ltrim(rtrim(ROLE_CODE__SIGN)) = ? "
						+ "AND SIGN_STATUS = 'U'";
						
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				pstmt.setString(2, roleCode);
				rs = pstmt.executeQuery();
				if (rs.next()) {
					signStatus = rs.getString("SIGN_STATUS");
				}
				System.out.println("signStatus = " + signStatus);

				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if("U".equalsIgnoreCase(signStatus)){
					sql = "select code from users where emp_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCodeAprv);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						userCode = rs.getString("code");
					}
					System.out.println("userCode = " + userCode);

					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					sql = "UPDATE OBJ_SIGN_TRANS "
							+ "SET SIGN_DATE = sysdate, USER_ID__SIGN = ?, SIGN_REMARKS = 'HR_SPAN is over', SIGN_STATUS = 'V', EMP_CODE = ? "
							+ "WHERE ltrim(rtrim(REF_SER)) = 'S-MCH' AND ltrim(rtrim(REF_ID)) = ? AND ltrim(rtrim(ROLE_CODE__SIGN)) = ? "
							+ "AND SIGN_STATUS = 'U'";
							
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, userCode);
					pstmt.setString(2, empCodeAprv);
					pstmt.setString(3, tranId);
					pstmt.setString(4, roleCode);
					resultCnt += pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
					System.out.println("Update Successfully:"+resultCnt);
					
					processInfo = processId.split(":");
					sql = "UPDATE WF_PRC_STATUS "
							+ "SET STATUS_DATE = sysdate, PROCESS_STATUS = 4, ERR_STATUS = '0', "
							+ "STATUS_REMARKS='Escalated -> Completing :"+processId+" Invoked :"+processId+"' "
							+ "WHERE ltrim(rtrim(REF_SER)) = 'S-MCH' AND REF_ID = ? AND PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND PROCESS_STATUS != 3";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					pstmt.setString(2, processInfo[0]);
					pstmt.setString(3, processInfo[1]);
					pstmt.setString(4, activityId);
					resultCnt += pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
					System.out.println("Update Successfully:"+resultCnt);
					if(resultCnt > 1) {
						conn.commit();
						retString = "Y";
					} else {
						conn.rollback();
					}
				} else {
					retString = "N";
				}
			}
			
		} catch (Exception e) {
			try {
				conn.rollback();
			} catch (SQLException e1) {
				e1.printStackTrace();
			}
			e.printStackTrace();
			System.out.println("Exeption occured");

			throw new ITMException(e);
		} finally {
			if (conn != null) {
				try {
					conn.commit();
					conn.close();
					conn = null;
				} catch (SQLException e) {
					e.printStackTrace();
					System.out.println("Exeption in Finaly");
				}
			}
		}

		return retString;
	}
	
}
