package ibase.webitm.ejb.fin;

import java.io.File;
import java.io.*;

import ibase.utility.CommonConstants;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.utility.ITMException;

import javax.naming.InitialContext;

public class ReconcilePopHelpBean {
	
	InitialContext ctx = null;
	InterCompReconcileProcessLocal reconcileObj=null;
	String xmlStringPopHelp="";


public String getPophelp(String sundryType){
	
	try{
		System.out.println("In getPophelp222--->>["+sundryType+"]");
		ctx = new InitialContext();
		reconcileObj = (InterCompReconcileProcessLocal)ctx.lookup("ibase/InterCompReconcileProcess/local");
		
		xmlStringPopHelp=reconcileObj.getValuesForPopHelp(sundryType);
		//System.out.println("xmlStringPopHelp=====>>["+xmlStringPopHelp+"]");
		String xslFileName = getXSLFileName( "reconcilepop.xsl" );
		reconcileObj=null;
//		xmlStringPopHelp = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, xmlStringPopHelp, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		
	}
	catch(Exception e){
		e.printStackTrace();
	}
	return xmlStringPopHelp;
}


public String getPophelp(String sundryType,String keyString){
	
	try{
		System.out.println("In getPophelp--->>["+sundryType+"]");
		System.out.println("keyString :"+keyString);
		ctx = new InitialContext();
		reconcileObj = (InterCompReconcileProcessLocal)ctx.lookup("ibase/InterCompReconcileProcess/local");
		
		xmlStringPopHelp=reconcileObj.getValuesForPopHelp(sundryType,keyString);
		//System.out.println("xmlStringPopHelp=====>>["+xmlStringPopHelp+"]");
		String xslFileName = getXSLFileName( "reconcilepop.xsl" );
		reconcileObj=null;
//		xmlStringPopHelp = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, xmlStringPopHelp, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		
	}
	catch(Exception e){
		e.printStackTrace();
	}
	return xmlStringPopHelp;
}



public String getPophelpForBankCode(String bankCode,String keyString){
	
	try{
		System.out.println("In getPophelp--->>["+bankCode+"]");
		System.out.println("keyString :"+keyString);
		ctx = new InitialContext();
		reconcileObj = (InterCompReconcileProcessLocal)ctx.lookup("ibase/BankRecoWizICLocal/local");
		
		xmlStringPopHelp=reconcileObj.getValuesForPopHelp(bankCode,keyString);
		//System.out.println("xmlStringPopHelp=====>>["+xmlStringPopHelp+"]");
		String xslFileName = getXSLFileName( "BankReconcilepop.xsl" );
		reconcileObj=null;
//		xmlStringPopHelp = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, xmlStringPopHelp, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		
	}
	catch(Exception e){
		e.printStackTrace();
	}
	return xmlStringPopHelp;
}

private String getXSLFileName( String xslFileName )throws ITMException
{   
	String retFileName = null;
	try
	{
		String defaultPath = null;
		if( CommonConstants.APPLICATION_CONTEXT != null )
		{
			defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
		}
		else
		{
			defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
		}
		File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
		if ( !xslPath.exists() )
		{
			xslPath.mkdir();
		}
		System.out.println( " xslPath1111 [" + xslPath +"] xslFileName ["+xslFileName +"]");
		File xslFile = new File(xslPath , xslFileName);
		if( xslFile.exists() )
		{
			retFileName = xslFile.getAbsolutePath();
			System.out.println("File found111--->>"+retFileName);
		}
		else
		{
			throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
		}
	}
	catch (Exception e)
	{
		throw new ITMException(e);
	}
	return retFileName;
}
public static String getXSL(String xslFileName) throws IOException, ITMException
{
	String retFileName = null; //"/home/base/Software/jboss-5.1.0.GA/server/default/deploy/ibase.ear/ibase.war/webitm/xsl/Standard/WIZARD/reconcilepop.xsl";
	String xslString=null;
	try
	{
		String defaultPath = null;
		
		if( CommonConstants.APPLICATION_CONTEXT != null )
		{
			defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
		}
		else
		{
			defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
		}
		File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
		if ( !xslPath.exists() )
		{
			xslPath.mkdir();
		}
		System.out.println( " xslPath1111 [" + xslPath +"] xslFileName ["+xslFileName +"]");
		File xslFile = new File(xslPath , xslFileName);
		if( xslFile.exists() )
		{
			retFileName = xslFile.getAbsolutePath();
			System.out.println("File found111--->>"+retFileName);
			xslString =readFile(retFileName);
		}
		else
		{
			throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
		}
		System.out.println("File found111--->>"+retFileName);
		xslString =readFile(retFileName);
	}
	catch (Exception e)
	{
		throw new ITMException(e);
	}
	return xslString;
}
private static String readFile(String xslFilePath) throws IOException
{
	String xslString ="";
	StringBuilder xslStringBuilder = new StringBuilder();;
	FileInputStream fStream = null;
	DataInputStream dInputStream = null;
	BufferedReader buffReader = null ;
	
	try 
	{
		File file = new File(xslFilePath);
		fStream = new FileInputStream(file);
		dInputStream = new DataInputStream(fStream);
		buffReader = new BufferedReader(	new InputStreamReader(dInputStream));
		
		while ((xslString = buffReader.readLine()) != null) 
		{
			xslStringBuilder.append(xslString);
		}
	} 
	catch (Exception e) 
	{
		e.printStackTrace();
	}
	finally
	{
		if(fStream != null)
		{
			fStream.close();
		}
		if(dInputStream != null)
		{
			dInputStream.close();
		}
		if(buffReader != null)
		{
			buffReader.close();
		}
		
	}
	return xslStringBuilder.toString();
}
	

}
