/* Developed By VALLABH KADAM
 * Date : 07-MAR-2017
 * Component Name : EmpStatusDateChgPrc
 */
package ibase.webitm.ejb.adm;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.adm.adv.EmpMaritalStatusConfLocal;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import org.w3c.dom.Document;

/**
 * Session Bean implementation class EmpStatusDateChgPrc
 */
@Stateless
public class EmpStatusDateChgPrc extends ProcessEJB implements EmpStatusDateChgPrcLocal, EmpStatusDateChgPrcRemote 
{
	E12GenericUtility genericUtility=new E12GenericUtility();
	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException, ITMException
	{
		String retString = "";
		Document detailDom = null;
		Document headerDom = null;
//		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{	
			if(xmlString != null && xmlString.trim().length() != 0)
			{
				headerDom = genericUtility.parseString(xmlString); 
				System.out.println("headerDom" + headerDom);
			}
			if(xmlString2 != null && xmlString2.trim().length() != 0)
			{
				detailDom = genericUtility.parseString(xmlString2); 
				System.out.println("detailDom" + detailDom);
			}
			retString = process(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception :EmpStatusDateChgPrc :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	
	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException, ITMException
	{
		String returnString = "",confirm="",empCode="",tranDate="",sql="",statusDateStr="",chgTerm="",chgUser="";
		Timestamp tranDateTimestamp=null,statusDateTimestamp=null,chgDate=null;
		boolean isError = false;
		Connection connection = null;
		ConnDriver connDriver = null;
		AppConnectParm appConnect = null;
		InitialContext initialCtx = null;
		EmpMaritalStatusConfLocal empMaritalStatusConf = null;
		ITMDBAccessLocal itmDBAccess = null;
		
		PreparedStatement pstmt=null;
		ResultSet rs=null;		
		int updCnt=0,updateCnt=0;
		
		try
		{
			connDriver = new ConnDriver();
			connection = connDriver.getConnectDB("DriverITM");
			connection.setAutoCommit(false);
			appConnect = new AppConnectParm();
			initialCtx = new InitialContext(appConnect.getProperty());
			itmDBAccess = (ITMDBAccessLocal)initialCtx.lookup("ibase/ITMDBAccessEJB/local");
			empCode = checkNull(genericUtility.getColumnValue("emp_code", headerDom));
			tranDate = checkNull(genericUtility.getColumnValue("tran_date", headerDom));
			System.out.println("@V@ VALLABH empCode :- ["+empCode+"]");
			System.out.println("@V@ VALLABH tranDate :- ["+tranDate+"]");
			tranDateTimestamp = Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDate, genericUtility.getApplDateFormat()
	        		,genericUtility.getDBDateFormat()));
			statusDateStr = genericUtility.getColumnValue("status_date", headerDom);
			System.out.println("statusDateStr from Dom::"+statusDateStr);
			statusDateTimestamp = java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(statusDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()));
			System.out.println("tranDate after parsing::"+tranDate);
			
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDateStr = sdf.format(currentDate.getTime());
			
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			
			chgDate=Timestamp.valueOf(genericUtility.getValidDateString(sysDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())
					+ " 00:00:00.0");
			
//			sql = "SELECT CONFIRM FROM EMP_MARITALCHG WHERE EMP_CODE = ? AND TRAN_DATE = ?";
//			pstmt = connection.prepareStatement(sql);
//			pstmt.setString(1, empCode);
//			pstmt.setTimestamp(2, tranDateTimestamp);
//			rs = pstmt.executeQuery();
//			if(rs.next())
//			{
//				confirm = checkNull(rs.getString("CONFIRM"));				
//			}
//			pstmt.close();
//			pstmt=null;
//			rs.close();
//			rs=null;
//			System.out.println("@V@ VALLABH confirm :- ["+confirm+"]");
//			if(!"X".equalsIgnoreCase(confirm))
//			{
//				empMaritalStatusConf = (EmpMaritalStatusConfLocal)initialCtx.lookup("ibase/EmpMaritalStatusConf/local");
//				returnString = checkNull(empMaritalStatusConf.actionHandler("", headerDom, detailDom, xtraParams, "N", connection));
//				System.out.println("EmpStatusDateChgPrc returnString ::[" + returnString + "]");
//			}
//			else
//			{
//				returnString = itmDBAccess.getErrorString("", "VTALRDCACL", "", "", connection);
//				return returnString;
//			}
			sql="update EMP_MARITALCHG set status_date=?,chg_date=?,chg_user=?,chg_term=? where emp_code=? and tran_date=?";
			pstmt=connection.prepareStatement(sql);
			pstmt.setTimestamp(1, statusDateTimestamp);
			pstmt.setTimestamp(2, chgDate);
			pstmt.setString(3, chgUser);
			pstmt.setString(4, chgTerm);
			pstmt.setString(5,empCode);
			pstmt.setTimestamp(6,tranDateTimestamp);
			updCnt=pstmt.executeUpdate();
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("@V@ EMP_MARITALCHG Update count :- ["+updCnt+"]");
			
			sql="Update employee set M_STATUS_DATE=?,chg_date=?,chg_user=?,chg_term=? where emp_code=?";
			pstmt=connection.prepareStatement(sql);
			pstmt.setTimestamp(1, statusDateTimestamp);
			pstmt.setTimestamp(2, chgDate);
			pstmt.setString(3, chgUser);
			pstmt.setString(4, chgTerm);
			pstmt.setString(5, empCode);
			updateCnt=pstmt.executeUpdate();
			System.out.println("@V@ Employee Update count :- ["+updateCnt+"]");
						
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(updCnt<=0 && updateCnt<=0)
			{
				returnString = itmDBAccess.getErrorString("", "VTMARPRFL", "", "", connection);
			}
			if(returnString.length() > 0)
			{
				isError = true;
				System.out.println("EmpStatusDateChgPrc isError ::[" + isError + "]");
			}
			else
			{
				returnString = itmDBAccess.getErrorString("", "VTMARPRSCS", "", "", connection);
			}
			
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception :EmpStatusDateChgPrc :process(String xmlString2, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally
		{
			System.out.println("Closing Connection....");
			try
			{
				if(isError)
				{
					connection.rollback();
					System.out.println("EmpStatusDateChgPrc connection rollback");
				}
				else
				{
					connection.commit();
					System.out.println("EmpStatusDateChgPrc connection committed");
				}
				if(connection != null)
				{
					connection.close();
					connection = null;
				}
			}
			catch(Exception e)
			{
				returnString = e.getMessage();
				e.printStackTrace();
			}
		}
		System.out.println("errString...:: "+returnString);
		return returnString;
	}
	
	private String checkNull(String input)
	{
		if (input == null || ("null").equalsIgnoreCase(input.trim()))
		{
			input = "";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
}
