/* Developed By Vallabh Kadam
 * Date : 30-NOV-2016
 * Component Name : EmpStatusDateChgIC
 */
package ibase.webitm.ejb.adm;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.adm.adv.EmpMaritalStatusConfLocal;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class EmpStatusDateChgIC extends ValidatorEJB implements EmpStatusDateChgICLocal , EmpStatusDateChgICRemote
{
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			System.out.println("EmpMaritalStatusConfIC:wfValData value of xmlString ["+xmlString+"]");
			System.out.println("EmpMaritalStatusConfIC:wfValData value of xmlString ["+xmlString1+"]");
			System.out.println("EmpMaritalStatusConfIC:wfValData value of xmlString ["+xmlString2+"]");

			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}

			errString = checkNull(wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams));
			System.out.println ("EmpMaritalStatusConfIC:ErrString: " + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception: EmpMaritalStatusConfIC: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println ("Returning from EmpMaritalStatusConfIC wfValData");
		return errString;  
	}

	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		java.sql.Timestamp tranDate = null,tranDateTemp=null,confDtTimestamp=null,confDate=null;
		NodeList parentList = null , childList = null;
		Node parentNode = null , childNode = null ;
		int noOfChilds = 0 , counterChild = 0;
		String sql = "", empCode = "", confirm = "", errString = "", tranDateStr = "",statusDateStr="",cnfStat="";
		String childNodeName = "";
		int currentFormNo = 0;
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		E12GenericUtility genericUtility = new E12GenericUtility();
		boolean latestTran=true;
		
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(counterChild = 0; counterChild < noOfChilds; counterChild++)
			{
				childNode = childList.item(counterChild);
				childNodeName = childNode.getNodeName();
				switch(currentFormNo)
				{
					case 1:
					System.out.println("In case 1 ::::::::");
					empCode =  genericUtility.getColumnValue("emp_code", dom);
					System.out.println("empCode from Dom::"+empCode);
					tranDateStr = genericUtility.getColumnValue("tran_date", dom);
					statusDateStr = genericUtility.getColumnValue("status_date", dom);
					System.out.println("tranDateStr from Dom::"+tranDateStr);
					tranDate = java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()));
					System.out.println("tranDate after parsing::"+tranDate);
									
					if(statusDateStr==null || statusDateStr.trim().length()==0)
					{
						errString = itmDBAccessEJB.getErrorString("","VTSTDTBLNK","","",conn);
						return errString;
					}
					
					/**
					 * Select all tran date
					 * */
					sql = "SELECT CONF_DATE FROM EMP_MARITALCHG WHERE EMP_CODE = ? and TRAN_DATE=?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					pstmt.setTimestamp(2, tranDate);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						confDtTimestamp = rs.getTimestamp("CONF_DATE");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					
					ArrayList<Timestamp> confDateAll=new ArrayList<Timestamp>();
					sql = "SELECT CASE WHEN CONFIRM IS NULL THEN 'N' ELSE CONFIRM END AS CONFIRM_STAT,CONF_DATE" +
							" FROM EMP_MARITALCHG WHERE EMP_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						cnfStat = rs.getString("CONFIRM_STAT");
						confDate = rs.getTimestamp("CONF_DATE");
						if("Y".equalsIgnoreCase(cnfStat))
						{
							confDateAll.add(confDate);
						}
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					
					if(confDtTimestamp!=null)
					{
						for(Timestamp tempDate:confDateAll)
						{
							if(confDtTimestamp.before(tempDate))
							{
								latestTran=false;
								break;
							}
						}
					}
					
					/**
					 * Check Transaction is latest
					 * */
					if(!latestTran)
					{
						System.out.println("@V@ Transaction is OLD ..");
						errString = itmDBAccessEJB.getErrorString("", "VTOLDTRAN", "", "", conn);
						return errString;
					}
					
					sql = "SELECT CASE WHEN CONFIRM IS NULL THEN 'N' ELSE CONFIRM END AS CONFIRM" +
							" FROM EMP_MARITALCHG WHERE EMP_CODE = ? AND TRAN_DATE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					pstmt.setTimestamp(2, tranDate);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						confirm = checkNull(rs.getString("CONFIRM"));				
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					System.out.println("@V@ VALLABH confirm :- ["+confirm+"]");
					
					if("N".equalsIgnoreCase(confirm))
					{
						System.out.println("@V@ Un confirm transaction...");
						errString = itmDBAccessEJB.getErrorString("", "VTUNCFTNS", "", "", conn);
						return errString;
					}					
					if("X".equalsIgnoreCase(confirm))
					{
						errString = itmDBAccessEJB.getErrorString("", "VTALRDCACL", "", "", conn);
						return errString;
					}
				}
			}
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				close(pstmt, rs);
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e)
			{
				e.printStackTrace();

			}
		}
		return errString;
	}


	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{

		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			System.out.println("EmpMaritalStatusConfIC:itemChanged value of xmlString ["+xmlString+"]");
			System.out.println("EmpMaritalStatusConfIC:itemChanged value of xmlString ["+xmlString1+"]");
			System.out.println("EmpMaritalStatusConfIC:itemChanged value of xmlString ["+xmlString2+"]");
			System.out.println("objContext ..:: ["+objContext+"]");
			System.out.println("currentColumn ..:: ["+currentColumn+"]");
			System.out.println("editFlag ..:: ["+editFlag+"]");

			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("EmpMaritalStatusConfIC::ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("EmpMaritalStatusConfIC::Exception :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		System.out.println ("EmpMaritalStatusConfIC::returning from itemChanged");
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		int currentFormNo = 0;

		StringBuffer valueXmlString = null;
		String objNameDefault = "" ;
		String sql = "", empCode = "", oldStatus = "", newStatus = "", empName = "", confirm = "", tranDateStr = "", statusDateStr = "";
		double amount = 0.0d;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Timestamp tranDate = null;
//		Date statusDate = null;
		String statusDate = "",confDateStr="",confDate="";
		String prdCode = "", giftCode = "";
		String empCodeAprv="",spouseName="",empFname="",empMname="",empLname="",shortName="",voucherNo="",
				empFnameO="",empMnameO="",empLnameO="",shortNameO="",statDateOStr="",statDateO="",chgTerm="",chgUser="";
		AdmCommon admCommon = null;
		SimpleDateFormat sdf = null;
		SimpleDateFormat sdfDBFormat = null;
		Timestamp statusDateTS = null;
		Timestamp statusDateOTS = null;
		Timestamp confDateTS = null;
		try
		{
			sdf = new SimpleDateFormat(getApplDateFormat());
			SimpleDateFormat sdfDB = new SimpleDateFormat(getDBDateFormat());
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			E12GenericUtility genericUtility = new E12GenericUtility();

			if (objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			objNameDefault  = checkNull(getObjName(dom ,"1"));
			System.out.println("objNameDefault ..:: ["+objNameDefault+"]");

			switch (currentFormNo)
			{
				case 1:	
				{
					System.out.println("current form::::::::::::"+currentFormNo);
					empCode =  genericUtility.getColumnValue("emp_code", dom);
					System.out.println("empCode from Dom::"+empCode);
					tranDateStr = genericUtility.getColumnValue("tran_date", dom);
					System.out.println("tranDateStr from Dom::"+tranDateStr);
					tranDate = java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(tranDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()));
					System.out.println("tranDate after parsing::"+tranDate);
					statusDateStr = genericUtility.getColumnValue("status_date", dom);
					
					Calendar currentDate = Calendar.getInstance();
//					SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
					String sysDateStr = sdf.format(currentDate.getTime());
					
					chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
					chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
					System.out.println("@V@ chgTerm :- ["+chgTerm+"]");
					System.out.println("@V@ chgUser :- ["+chgUser+"]");
	
					valueXmlString.append("<Detail>\r\n");
					if(currentColumn.equalsIgnoreCase("itm_default"))
					{
						System.out.println("@V@ In itm_defaultedit");
						
						sql = "SELECT STATUS_DATE, OLD_STATUS, NEW_STATUS, SHORT_NAME, CONFIRM,EMP_CODE__APRV," +
								" SPOUSE_NAME,EMP_FNAME,EMP_MNAME,EMP_LNAME,SHORT_NAME,VOUCHER_NO,AMOUNT," +
								" EMP_FNAME__O,EMP_MNAME__O,EMP_LNAME__O,SHORT_NAME__O,STATUS_DATE__O,CONF_DATE" +
								" FROM EMP_MARITALCHG" +
								" WHERE EMP_CODE = ? AND TRAN_DATE = ? ";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1, empCode);
						pstmt.setTimestamp(2, tranDate);
						rs=pstmt.executeQuery();
						while(rs.next())
						{							
							//statusDateStr = checkNull(rs.getString("STATUS_DATE"));
							statusDateTS = rs.getTimestamp("STATUS_DATE");
							oldStatus=checkNull(rs.getString("OLD_STATUS"));
							newStatus = checkNull(rs.getString("NEW_STATUS"));
							empName = checkNull(rs.getString("SHORT_NAME"));
							confirm = checkNull(rs.getString("CONFIRM"));
							empCodeAprv = checkNull(rs.getString("EMP_CODE__APRV"));
							spouseName = checkNull(rs.getString("SPOUSE_NAME"));
							empFname = checkNull(rs.getString("EMP_FNAME"));
							empMname = checkNull(rs.getString("EMP_MNAME"));
							empLname = checkNull(rs.getString("EMP_LNAME"));
							shortName = checkNull(rs.getString("SHORT_NAME"));
							voucherNo = checkNull(rs.getString("VOUCHER_NO"));
							amount = rs.getDouble("AMOUNT");
							empFnameO = checkNull(rs.getString("EMP_FNAME__O"));
							empMnameO = checkNull(rs.getString("EMP_MNAME__O"));
							empLnameO = checkNull(rs.getString("EMP_LNAME__O"));
							shortNameO = checkNull(rs.getString("SHORT_NAME__O"));
							//statDateOStr = checkNull(rs.getString("STATUS_DATE__O"));
							//confDateStr = checkNull(rs.getString("CONF_DATE"));
							statusDateOTS = rs.getTimestamp("STATUS_DATE__O");
							confDateTS = rs.getTimestamp("CONF_DATE");
						}
						close(pstmt, rs);
						
						valueXmlString.append("<emp_code protect=\"1\"><![CDATA[" + empCode + "]]></emp_code>\r\n");
						valueXmlString.append("<tran_date protect=\"1\"><![CDATA[" + tranDateStr + "]]></tran_date>\r\n");
//						valueXmlString.append("<status_date><![CDATA[" + statusDateStr + "]]></status_date>\r\n");
						//modification by Santosh Gupta to make old,new status editable (18/4/17)START
						//System.out.println("value of confirm is:"+confirm);
						//Modified by Santosh Gupta to give status date editable if status is y
						
						if(statusDateTS != null)
						{
							statusDateStr = sdfDB.format(statusDateTS);
							statusDate = genericUtility.getValidDateTimeString(statusDateStr,genericUtility.getDBDateFormat(),
									genericUtility.getApplDateFormat());
							if( "Y".equalsIgnoreCase(confirm))
							{
								//valueXmlString.append("<status_date><![CDATA[" + statusDate + "]]></status_date>\r\n");
								valueXmlString.append("<status_date protect=\"0\"><![CDATA[" + statusDate + "]]></status_date>\r\n");
							}
							else
							{
								valueXmlString.append("<status_date protect=\"1\"><![CDATA[" + statusDate + "]]></status_date>\r\n");
							}
						}
						else
						{
							if( "Y".equalsIgnoreCase(confirm))
							{
								//valueXmlString.append("<status_date><![CDATA[]]></status_date>\r\n");
								valueXmlString.append("<status_date protect=\"0\"><![CDATA[]]></status_date>\r\n");
							}
							else
							{
								valueXmlString.append("<status_date protect=\"1\"><![CDATA[]]></status_date>\r\n");
							}
						}
						//Santosh Gupta End
						valueXmlString.append("<old_status protect=\"1\"><![CDATA[" + oldStatus + "]]></old_status>\r\n");
						valueXmlString.append("<new_status protect=\"1\"><![CDATA[" + newStatus + "]]></new_status>\r\n");
						valueXmlString.append("<emp_code__aprv protect=\"1\"><![CDATA[" + empCodeAprv + "]]></emp_code__aprv>\r\n");
						valueXmlString.append("<spouse_name protect=\"1\"><![CDATA[" + spouseName + "]]></spouse_name>\r\n");
						valueXmlString.append("<emp_fname protect=\"1\"><![CDATA[" + empFname + "]]></emp_fname>\r\n");
						valueXmlString.append("<emp_mname protect=\"1\"><![CDATA[" + empMname + "]]></emp_mname>\r\n");
						valueXmlString.append("<emp_lname protect=\"1\"><![CDATA[" + empLname + "]]></emp_lname>\r\n");
						
						valueXmlString.append("<emp_maritalchg_emp_fname protect=\"1\">").append("<![CDATA[" + empFname+ "]]>").append("</emp_maritalchg_emp_fname>");
						valueXmlString.append("<emp_maritalchg_emp_mname protect=\"1\">").append("<![CDATA[" + empMname+ "]]>").append("</emp_maritalchg_emp_mname>");
						valueXmlString.append("<emp_maritalchg_emp_lname protect=\"1\">").append("<![CDATA[" + empLname+ "]]>").append("</emp_maritalchg_emp_lname>");
						
						valueXmlString.append("<short_name protect=\"1\"><![CDATA[" + shortName + "]]></short_name>\r\n");
						valueXmlString.append("<emp_maritalchg_voucher_no protect=\"1\"><![CDATA[" + voucherNo + "]]></emp_maritalchg_voucher_no>\r\n");
						valueXmlString.append("<emp_maritalchg_amount protect=\"1\"><![CDATA[" + amount + "]]></emp_maritalchg_amount>\r\n");
						valueXmlString.append("<emp_fname__o protect=\"1\"><![CDATA[" + empFnameO + "]]></emp_fname__o>\r\n");
						valueXmlString.append("<emp_mname__o protect=\"1\"><![CDATA[" + empMnameO + "]]></emp_mname__o>\r\n");
						valueXmlString.append("<emp_lname__o protect=\"1\"><![CDATA[" + empLnameO + "]]></emp_lname__o>\r\n");
						valueXmlString.append("<short_name__o protect=\"1\"><![CDATA[" + shortNameO + "]]></short_name__o>\r\n");
						valueXmlString.append("<chg_date protect=\"1\"><![CDATA[" + sysDateStr + "]]></chg_date>\r\n");
						valueXmlString.append("<chg_term protect=\"1\"><![CDATA[" + chgTerm + "]]></chg_term>\r\n");
						valueXmlString.append("<chg_user protect=\"1\"><![CDATA[" + chgUser + "]]></chg_user>\r\n");
						
						//Modified by Ahmed on 26/Apr/2017[start]
//						if(statDateOStr!=null && statDateOStr.trim().length()>0)
//						{
//							statDateO = genericUtility.getValidDateTimeString(statDateOStr,genericUtility.getDBDateFormat(),
//									genericUtility.getApplDateFormat());
//							valueXmlString.append("<status_date__o protect=\"1\"><![CDATA[" + statDateO + "]]></status_date__o>\r\n");
//						}
//						else
//						{
//							valueXmlString.append("<status_date__o protect=\"1\"><![CDATA[]]></status_date__o>\r\n");
//						}
						
						if(statusDateOTS != null)
						{
							statDateOStr = sdfDB.format(statusDateOTS);
							statDateO = genericUtility.getValidDateTimeString(statDateOStr,genericUtility.getDBDateFormat(),
									genericUtility.getApplDateFormat());
							valueXmlString.append("<status_date__o protect=\"1\"><![CDATA[" + statDateO + "]]></status_date__o>\r\n");
						}
						else
						{
							valueXmlString.append("<status_date__o protect=\"1\"><![CDATA[]]></status_date__o>\r\n");
						}

//						if(confDateStr!=null && confDateStr.trim().length()>0)
//						{
//							confDate = genericUtility.getValidDateTimeString(confDateStr,genericUtility.getDBDateFormat(),
//									genericUtility.getApplDateFormat());
//							valueXmlString.append("<conf_date protect=\"1\"><![CDATA[" + confDate + "]]></conf_date>\r\n");
//						}
//						else
//						{
//							valueXmlString.append("<conf_date protect=\"1\"><![CDATA[]]></conf_date>\r\n");
//						}
						
						if(confDateTS != null)
						{
							confDateStr = sdfDB.format(confDateTS);
							confDate = genericUtility.getValidDateTimeString(confDateStr,genericUtility.getDBDateFormat(),
									genericUtility.getApplDateFormat());
							valueXmlString.append("<conf_date protect=\"1\"><![CDATA[" + confDate + "]]></conf_date>\r\n");
						}
						else
						{
							
							valueXmlString.append("<conf_date protect=\"1\"><![CDATA[]]></conf_date>\r\n");
						}
						//Modified by Ahmed on 26/Apr/2017[end]
					}
//					if(currentColumn.equalsIgnoreCase("itm_defaultedit"))
//					{
//						System.out.println("@V@ In itm_defaultedit");
//						
//						sql = "SELECT STATUS_DATE, OLD_STATUS, NEW_STATUS, SHORT_NAME, CONFIRM,EMP_CODE__APRV," +
//								" SPOUSE_NAME,EMP_FNAME,EMP_MNAME,EMP_LNAME,SHORT_NAME,VOUCHER_NO,AMOUNT," +
//								" EMP_FNAME__O,EMP_MNAME__O,EMP_LNAME__O,SHORT_NAME__O" +
//								" FROM EMP_MARITALCHG" +
//								" WHERE EMP_CODE = ? AND TRAN_DATE = ? ";
//						pstmt=conn.prepareStatement(sql);
//						pstmt.setString(1, empCode);
//						pstmt.setTimestamp(2, tranDate);
//						rs=pstmt.executeQuery();
//						while(rs.next())
//						{							
//							statusDate = rs.getDate("STATUS_DATE");
//							oldStatus=checkNull(rs.getString("OLD_STATUS"));
//							newStatus = checkNull(rs.getString("NEW_STATUS"));
//							empName = checkNull(rs.getString("SHORT_NAME"));
//							confirm = checkNull(rs.getString("CONFIRM"));
//							empCodeAprv = checkNull(rs.getString("EMP_CODE__APRV"));
//							spouseName = checkNull(rs.getString("SPOUSE_NAME"));
//							empFname = checkNull(rs.getString("EMP_FNAME"));
//							empMname = checkNull(rs.getString("EMP_MNAME"));
//							empLname = checkNull(rs.getString("EMP_LNAME"));
//							shortName = checkNull(rs.getString("SHORT_NAME"));
//							voucherNo = checkNull(rs.getString("VOUCHER_NO"));
//							amount = rs.getDouble("AMOUNT");
//							empFnameO = checkNull(rs.getString("EMP_FNAME__O"));
//							empMnameO = checkNull(rs.getString("EMP_MNAME__O"));
//							empLnameO = checkNull(rs.getString("EMP_LNAME__O"));
//							shortNameO = checkNull(rs.getString("SHORT_NAME__O"));
//						}
//						close(pstmt, rs);
//						
//						valueXmlString.append("<emp_code protect=\"1\"><![CDATA[" + empCode + "]]></emp_code>\r\n");
//						valueXmlString.append("<tran_date protect=\"1\"><![CDATA[" + tranDateStr + "]]></tran_date>\r\n");
//						valueXmlString.append("<status_date><![CDATA[" + statusDateStr + "]]></status_date>\r\n");
//						valueXmlString.append("<old_status protect=\"1\"><![CDATA[" + oldStatus + "]]></old_status>\r\n");
//						valueXmlString.append("<new_status protect=\"1\"><![CDATA[" + newStatus + "]]></new_status>\r\n");
//						valueXmlString.append("<emp_code__aprv protect=\"1\"><![CDATA[" + empCodeAprv + "]]></emp_code__aprv>\r\n");
//						valueXmlString.append("<spouse_name protect=\"1\"><![CDATA[" + spouseName + "]]></spouse_name>\r\n");
//						valueXmlString.append("<emp_fname protect=\"1\"><![CDATA[" + empFname + "]]></emp_fname>\r\n");
//						valueXmlString.append("<emp_mname protect=\"1\"><![CDATA[" + empMname + "]]></emp_mname>\r\n");
//						valueXmlString.append("<emp_lname protect=\"1\"><![CDATA[" + empLname + "]]></emp_lname>\r\n");
//						valueXmlString.append("<short_name protect=\"1\"><![CDATA[" + shortName + "]]></short_name>\r\n");
//						valueXmlString.append("<voucher_no protect=\"1\"><![CDATA[" + voucherNo + "]]></voucher_no>\r\n");
//						valueXmlString.append("<amount protect=\"1\"><![CDATA[" + amount + "]]></amount>\r\n");
//						valueXmlString.append("<emp_fname__o protect=\"1\"><![CDATA[" + empFnameO + "]]></emp_fname__o>\r\n");
//						valueXmlString.append("<emp_mname__o protect=\"1\"><![CDATA[" + empMnameO + "]]></emp_mname__o>\r\n");
//						valueXmlString.append("<emp_lname__o protect=\"1\"><![CDATA[" + empLnameO + "]]></emp_lname__o>\r\n");
//						valueXmlString.append("<short_name__o protect=\"1\"><![CDATA[" + shortNameO + "]]></short_name__o>\r\n");
//					}
					valueXmlString.append ("</Detail>\r\n");
				}
				break;
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				close(pstmt, rs);
				if (conn != null)
				{
					conn.close();
					conn = null;
				}

			} 
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("valueXmlString"+valueXmlString);
		return valueXmlString.toString();
	}
	private String getObjName(Document dom,String objContext)
	{
		Node elementName = null;
		NodeList elementList = null;
		String objName = "";

		try
		{
			elementList = dom.getElementsByTagName("Detail"+objContext);
			elementName = elementList.item(0);
	
			if(elementName != null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
			{
				NamedNodeMap etlAttributes = elementName.getAttributes();
	
				if(etlAttributes != null)
				{
					if(etlAttributes.getNamedItem("obj_name") != null)
					{
						objName = etlAttributes.getNamedItem("obj_name").getNodeValue();
					}
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return objName;
	}
	
	private String checkNull(String input)
	{
		if(input == null)
		{
			input = "";
		}

		else 
		{
			input = input.trim();
		}
		return input;
	}
	
	private void close(PreparedStatement pstmt,ResultSet rs) //Method to close PreparedStatement & ResultSet
	{
		try
		{
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
}