/*
 * Author: Wasim Ansari
 * Date: 08-AUG-2016
 * Request: S16EBAS006 (Pack Label Wizard)
 */

package ibase.webitm.servlet.wms;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.wms.PackLabelWizEJB;
import ibase.webitm.ejb.wms.PackLabelWizEJBRemote;
import ibase.webitm.servlet.Messages;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PackLabelWizHandlerServlet extends HttpServlet
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	InitialContext ctx = null;
	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		doPost( request, response );
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		try
		{
			System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ PackLabelWizHandlerServlet ]XXXXXXXXXXXXXXXXXXXX");
			request.setCharacterEncoding(CommonConstants.ENCODING);
			String htmlData = ""; //$NON-NLS-1$
			String retStr = "";
			PackLabelWizEJBRemote packLabelWizEJBRemote = null;
			//Changed by manish on 07/10/16[Start]
			String actionPrint = request.getParameter("ACTION");

			System.out.println("PackLabelWizHandlerServlet ACTION ["+actionPrint+"]");

			if("PRINT".equalsIgnoreCase(actionPrint))
			{
				String itemCodeCaseLabel = checkNullAndTrim(request.getParameter("ITEM_CODE"));
				String lotNoCaseLabel 	= checkNullAndTrim(request.getParameter("LOT_NO"));
				String qtyCaseLabel 	= checkNullAndTrim(request.getParameter("QUANTITY"));
				String PurcOrdNoCaseLabel 	= checkNullAndTrim(request.getParameter("ORDER_NO"));
				ctx = getInitialContext();
				packLabelWizEJBRemote = (ibase.webitm.ejb.wms.PackLabelWizEJBRemote) ctx.lookup("ibase/PackLabelWizEJB/remote");
				retStr = packLabelWizEJBRemote.insertCaseLabel(itemCodeCaseLabel,lotNoCaseLabel,qtyCaseLabel,PurcOrdNoCaseLabel);
				System.out.println("retStr ====>> ["+retStr+"]");
				response.setContentType("text/xml");
	            
	            if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
				{
					response.setHeader("Content-Encoding", "gzip");
					GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
					gzOutStream.write(retStr.toString().getBytes());
					gzOutStream.flush();
					gzOutStream.close();
				}
				else
				{
					response.setHeader("Content-Encoding", "");
					OutputStream outStream = response.getOutputStream();
					outStream.write(retStr.toString().getBytes());
					outStream.flush();
					outStream.close();
				}
			}
			else if("CALCEXPDATE".equalsIgnoreCase(actionPrint))
			{
				String mfgDate = request.getParameter("MFG_DATE");
				String itemCode = checkNullAndTrim(request.getParameter("ITEM_CODE"));
				ctx = getInitialContext();
				packLabelWizEJBRemote = (ibase.webitm.ejb.wms.PackLabelWizEJBRemote) ctx.lookup("ibase/PackLabelWizEJB/remote");
				retStr = packLabelWizEJBRemote.calcExpDate(mfgDate,itemCode);
				System.out.println("retStr ====>> ["+retStr+"]");
				response.setContentType("text/xml");
	            
	            if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
				{
					response.setHeader("Content-Encoding", "gzip");
					GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
					gzOutStream.write(retStr.toString().getBytes());
					gzOutStream.flush();
					gzOutStream.close();
				}
				else
				{
					response.setHeader("Content-Encoding", "");
					OutputStream outStream = response.getOutputStream();
					outStream.write(retStr.toString().getBytes());
					outStream.flush();
					outStream.close();
				}
			}
			else if("SITE".equalsIgnoreCase(actionPrint))
			{
				String purcOrd = checkNullAndTrim(request.getParameter("PURC_ORDER"));
				String contNo = checkNullAndTrim(request.getParameter("CONTRACT_NO"));
				System.out.println("purcOrd==["+purcOrd+"] contNo==["+contNo+"]");
				ctx = getInitialContext();
				packLabelWizEJBRemote = (ibase.webitm.ejb.wms.PackLabelWizEJBRemote) ctx.lookup("ibase/PackLabelWizEJB/remote");
				retStr = packLabelWizEJBRemote.getSiteCode(purcOrd,contNo);
				System.out.println("retStr ====>> ["+retStr+"]");
				response.setContentType("text/xml");
	            
	            if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
				{
					response.setHeader("Content-Encoding", "gzip");
					GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
					gzOutStream.write(retStr.toString().getBytes());
					gzOutStream.flush();
					gzOutStream.close();
				}
				else
				{
					response.setHeader("Content-Encoding", "");
					OutputStream outStream = response.getOutputStream();
					outStream.write(retStr.toString().getBytes());
					outStream.flush();
					outStream.close();
				}
			}
			else if("CMPDATE".equalsIgnoreCase(actionPrint))
			{
				String mfgDate = request.getParameter("MFG_DATE");
				String expDate = request.getParameter("EXP_DATE");
				ctx = getInitialContext();
				packLabelWizEJBRemote = (ibase.webitm.ejb.wms.PackLabelWizEJBRemote) ctx.lookup("ibase/PackLabelWizEJB/remote");
				retStr = packLabelWizEJBRemote.compDate(mfgDate,expDate);
				System.out.println("retStr ====>> ["+retStr+"]");
				response.setContentType("text/xml");
				
				if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
				{
					response.setHeader("Content-Encoding", "gzip");
					GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
					gzOutStream.write(retStr.toString().getBytes());
					gzOutStream.flush();
					gzOutStream.close();
				}
				else
				{
					response.setHeader("Content-Encoding", "");
					OutputStream outStream = response.getOutputStream();
					outStream.write(retStr.toString().getBytes());
					outStream.flush();
					outStream.close();
				}
			}
			//Changed by manish on 07/10/16[end]
			else{
				String itemCode = checkNullAndTrim(request.getParameter("ITEM_CODE"));
				String lotNo 	= checkNullAndTrim(request.getParameter("LOT_NO"));	

				if(itemCode.length() != 0 && lotNo.length() != 0)
				{
					PackLabelWizEJB packLabel = new PackLabelWizEJB();
					String shipperSize = packLabel.getItemLotPackSize(itemCode,lotNo);

					response.setContentType("text/xml");

					if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
					{
						response.setHeader("Content-Encoding", "gzip");
						GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
						gzOutStream.write(shipperSize.toString().getBytes());
						gzOutStream.flush();
						gzOutStream.close();
					}
					else
					{
						response.setHeader("Content-Encoding", "");
						OutputStream outStream = response.getOutputStream();
						outStream.write(shipperSize.toString().getBytes());
						outStream.flush();
						outStream.close();
					}
				}
				else
				{	
					ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )request.getSession().getAttribute( "USER_INFO" ); //$NON-NLS-1$
					if(userInfo != null)
					{
						String objName 	= request.getParameter("OBJ_NAME");//Storing ObjectName //$NON-NLS-1$
						String formNo 	= request.getParameter("FORM_NO");//Storing Current FormNo //$NON-NLS-1$
						String action	= request.getParameter("action");//Which actions is performed e.g. 'Next','Previous','Finish' //$NON-NLS-1$
						//String formType = request.getParameter("formType");//Type of form to implement MultipleForms //$NON-NLS-1$
						//String forceSave = request.getParameter("forceSave");//To override Warnings from Business Components //$NON-NLS-1$

						String preFormVal = request.getParameter("PRE_FORM_VAL");
						System.out.println("preFormVal==========["+preFormVal+"]");
						
						String editorId = (String) request.getSession().getAttribute( "WIZARD_BEAN_ID_" + objName );
						System.out.println(" ITMWizardHandlerServlet :: editorId["+editorId+"]" );

						if (request.getSession().getAttribute("WIZARD_BEAN_" + editorId) != null) 
						{
							System.out.println(" Wizard Object Found ");

							if ("previous".equalsIgnoreCase(action) && "2".equalsIgnoreCase(formNo)) 
							{
								response.sendRedirect("/ibase/webitm/jsp/packLabelWiz.jsp?OBJ_NAME=" + objName + "&PRE_FORM_VAL=" + preFormVal);
							}
						}
					}
					else
					{
						htmlData = Messages.getString("ITMWizardHandlerServlet_notLoggedIn")+"\n"+Messages.getString("ITMWizardHandlerServlet_pleaseReLogin"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					}
				}	
			}
		}
		catch (Exception e) {
			// TODO: handle exception
		}
	}

	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("CrossDockAllocServlet.getInitialContext()");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("CrossDockAllocServlet.getInitialContext()"+e.getMessage());
			throw new ITMException(e);
		}
		return ctx;
	}
}
