/**
 * PURPOSE : Stock Transfer Out Component Pos Save
 * AUTHOR : Wasim Ansari
 * DATE : 07-01-2016
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.EventManagerLocal;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.CreateDistOrder;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.DistStkUpdLocal;
import ibase.webitm.ejb.dis.adv.StockTransferConf;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

import javax.naming.InitialContext;

import org.w3c.dom.Document;


@javax.ejb.Stateless
public class PalletOutPos extends ValidatorEJB implements PalletOutPosLocal, PalletOutPosRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	DistCommon distComm = new DistCommon();
	CreateDistOrder distOrder = new CreateDistOrder();
	
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public String postSave( String domString, String tranId, String editFlag, String xtraParams, Connection conn1 ) throws RemoteException, ITMException
	{
		ResultSet rs = null,rsBay = null;
		PreparedStatement pstmt = null, pstmtUpdate = null,pstmtBay = null;	
		String errString = "", sql = "",inOut = "",refSer = "",refId = "";
		boolean isScheduleReq = true,isError = false;
		String locCodeInput = "",locCodeSugg = "",siteCode = "",palleNoInterface = "",bayNo = "";
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver(); 
		Document dom = null;
		
		try
		{
			System.out.println("Inside Pos save Wizard Stock Transfer");
			System.out.println("Xtra Params in post save==>"+xtraParams);
			System.out.println("XML String="+domString);
			
			System.out.println("Connection not found from Framework so creating new");
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			conn.setAutoCommit(false);

			siteCode = checkNullAndTrim((genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode")));
			System.out.println("Site Code="+siteCode);
			
			if(domString != null &&  (domString.indexOf("Detail2") != -1))
			{
				dom = genericUtility.parseString(domString);
	
				bayNo = checkNullAndTrim(genericUtility.getColumnValue("pallet_no", dom, "1" ));
				locCodeInput = checkNullAndTrim(genericUtility.getColumnValue("loc_code_input", dom, "2" ));
				locCodeSugg = checkNullAndTrim(genericUtility.getColumnValue("loc_code_sugg", dom, "2" ));
	
				System.out.println("Loc code received in Pos Save Pallet_no["+bayNo+"]loc code input ["+locCodeInput+"] loc code sugg ["+locCodeSugg+"]");
				
				//sql = "SELECT DISTINCT PALLET_NO FROM WMS_TO_HOST WHERE BAY_NO = ?";
				/*sql = " SELECT DISTINCT PALLET_NO FROM WMS_TO_HOST WHERE BAY_NO = ? "
					 +" AND REF_ID IN (SELECT REF_ID FROM SWMS_TO_AWMS WHERE SCHEDULE_STATUS = 'N')";
				pstmtBay = conn.prepareStatement(sql);
				pstmtBay.setString(1, bayNo);
				rsBay = pstmtBay.executeQuery();
				while(rsBay.next())
				{
					palleNoInterface = checkNullAndTrim(rsBay.getString("PALLET_NO"));
					
					System.out.println("Pallet no interface="+palleNoInterface);*/
					
					/*sql = " SELECT DISTINCT REF_ID,REF_SER,IN_OUT FROM WMS_TO_HOST WHERE PALLET_NO = ?"
						 +" AND REF_ID IN (SELECT REF_ID FROM SWMS_TO_AWMS  WHERE SCHEDULE_STATUS = 'N' AND PALLET_NO = ?)";*/
					
					sql = " SELECT DISTINCT REF_ID,REF_SER,IN_OUT FROM WMS_TO_HOST WHERE BAY_NO = ?"
							 +" AND REF_ID IN (SELECT REF_ID FROM SWMS_TO_AWMS  WHERE SCHEDULE_STATUS = 'N')";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, bayNo);
					//pstmt.setString(2, palleNoInterface);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						refId = checkNullAndTrim(rs.getString("REF_ID"));
						refSer   = checkNullAndTrim(rs.getString("REF_SER"));
						inOut  = checkNullAndTrim(rs.getString("IN_OUT"));
						//palleNoInterface  = checkNullAndTrim(rs.getString("PALLET_NO"));
						
						HashMap interfaceHmap = new HashMap();
						interfaceHmap.put("REF_ID", refId);
						interfaceHmap.put("REF_SER", refSer);
						interfaceHmap.put("LOC_CODE_TO", locCodeInput);
						interfaceHmap.put("BAY_NO", bayNo);
						//interfaceHmap.put("PALLET_NO", palleNoInterface);
						
						System.out.println("refId["+refId+"]refSer["+refSer+"]inOut["+inOut+"]palletNo["+palleNoInterface+"]");
						
						if("D-SO".equalsIgnoreCase(refSer) || "S-ORD".equalsIgnoreCase(refSer))
						{
							isScheduleReq = checkCountPalletReq(refId,conn);
							System.out.println("Count for D-S0/S-ORD="+isScheduleReq);
							if(isScheduleReq)
							{
								System.out.println("["+refId+"]can be used for stock transfer");
							}
							else
							{
								//continue;
								errString = itmDBAccessEJB.getErrorString("","VTACKAWMS","","",conn);
								return errString;
							}
						}
						if("O".equalsIgnoreCase(inOut))
						{	
							System.out.println("Going for stock transfer refId["+refId+"]refSer["+refSer+"]inOut["+inOut+"]");
							errString = stockTransfer(interfaceHmap,xtraParams,conn);
						}
					}
					if(pstmt != null) { pstmt.close(); pstmt = null; }
					if(rs != null) { rs.close(); rs = null; }
				/*}
				if(pstmtBay != null) { pstmtBay.close(); pstmtBay = null; }
				if(rsBay != null) { rsBay.close(); rsBay = null; }*/
			}
			else
			{
				System.out.println("Detail not found");
			}
		}	
		catch(Exception e)
		{
			try
			{
				isError = true;
				e.printStackTrace();			
				throw new ITMException(e);
			}
			catch (Exception e1)
			{
				e1.printStackTrace();
				throw new ITMException(e1);
			}
		}
		finally
		{
			try
			{	
				if(isError)
				{
					System.out.println("Finally rollbacking");
					conn.rollback();
				}
				else
				{
					System.out.println("Finally committing");
					conn.commit();
				}
				if(conn != null){conn.close();conn=null;}
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(pstmtUpdate != null){pstmtUpdate.close();pstmtUpdate = null;}
				if(rs != null){rs.close();rs = null;}
				if(pstmtBay != null) { pstmtBay.close(); pstmtBay = null; }
				if(rsBay != null) { rsBay.close(); rsBay = null; }
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("Return String from Post Save"+errString);
		return errString;
	}	

	@SuppressWarnings({ "rawtypes", "unchecked" })
	private String stockTransfer(HashMap interfaceMap,String xtraParams,Connection conn) throws SQLException, ITMException
	{
		PreparedStatement pstmt=null, pstmtHdr = null, pstmtDet = null,pstmtInterface = null,pstmtUpdate = null,pstmtDso = null;
		ResultSet rs = null,rsInterface = null,rsDso = null;

		String sql = "",insertSql = "",tranID = "",userId = "",errString = "",sqlInterface = "",sqlUpdate = "",sqlDso = "",
				chgTerm = "",bayNo = "", lotSlPallet = "", lotNoPallet = "";

		String refSer = "",refId = "",itemCode = "",lotNo = "",lotSl = "",acctCodeInv = "",cctrCodeInv = "",noArt = "",lineNoNew = "",
				palletNo = "",locCodeTo = "",locCodeFrom = "",siteCode = "",lineNoInterface = "", lotNoFirst = "", lotSlFirst = "";

		double quantity = 0,allocQty = 0,distOrderAlloc = 0,sordAllocQty = 0;
		int updCnt = 0,lineNo = 0,countDso = 0;

		//HashMap hashMap = new HashMap(); 

		userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
		chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );

		boolean headerFlag = true;
		DistStkUpdLocal distStkUpd = null;

		ArrayList lineNoList = new ArrayList();
		ArrayList allocList = new ArrayList();
		ArrayList locationList = new ArrayList();
		ArrayList DistStkList = new ArrayList();
		ArrayList DespatchStkList = new ArrayList();
		boolean isRecordExist = false;

		try
		{
			System.out.println("Inside stock transfer");

			java.sql.Timestamp currDate = getCurrtDate();
			System.out.println("Current date for stock transfer is"+currDate);

			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);

			refSer = (String) interfaceMap.get("REF_SER");
			refId = (String) interfaceMap.get("REF_ID");
			locCodeTo = (String) interfaceMap.get("LOC_CODE_TO");
			bayNo = (String) interfaceMap.get("BAY_NO");
			//locCodeFrom = (String) interfaceMap.get("PALLET_NO");

			System.out.println("bay no ::::" + bayNo);
			
			sql = "select tran_id from distord_iss where dist_order = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, refId);
			rs = pstmt.executeQuery();
			if(rs.next()){
				tranID = rs.getString("tran_id");
			}
			tranID = tranID == null ? "" : tranID.trim();
			System.out.println("tran id::::" + tranID);
			
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			
			if(tranID.length() > 0){
				
				
				sql = "SELECT DISTINCT (LINE_NO),PALLET_NO,lot_no,lot_sl FROM WMS_TO_HOST WHERE REF_ID = ? AND IN_OUT != 'P' AND BAY_NO = ?"
					      +" AND PALLET_NO IN (SELECT PALLET_NO FROM SWMS_TO_AWMS WHERE REF_ID = ? AND SCHEDULE_STATUS = 'N')";
			pstmtInterface = conn.prepareStatement(sql);
			pstmtInterface.setString(1, refId);
			pstmtInterface.setString(2, bayNo);
			pstmtInterface.setString(3, refId);
			
			rsInterface = pstmtInterface.executeQuery();
			while(rsInterface.next())
			{	
				
				lineNoNew = checkNullAndTrim(rsInterface.getString("LINE_NO"));
				palletNo = checkNullAndTrim(rsInterface.getString("PALLET_NO"));
				lotNoPallet = checkNullAndTrim(rsInterface.getString("lot_no"));
				lotSlPallet = checkNullAndTrim(rsInterface.getString("lot_sl"));
				
			}
			pstmtInterface.close();
			pstmtInterface = null;
			rsInterface.close();
			rsInterface = null;
			
			System.out.println(" data when tran id is  present::line no [" + lineNoNew + "] pallet not ::: [" + palletNo + "] :: lot no [" +lotNoPallet + "] ::: lot sl Pallet::[" + lotSlPallet +"]");
				
				sqlUpdate = "UPDATE SWMS_TO_AWMS SET SCHEDULE_STATUS = 'Y' WHERE REF_ID = ? AND LINE_NO = ? AND PALLET_NO = ? and lot_no = ? and lot_sl = ?";
				pstmtUpdate = conn.prepareStatement(sqlUpdate);
				pstmtUpdate.setString(1, refId);
				pstmtUpdate.setString(2, lineNoNew);
				pstmtUpdate.setString(3, palletNo);
				pstmtUpdate.setString(4, lotNoPallet);
				pstmtUpdate.setString(5, lotSlPallet);

				int caseCount = pstmtUpdate.executeUpdate();
				
				System.out.println("Updated ="+caseCount);
				
				pstmtUpdate.close();
				pstmtUpdate = null;
				
				errString = "Success";
				return errString;
			}
			
			if("D-SO".equalsIgnoreCase(refSer))
			{
				sqlDso = "SELECT COUNT(*) AS COUNT FROM DISTORDER_ALLOC WHERE DIST_ORDER = ?";
				pstmtDso = conn.prepareStatement(sqlDso);
				pstmtDso.setString(1, refId);
				rsDso = pstmtDso.executeQuery();
				if(rsDso.next())
				{
					countDso = rsDso.getInt("COUNT");
				}
				if(pstmtDso != null){pstmtDso.close();pstmtDso = null;}
				if(rsDso != null){rsDso.close();rsDso = null;}

				System.out.println("Count DSO ="+countDso);
				
				

				if(countDso == 0)
				{
					sql = "SELECT D.TRAN_ID,D.ITEM_CODE,D.LINE_NO,S.QUANTITY,D.LOT_NO,D.LOT_SL,D.LOC_CODE,H.SITE_CODE,S.ALLOC_QTY,D.NO_ART,"
							+" S.ACCT_CODE__INV,S.CCTR_CODE__INV"
							+" FROM DISTORD_ISSDET D,DISTORD_ISS H,STOCK S "
							+" WHERE D.TRAN_ID = H.TRAN_ID AND H.CONFIRMED = 'N' AND D.DIST_ORDER = ? AND D.LINE_NO = ? AND D.QUANTITY > 0 "
							+" AND S.LOC_CODE = D.LOC_CODE AND S.LOT_NO = D.LOT_NO" 
							+" AND S.LOT_SL = D.LOT_SL AND S.ITEM_CODE = D.ITEM_CODE AND S.SITE_CODE = H.SITE_CODE";
				}
				else
				{
					   sql = " SELECT D.QTY_ALLOC,D.SITE_CODE__MFG,D.QUANTITY AS DIST_QTY,DT.LINE_NO AS LINE_NO_DIST,"
							//+" H.SITE_CODE,H.TRAN_TYPE,DT.TAX_CLASS,DT.TAX_CHAP,DT.TAX_ENV,"//Changed site code ship on 15-07-2016
							+" H.SITE_CODE__SHIP AS SITE_CODE,H.TRAN_TYPE,DT.TAX_CLASS,DT.TAX_CHAP,DT.TAX_ENV,"
							+" S.ITEM_CODE,S.LOT_NO,S.LOT_SL,S.QUANTITY,S.ALLOC_QTY,S.EXP_DATE, S.UNIT,S.UNIT__ALT,S.ITEM_SER, S.MFG_DATE,S.NO_ART,"
							+" S.POTENCY_PERC, S.PACK_CODE, S.LOC_CODE, S.BATCH_NO, S.GRADE , S.QTY_PER_ART,S.GROSS_WEIGHT, S.TARE_WEIGHT, "
							+" S.NET_WEIGHT, S.DIMENSION, S.RETEST_DATE, S.SUPP_CODE__MFG, S.PACK_INSTR,S.RATE,"
							+" S.ACCT_CODE__INV,S.CCTR_CODE__INV,DT.RATE__CLG,DT.QTY_CONFIRM,DT.QTY_SHIPPED "
							+" FROM DISTORDER_ALLOC D,DISTORDER H,DISTORDER_DET DT,STOCK S "
							//+" WHERE D.DIST_ORDER = ? AND D.LINE_NO = ? AND S.QUANTITY > 0 "
							+" WHERE D.DIST_ORDER = ? " 
							//"AND (D.LOC_CODE = ? OR D.LOC_CODE = ? OR D.LOC_CODE = ? OR D.LOC_CODE = ?) AND D.LINE_NO = ? AND S.QUANTITY > 0  "
							+ "AND D.DIST_ORDER = H.DIST_ORDER AND H.DIST_ORDER = DT.DIST_ORDER AND D.LINE_NO = DT.LINE_NO AND" 
							+" D.LOT_NO = S.LOT_NO AND D.LOT_SL = S.LOT_SL AND D.ITEM_CODE = S.ITEM_CODE AND D.LOC_CODE = S.LOC_CODE"
							+" AND S.SITE_CODE = H.SITE_CODE__SHIP ";
				}
			}
			else if("S-ORD".equalsIgnoreCase(refSer))
			{
				sql = "SELECT S.ITEM_CODE,D.LINE_NO,S.QUANTITY,S.ALLOC_QTY,D.QTY_ALLOC,S.LOT_NO,S.LOT_SL,S.LOC_CODE,S.SITE_CODE,S.NO_ART,"
						+" S.ACCT_CODE__INV,S.CCTR_CODE__INV " 
						+" FROM SORDALLOC D,SORDER H,STOCK S "
					  //+" WHERE D.SALE_ORDER = ? AND D.LINE_NO = ? AND S.QUANTITY > 0"
						+" WHERE D.SALE_ORDER = ? AND (D.LOC_CODE = ? OR D.LOC_CODE = ? OR D.LOC_CODE = ? OR D.LOC_CODE = ?) AND D.LINE_NO = ? AND S.QUANTITY > 0"
						+" AND D.SALE_ORDER = H.SALE_ORDER"
						+" AND D.LOT_NO = S.LOT_NO AND D.LOT_SL = S.LOT_SL"
						+" AND D.ITEM_CODE = S.ITEM_CODE AND D.LOC_CODE = S.LOC_CODE AND D.SITE_CODE = S.SITE_CODE";
			}
			else if("PR".equalsIgnoreCase(refSer))
			{
				sql = "SELECT S.ITEM_CODE,S.QUANTITY,S.LOT_NO,S.LOT_SL,S.LOC_CODE,S.ALLOC_QTY,P.NO_ART,"
						+" S.ACCT_CODE__INV,S.CCTR_CODE__INV, " 
						+" S.SITE_CODE FROM STOCK S,PALLET_REQ_DET P WHERE" 
						+" P.TRAN_ID = ? AND P.LINE_NO = ? AND"
					    +" (S.LOC_CODE = P.PALLET_NO OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ?) "
					    +" AND S.QUANTITY > 0"; 
			}
			else if("PRS".equalsIgnoreCase(refSer))
			{
				sql = "SELECT P.ITEM_CODE,S.QUANTITY,P.LOT_NO,P.LOT_SL,S.LOC_CODE,H.SITE_CODE,S.ALLOC_QTY,P.NO_ART,"
						+" S.ACCT_CODE__INV,S.CCTR_CODE__INV "
						+" FROM PALLET_REQ_DET P,STOCK S,PALLET_REQ_HDR H WHERE P.TRAN_ID = ? AND P.LINE_NO = ?" 
						+" AND P.TRAN_ID = H.TRAN_ID AND P.ITEM_CODE = S.ITEM_CODE" 
						//+" AND H.SITE_CODE = S.SITE_CODE AND (P.PALLET_NO = S.LOC_CODE OR S.LOC_CODE = ? )" 
						+" AND H.SITE_CODE = S.SITE_CODE AND "
						+" (P.PALLET_NO = S.LOC_CODE OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ? OR S.LOC_CODE = ?) " 
						+" AND P.LOT_NO = S.LOT_NO" 
						+" AND P.LOT_SL = S.LOT_SL AND S.QUANTITY > 0";
			}

			insertSql = "INSERT INTO STOCK_TRANSFER_DET(TRAN_ID, LINE_NO, ITEM_CODE, QUANTITY, LOC_CODE__FR,"
					+ " LOC_CODE__TO, LOT_NO__FR, LOT_NO__TO, LOT_SL__FR, LOT_SL__TO, ACCT_CODE__CR, ACCT_CODE__DR,"
					+ " CCTR_CODE__DR, CCTR_CODE__CR, NO_ART) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmtDet = conn.prepareStatement(insertSql);


			/*sqlInterface = "SELECT DISTINCT (LINE_NO),PALLET_NO FROM WMS_TO_HOST WHERE REF_ID = ? AND IN_OUT != 'P' AND PALLET_NO = ?"
					+ " AND PALLET_NO IN (SELECT PALLET_NO FROM SWMS_TO_AWMS WHERE REF_ID = ? AND SCHEDULE_STATUS = 'N')";
			*/
			sqlInterface = "SELECT DISTINCT (LINE_NO),PALLET_NO,lot_no,lot_sl FROM WMS_TO_HOST WHERE REF_ID = ? AND IN_OUT != 'P' AND BAY_NO = ?"
					      +" AND PALLET_NO IN (SELECT PALLET_NO FROM SWMS_TO_AWMS WHERE REF_ID = ? AND SCHEDULE_STATUS = 'N')";
			pstmtInterface = conn.prepareStatement(sqlInterface);
			pstmtInterface.setString(1, refId);
			//pstmtInterface.setString(2, locCodeFrom);
			pstmtInterface.setString(2, bayNo);
			pstmtInterface.setString(3, refId);
			
			rsInterface = pstmtInterface.executeQuery();
			while(rsInterface.next())
			{	
				
				locCodeFrom = checkNullAndTrim(rsInterface.getString("PALLET_NO"));
				palletNo = checkNullAndTrim(rsInterface.getString("PALLET_NO"));
				lotNoFirst = checkNullAndTrim(rsInterface.getString("lot_no"));
				lotSlFirst = checkNullAndTrim(rsInterface.getString("lot_sl"));
				
				if("S-ORD".equalsIgnoreCase(refSer))//this is because sordalloc has char(3) in line_no
				{
					lineNoInterface = checkNullAndTrim(rsInterface.getString("LINE_NO"));
					lineNoInterface = "   " + lineNoInterface;
					lineNoInterface = lineNoInterface.substring( lineNoInterface.length()-3 );
				}
				else
				{
					lineNoInterface = checkNullAndTrim(rsInterface.getString("LINE_NO"));
				}
				System.out.println("Line number first is ["+lineNoInterface+"]Loc Code From ["+locCodeFrom+"]::lot no [" + lotNoFirst +"]::lot sl ::[" + lotSlFirst + "]");
				
				/*if(headerFlag)
				{	
					insertSql = "INSERT INTO STOCK_TRANSFER(TRAN_ID,TRAN_DATE,SITE_CODE,REF_SER__FOR,REF_ID__FOR,"+
							"REAS_CODE,ITEM_SER,CONFIRMED,"+
							"EMP_CODE__APRV,CHG_DATE,CHG_TERM,CHG_USER) "+
							"VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
					pstmtHdr = conn.prepareStatement(insertSql);
					tranID = generateTranTd("w_stock_transfer", currDateStr, loginSiteCode, conn);
					pstmtHdr.setString( 1, tranID );
					pstmtHdr.setTimestamp( 2, currDate );
					pstmtHdr.setString( 3, loginSiteCode );
					pstmtHdr.setString( 4, "XFRX");
					pstmtHdr.setString( 5, refId );
					pstmtHdr.setString( 6, "" );
					pstmtHdr.setString( 7, "" );
					pstmtHdr.setString( 8, "N" );
					pstmtHdr.setString( 9, "" );
					pstmtHdr.setTimestamp( 10, currDate );
					pstmtHdr.setString( 11, chgTerm );
					pstmtHdr.setString( 12, userId );
					updCnt = pstmtHdr.executeUpdate();
					pstmtHdr.close();
					pstmtHdr = null;
				}*/	

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refId);
				//pstmt.setString(2, lineNoInterface);
				/*if("D-SO".equalsIgnoreCase(refSer) && countDso > 0)
				{
					pstmt.setString(2, locCodeFrom);
					pstmt.setString(3, locCodeFrom+"X");
					pstmt.setString(4, locCodeFrom+"B");
					pstmt.setString(5, locCodeFrom+"P");
					pstmt.setString(6, lineNoInterface);
				}*/
				//else
					if("S-ORD".equalsIgnoreCase(refSer))
				{
					pstmt.setString(2, locCodeFrom);
					pstmt.setString(3, locCodeFrom+"X");
					pstmt.setString(4, locCodeFrom+"B");
					pstmt.setString(5, locCodeFrom+"P");
					pstmt.setString(6, lineNoInterface);
				}
				else if("PR".equalsIgnoreCase(refSer) || "PRS".equalsIgnoreCase(refSer))
				{
					pstmt.setString(2, lineNoInterface);
					//locCodeQuarnt = checkNullAndTrim(rsInterface.getString("PALLET_NO"));
					pstmt.setString(3, locCodeFrom+"Q");
					pstmt.setString(4, locCodeFrom+"U");
					pstmt.setString(5, locCodeFrom+"P");
					pstmt.setString(6, locCodeFrom+"M");
					pstmt.setString(7, locCodeFrom+"X");
					pstmt.setString(8, locCodeFrom+"B");
					pstmt.setString(9, locCodeFrom+"S");
					pstmt.setString(10,locCodeFrom+"R");//Changed by wasim on 19-04-2016 to consider rejected location from QC 
				}
				/*else
				{
					pstmt.setString(2, lineNoInterface);
				}*/
				
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					siteCode  = checkNullAndTrim(rs.getString("SITE_CODE"));
					System.out.println("Stock allocation site code ["+siteCode+"] Header Flag["+headerFlag+"]");
					
					//Changed by wasim on 15-07-2016 to set stock allocated site code in stock_transfer header [START]
					if(headerFlag)
					{	
						insertSql = "INSERT INTO STOCK_TRANSFER(TRAN_ID,TRAN_DATE,SITE_CODE,REF_SER__FOR,REF_ID__FOR,"+
								"REAS_CODE,ITEM_SER,CONFIRMED,"+
								"EMP_CODE__APRV,CHG_DATE,CHG_TERM,CHG_USER) "+
								"VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
						pstmtHdr = conn.prepareStatement(insertSql);
						tranID = generateTranTd("w_stock_transfer", currDateStr, siteCode, conn);
						pstmtHdr.setString( 1, tranID );
						pstmtHdr.setTimestamp( 2, currDate );
						pstmtHdr.setString( 3, siteCode );
						pstmtHdr.setString( 4, "XFRX");
						pstmtHdr.setString( 5, refId );
						pstmtHdr.setString( 6, "" );
						pstmtHdr.setString( 7, "" );
						pstmtHdr.setString( 8, "N" );
						pstmtHdr.setString( 9, "" );
						pstmtHdr.setTimestamp( 10, currDate );
						pstmtHdr.setString( 11, chgTerm );
						pstmtHdr.setString( 12, userId );
						updCnt = pstmtHdr.executeUpdate();
						pstmtHdr.close();
						pstmtHdr = null;
					}
					//Changed by wasim on 15-07-2016 to set stock allocated site code in stock_transfer header [END]
					
					lineNoList.add(lineNoInterface);
					
					isRecordExist = true;
					itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
					quantity   = rs.getDouble("QUANTITY");
					lotNo  = checkNullAndTrim(rs.getString("LOT_NO"));
					lotSl  = checkNullAndTrim(rs.getString("LOT_SL"));
					noArt  = checkNullAndTrim(rs.getString("NO_ART"));
					locCodeFrom  = checkNullAndTrim(rs.getString("LOC_CODE"));
					allocQty  = rs.getDouble("ALLOC_QTY");
					
					acctCodeInv  = checkNullAndTrim(rs.getString("ACCT_CODE__INV"));
					cctrCodeInv  = checkNullAndTrim(rs.getString("CCTR_CODE__INV"));
					
					if(countDso > 0 && "D-SO".equalsIgnoreCase(refSer))
					{	
						distOrderAlloc  = rs.getDouble("QTY_ALLOC");
					}
					if("S-ORD".equalsIgnoreCase(refSer))
					{
						sordAllocQty  = rs.getDouble("QTY_ALLOC");
					}
					
					System.out.println("Loc code to recieved=["+locCodeTo+"]Loc Code From["+locCodeFrom+"]PalletNo["+palletNo+"]");

					lineNo++;

					pstmtDet.setString( 1, tranID );
					pstmtDet.setInt( 2, lineNo );
					pstmtDet.setString( 3, itemCode );
					pstmtDet.setDouble( 4, quantity );
					pstmtDet.setString( 5, locCodeFrom );
					pstmtDet.setString( 6, locCodeTo );
					pstmtDet.setString( 7, lotNo );
					pstmtDet.setString( 8, lotNo );
					pstmtDet.setString( 9, lotSl );
					pstmtDet.setString( 10, lotSl );
					pstmtDet.setString( 11, acctCodeInv );
					pstmtDet.setString( 12, acctCodeInv );
					pstmtDet.setString( 13, cctrCodeInv );
					pstmtDet.setString( 14, cctrCodeInv );
					pstmtDet.setString( 15, noArt );

					updCnt = pstmtDet.executeUpdate();
					System.out.println("UPdate in stock transfer det="+updCnt);
					pstmtDet.clearParameters();

					System.out.println("@@Quantity=["+quantity+"]Alloc Qty=["+allocQty+"]");

					HashMap hashMap1 = new HashMap(); 
					hashMap1.put("tran_date", new java.sql.Date(System.currentTimeMillis()));
					hashMap1.put("ref_ser",refSer);
					hashMap1.put("ref_id", refId);
					hashMap1.put("ref_line", lineNoInterface);
					hashMap1.put("item_code", itemCode);
					hashMap1.put("site_code", siteCode);
					hashMap1.put("loc_code",locCodeFrom);
					hashMap1.put("lot_no",lotNo);
					hashMap1.put("lot_sl",lotSl);
					hashMap1.put("alloc_qty", (quantity-allocQty));
					hashMap1.put("chg_win","W_STOCK_TRANSFER_MULTI");
					hashMap1.put("chg_user", userId);
					hashMap1.put("chg_term", chgTerm);
					
					System.out.println("COUNTD_SO="+countDso);
					if("D-SO".equalsIgnoreCase(refSer) && countDso > 0)
					{	
						hashMap1.put("tran_type", rs.getString("TRAN_TYPE"));
						hashMap1.put("line_no_dist", rs.getString("LINE_NO_DIST"));
						hashMap1.put("exp_date", rs.getTimestamp("EXP_DATE"));
						hashMap1.put("unit", rs.getString("UNIT"));
						hashMap1.put("unit__alt", rs.getString("UNIT__ALT"));
						hashMap1.put("item_ser", rs.getString("ITEM_SER"));
						hashMap1.put("site_code__mfg", rs.getString("SITE_CODE__MFG"));
						hashMap1.put("mfg_date", rs.getTimestamp("MFG_DATE"));
						hashMap1.put("potency_perc", rs.getDouble("POTENCY_PERC"));
						hashMap1.put("quantity", rs.getDouble("DIST_QTY"));
						hashMap1.put("qty_alloc", rs.getDouble("ALLOC_QTY"));
						hashMap1.put("pack_code", rs.getString("PACK_CODE"));
						hashMap1.put("pack_instr", rs.getString("PACK_INSTR"));
						hashMap1.put("batch_no", rs.getString("BATCH_NO"));
						hashMap1.put("grade", rs.getString("GRADE"));
						hashMap1.put("gross_weight", rs.getDouble("GROSS_WEIGHT"));
						hashMap1.put("tare_weight", rs.getDouble("TARE_WEIGHT"));
						hashMap1.put("net_weight", rs.getDouble("NET_WEIGHT"));
						hashMap1.put("dimension", rs.getString("DIMENSION"));
						hashMap1.put("retest_date", rs.getTimestamp("RETEST_DATE"));
						hashMap1.put("supp_code__mfg", rs.getString("SUPP_CODE__MFG"));
						hashMap1.put("rate", rs.getString("RATE"));
						hashMap1.put("tax_class", rs.getString("TAX_CLASS"));
						hashMap1.put("tax_chap", rs.getString("TAX_CHAP"));
						hashMap1.put("tax_env", rs.getString("TAX_ENV"));
						hashMap1.put("loc_code__to", locCodeTo);
						hashMap1.put("no_art", rs.getString("NO_ART"));
						hashMap1.put("qty_per_art", rs.getDouble("QTY_PER_ART"));
						hashMap1.put("rate__clg", rs.getDouble("RATE__CLG" ));//added rate clg on 15-07-2016
						hashMap1.put("qty_shipped", rs.getDouble("QTY_SHIPPED" ));//added rate by wasim on 15-07-2016
						hashMap1.put("qty_confirm", rs.getDouble("QTY_CONFIRM"));//added rate by wasim on 15-07-2016
						DistStkList.add(hashMap1);
					}
					if("S-ORD".equalsIgnoreCase(refSer))
					{
						DespatchStkList.add(hashMap1);
					}
					
					if("PR".equalsIgnoreCase(refSer) || "PRS".equalsIgnoreCase(refSer) || "D-SO".equalsIgnoreCase(refSer) || "S-ORD".equalsIgnoreCase(refSer))
					{	
						if((quantity-allocQty) > 0)
						{	 
							distStkUpd = getComponent("DistStkUpd");
							if (distStkUpd.updAllocTrace(hashMap1, conn) > 0)
							{
								System.out.println("distStkUpd.UpdAllocTrace(HashMap, Connection) : Sucessuful!");
							}
						}	
					}
					
					if("D-SO".equalsIgnoreCase(refSer) || "S-ORD".equalsIgnoreCase(refSer) || "PR".equalsIgnoreCase(refSer) || "PRS".equalsIgnoreCase(refSer))
					{
						//HashMap allocation = new HashMap();
						ArrayList allocLocList = new ArrayList();

						System.out.println("Going for Allocation location code TO");
						HashMap hashMap = new HashMap(); 
						hashMap.put("tran_date", new java.sql.Date(System.currentTimeMillis()));
						hashMap.put("ref_ser",refSer);
						hashMap.put("ref_id", refId);
						hashMap.put("ref_line", lineNoInterface);
						hashMap.put("item_code", itemCode);
						hashMap.put("site_code", siteCode);
						hashMap.put("loc_code",locCodeTo);
						hashMap.put("lot_no",lotNo);
						hashMap.put("lot_sl",lotSl);
						hashMap.put("chg_win","W_STOCK_TRANSFER_MULTI");
						hashMap.put("chg_user", userId);
						hashMap.put("chg_term", chgTerm);

						if(("PRS".equalsIgnoreCase(refSer) || "PR".equalsIgnoreCase(refSer) || "D-SO".equalsIgnoreCase(refSer) || "S-ORD".equalsIgnoreCase(refSer)) && allocQty > 0)
						{
							allocLocList = checkStockAllocation(siteCode,itemCode,lotNo,lotSl,locCodeFrom,locCodeTo,conn);
							System.out.println("allocLocList stock found="+allocLocList.size());
							
							if("S-ORD".equalsIgnoreCase(refSer))
							{
								hashMap.put("alloc_qty", allocQty);
								hashMap.put("dealloc_qty", -sordAllocQty);
								allocList.add(hashMap);
							}
							else
							{
								hashMap.put("alloc_qty", allocQty);
								hashMap.put("dealloc_qty", -distOrderAlloc);
								allocList.add(hashMap);
							}
							locationList.add(allocLocList);
						}
					}

					//sqlUpdate = "UPDATE SWMS_TO_AWMS SET SCHEDULE_STATUS = 'Y' WHERE REF_ID = ? AND LINE_NO = ?";
					sqlUpdate = "UPDATE SWMS_TO_AWMS SET SCHEDULE_STATUS = 'Y' WHERE REF_ID = ? AND LINE_NO = ? AND PALLET_NO = ? and lot_no = ? and lot_sl = ?";
					pstmtUpdate = conn.prepareStatement(sqlUpdate);
					pstmtUpdate.setString(1, refId);
					pstmtUpdate.setString(2, lineNoInterface.trim());//this trim is for in case of S-ORD
					pstmtUpdate.setString(3, palletNo);
					pstmtUpdate.setString(4, lotNoFirst);
					pstmtUpdate.setString(5, lotSlFirst);
					int caseCount = pstmtUpdate.executeUpdate();
					System.out.println("Updated ="+caseCount);
					pstmtUpdate.close();pstmtUpdate = null;

					if("PR".equalsIgnoreCase(refSer) || "PRS".equalsIgnoreCase(refSer))
					{
						sqlUpdate = "UPDATE PALLET_REQ_DET SET STATUS = 'V' WHERE TRAN_ID = ? AND LINE_NO = ?";
						pstmtUpdate = conn.prepareStatement(sqlUpdate);
						pstmtUpdate.setString(1, refId);
						pstmtUpdate.setString(2, lineNoInterface);
						caseCount = pstmtUpdate.executeUpdate();
						System.out.println("Updated ="+caseCount);
						pstmtUpdate.close();pstmtUpdate = null;
					}

					headerFlag = false;
				}	
				pstmt.close();pstmt = null;
				rs.close();rs = null;

				/*if(("PR".equalsIgnoreCase(refSer) || "PRS".equalsIgnoreCase(refSer)) && isRecordExist)
				{	
					System.out.println(" created successfully PR/PRS Case---------------["+tranID+"]refId["+refId);
					headerFlag = true;
					//tranIdList.add(tranID);
					StockTransferConf stkConfAdd = new StockTransferConf();
					errString = stkConfAdd.confirm(tranID, xtraParams, "", conn, false);
					System.out.println("Stock transfer confirm for ===============PR/PRS="+errString);
					if( errString != null &&  errString.indexOf( "CONFSUCC" ) > -1)
					{
						errString = allocStockLocCodeTo(allocList,false,conn);
						System.out.println("Return from alloc To for PR/PRS="+errString);

						allocList.clear();

						System.out.println("Stock Transfer allocation on location code TO updated successfully");
						updateLocation(locationList,conn);
						locationList.clear();   
						conn.commit();
						
						errString = itmDBAccessEJB.getErrorString("","CONFSUCC","","",conn);
					}
					else
					{
						conn.rollback();
					}
				}*/
			}	
			pstmtInterface.close();pstmtInterface = null;
			rsInterface.close();rsInterface = null;

			//if(isRecordExist && (!"PR".equalsIgnoreCase(refSer) && !"PRS".equalsIgnoreCase(refSer)))
			if(isRecordExist)
			{	
				System.out.println("Inside record exist block------------");//CONFSUCC
				StockTransferConf stkConf = new StockTransferConf();
				errString = stkConf.confirm(tranID, xtraParams, "", conn, false);

				System.out.println("Return String from stock transfer===="+errString);//CONFSUCC

				if( errString != null &&  errString.indexOf( "CONFSUCC" ) > -1)
				{
					//errString = allocStockLocCodeTo(allocList,false,conn);//commented by azhar on 29-NOV-2016 as in post save DI it is getting allocated
					System.out.println("Return from alloc To="+errString);

						if("D-SO".equalsIgnoreCase(refSer) && countDso > 0)
						{
							updateLocation(locationList,conn);
							
							//errString = allocStockLocCodeTo(allocList,true,conn);//commented by azhar for firmplan
							
							System.out.println("For D-SO after stock transfer connection need to be committed....so connection committed");
							conn.commit();
							System.out.println("Going for Distribution issue");
							
							//Changed by wasim to change site code as stock allocated site code
							//errString = createDistIssue(loginSiteCode, refId, DistStkList, xtraParams, conn);
							errString = createDistIssue(siteCode, refId, DistStkList, xtraParams, conn);

							System.out.println("Return from dist issue"+errString);
							if( errString != null &&  (errString.indexOf( "Success" ) > -1 || errString.indexOf( "VTCONPARM" ) > -1))//VTCONPARM
							{
								System.out.println("Distribution issue created successfully---------");
								conn.commit();
								//errString = itmDBAccessEJB.getErrorString("","CONFSUCC","","",conn);
							}
							else
							{
								throw new Exception (errString);
							}
						}
						else if("S-ORD".equalsIgnoreCase(refSer))
						{
							//errString = createDespatch(refId,lineNoList,conn);//VTCONPARM
							//errString = allocStockLocCodeTo(allocList,true,conn);
							
							updateLocation(locationList,conn);
							
							System.out.println("For s-ord after stock transfer connection need to be committed....so connection committed");
							conn.commit();
							System.out.println("Going for Despatch");
							//errString = despatchOrder(refId,lineNoList,xtraParams,locCodeTo,conn);
							errString = despatchOrder(refId,DespatchStkList,xtraParams,locCodeTo,conn);
							System.out.println("Return from despatch"+errString);
							
							if( errString != null &&  errString.indexOf( "Success" ) > -1)
							{
								System.out.println("Despatch created successfully and commited");
								conn.commit();
								//errString = itmDBAccessEJB.getErrorString("","CONFSUCC","","",conn);
							}
							else
							{
								throw new Exception (errString);
							}
						}
						else if ("D-SO".equalsIgnoreCase(refSer))//D-SO is required if dist_issue already created then only stock transfer will be done
						{
							updateLocation(locationList,conn);
							conn.commit();
							System.out.println("Stock Transfer for D-SO completed successfully and committed");
							
							errString = itmDBAccessEJB.getErrorString("","CONFSUCC","","",conn);
						}
						else if ("PRS".equalsIgnoreCase(refSer) || "PR".equalsIgnoreCase(refSer))
						{
							updateLocation(locationList,conn);  
							conn.commit();
							System.out.println("Stock Transfer for PR/PRS completed successfully and committed");
							
							errString = itmDBAccessEJB.getErrorString("","CONFSUCC","","",conn);
						}
				}
				else
				{
					throw new Exception (errString);
				}
			}
			else
			{
				System.out.println("hiii");
				conn.rollback();
			}
		}
		catch(Exception e)
		{
			System.out.println("Stock Transfer Catch Received");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(pstmtHdr != null){pstmtHdr.close();pstmtHdr = null;}
				if(pstmtDet != null){pstmtDet.close();pstmtDet = null;}
				if(rs != null){rs.close();rs = null;}
				if(pstmtDso != null){pstmtDso.close();pstmtDso = null;}
				if(rsDso != null){rsDso.close();rsDso = null;}
			}
			catch(Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		return errString;
	}
	
	@SuppressWarnings("static-access")
	private String generateTranTd(String windowName,String tranDate,String siteCode, Connection  conn )throws ITMException
	{		
		System.out.println("inside generateTranTd@@.........");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String tranId = "";
		String tranSer1 = "",keyString = "",keyCol = "";
		CommonConstants commonConstants = new CommonConstants();
		try
		{		 	
			sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, windowName);

			rs = pstmt.executeQuery();
			System.out.println("keyString :"+sql);

			if (rs.next())
			{
				keyString = rs.getString(1);
				keyCol = rs.getString(2);
				tranSer1 = rs.getString(3);
			}
			else
			{
				sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "GENERAL");
				rs = pstmt.executeQuery();
				System.out.println("keyString :"+sql);				
				if (rs.next())
				{
					keyString = rs.getString(1);
					keyCol = rs.getString(2);
					tranSer1 = rs.getString(3);
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer1 :"+tranSer1);
			String xmlValues = "";
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +	"<tran_id></tran_id>";
			xmlValues = xmlValues + "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues + "<tran_date>"+ tranDate + "</tran_date>";
			xmlValues = xmlValues + "<tran_type>"+"U"+"</tran_type>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", commonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer1, keyCol, keyString, conn);

			System.out.println("tranId ::"+tranId);
		}
		catch (SQLException ex)
		{			
			System.out.println("Exception ::" +sql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{		
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}

		return tranId;
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	private ArrayList checkStockAllocation(String siteCode,String itemCode,String lotNo,String lotSl,String locCodeFrom,String locCodeTo,Connection conn)  throws ITMException, Exception
	{
		String tranId = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",tableName = "",lineNo = "",refSer = "",id = "",expLev = "";
		ArrayList allocLocList = new ArrayList();
		try
		{
			System.out.println("inside checkStockAllocation");

			sql = "SELECT EXP_LEV,SALE_ORDER,LOC_CODE,QUANTITY,LINE_NO FROM SORDALLOC WHERE SITE_CODE = ? AND ITEM_CODE = ? AND LOT_NO = ? AND LOT_SL = ?" 
					+" AND LOC_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, itemCode);
			pstmt.setString(3, lotNo);
			pstmt.setString(4, lotSl);
			pstmt.setString(5, locCodeFrom);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				tranId = checkNullAndTrim(rs.getString("SALE_ORDER"));
				//lineNo = checkNullAndTrim(rs.getString("LINE_NO"));//Changed by wasim on 11-01-2015 as sordalloc has char(3) line no
				lineNo = rs.getString("LINE_NO");
				expLev = rs.getString("EXP_LEV");
				
				tableName = "SORDALLOC";
				refSer = "S-ORD";
				id = "SALE_ORDER";
				HashMap hm = new HashMap();
				hm.put("LOC_CODE_NEW", locCodeTo);
				hm.put("LOC_CODE_OLD", locCodeFrom);//Added by wasim on 20-01-2016
				hm.put("LOT_NO", lotNo);//Added by wasim on 20-01-2016
				hm.put("LOT_SL", lotSl);//Added by wasim on 20-01-2016
				hm.put("SITE_CODE", siteCode);//Added by wasim on 20-01-2016
				hm.put("ITEM_CODE", itemCode);//Added by wasim on 20-01-2016
				hm.put("EXP_LEV", expLev);//Added by wasim on 20-01-2016
				
				hm.put("LINE_NO", lineNo);
				hm.put("TABLE", tableName);
				hm.put("TRAN_ID", tranId);
				hm.put("REF_SER", refSer);
				hm.put("ID", id);

				allocLocList.add(hm);
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("Found Allocation size in SORDALLOC="+allocLocList);

			sql = "SELECT D.DIST_ORDER,D.LOC_CODE,D.QUANTITY,D.LINE_NO FROM DISTORDER_ALLOC D,DISTORDER H WHERE H.SITE_CODE = ? AND D.ITEM_CODE = ? "
					+ " AND D.LOT_NO = ? AND D.LOT_SL = ? AND D.LOC_CODE = ? AND H.DIST_ORDER = D.DIST_ORDER";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, itemCode);
			pstmt.setString(3, lotNo);
			pstmt.setString(4, lotSl);
			pstmt.setString(5, locCodeFrom);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				tranId = checkNullAndTrim(rs.getString("DIST_ORDER"));
				lineNo = checkNullAndTrim(rs.getString("LINE_NO"));
				tableName = "DISTORDER_ALLOC";
				refSer = "D-SO";
				id = "DIST_ORDER";
				HashMap hm = new HashMap();
				hm.put("LOC_CODE_NEW", locCodeTo);
				hm.put("LOC_CODE_OLD", locCodeFrom);//Added by wasim on 20-01-2016
				hm.put("LOT_NO", lotNo);//Added by wasim on 20-01-2016
				hm.put("LOT_SL", lotSl);//Added by wasim on 20-01-2016
				hm.put("SITE_CODE", siteCode);//Added by wasim on 20-01-2016
				hm.put("ITEM_CODE", itemCode);//Added by wasim on 20-01-2016
				hm.put("LINE_NO", lineNo);
				hm.put("TABLE", tableName);
				hm.put("TRAN_ID", tranId);
				hm.put("REF_SER", refSer);
				hm.put("ID", id);

				allocLocList.add(hm);
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("New1 Allocation size="+allocLocList);

			sql = "SELECT D.TRAN_ID,D.LOC_CODE,D.QUANTITY,D.LINE_NO FROM DISTORD_ISSDET D,DISTORD_ISS H WHERE H.SITE_CODE = ? AND D.ITEM_CODE = ? AND D.LOT_NO = ?" 
					+" AND D.LOT_SL = ? AND D.LOC_CODE = ? AND H.TRAN_ID = D.TRAN_ID";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, itemCode);
			pstmt.setString(3, lotNo);
			pstmt.setString(4, lotSl);
			pstmt.setString(5, locCodeFrom);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				tranId = checkNullAndTrim(rs.getString("TRAN_ID"));
				lineNo = checkNullAndTrim(rs.getString("LINE_NO"));
				tableName = "DISTORD_ISSDET";
				refSer = "D-SO";
				id = "TRAN_ID";
				HashMap hm = new HashMap();
				hm.put("LOC_CODE_NEW", locCodeTo);
				hm.put("LOC_CODE_OLD", locCodeFrom);//Added by wasim on 20-01-2016
				hm.put("LOT_NO", lotNo);//Added by wasim on 20-01-2016
				hm.put("LOT_SL", lotSl);//Added by wasim on 20-01-2016
				hm.put("SITE_CODE", siteCode);//Added by wasim on 20-01-2016
				hm.put("ITEM_CODE", itemCode);//Added by wasim on 20-01-2016
				hm.put("LINE_NO", lineNo);
				hm.put("TABLE", tableName);
				hm.put("TRAN_ID", tranId);
				hm.put("REF_SER", refSer);
				hm.put("ID", id);

				allocLocList.add(hm);
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			
			System.out.println("Final Allocation size="+allocLocList);

			/*hm.put("LOC_CODE_NEW", locCodeTo);
			hm.put("LINE_NO", lineNo);
			hm.put("TABLE", tableName);
			hm.put("TRAN_ID", tranId);
			hm.put("REF_SER", refSer);
			hm.put("ID", id);*/
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(rs != null){rs.close();rs = null;}
			}
			catch(Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		return allocLocList;
	}
	@SuppressWarnings("rawtypes")
	private String updateLocation(ArrayList locList,Connection conn)  throws ITMException, Exception
	{
		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",tableName = "",locCode = "",tranId = "",id = "",lineNo = "",locCodeOld = "";
		String retString = "",lotNo = "",lotSl = "",itemCode = "",expLev = "";
		int updCount = 0;
		try
		{
			System.out.println("inside updateLocation");

			Iterator itr = locList.iterator();
			System.out.println("Array Total size="+locList.size());

			while(itr.hasNext())
			{  
				ArrayList mainList = new ArrayList();
				mainList = (ArrayList) itr.next();

				Iterator itrMain = mainList.iterator();

				System.out.println("Main Array List size="+mainList.size());
				while(itrMain.hasNext())
				{
					HashMap detail = new HashMap();
					detail = (HashMap) itrMain.next();

					if(detail.size() > 0)
					{	  
						tableName = (String) detail.get("TABLE");
						locCode = (String) detail.get("LOC_CODE_NEW");
						locCodeOld = (String) detail.get("LOC_CODE_OLD");//Changed by wasim on 20-1-2016
						
						lotNo = (String) detail.get("LOT_NO");//Changed by wasim on 20-1-2016
						lotSl = (String) detail.get("LOT_SL");//Changed by wasim on 20-1-2016
						itemCode = (String) detail.get("ITEM_CODE");//Changed by wasim on 20-1-2016
						
						lineNo = (String) detail.get("LINE_NO");
						tranId = (String) detail.get("TRAN_ID");
						id = (String) detail.get("ID");

						lineNo = "   " + lineNo;
						lineNo = lineNo.substring( lineNo.length()-3 );

						//sql = "UPDATE "+tableName+" SET LOC_CODE = ? WHERE "+id+" = ? AND LINE_NO = ?";
						System.out.println("Table["+tableName+"]");
						
						if("SORDALLOC".equalsIgnoreCase(tableName))
						{
							expLev = (String) detail.get("EXP_LEV");//Changed by wasim on 20-1-2016
							
							sql = "UPDATE "+tableName+" SET LOC_CODE = ? WHERE "+id+" = ? AND LINE_NO = ? AND LOC_CODE = ?"
									+ " AND LOT_NO = ? AND LOT_SL = ? AND ITEM_CODE = ? AND EXP_LEV = ?";
						}
						else
						{
							sql = "UPDATE "+tableName+" SET LOC_CODE = ? WHERE "+id+" = ? AND LINE_NO = ? AND LOC_CODE = ?"
									+ " AND LOT_NO = ? AND LOT_SL = ? AND ITEM_CODE = ?";
						}
						
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, locCode);
						pstmt.setString(2, tranId);
						pstmt.setString(3, lineNo);
						pstmt.setString(4, locCodeOld);
						
						pstmt.setString(5, lotNo);
						pstmt.setString(6, lotSl);
						pstmt.setString(7, itemCode);
						if("SORDALLOC".equalsIgnoreCase(tableName))
						{
							pstmt.setString(8, expLev);
						}
						
						updCount = pstmt.executeUpdate();
						System.out.println("Update="+updCount);
						pstmt.clearParameters();
					}  
				}
			}	
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(rs != null){rs.close();rs = null;}
			}
			catch(Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		return retString;
	}
	
	//public String createDistIssue(String siteCode, String distOrderNo, ArrayList DistStkList, String tranId, boolean headerFlag, String xtraParams, Connection conn) throws RemoteException, ITMException
	@SuppressWarnings("rawtypes")
	public String createDistIssue(String siteCode, String distOrderNo, ArrayList DistStkList, String xtraParams, Connection conn) throws RemoteException, ITMException									
	{
		StringBuffer xmlBuff = new StringBuffer();

		String xmldetail1 = null;
		StringBuffer detail2xml = new StringBuffer();
		StringBuffer xmldetail2ftr = new StringBuffer();
		xmldetail2ftr.append("</Detail2>");
		//String distOrderNo = null;
		String sql = null,tranDate = null,locCode = null,retString = "",tranType = "";
		PreparedStatement pstmt = null; PreparedStatement pstmt1 = null; PreparedStatement pstmt2 = null,distIssDetPstmt = null,pstmtHdr = null;
		ResultSet rs = null; ResultSet rs1 = null; ResultSet rs2 = null; ResultSet rs3 = null;
		Statement stmt1 = null;

		int count = 0,linenoCtr = 0;
		double minputQty = 0.0D; double integralQty = 0.0D;
		double grossPer = 0.0D; double netPer = 0.0D; double tarePer = 0.0D; double grossWt = 0.0D; double netWt = 0.0D; double tareWt = 0.0D; double rateClgVal = 0.0D; double rate2 = 0.0D;
		double disAmount = 0.0D; double amount = 0.0D; double shipperQty = 0.0D; double discount = 0.0D,qtyPerArtStock = 0.0D;
		
		double lcQtyOrderAlt = 0.0D; double lcFact = 0.0D;
		String siteCodeMfg = ""; String sundryCode = ""; double potencyPerc = 0;
		String priceList = ""; String tabValue = ""; String priceListClg = "";  
		String rate = ""; 
		String itemCode = ""; 
		String checkIntegralQty = ""; String rate1 = ""; double quantity = 0d;
		String active = ""; String itemDescr = ""; String errCode = ""; String sql2 = ""; int noArt = 0;
		String detail2stock = ""; String errString = ""; String taxChap = ""; 
		String lotNo = ""; String lotSl = ""; String packCode = ""; String rateClg = ""; String taxEnv = ""; String taxClass = "";
		java.util.Date expDate = null; java.util.Date mfgDate = null; 
		StringBuffer xmldetail2stock = null;
		int countDtl = 0;
		int noArt1 = 0; int mLineNoDist = 0;
		String batchNo = "",grade = "",dimension = "",suppCodeMfg = "",packInstr = "",descr = "",xmlString = "",unitAlt = "",unit = "",tranID = "",processXml = "";
		Timestamp retestDate = null;
		int lineNoDet = 0, noArtStock = 0;
		CreateDistOrder distOrder = new CreateDistOrder();
		String tLocCode = "", tLotSl = "";

		try
		{
			System.out.println("Inside Create Distribution issue");

			SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
			SimpleDateFormat dbf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());

			tranDate = getCurrdateAppFormat();

			//locCode = distComm.getDisparams("999999", "D-SO", conn);Changed by wasim on 11-01-2015 as code is migrated from schdular.

			Iterator itr = DistStkList.iterator();
			System.out.println("Array Total size="+DistStkList.size());
			System.out.println("List for DI::::" + DistStkList.toString());
			
			/*result = mfgc.getEnvMfg("999999", "IS_CREATE_DI", conn);
			
			System.out.println("result from disparm:::" + result);
			
			sql = "select tran_id from distord_iss where dist_order = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, distOrderNo);
			rs = pstmt.executeQuery();
			if(rs.next()){
				tranID = rs.getString("tran_id");
			}
			tranID = tranID == null ? "" : tranID.trim();
			System.out.println("tran id::::" + tranID);
			
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			
			if(tranID.length()>0){
				
			sql = "select max(line_no) as line_no from distord_issdet where dist_order = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, distOrderNo);
			rs = pstmt.executeQuery();
			if(rs.next()){
				 lineNoDet = rs.getInt("line_no");
			}
			
			System.out.println("line no in detail::::" + lineNoDet);
			
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			}*/
			
			sql = "select tran_id from distord_iss where dist_order = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, distOrderNo);
			rs = pstmt.executeQuery();
			if(rs.next()){
				tranID = rs.getString("tran_id");
			}
			tranID = tranID == null ? "" : tranID.trim();
			System.out.println("tran id::::" + tranID);
			
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			
			if(tranID.length() > 0){
				retString = "Success";
				return retString;
			}
			if(tranID.length()>0){
				
			sql = "select max(line_no) as line_no from distord_issdet where dist_order = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, distOrderNo);
			rs = pstmt.executeQuery();
			if(rs.next()){
				 lineNoDet = rs.getInt("line_no");
			}
			
			System.out.println("line no in detail::::" + lineNoDet);
			
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			}
			
			while(itr.hasNext())
			{ 
				HashMap stkMap = new HashMap();
				stkMap = (HashMap) itr.next();

				tranType = checkNullAndTrim((String) stkMap.get("tran_type"));
				mLineNoDist = Integer.parseInt((String) stkMap.get("line_no_dist"));
				siteCode = checkNullAndTrim((String) stkMap.get("site_code"));
				itemCode = checkNullAndTrim((String) stkMap.get("item_code"));
				lotNo = checkNullAndTrim((String) stkMap.get("lot_no"));
				lotSl = checkNullAndTrim((String) stkMap.get("lot_sl"));
				//siteCode = (String) stkMap.get("loc_code");
				quantity = (Double) stkMap.get("quantity");
				expDate = (Date) stkMap.get("exp_date");
				System.out.println("::exp date::" + expDate);
				unit = checkNullAndTrim((String) stkMap.get("unit"));
				unitAlt = checkNullAndTrim((String) stkMap.get("unit__alt"));
				siteCodeMfg = checkNullAndTrim((String) stkMap.get("site_code__mfg"));
				mfgDate = (Date) stkMap.get("mfg_date");
				System.out.println("::mfg date::" + mfgDate);
				potencyPerc = (Double) stkMap.get("potency_perc");
				packCode = checkNullAndTrim((String) stkMap.get("pack_code"));
				packInstr = checkNullAndTrim((String) stkMap.get("pack_instr"));
				batchNo = checkNullAndTrim((String) stkMap.get("batch_no"));
				grade = checkNullAndTrim((String) stkMap.get("grade"));
				grossWt = (Double) stkMap.get("gross_weight");
				tareWt = (Double) stkMap.get("tare_weight");
				netWt = (Double) stkMap.get("net_weight");
				dimension = checkNullAndTrim((String) stkMap.get("dimension"));
				//retestDate = (Date) stkMap.get("retest_date");
				suppCodeMfg = checkNullAndTrim((String) stkMap.get("supp_code__mfg"));
				rate = checkNullAndTrim((String) stkMap.get("rate"));
				taxClass = checkNullAndTrim((String) stkMap.get("tax_class"));
				taxChap = checkNullAndTrim((String) stkMap.get("tax_chap"));
				taxEnv = checkNullAndTrim((String) stkMap.get("tax_env"));
				locCode = checkNullAndTrim((String) stkMap.get("loc_code__to"));
				noArtStock =  Integer.parseInt((String) stkMap.get("no_art"));
				qtyPerArtStock = (Double) stkMap.get("qty_per_art"); 
				
				System.out.println("item code ::[" +itemCode+"]:::sitecode:::[" +siteCode+"]:::no of articles:::["+noArtStock+"]::qty per art::[" +qtyPerArtStock + "]");
				
				rateClg = Double.toString((Double) stkMap.get("rate__clg"));//added by wasim to get rate clg from distorder det
				StringBuffer xmldetail2hdr = new StringBuffer();
				xmldetail2hdr.append("<Detail2 dbID=\"\" domID=\"1\" objName=\"dist_order_post\" objContext=\"2\">");
				xmldetail2hdr.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
				if(tranID.length() > 0){
					
					xmldetail2hdr.append("<tran_id><![CDATA[" + tranID + "]]></tran_id>");;
				}else{
					
					xmldetail2hdr.append("<tran_id/>");	
				}
				xmldetail2hdr.append("<tran_id/>");
				xmldetail2hdr.append("<dist_order><![CDATA[" + distOrderNo + "]]></dist_order>");
				xmldetail2hdr.append("<line_no_dist_order><![CDATA[" + mLineNoDist + "]]></line_no_dist_order>");
				
				//xmldetail2hdr.append(getDetails(siteCode, mLineNoDist, distOrderNo, tranType, conn));
				xmldetail2hdr.append("<item_code><![CDATA[" + itemCode + "]]></item_code>");
				xmldetail2hdr.append("<tax_class><![CDATA[" + taxClass + "]]></tax_class>");
				xmldetail2hdr.append("<tax_chap><![CDATA[" + taxChap + "]]></tax_chap>");
				xmldetail2hdr.append("<tax_env><![CDATA[" + taxEnv + "]]></tax_env>");
				
				sql = " SELECT (CASE WHEN ACTIVE IS NULL THEN 'Y' ELSE ACTIVE END) ACT, MIN_SHELF_LIFE,  (CASE WHEN TRACK_SHELF_LIFE IS NULL THEN 'N' ELSE TRACK_SHELF_LIFE END) TRK_SHELF_LIFE,  (CASE WHEN SUPP_SOUR IS NULL THEN 'M' ELSE SUPP_SOUR END) SUP_SOUR, DESCR  FROM ITEM WHERE ITEM_CODE = '" + 
						itemCode + "' ";
				pstmt1 = conn.prepareStatement(sql);
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					active = rs1.getString(1);
					itemDescr = rs1.getString(5);
					if (active.equals("N"))
					{
						errCode = "VTITEM4";
						errString = itmDBAccessEJB.getErrorString("", errCode, "", "", conn);
						return errString;
					}
				}
				rs1.close();rs1 = null;
				pstmt1.close();pstmt1 = null;
				
				sql = " SELECT SUNDRY_CODE, PRICE_LIST, PRICE_LIST__CLG, SITE_CODE__SHIP  FROM DISTORDER WHERE DIST_ORDER = '" + 
						distOrderNo + "' ";
				pstmt1 = conn.prepareStatement(sql);
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					sundryCode = rs1.getString("SUNDRY_CODE");
					priceList = rs1.getString("PRICE_LIST");
					priceListClg = rs1.getString("PRICE_LIST__CLG");
				}
				rs1.close();rs1 = null;
				pstmt1.close();pstmt1 = null;
				
				//stockQty = quantity - allocQty;
				minputQty = quantity;
				
				  //Changed########### by wasim on 15-07-2016 [START] 
					if (tranType != null && tranType.trim().length() > 0)
					{
						sql = "SELECT CHECK_INTEGRAL_QTY, TRAN_TYPE__PARENT FROM DISTORDER_TYPE WHERE TRAN_TYPE = '"+tranType+"' ";
						pstmt1   = conn.prepareStatement(sql);
						rs1 = pstmt1.executeQuery();
						if (rs1.next())
						{
							checkIntegralQty = rs1.getString( 1 );
							if (checkIntegralQty == null || checkIntegralQty.trim().length() == 0)
							{
								checkIntegralQty = "Y";
							}
						}
						rs1.close();
						rs1 = null;
						pstmt1.close();
						pstmt1 = null;
					}
					
					if (!checkIntegralQty.equals("N"))
					{
						integralQty = getIntegralQty( siteCode, itemCode, lotNo, packCode, checkIntegralQty );
						System.out.println("Integral quantiity"+integralQty);
						
						if (integralQty <= 0)
						{
							errCode = "VINTGRLQTY";
							errString = itmDBAccessEJB.getErrorString( "", errCode, "", "", conn);
							return errString;
						}
					}
					
					rate1 = rate;
					if (rate1.equals(""))
					{
						rate1 = "0";
					}
					System.out.println("rate1----"+rate1+"---priceList----"+priceList);
				//#########Changed by wasim on 15-07-2016 [END] 
				
				if (Double.parseDouble(rate1) == 0.0D)
				{
					if ((priceList != null) && (priceList.trim().length() > 0))
					{
						sql2 = "SELECT COUNT(*) FROM PRICELIST WHERE PRICE_LIST = '" + 
								priceList + "'  AND LIST_TYPE = 'I' ";
						pstmt2 = conn.prepareStatement(sql2);
						rs2 = pstmt2.executeQuery();
						if (rs2.next())
						{
							count = rs2.getInt(1);
						}
						rs2.close();
						rs2 = null;
						pstmt2.close();
						pstmt2 = null;

						if (count == 0)
						{
							rate2 = distComm.pickRate(priceList, tranDate, itemCode, lotNo, "D", conn);
							System.out.println("printing rate2----" + rate2);
						}
						else
						{
							tabValue = siteCode + "~t" + locCode + "~t" + lotNo + "~t";
							System.out.println("printing tabValue----" + tabValue);

							rate2 = distComm.pickRate(priceList, tranDate, itemCode, tabValue, "I", conn);
							System.out.println("printing rate2----" + rate2);
						}
					}

					rate1 = Double.toString(rate2);
				}
				
				//Changed by wasim on 15-07-2016for rate clg [START]
				if (priceListClg != null && priceListClg.trim().length() > 0 )
				{
					//rateClgVal = distComm.pickRate(priceListClg, tranDate, itemCode, rs1.getString(1),"D",conn);
					rateClgVal = distComm.pickRate(priceListClg, tranDate, itemCode, lotNo,"D",conn);
					System.out.println("rateClgVal----"+rateClgVal);
					if (rateClgVal <= 0)
					{
						rateClgVal = Double.parseDouble(rate);
					}
				}
				else
				{
					rateClgVal= Double.parseDouble(rateClg);
				}
				System.out.println("@@Final rate clg="+rateClgVal);
				//Changed by wasim on 15-07-2016for rate clg [START]
				
				System.out.println("My quantity="+minputQty);
				
				if (minputQty > 0.0D)
				{
					grossPer = grossWt / minputQty;
					netPer = netWt / minputQty;
					tarePer = tareWt / minputQty;

					grossWt = minputQty * grossPer;
					netWt = minputQty * netPer;
					tareWt = minputQty * tarePer;
				}

				disAmount = amount * (discount / 100.0D);

				 noArt1 = 0;
				 System.out.println("First time:::sitecode:: [" + siteCode + "]::sundryCode::[" + sundryCode + "]::itemcode::["+ itemCode +"]:::" +
				 		"packcode::["+packCode+"]::minput qty::["+minputQty+"]::shipper qty::["+shipperQty+"]::integral qty::[" +integralQty+"]:::");
				    noArt1 = getNoArt(siteCode, sundryCode, itemCode, packCode, minputQty, 'B', shipperQty, integralQty);
				  //noArt1 = getNoArt(siteCode, sundryCode, itemCode, packCode, quantity, 'B', shipperQty, integralQty);
				
				noArt = noArt1;
				System.out.println("%^%^%^%^%^%NoArt is&***&*&*&*&[" + noArt + "]");

				double shipperSize = 0.0D; double shipQty = 0.0D; double noArt11 = 0.0D; double remainder = 0.0D;
				double integralqty = 0.0D;
				double noArt12 = 0.0D; double acShipperQty = 0.0D; double acIntegralQty = 0.0D;
				stmt1 = conn.createStatement();
				sql = "select (case when shipper_size is null then 0 else shipper_size end) shipper_size from item_lot_packsize where item_code = '" + 
						itemCode + "'" + 
						" and  '" + lotNo + "' >= lot_no__from " + 
						" and  '" + lotNo + "'  <= lot_no__to ";
				System.out.println("sql :" + sql);
				rs3 = stmt1.executeQuery(sql);
				if (rs3.next())
				{
					shipperSize = rs3.getDouble(1);
				}
				System.out.println("shipperSize .............:" + shipperSize);
				System.out.println("minputQty .............:" + quantity);
				if (shipperSize > 0.0D)
				{
					shipQty = shipperSize;
					noArt11 = (minputQty - minputQty % shipQty) / shipQty;
					//noArt11 = (quantity - quantity % shipQty) / shipQty;
					System.out.println("noArt11 .............:" + noArt11);
					remainder = minputQty % shipQty;
					//remainder = quantity % shipQty;
					System.out.println("remainder .............:" + remainder);
					sql = "select ( case when integral_qty is null then 0 else integral_qty end) integral_qty from customeritem where cust_code = '" + 
							sundryCode + "' and item_code ='" + itemCode + "'";
					System.out.println("sql :" + sql);
					rs3 = stmt1.executeQuery(sql);
					if (rs3.next())
					{
						integralqty = rs3.getDouble(1);
					}

					System.out.println("integralqty .............:" + integralqty);
					if (integralqty == 0.0D)
					{
						sql = "select  ( case when integral_qty is null then 0 else integral_qty end) integral_qty from siteitem where site_code = '" + 
								siteCode + "' and item_code ='" + itemCode + "'";
						System.out.println("sql :" + sql);
						rs3 = stmt1.executeQuery(sql);
						if (rs3.next())
						{
							integralqty = rs3.getDouble(1);
						}

						if (integralqty == 0.0D)
						{
							sql = "select ( case when integral_qty is null then 0 else integral_qty end) integral_qty from item where item_code ='" + 
									itemCode + "'";
							System.out.println("sql :" + sql);
							rs3 = stmt1.executeQuery(sql);
							if (rs3.next())
							{
								integralqty = rs3.getDouble(1);
							}
						}
					}

					System.out.println("integralqty .............:" + integralqty);
					if (integralqty > 0.0D)
					{
						noArt12 = (remainder - remainder % integralqty) / integralqty;
					}
					if (noArt12 > 0.0D)
					{
						noArt12 = 1.0D;
					}

					noArt1 = (int)(noArt11 + noArt12);
					noArt = noArt1;
					System.out.println("noArt .............:" + noArt);
					acShipperQty = shipQty;
					acIntegralQty = integralqty;
				}
				if (shipperSize == 0.0D)
				{
					noArt1 = getNoArt(siteCode, sundryCode, itemCode, packCode, minputQty, 'B', acShipperQty, acIntegralQty);
					//noArt1 = getNoArt(siteCode, sundryCode, itemCode, packCode, quantity, 'B', acShipperQty, acIntegralQty);
					noArt = noArt1;
				}
				
				if(quantity <= qtyPerArtStock){
					noArtStock = 1;
				}
				
				System.out.println("Second time:::sitecode:: [" + siteCode + "]::sundryCode::[" + sundryCode + "]::itemcode::["+ itemCode +"]:::" +
				 		"packcode::["+packCode+"]::minput qty::["+minputQty+"]::shipper qty::["+shipperQty+"]::integral qty::[" +integralQty+"]:::");
				lcFact = 0.0D;
				ArrayList QtyFactorList = new ArrayList();

				QtyFactorList = distComm.convQtyFactor(unitAlt, unit, itemCode, minputQty, lcFact, conn);
				//QtyFactorList = distComm.convQtyFactor(unitAlt, unit, itemCode, quantity, lcFact, conn);
				lcQtyOrderAlt = ((Double)QtyFactorList.get(1)).doubleValue();
				lcFact = ((Double)QtyFactorList.get(0)).doubleValue();
				System.out.println("List receved="+QtyFactorList);
				QtyFactorList = null;

				xmldetail2stock = new StringBuffer();

				
				lineNoDet++;
				linenoCtr++;
				countDtl++;
				System.out.println("Line number issue= "+linenoCtr);
				System.out.println("Line number in manual DI= "+lineNoDet);
				
				/*if(tranID.length() > 0){
				xmldetail2stock.append("<line_no><![CDATA[" + lineNoDet + "]]></line_no>");
				}else{
					xmldetail2stock.append("<line_no><![CDATA[" + linenoCtr + "]]></line_no>");	
				}
				if(result.equalsIgnoreCase("YES")){
					xmldetail2stock.append("<remarks><![CDATA[" + remarksTobeSet + "]]></remarks>");
				}*/
				
				 if(tranID.length() > 0){
					xmldetail2stock.append("<line_no><![CDATA[" + lineNoDet + "]]></line_no>");
					}else{
						xmldetail2stock.append("<line_no><![CDATA[" + linenoCtr + "]]></line_no>");	
					}
				//xmldetail2stock.append("<line_no><![CDATA[" + linenoCtr + "]]></line_no>");
				xmldetail2stock.append("<item_descr>").append("<![CDATA[").append(itemDescr == null ? "" : itemDescr).append("]]>").append("</item_descr>\r\n");
				xmldetail2stock.append("<location_descr>").append("<![CDATA[").append(descr).append("]]>").append("</location_descr>\r\n");
				xmldetail2stock.append("<unit>").append("<![CDATA[").append(unit).append("]]>").append("</unit>\r\n");
				xmldetail2stock.append("<unit__alt>").append("<![CDATA[").append(unitAlt).append("]]>").append("</unit__alt>\r\n");
				xmldetail2stock.append("<conv__qty__alt>").append("<![CDATA[").append(lcFact).append("]]>").append("</conv__qty__alt>\r\n");
				xmldetail2stock.append("<qty_order__alt>").append("<![CDATA[").append(lcQtyOrderAlt).append("]]>").append("</qty_order__alt>\r\n");
				 //tLocCode = "";
				tLocCode = locCode;
				tLocCode = tLocCode == null ? "" : tLocCode.trim();
				xmldetail2stock.append("<loc_code>").append("<![CDATA[").append(tLocCode == null ? "" : tLocCode.trim()).append("]]>").append("</loc_code>\r\n");

				xmldetail2stock.append("<rate>").append("<![CDATA[").append(rate).append("]]>").append("</rate>\r\n");
				xmldetail2stock.append("<rate__clg>").append("<![CDATA[").append(rateClgVal).append("]]>").append("</rate__clg>\r\n");
				xmldetail2stock.append("<quantity>").append("<![CDATA[").append(quantity).append("]]>").append("</quantity>\r\n");
				xmldetail2stock.append("<amount>").append("<![CDATA[").append(quantity * Double.parseDouble(rate1)).append("]]>").append("</amount>\r\n");
				 //tLotSl = null;
				tLotSl = lotSl;
				tLotSl = tLotSl == null ? "" : tLotSl.trim();
				xmldetail2stock.append("<lot_sl>").append("<![CDATA[").append(tLotSl == null ? "    " : tLotSl).append("]]>").append("</lot_sl>\r\n");
				xmldetail2stock.append("<pack_code>").append("<![CDATA[").append(packCode == null ? "" : packCode).append("]]>").append("</pack_code>\r\n");
				xmldetail2stock.append("<disc_amt>").append("<![CDATA[").append(disAmount).append("]]>").append("</disc_amt>\r\n");

				grossWt = Double.parseDouble(getFormatedValue(grossWt, 3));

				xmldetail2stock.append("<gross_weight>").append("<![CDATA[").append(grossWt).append("]]>").append("</gross_weight>\r\n");
				netWt = Double.parseDouble(getFormatedValue(netWt, 3));

				xmldetail2stock.append("<net_weight>").append("<![CDATA[").append(netWt).append("]]>").append("</net_weight>\r\n");
				tareWt = Double.parseDouble(getFormatedValue(tareWt, 3));

				xmldetail2stock.append("<tare_weight>").append("<![CDATA[").append(tareWt).append("]]>").append("</tare_weight>\r\n");
				xmldetail2stock.append("<pack_instr>").append("<![CDATA[").append(packInstr == null ? "" : packInstr).append("]]>").append("</pack_instr>\r\n");
				xmldetail2stock.append("<retest_date>").append("<![CDATA[").append(retestDate == null ? "" : sdf.format(retestDate)).append("]]>").append("</retest_date>\r\n");
				xmldetail2stock.append("<dimension>").append("<![CDATA[").append(dimension == null ? "" : dimension).append("]]>").append("</dimension>\r\n");
				xmldetail2stock.append("<supp_code__mfg>").append("<![CDATA[").append(suppCodeMfg == null ? "" : suppCodeMfg).append("]]>").append("</supp_code__mfg>\r\n");
				xmldetail2stock.append("<site_code__mfg>").append("<![CDATA[").append(siteCodeMfg == null ? "" : siteCodeMfg).append("]]>").append("</site_code__mfg>\r\n");
				xmldetail2stock.append("<mfg_date>").append("<![CDATA[").append(mfgDate == null ? "" : sdf.format(mfgDate)).append("]]>").append("</mfg_date>\r\n");
				xmldetail2stock.append("<exp_date>").append("<![CDATA[").append(expDate == null ? "" : sdf.format(expDate)).append("]]>").append("</exp_date>\r\n");
				xmldetail2stock.append("<potency_perc>").append("<![CDATA[").append(potencyPerc).append("]]>").append("</potency_perc>\r\n");
				//xmldetail2stock.append("<no_art>").append("<![CDATA[").append(noArt).append("]]>").append("</no_art>\r\n"); commented by azhar as told by manoj sir after discussion with manoharan sir[26-dec-2016]
				xmldetail2stock.append("<no_art>").append("<![CDATA[").append(noArtStock).append("]]>").append("</no_art>\r\n");
				xmldetail2stock.append("<batch_no>").append("<![CDATA[").append(batchNo == null ? "" : batchNo).append("]]>").append("</batch_no>\r\n");
				xmldetail2stock.append("<grade>").append("<![CDATA[").append(grade == null ? "" : grade).append("]]>").append("</grade>\r\n");
				xmldetail2stock.append("<lot_no>").append("<![CDATA[").append(lotNo == null ? "               " : lotNo).append("]]>").append("</lot_no>\r\n");
				detail2stock = xmldetail2stock.toString();
				xmldetail2stock = null;

				detail2xml.append(xmldetail2hdr.toString());
				detail2xml.append(detail2stock);
				detail2xml.append(xmldetail2ftr.toString());
				System.out.println("xmlString detail2......" + detail2xml.toString());

				noArt1 = 0;
				grossWt = 0.0D;
				tareWt = 0.0D;
				netWt = 0.0D;
			}//End iterator

			//added by azhar [START][W16HSUN001]
			
			
			
			/*System.out.println("value in mfgparm::: " + result);
			
			if(!result.equalsIgnoreCase("YES") && tranID.length() > 0){
			
			
				sql = "select inv_stat from location where loc_code in (select loc_code from distord_issdet where dist_order = ?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, distOrderNo);
				rs = pstmt.executeQuery();
				while(rs.next()){
					
					invStat = rs.getString("inv_stat");
					invStat = invStat == null ? "" : invStat.trim();
					System.out.println("::inv stat from DI:: " + invStat);
					invMap = new HashMap();
					invMap.put("inv_stat" , invStat);
				}
			
			System.out.println(":::::inv stat in map:: " + invMap.toString());
			
			if(!invMap.containsValue("AWMS") || !invMap.containsValue("AWMSQ")){
				 processXml = getXmlInEditMode(tranID,xtraParams,conn, "dist_order_post");
				 System.out.println("Process xml in edit mode::" +processXml);//TODO append process xml to detail2xml
				 String tempXml = processXml.substring(0, processXml.lastIndexOf("</Detail2>") + 10).concat(detail2xml.toString()).concat(processXml.substring(processXml.lastIndexOf("</Detail2>")+10));
				 xmlBuff = new StringBuffer();
				 xmlBuff.append(tempXml.substring(0, tempXml.indexOf("<Header0>") + 9));
			        xmlBuff.append("<objName><![CDATA[").append("dist_order_post").append("]]></objName>");
			        xmlBuff.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
			        xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
			        xmlBuff.append("<editFlag><![CDATA[").append("E").append("]]></editFlag>");
			        xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
			        xmlBuff.append("<action><![CDATA[").append("SAVE").append("]]></action>");
			        xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
			        xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
			        xmlBuff.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
			        xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
			        xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
			        xmlBuff.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
			        xmlBuff.append(tempXml.substring(tempXml.indexOf("<Header0>") + 9, tempXml.indexOf("</Header0>")));
			        //xmlBuff.append(detail2xml);
			        xmlBuff.append(tempXml.substring(tempXml.indexOf("</Header0>")));
			        System.out.println("xmlBuff::::"+xmlBuff.toString());
			        xmlString = xmlBuff.toString().trim();
					xmlBuff = null;
					System.out.println(":::xmlString:::"+xmlString);
					System.out.println("::::::::::xmlString for MasterStatefulEJB for Processing::::::::::" + xmlString.trim());
					if (xmlString.contains("Detail2"))
					{
						retString = distOrder.saveData(siteCode, xmlString, conn);
						System.out.println("After save data distribution issue"+retString);
						if (retString.indexOf("Success") > -1)
						{
							System.out.println("Successfully saved");
							//retString = "VTCONPARM";
						}
					} //TODO  call save data
			} 
			else{
			
				xmlBuff = null;
			xmlBuff = new StringBuffer();
			xmldetail1 = createHeader(siteCode, distOrderNo,xtraParams, conn);
			xmlBuff.append(xmldetail1.toString());
			xmlBuff.append(detail2xml.toString());
			xmlBuff.append("</Header0>");
			xmlBuff.append("</group0>");
			xmlBuff.append("</DocumentRoot>");
			xmlString = xmlBuff.toString();
			System.out.println("xmlString------" + xmlString);
			
			}
			
			}else if(!result.equalsIgnoreCase("YES") && tranID.length() == 0){
				xmlBuff = null;
				xmlBuff = new StringBuffer();
				xmldetail1 = createHeader(siteCode, distOrderNo,xtraParams, conn);
				xmlBuff.append(xmldetail1.toString());
				xmlBuff.append(detail2xml.toString());
				xmlBuff.append("</Header0>");
				xmlBuff.append("</group0>");
				xmlBuff.append("</DocumentRoot>");
				xmlString = xmlBuff.toString();
				System.out.println("xmlString------" + xmlString);
			}
			
			if(result.equalsIgnoreCase("YES") && tranID.length() == 0){
				xmlBuff = null;
				xmlBuff = new StringBuffer();
				xmldetail1 = createHeader(siteCode, distOrderNo,xtraParams, conn);
				xmlBuff.append(xmldetail1.toString());
				xmlBuff.append(detail2xml.toString());
				xmlBuff.append("</Header0>");
				xmlBuff.append("</group0>");
				xmlBuff.append("</DocumentRoot>");
				xmlString = xmlBuff.toString();
				System.out.println("xmlString------" + xmlString);
			}*/
			//added by  azhar[END][W16HSUN001]
			
			
			
			if(tranID.length() > 0){
				/*processXml = getXmlInEditMode(tranID,xtraParams,conn, "dist_order_post");
				 System.out.println("Process xml in edit mode::" +processXml);//TODO append process xml to detail2xml
				 String tempXml = processXml.substring(0, processXml.lastIndexOf("</Detail2>") + 10).concat(detail2xml.toString()).concat(processXml.substring(processXml.lastIndexOf("</Detail2>")+10));
				 xmlBuff = new StringBuffer();
				  xmlBuff.append(tempXml.substring(0, tempXml.indexOf("<Header0>") + 9));
			      xmlBuff.append("<objName><![CDATA[").append("dist_order_post").append("]]></objName>");
			      xmlBuff.append("<pageContext><![CDATA[").append("2").append("]]></pageContext>");
			      xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
			      xmlBuff.append("<editFlag><![CDATA[").append("E").append("]]></editFlag>");
			      xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
			      xmlBuff.append("<action><![CDATA[").append("EDIT").append("]]></action>");
			      xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
			      xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
			      xmlBuff.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
			      xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
			      xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
			      xmlBuff.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
			      xmlBuff.append("<pkValues><![CDATA[").append(tranID).append("]]></pkValues>");
			      xmlBuff.append(tempXml.substring(tempXml.indexOf("<Header0>") + 9, tempXml.indexOf("</Header0>")));
			        //xmlBuff.append(detail2xml);
			      xmlBuff.append(tempXml.substring(tempXml.indexOf("</Header0>")));
			        System.out.println("xmlBuff::::"+xmlBuff.toString());
			        xmlString = xmlBuff.toString().trim();
					xmlBuff = null;
					System.out.println(":::xmlString:::"+xmlString);
					System.out.println("::::::::::xmlString for MasterStatefulEJB for Processing::::::::::" + xmlString.trim());*/
				packCode = packCode == null ? "" : packCode.trim();
				siteCodeMfg = siteCodeMfg == null ? "" : siteCodeMfg.trim();
				
				//String mfgDateNew = dbf.format(mfgDate);
				Timestamp mfgTimeStamp = Timestamp.valueOf(dbf.format(mfgDate).toString() + " 00:00:00.0");
				//System.out.println("mfg date:: " + mfgDate);
				Timestamp expTimeStamp = Timestamp.valueOf(dbf.format(expDate).toString() + " 00:00:00.0");
				//String expDateNew = dbf.format(expDate);
				
				
				System.out.println("exp date:: " + expDate);
				double amt = quantity * Double.parseDouble(rate1);
				
				sql = "Insert into DISTORD_ISSDET (TRAN_ID, LINE_NO, DIST_ORDER, LINE_NO_DIST_ORDER, ITEM_CODE, QUANTITY, UNIT, LOC_CODE, LOT_NO, LOT_SL," +
						" PACK_CODE, RATE, AMOUNT,SITE_CODE__MFG, MFG_DATE, EXP_DATE, POTENCY_PERC, NO_ART, GROSS_WEIGHT, TARE_WEIGHT, " +
						"NET_WEIGHT, RATE__CLG, DISC_AMT, UNIT__ALT, CONV__QTY__ALT, QTY_ORDER__ALT) " +
						"values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranID);
				pstmt.setInt(2, lineNoDet);
				pstmt.setString(3, distOrderNo);
				pstmt.setInt(4, mLineNoDist);
				pstmt.setString(5, itemCode);
				pstmt.setDouble(6, quantity);
				pstmt.setString(7, unit);
				pstmt.setString(8, tLocCode);
				pstmt.setString(9, lotNo);
				pstmt.setString(10, tLotSl);
				pstmt.setString(11, packCode);
				pstmt.setString(12, rate);
				pstmt.setDouble(13, amt);
				pstmt.setString(14, siteCodeMfg);
				pstmt.setTimestamp(15, mfgTimeStamp);
				pstmt.setTimestamp(16, expTimeStamp);
				pstmt.setDouble(17, potencyPerc);
				pstmt.setDouble(18, noArt);
				pstmt.setDouble(19, grossWt);
				pstmt.setDouble(20, tareWt);
				pstmt.setDouble(21, netWt);
				pstmt.setDouble(22, rateClgVal);
				pstmt.setDouble(23, disAmount);
				pstmt.setString(24, unitAlt);
				pstmt.setDouble(25, lcFact);
				pstmt.setDouble(26, lcQtyOrderAlt);
				int updCnt = pstmt.executeUpdate();
				if(updCnt > 0){
					
					conn.commit();
					processXml = getXmlInEditMode(tranID,xtraParams,conn, "dist_order_post");
					System.out.println("xml in edit mode::::" + processXml);
				    String currDomID = String.valueOf(lineNoDet);
				    System.out.println("Curr dom id::" + currDomID);
					executeSystemEvent("post_save_rec_2", processXml, xtraParams,currDomID,conn);
					executeSystemEvent("post_save", processXml, xtraParams,currDomID,conn);
					retString = "Success";
				/*	String transString = "<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?><Root>" + 
			                   "<header><objName><![CDATA[dist_order_post]]></objName>" + 
			                   "<objContext><![CDATA[2]]></objContext>" + 
			                   "<editFlag><![CDATA[E]]></editFlag>" + 
			                   "<keyValue><![CDATA[" + tranID + "]]></keyValue>" + 
			                   "<forcedSave><![CDATA[false]]></forcedSave>" + 
			                   "</header></Root>";
			                 String statusStr = executeSystemEvent("post_save_rec_2",transString, lineNoDet,xtraParams,conn);
			                 if (statusStr.indexOf("<Errors>") == -1){
			                	 retString = "Success";*/
			                 
			                 

				}
				
				
			}else{
			xmlBuff = null;
			xmlBuff = new StringBuffer();
			xmldetail1 = createHeader(siteCode, distOrderNo,xtraParams, conn);
			xmlBuff.append(xmldetail1.toString());
			xmlBuff.append(detail2xml.toString());
			xmlBuff.append("</Header0>");
			xmlBuff.append("</group0>");
			xmlBuff.append("</DocumentRoot>");
			xmlString = xmlBuff.toString();
			System.out.println("xmlString------" + xmlString);
			
			System.out.println("Number of Records in Detail---" + countDtl);

			System.out.println("xmlString.contains(Detail2)----" + xmlString.contains("Detail2"));
			if (xmlString.contains("Detail2"))
			{
				retString = distOrder.saveData(siteCode, xmlString, conn);
				System.out.println("After save data distribution issue"+retString);
				if (retString.indexOf("Success") > -1)
				{
					System.out.println("Successfully saved");
					//retString = "VTCONPARM";
				}
			}
			System.out.println("Last final return String1 ="+retString);
			
			//added by  azhar[STATRT][W16HSUN001]
			/*if(result.equalsIgnoreCase("YES") && tranID.length() > 0){
				retString = "Success";
			}*/
			
			System.out.println("Last final return String2 ="+retString);
			//added by  azhar[END][W16HSUN001]
			}
		}
		catch (Exception e)
		{
			System.out.println("createDistIssue Catch Recived");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(pstmt1 != null){pstmt1.close();pstmt1 = null;}
				if(pstmt2 != null){pstmt2.close();pstmt2 = null;}
				if(distIssDetPstmt != null){distIssDetPstmt.close();distIssDetPstmt = null;}
				if(pstmtHdr != null){pstmtHdr.close();pstmtHdr = null;}
				if(rs != null){rs.close();rs = null;}
				if(rs1 != null){rs1.close();rs1 = null;}
				if(rs2 != null){rs2.close();rs2 = null;}
			}
			catch(Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		System.out.println("Last final return String ="+retString);
		return retString;
	}
	
	
	public String executeSystemEvent(String eventCode, String processXml,String xtraParams,String dbID,Connection conn) throws ITMException 
	{
		String result = "";
		try {
			InitialContext ctx = null;
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			Document dom = null;
			if(processXml.length() == 0){
				dom = null;
			}else{
				dom = genericUtility.parseString(processXml);
			}
			EventManagerLocal eventManager = (EventManagerLocal) ctx.lookup("ibase/EventManagerEJB/local");
			result = eventManager.executeSystemEvent("dist_order_post",eventCode,"1",dom,dom,xtraParams,dbID,conn);
		}
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return result;
	}
	private String getXmlInEditMode(String tranId, String xtraParams, Connection conn, String type) 
	{
		InitialContext ctx = null;
		String xmlInEditMode = "";
		MasterStatefulLocal masterStateful = null;
		AppConnectParm appConnect = new AppConnectParm();
		UserInfoBean userInfo = new UserInfoBean();
		if(!type.equalsIgnoreCase("dist_order_post"))
			return "";
		try 
		{
			userInfo.setLoginCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
			userInfo.setEmpCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
			userInfo.setSiteCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
			userInfo.setEntityCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "entityCode"));
			userInfo.setProfileId(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "profileId"));
			userInfo.setUserType(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userType"));
			userInfo.setRemoteHost(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));
			ctx = new InitialContext(appConnect.getProperty());
			masterStateful = (MasterStatefulLocal) ctx.lookup("ibase/MasterStatefulEJB/local");
			masterStateful.setUserInfo(userInfo);
			
			xmlInEditMode = masterStateful.getDetailXMLDomString("dist_order_post","1", "E", tranId, "");	
			
			

		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		
		System.out.println("Returning from MasterStateful xmlInEditMode ::: " + xmlInEditMode);
		return xmlInEditMode;
	}
	private double getIntegralQty(String siteCode, String itemCode, String lotNo, String packCode, String checkIntegralQty) throws ITMException
	{
		double integralQty = 0.0D;
		String sql = "";
		ResultSet rs = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		Statement stmt = null;
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			stmt = conn.createStatement();
			char type = checkIntegralQty.charAt(0);

			switch (type)
			{
			case 'S':
				sql = "SELECT CASE WHEN SHIPPER_SIZE IS NULL THEN 0 ELSE SHIPPER_SIZE END FROM ITEM_LOT_PACKSIZE WHERE ITEM_CODE = '" + 
						itemCode + "' " + 
						"AND LOT_NO__FROM <= '" + lotNo + "' " + 
						"AND LOT_NO__TO   >= '" + lotNo + "' ";
				System.out.println("sql :" + sql);
				rs = stmt.executeQuery(sql);
				if (rs.next())
				{
					integralQty = rs.getDouble(1);
				}

				if (integralQty != 0.0D)
					break;
				sql = "SELECT CASE WHEN CAPACITY IS NULL THEN 0 ELSE CAPACITY END FROM PACKING WHERE PACK_CODE = '" + 
						packCode + "'";
				System.out.println("sql :" + sql);
				rs = stmt.executeQuery(sql);
				if (rs.next())
				{
					integralQty = rs.getDouble(1);
				}

				if (integralQty != 0.0D)
					break;
				sql = "SELECT REO_QTY FROM SITEITEM WHERE SITE_CODE = '" + 
						siteCode + "'" + " AND ITEM_CODE = '" + itemCode + "'";
				System.out.println("sql :" + sql);
				rs = stmt.executeQuery(sql);
				if (rs.next())
				{
					integralQty = rs.getDouble(1);
				}

				if (integralQty != 0.0D)
					break;
				sql = "SELECT REO_QTY FROM ITEM WHERE ITEM_CODE = '" + 
						itemCode + "'";
				System.out.println("sql :" + sql);
				rs = stmt.executeQuery(sql);
				if (!rs.next())
					break;
				integralQty = rs.getDouble(1);

				break;
			case 'P':
				sql = "SELECT CASE WHEN CAPACITY IS NULL THEN 0 ELSE CAPACITY END FROM PACKING WHERE PACK_CODE = '" + 
						packCode + "'";
				System.out.println("sql :" + sql);
				rs = stmt.executeQuery(sql);
				if (!rs.next())
					break;
				integralQty = rs.getDouble(1);

				break;
			case 'I':
				sql = "SELECT INTEGRAL_QTY FROM SITEITEM WHERE SITE_CODE = '" + 
						siteCode + "'" + " AND ITEM_CODE = '" + itemCode + "'";
				System.out.println("sql :" + sql);
				rs = stmt.executeQuery(sql);
				if (rs.next())
				{
					integralQty = rs.getDouble(1);
				}

				if (integralQty != 0.0D)
					break;
				sql = "SELECT INTEGRAL_QTY FROM ITEM WHERE ITEM_CODE = '" + itemCode + "'";
				System.out.println("sql :" + sql);
				rs = stmt.executeQuery(sql);
				if (!rs.next())
					break;
				integralQty = rs.getDouble(1);
			}

			//conn.close();
		}
		catch (Exception e)
		{
			System.out.println("the exception occurs in getIntegralQty :" + e);
		}
		//Changed by Jagruti Shinde on 04-08-2016 to add finally block and close the connection [Start]
		finally
		{	
			try
			{				
				if(rs != null)
				{ 
					rs.close();
					rs = null; 
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		//Changed by  Jagruti Shinde on 04-08-2016 to add finally block and close the connection [End]
		System.out.println("integralQty :" + integralQty);
		return integralQty;
	}	
	public String getFormatedValue(double actVal, int prec) throws RemoteException 
	{
		NumberFormat numberFormat = NumberFormat.getIntegerInstance();
		Double DoubleValue = new Double(actVal);
		numberFormat.setMaximumFractionDigits(prec);
		String strValue = numberFormat.format(DoubleValue);

		strValue = strValue.replaceAll(",", "");
		return strValue;
	}

	private String getCurrdateAppFormat() 
	{
		String s = "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			java.util.Date date = null;
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());

			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
			s = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(timestamp).toString();
		}
		catch (Exception localException)
		{
		}

		return s;
	}
	@SuppressWarnings("unused")
	public String createHeader(String siteCode, String distOrderNo,String xtraParams, Connection conn)
			throws RemoteException, ITMException
			{
		StringBuffer xmlBuffHeader = new StringBuffer();
		String sql = null,isAutoConfirm = "N";
		//String tranDate = null;
		String tranDate = null;
		String retString = "";
		PreparedStatement pstmt = null; PreparedStatement distIssHdrPstmt = null;
		ResultSet rs = null;  

		//double mod = 0.0D; double minputQty = 0.0D; double remQuantity = 0.0D; double stockQty = 0.0D; double integralQty = 0.0D;
		//double grossPer = 0.0D; double netPer = 0.0D; double tarePer = 0.0D; double grossWt = 0.0D; double netWt = 0.0D; double tareWt = 0.0D; double rateClgVal = 0.0D; double rate2 = 0.0D;
		//double disAmount = 0.0D; double amount = 0.0D; double shipperQty = 0.0D; double discount = 0.0D;
		//int minShelfLife = 0; int noArt1 = 0; int cnt = 0;
		//int mLineNoDist = 0;
		//double qtyConfirm = 0.0D; double qtyShipped = 0.0D; double lcQtyOrderAlt = 0.0D; double lcFact = 0.0D;
		//String suppSour = ""; String trackShelfLife = ""; String siteCodeMfg = ""; String sundryCode = ""; String potencyPerc = "";
		//String priceList = ""; String tabValue = ""; String priceListClg = ""; String chkDate = ""; String disCountPer = "";
		//String tranTypePparent = null; String rate = ""; String lsTranTypeParent = "";
		//String qtyOrdAlt = ""; String convQtyAlt = "";
		//String res = ""; String locCodeDamaged = ""; String itemCode = ""; String availableYn = "";
		//String checkIntegralQty = ""; String rate1 = ""; String tranTypeParent = ""; String quantity = "";
		//String active = ""; String itemDescr = ""; String errCode = ""; String sql2 = ""; String noArt = "";
		//String detail2stock = ""; String errString = ""; String taxChap = ""; String siteCodeShip = "";
		//String lotNo = ""; String lotSl = ""; String packCode = ""; String rateClg = ""; String taxEnv = ""; String taxClass = "";
		//java.util.Date expDate = null; java.util.Date mfgDate = null; java.util.Date chkDate1 = null;
		//int caseCount = 0;
		//boolean isDetFound = false;
		boolean isError = false;
		//String today = "",tranId = "";
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
	
			System.out.println("Xtra Params in dist issue="+xtraParams);
			String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			String chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			String chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");

			tranDate = getCurrdateAppFormat();
			//tranDate = getCurrtDate();

			//tranId = generateTranTd("w_dist_order_post", today, siteCode, conn);

			sql = "SELECT D.DIST_ORDER AS DIST_ORDER,D.ORDER_DATE AS ORDER_DATE,D.SITE_CODE__SHIP AS SITE_CODE__SHIP,"
					+ "D.SITE_CODE__DLV AS SITE_CODE__DLV,D.SHIP_DATE AS SHIP_DATE,D.DUE_DATE AS DUE_DATE,D.REMARKS AS REMARKS,"
					+ " D.DIST_ROUTE AS DIST_ROUTE,D.PRICE_LIST AS PRICE_LIST,D.CONFIRMED AS CONFIRMED,D.CHG_USER AS CHG_USER,"
					+ "D.CHG_TERM AS CHG_TERM,D.TARGET_WGT AS TARGET_WGT,D.TARGET_VOL AS TARGET_VOL,D.LOC_CODE__GIT AS LOC_CODE__GIT,"
					+ " D.CHG_DATE AS CHG_DATE,SITE_A.DESCR AS SITEA_DESCR,SITE_B.DESCR AS SITEB_DESCR,LOCATION.DESCR AS LOCATION_DESCR,"
					+ "D.CONF_DATE AS CONF_DATE,D.SITE_CODE AS SITE_CODE,D.STATUS AS STATUS,D.SALE_ORDER AS SALE_ORDER, D.REMARKS1 AS REMARK1,"
					+ "D.REMARKS2 AS REMARK2,TRIM(D.ORDER_TYPE) AS ORDER_TYPE,SITE_A.ADD1 AS SITEA_ADD1,SITE_A.ADD2 AS SITEA_ADD2,"
					+ "SITE_A.CITY AS SITEA_CITY,SITE_A.PIN AS SITEA_PIN,SITE_A.STATE_CODE AS SITEA_STATE_CODE, SITE_B.ADD1 AS SITEB_ADD1,"
					+ "SITE_B.ADD2 AS SITEB_ADD2,SITE_B.CITY AS SITEB_CITY,SITE_B.PIN AS SITEB_PIN,SITE_B.STATE_CODE AS SITEB_STATE_CODE,"
					+ "D.LOC_CODE__CONS AS LOC_CODE__CONS,D.SUNDRY_TYPE AS SUNDRY_TYPE, D.SUNDRY_CODE AS SUNDRY_CODE,"
					+ "D.AUTO_RECEIPT AS AUTO_RECEIPT,D.TRAN_TYPE AS TRAN_TYPE,D.CURR_CODE AS CURR_CODE,D.EXCH_RATE AS EXCH_RATE,"
					+ "D.SALES_PERS AS SALES_PERS,SALES_PERS.SP_NAME AS SP_NAME, D.LOC_CODE__GITBF AS LOC_CODE__GITBF,D.CUST_CODE__DLV AS"
					+ " CUST_CODE__DLV,D.DLV_TO AS DLV_TO,D.DLV_ADD1 AS DLV_ADD1,D.DLV_ADD2 AS DLV_ADD2,D.DLV_ADD3 AS DLV_ADD3,D.DLV_CITY"
					+ " AS DLV_CITY, D.STATE_CODE__DLV AS STATE_CODE__DLV,D.COUNT_CODE__DLV AS COUNT_CODE__DLV,D.DLV_PIN AS DLV_PIN,"
					+ "D.STAN_CODE AS STAN_CODE,D.TEL1__DLV AS TEL1__DLV,D.TEL2__DLV AS TEL2__DLV,D.TEL3__DLV AS TEL3__DLV,"
					+ " D.FAX__DLV AS FAX__DLV,D.AVALIABLE_YN AS AVALIABLE_YN,D.PURC_ORDER AS PURC_ORDER,D.TOT_AMT AS TOT_AMT,"
					+ "D.TAX_AMT AS TAX_AMT,D.NET_AMT AS NET_AMT,D.TRAN_SER AS TRAN_SER, D.PRICE_LIST__CLG AS PRICE_LIST__CLG,SPACE(25)"
					+ " AS LOC,FN_SUNDRY_NAME(D.SUNDRY_TYPE,D.SUNDRY_CODE,'N') AS SUNDRY_NAME, D.PROJ_CODE AS PROJ_CODE,"
					+ "SITE_C.DESCR AS SITEC_DESCR,D.POLICY_NO AS POLICY_NO,D.LOC_CODE__DAMAGED AS LOC_CODE__DAMAGED,"
					+ "D.SITE_CODE__BIL AS SITE_CODE__BIL,SITE_D.DESCR AS SITED_DESCR,SITE_D.ADD1 AS SITED_ADD1, SITE_D.ADD2 AS SITED_ADD2,"
					+ "SITE_D.CITY AS SITED_CITY,SITE_D.PIN SITED_PIN ,SITE_D.STATE_CODE AS SITED_STATE_CODE,D.TRANS_MODE AS TRANS_MODE "
					+ " FROM DISTORDER  D,SITE SITE_A,SITE SITE_B,LOCATION  LOCATION,SALES_PERS  SALES_PERS,SITE SITE_C,SITE SITE_D "
					+ "  WHERE ( D.SITE_CODE__SHIP      = SITE_A.SITE_CODE  ) AND  ( D.SITE_CODE__DLV      = SITE_B.SITE_CODE (+)  ) AND "
					+ " ( D.LOC_CODE__GIT      = LOCATION.LOC_CODE (+)  ) AND  ( D.SITE_CODE      = SITE_C.SITE_CODE (+)  ) AND "
					+ " ( D.SALES_PERS=SALES_PERS.SALES_PERS(+)) AND  ( D.SITE_CODE__BIL=SITE_D.SITE_CODE(+))"
					+ "   AND ( ( D.DIST_ORDER    = '" + distOrderNo + "' ) ) ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				xmlBuffHeader.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
				xmlBuffHeader.append("<DocumentRoot>");
				xmlBuffHeader.append("<description>").append("Datawindow Root").append("</description>");
				xmlBuffHeader.append("<group0>");
				xmlBuffHeader.append("<description>").append("Group0 description").append("</description>");
				xmlBuffHeader.append("<Header0>");

				xmlBuffHeader.append("<objName><![CDATA[").append("dist_order_post").append("]]></objName>");

				xmlBuffHeader.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
				xmlBuffHeader.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
				xmlBuffHeader.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
				xmlBuffHeader.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
				xmlBuffHeader.append("<action><![CDATA[").append("SAVE").append("]]></action>");
				xmlBuffHeader.append("<elementName><![CDATA[").append("").append("]]></elementName>");
				xmlBuffHeader.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
				xmlBuffHeader.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
				xmlBuffHeader.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
				xmlBuffHeader.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
				xmlBuffHeader.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
				xmlBuffHeader.append("<description>").append("Header0 members").append("</description>");

				xmlBuffHeader.append("<Detail1 dbID=\"\" domID=\"1\" objName=\"dist_order_post\" objContext=\"1\">");

				xmlBuffHeader.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
				xmlBuffHeader.append("<tran_id/>");

				xmlBuffHeader.append("<tran_date><![CDATA[" + tranDate + "]]></tran_date>");
				xmlBuffHeader.append("<eff_date><![CDATA[" + tranDate + "]]></eff_date>");
				xmlBuffHeader.append("<dist_order><![CDATA[" + distOrderNo + "]]></dist_order>");

				xmlBuffHeader.append("<site_code><![CDATA[" + (rs.getString("SITE_CODE__SHIP") == null ? "" : rs.getString("SITE_CODE__SHIP").trim()) + "]]></site_code>");
				xmlBuffHeader.append("<site_code__dlv><![CDATA[" + (rs.getString("SITE_CODE__DLV") == null ? "" : rs.getString("SITE_CODE__DLV").trim()) + "]]></site_code__dlv>");
				xmlBuffHeader.append("<dist_route><![CDATA[" + (rs.getString("DIST_ROUTE") == null ? "" : rs.getString("DIST_ROUTE")) + "]]></dist_route>");
				xmlBuffHeader.append("<tran_code><![CDATA[]]></tran_code>");
				xmlBuffHeader.append("<lr_no><![CDATA[]]></lr_no>");
				xmlBuffHeader.append("<lr_date><![CDATA[]]></lr_date>");
				xmlBuffHeader.append("<lorry_no><![CDATA[]]></lorry_no>");
				xmlBuffHeader.append("<gross_weight><![CDATA[0]]></gross_weight>");
				xmlBuffHeader.append("<tare_weight><![CDATA[0]]></tare_weight>");
				xmlBuffHeader.append("<net_weight><![CDATA[0]]></net_weight>");
				xmlBuffHeader.append("<frt_amt><![CDATA[0]]></frt_amt>");
				xmlBuffHeader.append("<amount><![CDATA[0]]></amount>");
				xmlBuffHeader.append("<tax_amt><![CDATA[0]]></tax_amt>");
				xmlBuffHeader.append("<net_amt><![CDATA[0]]></net_amt>");
				xmlBuffHeader.append("<remarks><![CDATA[]]></remarks>");
				xmlBuffHeader.append("<frt_type><![CDATA[T]]></frt_type>");

				xmlBuffHeader.append("<chg_user><![CDATA[" + userId + "]]></chg_user>");

				xmlBuffHeader.append("<chg_term><![CDATA[" + chgTerm + "]]></chg_term>");
				xmlBuffHeader.append("<curr_code><![CDATA[" + (rs.getString("CURR_CODE")) + "]]></curr_code>");
				xmlBuffHeader.append("<chg_date><![CDATA[" + tranDate + "]]></chg_date>");
				xmlBuffHeader.append("<site_descr><![CDATA[" + (rs.getString("SITEA_DESCR") == null ? "" : rs.getString("SITEA_DESCR").trim()) + "]]></site_descr>");
				xmlBuffHeader.append("<site_to_descr><![CDATA[" + (rs.getString("SITEB_DESCR") == null ? "" : rs.getString("SITEB_DESCR").trim()) + "]]></site_to_descr>");
				xmlBuffHeader.append("<location_descr><![CDATA[" + (rs.getString("LOCATION_DESCR") == null ? "" : rs.getString("LOCATION_DESCR").trim()) + "]]></location_descr>");
				xmlBuffHeader.append("<tran_name><![CDATA[]]></tran_name>");
				xmlBuffHeader.append("<currency_descr><![CDATA[]]></currency_descr>");
				xmlBuffHeader.append("<confirmed><![CDATA[" + isAutoConfirm + "]]></confirmed>");
				xmlBuffHeader.append("<loc_code__git><![CDATA[" + (rs.getString("LOC_CODE__GITBF") == null ? "" : rs.getString("LOC_CODE__GITBF")) + "]]></loc_code__git>");
				xmlBuffHeader.append("<conf_date><![CDATA[" + sdf.format(rs.getTimestamp("CONF_DATE")) + "]]></conf_date>");
				xmlBuffHeader.append("<no_art><![CDATA[0]]></no_art>");
				xmlBuffHeader.append("<trans_mode><![CDATA[" + (rs.getString("TRANS_MODE") == null ? "" : rs.getString("TRANS_MODE").trim()) + "]]></trans_mode>");
				xmlBuffHeader.append("<gp_no><![CDATA[]]></gp_no>");
				xmlBuffHeader.append("<gp_date/>");
				xmlBuffHeader.append("<conf_passwd/>");

				xmlBuffHeader.append("<order_type><![CDATA[" + (rs.getString("ORDER_TYPE") == null ? "" : rs.getString("ORDER_TYPE").trim()) + "]]></order_type>");
				xmlBuffHeader.append("<gp_ser><![CDATA[I]]></gp_ser>");
				xmlBuffHeader.append("<ref_no><![CDATA[]]></ref_no>");
				xmlBuffHeader.append("<ref_date><![CDATA[]]></ref_date>");

				xmlBuffHeader.append("<available_yn><![CDATA[" + (rs.getString("AVALIABLE_YN") == null ? "N" : rs.getString("AVALIABLE_YN").trim()) + "]]></available_yn>");
				xmlBuffHeader.append("<site_add1><![CDATA[" + (rs.getString("SITEA_ADD1") == null ? "" : rs.getString("SITEA_ADD1").trim()) + "]]></site_add1>");
				xmlBuffHeader.append("<site_add2><![CDATA[" + (rs.getString("SITEA_ADD2") == null ? "" : rs.getString("SITEA_ADD2").trim()) + "]]></site_add2>");
				xmlBuffHeader.append("<site_city><![CDATA[" + (rs.getString("SITEA_CITY") == null ? "" : rs.getString("SITEA_CITY").trim()) + "]]></site_city>");
				xmlBuffHeader.append("<site_pin><![CDATA[" + (rs.getString("SITEA_PIN") == null ? "" : rs.getString("SITEA_PIN").trim()) + "]]></site_pin>");
				xmlBuffHeader.append("<site_state_code><![CDATA[" + (rs.getString("SITEA_STATE_CODE") == null ? "" : rs.getString("SITEA_STATE_CODE").trim()) + "]]></site_state_code>");
				xmlBuffHeader.append("<exch_rate><![CDATA[" + rs.getDouble("EXCH_RATE") + "  ]]></exch_rate>");
				xmlBuffHeader.append("<tran_type><![CDATA[" + (rs.getString("TRAN_TYPE") == null ? "" : rs.getString("TRAN_TYPE").trim()) + "]]></tran_type>");
				xmlBuffHeader.append("<emp_code__aprv><![CDATA[]]></emp_code__aprv>");
				xmlBuffHeader.append("<discount><![CDATA[0]]></discount>");
				xmlBuffHeader.append("<permit_no><![CDATA[]]></permit_no>");
				xmlBuffHeader.append("<shipment_id><![CDATA[]]></shipment_id>");
				xmlBuffHeader.append("<curr_code__frt><![CDATA[" + (rs.getString("CURR_CODE")) + "]]></curr_code__frt>");
				xmlBuffHeader.append("<exch_rate__frt><![CDATA[]]></exch_rate__frt>");
				xmlBuffHeader.append("<currency_descr__frt><![CDATA[]]></currency_descr__frt>");
				xmlBuffHeader.append("<rd_permit_no><![CDATA[]]></rd_permit_no>");
				xmlBuffHeader.append("<dc_no><![CDATA[]]></dc_no>");
				xmlBuffHeader.append("<tran_ser><![CDATA[D-ISS ]]></tran_ser>");
				xmlBuffHeader.append("<part_qty><![CDATA[A]]></part_qty>");
				xmlBuffHeader.append("<sundry_details><![CDATA[]]></sundry_details>");
				xmlBuffHeader.append("<sundry_name><![CDATA[" + (rs.getString("SUNDRY_NAME") == null ? "" : rs.getString("SUNDRY_NAME")) + "]]></sundry_name>");
				xmlBuffHeader.append("<proj_code><![CDATA[" + (rs.getString("PROJ_CODE") == null ? "" : rs.getString("PROJ_CODE").trim()) + "]]></proj_code>");
				xmlBuffHeader.append("<site_tele1><![CDATA[]]></site_tele1>");
				xmlBuffHeader.append("<site_tele2><![CDATA[]]></site_tele2>");
				xmlBuffHeader.append("<site_tele3><![CDATA[]]></site_tele3>");
				xmlBuffHeader.append("<site_code__bil><![CDATA[]]></site_code__bil>");
				xmlBuffHeader.append("<site_descr_bill><![CDATA[]]></site_descr_bill>");
				xmlBuffHeader.append("<site_add1_bill><![CDATA[]]></site_add1_bill>");
				xmlBuffHeader.append("<site_add2_bill><![CDATA[]]></site_add2_bill>");
				xmlBuffHeader.append("<site_city_bill><![CDATA[]]></site_city_bill>");
				xmlBuffHeader.append("<site_pin_bill><![CDATA[]]></site_pin_bill>");
				xmlBuffHeader.append("<site_state_code_bill><![CDATA[]]></site_state_code_bill>");
				xmlBuffHeader.append("<pallet_wt><![CDATA[]]></pallet_wt>");
				xmlBuffHeader.append("<auto_receipt><![CDATA[N]]></auto_receipt>");
				xmlBuffHeader.append("</Detail1>");
				
				retString = xmlBuffHeader.toString();
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
		}
		catch (Exception e)
		{
			isError = true;
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(distIssHdrPstmt != null){distIssHdrPstmt.close();distIssHdrPstmt = null;}
				if(rs != null){rs.close();rs = null;}
			}
			catch(Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		System.out.println("Header return string::" + retString);
		return retString;
	}
	@SuppressWarnings({  "rawtypes", "unused" })
	private String getDetails(String mSiteCode, int mLineNoDist, String mDistOrder, String lsTranType, Connection conn) 
			throws RemoteException, ITMException 
			{
		String mItemCode = null; String mTaxClass = null; String mTaxChap = null; String mTaxEnv = null;
		String lsUnitAlt = null; String lsUnit = null; String lsPackInstr = null;
		String iItemCode = ""; String mPackCode = null; String unit = "";
		double mQty = 0.0D; double lcQty = 0.0D; double mRate = 0.0D; double mDiscount = 0.0D; double lcRateClg = 0.0D; double lcConvQtyAlt = 0.0D;

		String sql = null; String lsTranTypeParent = "";
		ResultSet rs = null; ResultSet rs1 = null;
		PreparedStatement pstmt = null; PreparedStatement pstmt1 = null;
		StringBuffer detail2hdr = new StringBuffer("");
		String mLotNo = null;

		HashMap hm = new HashMap();

		try
		{
			sql = "select item_code,((case when qty_confirm is null then 0 else qty_confirm end) -  (case when qty_shipped is null then 0 else qty_shipped end))\tas qty, ((case when qty_shipped is null then 0 else qty_shipped end) -  (case when qty_return is null then 0 else qty_return end)) as lcqty, tax_class,tax_chap,tax_env,case when rate is null then 0 else rate end as rate, case when discount is null then 0 else discount end as discount,\t rate__clg  ,UNIT__ALT ,UNIT,CONV__QTY__ALT,pack_instr  from \tdistorder_det  where dist_order = '" + 
					mDistOrder + "'  " + 
					" and \tline_no    = " + mLineNoDist + 
					" AND   CASE WHEN STATUS IS NULL THEN 'O' ELSE STATUS END<>'C' ";

			pstmt = conn.prepareStatement(sql);

			rs = pstmt.executeQuery();
			if (rs.next())
			{
				mItemCode = rs.getString("item_code") == null ? "" : rs.getString("item_code");
				mQty = rs.getDouble("qty");
				lcQty = rs.getDouble("lcqty");
				mTaxClass = rs.getString("tax_class") == null ? "" : rs.getString("tax_class");
				mTaxChap = rs.getString("tax_chap") == null ? "" : rs.getString("tax_chap");
				mTaxEnv = rs.getString("tax_env") == null ? "" : rs.getString("tax_env");
				mRate = rs.getDouble("rate");
				mDiscount = rs.getDouble("discount");
				lcRateClg = rs.getDouble("rate__clg");
				lsUnitAlt = rs.getString("UNIT__ALT") == null ? "" : rs.getString("UNIT__ALT");
				unit = rs.getString("UNIT") == null ? "" : rs.getString("UNIT");
				lcConvQtyAlt = rs.getDouble("CONV__QTY__ALT");
				lsPackInstr = rs.getString("pack_instr") == null ? "" : rs.getString("pack_instr");

				if (lsUnitAlt.trim().length() == 0)
				{
					lsUnitAlt = lsUnit;
					lcConvQtyAlt = 1.0D;
				}

				detail2hdr.append("<item_code><![CDATA[" + mItemCode + "]]></item_code>");
		        detail2hdr.append("<unit><![CDATA[" + lsUnit + "]]></unit>");
		        detail2hdr.append("<unit__alt><![CDATA[" + lsUnitAlt + "]]></unit__alt>");
		        detail2hdr.append("<pack_instr><![CDATA[" + lsPackInstr + "]]></pack_instr>");

				/*hm.put("item_code", mItemCode);
				hm.put("unit", lsUnit);
				hm.put("unit__alt", lsUnitAlt);
				hm.put("pack_instr", lsPackInstr);*/

				sql = " select tran_type__parent  from\tdistorder_type where  tran_type = '" + 
						lsTranType + "' ";

				pstmt1 = conn.prepareStatement(sql);
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					lsTranTypeParent = rs1.getString("tran_type__parent") == null ? "" : rs1.getString("tran_type__parent").trim();
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;

				if (!lsTranTypeParent.equalsIgnoreCase(lsTranType.trim()))
				{
					detail2hdr.append("<quantity>" + lcQty + "</quantity>");
		            detail2hdr.append("<qty_order__alt>" + lcQty + "</qty_order__alt>");
					/*hm.put("quantity", lcQty);
					hm.put("qty_order__alt", lcQty);*/
					//lcQty = lcQty;
				}
				else
				{
					detail2hdr.append("<quantity>" + mQty + "</quantity>");
		            detail2hdr.append("<qty_order__alt>" + mQty + "</qty_order__alt>");
					/*hm.put("quantity", mQty);
					hm.put("qty_order__alt", mQty);	*/
					lcQty = mQty;
				}
				detail2hdr.append("<tax_class><![CDATA[" + mTaxClass + "]]></tax_class>");
		        detail2hdr.append("<tax_chap><![CDATA[" + mTaxChap + "]]></tax_chap>");
		        detail2hdr.append("<tax_env><![CDATA[" + mTaxEnv + "]]></tax_env>");
		        detail2hdr.append("<rate>" + mRate + "</rate>");
		        detail2hdr.append("<discount>" + mDiscount + "</discount>");

			/*	hm.put("tax_class", mTaxClass);
				hm.put("tax_chap", mTaxChap);	
				hm.put("tax_env", mTaxEnv);
				hm.put("rate", mRate);
				hm.put("discount", mDiscount);*/
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		System.out.println("chandni inside detail::" + detail2hdr.toString());
		return detail2hdr.toString();
		//return hm;
			}
	@SuppressWarnings("unused")
	private String calcExpiry(String tranDate, int months)
	{
		java.util.Date expDate = new java.util.Date();
		java.util.Date retDate = new java.util.Date();
		String retStrInDate = "";
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			if (months > 0)
			{
				Calendar cal = Calendar.getInstance();
				expDate = sdf.parse(tranDate);

				cal.setTime(expDate);
				cal.add(2, months);

				cal.add(2, 1);
				cal.set(5, 0);

				retDate = cal.getTime();
				retStrInDate = sdf.format(retDate);
			}
			else
			{
				retStrInDate = tranDate;
			}

		}
		catch (Exception localException)
		{
		}

		return retStrInDate;
	}
	private int getNoArt(String siteCode, String custCode, String itemCode, String packCode, double qty, char type, double shipperQty, double integralQty1) throws ITMException
	{
		String sql = "";
		ResultSet rs = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		Statement stmt = null;
		double reoQty = 0.0D; double capacity = 0.0D; double integralQty = 0.0D; double mod = 0.0D; double noArt3 = 0.0D;
		double noArt = 0.0D; double noArt1 = 0.0D; double noArt2 = 0.0D;
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			stmt = conn.createStatement();
			System.out.println("type :" + type);
			switch (type)
			{
			case 'S':
				sql = "SELECT CASE WHEN CAPACITY IS NULL THEN 0 ELSE CAPACITY END FROM PACKING WHERE PACK_CODE = '" + 
						packCode + "'";
				rs = stmt.executeQuery(sql);
				if (rs.next())
				{
					capacity = rs.getDouble(1);
				}
				else
				{
					capacity = 0.0D;
				}
				sql = "SELECT REO_QTY FROM SITEITEM WHERE SITE_CODE = '" + siteCode + "' " + 
						"AND ITEM_CODE = '" + itemCode + "'";
				System.out.println("sql :" + sql);
				rs = stmt.executeQuery(sql);
				if (rs.next())
				{
					reoQty = rs.getDouble(1);
				}

				if (reoQty == 0.0D)
				{
					sql = "SELECT REO_QTY FROM ITEM WHERE ITEM_CODE = '" + itemCode + "'";
					System.out.println("sql :" + sql);
					rs = stmt.executeQuery(sql);
					if (rs.next())
					{
						reoQty = rs.getDouble(1);
					}
				}

				if (reoQty == 0.0D)
				{
					reoQty = 0.0D;
				}
				if (capacity > 0.0D)
				{
					shipperQty = capacity;
				}
				else
				{
					shipperQty = reoQty;
				}

				System.out.println("shipperQty :" + shipperQty);
				if (shipperQty <= 0.0D)
					break;
				mod = qty % shipperQty;
				System.out.println("mod :" + mod);
				noArt = (qty - mod) / shipperQty;

				break;
			case 'I':
				sql = "SELECT INTEGRAL_QTY FROM CUSTOMERITEM WHERE CUST_CODE = '" + 
						custCode + "'" + " AND ITEM_CODE = '" + itemCode + "'";
				System.out.println("sql :" + sql);
				rs = stmt.executeQuery(sql);
				if (rs.next())
				{
					integralQty = rs.getDouble(1);
				}

				if (integralQty == 0.0D)
				{
					sql = "SELECT INTEGRAL_QTY FROM SITEITEM WHERE SITE_CODE = '" + 
							siteCode + "'" + " AND ITEM_CODE = '" + itemCode + "'";
					System.out.println("sql :" + sql);
					rs = stmt.executeQuery(sql);
					if (rs.next())
					{
						integralQty = rs.getDouble(1);
					}

					if (integralQty == 0.0D)
					{
						sql = "SELECT INTEGRAL_QTY FROM ITEM WHERE ITEM_CODE = '" + itemCode + "'";
						System.out.println("sql :" + sql);
						rs = stmt.executeQuery(sql);
						if (rs.next())
						{
							integralQty = rs.getDouble(1);
						}
					}
				}

				if (integralQty <= 0.0D)
					break;
				mod = qty % integralQty;
				System.out.println("mod :" + mod);
				noArt = (qty - mod) / integralQty;

				break;
			case 'B':
				sql = "SELECT CASE WHEN CAPACITY IS NULL THEN 0 ELSE CAPACITY END FROM PACKING WHERE PACK_CODE = '" + 
						packCode + "'";
				System.out.println("sql :" + sql);
				rs = stmt.executeQuery(sql);
				if (rs.next())
				{
					capacity = rs.getDouble(1);
				}
				else
				{
					capacity = 0.0D;
				}
				sql = "SELECT REO_QTY FROM SITEITEM WHERE SITE_CODE = '" + siteCode + "' " + 
						"AND ITEM_CODE = '" + itemCode + "'";
				System.out.println("sql :" + sql);
				rs = stmt.executeQuery(sql);
				if (rs.next())
				{
					reoQty = rs.getDouble(1);
				}

				if (reoQty == 0.0D)
				{
					sql = "SELECT REO_QTY FROM ITEM WHERE ITEM_CODE = '" + itemCode + "'";
					System.out.println("sql :" + sql);
					rs = stmt.executeQuery(sql);
					if (rs.next())
					{
						reoQty = rs.getDouble(1);
					}
				}

				if (capacity > 0.0D)
				{
					shipperQty = capacity;
				}
				else
				{
					shipperQty = reoQty;
				}

				if (shipperQty > 0.0D)
				{
					mod = qty % shipperQty;
					noArt1 = (qty - mod) / shipperQty;
				}
				sql = "SELECT INTEGRAL_QTY FROM CUSTOMERITEM WHERE CUST_CODE = '" + 
						custCode + "' " + 
						"AND ITEM_CODE = '" + itemCode + "'";
				System.out.println("sql :" + sql);
				rs = stmt.executeQuery(sql);
				if (rs.next())
				{
					integralQty = rs.getDouble(1);
				}

				if (integralQty == 0.0D)
				{
					sql = "SELECT INTEGRAL_QTY FROM SITEITEM WHERE SITE_CODE = '" + 
							siteCode + "' " + 
							"AND ITEM_CODE = '" + itemCode + "'";
					System.out.println("sql :" + sql);
					rs = stmt.executeQuery(sql);
					if (rs.next())
					{
						integralQty = rs.getDouble(1);
					}

					if (integralQty == 0.0D)
					{
						sql = "SELECT INTEGRAL_QTY FROM ITEM WHERE ITEM_CODE = '" + itemCode + "'";
						System.out.println("sql :" + sql);
						rs = stmt.executeQuery(sql);
						if (rs.next())
						{
							integralQty = rs.getDouble(1);
						}
					}
				}

				double remainder1 = 0.0D;
				if (integralQty > 0.0D)
				{
					remainder1 = mod % integralQty;
					System.out.println("remainder1 :" + remainder1);
					noArt3 = (mod - remainder1) / integralQty;
					noArt2 = (int)noArt3;
				}
				if (noArt2 > 0.0D)
				{
					noArt2 = 1.0D;
				}
				noArt = noArt1 + noArt2;
				System.out.println("noArt :" + noArt);
			}
			conn.close();
			if (noArt == 0.0D)
			{
				noArt = 0.0D;
			}
		}
		catch (Exception e)
		{
			System.out.println("Exception occures in getNoArt :" + e);
		}
		//Changed by Jagruti Shinde on 04-08-2016 to add finally block and close the connection [Start]
		finally
		{	
			try
			{				
				if(rs != null)
				{ 
					rs.close();
					rs = null; 
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		//Changed by  Jagruti Shinde on 04-08-2016 to add finally block and close the connection [End]
		System.out.println("(int)noArt :" + (int)noArt);
		return (int)noArt;
	}
	@SuppressWarnings("unused")
	private  String getError(String saleOrder,String Code,Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";
		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			String begPart = errString.substring(0,errString.indexOf("<message>")+9);
			String endDesc = errString.substring(errString.indexOf("</description>"));
			mainStr= begPart+"Invalid Data"+"</message><description>";
			mainStr= mainStr+"Sale Order ["+saleOrder+""+endDesc;
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	private DistStkUpdLocal getComponent(String componentName)throws Exception
	{
		DistStkUpdLocal comp = null;
		try
		{
			System.out.println("Looking For Component.... :: " + componentName);
			AppConnectParm appConnect = new AppConnectParm();
			java.util.Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			comp = (DistStkUpdLocal)ctx.lookup("ibase/DistStkUpd/local"); // for ejb3
			//comp = distStkUpdHome.create();
			System.out.println(componentName+" Found.....");			
		}
		catch(Exception e)
		{
			throw e;
		}
		return comp;
	}
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	@SuppressWarnings("unused")
	private String checkNull( String input )
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}
	private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException 
	{
		java.sql.Timestamp currDate = null;
		try 
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return (currDate);
	}
	//private String allocStockLocCodeTo(ArrayList stkList,ArrayList tranIdIssList,String refSer,String refId,int countDso,Connection conn)  throws ITMException, Exception
	//private String allocStockLocCodeTo(ArrayList stkList,Connection conn)  throws ITMException, Exception
	@SuppressWarnings({ "unused", "rawtypes", "unchecked" })
	private String allocStockLocCodeTo(ArrayList stkList,boolean deallocFlag,Connection conn)  throws ITMException, Exception
	{
		String result = "",locCodeTo = "",sqlUpdate = "",tranIdList = "",deallocQty = "";
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		DistStkUpdLocal distStkUpd = null;
		int count = 0;
		int cntList = 0;
		double allocQty = 0;
		boolean isError = false;
		try
		{
			System.out.println("Inside allocStockLocCodeTo");
			//System.out.println("Count DSO="+countDso);

			Iterator itr = stkList.iterator();
			System.out.println("Array List size="+stkList.size());

			if(stkList.size() > 0)
			{	
				while(itr.hasNext())
				{  
					HashMap detail = new HashMap();
					detail = (HashMap) itr.next();
					
					if(deallocFlag)
					{
						System.out.println("Inside deallocation alloc_qty");
						allocQty = (Double) detail.get("dealloc_qty");
						System.out.println("Final dealloc quantity="+allocQty);
						detail.put("alloc_qty", allocQty);
					}

					distStkUpd = getComponent("DistStkUpd");
					if (distStkUpd.updAllocTrace(detail, conn) > 0)
					{
						System.out.println("distStkUpd.UpdAllocTrace(HashMap, Connection) : Sucessuful!="+count);
					}
					count++;
				}
			} 
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Catch allocStockLocCodeTo");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(rs != null){rs.close();rs = null;}
			}
			catch(Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		return result;
	}
	private boolean checkCountPalletReq(String refId,Connection conn)  throws ITMException, Exception
	{
		boolean result = false;
		int countWms = 0;
		int countAWms = 0;
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		String sql = "";
		try
		{
			sql = "SELECT COUNT(*) AS COUNT FROM SWMS_TO_AWMS WHERE REF_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, refId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				countWms = rs.getInt("COUNT");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;

			sql = "SELECT COUNT(*) AS COUNT FROM WMS_TO_HOST WHERE REF_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, refId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				countAWms = rs.getInt("COUNT");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;

			System.out.println("Count WMS is="+countWms);
			System.out.println("Count AWMS is="+countAWms);

			if(countWms == countAWms)
			{
				return true;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(rs != null){rs.close();rs = null;}
			}
			catch(Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		return result;
	}
	
	//private String despatchOrder(String saleOrder,String custCode,String tranId,Date lrDate,String invoiceNo, String xtraParams, Connection conn) throws RemoteException, ITMException
	@SuppressWarnings("rawtypes")
	private String despatchOrder(String saleOrder,ArrayList<String> lineNoList,String xtraParams,String locCode, Connection conn) throws RemoteException, ITMException
	{
		String userId = "", termId = "",custCode = "";
		String sql = "";
		String siteCode = "";	
		String currCodedlv  = "";
		String lnNoSord = "";
		String currencyCode = "";
		String currCodeFrt="";
		String currCodeIns ="";
		String quntyStduom="";
		String transMode = "";
		String lotSl = "";
		String lotNo = "";
		String explLev = "";
		String stanCode="";
		String exchRate1="";
		String netTotAmt = "";	
		String itemCode = "";
		String quantity ="";
		String rate="";
		String unit="";
		String conQtyStd ="";
		String unitRate="";
		String taxClass="";
		String taxChap="";
		String taxEnv = "";
		String packCode ="";
		String siteCodeDet ="",convRtuomStduom="";
		String rateStduom="",netAmt="";
		String unitStd = "",noArt = "",packInstr="";
		String stanCodeDlv="",dlvAdd1="",dlvAdd2="",dlvAdd3="",dlvCity="",dlvPin="",countCodeDlv="",tranCode="",stanCodeInit="",status=" ",statusRemarks="",shipmentId="";
		String siteCodeMfg="",lineNo="";
		Date orderDt = null,expDate=null,mfgDate=null;
		PreparedStatement pstmt = null,pstmt1 =null;
		ResultSet rs = null,rs1 = null;
		double rateClg=0;
		int lnno = 0;
		E12GenericUtility genericUtility = new E12GenericUtility();
		StringBuffer xmlBuff = null;
		String xmlString = null,retString  = null;
		String dimension="";
		double qtyStk=0d,palletWt=0d,cAllocQty=0d,cQty=0d;
		double balQty = 0d;
		double grossPer = 0d;
		double netPer = 0d;
		double tarePer = 0d;
		double grossWeight1 = 0d,tareWeight1 = 0d,netWeight1 = 0d;
		DecimalFormat df = new DecimalFormat("#########.###");
		try   
		{
				System.out.println("@@@@@@@ despatchOrder  function called");
				
				//locCode = distComm.getDisparams("999999", "S-ORD", conn);
				//System.out.println("Location code for Despatch from disparm=["+locCode+"]");//Changed by wasim on 11-01-2015 as code is migrated from schdular
				
				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
				SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getDBDateFormat());
				Date today =  java.sql.Timestamp.valueOf(sdf1.format(new java.util.Date()).toString() + " 00:00:00.0");
				System.out.println("==today=="+today);
				userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");  System.out.println("--login code--"+userId);
				termId =  genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"); System.out.println("--term id--"+termId);
				
				sql = "select cust_code,item_ser,site_code,curr_code,exch_rate,tran_code, trans_mode,curr_code__frt,curr_code__ins,cust_code__dlv," +
					    " stan_code,order_date,EXCH_RATE__FRT,EXCH_RATE__INS,FOB_VALUE,CONF_DATE,CHG_DATE,STATE_CODE__DLV,UDF__STR1,UDF__STR2,DLV_ADD1,DLV_ADD2,DLV_ADD3," +
						" DLV_TO,DLV_CITY,DLV_PIN,COUNT_CODE__DLV,TRAN_CODE,STAN_CODE,STAN_CODE__INIT,PARENT__TRAN_ID,REV__TRAN,STATUS_REMARKS,SPEC_REASON,DIST_ROUTE,STATUS,STATUS_DATE"+
						" from sorder where sale_order = ? " ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,saleOrder);
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					custCode = rs.getString("cust_code") == null ? " " : rs.getString("cust_code");
					siteCode = rs.getString("site_code") == null ? " " : rs.getString("site_code")  ;
					currencyCode = rs.getString("curr_code") == null ? " " : rs.getString("curr_code");
					exchRate1 = rs.getString("exch_rate") == null ? " " : rs.getString("exch_rate");
					transMode = rs.getString("trans_mode") == null ? "R " : rs.getString("trans_mode");
					currCodeFrt = rs.getString("curr_code__frt") == null ? " " : rs.getString("curr_code__frt");
					currCodeIns = rs.getString("curr_code__ins") == null ? " " : rs.getString("curr_code__ins");
					currCodedlv = rs.getString("cust_code__dlv") == null ? " " : rs.getString("cust_code__dlv");
					stanCode = rs.getString("stan_code") == null ? "" : rs.getString("stan_code");
					orderDt = rs.getDate("order_date");
					stanCodeDlv = rs.getString("STATE_CODE__DLV") == null ? " " : rs.getString("STATE_CODE__DLV");
					/*----------------------changes done by mahendra on dated 13-oct-14-------------*/
					dlvAdd1 = rs.getString("DLV_ADD1") == null ? " " : rs.getString("DLV_ADD1");
					dlvAdd2 = rs.getString("DLV_ADD2") == null ? " " : rs.getString("DLV_ADD2");
					dlvAdd3 = rs.getString("DLV_ADD3") == null ? " " : rs.getString("DLV_ADD3");
					dlvCity = rs.getString("DLV_CITY") == null ? " " : rs.getString("DLV_CITY");
					dlvPin = rs.getString("DLV_PIN") == null ? " " : rs.getString("DLV_PIN");
					countCodeDlv = rs.getString("COUNT_CODE__DLV") == null ? " " : rs.getString("COUNT_CODE__DLV");
					tranCode = rs.getString("TRAN_CODE") == null ? " " : rs.getString("TRAN_CODE");
					stanCodeInit = rs.getString("STAN_CODE__INIT") == null ? "" : rs.getString("STAN_CODE__INIT");
					//status = rs.getString("STATUS") == null ? " " : rs.getString("STATUS");
					statusRemarks = rs.getString("STATUS_REMARKS") == null ? " " : rs.getString("STATUS_REMARKS");
				}
				rs.close();rs =null;
				pstmt.close();pstmt = null;
				
				sql ="select exp_lev  from sorditem where sale_order = ?  ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,saleOrder);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					explLev = rs.getString("exp_lev")==null ? " ":rs.getString("exp_lev");
				}
				rs.close();rs =null;
				pstmt.close();pstmt = null;
				
				//Changed by wasim on 05-11-2015 
				/*sql ="select shipment_id from porcp where TRAN_ID=? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					shipmentId = rs.getString("shipment_id")==null ? " ":rs.getString("shipment_id");
				}
				rs.close();
				rs =null;
				pstmt.close();
				pstmt = null;
				System.out.println("shipment id is :::::"+shipmentId);*/
					
				/*System.out.println("lrDate date is :"+lrDate);
				lrDateVal=lrDate==null?"":sdf.format(lrDate);
				System.out.println("lrDateVal date is :"+lrDateVal);*/
				
				xmlBuff = new StringBuffer();
				System.out.println("--XML CREATION --");
				xmlBuff.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
				xmlBuff.append("<DocumentRoot>");
				xmlBuff.append("<description>").append("Datawindow Root").append("</description>");
				xmlBuff.append("<group0>");
				xmlBuff.append("<description>").append("Group0 description").append("</description>");
				xmlBuff.append("<Header0>");
				xmlBuff.append("<objName><![CDATA[").append("despatch").append("]]></objName>");  
				xmlBuff.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
				xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
				xmlBuff.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
				xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
				xmlBuff.append("<action><![CDATA[").append("SAVE").append("]]></action>");
				xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
				xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
				xmlBuff.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
				xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
				xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
				xmlBuff.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
				xmlBuff.append("<description>").append("Header0 members").append("</description>");	
				
				
				xmlBuff.append("<Detail1 dbID=\"\" domID=\"1\" objName=\"despatch\" objContext=\"1\">");  
				xmlBuff.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
				xmlBuff.append("<desp_id/>");
				xmlBuff.append("<desp_date><![CDATA["+ sdf.format(orderDt).toString() +"]]></desp_date>");
				xmlBuff.append(	"<sord_date><![CDATA["+ sdf.format(orderDt).toString() +"]]></sord_date>");
				xmlBuff.append("<sord_no><![CDATA["+ saleOrder.trim() +"]]></sord_no>");
				xmlBuff.append("<cust_code><![CDATA["+ custCode.trim() +"]]></cust_code>");
				xmlBuff.append("<cust_code__dlv><![CDATA["+ custCode.trim() +"]]></cust_code__dlv>");
				xmlBuff.append("<stan_code><![CDATA["+ stanCode.trim() +"]]></stan_code>");
				xmlBuff.append("<trans_mode><![CDATA["+ transMode.trim() +"]]></trans_mode>");
				//lrDate added by mahendra dated 05-05-2014
				//xmlBuff.append("<lr_date><![CDATA["+ lrDateVal.toString() +"]]></lr_date>");
				xmlBuff.append("<shipment_id><![CDATA["+ shipmentId.trim() +"]]></shipment_id>");//added by mahendra 17.07.2014(for tnt_track_info shipment id required) 
				xmlBuff.append("<curr_code__frt><![CDATA["+ currCodeFrt.trim() +"]]></curr_code__frt>");
				xmlBuff.append("<curr_code__ins><![CDATA["+ currCodeIns.trim() +"]]></curr_code__ins>");
				xmlBuff.append("<curr_code><![CDATA["+ currencyCode.trim() +"]]></curr_code>");
				xmlBuff.append("<exch_rate><![CDATA["+  exchRate1 +"]]></exch_rate>");// CAN NOT BE NULL
				xmlBuff.append("<exch_rate__frt><![CDATA["+  exchRate1 +"]]></exch_rate__frt>");	
				xmlBuff.append("<exch_rate__ins><![CDATA["+ exchRate1 +"]]></exch_rate__ins>");
				xmlBuff.append("<cust_code__dlv><![CDATA["+ currCodedlv +"]]></cust_code__dlv>");
				xmlBuff.append("<site_code><![CDATA["+ siteCode.trim()+"]]></site_code>");
				xmlBuff.append("<remarks><![CDATA["+ " generate from sale order  "+ saleOrder +"]]></remarks>");				
				xmlBuff.append("<chg_user><![CDATA["+ userId +"]]></chg_user>");
				xmlBuff.append("<chg_term><![CDATA["+ termId +"]]></chg_term>");
				xmlBuff.append("<chg_date><![CDATA["+ today +"]]></chg_date>");
				xmlBuff.append("<state_code__dlv><![CDATA["+ stanCodeDlv.trim()+"]]></state_code__dlv>");
				/*--------------------changed by mahendra on dated 13-oct-14-----------------------------*/
				xmlBuff.append("<dlv_add1><![CDATA["+ dlvAdd1 +"]]></dlv_add1>");
				xmlBuff.append("<dlv_add2><![CDATA["+ dlvAdd3 +"]]></dlv_add2>");
				xmlBuff.append("<dlv_add3><![CDATA["+ dlvAdd2 +"]]></dlv_add3>");
				/*----------------------------------------------------------------------------*/
				xmlBuff.append("<dlv_city><![CDATA["+ dlvCity +"]]></dlv_city>");				
				xmlBuff.append("<dlv_pin><![CDATA["+ dlvPin +"]]></dlv_pin>");
				xmlBuff.append("<count_code__dlv><![CDATA["+ countCodeDlv +"]]></count_code__dlv>");
				xmlBuff.append("<tran_code><![CDATA["+ tranCode +"]]></tran_code>");
				xmlBuff.append("<stan_code__init><![CDATA["+ stanCodeInit.trim() +"]]></stan_code__init>");
				xmlBuff.append("<status_remarks><![CDATA["+ statusRemarks +"]]></status_remarks>");
				//xmlBuff.append("<status><![CDATA["+ status +"]]></status>");
				xmlBuff.append("<status><![CDATA["+status+"]]></status>");//status set blank on dated 17-10-2014
				xmlBuff.append("</Detail1>");
				
			System.out.println("ArrayList size="+lineNoList.size());
			
			/*for(String lineNoInterface : lineNoList)
			{  
				System.out.println("Line["+lineNoInterface+"]");
				lineNoInterface = "   " + lineNoInterface;
				lineNoInterface = lineNoInterface.substring( lineNoInterface.length()-3 );
				System.out.println("Inside First refId["+saleOrder+"]lineNumber=["+lineNoInterface+"]");*/
			
			String lineNoInterface = "";
			Iterator itr = lineNoList.iterator();
			System.out.println("Array Total size in despatchOrder="+lineNoList.size());

			while(itr.hasNext())
			{ 
				HashMap stkMap = new HashMap();
				stkMap = (HashMap) itr.next();
				
				lineNoInterface = (String) stkMap.get("ref_line");
				itemCode = checkNullAndTrim((String) stkMap.get("item_code"));
				siteCode = checkNullAndTrim((String) stkMap.get("site_code"));
				//locCode = checkNullAndTrim((String) stkMap.get("loc_code"));
				lotNo = checkNullAndTrim((String) stkMap.get("lot_no"));
				lotSl = checkNullAndTrim((String) stkMap.get("lot_sl"));
				
				/*sql = "select line_no,item_code,quantity,rate,unit,conv__qty_stduom,unit__rate,tax_class,tax_chap,tax_env,pack_code,rate__clg,quantity__stduom," +
						"net_tot_amt,net_amt,site_code,unit__std,no_art,rate__stduom,conv__rtuom_stduom,PACK_INSTR,NO_PALLET from sorddet where sale_order = ? order by line_no";*/
				sql = "select s.quantity,s.item_code,s.lot_no,s.lot_sl,s.loc_code,s.gross_weight,s.tare_weight,s.net_weight,s.alloc_qty,s.exp_date,"
						+" s.site_code__mfg,s.mfg_date,s.dimension,d.qty_alloc,"
						+" dt.line_no,dt.rate,dt.unit,dt.conv__qty_stduom,dt.unit__rate,dt.tax_class,dt.tax_chap,dt.tax_env,"
						+" dt.pack_code,dt.rate__clg,dt.quantity__stduom,dt.net_tot_amt,dt.net_amt,dt.site_code,dt.unit__std,dt.no_art,dt.rate__stduom,"
						+" dt.conv__rtuom_stduom,dt.pack_instr,dt.no_pallet" 
						+" from sorddet dt,sordalloc d,stock s,sorder h"
						+" where d.sale_order = ?"
						+" and h.sale_order = d.sale_order"
						+" and d.sale_order = dt.sale_order"
						+" and d.line_no = ?"
						+" and d.line_no = dt.line_no"
						+" and s.item_code = d.item_code"
						+" and s.lot_no = d.lot_no"
						+" and s.lot_sl = d.lot_sl "
						+" and s.loc_code = d.loc_code"
						+" and s.site_code = d.site_code"
				
						+" and s.item_code = ?"
						+" and s.site_code = ?"
						+" and s.lot_no = ?"
						+" and s.lot_sl = ?"
						+" and s.loc_code = ?";

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,saleOrder);
				pstmt.setString(2,lineNoInterface);
				
				pstmt.setString(3,itemCode);
				pstmt.setString(4,siteCode);
				pstmt.setString(5,lotNo);
				pstmt.setString(6,lotSl);
				pstmt.setString(7,locCode);
				rs = pstmt.executeQuery();
			   while( rs.next() )
			   {
				    lotSl = rs.getString("lot_sl")==null ? " ":rs.getString("lot_sl");
					lotNo = rs.getString("lot_no")==null ? " ":rs.getString("lot_no");
					//locCode = rs1.getString("LOC_CODE")==null ? " ":rs1.getString("LOC_CODE");
					
					lnNoSord = rs.getString("line_no");	
					itemCode = rs.getString("item_code") == null ? " " : rs.getString("item_code");	
					//quantity = rs.getString("quantity") == null ? "0" : rs.getString("quantity");
					quantity = rs.getString("qty_alloc") == null ? "0" : rs.getString("qty_alloc");
					rate = rs.getString("rate")== null ? " " : rs.getString("rate");
					unit = rs.getString("unit") == null ? " " : rs.getString("unit");
					conQtyStd = rs.getString("conv__qty_stduom") == null ? " " : rs.getString("conv__qty_stduom");
					unitRate = rs.getString("unit__rate") == null ? " " : rs.getString("unit__rate");
					taxClass = rs.getString("tax_class") == null ? " " : rs.getString("tax_class");
					taxChap = rs.getString("tax_chap") == null ? " " : rs.getString("tax_chap");
					taxEnv = rs.getString("tax_env") == null ? " " : rs.getString("tax_env");
					packCode = rs.getString("pack_code") == null ? " " : rs.getString("pack_code");
					packInstr = rs.getString("PACK_INSTR") == null ? " " : rs.getString("PACK_INSTR");
					rateClg = rs.getDouble("rate__clg");
					quntyStduom = rs.getString("quantity__stduom") == null ? "0" : rs.getString("quantity__stduom");
					netTotAmt = rs.getString("net_tot_amt") == null ? " " : rs.getString("net_tot_amt");
					siteCodeDet = rs.getString("site_code") == null ? " " : rs.getString("site_code");	
					unitStd = rs.getString("unit__std") == null ? " " : rs.getString("unit__std");	
					noArt = rs.getString("no_art");	
					rateStduom = rs.getString("rate__stduom");	
					convRtuomStduom = rs.getString("conv__rtuom_stduom");	
					netAmt = rs.getString("net_amt");
					
					qtyStk			= rs.getDouble("quantity");
					grossWeight1	= rs.getDouble("gross_weight");
					tareWeight1		= rs.getDouble("tare_weight");
					netWeight1		= rs.getDouble("net_weight");
					cAllocQty		= rs.getDouble("alloc_qty");
					expDate         = rs.getDate("exp_date");
					siteCodeMfg     = rs.getString("site_code__mfg"); 
					mfgDate         = rs.getDate("mfg_date");
					dimension       = rs.getString("dimension")==null ? " ":rs.getString("dimension");
					
					
					//palletWt = rs.getInt("NO_PALLET");
					//palletWt = rs.getString("NO_PALLET") == null ? " " : rs.getString("NO_PALLET");
					

					/*sql =" SELECT LOT_SL,LOT_NO,LOC_CODE,GROSS_WEIGHT,TARE_WEIGHT,NET_WEIGHT,DIMENSION,PALLET_WT,pack_code  FROM PORCPDET WHERE TRAN_ID = ? AND LINE_NO = ? ";
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1,tranId);
					pstmt1.setString(2,lnNoSord);
					rs1 = pstmt1.executeQuery();
					if (rs1.next())
					{
						lotSl = rs1.getString("LOT_SL")==null ? " ":rs1.getString("LOT_SL");
						lotNo = rs1.getString("LOT_NO")==null ? " ":rs1.getString("LOT_NO");
						locCode = rs1.getString("LOC_CODE")==null ? " ":rs1.getString("LOC_CODE");
						dimension = rs1.getString("DIMENSION")==null ? " ":rs1.getString("DIMENSION");
						grossWeightFmPorcp		= rs1.getDouble("GROSS_WEIGHT");
						tareWeightFmPorcp		= rs1.getDouble("TARE_WEIGHT");
						netWeightFmPorcp		= rs1.getDouble("NET_WEIGHT");
						//palletWt = rs1.getInt("PALLET_WT");
						palletWt = rs1.getDouble("PALLET_WT");
						packCode = rs1.getString("pack_code") == null ? " " : rs1.getString("pack_code");
	
					} 
					rs1.close();rs1 =null;
					pstmt1.close();pstmt1 = null;
				    System.out.println("pallet wt from receipt :"+palletWt);
				    System.out.println("packCode from receipt :"+packCode);*/
				    
					// ADDED BY RITESH ON 26/05/13 START
					/*sqlTemp ="SELECT A.EXP_DATE, " 
							+"A.QUANTITY, "
							+"A.SITE_CODE__MFG, "
							+"A.MFG_DATE, "
							+"A.PACK_CODE, " 
							+"A.GROSS_WEIGHT, "
							+"A.TARE_WEIGHT, "
							+"A.NET_WEIGHT, " 
							+"A.DIMENSION, "
							+"A.SUPP_CODE__MFG, " 
							+"A.QTY_PER_ART, "
							+"A.GROSS_WT_PER_ART, " 
							+"A.TARE_WT_PER_ART ,"  
							+"A.PALLET_WT,  "
							+"A.ALLOC_QTY  "
							+"FROM STOCK A " 
							+"WHERE A.ITEM_CODE = '"+itemCode+"' "  
							+"AND A.SITE_CODE = '"+siteCodeDet+"' "  
							+"AND A.LOC_CODE = '"+locCode+"' "  
							+"AND A.LOT_NO = '"+lotNo+"' "   
							+"AND A.LOT_SL = '"+lotSl+"' ";   
					System.out.println("sqlGetWeight :"+sqlTemp);
					pstmt1 = conn.prepareStatement(sqlTemp);
					rs1 = pstmt1.executeQuery(sqlTemp);
					if (rs1.next())
					{
						qtyStk			= rs1.getDouble("QUANTITY");
						grossWeight		= rs1.getDouble("GROSS_WEIGHT");
						tareWeight		= rs1.getDouble("TARE_WEIGHT");
						netWeight		= rs1.getDouble("NET_WEIGHT");
						//if(dimension == null)
						//dimension		= rs1.getString("DIMENSION");
						//palletWt		= rs1.getDouble("PALLET_WT");
						cAllocQty		= rs1.getDouble("alloc_qty");
						expDate         = rs1.getDate("EXP_DATE");
						siteCodeMfg     = rs1.getString("SITE_CODE__MFG"); 
						mfgDate         = rs1.getDate("MFG_DATE");
					}
					rs1.close();rs1 =null;
					pstmt1.close();pstmt1 = null;
					
					System.out.println(" qtyStk @@@1 ::["+qtyStk+"]");
					System.out.println(" expDate ::["+expDate+"]");
					System.out.println(" siteCodeMfg::["+siteCodeMfg+"]");
					System.out.println(" mfgDate::["+mfgDate+"]");
					System.out.println(" dimension::["+dimension+"]");
					System.out.println(" palletWt::["+palletWt+"]");*/
					
					dimension = dimension == null ? " " : dimension;
					siteCodeMfg = siteCodeMfg == null ? " " : siteCodeMfg;
					
					if(quantity != null && quantity.trim().length() > 0)
					{
						cQty = Double.parseDouble(quantity);
					}
					balQty = cQty - cAllocQty;
					
					if (qtyStk > balQty)
					{
						qtyStk = balQty;
					}
					System.out.println(" qtyStk @@@2 ::["+qtyStk+"]");
					System.out.println(" balQty @@@ ::["+qtyStk+"]");
					if (qtyStk > 0)
					{
						grossPer = (grossWeight1 / qtyStk) ;
						grossPer = df.parse(df.format(grossPer)).doubleValue();
						System.out.println("grossPer :"+grossPer);
						netPer 	=  (netWeight1 / qtyStk);
						netPer = df.parse(df.format(netPer)).doubleValue();
						System.out.println("netPer 	:"+netPer);
						tarePer	=  (tareWeight1 / qtyStk);
						tarePer = df.parse(df.format(tarePer)).doubleValue();
						System.out.println("tarePer	:"+tarePer);									
						grossWeight1 = (balQty * grossPer);
						System.out.println("grossWeight1 :"+grossWeight1);
						netWeight1 = (balQty * netPer);
						System.out.println("netWeight1 :"+netWeight1);
						tareWeight1 = (balQty * tarePer);
						System.out.println("tareWeight1 :"+tareWeight1);	
						
						grossWeight1 = df.parse(df.format(grossWeight1)).doubleValue(); 	
						netWeight1	= df.parse(df.format(netWeight1)).doubleValue(); 	
						tareWeight1	= df.parse(df.format(tareWeight1)).doubleValue(); 
						System.out.println("stk > 0 :: grossWeight1:["+grossWeight1+"]netWeight1:["+netWeight1+"]tareWeight1:["+tareWeight1+"]");
					}
					// ADDED BY RITESH ON 26/05/13 END
					
					System.out.println("Final==grossWeight1:["+grossWeight1+"]netWeight1:["+netWeight1+"]tareWeight1:["+tareWeight1+"]");
					
			    	lnno ++;
			    	System.out.println("--LINE NO--"+lnno);
					xmlBuff.append("<Detail2 dbID='' domID=\"1\" objName=\"despatch\" objContext=\"2\">"); 
					xmlBuff.append("<attribute pkNames=\"\" selected=\"N\" updateFlag=\"A\" status=\"N\" />");
					xmlBuff.append("<desp_id/>");
					xmlBuff.append("<sord_no><![CDATA["+ saleOrder.trim() +"]]></sord_no>");
					
					
					lineNo=String.valueOf(lnno);
					lineNo=lineNo.trim();
				    lineNo="   "+lineNo;
					System.out.println("---"+lineNo+"---");
					lineNo = lineNo.substring(lineNo.length() - 3);
					System.out.println("--@@@@@-"+lineNo+"---");
					xmlBuff.append("<line_no><![CDATA["+lineNo+"]]></line_no>");					
					xmlBuff.append("<line_no__sord><![CDATA["+ lnNoSord +"]]></line_no__sord>");					
					xmlBuff.append("<lot_no><![CDATA["+ lotNo +"]]></lot_no>");					
					xmlBuff.append("<lot_sl><![CDATA["+ lotSl +"]]></lot_sl>");					
					xmlBuff.append("<loc_code><![CDATA["+ locCode +"]]></loc_code>");					
					xmlBuff.append("<exp_lev><![CDATA["+ explLev +"]]></exp_lev>");					
					xmlBuff.append("<remarks><![CDATA["+ "generated from sorder "+"]]></remarks>");					
					xmlBuff.append("<rate><![CDATA["+rate +"]]></rate>");					
					xmlBuff.append("<item_code__ord><![CDATA["+ itemCode.trim() +"]]></item_code__ord>");					
					xmlBuff.append("<item_code><![CDATA["+ itemCode +"]]></item_code>");					
					xmlBuff.append("<quantity><![CDATA["+ quantity.trim() +"]]></quantity>");	
					xmlBuff.append("<quantity__ord><![CDATA["+ quantity.trim() +"]]></quantity__ord>");
					xmlBuff.append("<unit><![CDATA["+ unit+"]]></unit>");					
					xmlBuff.append("<conv__qty_stduom><![CDATA["+ conQtyStd +"]]></conv__qty_stduom>");					
					xmlBuff.append("<unit__rate><![CDATA["+ unitRate +"]]></unit__rate>");				
					xmlBuff.append("<tax_class><![CDATA["+taxClass.trim() +"]]></tax_class>");				
					xmlBuff.append("<tax_chap><![CDATA["+taxChap +"]]></tax_chap>");				
					xmlBuff.append("<tax_env><![CDATA["+ taxEnv+"]]></tax_env>");					
					xmlBuff.append("<rate__clg><![CDATA["+ rateClg +"]]></rate__clg>");					
					xmlBuff.append("<tot_net_amt><![CDATA["+ netTotAmt.trim()+"]]></tot_net_amt>");					
					xmlBuff.append("<site_code><![CDATA["+ siteCodeDet.trim()+"]]></site_code>");					
					xmlBuff.append("<quantity__stduom><![CDATA["+ quntyStduom.trim()+"]]></quantity__stduom>");					
					xmlBuff.append("<pack_code><![CDATA["+ packCode.trim()+"]]></pack_code>");
					xmlBuff.append("<unit__std><![CDATA["+ unitStd+"]]></unit__std>");
					xmlBuff.append("<chg_user><![CDATA["+ userId +"]]></chg_user>");
					xmlBuff.append("<chg_term><![CDATA["+ termId +"]]></chg_term>");
					xmlBuff.append("<chg_date><![CDATA["+ today +"]]></chg_date>");
					xmlBuff.append("<no_art><![CDATA["+ noArt +"]]></no_art>");
					xmlBuff.append("<rate__stduom><![CDATA["+ rateStduom +"]]></rate__stduom>");
					xmlBuff.append("<conv__rtuom_stduom><![CDATA["+ convRtuomStduom +"]]></conv__rtuom_stduom>");
					xmlBuff.append("<tot_net_amt><![CDATA["+ netAmt +"]]></tot_net_amt>");
					xmlBuff.append("<quantity__inv><![CDATA["+ quantity +"]]></quantity__inv>");
					xmlBuff.append("<quantity__real><![CDATA["+ quantity +"]]></quantity__real>");
					// ADDED BY RITESH ON 26/05/13 START
					xmlBuff.append("<gross_weight>").append("<![CDATA[").append(grossWeight1).append("]]>").append("</gross_weight>");
					xmlBuff.append("<nett_weight>").append("<![CDATA[").append(netWeight1).append("]]>").append("</nett_weight>");
					xmlBuff.append("<tare_weight>").append("<![CDATA[").append(tareWeight1).append("]]>").append("</tare_weight>");
					xmlBuff.append("<dimension><![CDATA["+ dimension +"]]></dimension>");
					xmlBuff.append("<pallet_wt><![CDATA["+ palletWt +"]]></pallet_wt>");
					//xmlBuff.append("<pack_code><![CDATA["+ packCode +"]]></pack_code>");
					// ADDED BY RITESHON 26/05/13 END
					xmlBuff.append("<pack_instr><![CDATA["+packInstr.trim()+"]]></pack_instr>");
					xmlBuff.append("<site_code__mfg><![CDATA["+siteCodeMfg.trim()+"]]></site_code__mfg>");
					if(expDate != null)
					{
						xmlBuff.append("<exp_date><![CDATA["+sdf.format(expDate).toString()+"]]></exp_date>");
					}
					else
					{
						xmlBuff.append("<exp_date><![CDATA[]]></exp_date>");
					}
					if(mfgDate != null)
					{
						xmlBuff.append("<mfg_date><![CDATA["+sdf.format(mfgDate).toString()+"]]></mfg_date>");
					}
					else
					{
						xmlBuff.append("<mfg_date><![CDATA[]]></mfg_date>");
					}
					
					xmlBuff.append("</Detail2>");
			    }
			   rs.close(); rs = null;
			   pstmt.close();pstmt = null;
			} 
			    lnno = 0;
				xmlBuff.append("</Header0>");
				xmlBuff.append("</group0>");
				xmlBuff.append("</DocumentRoot>");
				xmlString = xmlBuff.toString();
				System.out.println("xmlString  for despatch:"+xmlBuff.toString());
				siteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
				System.out.println("site code =="+siteCode);
				retString = saveData(siteCode,xmlString,conn);
				System.out.println("retString from despatch:"+retString);
				
				if (retString.indexOf("Success") > -1)
				{
					System.out.println("Despatch created successfully");
					/*System.out.println("@@@@@@3: retString from despatch"+retString);
					conn.commit();
					-----------------------------------------------------------------------
					System.out.println("update pack code before confirmation !!! ");
					String[] arrayForTranId = retString.split("<TranID>");
					int endIndex = arrayForTranId[1].indexOf("</TranID>");
					String tranIdForDesp = arrayForTranId[1].substring(0,endIndex);
					System.out.println("-tranIdForDesp-"+tranIdForDesp);
					System.out.println("packInstr  : "+packInstr);
					System.out.println("packCode  : "+packCode);
					
					
					sql = "select PACK_CODE,PACK_INSTR,Line_no from porcpdet where TRAN_ID = ?";
					pstmt2  = conn.prepareStatement(sql);
					pstmt2.setString(1,tranId);
					rs2 = pstmt2.executeQuery();
					while(rs2.next())
					{
						packCode=rs2.getString("pack_code");
						packInstr=rs2.getString("PACK_INSTR");
						lineNo=rs2.getString("Line_no");
						
						System.out.println("packCode :"+packCode +"@packInstr :"+packInstr+" @lineNo :"+lineNo);
						
						sql = " update despatchdet set PACK_INSTR = ?,PACK_CODE = ?  where desp_id = ?  and line_no = ?";
						pstmt  = conn.prepareStatement(sql);
						pstmt.setString(1,packInstr);
						pstmt.setString(2,packCode);
						pstmt.setString(3,tranIdForDesp);
						pstmt.setString(4,lineNo);
											
						int row = pstmt.executeUpdate();
						System.out.println("updated rows@@@ =="+row);
						conn.commit();
						
					}
					pstmt2.close();
					pstmt2 = null;
					rs2.close();
					rs2 = null;
								
					varValue = dComm.getDisparams("999999","AUTO_CONF_DESP", conn); 
					System.out.println("varValue --"+varValue);
					if("Y".equalsIgnoreCase(varValue.trim()))
					{
						//retString = confirmSaleOrder("despatch",tranIdForDesp,xtraParams,conn);
						System.out.println("retString from conf from despatch ::"+retString);
						return retString;
					}*/
				}
		}
		catch(Exception e)
		{
			System.out.println("Catche despatchOrder");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(rs != null){rs.close();rs = null;}
				if(pstmt1 != null){pstmt1.close();pstmt1 = null;}
				if(rs1 != null){rs1.close();rs1 = null;}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("Returning Result [" + retString + "]");
		return retString;
	}
	private String saveData(String siteCode,String xmlString, Connection conn) throws ITMException
	{
		System.out.println("saving data...........");
		InitialContext ctx = null;
		String retString = null;
		MasterStatefulLocal masterStateful = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
			System.out.println("-----------masterStateful------- " + masterStateful);
			String [] authencate = new String[2];
			authencate[0] = "";
			authencate[1] = "";
			System.out.println("xmlString to masterstateful [" + xmlString + "]");
			retString = masterStateful.processRequest(authencate, siteCode, true, xmlString,true,conn);
			System.out.println("--retString - -"+retString);
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :CreateDistOrder :saveData :==>");
			throw itme;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :CreateDistOrder :saveData :==>");
			throw new ITMException(e);
		}
		return retString;
	}
	
	@SuppressWarnings("unused")
	private String getLocCodeTo(String itemCode,Connection conn)  throws ITMException, Exception
	{
		String locCodeTo = "",itemSerRg = "";
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		String sql = "";
		try
		{
			sql = "SELECT ITEM_SER__FG1 FROM ITEM WHERE ITEM_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemSerRg = checkNullAndTrim(rs.getString("ITEM_SER__FG1"));
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			
			System.out.println("ITEM_SER__FG1["+itemSerRg+"]");
			
			locCodeTo = checkNullAndTrim(distComm.getDisparams("999999", itemSerRg , conn));
		}
		catch(Exception e)
		{
			System.out.println("Catch getLocCodeTo");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null){pstmt.close();pstmt = null;}
				if(rs != null){rs.close();rs = null;}
			}
			catch(Exception ex)
			{
				throw new ITMException(ex);
			}
		}
		System.out.println("Location code returing["+locCodeTo+"]");
		return locCodeTo;
	}
}

