/*

<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<Root>
	<Detail1>
		<id>1</id>
		<name>Pankaj</name>
		<age>29</age>
		<role>Java Developer</role>
		<gender>Male</gender>
	</Detail1>
	<Detail1>
		<id>2</id>
		<name>Lisa</name>
		<age>35</age>
		<role>CSS Developer</role>
		<gender>Female</gender>
	</Detail1>
</Root>

*/




package ibase.webitm.bean.sys;

import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;

import java.text.SimpleDateFormat;
import java.util.*;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProteusDataSource 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	private String dataObjNmae = "";
	private String dataSourceSQL = "";
	private Connection transactionObject = null;
	private	int rowCount = 0;
	private int columnCount = 0;
	private HashMap modifiedRowMap = new HashMap();
	private HashMap columnsAttributeMap = new HashMap();
	private Document editDom = null;
	private	String objName = "";
	private	int formNo = 0;
	private	NodeList parentNodeList = null;
	private	NodeList childNodeList = null;
	private String formTagName = null;
	private String[] columnList;

	public ProteusDataSource( String objName, String domStr , int formNo) throws ITMException
	{
		Document localDom = null;
		Node parentNode = null;
		String childNodeName = "";
		try
		{
			if (domStr.indexOf("<Root>") == -1)
			{
				domStr = "<Root>\r\n" + domStr + "</Root>";
			}
			localDom = genericUtility.parseString(domStr);
			initiateProteusDataSource(objName, localDom, formNo);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}

	}

	public ProteusDataSource( String objName, Document argDom , int formNo) throws ITMException
	{
		try
		{
			String domStr = genericUtility.serializeDom(argDom);
			if (domStr.indexOf("<Root>") == -1)
			{
				domStr = "<Root>\r\n" + domStr + "</Root>";
			}
			argDom = genericUtility.parseString(domStr);
			initiateProteusDataSource(objName, argDom, formNo);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}		
	}

	private void initiateProteusDataSource( String objName, Document argDom , int formNo) throws ITMException
	{
		Node parentNode = null;
		String childNodeName = "";
		Node childNode = null;
		try
		{
			this.objName = objName;
			this.editDom = argDom;
			this.formNo = formNo;
			this.parentNodeList = this.editDom.getElementsByTagName("Detail" + formNo);
			this.rowCount = this.parentNodeList.getLength();
			parentNode = this.parentNodeList.item(0);
			this.childNodeList = parentNode.getChildNodes();
			int childNodeListLength = this.childNodeList.getLength();
			this.columnCount = childNodeListLength;
			this.formTagName = "Detail" + this.formNo;
			System.out.println("serialize editDom ::"+genericUtility.serializeDom(this.editDom));
			this.columnList = new String[childNodeListLength];
			for(int ctr = 0; ctr < childNodeListLength; ctr++)
			{
				childNode = childNodeList.item(ctr);
				if (childNode.getNodeType() != Node.ELEMENT_NODE) 
				{
					continue;
				}
				this.columnList[ctr] = childNodeList.item(ctr).getNodeName();
				this.columnsAttributeMap.put((String)childNodeList.item(ctr).getNodeName().trim() + "_protect" , "X");
			}
		

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}		
	}


	public int setItem(int rowNum, String columnName ,  int columnValue) throws ITMException
	{
		Element element = null;
		Node node = null;
		int returnValue = 0;
		try
		{
			element = (Element) this.parentNodeList.item(rowNum - 1);
			node = element.getElementsByTagName(columnName).item(0).getFirstChild();
			node.setNodeValue("" + columnValue);
			ArrayList modifiedColNames = new ArrayList();
			if (this.modifiedRowMap.get(rowNum) != null)
			{
				modifiedColNames = (ArrayList)this.modifiedRowMap.get(rowNum);
			}
			if (!modifiedColNames.contains(columnName))
			{
				modifiedColNames.add(columnName);
				this.modifiedRowMap.put(rowNum , modifiedColNames);
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return returnValue;
	}

	public int setItem(int rowNum, String columnName ,  String columnValue) throws ITMException
	{
		Element element = null;
		Node node = null;
		int returnValue = 0;
		try
		{
			element = (Element) this.parentNodeList.item(rowNum - 1);
			node = element.getElementsByTagName(columnName).item(0).getFirstChild();
			node.setNodeValue(columnValue);
			ArrayList modifiedColNames = new ArrayList();
			if (this.modifiedRowMap.get(rowNum) != null)
			{
				modifiedColNames = (ArrayList)this.modifiedRowMap.get(rowNum);
			}
			if (!modifiedColNames.contains(columnName))
			{
				modifiedColNames.add(columnName);
				this.modifiedRowMap.put(rowNum , modifiedColNames);
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return returnValue;
	}

	public int setItem(int rowNum, String columnName ,  double columnValue) throws ITMException
	{
		Element element = null;
		Node node = null;
		int returnValue = 0;
		try
		{
			element = (Element) this.parentNodeList.item(rowNum - 1);
			node = element.getElementsByTagName(columnName).item(0).getFirstChild();
			node.setNodeValue("" + columnValue);
			ArrayList modifiedColNames = new ArrayList();
			if (this.modifiedRowMap.get(rowNum) != null)
			{
				modifiedColNames = (ArrayList)this.modifiedRowMap.get(rowNum);
			}
			if (!modifiedColNames.contains(columnName))
			{
				modifiedColNames.add(columnName);
				this.modifiedRowMap.put(rowNum , modifiedColNames);
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return returnValue;
	}

	public String getItemString(int rowNum, String columnName) throws ITMException
	{
		Node parentNode = null;
		Node childNode = null;
		NodeList childNodeList = null;
		String columnValue = null;
		String returnValue = null;
		int childNodeListLength = 0;
		try
		{
			parentNode =  this.parentNodeList.item(rowNum - 1);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			for (int childRow = 0; childRow < childNodeListLength; childRow++)
			{
				childNode = childNodeList.item(childRow);
				if( childNode.getNodeType() != Node.ELEMENT_NODE )
				{
					continue;
				}
				String childNodeName = childNode.getNodeName(); 
				if (!childNodeName.equals(columnName))
				{
					continue;
				}
				if (childNode.getFirstChild() != null)
				{
					columnValue = childNode.getFirstChild().getNodeValue();
				}
				if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0)
				{
					returnValue = columnValue;
				}
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return returnValue;
	}

/*
	public String getItemString(int rowNum, String columnName) throws ITMException
	{
		Element element = null;
		String columnValue = null;
		String returnValue = null;
		try
		{
			element = (Element) this.parentNodeList.item(rowNum - 1);
			columnValue = element.getElementsByTagName(columnName).item(0).getFirstChild().getNodeValue();
			if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0)
			{
				returnValue = columnValue;
			}

			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return returnValue;
	}
*/

	public Integer getItemNumber(int rowNum, String columnName) throws ITMException
	{
		String columnValue = null;
		Integer returnValue = null;
		try
		{

			columnValue = getItemString(rowNum , columnName);
			if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0)
			{
				returnValue = Integer.parseInt(columnValue);
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return returnValue;
	}


	public Integer getItemNumber(int rowNum, String columnName, Integer i) throws ITMException
	{
		String columnValue = null;
		Integer returnValue = null;
		try
		{
			columnValue = getItemString(rowNum , columnName);
			if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0)
			{
				int decPos = columnValue.indexOf(".");
				if (decPos != -1)
				{
					if (decPos > 0)
					{
						columnValue = columnValue.substring(0 , decPos);
					}
					else
					{
						columnValue = "0";
					}
				}
				returnValue = Integer.parseInt(columnValue);
			}
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return returnValue;
	}


	public Double getItemNumber(int rowNum, String columnName, Double d) throws ITMException
	{
		String columnValue = null;
		Double returnValue = null;
		try
		{
			columnValue = getItemString(rowNum , columnName);
			if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0)
			{
				returnValue = Double.parseDouble(columnValue);
			}
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return returnValue;
	}


	public Double getItemDecimal(int rowNum, String columnName) throws ITMException
	{
		String columnValue = null;
		Double returnValue = null;
		try
		{
			columnValue = getItemString(rowNum , columnName);
			if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0)
			{
				returnValue = Double.parseDouble(columnValue);
			}
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return returnValue;
	}

	public java.sql.Timestamp getItemDateTime(int rowNum, String columnName) throws ITMException
	{
		String columnValue = null;
		java.sql.Timestamp returnValue = null;
		try
		{
			columnValue = getItemString(rowNum , columnName);
			if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0)
			{
				returnValue = java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(columnValue, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
			}
		}
		catch (Exception e)
		{
			//throw new ITMException(e);
			returnValue = null;
		}
		return returnValue;
	}

	public java.sql.Date getItemDate(int rowNum, String columnName) throws ITMException
	{
		String columnValue = null;
		java.sql.Date returnValue = null;
		try
		{
			columnValue = getItemString(rowNum , columnName);
			if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0)
			{
				returnValue = java.sql.Date.valueOf(genericUtility.getValidDateString(columnValue, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
			}
		}
		catch (Exception e)
		{
			//throw new ITMException(e);
			returnValue = null;
		}
		return returnValue;
	}


	public String getXmlString() throws ITMException
	{
		String output = null;
		try 
		{
			output = genericUtility.serializeDom(this.editDom);
		} 
		catch (Exception e) 
		{
			System.out.println("HHHHH::: " + e);
			e.printStackTrace();
			throw new ITMException(e);
		}
        return output;
    }

	public String getXmlString(String s) throws ITMException
	{
		String output = null;
		StringBuffer xmlString = new StringBuffer();

		xmlString.append("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
		xmlString.append("A").append("</editFlag>\r\n</Header>\r\n");
		try 
		{


			for (int i=0; i<this.rowCount; i++)
			{
				xmlString.append("<" + formTagName + ">\r\n");
				for (int j=0; j < this.columnCount; j++)
				{
					String columnValue = getItemString(i+1 ,this.columnList[j]);
					String columnProtect = (String)this.columnsAttributeMap.get(this.columnList[j] + "_protect");
					if (columnProtect != null && columnProtect.length() > 0 && !columnProtect.equalsIgnoreCase("X"))
					{
						columnProtect = " protect='" + columnProtect + "'";
					}
					else
					{
						columnProtect = "";
					}
					xmlString.append("<" + this.columnList[j] + columnProtect + ">");
					if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0)
					{
						xmlString.append("<![CDATA[" + columnValue + "]]>");
					}
					xmlString.append("</" +this.columnList[j] + ">\r\n");
				}
				xmlString.append("</" + formTagName + ">\r\n");
			}			
			xmlString.append("</Root>");
			output = xmlString.toString();
		} 
		catch (Exception e) 
		{
			System.out.println("HHHHH::: " + e);
			e.printStackTrace();
			throw new ITMException(e);
		}
        return output;
    }

	public String getChangedXmlString() throws ITMException
	{
		String output = null;
		int key = 0;
		Integer ikey = 0;
		int modifiedColumnCounts = 0;
		StringBuffer xmlString = new StringBuffer();
		ArrayList modifiedColumnList = new ArrayList();

		xmlString.append("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
		xmlString.append("A").append("</editFlag>\r\n</Header>\r\n");
		try 
		{
			Iterator keySetIterator = this.modifiedRowMap.keySet().iterator();
			while(keySetIterator.hasNext())
			{ 
				//key = (int)keySetIterator.next(); 
				//Added by arun 1-11-17 start 
				key = Integer.parseInt((String)keySetIterator.next());
				//Added by arun 1-11-17 ended 
				modifiedColumnList = (ArrayList)this.modifiedRowMap.get(key);
				modifiedColumnCounts = modifiedColumnList.size();
				if (modifiedColumnCounts > 0)
				{
					xmlString.append("<" + formTagName + ">\r\n");
					String[] modifiedColumnNames ;
					modifiedColumnNames = new String[modifiedColumnCounts];
					for (int i = 0; i < modifiedColumnCounts; i++)
					{
						modifiedColumnNames[i] = modifiedColumnList.get(i).toString();
						String columnValue = getItemString(key , modifiedColumnNames[i]);
						String columnProtect = (String)this.columnsAttributeMap.get(modifiedColumnNames[i] + "_protect");
						if (columnProtect != null && columnProtect.length() > 0 && !columnProtect.equalsIgnoreCase("X"))
						{
							columnProtect = " protect='" + columnProtect + "'";
						}
						else
						{
							columnProtect = "";
						}
						xmlString.append("<" + modifiedColumnNames[i] + columnProtect + ">");
						if (columnValue != null && !columnValue.equalsIgnoreCase("null") && !columnValue.equalsIgnoreCase("<null>") && columnValue.length() > 0)
						{
							xmlString.append("<![CDATA[" + columnValue + "]]>");
						}
						xmlString.append("</" + modifiedColumnNames[i] + ">\r\n");
					}
				}
				modifiedColumnList.clear();
				modifiedColumnCounts = 0;
				xmlString.append("</" + formTagName + ">\r\n");
			}
			xmlString.append("</Root>");
			output = xmlString.toString();
		} 
		catch (Exception e) 
		{
			System.out.println("HHHHH::: " + e);
			e.printStackTrace();
			throw new ITMException(e);
		}
        return output;
    }

	public int getRowCount() throws ITMException
	{
		String output = null;
		try 
		{
			this.parentNodeList = this.editDom.getElementsByTagName(formTagName);
			this.rowCount = this.parentNodeList.getLength();
		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
        return this.rowCount;
    }

	public int insertRow(int rowPos) throws ITMException
	{
		NodeList rootNode = null;
		Element element = null;
		Element newElement = null;
		ArrayList modifiedColNames = new ArrayList();
		try 
		{

			rootNode = this.editDom.getElementsByTagName("Root");
			element = (Element)rootNode.item(0);
				System.out.println("\r\n Inside Insert Row 1");
			newElement = this.editDom.createElement(this.formTagName);
				System.out.println("\r\n Inside Insert Row 2");
			newElement.appendChild(this.editDom.createTextNode(""));
            element.appendChild(newElement);
				System.out.println("\r\n Inside Insert Row 3");
			this.parentNodeList = this.editDom.getElementsByTagName(formTagName);
				System.out.println("\r\n Inside Insert Row 4");
			this.rowCount = this.parentNodeList.getLength();
				System.out.println("\r\n Inside Insert Row 5 --- " + this.rowCount);
			element = (Element)this.parentNodeList.item(this.rowCount);
				System.out.println("\r\n Inside Insert Row 6");
				System.out.println("\r\n Inside Insert Row 6 -- " + this.columnCount);
			for ( int ctr = 0;ctr < this.columnCount; ctr++)
			{
				newElement = this.editDom.createElement(this.columnList[ctr]);
				System.out.println("\r\n Inside Insert Row 7");
				newElement.appendChild(this.editDom.createTextNode(""));
				System.out.println("\r\n Inside Insert Row 8");
				element = (Element)this.parentNodeList.item(this.rowCount - 1);
				System.out.println("\r\n Inside Insert Row 9");
				element.appendChild(newElement);
				System.out.println("\r\n Inside Insert Row 10");
				modifiedColNames.add(this.columnList[ctr]);
			}
			this.modifiedRowMap.put(this.rowCount , modifiedColNames);
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
        return rowCount;
    }

	public void modifyDsAttribute(String columnName , String columnAttributeName , String columnAttributeValue) throws ITMException
	{
		try
		{
			String columnAttribute = columnName.trim() + "_" + columnAttributeName.trim();
			System.out.println("columnAttribute::: " + columnAttribute);
			this.columnsAttributeMap.put(columnAttribute , columnAttributeValue);
			for (int i=1; i <= this.rowCount; i++)
			{
				ArrayList modifiedColNames = new ArrayList();
				if (this.modifiedRowMap.get(i) != null)
				{
					modifiedColNames = (ArrayList)this.modifiedRowMap.get(i);
				}
				if (!modifiedColNames.contains(columnName))
				{
					modifiedColNames.add(columnName);
					this.modifiedRowMap.put(i , modifiedColNames);
				}
			}
		}
		catch (Exception e)
		{
			System.out.println("HHHHH::: " + e);
			e.printStackTrace();
			throw new ITMException(e);
		}
	}

}
