/*
 * Decompiled with CFR 0.152.
 */
package ibase.e12ria.client;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.NamedNodeMap;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import ibase.e12ria.client.E12Constants;
import ibase.e12ria.client.E12Global;
import ibase.e12ria.client.HomePgActionInfoBean;
import ibase.e12ria.client.LinkActionInfoBean;
import ibase.e12ria.client.resources.Resources;
import ibase.e12ria.e12table.client.ColumnInfoBean;
import ibase.e12ria.e12table.client.DataGridTableRowModel;
import ibase.e12ria.e12widgets.client.E12TextBox;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class E12CommonUtils {
    static E12CommonUtils e12CommonUtils = null;
    HashMap<String, LinkActionInfoBean> linkActionInfoMap;

    public static E12CommonUtils getInstance() {
        try {
            if (e12CommonUtils == null) {
                e12CommonUtils = new E12CommonUtils();
            }
        }
        catch (Exception e) {
            Window.alert((String)("Exception : E12CommonUtils getInstance " + e.getMessage()));
            e.printStackTrace();
        }
        return e12CommonUtils;
    }

    static String checkNull(String value) {
        if (value == "undefined" || value == null) {
            value = "";
        }
        return value;
    }

    public HashMap<Integer, ColumnInfoBean> setMetadataInfoInMap(NodeList textObjNodes, NodeList colObjNodes, NodeList colInfoNodeList) {
        HashMap<Integer, ColumnInfoBean> metadataInfoHMap = new HashMap<Integer, ColumnInfoBean>();
        ArrayList<String> colDisplayNameList = E12CommonUtils.getColDisplayNameList(colInfoNodeList);
        ArrayList<String> colLogicalNameList = E12CommonUtils.getColLogicalNameList(colInfoNodeList);
        ArrayList<String> colPhysicalNamelist = this.getColPhysicalNameList(colInfoNodeList);
        int key = 0;
        int i = 0;
        while (i < textObjNodes.getLength()) {
            NodeList textObjItems = textObjNodes.item(i).getChildNodes();
            String text = textObjItems.item(2).getFirstChild().getNodeValue();
            String width = textObjItems.item(8).getFirstChild().getNodeValue();
            String phyName = "";
            String logicalName = "";
            String name = textObjItems.item(10).getFirstChild().getNodeValue().trim();
            String textLogicalName = name.substring(0, name.lastIndexOf("_t"));
            int j = 0;
            while (j < colLogicalNameList.size()) {
                if (textLogicalName.equalsIgnoreCase(colLogicalNameList.get(j))) {
                    phyName = colPhysicalNamelist.get(j);
                    logicalName = colLogicalNameList.get(j);
                    ColumnInfoBean colInfoBean = new ColumnInfoBean(text, phyName, logicalName, width);
                    metadataInfoHMap.put(new Integer(key), colInfoBean);
                    ++key;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return metadataInfoHMap;
    }

    private ArrayList<String> getColPhysicalNameList(NodeList colInfoNodeLst) {
        ArrayList<String> phyNameList = new ArrayList<String>();
        int i = 0;
        while (i < colInfoNodeLst.getLength()) {
            String physicalName = colInfoNodeLst.item(i).getAttributes().getNamedItem("physicalName").getNodeValue();
            String[] actualPhyName = physicalName.split("\\.");
            phyNameList.add(actualPhyName[1]);
            ++i;
        }
        return phyNameList;
    }

    private static ArrayList<String> getColLogicalNameList(NodeList colInfoNodeLst) {
        ArrayList<String> logicalNameList = new ArrayList<String>();
        int i = 0;
        while (i < colInfoNodeLst.getLength()) {
            String logicalName = colInfoNodeLst.item(i).getAttributes().getNamedItem("logicalName").getNodeValue();
            logicalNameList.add(logicalName);
            ++i;
        }
        return logicalNameList;
    }

    private static ArrayList<String> getColDisplayNameList(NodeList colInfoNodeLst) {
        ArrayList<String> displayNameList = new ArrayList<String>();
        int i = 0;
        while (i < colInfoNodeLst.getLength()) {
            String displayName = colInfoNodeLst.item(i).getAttributes().getNamedItem("displayName").getNodeValue();
            displayNameList.add(displayName);
            ++i;
        }
        return displayNameList;
    }

    public HashMap<String, ArrayList> parseTokenizedString(String tokenizedStr) {
        HashMap<String, ArrayList> tokenMainMap = new HashMap<String, ArrayList>();
        try {
            String[] elementsStrArr = tokenizedStr.split("~ELEMSEP~");
            ArrayList<HashMap<String, String>> colObjStrArr = new ArrayList<HashMap<String, String>>();
            ArrayList<HashMap<String, String>> txtObjStrArr = new ArrayList<HashMap<String, String>>();
            ArrayList<HashMap<String, String>> tableColObjStrArr = new ArrayList<HashMap<String, String>>();
            int ctr = 0;
            while (ctr < elementsStrArr.length) {
                String[] strTok = elementsStrArr[ctr].split("~OBJSEP~");
                HashMap<String, String> tokenMap = this.parseTokens(strTok[1]);
                if (strTok[0].equalsIgnoreCase("ColumnObject")) {
                    colObjStrArr.add(tokenMap);
                } else if (strTok[0].equalsIgnoreCase("TextObject")) {
                    txtObjStrArr.add(tokenMap);
                } else if (strTok[0].equalsIgnoreCase("table_column")) {
                    tableColObjStrArr.add(tokenMap);
                }
                ++ctr;
            }
            tokenMainMap.put("ColumnObject", colObjStrArr);
            tokenMainMap.put("TextObject", txtObjStrArr);
            tokenMainMap.put("table_column", tableColObjStrArr);
        }
        catch (Exception e) {
            Window.alert((String)("parseTokenizedString Exception[" + e.getMessage() + "]"));
        }
        return tokenMainMap;
    }

    private HashMap<String, String> parseTokens(String tokenizedStr) {
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        String[] strMainTok = tokenizedStr.split("~PROPSEP~");
        int i = 0;
        while (i < strMainTok.length) {
            String[] strTok = strMainTok[i].split("~PROPVALSEP~");
            String strTok0 = strTok[0];
            String strTok1 = strTok.length > 1 ? strTok[1] : "";
            tokenMap.put(strTok0, E12Global.checkNull(strTok1));
            ++i;
        }
        return tokenMap;
    }

    public HashMap<String, ArrayList> parseMetadataXML(String metadataXMLStr) {
        HashMap<String, ArrayList> nodeMainMap = new HashMap<String, ArrayList>();
        Document doc = XMLParser.parse((String)metadataXMLStr);
        XMLParser.removeWhitespace((Node)doc);
        NodeList colNodeList = doc.getElementsByTagName("ColumnObject");
        NodeList txtNodeList = doc.getElementsByTagName("TextObject");
        NodeList tblNodeList = doc.getElementsByTagName("table_column");
        ArrayList<HashMap<String, String>> colObjStrArr = new ArrayList<HashMap<String, String>>();
        ArrayList<HashMap<String, String>> txtObjStrArr = new ArrayList<HashMap<String, String>>();
        ArrayList<HashMap<String, String>> tableColObjStrArr = new ArrayList<HashMap<String, String>>();
        int len = colNodeList.getLength();
        int cntr = 0;
        while (cntr < len) {
            Node colObjNode = colNodeList.item(cntr);
            colObjStrArr.add(this.parseNode(colObjNode));
            ++cntr;
        }
        len = txtNodeList.getLength();
        cntr = 0;
        while (cntr < len) {
            Node txtObjNode = txtNodeList.item(cntr);
            txtObjStrArr.add(this.parseNode(txtObjNode));
            ++cntr;
        }
        len = tblNodeList.getLength();
        cntr = 0;
        while (cntr < len) {
            Node tblObjNode = tblNodeList.item(cntr);
            tableColObjStrArr.add(this.parseNode(tblObjNode));
            ++cntr;
        }
        nodeMainMap.put("ColumnObject", colObjStrArr);
        nodeMainMap.put("TextObject", txtObjStrArr);
        nodeMainMap.put("table_column", tableColObjStrArr);
        return nodeMainMap;
    }

    public HashMap<String, String> parseNode(Node elementNode) {
        HashMap<String, String> nodeMap = new HashMap();
        nodeMap = this.processAttributes(elementNode);
        NodeList childNodeList = elementNode.getChildNodes();
        int len = 0;
        if (childNodeList != null) {
            len = childNodeList.getLength();
        }
        int cntr = 0;
        while (cntr < len) {
            Node childElmNode = childNodeList.item(cntr);
            if (childElmNode != null) {
                HashMap<String, String> attribMap = this.processAttributes(childElmNode);
                String nodeName = childElmNode.getNodeName();
                String nodeValue = "";
                nodeValue = childElmNode.getFirstChild() != null ? childElmNode.getFirstChild().getNodeValue() : childElmNode.getNodeValue();
                nodeMap.put(nodeName, nodeValue);
                if (attribMap != null) {
                    nodeMap.putAll(attribMap);
                }
            }
            ++cntr;
        }
        return nodeMap;
    }

    private HashMap<String, String> processAttributes(Node node) {
        HashMap<String, String> attribMap = null;
        if (node.hasAttributes()) {
            attribMap = new HashMap<String, String>();
            NamedNodeMap attributes = node.getAttributes();
            int len = 0;
            if (attributes != null) {
                len = attributes.getLength();
            }
            int cntr = 0;
            while (cntr < len) {
                Node attribNode = attributes.item(cntr);
                if (attribNode != null && attribNode.getNodeType() == 2) {
                    String nodeName = String.valueOf(node.getNodeName()) + "." + attribNode.getNodeName();
                    String nodeValue = attribNode.getNodeValue();
                    attribMap.put(nodeName, nodeValue);
                }
                ++cntr;
            }
        }
        return attribMap;
    }

    public boolean isValidDate(String date) {
        DateTimeFormat dtf = DateTimeFormat.getFormat((String)E12Constants.dispDate);
        Date testDate = null;
        try {
            testDate = dtf.parse(date);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    protected void performLinkAction(LinkActionInfoBean linkActionInfoBean, StringBuffer pkFieldValue, String objName, ArrayList<String> dataGridHeaderLogicalColName, boolean isAnyRowSelected, DataGridTableRowModel selectedDGTRModel) {
        try {
            String targetObjName = linkActionInfoBean.getTargetObj();
            String linkType = linkActionInfoBean.getLilnkType();
            String linkUri = linkActionInfoBean.getLinkUri();
            String linkArgmnt = linkActionInfoBean.getLinkArg();
            String linkTitle = linkActionInfoBean.getTitle();
            String linkForm = linkActionInfoBean.getLinkForm();
            String paramType = "";
            String qryParam = "";
            char pageCtx = '\u0001';
            char objCtx = '\u0001';
            String url = "";
            ArrayList<String> targetField = new ArrayList<String>();
            ArrayList<String> sourceField = new ArrayList<String>();
            ArrayList<String> dateType = new ArrayList<String>();
            if (targetObjName.length() + 2 == linkForm.length()) {
                pageCtx = linkForm.charAt(targetObjName.length());
                objCtx = linkForm.charAt(targetObjName.length() + 1);
            }
            String[] argNameArray = linkArgmnt.split(",");
            int cnt = 0;
            while (cnt < argNameArray.length) {
                targetField.add(argNameArray[cnt].substring(argNameArray[cnt].lastIndexOf(":") + 1, argNameArray[cnt].length()));
                sourceField.add(argNameArray[cnt].substring(0, argNameArray[cnt].lastIndexOf(".")));
                dateType.add(argNameArray[cnt].substring(argNameArray[cnt].lastIndexOf(".") + 1, argNameArray[cnt].lastIndexOf(":")));
                ++cnt;
            }
            String qryStr = this.getQueryParam(sourceField, targetField, dataGridHeaderLogicalColName, isAnyRowSelected, selectedDGTRModel);
            String[] qryStrArray = qryStr.split("&");
            int i = 0;
            while (i < qryStrArray.length) {
                qryParam = String.valueOf(qryParam) + qryStrArray[i].substring(qryStrArray[i].lastIndexOf("=") + 1, qryStrArray[i].length()) + ":";
                ++i;
            }
            int countp = 0;
            while (countp < dateType.size()) {
                paramType = String.valueOf(paramType) + (String)dateType.get(countp) + ":";
                ++countp;
            }
            if ("1".equals(linkType)) {
                if (objName.equals("sorder_confirmed")) {
                    if (!"".equals(pkFieldValue.toString().trim()) && pkFieldValue.length() > 0) {
                        url = "/ibase/webitm/jsp/ViewStatus.jsp?OBJ_NAME=" + objName + "&PK_FIELDVALUE=" + pkFieldValue;
                    } else {
                        Window.alert((String)E12Constants.constants.setTransactionFailed());
                    }
                } else if (pageCtx == '\u0001' && objCtx == '\u0001') {
                    url = "/ibase/webitm/jsp/ITMLinkPage.jsp?&TAR_OBJ_NAME=" + targetObjName + "&LINK_DESCR=" + linkTitle + "&QRY_PARAM=" + qryParam + "&QRY_PARAM_TYPE=" + paramType + "&OBJ_CTXT=" + objCtx;
                } else if (!"".equals(pkFieldValue.toString().trim()) && pkFieldValue.length() > 0) {
                    url = "/ibase/webitm/jsp/ITMTransactionEditor.jsp?OBJ_TITLE=" + targetObjName.toUpperCase() + "&OBJ_NAME=" + targetObjName + "&PAGE_CONTEXT=" + pageCtx + "&OBJ_CONTEXT=" + objCtx + "&EDIT_FLAG=V&DB_ID=" + pkFieldValue + "&PARAM_TYPE=" + paramType;
                    url = String.valueOf(url) + qryStr;
                } else {
                    Window.alert((String)E12Constants.constants.setTransactionFailed());
                }
            } else if ("2".equals(linkType)) {
                if (!"".equals(pkFieldValue.toString().trim()) && pkFieldValue.length() > 0) {
                    url = "/ibase/webitm/jsp/ITMTransactionEditor.jsp?OBJ_TITLE=" + targetObjName.toUpperCase() + "&OBJ_NAME=" + targetObjName + "&PAGE_CONTEXT=" + pageCtx + "&OBJ_CONTEXT=" + objCtx + "&EDIT_FLAG=E&DB_ID=" + pkFieldValue + "&PARAM_TYPE=" + paramType;
                    url = String.valueOf(url) + qryStr;
                } else {
                    Window.alert((String)E12Constants.constants.setTransactionFailed());
                }
            } else if ("3".equals(linkType)) {
                if (linkUri.indexOf("/ibase/bi") != -1) {
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("bi", String.valueOf(targetObjName) + ".xml");
                    paramMap.put("common", "true");
                    paramMap.put("target", "browser");
                    paramMap.put("drill", "Indrill");
                    String encodedParamString = this.getEncodedParamString(paramMap);
                    if (!"".equalsIgnoreCase(encodedParamString)) {
                        encodedParamString = String.valueOf(encodedParamString) + "&";
                    }
                    url = linkUri.indexOf("?") != -1 ? String.valueOf(linkUri) + "&" + encodedParamString + qryStr : String.valueOf(linkUri) + "?" + encodedParamString + qryStr;
                } else {
                    url = linkUri.indexOf("?") != -1 ? String.valueOf(linkUri) + "&" + qryStr : String.valueOf(linkUri) + "?" + qryStr;
                }
            } else if ("4".equals(linkType)) {
                if (!"".equals(pkFieldValue.toString().trim()) && pkFieldValue.length() > 0) {
                    url = "/ibase/webitm/jsp/ITMTransactionEditor.jsp?OBJ_TITLE=" + targetObjName.toUpperCase() + "&OBJ_NAME=" + targetObjName + "&PAGE_CONTEXT=" + pageCtx + "&OBJ_CONTEXT=" + objCtx + "&EDIT_FLAG=A&DB_ID=" + pkFieldValue + "&PARAM_TYPE=" + paramType + "&";
                    url = String.valueOf(url) + qryStr;
                } else {
                    Window.alert((String)E12Constants.constants.setTransactionFailed());
                }
            } else if ("5".equals(linkType)) {
                Window.alert((String)E12Constants.constants.setLinkNotDefined());
            } else if ("6".equals(linkType)) {
                url = "/ibase/webitm/jsp/ITMProcessPageEditor.jsp?OBJ_NAME=" + targetObjName + "&OBJ_TYPE=P&";
                url = String.valueOf(url) + qryStr;
            }
            if (!"".equals(url.toString())) {
                Window.open((String)url, (String)objName, (String)"toolbar=no,status=yes,resizable=yes,scrollbars=no,screenX=0,screenY=0,width=800,height=600,top=70,left=220");
            }
        }
        catch (Exception e) {
            Window.alert((String)("In Perform LinkAction Exception[" + e.getMessage() + "]"));
        }
    }

    protected String getQueryParam(ArrayList<String> sourceField, ArrayList<String> targetField, ArrayList<String> dataGridHeaderLogicalColName, boolean isAnyRowSelected, DataGridTableRowModel selectedDGTRModel) {
        String qryString = "";
        try {
            HashMap<String, String> queryParamsMap = new HashMap<String, String>();
            int srcFldcnt = 0;
            while (srcFldcnt < sourceField.size()) {
                String columnName = sourceField.get(srcFldcnt);
                String paramName = targetField.get(srcFldcnt);
                if (dataGridHeaderLogicalColName.contains(columnName) && isAnyRowSelected) {
                    String paramValue = selectedDGTRModel.getCellText(columnName);
                    queryParamsMap.put(paramName, paramValue);
                } else {
                    queryParamsMap.put(paramName, columnName);
                }
                ++srcFldcnt;
            }
            qryString = this.getEncodedParamString(queryParamsMap);
        }
        catch (Exception e) {
            Window.alert((String)("Exception in getQueryParam[" + e.getMessage() + "]"));
        }
        return qryString;
    }

    protected void performAction(HomePgActionInfoBean actionInfoBean, String objName, String objTitle, boolean isAnyRowSelected, StringBuffer pkFieldNames, StringBuffer pkFieldValue, String frmlArgValues, String advQuery) {
        String actionType = actionInfoBean.getActionType();
        String serviceHandler = actionInfoBean.getServiceHandler();
        String id = actionInfoBean.getId();
        String url = "";
        if (actionType.equalsIgnoreCase("S") && id.equalsIgnoreCase("A")) {
            url = "/ibase/webitm/jsp/ITMTransactionEditor.jsp?OBJ_TITLE=" + objTitle + "&OBJ_NAME=" + objName + "&OBJ_CONTEXT=1&EDIT_FLAG=A&FRML_FLT_VAL=" + frmlArgValues + "&dummyInt=" + Math.random();
            Window.open((String)url, (String)objName, (String)"toolbar=no,status=yes,resizable=yes,scrollbars=no,screenX=0,screenY=0,width=800,height=600,top=70,left=220");
        }
        if (actionType.equalsIgnoreCase("S") && id.equalsIgnoreCase("E")) {
            if (isAnyRowSelected) {
                url = "/ibase/webitm/jsp/ITMTransactionEditor.jsp?OBJ_TITLE=" + objTitle + "&OBJ_NAME=" + objName + "&OBJ_CONTEXT=1&EDIT_FLAG=E&DB_ID=" + pkFieldValue.toString() + "&dummyInt=" + Math.random();
                Window.open((String)url, (String)objName, (String)"toolbar=no,status=yes,resizable=yes,scrollbars=no,screenX=0,screenY=0,width=800,height=600,top=70,left=220");
            } else {
                Window.alert((String)E12Constants.constants.setNoRowSelected());
            }
        }
        if (actionType.equalsIgnoreCase("U")) {
            String REF_ID;
            String string = REF_ID = pkFieldValue != null ? pkFieldValue.toString() : "";
            if (serviceHandler.equalsIgnoreCase("1")) {
                String rights_char = actionInfoBean.getId();
                String urlCData = actionInfoBean.getServiceCodeCData();
                url = urlCData != null && urlCData.indexOf("?") == -1 ? String.valueOf(urlCData) + "?" : String.valueOf(urlCData) + "&";
                url = "X".equals(rights_char) ? String.valueOf(url) + "OBJ_NAME=" + objName + "&REF_ID=" + REF_ID + "&ACTION=DOWNLOAD_XML" + "&FILTERQUERY=" + advQuery : ("T".equals(rights_char) ? String.valueOf(url) + "OBJ_NAME=" + objName + "&REF_ID=" + REF_ID + "&ACTION=DOWNLOAD_XLS" + "&FILTERQUERY=" + advQuery : ("B".equals(rights_char) ? String.valueOf(url) + "OBJ_NAME=" + objName + "&REF_ID=" + REF_ID + "&ACTION=BROWDATA_XLS" + "&FILTERQUERY=" + advQuery : String.valueOf(url) + "OBJ_NAME=" + objName + "&REF_ID=" + REF_ID + "&FILTERQUERY=" + advQuery));
                url = String.valueOf(url) + "&dummyInt=" + Math.random();
                Window.open((String)url, (String)objName, (String)"toolbar=no,status=yes,resizable=yes,scrollbars=no,screenX=0,screenY=0,width=800,height=600,top=70,left=220");
            } else if (serviceHandler.equalsIgnoreCase("2") || serviceHandler.equalsIgnoreCase("3")) {
                this.callServiceHandler(objName, serviceHandler, pkFieldNames, pkFieldValue, actionInfoBean);
            } else {
                String urlCData = actionInfoBean.getServiceCodeCData();
                url = urlCData != null && urlCData.indexOf("?") == -1 ? String.valueOf(urlCData) + "?" : String.valueOf(urlCData) + "&";
                url = String.valueOf(url) + "OBJ_NAME=" + objName + "&REF_ID=" + REF_ID + "&COMP_TYPE=" + actionInfoBean.getCmpType() + "&COMP_NAME=" + actionInfoBean.getCmpName() + "&METHOD_NAME=" + actionInfoBean.getMetName();
                url = String.valueOf(url) + "&dummyInt=" + Math.random();
                Window.open((String)url, (String)objName, (String)"toolbar=no,status=yes,resizable=yes,scrollbars=no,screenX=0,screenY=0,width=800,height=600,top=70,left=220");
            }
        }
    }

    public HashMap<String, LinkActionInfoBean> getLinkActionInfoMap(String objName) {
        this.linkActionInfoMap = new HashMap();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ACTION", "GET_LINKS");
        paramMap.put("OBJ_CTXT", "1");
        paramMap.put("OBJ_NAME", objName);
        String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
        String url = "/ibase/WebITMLinkControllerServlet?" + paramString;
        RequestBuilder reqstBldr = new RequestBuilder(RequestBuilder.GET, url);
        try {
            reqstBldr.sendRequest(null, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    if (E12Global.getInstance().checkErrorException(response, 1)) {
                        String responseStr = response.getText();
                        Document document = XMLParser.parse((String)responseStr);
                        XMLParser.removeWhitespace((Node)document);
                        NodeList linksInfoLst = document.getElementsByTagName("Link");
                        int linkLen = linksInfoLst.getLength();
                        int i = 0;
                        while (i < linkLen) {
                            NodeList linksItemInfoLst = linksInfoLst.item(i).getChildNodes();
                            String linkFormNoNode = linksInfoLst.item(i).getAttributes().getNamedItem("formNo").getNodeValue();
                            String linkTergetObjNode = linksItemInfoLst.item(0).getFirstChild().getNodeValue();
                            String linkFormNode = linksItemInfoLst.item(1).getFirstChild().getNodeValue();
                            String linkTitleNode = linksItemInfoLst.item(2).getFirstChild().getNodeValue();
                            String linkUriNode = linksItemInfoLst.item(3).getFirstChild().getNodeValue();
                            String linkTypeNode = linksItemInfoLst.item(4).getFirstChild().getNodeValue();
                            String linkArgNode = linksItemInfoLst.item(5).getFirstChild().getNodeValue();
                            String linkUpdtFlag = linksItemInfoLst.item(6).getFirstChild().getNodeValue();
                            String linkRightChar = linksItemInfoLst.item(7).getFirstChild().getNodeValue();
                            LinkActionInfoBean linkActionInfoBean = new LinkActionInfoBean(linkTergetObjNode, linkFormNoNode, linkTitleNode, linkUriNode, linkTypeNode, linkArgNode, linkFormNode, linkUpdtFlag, linkRightChar);
                            E12CommonUtils.this.linkActionInfoMap.put(linkTitleNode, linkActionInfoBean);
                            ++i;
                        }
                    }
                }

                public void onError(Request request, Throwable exception) {
                }
            });
        }
        catch (Exception e) {
            Window.alert((String)(" Exception in getting links" + e.getMessage()));
        }
        return this.linkActionInfoMap;
    }

    public boolean isFocusable(Widget firstEditable) {
        CheckBox checkBox;
        if (firstEditable == null) {
            return false;
        }
        String className = firstEditable.getClass().toString();
        if ("TextBox".equalsIgnoreCase(className = className.substring(className.lastIndexOf(".") + 1, className.length()))) {
            final TextBox txtBox = (TextBox)firstEditable;
            if (txtBox.isEnabled() && txtBox.isVisible()) {
                new Timer(){

                    public void run() {
                        txtBox.setFocus(true);
                        txtBox.selectAll();
                    }
                }.schedule(1);
                return true;
            }
        } else if ("DateBox".equalsIgnoreCase(className)) {
            final DateBox dateBox = (DateBox)firstEditable;
            if (dateBox.isVisible() && dateBox.getTextBox().isEnabled()) {
                new Timer(){

                    public void run() {
                        dateBox.setFocus(true);
                    }
                }.schedule(1);
                return true;
            }
        } else if ("ListBox".equalsIgnoreCase(className)) {
            final ListBox listBox = (ListBox)firstEditable;
            if (listBox.isVisible() && listBox.isEnabled()) {
                new Timer(){

                    public void run() {
                        listBox.setFocus(true);
                    }
                }.schedule(1);
                return true;
            }
        } else if ("E12TextBox".equalsIgnoreCase(className)) {
            final E12TextBox numTxtBox = (E12TextBox)firstEditable;
            if (numTxtBox.isVisible() && numTxtBox.isEnabled()) {
                new Timer(){

                    public void run() {
                        numTxtBox.setFocus(true);
                        numTxtBox.selectAll();
                    }
                }.schedule(1);
                return true;
            }
        } else if ("TextArea".equalsIgnoreCase(className)) {
            final TextArea txtArea = (TextArea)firstEditable;
            if (txtArea.isVisible() && txtArea.isEnabled()) {
                new Timer(){

                    public void run() {
                        txtArea.setFocus(true);
                    }
                }.schedule(1);
                return true;
            }
        } else if ("CheckBox".equalsIgnoreCase(className) && (checkBox = (CheckBox)firstEditable).isVisible() && checkBox.isEnabled()) {
            new Timer(){

                public void run() {
                    checkBox.setFocus(true);
                }
            }.schedule(1);
            return true;
        }
        return false;
    }

    public void setE12Constants(String loginResponse) {
        if (loginResponse == null) {
            return;
        }
        this.resetE12Constants();
        Document document = XMLParser.parse((String)loginResponse);
        XMLParser.removeWhitespace((Node)document);
        NodeList childNodeList = document.getElementsByTagName("Root").item(0).getChildNodes();
        int len = childNodeList.getLength();
        int index = 0;
        while (index < len) {
            Node currNode = childNodeList.item(index);
            String nodeName = currNode.getNodeName();
            String nodeValue = "";
            if (currNode.getFirstChild() != null && currNode.getFirstChild().getNodeType() == 4) {
                nodeValue = currNode.getFirstChild().getNodeValue();
            }
            if ("status".equalsIgnoreCase(nodeName)) {
                E12Constants.authenticateStatus = nodeValue;
            } else if ("userID".equalsIgnoreCase(nodeName)) {
                E12Constants.userID = nodeValue;
            } else if ("profileID".equalsIgnoreCase(nodeName)) {
                E12Constants.profileID = nodeValue;
            } else if ("empDesignation".equalsIgnoreCase(nodeName)) {
                E12Constants.empDesignation = nodeValue;
            } else if ("empDivision".equalsIgnoreCase(nodeName)) {
                E12Constants.empDivision = nodeValue;
            } else if ("empHeadQuat".equalsIgnoreCase(nodeName)) {
                E12Constants.empHeadQuat = nodeValue;
            } else if ("empDOJ".equalsIgnoreCase(nodeName)) {
                E12Constants.empDOJ = nodeValue;
            } else if ("dispDate".equalsIgnoreCase(nodeName)) {
                E12Constants.dispDate = nodeValue;
            } else if ("userLevel".equalsIgnoreCase(nodeName)) {
                E12Constants.userLevel = nodeValue;
            } else if ("siteDescr".equalsIgnoreCase(nodeName)) {
                E12Constants.siteDescr = nodeValue;
            } else if ("deptDescr".equalsIgnoreCase(nodeName)) {
                E12Constants.deptDescr = nodeValue;
            } else if ("emailIdOff".equalsIgnoreCase(nodeName)) {
                E12Constants.emailIdOff = nodeValue;
            } else if ("empCode".equalsIgnoreCase(nodeName)) {
                E12Constants.empCode = nodeValue;
            } else if ("empName".equalsIgnoreCase(nodeName)) {
                E12Constants.empName = nodeValue;
            } else if ("reportTo".equalsIgnoreCase(nodeName)) {
                E12Constants.reportTo = nodeValue;
            } else if ("stanCode".equalsIgnoreCase(nodeName)) {
                E12Constants.stanCode = nodeValue;
            } else if ("userCountry".equalsIgnoreCase(nodeName)) {
                E12Constants.userCountry = nodeValue;
            } else if ("userLanguage".equalsIgnoreCase(nodeName)) {
                E12Constants.userLanguage = nodeValue;
            } else if ("entityCode".equalsIgnoreCase(nodeName)) {
                E12Constants.entityCode = nodeValue;
            } else if ("itemSer".equalsIgnoreCase(nodeName)) {
                E12Constants.itemSer = nodeValue;
            }
            ++index;
        }
    }

    public String getEncodedParamString(Map<String, String> paramMap) {
        String encodedString = "";
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            encodedString = String.valueOf(encodedString) + URL.encodeComponent((String)key) + "=" + URL.encodeComponent((String)value) + "&";
        }
        encodedString = encodedString.substring(0, encodedString.length() - 1);
        return encodedString;
    }

    public static String getAttribValue(Node node, String attributeName) {
        String attribValue = "";
        try {
            Node attribNode;
            if (node != null && node.getAttributes() != null && (attribNode = node.getAttributes().getNamedItem(attributeName)) != null) {
                attribValue = E12CommonUtils.checkNull(attribNode.getNodeValue());
            }
        }
        catch (Exception e) {
            Window.alert((String)("E21CommonUtils Exception : getAttribValue :" + e.getMessage()));
        }
        return attribValue;
    }

    public static native int getScreenHeight();

    public static native int getScreenWidth();

    public void resetE12Constants() {
        E12Constants.authenticateStatus = "";
        E12Constants.userID = "";
        E12Constants.profileID = "";
        E12Constants.empDesignation = "";
        E12Constants.empDivision = "";
        E12Constants.empHeadQuat = "";
        E12Constants.empDOJ = "";
        E12Constants.dispDate = "";
        E12Constants.userLevel = "";
        E12Constants.siteDescr = "";
        E12Constants.deptDescr = "";
        E12Constants.emailIdOff = "";
        E12Constants.empCode = "";
        E12Constants.empName = "";
        E12Constants.reportTo = "";
        E12Constants.stanCode = "";
        E12Constants.userCountry = "";
        E12Constants.userLanguage = "";
        E12Constants.entityCode = "";
        E12Constants.itemSer = "";
    }

    public static native void printOnConsole(String var0);

    public static String getConvertDateString(String dateStr, String sourceDateFormat, String targetDateFormat) {
        E12CommonUtils.printOnConsole("getValidDateString Converting dateStr :[" + dateStr + "] From format :[" + sourceDateFormat + "] To Format :[" + targetDateFormat + "]");
        Date date = null;
        String retDateStr = "";
        String copyDateStr = dateStr;
        try {
            if (!sourceDateFormat.equalsIgnoreCase(targetDateFormat)) {
                if (sourceDateFormat.indexOf("/") != -1) {
                    dateStr.replace('/', '-');
                } else if (sourceDateFormat.indexOf(".") != -1) {
                    dateStr.replace('.', '-');
                }
                date = new SimpleDateFormat(sourceDateFormat).parse(dateStr);
                SimpleDateFormat sdfOutput = new SimpleDateFormat(targetDateFormat);
                retDateStr = sdfOutput.format(date);
            } else {
                retDateStr = dateStr;
            }
        }
        catch (Exception e) {
            E12CommonUtils.printOnConsole("Exception :getValidDateString :==>" + e.getMessage());
            retDateStr = copyDateStr;
        }
        return retDateStr;
    }

    public static void applyDatagridThemes() {
        E12CommonUtils.printOnConsole(" Apply Datagrid Themes :" + E12Constants.userTheme);
        if ("blue".equalsIgnoreCase(E12Constants.userTheme)) {
            Resources.DATAGRID_RES.blueThemeCSS().ensureInjected();
        } else if ("gray".equalsIgnoreCase(E12Constants.userTheme)) {
            Resources.DATAGRID_RES.grayThemeCSS().ensureInjected();
        } else if ("orange".equalsIgnoreCase(E12Constants.userTheme)) {
            Resources.DATAGRID_RES.orangeThemeCSS().ensureInjected();
        } else if ("green".equalsIgnoreCase(E12Constants.userTheme)) {
            Resources.DATAGRID_RES.greenThemeCSS().ensureInjected();
        }
    }

    public static void applyUserTheme() {
        E12CommonUtils.printOnConsole(" Apply Themes :" + E12Constants.userTheme);
        if ("blue".equalsIgnoreCase(E12Constants.userTheme)) {
            Resources.THEME_RES.blueThemeCSS().ensureInjected();
        } else if ("gray".equalsIgnoreCase(E12Constants.userTheme)) {
            Resources.THEME_RES.grayThemeCSS().ensureInjected();
        } else if ("orange".equalsIgnoreCase(E12Constants.userTheme)) {
            Resources.THEME_RES.orangeThemeCSS().ensureInjected();
        } else if ("green".equalsIgnoreCase(E12Constants.userTheme)) {
            Resources.THEME_RES.greenThemeCSS().ensureInjected();
        }
    }

    public static native int getBrowserVersion();

    public static int getTableHeightFactor() {
        if (E12CommonUtils.getBrowserVersion() == -1) {
            return 0;
        }
        return 15;
    }

    private void callServiceHandler(String objName, String serviceHandler, StringBuffer pkFieldName, StringBuffer pkFieldValue, HomePgActionInfoBean actionInfoBean) {
        if (pkFieldValue.charAt(pkFieldValue.length() - 1) == ':') {
            pkFieldValue.deleteCharAt(pkFieldValue.length() - 1);
        }
        if (pkFieldName.charAt(pkFieldName.length() - 1) == ':') {
            pkFieldName.deleteCharAt(pkFieldName.length() - 1);
        }
        String local_edit_mode = "A";
        String chgString = "<?xml version='1.0' encoding='utf-8'?><Root><header><objName><![CDATA[" + objName + "]]></objName>" + "<pageContext><![CDATA[1]]></pageContext>" + "<objContext><![CDATA[" + actionInfoBean.objContext + "]]></objContext>" + "<editFlag><![CDATA[" + local_edit_mode + "]]></editFlag>" + "<focusedColumn><![CDATA[]]></focusedColumn>" + "<elementName><![CDATA[]]></elementName>" + "<keyValue><![CDATA[]]></keyValue>" + "<taxKeyValue><![CDATA[]]></taxKeyValue>" + "<saveLevel><![CDATA[0]]></saveLevel>" + "<forcedSave><![CDATA[false]]></forcedSave>" + "<taxInFocus><![CDATA[false]]></taxInFocus>" + "</header>" + "</Root>";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("SERVICE_HANDLER", serviceHandler);
        paramMap.put("SERVICE_CODE", actionInfoBean.getServiceCodeCData());
        paramMap.put("OBJ_NAME", objName);
        paramMap.put("REF_ID", pkFieldValue.toString());
        paramMap.put("COMP_TYPE", actionInfoBean.getCmpType());
        paramMap.put("COMP_NAME", actionInfoBean.getCmpName());
        paramMap.put("METHOD_NAME", actionInfoBean.getMetName());
        paramMap.put("CHG_STR", chgString);
        paramMap.put("TITLE", actionInfoBean.getTitle());
        paramMap.put("isDecode", "false");
        if (serviceHandler.equalsIgnoreCase("2")) {
            paramMap.put("PK_FLD_NAMES", pkFieldName.toString());
            paramMap.put("ACTION_CHAR", actionInfoBean.getId());
        }
        paramMap.put("dummyInt", "" + Math.random());
        String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
        String url = "/ibase/WebITMServiceHandlerServlet" + serviceHandler + "?" + paramString;
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url);
        try {
            requestBuilder.sendRequest(null, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    if (E12Global.getInstance().checkErrorException(response, 1)) {
                        Document doc = XMLParser.parse((String)response.getText());
                        XMLParser.removeWhitespace((Node)doc);
                        NodeList nlst = doc.getElementsByTagName("error");
                        String descriptionValue = nlst.item(0).getChildNodes().item(1).getFirstChild().getNodeValue();
                        Window.alert((String)descriptionValue);
                    }
                }

                public void onError(Request request, Throwable exception) {
                }
            });
        }
        catch (Exception e) {
            Window.alert((String)(" E12CommonUtils: callServiceHandler method" + e.getMessage()));
        }
    }

    public native void loadingCompletedMenus(String var1, boolean var2);

    public native void setTranslucentClass(boolean var1);
}

