/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.CountUtils;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class Counta
implements Function {
    private static final CountUtils.I_MatchPredicate predicate = new CountUtils.I_MatchPredicate(){

        public boolean matches(ValueEval valueEval) {
            return valueEval != BlankEval.INSTANCE;
        }
    };

    public ValueEval evaluate(ValueEval[] args, int srcCellRow, short srcCellCol) {
        int nArgs = args.length;
        if (nArgs < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        if (nArgs > 30) {
            return ErrorEval.VALUE_INVALID;
        }
        int temp = 0;
        for (int i = 0; i < nArgs; ++i) {
            temp += CountUtils.countArg(args[i], predicate);
        }
        return new NumberEval(temp);
    }
}

