/*
 * Author:sarita
 * Date:
 * Request ID:
 */
package ibase.webitm.ejb.fin.adv;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


/**
 * Session Bean implementation class EtaWizardPosEJB
 */
@Stateless
public class CostCtrAllocPosEJB extends ValidatorEJB implements CostCtrAllocPosEJBRemote,CostCtrAllocPosEJBLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	DistCommon distComm = new DistCommon();
	ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
	DecimalFormat deciFormater = new DecimalFormat("0.00");
    /**
     * Default constructor. 
     */
    public CostCtrAllocPosEJB() {  /* TODO Auto-generated constructor stub*/ }

    @Override
	public String postSave(String xmlStringAll, String tranID, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException 
	{
		String retString="";
		try 
		{
			retString = postSave(xmlStringAll, xtraParams, "", conn);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}//end of method postSave
			
	public String postSave(String xmlstring, String xtraParams, String forcedFlag, Connection conn) throws RemoteException,ITMException
	{
		System.out.println("Inside Post Save Method !!!!!!");
		System.out.println("CostCtrAllocPosEJB ["+xmlstring+"] \n xtraParams ["+xtraParams+"] \n forcedFlag["+forcedFlag+"]");
		
		boolean isLocCon = false;
		PreparedStatement pstmt = null,pstmt1=null,pstmt2=null,pstmt3=null, pstmtPdet = null,pstmtPorder = null,pstmtUpd = null,pstmtAsnDet = null;
		ResultSet rs = null;
		Document dom = null;
		String sql = "",retString = "";
		boolean deleteFlag,deleteFlag1 = false;
		String statusFlag = "",statusFlag1 = "";
		int selCnt = 0;
		String tran_id="",prd_code="",site_code="",from_date="",to_date="",	acct_code="",cctr_code="",exp_head="",alloc_basis="",res_basis="",tot_units="";
		String acctCodeDtl3="",tranIdDtl3="",lineNoDtl3="",siteCodeDtl3="",cctrCodeDtl3="",cctrDescrDtl3="",unitAllocDtl3="";
		Timestamp fromDateTimestamp = null;
		Timestamp toDateTimestamp = null;
		InitialContext ctx = null;
		boolean isError = false;
		String currDate = "",loginSiteCode="",tranID="",drcrFlag="",tranIDJNRL="";
		String userId="",chgTerm="",responseXML="";
		Timestamp tranDate = null;
		int domIDLineNo=0,lineNo=0,domNo=0;
		boolean flag = true;
		String finEntityJrnal = "",currCodeJrnal="",sysDateStr="",loginEmpCode="";
		StringBuffer finalString = null;
		StringBuffer headerString = null;
		StringBuffer detailString = new StringBuffer();
		double crAmount=0.0, drAmount=0.0;
		double totalAllocAmt = 0;
		String creditAmount="",debitAmount="";
		
		try
		{	
			if(conn == null || conn.isClosed())
			{
				System.out.println("@@Connection is null");
				conn = getConnection();
				isLocCon = true;
			}
			else
			{
				System.out.println("@@Connection is not null");
			}
			
			if(xmlstring != null &&  (xmlstring.indexOf("Detail2") != -1))
			{
				
				currDate = getCurrdateAppFormat();
			    tranDate = getCurrtDate();
			    loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			    userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
				chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
				loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			   
			    System.out.println("generated transaction ID is :::::["+tranID+"]");
			    System.out.println("Line Number for Detail3 is :::["+lineNoDtl3+"]");
			    
				sql =   "insert into resource_cons " 
						+"(tran_id,prd_code,site_code,from_date,to_date,acct_code,cctr_code,exp_head,tot_units,add_date,add_user,add_term,chg_date,chg_user,chg_term) " 
						+"values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
				
				sql = "insert into resource_cons_det" 
						  +"(tran_id,line_no,dept_code,work_ctr,cctr_code_alloc,unit_alloc,acct_code) " 
						  +"values(?,?,?,?,?,?,?)";
					
				pstmt1 = conn.prepareStatement(sql);
				
				
			/*	sql = "insert into journal" +
					 "(tran_id,tran_date,site_code,site_code__rev,reversible,eff_date,fin_entity,curr_code,exch_rate,dr_amt,cr_amt,auto_rev,status,confirmed,remarks,tran_type) " +
					 "values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				pstmt2 = conn.prepareStatement(sql);*/
				
				
				/*sql = "insert into jourdet " 
					  +"(tran_id,line_no,acct_code,cctr_code,drcr_flag,amount,remarks)" 
					  +"values(?,?,?,?,?,?,?)";
				
				pstmt3 = conn.prepareStatement(sql);*/
				
				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
				Date sysDate = new Date();
				sysDateStr = sdf.format(tranDate);
				System.out.println("sysDateStr >>>>>>>>>>>"+sysDateStr);
				
				//tranIDJNRL = checkNullAndTrim(generateTranTd("w_journal", currDate, loginSiteCode, conn));
				dom = genericUtility.parseString(xmlstring);
				NodeList detail2NodeList =dom.getElementsByTagName("Detail2");
				int detail2NodeListlen = detail2NodeList.getLength();
				for(int ctrH = 0; ctrH < detail2NodeListlen ; ctrH++)
				{
					deleteFlag = false;
                    lineNo++;
					domNo++;
					
					finalString = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
					finalString.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 escription</description>\r\n");
					finalString.append("<Header0>\r\n");
					finalString.append("<description>Header0 members</description>\r\n");
					finalString.append("<objName><![CDATA[").append("journal").append("]]></objName>\r\n");
					finalString.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>\r\n");
					finalString.append("<objContext><![CDATA[").append("1").append("]]></objContext>\r\n");
					finalString.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>\r\n");
					finalString.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>\r\n");
					finalString.append("<action><![CDATA[").append("SAVE").append("]]></action>\r\n");
					finalString.append("<elementName><![CDATA[").append("").append("]]></elementName>\r\n");
					finalString.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>\r\n");
					finalString.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>\r\n");
					finalString.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>\r\n");
					finalString.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>\r\n");
					finalString.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>\r\n");
					
                    tranID = generateTranTd("w_cctr_alloc_wiz", currDate, loginSiteCode, conn);
					NodeList childNodeList = detail2NodeList.item(ctrH).getChildNodes();
					int childNodeListlen = childNodeList.getLength();
					
					//Element eachDetail2Element = (Element)detail2NodeList.item(ctrH);
					/*drcrFlag = eachDetail2Element.getElementsByTagName("drcr_flag").item(0).getChildNodes().item(0).getNodeValue();
					tot_units = eachDetail2Element.getElementsByTagName("tot_units").item(0).getChildNodes().item(0).getNodeValue();
					
					System.out.println("560101.drcrFlag["+drcrFlag+"] for Detail"+(ctrH+1)+"");
					System.out.println("560101.tot_units["+tot_units+"] for Detail"+(ctrH+1)+"");
					
					if("C".equalsIgnoreCase(drcrFlag))
					{
						crAmount = (crAmount + Double.valueOf(tot_units));	
						System.out.println("Value of Total Unit for CrAmountis :::::["+crAmount+"]"); 
					}
					else if("D".equalsIgnoreCase(drcrFlag))
					{
						drAmount = (drAmount + Double.valueOf(tot_units));
						System.out.println("Value of Total Unit for DrAmount is :::::["+drAmount+"]");
					}	
					*/
					//System.out.println("560101.crAmount["+crAmount+"] drAmount ["+drAmount+"] for Detail"+(ctrH+1)+"");
									
					for(int ctrD = 0; ctrD < childNodeListlen ; ctrD++)
					{					
						Node childNode = childNodeList.item(ctrD);
						
						if("attribute".equalsIgnoreCase(childNode.getNodeName()))
						{
							statusFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							System.out.println("Post Save Status for Detail2["+statusFlag+"]");
							
							if("D".equalsIgnoreCase(statusFlag))
							{
								deleteFlag = true;
								break;
								//continue;
							}
						}
						else if(childNode != null && "tran_id".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							tran_id = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("tran_id is===="+tran_id);
						}
						else if(childNode != null && "prd_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							prd_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("prd_code is===="+prd_code);
						}
						else if(childNode != null && "site_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							site_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("site_code is===="+site_code);
						}
						else if(childNode != null && "from_date".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							from_date = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("from_date is===="+from_date);
						}
						else if(childNode != null && "to_date".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							to_date = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("to_date is===="+to_date);
						}
						else if(childNode != null && "acct_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							acct_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("acct_code is===="+acct_code);
						}
						else if(childNode != null && "cctr_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							cctr_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("cctr_code is===="+cctr_code);
						}
						else if(childNode != null && "exp_head".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							exp_head = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("exp_head is===="+exp_head);
						}
						else if(childNode != null && "alloc_basis".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							alloc_basis = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("alloc_basis is===="+alloc_basis);
						}
						else if(childNode != null && "res_basis".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							res_basis = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("res_basis is===="+res_basis);
						}
						else if(childNode != null && "tot_units".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							tot_units = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("tot_units is===="+tot_units);
						}
						else if(childNode != null && "drcr_flag".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							drcrFlag = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("drcrFlag is===="+drcrFlag);
						}	
					}//end of for loop
									
					System.out.println("tran_id["+tranID+"]" +"prd_code["+prd_code+"]"+"site_code["+site_code+"]"+"from_date["+from_date+"]"+"to_date["+to_date+"]"+"acct_code["+acct_code+"]"+"cctr_code["+cctr_code+"]"+"exp_head["+exp_head+"]"+"alloc_basis["+alloc_basis+"]"+"res_basis["+res_basis+"]"+"tot_units["+tot_units+"]");
					System.out.println("domIDLineNoDet ::"+lineNo);					
					finEntityJrnal = getFinEntityVal(site_code, conn);
					currCodeJrnal = getCurrencyCodeVal(finEntityJrnal, conn);
					System.out.println("tranIDJNRL ::["+tranIDJNRL+"]"+"site_code ["+site_code+"]" +"acc_code ["+acct_code+"]" + "lineNo ::["+lineNo+"]"+"drcrFlag ::["+drcrFlag+"]" +"finEntityJrnal ::["+finEntityJrnal+"]" +"currCodeJrnal ::["+currCodeJrnal+"]");					
					System.out.println("Value of Flag is ::::::["+flag+"]");
					pstmt.setString(1,tranID);
					pstmt.setString(2,prd_code);
					pstmt.setString(3,site_code);
					pstmt.setTimestamp(4,fromDateTimestamp);
					pstmt.setTimestamp(5,toDateTimestamp);
					pstmt.setString(6,acct_code);
					pstmt.setString(7,cctr_code);
					pstmt.setString(8,exp_head);
					pstmt.setDouble(9,Double.valueOf(tot_units));
					pstmt.setTimestamp(10,tranDate);
					pstmt.setString(11,userId);
					pstmt.setString(12,chgTerm);
					pstmt.setTimestamp(13,tranDate);
					pstmt.setString(14,userId);
					pstmt.setString(15,chgTerm);
					pstmt.addBatch();
					
					creditAmount = deciFormater.format(crAmount);
					debitAmount = deciFormater.format(drAmount);
					System.out.println("DRCR Flag ["+drcrFlag+"]" + "Amount is ["+tot_units+"]");																				
					System.out.println("Value of Total Unit for CrAmountis :::::["+crAmount+"]" + "String is ::::["+creditAmount+"]");
					System.out.println("Value of Total Unit for DrAmount is :::::["+drAmount+"]" + "String is ::::["+debitAmount+"]");						                      	
						
					
					//System.out.println("Header String is :::: " +headerString.toString());
					
					/*finalString.append("<Detail2 dbID=':' domID='" + lineNo + "' objName='journal' objContext='2'>");
					finalString.append("<attribute pkNames='journal:line_no:' status='N' updateFlag='A' selected='Y'/>");
					finalString.append("<tran_id><![CDATA[" ).append((tranIDJNRL)).append( "]]></tran_id>\r\n" );
					finalString.append("<line_no><![CDATA[" ).append((lineNo)).append( "]]></line_no>\r\n" );
					finalString.append("<acct_code><![CDATA[" ).append((acct_code)).append( "]]></acct_code>\r\n" );
					finalString.append("<cctr_code><![CDATA[" ).append((cctr_code)).append( "]]></cctr_code>\r\n" );
					finalString.append("<drcr_flag><![CDATA[" ).append((drcrFlag)).append( "]]></drcr_flag>\r\n" );
					finalString.append("<amount><![CDATA[" ).append((tot_units)).append( "]]></amount>\r\n" );
					finalString.append("<remarks><![CDATA[" ).append(("")).append( "]]></remarks>\r\n" );
					finalString.append("</Detail2>");*/
					
											
				//	System.out.println("Value of FinalString is :::::: ["+finalString.toString()+"]");
						
					
					
					/*if(flag)
					{
						pstmt2.setString(1,tranIDJNRL);
						pstmt2.setTimestamp(2,tranDate);
						pstmt2.setString(3,site_code);
						pstmt2.setString(4,site_code);
						pstmt2.setString(5,"N");
						pstmt2.setTimestamp(6,tranDate);
						pstmt2.setString(7,finEntityJrnal);
						pstmt2.setString(8,currCodeJrnal);
						pstmt2.setDouble(9,Double.valueOf(1));
						pstmt2.setDouble(10,Double.valueOf(tot_units));
						pstmt2.setDouble(11,Double.valueOf(tot_units));
						pstmt2.setString(12,"N");
						pstmt2.setString(13,"N");
						pstmt2.setString(14,"N");
						pstmt2.setString(15,"");
						pstmt2.setString(16,"");
						pstmt2.executeUpdate();
						//pstmt2.addBatch();
						
					}
										
					pstmt3.setString(1,tranIDJNRL);
					pstmt3.setInt(2,lineNo);
					pstmt3.setString(3,acct_code);
					pstmt3.setString(4,cctr_code);
					pstmt3.setString(5,drcrFlag);
					pstmt3.setDouble(6,Double.valueOf(tot_units));					
					pstmt3.setString(7,"");
					pstmt3.executeUpdate();
					//pstmt3.addBatch();
*/					 
					
					NodeList nodeList =dom.getElementsByTagName("Detail3");
					int nodeListlen = nodeList.getLength();					
					System.out.println("NodeList for Detail3 is ========"+nodeListlen);
					
					for(int ctr = 0; ctr < nodeListlen ; ctr++)
					{
					    deleteFlag1 = false;				    
						NodeList childNodeListData = nodeList.item(ctr).getChildNodes();
						int childNodeListlenData = childNodeListData.getLength();
						System.out.println("childNodeListlenData>>>>>"+childNodeListlenData);
						System.out.println("domIDLineNo is ========="+domIDLineNo);
						acctCodeDtl3 = "";
						for(int ctrD = 0; ctrD < childNodeListlenData ; ctrD++)
						{
							
							Node childNodeData = childNodeListData.item(ctrD);
							System.out.println("childNodeData.getNodeName ::::["+childNodeData.getNodeName()+"]");
							//statusFlag = childNodeData.getAttributes().getNamedItem("updateFlag").getNodeValue();
							//System.out.println("statusFlag ::::["+statusFlag+"]");
							
							if("attribute".equalsIgnoreCase(childNodeData.getNodeName()))
							{
								statusFlag1 = childNodeData.getAttributes().getNamedItem("updateFlag").getNodeValue();
								System.out.println("Post Save Status for Detail3["+statusFlag1+"]");
								
								if("D".equalsIgnoreCase(statusFlag1))
								{
									deleteFlag1 = true;
									break;								
								}
							}
							else if(childNodeData != null && "acct_code".equalsIgnoreCase(childNodeData.getNodeName()) && childNodeData.getFirstChild() != null)
							{
								acctCodeDtl3 = checkNullAndTrim(childNodeData.getFirstChild().getNodeValue());
								System.out.println("acctCodeDtl3 acct_code::"+acctCodeDtl3);
							}
							else if(childNodeData != null && "tran_id".equalsIgnoreCase(childNodeData.getNodeName()) && childNodeData.getFirstChild() != null)
							{
								tranIdDtl3 = checkNullAndTrim(childNodeData.getFirstChild().getNodeValue());
								System.out.println("tranIdDtl3 tran_id::"+tranIdDtl3);
							}
							else if(childNodeData != null && "line_no".equalsIgnoreCase(childNodeData.getNodeName()) && childNodeData.getFirstChild() != null)
							{
								lineNoDtl3 = checkNullAndTrim(childNodeData.getFirstChild().getNodeValue());
								System.out.println("lineNoDtl3 line_no::"+lineNoDtl3);
							}
							else if(childNodeData != null && "site_code".equalsIgnoreCase(childNodeData.getNodeName()) && childNodeData.getFirstChild() != null)
							{
								siteCodeDtl3 = checkNullAndTrim(childNodeData.getFirstChild().getNodeValue());
								System.out.println("siteCodeDtl3 site_code::"+siteCodeDtl3);
							}
							else if(childNodeData != null && "cctr_code_alloc".equalsIgnoreCase(childNodeData.getNodeName()) && childNodeData.getFirstChild() != null)
							{
								cctrCodeDtl3 = checkNullAndTrim(childNodeData.getFirstChild().getNodeValue());
								System.out.println("cctrCodeDtl3 cctr_code_alloc::"+cctrCodeDtl3);
							}
							else if(childNodeData != null && "cctr_descr".equalsIgnoreCase(childNodeData.getNodeName()) && childNodeData.getFirstChild() != null)
							{
								cctrDescrDtl3 = checkNullAndTrim(childNodeData.getFirstChild().getNodeValue());
								System.out.println("cctrDescrDtl3 cctr_descr::"+cctrDescrDtl3);
							}
							else if(childNodeData != null && "unit_alloc".equalsIgnoreCase(childNodeData.getNodeName()) && childNodeData.getFirstChild() != null)
							{
								unitAllocDtl3 = checkNullAndTrim(childNodeData.getFirstChild().getNodeValue());
								System.out.println("unitAllocDtl3 unit_alloc::"+unitAllocDtl3);
							}
							//totalAllocAmt = totalAllocAmt + Double.valueOf(unitAllocDtl3);							 
						}//end of for loop
						
						System.out.println("unit_alloc Value is :::"+totalAllocAmt);
						
						if(acctCodeDtl3 != null && acctCodeDtl3.length() > 0)
						{
							if(!acctCodeDtl3.equalsIgnoreCase(acct_code))
							{
								System.out.println("Account code belogs to Detail3");
								continue;
							}							
						}
						System.out.println("Delete Flag1="+deleteFlag1);
						if(deleteFlag1)
						{
							continue;
						}			  
						
						domIDLineNo++;
						System.out.println("domIDLineNo ::"+(domIDLineNo));
						pstmt1.setString(1,tranID);
						pstmt1.setInt(2,domIDLineNo);
						pstmt1.setString(3,"");
						pstmt1.setString(4,"");
						pstmt1.setString(5,cctrCodeDtl3);
						pstmt1.setString(6,unitAllocDtl3);
						pstmt1.setString(7,acctCodeDtl3);
						pstmt1.addBatch();		
						
						detailString.append("<Detail2 dbID=':' domID='" + (domIDLineNo) + "' objName='journal' objContext='2'>");
						detailString.append("<attribute pkNames='journal:line_no:' status='N' updateFlag='A' selected='Y'/>");
						detailString.append("<tran_id><![CDATA[" ).append(tranIDJNRL).append( "]]></tran_id>\r\n" );
						detailString.append("<line_no><![CDATA[" ).append((domIDLineNo)).append( "]]></line_no>\r\n" );
						detailString.append("<acct_code><![CDATA[" ).append((acctCodeDtl3)).append( "]]></acct_code>\r\n" );
						detailString.append("<cctr_code><![CDATA[" ).append((cctrCodeDtl3)).append( "]]></cctr_code>\r\n" );
						detailString.append("<drcr_flag><![CDATA[" ).append((drcrFlag)).append( "]]></drcr_flag>\r\n" );
						detailString.append("<amount><![CDATA[" ).append((unitAllocDtl3)).append( "]]></amount>\r\n" );
						detailString.append("<remarks><![CDATA[" ).append(("")).append( "]]></remarks>\r\n" );
						detailString.append("</Detail2>");
						System.out.println("Detail String is :::: " +detailString.toString());
					}//end of for loop for Detail2	
					
					System.out.println("acctCodeDtl3["+acctCodeDtl3+"]"+"tranIdDtl3["+tranIdDtl3+"]"+"lineNoDtl3["+lineNoDtl3+"]"+"siteCodeDtl3["+siteCodeDtl3+"]"+"cctrCodeDtl3["+cctrCodeDtl3+"]"+"cctrDescrDtl3["+cctrDescrDtl3+"]"+"unitAllocDtl3["+unitAllocDtl3+"]");
														
					if(from_date != null && from_date.length() > 0)
					{
						fromDateTimestamp = Timestamp.valueOf(from_date);
					}					
					if(to_date != null && to_date.length() > 0)
					{
						toDateTimestamp = Timestamp.valueOf(to_date);
						//toDateTimestamp = Timestamp.valueOf(genericUtility.getValidDateTimeString(toDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat()));
					}
					  
					/*    currDate = getCurrdateAppFormat();
					    tranDate = getCurrtDate();
					    loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
					    userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
						chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
					    
					    tranID = generateTranTd("w_cctr_alloc_wiz", currDate, loginSiteCode, conn);
					    System.out.println("generated transaction ID is :::::["+tranID+"]");
					    System.out.println("Line Number for Detail3 is :::["+lineNoDtl3+"]");
					    
						sql =   "insert into resource_cons " 
								+"(tran_id,prd_code,site_code,from_date,to_date,acct_code,cctr_code,exp_head,tot_units,add_date,add_user,add_term,chg_date,chg_user,chg_term) " 
								+"values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
						pstmt = conn.prepareStatement(sql);*/
						/*pstmt.setString(1,tranID);
						pstmt.setString(2,prd_code);
						pstmt.setString(3,site_code);
						pstmt.setTimestamp(4,fromDateTimestamp);
						pstmt.setTimestamp(5,toDateTimestamp);
						pstmt.setString(6,acct_code);
						pstmt.setString(7,cctr_code);
						pstmt.setString(8,exp_head);
						pstmt.setDouble(9,Double.valueOf(tot_units));
						pstmt.setTimestamp(10,tranDate);
						pstmt.setString(11,userId);
						pstmt.setString(12,chgTerm);
						pstmt.setTimestamp(13,tranDate);
						pstmt.setString(14,userId);
						pstmt.setString(15,chgTerm);
						pstmt.addBatch();
						pstmt.executeBatch();*/
						
					
					
						/*sql = "insert into resource_cons_det" 
							  +"(tran_id,line_no,cctr_code_alloc,unit_alloc,acct_code) " 
							  +"values(?,?,?,?,?,?,?)";
						
						pstmt = conn.prepareStatement(sql);*/
						/*pstmt1.setString(1,tranID);
						pstmt1.setInt(2,Integer.parseInt(lineNoDtl3));
						pstmt1.setString(3,cctrCodeDtl3);
						pstmt1.setString(4,unitAllocDtl3);
						pstmt1.setString(5,acctCodeDtl3);
						pstmt1.addBatch();*/
					
				/*	  sql = "insert into jourdet " 
							  +"(tran_id,line_no,acct_code,cctr_code,drcr_flag,amount,remarks)" 
							  +"values(?,?,?,?,?,?,?)";
						
					  pstmt3 = conn.prepareStatement(sql);*/
					 
							
					pstmt.clearParameters();
					pstmt1.clearParameters();
					/*pstmt2.clearParameters();
					pstmt3.clearParameters();*/
					System.out.println("Delete Flag="+deleteFlag);
			    	
					if(deleteFlag)
					{
						continue;
					}			    	
			    	selCnt++;
				}// end of main for loop for Detail2
				
				headerString = new StringBuffer("<Detail1 dbID='' domID='" + lineNo + "' objName=\"journal\" objContext=\"1\">");
				headerString.append("<attribute pkNames=\"tran_id:\" status=\"N\" updateFlag=\"A\" selected=\"Y\" />");
				headerString.append("<tran_id><![CDATA[" ).append(tranIDJNRL).append( "]]></tran_id>\r\n" );
				headerString.append("<tran_date><![CDATA[" ).append((sysDateStr)).append( "]]></tran_date>\r\n" );
				headerString.append("<site_code><![CDATA[" ).append((site_code)).append( "]]></site_code>\r\n" );
				headerString.append("<site_code__rev><![CDATA[" ).append((site_code)).append( "]]></site_code__rev>\r\n" );
				headerString.append("<reversible><![CDATA[" ).append(('N')).append( "]]></reversible>\r\n" );
				headerString.append("<eff_date><![CDATA[" ).append((sysDateStr)).append( "]]></eff_date>\r\n" );
				headerString.append("<fin_entity><![CDATA[" ).append(checkNullAndTrim(finEntityJrnal)).append( "]]></fin_entity>\r\n" );
				headerString.append("<curr_code><![CDATA[" ).append(checkNullAndTrim(currCodeJrnal)).append( "]]></curr_code>\r\n" );
				headerString.append("<exch_rate><![CDATA[" ).append((Double.valueOf(1))).append( "]]></exch_rate>\r\n" );
				/*headerString.append("<dr_amt><![CDATA[" ).append(debitAmount).append( "]]></dr_amt>\r\n" );
				headerString.append("<cr_amt><![CDATA[" ).append(creditAmount).append( "]]></cr_amt>\r\n" );*/
				headerString.append("<dr_amt><![CDATA[" ).append(0).append( "]]></dr_amt>\r\n" );
				headerString.append("<cr_amt><![CDATA[" ).append(0).append( "]]></cr_amt>\r\n" );
				headerString.append("<auto_rev><![CDATA[" ).append(('N')).append( "]]></auto_rev>\r\n" );
				headerString.append("<status><![CDATA[" ).append(('N')).append( "]]></status>\r\n" );
				headerString.append("<confirmed><![CDATA[" ).append(('N')).append( "]]></confirmed>\r\n" );
				headerString.append("<remarks><![CDATA[" ).append(("")).append( "]]></remarks>\r\n" );
				headerString.append("<tran_type><![CDATA[" ).append(("")).append( "]]></tran_type>\r\n" );
				headerString.append("</Detail1>\r\n");
				
				finalString = finalString.append(headerString.toString()+detailString.toString());
				finalString.append("</Header0></group0></DocumentRoot>");
				
				System.out.println("11111. XMLSTRING after adding detail1 " +finalString.toString());
				System.out.println("Total selected record for Form 3="+selCnt);
								    
				if(selCnt == 0) 
				{
					retString = itmDBAccessLocal.getErrorString("","VTBLNKDTL","","",conn);
					return retString;
				}
				else
				{
					pstmt.executeBatch();
					pstmt1.executeBatch();
					/*pstmt2.executeBatch();*/
					//pstmt3.executeBatch();
					
					if(pstmt != null)
					{
						pstmt.close(); 
						pstmt = null;
					}
					if(pstmt1 != null)
					{
						pstmt1.close(); 
						pstmt1 = null;
					}
					/*if(pstmt2 != null)
					{
						pstmt2.close(); 
						pstmt2 = null;
					}
					if(pstmt3 != null)
					{
						pstmt3.close(); 
						pstmt3 = null;
					}*/
				}
				//Added By PriyankaC on 18Oct2017...[Start]
				
				retString = saveJournalData(xtraParams,loginSiteCode,finalString.toString(),conn);
				System.out.println("saveJrnal retString :::::: ["+retString+"]");
				
				if ( retString.indexOf("Success") > -1 && retString.indexOf("<TranID>") > 0 )
				{
				    tranIDJNRL = retString.substring( retString.indexOf("<TranID>")+8, retString.indexOf("</TranID>"));
					System.out.println("tranIDJNRL is =======>> "+tranIDJNRL);
					
				     ctx = getInitialContext();
				     System.out.println("ctx value is ::::["+ctx+"]");
				     System.out.println("tranID:: ["+tranIDJNRL+"]" + "xtraParams:: ["+xtraParams+"]" + "forcedFlag:: ["+forcedFlag+"]");
				 	 //conn.commit();
				     JvConfirmLocal validation = (ibase.webitm.ejb.fin.adv.JvConfirmLocal)ctx.lookup("ibase/JvConfirm/local");
					 //responseXML = validation.confirm( tranID, xtraParams, forcedFlag, conn);
				     retString = validation.confirm( tranIDJNRL, xtraParams, forcedFlag, conn);
					 System.out.println("responseXMLinPosSave" +retString);
					 
					// CONFSUCCES
					/* if(retString != null && retString.indexOf("Error") != -1)
					 {
						 return retString;
					 }
					 else*/ 
					 if(retString.indexOf("CONFSUCCES") == -1)
					 {
						 retString = getError(responseXML, "TRFAILED", conn);
						 System.out.println("retString if Error ::"+retString);
						 isError = true;
						 return retString;
						 
					 }
					 else if(retString.indexOf("CONFSUCCES") != -1)
					 {
						 retString = "";
						 System.out.println("retString if Success ::"+retString);
						 return retString;
					 }
					 //System.out.println("final task completed:");
					 //retString = "";
				}// end of if block
				else
				{
					 return retString;
				}
				System.out.println("final task completed:");
				//Added By PriyankaC on 18Oct2017...[End]
			}
		}//end of try block
		catch(Exception e)
		{
			System.out.println("Exception :: CostCtrAllocPosEJB :: postSave method"+e);
			e.printStackTrace();
			throw new ITMException(e);
			
		}//end of catch block
		finally
		{
			try
			{
				System.out.println("Inside finally CostCtrAllocPosEJB isError["+isError+"] connStatus["+isLocCon+"]");
				if ( rs != null )
				{
					rs.close();rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				
				if(isLocCon)
				{
					if(isError)
					{
						System.out.println("Inside rollbacking....");
						conn.rollback();
					}
					else
					{
						System.out.println("Inside committing....");
						conn.commit();
					}
					if (conn != null )
					{
						conn.close();conn = null;
					}
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}//end of finally block
		System.out.println("errString from post save CostCtrAllocPosEJB =["+retString+"]");
		return retString;
	}//end of method postSave
	
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}//end of method checkNullAndTrim
	
	private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException 
	{
		String currAppdate = "";
		java.sql.Timestamp currDate = null;
		try 
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return (currDate);
	}//end of method getCurrtDate
	
	private String getCurrdateAppFormat() throws ITMException 
	{
		String s = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			java.util.Date date = null;
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());

			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
			s = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(timestamp).toString();
		}
		catch (Exception localException)
		{
			localException.printStackTrace();
			throw new ITMException(localException);
		}

		return s;
	}//end of method getCurrdateAppFormat
	
	public int GetRandomNumber()
    {
        long timeSeed = System.nanoTime(); // to get the current date time value
        double randSeed = Math.random() * 1000; // random number generation
        long midSeed = (long) (timeSeed * randSeed); 
        String s = midSeed + "";
        String subStr = s.substring(0, 9);
        int finalSeed = Integer.parseInt(subStr);    // integer value
        return finalSeed;
    }//end of method GetRandomNumber
	
		
	private String generateTranTd(String windowName,String tranDate,String siteCode, Connection  conn )throws ITMException
	{		
		System.out.println("inside generateTranTd@@.........");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String tranId = "";
		String newKeystring = "",tranSer1 = "",keyString = "",keyCol = "";
		CommonConstants commonConstants = new CommonConstants();
		try
		{		 	
			sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, windowName);

			rs = pstmt.executeQuery();
			System.out.println("keyString :"+sql);

			if (rs.next())
			{
				keyString = rs.getString(1);
				keyCol = rs.getString(2);
				tranSer1 = rs.getString(3);
			}
			else
			{
				sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "GENERAL");
				rs = pstmt.executeQuery();
				System.out.println("keyString :"+sql);				
				if (rs.next())
				{
					keyString = rs.getString(1);
					keyCol = rs.getString(2);
					tranSer1 = rs.getString(3);
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer1 :"+tranSer1);
			String xmlValues = "";
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +	"<tran_id></tran_id>";
			xmlValues = xmlValues + "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues + "<tran_date>"+ tranDate + "</tran_date>";
			xmlValues = xmlValues + "<tran_type>"+"U"+"</tran_type>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", commonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer1, keyCol, keyString, conn);

			System.out.println("tranId ::"+tranId);
		}
		catch (SQLException ex)
		{			
			System.out.println("Exception ::" +sql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{		
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}

		return tranId;
	}//end of method generateTranTd
	
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("CostCtrAllocServlet.getInitialContext()");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("CostCtrAllocServlet.getInitialContext()"+e.getMessage());
			throw new ITMException(e);
		}
		return ctx;
	}//end of method getInitialContext
	
	private  String getError(String errorstr,String Code,Connection conn)  throws ITMException, Exception
    {
        String mainStr ="";
        
        try
        {
        	String errString = "";
        	errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			String begPart = errString.substring(0,errString.indexOf("<message>")+9);
			String endDesc = errString.substring(errString.indexOf("</description>"));
			mainStr= begPart+"Invalid Data"+"</message><description>";
			mainStr= mainStr+"Process Failed ["+errorstr+""+endDesc;
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
        }
        catch(Exception e)
        {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return mainStr;
    }//end of method getError
	
	public String getFinEntityVal(String siteCode,Connection conn)
	{
		String sql = "",FinEntto="";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		try
		{
			sql ="select fin_entity from site where site_code = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString (1,siteCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				FinEntto = rs.getString(1);
				System.out.println("Fin Entiry ::::: ["+FinEntto+"]");
			}
			rs.close();
			rs = null; 
			pstmt.close();
			pstmt =null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return checkNullAndTrim(FinEntto);
	}//end of method getFinEntityVal
	
	public String getCurrencyCodeVal(String finEntity,Connection conn)
	{
		String sql = "",currCodeVal="";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		try
		{
			sql ="select curr_code from finent where fin_entity = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString (1,finEntity);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				currCodeVal = rs.getString(1);
				System.out.println("currCodeVal ::::: ["+currCodeVal+"]");
			}
			rs.close();
			rs = null; 
			pstmt.close();
			pstmt =null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return checkNullAndTrim(currCodeVal);
	}//end of method getCurrencyCodeVal
	
	public String saveJournalData(String xtraParams,String siteCode, String xmlString, Connection conn) throws ITMException
	{
		System.out.println("Inside saveJournalData method of CostCtrAllocPosEJB");
		InitialContext ctx = null;
		String retString = null;
		MasterStatefulLocal masterStateful = null;
		try
		{
			System.out.println("Data in xmlString is :::::: ["+xmlString+"]");
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");

			/*String [] authencate = new String[2];
			authencate[0] = "";
			authencate[1] = "";
			System.out.println("xmlString in masterStateful :::: " + xmlString);
			retString = masterStateful.processRequest(authencate, siteCode, true, xmlString, true, conn);
			masterStateful = null;*/		
			String userInfo = getUserInfo(xtraParams);
			System.out.println("userInfo >>>>>>"+userInfo);
			retString = masterStateful.processRequest(userInfo, xmlString.toString(), true, conn); 
		}
		catch(Exception e)
		{
			System.out.println("Inside saveJournalData method ::::"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}//end of method saveJournalData
	
	public String getXtraParams(String loginCode, String siteCode, String empCode, Connection conn)throws Exception
	{
		String remotehost = "", entityCode = "", profileId = "", userType = "", userCountry = "", userLang="";
		StringBuffer xtraParamsBuff = new StringBuffer();
		String sql = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;

		try
		{
			sql = "SELECT USER_TYPE,ENTITY_CODE,PROFILE_ID,USER_LANG,USER_COUNTRY FROM USERS WHERE CODE = ? ";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,loginCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				entityCode = rs.getString("ENTITY_CODE");
				profileId  = rs.getString("PROFILE_ID");
				userType   = rs.getString("USER_TYPE");
				userLang   = rs.getString("USER_LANG");
				userCountry= rs.getString("USER_COUNTRY");
			}			
            System.out.println("entityCode ::["+entityCode+"]" + "profileId ::["+profileId+"]" + "userType ::["+userType+"]" + "userLang ::["+userLang+"]" + "userCountry ::["+userCountry+"]");
			remotehost =  InetAddress.getLocalHost().getHostAddress();
			String XTRA_PARAMS_SEPARATOR = "~~";

			xtraParamsBuff.append("loginCode=" + loginCode);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + empCode);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + siteCode);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + entityCode);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + profileId);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + userType);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode=I");
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_lang=" + userLang);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_country=" + userCountry);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("charEnc=" + CommonConstants.ENCODING);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId="+remotehost);

			String chgTerm = remotehost;

			if(chgTerm!=null && chgTerm.length()>15){

				chgTerm = chgTerm.substring(0, 15);
			}

			else if(chgTerm==null || chgTerm.length()==0){

				chgTerm = remotehost;
			}

			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm );
			System.out.println("xtraParamsBuff ["+xtraParamsBuff+"]");

		}//end of try block
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{	
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{

				e.printStackTrace();
			}
		}
		return xtraParamsBuff.toString();
	}//end of method getXtraParams
	
	public String getUserInfo(String xtraParams)throws ITMException
	{
		StringBuffer userInfoStr = new StringBuffer();
		String userId = "", loginEmpCode = "", loginSiteCode = "", entityCode = "", profileId = "",
		userType = "", chgTerm = "";
		
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			entityCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode");
			profileId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"profileId");
			userType = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userType");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");

			System.out.println("xtraParams  is @@@@@ " + xtraParams);

			userInfoStr.append("<UserInfo>");
			userInfoStr.append("<loginCode>").append("<![CDATA["+userId+"]]>").append("</loginCode>\r\n");
			userInfoStr.append("<empCode>").append("<![CDATA["+loginEmpCode+"]]>").append("</empCode>\r\n");
			userInfoStr.append("<siteCode>").append("<![CDATA["+loginSiteCode+"]]>").append("</siteCode>\r\n");
			userInfoStr.append("<entityCode>").append("<![CDATA["+entityCode+"]]>").append("</entityCode>\r\n");
			userInfoStr.append("<profileId>").append("<![CDATA["+profileId+"]]>").append("</profileId>\r\n");
			userInfoStr.append("<userType>").append("<![CDATA["+userType+"]]>").append("</userType>\r\n");
			userInfoStr.append("<remoteHost>").append("<![CDATA["+chgTerm+"]]>").append("</remoteHost>\r\n");
			userInfoStr.append("</UserInfo>");
		}
		catch (Exception e)
		{	
			System.out.println(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return userInfoStr.toString();
	}//end of method getUserInfo
}//end of class CostCtrAllocPosEJB
