/**
* PURPOSE : Pre Save Logic implementation for packing component.
* AUTHOR : BALU
*/

package ibase.webitm.ejb.wms;

import ibase.webitm.ejb.*;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;

import java.rmi.RemoteException;
import java.sql.*;

import org.w3c.dom.*;

import javax.ejb.*;

@javax.ejb.Stateless
public class PackingPrs extends ValidatorEJB //implements PoRcpPrsLocal, PoRcpPrsRemote
{
	public String preSave() throws RemoteException,ITMException
	{
		return "";
	}

	public String preSave(String xmlString, String editFlag, String xtraParams, Connection conn)throws RemoteException,ITMException
	{

		System.out.println("PackingPrs EJB called");
		Document dom = null;
		try
		{
			System.out.println("xmlString in PackPrs : preSaveRec \n"+xmlString);			
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = GenericUtility.getInstance().parseString(xmlString);
				executepreSave( dom, editFlag, xtraParams, conn );
			}			
		}
		catch(Exception e)
		{
			System.out.println("Exception :PackPrs :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return "";
	}

	private String executepreSave( Document dom, String editFlag, String xtraParams, Connection conn ) throws RemoteException, ITMException
	{
		String sql = "";			
		String tranId = "";
		
		int deleteCount = 0;
		
		ResultSet rs = null;
		PreparedStatement pstmt = null;

		try
		{			
			conn.setAutoCommit(false); 
			GenericUtility genericUtility = GenericUtility.getInstance();
			
			tranId = genericUtility.getColumnValue( "tran_id", dom, "2" );
			
			if( tranId != null && tranId.trim().length() > 0 )
			{
				sql = "DELETE FROM PACK_DET WHERE TRAN_ID = ?";	
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				deleteCount = pstmt.executeUpdate();						
				if( deleteCount > 0 )
				{
					System.out.println( "Row with Tran_ID " + tranId + " deleted from PACKDET table" );
				}						
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}	
				
				sql = "DELETE FROM PACK_HDR WHERE TRAN_ID = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				deleteCount = pstmt.executeUpdate();						
				if( deleteCount > 0 )
				{
					System.out.println( "Row with Tran_ID " + tranId + " deleted from PACK_HDR table" );
				}						
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
										
		}
		catch (SQLException sqe)
		{
			System.out.println("The SQLException occurs in PackPrs :"+sqe);
			sqe.printStackTrace();
			throw new ITMException(sqe);
		}
		catch(Exception e)
		{
			System.out.println("The Exception occurs in PackPrs :"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :PackPrs :\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return "";
	}
}
