/*
 * Author:Wasim Ansari
 * Date:03-05-2017
 * Request ID:F17BBAS001 (GST Wizard Post Save Component for Reconciliation Trace)
 */
package ibase.webitm.ejb.gst;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class GSTRegNoPosEJB extends ValidatorEJB implements GSTRegNoPosEJBRemote,GSTRegNoPosEJBLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
    /**
     * Default constructor. 
     */
    public GSTRegNoPosEJB() {
        // TODO Auto-generated constructor stub
    }

	@Override
	public String postSave(String xmlStringAll, String tranID, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException 
	{
		String retString="";
		try 
		{
			retString = postSave(xmlStringAll, xtraParams, "", conn);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	
		
	public String postSave(String xmlstring, String xtraParams, String forcedFlag, Connection conn) throws RemoteException,ITMException
	{
		System.out.println("Inside GSTRegNoPosEJB Post Save ["+xmlstring+"] \n xtraParams ["+xtraParams+"] \n forcedFlag["+forcedFlag+"]");
		String finEntity="",finDescr="",siteCode="",siteDescr="",regNo="",regNo1="",regNo2="";
		String regDate=null;	
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Timestamp currDate = null;
		Timestamp validUptoDate = null;
		boolean isError = false,isLocCon = false;
		Document dom = null;
		String sql = "",retString = "",tranID = "", tranIdGSTN = "";
		String gstInNo = "GSTIN_NO";
		String gstUserName = "GST_UNAME";
		String gstGT = "GST_GT";
		int cnt = 0;
		String gstRefCode = "";
		String loginSite = "";
		java.sql.Date chg_date=null;
		String val = "";
		String loginSiteCode = "";
		try
		{	
			if(conn == null || conn.isClosed())
			{
				System.out.println("@@Connection is null");
				conn = getConnection();
				isLocCon = true;
			}
			else
			{
				System.out.println("@@Connection is not null");
			}
			
			if(xmlstring != null &&  (xmlstring.indexOf("Detail1") != -1))
			{
				currDate = new java.sql.Timestamp(System.currentTimeMillis());
	            SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
	            SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
	            String currDateStr = sdfAppl.format(currDate.getTime());
	            currDate = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
	            //currDate = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
	            System.out.println("currDate:::::::::"+currDate);
							
			    dom = genericUtility.parseString(xmlstring); 
				
				NodeList detail1NodeList =dom.getElementsByTagName("Detail1");
				int detail3NodeListlen = detail1NodeList.getLength();
				loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
				System.out.println("loginSite>>>>>>>>>>"+loginSite);
				
				for(int ctrH = 0; ctrH < detail3NodeListlen ; ctrH++)
				{
					NodeList childNodeList = detail1NodeList.item(ctrH).getChildNodes();
					int childNodeListlen = childNodeList.getLength();
					System.out.println("childNodeListlen>>>>>"+childNodeListlen);
										
					for(int ctrD = 0; ctrD < childNodeListlen ; ctrD++)
					{
						Node childNode = childNodeList.item(ctrD);
						System.out.println("childNode.getNodeName()>>"+childNode.getNodeName());
						if(childNode != null && "fin_entity".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							finEntity = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "finent_descr".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							finDescr = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "site_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							siteCode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "site_descr".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							siteDescr = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "reg_no".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							regNo = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "reg_no1".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							regNo1 = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "reg_no2".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							regNo2 = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
						else if(childNode != null && "reg_date".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							regDate = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
						}
					}
				}		
				System.out.println("finEntity["+finEntity+"]"+"finDescr["+finDescr+"]"+"siteCode["+siteCode+"]"+"siteDescr["+siteDescr+"]"+"regNo["+regNo+"]"+"regNo1["+regNo1+"]"+"regNo2["+regNo2+"]"+"regDate["+regDate+"]");
				
				validUptoDate = Timestamp.valueOf(genericUtility.getValidDateString(regDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
				System.out.println("validUptoDate["+validUptoDate+"]");
				ArrayList refList = new ArrayList();
				refList.add("GSTIN_NO");
				refList.add("GST_UNAME");
				refList.add("GST_GT");
				
				ArrayList gstList = new ArrayList();
				gstList.add(regNo);
				gstList.add(regNo1);
				gstList.add(regNo2);
				
				HashMap map = new HashMap();
				map.put(regNo, "GSTIN_NO");
				map.put(regNo1, "GST_UNAME");
				map.put(regNo2, "GST_GT");
				
				sql = "select count(*) as cnt from siteregno where fin_entity=? AND site_code=? AND ref_code=?";
				pstmt = conn.prepareStatement(sql);
			    
				for(int i=0;i<refList.size();i++)
			    {
				   	String refCode = (String)refList.get(i);
				   	System.out.println("refCode::::"+refCode);
				   	pstmt.setString(1,finEntity);
					pstmt.setString(2,siteCode);
					pstmt.setString(3,refCode.trim());
					rs = pstmt.executeQuery();
			    }
				if(rs.next())
				{
					cnt = rs.getInt("cnt");
					System.out.println("cnt>>>>>>>"+cnt);
				}
				if(pstmt != null)
				{
					pstmt.close(); 
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}							
				if(cnt>0)
				{
					sql = "update siteregno set reg_no=?,reg_date=? where fin_entity=? AND site_code=? AND ref_code=?";
					pstmt = conn.prepareStatement(sql);
					for(int x =0 ; x< gstList.size(); x++)
					{
						gstRefCode = (String) gstList.get(x);
						val = (String) map.get(gstRefCode);
						pstmt.setString(1,gstRefCode.trim());
						pstmt.setTimestamp(2,validUptoDate);
						pstmt.setString(3,finEntity);
						pstmt.setString(4,siteCode);
						pstmt.setString(5,val);
						pstmt.executeUpdate();
					}
					if(pstmt != null)
					{
						pstmt.close(); 
						pstmt = null;
					}
				}
				else
				{
					sql = " insert into siteregno (fin_entity,site_code,ref_code,reg_no,valid_upto,reg_date,chg_date,chg_user,eff_from) values(?,?,?,?,?,?,?,?)";
					pstmt = conn.prepareStatement(sql);
					
					for(int y =0 ; y< gstList.size(); y++)
					{
						gstRefCode = (String) gstList.get(y);
						val = (String) map.get(gstRefCode);
						pstmt.setString(1,finEntity);
						pstmt.setString(2,siteCode);
						pstmt.setString(3,val);
						pstmt.setString(4, gstRefCode);
						pstmt.setTimestamp(5,currDate);
						pstmt.setTimestamp(6,validUptoDate);
						pstmt.setTimestamp(7,currDate);
						pstmt.setString(8,loginSite);
						pstmt.setTimestamp(9,currDate);
						pstmt.addBatch();
					}
					pstmt.executeBatch();
					if(pstmt != null)
					{
					pstmt.close(); 
					pstmt = null;
					}
				}
				
				
				retString= insertUserSignAcc(xmlstring,xtraParams,forcedFlag, conn);
				
				
				
				
				
			}//End if Detail1 not found
			else
			{
				System.out.println("Detail1 not found");
				retString = itmDBAccessLocal.getErrorString("","VTBLNKDTL","","",conn);
				return retString;
			}
		}// end of try block
		catch(Exception e)
		{
			System.out.println("Exception GSTRegNoPosEJB ==>"+e.getMessage());
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Inside finally GSTRegNoPosEJB isError["+isError+"] connStatus["+isLocCon+"]");
				if (rs != null )
				{
					rs.close();rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if(isLocCon)
				{
					if(isError)
					{
						System.out.println("Inside rollbacking....");
						conn.rollback();
					}
					else
					{
						System.out.println("Inside committing....");
						conn.commit();
					}
					if (conn != null )
					{
						conn.close();conn = null;
					}
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("errString from post save GSTRegNoPosEJB =["+retString+"]");
		return retString;
	}
	
	
	public String insertUserSignAcc(String xmlstring, String xtraParams, String forcedFlag, Connection conn) throws ITMException
	{
		String userId="",signMethod="",serviceProvider="",serviceUri="",clientID="",clientSecret="",docType="",editFlag="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",retString = "";

		try
		{
			
		    Document dom = genericUtility.parseString(xmlstring); 
			
			NodeList detail1NodeList =dom.getElementsByTagName("Detail2");
			int detail3NodeListlen = detail1NodeList.getLength();
			
			for(int ctrH = 0; ctrH < detail3NodeListlen ; ctrH++)
			{
				userId="";signMethod="";serviceProvider="";serviceUri="";clientID="";clientSecret="";docType="";editFlag="";
				
				NodeList childNodeList = detail1NodeList.item(ctrH).getChildNodes();
				int childNodeListlen = childNodeList.getLength();
				System.out.println("insertUserSignAcc childNodeListlen>>>>>"+childNodeListlen);
									
				for(int ctrD = 0; ctrD < childNodeListlen ; ctrD++)
				{
					Node childNode = childNodeList.item(ctrD);
					System.out.println("insertUserSignAcc childNode.getNodeName()>>"+childNode.getNodeName());
					
					if(childNode != null && "user_id".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						userId = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "sign_method".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						signMethod = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "service_provider".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						serviceProvider = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "service_uri".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						serviceUri = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "client_id".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						clientID = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "client_secret".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						clientSecret = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "doc_type".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						docType = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "edit_flag".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						editFlag = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
				}
				
				System.out.println("@@EditFlag["+editFlag+"]");
				System.out.println("docType::  "+docType+"signMethod::"+signMethod);
				
				if("A".equalsIgnoreCase(editFlag))
				{
					sql = " insert into user_sign_acc (user_id,sign_method,service_provider,service_uri,client_id,client_secret,doc_type) values(?,?,?,?,?,?,?)";
					pstmt = conn.prepareStatement(sql);
					
					pstmt.setString(1,userId);
					pstmt.setString(2,signMethod);
					pstmt.setString(3,serviceProvider);
					pstmt.setString(4,serviceUri);
					pstmt.setString(5,clientID);
					pstmt.setString(6,clientSecret);
					pstmt.setString(7,docType);
						
					pstmt.executeUpdate();
					if(pstmt != null)
					{
					 pstmt.close(); 
					 pstmt = null;
					}
				}
				else if("E".equalsIgnoreCase(editFlag))
				{
					sql = " update user_sign_acc set service_provider=?,service_uri=?,client_id=?,client_secret=? where user_id=? and doc_type=? and sign_method=?";
					pstmt = conn.prepareStatement(sql);
					
					pstmt.setString(1,serviceProvider);
					pstmt.setString(2,serviceUri);
					pstmt.setString(3,clientID);
					pstmt.setString(4,clientSecret);
					pstmt.setString(5,userId);
					pstmt.setString(6,docType);
					pstmt.setString(7,signMethod);
					
					pstmt.executeUpdate();
					if(pstmt != null)
					{
						pstmt.close(); 
						pstmt = null;
					}
				}
			}	
			
		}
		catch(Exception ex)
		{
			System.out.println("Exception inside insertUserSignAcc==>"+ex.getMessage());
			throw new ITMException(ex);
		}
		finally
		{
			try{
			if (rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();pstmt = null;
			}
			}
			catch(Exception ex)
			{
				System.out.println("exception "+ex);
			}
		}
		
		return retString;
	}
	
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
}
