package ibase.server;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.io.IOUtils;

/**
 * Servlet which do the magic conversion.<br>
 * Dont forget to declare it in your web.xml<br>
 * < servlet><br>
 * < servlet-name>gwtTableToExcelServlet< /servlet-name><br>
 * < servlet-class>com.googlecode.gwtTableToExcel.server.TableToExcelServlet<
 * /servlet-class><br>
 * </ servlet><br>
 * < servlet-mapping><br>
 * < servlet-name>gwtTableToExcelServlet< /servlet-name><br>
 * < url-pattern>/gtte/excel< /url-pattern><br>
 * < /servlet-mapping><br>
 * 
 * @author Francois Wauquier 'wokier'
 */
@SuppressWarnings("serial")
public class TableToExcelServlet extends HttpServlet
{

	private String encoding = "ISO-8859-1";

	/**
	 * Constructor
	 */
	public TableToExcelServlet()
	{
		super();
	}

	/**
	 * @see HttpServlet#init()
	 */
	@Override
	public void init() throws ServletException
	{
		super.init();
	}

	/**
	 * see HttpServlet#init(ServletConfig)
	 */
	@Override
	public void init(ServletConfig config) throws ServletException
	{
		super.init(config);
		String initParameterEncoding = config.getInitParameter("encoding");
		if (initParameterEncoding != null)
		{
			setEncoding(initParameterEncoding);
		}
	}

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
	{
		export(request, response);
	}

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
	{
		export(request, response);
	}

	private void export(HttpServletRequest request, HttpServletResponse response)
	{
		try
		{
			HttpSession session = request.getSession(false);
			System.out.println("before session");
			String reportName = (String)session.getAttribute("reportName");
			System.out.println("After session");
			String html = request.getParameter("html");
			String fileName = request.getParameter("fileName");
			String export = request.getParameter("export");
			System.out.print(" fileName  is=" + fileName + "  export type is =" + export);
			System.out.println("html Data for PDF is ="+html);
			
			System.out.println("reportName---->"+reportName);
			response.reset();
			if(reportName == null)
			{
				fileName ="Dashboard";
			}else{
				fileName = reportName;
			}

			System.out.print(" fileName  is=" + fileName + "  export type is =" + export);
			if ("Excel".equals(export))
			{
				if (!fileName.endsWith(".xls"))
				{
					fileName = fileName + ".xls";
				}
				response.setContentType("application/vnd.ms-excel");
				response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
				response.getWriter().write(html);
			}
			else if ("PDF".equals(export))
			{

				if (!fileName.endsWith(".pdf"))
				{
					fileName = fileName + ".pdf";
				}
				//processRequest(request,response,html);
				createPdfUsingItext(request, response, html);
			}
			
		} catch (IOException e)
		{
			System.out.println("TableToExcelServlet : export()=" + e);
			e.printStackTrace();
		}
	}

	
	public void createPdfUsingItext(HttpServletRequest request, HttpServletResponse response, String exampleString)
	{
		System.out.println(" In createPdfUsingItext ");
		/*try
		{
			response.setContentType("application/pdf");
			response.setHeader("Content-disposition", "attach; filename=test.pdf");

			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			Document document = new Document();
			PdfWriter.getInstance(document, baos);
			System.out.println(" After setting header ");

			OutputStream out = response.getOutputStream();
			//PdfWriter.getInstance(document, out);
			document.open();
			document.add(new Paragraph("Tutorial to Generate PDF using Servlet"));
			document.add(new Paragraph("PDF Created Using Servlet, iText Example Works"));
			document.close();

			response.setContentLength(baos.size());
			// write ByteArrayOutputStream to the ServletOutputStream
			OutputStream os = response.getOutputStream();
			baos.writeTo(os);
			os.flush();
			os.close();
			System.out.println(" After pdf generation ");
		}
		
		  catch (DocumentException e) { // TODO Auto-generated catch block //
		 e.printStackTrace(); }
		 
		catch (IOException e)
		{
			// TODO Auto-generated catch block
			//  e.printStackTrace();
		} */
	}
	
	public void setEncoding(String encoding)
	{
		this.encoding = encoding;
	}
}
