package ibase.webitm.util.gst;

import java.io.IOException;
import java.text.SimpleDateFormat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.IMPG;
import ibase.webitm.bean.gst.InvLineItem;

public class IMPGSerializer extends JsonSerializer<IMPG>
{
	GSTCommonUtil gstCommonUtil = new GSTCommonUtil();
    final SimpleDateFormat gstFmt = new SimpleDateFormat(gstCommonUtil.getGSTDateFormat());
	
	@Override
	public void serialize(IMPG impg, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
	{
		json.writeStartObject();
		
		json.writeStringField("is_sez", impg.isSezImport ? "Y" : "N");
		if(impg.isSezImport)
		{
			json.writeStringField("stin", impg.sezGSTIN);
		}
		json.writeStringField("boe_num", impg.billOfEntryNo);
		json.writeStringField("boe_dt", gstFmt.format(impg.billOfEntryDate));
		json.writeNumberField("boe_val", impg.amount);
		json.writeStringField("port_code", impg.portCode);
		
		json.writeFieldName("itms");
	
		json.writeStartArray();
		for(InvLineItem li : impg.items)
		{
			json.writeStartObject();
			
			json.writeNumberField("num", li.num);
			json.writeNumberField("txval", li.taxval);
			json.writeNumberField("rt", li.rate);
			if(li.iamt > 0.0)
            {
            	json.writeNumberField("iamt", li.iamt);
            }
            
            if(li.camt > 0.0)
            {
            	json.writeNumberField("camt", li.camt);
            }
        	
            if(li.samt > 0.0)
            {
            	json.writeNumberField("samt", li.samt);
            }
            
            if(li.csamt > 0.0)
            {
            	json.writeNumberField("csamt", li.csamt);
            }
            
			json.writeStringField("elg", li.itcType);
			json.writeNumberField("tx_i", li.igstInputTax);
			if(li.cgstInputTax > 0.0)
			{
				json.writeNumberField("tx_c", li.cgstInputTax);
			}
			if(li.sgstInputTax > 0.0)
			{
				json.writeNumberField("tx_s", li.sgstInputTax);
			}
        	json.writeNumberField("tx_cs", li.cessInputTax);
        	
        	json.writeEndObject();
		}
		json.writeEndArray();
		 
		json.writeEndObject();
	}

}
