/**
 * PURPOSE : PhysicalCountIC component
 * AUTHOR : Sneha Mestry
 * DATE : 18-04-2016
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.*;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.reports.utility.SiteCodeBean;

import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wms.CommonWmsUtil;

import java.rmi.RemoteException;
import java.sql.*;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.*;

import org.w3c.dom.*;

@javax.ejb.Stateless
public class PhysicalCountIC extends ValidatorEJB implements PhysicalCountICLocal, PhysicalCountICRemote 
{
	E12GenericUtility genericUtility = new E12GenericUtility(); 

	@Override
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(DOM)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		try
		{
			System.out.println( "xmlString ::" + xmlString);
			System.out.println( "xmlString1 ::" + xmlString1);
			System.out.println( "xmlString2 ::" + xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( dom, dom1, dom2, objContext, xtraParams);
			System.out.println( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return (errString); 
	}
	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String xtraParams) throws RemoteException, ITMException
	{   				
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;

		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String  userId = "", childNodeName = "", errorType = "", errCode = "", errString = "";
		int currentFormNo = 0, childNodeListLength = 0, cnt = 0, ctr = 0;

		ArrayList <String> errList = new ArrayList<String>();
		ArrayList <String> errFields = new ArrayList <String> ();

		String locCode = "", itemCode = "", siteCode = "", lotNo = "", lotSl = "",sql= "";
		int locationCount = 0, itemCodeCount = 0, lotNoCount = 0, lotSlCount = 0;

		try
		{	
			System.out.println("<<========= Inside wfValData ===========>>"); // remove
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");*/
			conn = getConnection();
			conn.setAutoCommit(false);
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]

			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			siteCode = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");

			System.out.println("xtraParam----->>["+xtraParams+"]");
			System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
			System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
			System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");	

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}	

			switch ( currentFormNo )  
			{
			case 1:

				System.out.println("------in detail1 validation----------------");
				break;			

			case 2:
				System.out.println("------in detail2 validation----------------");

				locCode = checkNullAndTrim(genericUtility.getColumnValue("loc_code",dom2));	
				itemCode = checkNullAndTrim(genericUtility.getColumnValue("item_code",dom2));
				lotNo = checkNullAndTrim(genericUtility.getColumnValue("lot_no",dom2));	
				lotSl = checkNullAndTrim(genericUtility.getColumnValue("lot_sl",dom2));	

				System.out.println(" locCode in detail2 case2 ========>>"+locCode);
				System.out.println(" itemCode in detail2 case2 ========>>"+itemCode);
				System.out.println(" lotNo in detail2 case2 ========>>"+lotNo);
				System.out.println(" lot_sl in detail2 case2 ========>>"+lotSl);

				parentNodeList = dom2.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					//System.out.println("value of child node name ["+childNodeName + "]");

					if("loc_code".equalsIgnoreCase(childNodeName))
					{
						if(locCode.length() == 0 || locCode.equalsIgnoreCase("")) //BLANK
						{							
							//System.out.println("<<=========== location code found blank ========>> ");
							errCode = "VTLOCBLANK";		
							errList.add( errCode );
							errFields.add(childNodeName.toLowerCase());
							break;
						}
						else 
						{
							locationCount = getLocationCount(locCode, conn);
							if(locationCount == 0)
							{
								//System.out.println("<<========== No location found =============>> ");
								errCode = "VTLOCINVLD";		
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}
						}
					}
					else if("item_code".equalsIgnoreCase(childNodeName))
					{
						if(itemCode.length() == 0 || itemCode.equalsIgnoreCase("")) //BLANK
						{							
							//System.out.println("<<=========== item code found blank ========>> ");
							errCode = "VTITEMBLNK";		
							errList.add( errCode );
							errFields.add(childNodeName.toLowerCase());
							break;
						}
						else 
						{
							itemCodeCount = getItemCodeCount(siteCode, locCode, itemCode, conn);
							if(itemCodeCount == 0)
							{
								//System.out.println("<<========== No item code found =============>> ");
								errCode = "VTITEMINVD";		
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}
						}
					}
					else if("lot_no".equalsIgnoreCase(childNodeName))
					{
						if(lotNo.length() == 0 || lotNo.equalsIgnoreCase("")) //BLANK
						{							
							//System.out.println("<<=========== lotNo found blank ========>> ");
							errCode = "VTLOTNOBLK";		
							errList.add( errCode );
							errFields.add(childNodeName.toLowerCase());
							break;
						}
						else 
						{
							lotNoCount = getLotNoCount(siteCode, locCode, itemCode, lotNo, conn);

							if(lotNoCount == 0)
							{
								//System.out.println("<<========== No lotNo found =============>> ");
								errCode = "VTLOTNOINV";		
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}
						}
					}
					else if("lot_sl".equalsIgnoreCase(childNodeName))
					{
						if(lotSl.length() == 0 || lotSl.equalsIgnoreCase("")) //BLANK
						{							
							//System.out.println("<<=========== lotNo found blank ========>> ");
							errCode = "VTLSLBLANK";		
							errList.add( errCode );
							errFields.add(childNodeName.toLowerCase());
							break;
						}
						else 
						{
							lotSlCount = getLotSlCount(siteCode, locCode, itemCode, lotNo, lotSl, conn);

							if(lotSlCount == 0)
							{
								//System.out.println("<<========== No lotSl found =============>> ");
								errCode = "VTLOTSLINV";		
								errList.add( errCode );
								errFields.add(childNodeName.toLowerCase());
								break;
							}
						}
					}
				} 
				break;

			}//End of switch statement

			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn, errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;

				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}	
			errString = errStringXml.toString();
		}
		catch ( Exception e )
		{
			System.out.println ( "Exception: PhysicalCountIC: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			throw new ITMException(e);	
		}
		finally
		{
			try
			{

				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : PhysicalCountIC:wfValData : " + e.getMessage() );
				throw new ITMException(e);
			}
		}
		System.out.println( "errString>>>>>>>::" + errString );
		return errString;
	}

	private String errorType(Connection conn, String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

	@Override
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;

		System.out.println("xmlString in itemChanged ["+xmlString+"]");
		System.out.println("xmlString1 in itemChanged ["+xmlString1+"]");
		System.out.println("xmlString2  in itemChanged ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			System.out.println ( "Calling  itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams )");
			errString = itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception : PhysicalCountIC:itemChanged(String,String):" + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		System.out.println ( "returning from PhysicalCountIC itemChanged \n[" + errString + "]" );

		return errString;
	}

	@Override
	public String itemChanged( Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{	
		Connection conn = null;
		int currentFormNo = 0;
		String chgUser = "", chgTerm = "",  loginSite = "", locCode = "", locDescr = "", itemCode = "", itemDescr = "", unit = ""
			,lotSl ="" ,lotNo="",sql= "";
		StringBuffer valueXmlString;
		double quantity=0;

		valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append(editFlag);
		System.out.println("xtraParams=["+xtraParams+"]");
		System.out.println("Physical Count  itemChanged Called........................... : ["+currentColumn+"]"); 
		try
		{
			System.out.println("<<========= Inside itemChanged ===========>>"); // remove
			
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );	
			connDriver = null;*/
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			PreparedStatement pstmt = null;
			ResultSet rs= null;

			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(currentDate.getTime());	

			System.out.println("hdrDataDom------->>["+genericUtility.serializeDom(hdrDataDom)+"]");	
			System.out.println("currFormDataDom------>>["+genericUtility.serializeDom(currFormDataDom)+"]");
			System.out.println("allFormDataDom------>>["+genericUtility.serializeDom(allFormDataDom)+"]");

			loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));			
			chgUser = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
			chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));


			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			System.out.println("current form no["+currentFormNo+"]");

			valueXmlString.append("</editFlag>\r\n</Header>\r\n");

			switch ( currentFormNo )  
			{
			case 1:
			{
				System.out.println("<<------------------- Inside case1 itemChanged physical count -------------------->>");	 // remove

				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					valueXmlString.append( "<Detail1>\r\n" );
					valueXmlString.append( "<tran_date><![CDATA[" ).append( currDate ).append( "]]></tran_date>\r\n" );
					valueXmlString.append( "<site_code><![CDATA[" ).append( loginSite ).append( "]]></site_code>\r\n" );
					valueXmlString.append( "<confirmed><![CDATA[" ).append( "N" ).append( "]]></confirmed>\r\n" );
					valueXmlString.append( "<chg_date><![CDATA[" ).append( currDate ).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_user><![CDATA[" ).append( chgUser ).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_term><![CDATA[" ).append( chgTerm ).append( "]]></chg_term>\r\n" );
					valueXmlString.append("</Detail1>\r\n");
				}

			} //Case 1. End
			break;

			case 2:
			{
				System.out.println("<<------------------- Inside case2 itemChanged Physical count -------------------->>");	// remove
				valueXmlString.append( "<Detail2>\r\n" );

				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					valueXmlString.append( "<site_code><![CDATA[" ).append( loginSite ).append( "]]></site_code>\r\n" );
				}
				else if( currentColumn.trim().equalsIgnoreCase( "loc_code" ) )
				{
					locCode = checkNullAndTrim(genericUtility.getColumnValue("loc_code",currFormDataDom));
					System.out.println("locCode ==========>> ["+locCode+"]");	// remove
					if(locCode.length()  > 0)
					{
						locDescr = checkNullAndTrim(getColumnDescr(conn, "descr", "location", "loc_code", locCode));												
						valueXmlString.append( "<location_descr><![CDATA[" ).append( locDescr ).append( "]]></location_descr>\r\n" );
					}
					else
					{												
						valueXmlString.append( "<location_descr><![CDATA[" ).append( "" ).append( "]]></location_descr>\r\n" );
					}
				}
				else if( currentColumn.trim().equalsIgnoreCase( "item_code" ) )
				{
					itemCode = checkNullAndTrim(genericUtility.getColumnValue("item_code",currFormDataDom));
					System.out.println("itemCode ==========>> ["+itemCode+"]");	// remove
					if(itemCode.length()  > 0)
					{
						itemDescr = checkNullAndTrim(getColumnDescr(conn, "descr", "item", "item_code", itemCode));	
						unit = checkNullAndTrim(getColumnDescr(conn, "unit", "item", "item_code", itemCode));

						valueXmlString.append( "<item_descr><![CDATA[" ).append( itemDescr ).append( "]]></item_descr>\r\n" );
						valueXmlString.append( "<unit><![CDATA[" ).append( unit ).append( "]]></unit>\r\n" );
					}
					else
					{												
						valueXmlString.append( "<item_descr><![CDATA[" ).append( "" ).append( "]]></item_descr>\r\n" );
						valueXmlString.append( "<unit><![CDATA[" ).append( "" ).append( "]]></unit>\r\n" );
					}
				}

				//Changed by Jagruti Shinde request Id:[W16CSUN010][Start]
				else if( currentColumn.trim().equalsIgnoreCase( "lot_sl" ) )
				{
					lotSl = checkNullAndTrim(genericUtility.getColumnValue("lot_sl",currFormDataDom));
					lotNo = checkNullAndTrim(genericUtility.getColumnValue("lot_no",currFormDataDom));
					itemCode = checkNullAndTrim(genericUtility.getColumnValue("item_code",currFormDataDom));
					locCode = checkNullAndTrim(genericUtility.getColumnValue("loc_code",currFormDataDom));
					loginSite = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));

					sql = "SELECT QUANTITY FROM STOCK WHERE SITE_CODE = ? AND INV_STAT = ? AND LOC_CODE = ? AND ITEM_CODE = ? AND LOT_NO = ? AND LOT_SL = ? AND QUANTITY > 0";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, loginSite);
					pstmt.setString(2, "AWMS");
					pstmt.setString(3, locCode);
					pstmt.setString(4, itemCode);
					pstmt.setString(5, lotNo);
					pstmt.setString(6, lotSl);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						quantity = rs.getDouble("QUANTITY");
						System.out.println("quantityStock>>>>>>>" +quantity);
						System.out.println( "LOT_SL itemChanged");
					}
					if(pstmt != null)
					{ 
						pstmt.close(); 
						pstmt = null;
					}
					if(rs != null)
					{ 
						rs.close(); 
						rs = null; 
					}
				}
				valueXmlString.append( "<quantity><![CDATA[" ).append( quantity ).append( "]]></quantity>\r\n" );
				//Changed by Jagruti Shinde request Id:[W16CSUN010][End]

				valueXmlString.append("</Detail2>\r\n");

			} //Case 2. End
			break;
			}//End of switch block
			valueXmlString.append( "</Root>\r\n" );	 
		}
		catch (Exception e)
		{				
			e.printStackTrace();			

		}
		finally
		{	
			try
			{				
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println( "valueXmlString.toString()>>>>>>>::"+valueXmlString.toString());
		return valueXmlString.toString();
	}

	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}

	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}

	private String getColumnDescr(Connection conn, String columnName ,String tableName, String columnName2, String value) throws Exception
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";
		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{					
				findValue = rs.getString(1);
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}        
		}
		catch(Exception e)
		{
			System.out.println("Exception in getColumnDescr ");
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("returning String from getColumnDescr " + findValue);
		return findValue;
	}

	private int getLocationCount(String locCode, Connection conn) throws Exception
	{	
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		int count = 0;
		try
		{	
			sql = "SELECT COUNT(1) FROM LOCATION WHERE INV_STAT = ? AND LOC_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "AWMS");
			pstmt.setString(2, locCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);		
			}
			if(pstmt != null)
			{ 
				pstmt.close(); 
				pstmt = null;
			}
			if(rs != null)
			{ 
				rs.close(); 
				rs = null; 
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getLocationCount ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("return value from getLocationCount :::::::::: " + count);
		return count;
	}

	private int getItemCodeCount(String siteCode, String locCode, String itemCode, Connection conn) throws Exception
	{	
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		int count = 0;
		try
		{	
			sql = "SELECT COUNT(1) FROM STOCK WHERE SITE_CODE = ? AND INV_STAT = ? AND LOC_CODE = ? AND ITEM_CODE = ? AND QUANTITY > 0";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, "AWMS");
			pstmt.setString(3, locCode);
			pstmt.setString(4, itemCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);		
			}
			if(pstmt != null)
			{ 
				pstmt.close(); 
				pstmt = null;
			}
			if(rs != null)
			{ 
				rs.close(); 
				rs = null; 
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getItemCodeCount ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("return value from getItemCodeCount :::::::::: " + count);
		return count;
	}

	private int getLotNoCount(String siteCode, String locCode, String itemCode, String lotNo, Connection conn) throws Exception
	{	
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		int count = 0;
		try
		{	
			sql = "SELECT COUNT(1) FROM STOCK WHERE SITE_CODE = ? AND INV_STAT = ? AND LOC_CODE = ? AND ITEM_CODE = ? AND LOT_NO = ? AND QUANTITY > 0";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, "AWMS");
			pstmt.setString(3, locCode);
			pstmt.setString(4, itemCode);
			pstmt.setString(5, lotNo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);		
			}
			if(pstmt != null)
			{ 
				pstmt.close(); 
				pstmt = null;
			}
			if(rs != null)
			{ 
				rs.close(); 
				rs = null; 
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getLotNoCount ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("return value from getLotNoCount :::::::::: " + count);
		return count;
	}

	private int getLotSlCount(String siteCode, String locCode, String itemCode, String lotNo, String lotSl, Connection conn) throws Exception
	{	
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		int count = 0;
		try
		{	
			sql = "SELECT COUNT(1) FROM STOCK WHERE SITE_CODE = ? AND INV_STAT = ? AND LOC_CODE = ? AND ITEM_CODE = ? AND LOT_NO = ? AND LOT_SL = ? AND QUANTITY > 0";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, "AWMS");
			pstmt.setString(3, locCode);
			pstmt.setString(4, itemCode);
			pstmt.setString(5, lotNo);
			pstmt.setString(6, lotSl);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);		
			}
			if(pstmt != null)
			{ 
				pstmt.close(); 
				pstmt = null;
			}
			if(rs != null)
			{ 
				rs.close(); 
				rs = null; 
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getLotSlCount ::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("return value from getLotSlCount :::::::::: " + count);
		return count;
	}

}

