------------------------------------------------------------ADD COLUMN-------------------------------------------

ALTER TABLE PALLET_REQ_DET
ADD 
(ITEM_CODE     CHAR(10),   
LOT_NO             CHAR(15),     
LOT_SL             CHAR(15) ,    
QUANTITY           NUMBER(14,3), 
NO_ART             NUMBER(6)    
);

ALTER TABLE PALLET_REQ_DET ADD ( CONSTRAINT FK_PALLET_REQ_DET_ITEM_CODE FOREIGN KEY
( ITEM_CODE ) REFERENCES ITEM ) ;

---------------------------------------------------------system entry-------------------------------------------------------------------------------------
INSERT INTO TRANSETUP (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,CONFIRM_COL,CONFIRM_VAL,LEDG_POST_CONF,CHG_DATE_ON_CONF,TRAN_ID_COL,MAIL_OPTION,CONFIRM_MODE,TABLE_NAME,APPLICATION,REF_SER,VIEW_MODE,CHILDDATA_ARGOPT,AUDIT_TRAIL_OPT,PERIOD_OPTION) 
VALUES ('w_pallet_req_stk','2','2','A','PRS,seq07',SYSDATE,'BASE','BASE','0','confirmed','Y','N','N','TRAN_ID','0','0','pallet_req_hdr','WMS','PRS','F','2','0','M');

INSERT INTO OBJ_FORMS (WIN_NAME,TITLE,OBJ_BROW_NAME,FORM_NO) 
VALUES ('w_pallet_req_stk','Header','d_pallet_req_stk','1');

INSERT INTO OBJ_FORMS (WIN_NAME,TITLE,OBJ_BROW_NAME,FORM_NO)
VALUES ('w_pallet_req_stk','Detail','d_pallet_req_stk','2');

Insert into OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER)
VALUES ('pallet_req_stk',1,'add.gif','Adding new','a','a','A','Add','1','S',sysdate,'BASE','BASE');

INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER) 
VALUES ('pallet_req_stk',2,'edit.gif','Editing Existing Record','a','a','E','Edit','1','S',SYSDATE,'BASE','BASE');

INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER)
VALUES ('pallet_req_stk',3,'delete.gif','Delete  Property','a','a','D','Delete','1','S',sysdate,'BASE','BASE');

INSERT INTO ITM2MENU (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,MENU_PATH,ICON_PATH,CHG_DATE,CHG_TERM,CHG_USER) 
VALUES ('WMS',4,4,0,0,0,'w_pallet_req_stk','Pallet Request Stock Details','AWMS.4.4.0.0.0','e12_logo.gif',sysdate,'BASE','BASE');

-------------------------------------------------------------validation-----------------------------------------------------------------------------
INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES ('pallet_req_stk','pre_validate','1','prv_pallet_req','0',SYSDATE,'BASE','BASE','2','EJB','PalletReqIC');

----------------------------------------------------------------item change---------------------------------------------------------------------------
INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME) 
VALUES ('pallet_req_stk','post_item_change','1','poic_pallet_req','0',SYSDATE,'BASE','BASE','2','EJB','PalletReqIC');

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) 
values ('pallet_req_stk','1  ','itm_default','Y');

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) 
values ('pallet_req_stk','1  ','loc_code','Y');

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) 
values ('pallet_req_stk','1  ','site_code','Y');

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY)
VALUES ('pallet_req_stk','2  ','itm_default','Y');

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) 
values ('pallet_req_stk','2','loc_code','Y');

----------------------------------------------------------confirm-----------------------------------------------------------------------------
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER) 
VALUES ('pallet_req_stk',4,'Confirm','pre_Pallet_conf','N','C','Confirm','1','2','U',SYSDATE,'BASE','Base');

INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES ('pallet_req_stk','pre_Pallet_conf','1','Pallet_confirm','0',SYSDATE,'Base','BASE','2','EJB','PalletReqConf');

------------------------------------------------------------Expire -----------------------------------------------------------------------------
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,ACTION_TYPE)
VALUES ('pallet_req_stk',5,'Expire','pallet_exp','a','R','Expire','2','4','U');

INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES ('pallet_req_stk','pallet_exp','1','Pallet_expire','0',SYSDATE,'Base','BASE','2','EJB','PalletReqExpiryAct');

-----------------------------------------------------------Near Expire-----------------------------------------------------------------------------
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,ACTION_TYPE)
VALUES ('pallet_req_stk',6,'Near To Expire','pre_pallet_exl','a','R','NearExpire','2','4','U');

INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES ('pallet_req_stk','pre_pallet_exl','1','Pallet_explist','0',SYSDATE,'Base','BASE','2','EJB','PalletReqExpiryAct');

-------------------------------------------------------default button------------------------------------------------------
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,ACTION_TYPE)
VALUES ('pallet_req_stk',7,'Default','pre_pallet_def','a','R','Default','2','4','U');

INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES ('pallet_req_stk','pre_pallet_def','1','Pallet_default','0',SYSDATE,'Base','BASE','2','EJB','PalletReqExpiryAct');

INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('Pallet_default','Action To Set pallet details','http://localhost:8080/axis/services/ActionHandlerService','Base Information','actionHandler','String','S',sysdate,'Base','Base');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
VALUES ('Pallet_default',1,'COMPONENT_TYPE','I','Component Type','C.String',SYSDATE,'BASE','BASE','EJB');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
VALUES ('Pallet_default',2,'COMPONENT_NAME','I','Component Name','C.String',SYSDATE,'BASE','BASE','PalletReqExpiryAct');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
VALUES ('Pallet_default',3,'ACTION_TYPE','I','Action Type','C.String',SYSDATE,'BASE','BASE','DEFAULT');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('Pallet_default',4,'XML_DATA','I','XML data for Current form','S',SYSDATE,'BASE','BASE ');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('Pallet_default',5,'XML_DATA_1','I','XML data of form no 1','S',SYSDATE,'BASE','BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('Pallet_default',6,'OBJ_CONTEXT','I','Object context','S',SYSDATE,'BASE','BASE ');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('Pallet_default',7,'XTRA_PARAMS','I','Extra Arguments','S',sysdate,'BASE','BASE');
-------------------------------------------------------------messages-------------------------------------------------------------------------

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMITEMCNUL','Invalid Item Code','Item code cannot be blank. Please enter Item Code','E','Y',SYSDATE,'base','base');


INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMLOTSLNUL','Invalid Lot SL',' Lot SL cannot be blank. Please enter Lot SL','E','Y',SYSDATE,'base','base');


INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMLOTNONUL','Invalid Lot Number','Lot Number cannot be blank. Please enter Lot Number','E','Y',SYSDATE,'base','base');


INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMNOARTNUL','Invalid Number of Article','Number of Article cannot be blank. Please enter Number of Article','E','Y',SYSDATE,'base','base');


INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMQUANTNUL','Invalid Quantity','Quantity cannot be blank. Please enter Quantity','E','Y',SYSDATE,'base','base');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('VMITEMCEXT','Invalid Item Code','Entered Item Code should present in stock table','E','Y',sysdate,'base','base');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('VMLOTSLEXT','Invalid Lot SL','Entered Lot SL should present in stock table','E','Y',sysdate,'base','base');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('VMLOTNOEXT','Invalid Lot Number','Entered Lot Number should present in stock table','E','Y',sysdate,'base','base');

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,chg_date,chg_user,chg_term) 
VALUES ('VMNOARTEXT','Invalid Number of Article','Entered Number of Article should present in stock','E','Y',sysdate,'base','base');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
values ('VMQUANTEXT','Invalid Quantity','Entered Quantity should present in stock','E','Y',sysdate,'base','base');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('VMPALDETEX','Invalid Pallet Details','Entered Pallet Details already added in this transaction.','E','Y',SYSDATE,'base','base');

---------------------------------------------------------UPDATE SYSTEM_SERVICE_ARGS------------------------------------------------------------------------

UPDATE SYSTEM_SERVICE_ARGS SET  ARG_NAME='XML_DATA_ALL' 
where SERVICE_CODE='poic_pallet_req' and line_no='5';
-----------------------------------------------------------POPHELP--------------------------------------------------------------------


INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,
CHG_TERM,DIST_OPT,SQL_INPUT,HELP_OPTION) 
VALUES ('PALLET_NO','W_PALLET_REQ_STK','SELECT DISTINCT L.LOC_CODE
AS PALLET_NO ,L.DESCR FROM STOCK S ,LOCATION L WHERE L.INV_STAT=''AWMS'' AND 
L.SITE_CODE=''?'' AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0'
,'User-defined Type',0,0,SYSDATE,'BASE','BASE','0',':site_code',
'0');


INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,
CHG_TERM,DIST_OPT,SQL_INPUT,HELP_OPTION) 
VALUES ('ITEM_CODE','W_PALLET_REQ_STK','SELECT DISTINCT S.ITEM_CODE FROM STOCK S ,LOCATION L WHERE L.INV_STAT=''AWMS'' AND S.LOC_CODE=''?'' AND L.SITE_CODE=''?'' AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0
'
,'User-defined Type',0,0,SYSDATE,'BASE','BASE','0',':pallet_no,:site_code',
'0');


INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,
CHG_TERM,DIST_OPT,SQL_INPUT,HELP_OPTION) 
VALUES ('LOT_NO','W_PALLET_REQ_STK','SELECT DISTINCT S.LOT_NO FROM STOCK S ,LOCATION L WHERE L.INV_STAT=''AWMS'' AND S.LOC_CODE=''?'' AND L.SITE_CODE=''?'' AND S.ITEM_CODE=''?'' AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0
'
,'User-defined Type',0,0,SYSDATE,'BASE','BASE','0',':pallet_no,:site_code,:item_code',
'0');

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,
CHG_TERM,DIST_OPT,SQL_INPUT,HELP_OPTION) 
VALUES ('LOT_SL','W_PALLET_REQ_STK','SELECT DISTINCT S.LOT_SL FROM STOCK S ,LOCATION L WHERE L.INV_STAT=''AWMS'' AND S.LOC_CODE=''?'' AND L.SITE_CODE=''?'' AND S.ITEM_CODE=''?'' AND S.LOT_NO=''?'' AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0
'
,'User-defined Type',0,0,SYSDATE,'BASE','BASE','0',':pallet_no,:site_code,:item_code,:lot_no',
'0');

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,
CHG_TERM,DIST_OPT,SQL_INPUT,HELP_OPTION) 
VALUES ('NO_ART','W_PALLET_REQ_STK','SELECT DISTINCT S.NO_ART FROM STOCK S ,LOCATION L WHERE L.INV_STAT=''AWMS'' AND S.LOC_CODE=''?'' AND L.SITE_CODE=''?'' AND S.ITEM_CODE=''?'' AND S.LOT_NO=''?'' AND S.LOT_SL=''?'' AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0
'
,'User-defined Type',0,0,SYSDATE,'BASE','BASE','0',':pallet_no,:site_code,:item_code,:lot_no,:lot_sl',
'0');

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,
CHG_TERM,DIST_OPT,SQL_INPUT,HELP_OPTION) 
VALUES ('QUANTITY','W_PALLET_REQ_STK','SELECT DISTINCT S.QUANTITY FROM STOCK S ,LOCATION L WHERE L.INV_STAT=''AWMS'' AND S.LOC_CODE=''?'' AND L.SITE_CODE=''?'' AND S.ITEM_CODE=''?'' AND S.LOT_NO=''?'' AND S.LOT_SL=''?'' AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0
'
,'User-defined Type',0,0,SYSDATE,'BASE','BASE','0',':pallet_no,:site_code,:item_code,:lot_no,:lot_sl',
'0');
------------------------------------------------OBJ_ITEMCHANGE-------------------------------------------------------------------------------------------
insert into obj_itemchange (obj_name,form_no,field_name,mandatory) 
values ('pallet_req_stk','2','lot_sl','Y');

insert into obj_itemchange (obj_name,form_no,field_name,mandatory) 
values ('pallet_req_stk','2','quantity','Y');

-----------------------------------------------------pophelp for location code------------------------------------------------------------

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER
,CHG_TERM,DIST_OPT,SQL_INPUT,HELP_OPTION) 
VALUES ('LOC_CODE','W_PALLET_REQ_STK','SELECT LOC_CODE,DESCR FROM LOCATION WHERE INV_STAT!=''AWMS'' AND SITE_CODE=''?''',
'User-defined Type',0,0,sysdate,'BASE','BASE','0',':site_code',
'0');


-----------------------------------------------------------update messages-------------------------------------------------------------------
UPDATE MESSAGES SET MSG_DESCR='Entered Lot Number should be for respective pallet number and item code' WHERE MSG_NO='VMLOTNOEXT';

update messages set msg_descr='Entered Lot Serial Number should be for respective pallet number and item code' where msg_no='VMLOTSLEXT';

update messages set msg_descr='Entered Item Code should be for respective pallet number ' where msg_no='VMITEMCEXT';
-------------------------------------------------------OBJ_ITEMCHANGE------------------------------------------------------

insert into obj_itemchange (obj_name,form_no,field_name,mandatory) 
values ('pallet_req_stk','2','no_art','Y');


-------------------------------------------------------------23/11/2015--------------------------------------------------------------------

insert into obj_itemchange (obj_name,form_no,field_name,mandatory) 
values ('pallet_req_stk','2','pallet_no','Y');

insert into obj_itemchange (obj_name,form_no,field_name,mandatory) 
values ('pallet_req_stk','2','item_code','Y');

insert into obj_itemchange (obj_name,form_no,field_name,mandatory) 
values ('pallet_req_stk','2','lot_no','Y');

---------------------------------------changes as per client requirment---30/11/2015-----------------------------------------
update messages set msg_descr='Entered Lot SL should be for respective pallet number and item code' 
where msg_no='VMLOTSLEXT';
----------------------------------------------------changes as per client requirment 1/12/2015--------------------------------------------

update obj_actions set  title='Stock' where obj_name='pallet_req_stk' and description='Default';


---------------------------------------------------------------4/12/2015---------------------------------------------------------------

DELETE from pophelp where mod_name='W_PALLET_REQ_STK' and field_name='PALLET_NO';
DELETE  from pophelp where mod_name='W_PALLET_REQ_STK' and field_name='ITEM_CODE';
DELETE  from pophelp where mod_name='W_PALLET_REQ_STK' and field_name='LOT_SL';
DELETE from pophelp where mod_name='W_PALLET_REQ_STK' AND field_name='LOT_NO';
delete from pophelp where field_name='NO_ART' and mod_name='W_PALLET_REQ_STK';
DELETE from pophelp where mod_name='W_PALLET_REQ_STK' AND field_name='QUANTITY';

insert into pophelp (field_name,mod_name,sql_str,msg_title,width,height,
chg_date,chg_user,chg_term,dist_opt,sql_input,help_option) 
values ('PALLET_NO','W_PALLET_REQ_STK','select distinct s.loc_code as pallet_no  from stock s where 
S.INV_STAT IN (''AWMS'') AND S.SITE_CODE=''?'' AND S.QUANTITY > 0
union all
select distinct substr(s.loc_code,1,instr(s.loc_code,''Q'')-1)  from stock s where
S.INV_STAT IN (''AWMSQ'') AND S.SITE_CODE=''?'' AND S.QUANTITY > 0'
,'User-defined Type',0,0,sysdate,'BASE','BASE','0',
':site_code,:site_code','0');

insert into pophelp (field_name,mod_name,sql_str,msg_title,width,height,
chg_date,chg_user,chg_term,dist_opt,sql_input,help_option) 
values ('ITEM_CODE','W_PALLET_REQ_STK','SELECT DISTINCT S.ITEM_CODE FROM STOCK S 
WHERE  S.LOC_CODE like trim(''?'')||''%'' AND S.SITE_CODE=''?'' 
AND S.QUANTITY>0','User-defined Type'
,0,0,sysdate,'BASE','BASE','0',
':pallet_no,:site_code','0');


insert into pophelp (field_name,mod_name,sql_str,msg_title,width,height,chg_date,
chg_user,chg_term,dist_opt,sql_input,HELP_OPTION)
values ('LOT_SL','W_PALLET_REQ_STK','SELECT DISTINCT S.LOT_SL FROM STOCK S 
WHERE  S.LOC_CODE like trim(''?'')||''%'' AND S.SITE_CODE=''?'' 
AND S.ITEM_CODE=''?'' AND S.LOT_NO=''?''
AND S.QUANTITY>0','User-defined Type',0,0,SYSDATE,'BASE','BASE','0',
':pallet_no,:site_code,:item_code,:lot_no','0');

insert into pophelp (field_name,mod_name,sql_str,msg_title,width,height,
chg_date,chg_user,chg_term,dist_opt,sql_input,help_option) 
values ('LOT_NO','W_PALLET_REQ_STK','SELECT DISTINCT S.LOT_NO FROM STOCK S 
WHERE  S.LOC_CODE like trim(''?'')||''%'' AND S.SITE_CODE=''?'' 
AND S.ITEM_CODE=''?'' AND S.QUANTITY>0',
'User-defined Type',0,0,sysdate,'BASE','BASE','0'
,':pallet_no,:site_code,:item_code','0');

insert into pophelp (field_name,mod_name,sql_str,msg_title,width,height,chg_date,chg_user,
chg_term,dist_opt,sql_input,help_option) 
values ('NO_ART','W_PALLET_REQ_STK','SELECT DISTINCT S.NO_ART FROM STOCK S  WHERE 
 S.LOC_CODE like trim(''?'')||''%'' AND S.SITE_CODE=''?'' AND S.ITEM_CODE=''?'' AND S.LOT_NO=''?'' 
 AND S.LOT_SL=''?'' 
 AND S.QUANTITY>0','User-defined Type',0,0,SYSDATE,'BASE','BASE','0',
 ':pallet_no,:site_code,:item_code,:lot_no,:lot_sl','0');

------------------------------------8/12/2015--------------------------------------

DELETE from pophelp where mod_name='W_PALLET_REQ_STK' AND field_name='LOC_CODE';

 insert into pophelp (field_name,mod_name,sql_str,msg_title,width,height,
chg_date,chg_user,chg_term,dist_opt,sql_input,HELP_OPTION)
values ('LOC_CODE','W_PALLET_REQ_STK','SELECT LOC_CODE,DESCR FROM LOCATION WHERE INV_STAT NOT IN 
(''AWMS'',''AWMSQ'') AND SITE_CODE=''?''','User-defined Type',0,0,
SYSDATE,'BASE','BASE','0',':site_code','0');


--------------------------------------------As per client requirment 15/12/2015--------------------------------------------------
-------------------------------------------------FUNCTION----------------------------------------------------------------
   CREATE OR REPLACE FUNCTION FN_CHK_PRS 
(as_loccode  in char) 
return number is 
ll_retval number(1) := 0;
 
begin 
 
	begin
	 select count(1) into ll_retval from swms_to_awms a
	 where A.IN_OUT= 'O' AND a.schedule_status = 'N'
	 and a.pallet_no = as_loccode;
	 exception when others then
	   ll_retval := 0;
	end;
	if ll_retval = 0 then
		begin
		 select count(1) into ll_retval from pallet_req_hdr h, pallet_req_det d
		 where h.tran_id = d.tran_id
		 and h.confirmed = 'N'
		 and d.pallet_no = as_loccode;
		 exception when others then
		   ll_retval := 0;
		end;

	end if;
 
 return (ll_retval); 
end; 
/
   
   create synonym USER.fn_chk_prs for fn_chk_prs;
grant execute on FN_CHK_PRS to USER;

--------------------------------------------------MESSAGES----------------------------------------------------------------------

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,chg_date,chg_user,chg_term) 
values ('VMPALDEPEX','Invalid Pallet Details',
'Entered Pallet Details already added in previous transaction.','E','Y',sysdate,'base','base');

DELETE from pophelp where mod_name='W_PALLET_REQ_STK' and field_name='PALLET_NO';
commit;

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,
chg_term,dist_opt,sql_input,help_option) 
values ('PALLET_NO','W_PALLET_REQ_STK','select distinct s.loc_code as pallet_no  from stock s where 
S.INV_STAT IN (''AWMS'') AND S.SITE_CODE=''?'' AND S.QUANTITY > 0 and FN_CHK_PRS(TRIM(S.LOC_CODE)) = 0
union all
select distinct substr(s.loc_code,1,instr(s.loc_code,''Q'')-1)  from stock s where
s.inv_stat in (''AWMSQ'') and s.site_code=''?'' and s.quantity > 0 
and FN_CHK_PRS(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,''Q'')-1)) = 0'
,'User-defined Type',0,0,sysdate,'BASE','BASE','0',':site_code,:site_code',
'0');



--------------------------------------------------------16/12/2015------------------------------------------------------------------
delete from pophelp where mod_name='W_PALLET_REQ_STK' AND field_name='PALLET_NO';
commit;

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,
chg_term,dist_opt,sql_input,help_option) 
values ('PALLET_NO','W_PALLET_REQ_STK','select distinct s.loc_code as pallet_no  from stock s where 
S.INV_STAT IN (''AWMS'') AND S.SITE_CODE=''?'' AND S.QUANTITY > 0 and FN_CHK_PRS(TRIM(S.LOC_CODE),'''') = 0
union all
select distinct substr(s.loc_code,1,instr(s.loc_code,''Q'')-1)  from stock s where
s.inv_stat in (''AWMSQ'') and s.site_code=''?'' and s.quantity > 0 
and FN_CHK_PRS(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,''Q'')-1),'''') = 0'
,'User-defined Type',0,0,sysdate,'BASE','BASE','0',':site_code,:site_code',
'0');

----------------------------------function-----------------------------------------------------
   create or replace function fn_chk_prs 
(as_loccode  location.loc_code%type,as_tranid in pallet_req_hdr.tran_id%type) 
return number is 
ll_retval number(1) := 0;
ls_tranid pallet_req_hdr.tran_id%type := 0;
 
begin 

ls_tranid := as_tranid;
 if ls_tranid is null or ls_tranid = 'null' then 
    ls_tranid := '@@@@@@@@@@';
 end if;
 
	begin
	 select count(1) into ll_retval from swms_to_awms a
	 where A.IN_OUT= 'O' AND a.schedule_status = 'N'
	 and a.pallet_no = as_loccode;
	 exception when others then
	   ll_retval := 0;
	end;
	if ll_retval = 0 then
		begin
		 select count(1) into ll_retval from pallet_req_hdr h, pallet_req_det d
		 where h.tran_id = d.tran_id
		 and h.confirmed = 'N'
		 and d.pallet_no = as_loccode
     and h.tran_id <> ls_tranid;
		 exception when others then
		   ll_retval := 0;
		end;

	end if;
 
 return (ll_retval); 
end; 
/

-------------------------------------------------------------------END----------------------------------------------------------------------------


