/**
 *  Purpose:Entry screen for net_printers Master table, Request ID: D15DKAT008  
 *  Author: Jagruti Shinde
 *  Date: 11-08-2015
 */

package ibase.webitm.ejb.wms;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.ArrayList;


@Stateless
public class NetPrintersIC extends ValidatorEJB implements NetPrintersICLocal, NetPrintersICRemote
{

	E12GenericUtility genericUtility = new E12GenericUtility();	

	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = null;
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("Val xmlString :: " + xmlString);
			System.out.println("Val xmlString1 :: " + xmlString1);
			System.out.println("Val xmlString2 :: " + xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException( e );
		}
		return (errString);
	}

     public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("wfValData.....called..");
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0,currentFormNo =0,childNodeListLength =0;
	    String userId="";
		String childNodeName = null,childNodeValue = null;
		String errString = "";
		String printerName = "", printerDescr = "", serverUri = "", osName = "";
		int count = 0;
		int cnt = 0;
		String sql = "" ;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]

			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
				case 1 :
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{	
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						System.out.println("Netprinters_codechildNodeName.editFlag." + childNodeName+".." + editFlag);
						
						if(childNodeName.equalsIgnoreCase("printer_name"))
						{
							printerName = checkNull(genericUtility.getColumnValue("printer_name",dom));
							
							if (printerName.length() == 0)
							{
								errString = getErrorString("printer_name","VMPRINTNUL",userId);
								break ;
							}
							else 
							{
								if(!"E".equalsIgnoreCase(editFlag))
								{	
									sql = "SELECT COUNT(*) AS COUNT FROM NET_PRINTERS WHERE PRINTER_NAME = ?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,printerName);
									rs = pstmt.executeQuery();
									if( rs.next() )
									{
										count = rs.getInt("COUNT");
									}
										
									if(count != 0 )
									{	 
										errString = getErrorString("printer_name","VTEXIST",userId);
										return errString;
									}
									else
									{	
										 if(isSpecialCharFound(printerName))
										 {
								        	errString = getErrorString("printer_name","VTSPCHARNO",userId);
											return errString;
										        	
										 }
									} 
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;									 
									}
									if(rs != null)
									{
										rs.close();
										rs = null;
									}
								}	
							}
						}
						else if(childNodeName.equalsIgnoreCase("printer_descr") )
						{
							printerDescr = checkNull(genericUtility.getColumnValue("printer_descr",dom));
					
							if (printerDescr.length() == 0 )
							{
								errString = getErrorString("printer_descr","VMPRIDRNUL",userId);
								break ;
							}
							
						}
						else if(childNodeName.equalsIgnoreCase("server_uri") )
						{
							serverUri= checkNull(genericUtility.getColumnValue("server_uri",dom));
							
							if (serverUri.length() == 0)
							{
								errString = getErrorString("server_uri","VMPRISRNUL",userId);
								break ;
							}
						}
						else if(childNodeName.equalsIgnoreCase("os_name") )
						{
							osName= checkNull(genericUtility.getColumnValue("os_name",dom));
							
							if (osName.length() == 0)
							{
								errString = getErrorString("os_name","VMPRIOSNUL",userId);
								break ;
							}
						}
					}
							
			break;
			}//END SWITCH
		}//END TRY
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
			errString=e.getMessage();
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		System.out.println("ErrString ::"+errString);
		return errString;
	}
	private String checkNull( String input )
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}	
	public static boolean isSpecialCharFound(String inputString)
	{ 
	    String inputChar = "!@#$%^&*]}]{><?"; 
	    String inputStr=inputString;
	    for(int i=0;i<inputChar.length();i++)
	    {
	        if(inputStr.indexOf(inputChar.charAt(i))>=0)
	        {
	            return true;           
	        }
	    }
	    return false;
	}
}
