package ibase.dashboard.sfa.servlet;

import ibase.dashboard.sfa.ejb.ComplianceDB2Remote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;

public class ComplMTDSummaryServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;

    public ComplMTDSummaryServlet() {
    }

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doPost(request, response);
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		System.out.println("In ComplMTDSummaryServlet");
		ComplianceDB2Remote complMtdDtlSummary = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String loginEmpCode ="";
		String month = "";
		String year = "";
		String date = "";
		String salePersons = "";
		try
		{
			response.setContentType("application/xml");
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) request.getSession().getAttribute("USER_INFO");
			if(userInfo != null)
			{
				loginEmpCode = userInfo.getEmpCode();
			}
			dataSourceName = request.getParameter("dataSourceName");
			salePersons = request.getParameter("salePersons");
			String []inputDateArray = date.split("-");
			if(inputDateArray.length>1)
			{
				month = inputDateArray[1];
				year = inputDateArray[2];
			}
			System.out.println("ComplMTDSummaryServlet = >> loginEmpCode :: "+loginEmpCode);
			System.out.println("ComplMTDSummaryServlet = >> salePersons :: "+salePersons);
			context = new InitialContext(appConnectParm.getProperty());
			complMtdDtlSummary = (ComplianceDB2Remote) context.lookup("ibase/ComplianceDB2/remote");
			JSONObject jsonObjData = (JSONObject) complMtdDtlSummary.getComplMTDSummary(dataSourceName, "", "", salePersons, loginEmpCode);
			OutputStream outputStream   = response.getOutputStream();
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("Final data set for ComplMTDSummaryServlet build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : ComplMTDSummaryServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}
