package ibase.dashboard.mfg.ejb;

import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.ejb.Stateless;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.json.simple.JSONObject;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;

@Stateless
public class PendingQCWorkOrder extends ValidatorEJB implements PendingQCWorkOrderLocal, PendingQCWorkOrderRemote
{

	public PendingQCWorkOrder()
	{
		 // TODO Auto-generated constructor stub
	}
	E12GenericUtility e12GenericUtility = new E12GenericUtility();
	@SuppressWarnings("unchecked")
    public JSONObject getPendingQCWorkOrder(String geoLocation, String siteCode, String dataSourceName) throws RemoteException,ITMException 
	{
		
		System.out.println("In PendingQCOrder getPendingQCWorkOrder geoLocation :"+geoLocation+"----siteCode :"+siteCode+"---dataSourceName :"+dataSourceName);
		JSONObject rowDataPendingQCWorkOrder = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		DashboardUtility dashboardUtility = null;
		
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:17062016 by Nikhil*/
			conn = getConnection();
			int count = 0;
			
			dashboardUtility = new DashboardUtility();
			siteCode = dashboardUtility.getCommaSeparated(siteCode);
			geoLocation= dashboardUtility.getCommaSeparated(geoLocation);
			
			if(geoLocation.trim().length()>0 && geoLocation!=null && siteCode!=null && siteCode.trim().length()>0)
			{
				
				
				/*sql=    " SELECT no_of_days, ITEM_SER, NO_OF_OPEN_QCORDER, CHK_VAL, ROUND((PRODUCTION_VALUE)/100000,3) As PRODUCTION_VALUE " +
						" FROM ( SELECT z.NO_OF_DAYS AS NO_OF_DAYS,z.ITEM_SER AS ITEM_SER,SUM(z.NO_OF_OPEN_QCORDER) " +
						" AS NO_OF_OPEN_QCORDER, z.CHK_VAL AS CHK_VAL,sum(z.production_value) " +
						" as Production_Value FROM( SELECT ITEM.ITEM_SER, CASE " +
						" WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>=0 " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)<90 " +
						" THEN '>0-90 days' WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>=90 " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)<180 " +
						" THEN '>90-180 days' WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>=90 " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)<365 " +
						" THEN '>180-365 days' WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>365 THEN '>365 days' " +
						" WHEN TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')<> TO_CHAR(SYSDATE,'YYYY')  " +
						" THEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY') " +
						" END NO_OF_DAYS,COUNT(DISTINCT QC_ORDER.QORDER_NO) NO_OF_OPEN_QCORDER, " +
						" (CASE WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 0 " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)  < 90 THEN 1 " +
						" WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 90 " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)  < 180 " +
						" THEN 2 WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 180 " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)  < 365 THEN 3 " +
						" WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 365 THEN 4 " +
						" WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY') <> TO_CHAR (SYSDATE, 'YYYY') " +
						" THEN TO_NUMBER ( 4 + ABS ( TO_NUMBER (TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY' ) ) - TO_NUMBER (TO_CHAR (SYSDATE, 'YYYY')) ) ) ELSE 0 END) " +
						" AS CHK_VAL, sum(d.ACTUAL_PROD_VALUE) as production_value " +
						"FROM WORKORDER_RECEIPT,ITEM,qc_order,WORKORDER,dwh_production d,site e " +
						" WHERE (WORKORDER_RECEIPT.ITEM_CODE = ITEM.ITEM_CODE) " +
						" AND workorder_RECEIPT.site_code in("+siteCode+") " +
						" and workorder_receipt.site_code=e.site_code " +
						" and e.city in("+geoLocation+") " +
						" AND WORKORDER.WORK_ORDER=WORKORDER_RECEIPT.WORK_ORDER " +
						" AND WORKORDER_RECEIPT.CONFIRMED='Y' " +
						" AND workorder_receipt.lot_no=qc_order.lot_no " +
						" AND workorder_receipt.tran_id=qc_order.porcp_no " +
						" AND workorder_receipt.item_code=qc_order.item_code " +
						" AND QC_ORDER.STATUS='U' and d.work_order=workorder.work_order " +
						" GROUP BY  WORKORDER_RECEIPT.TRAN_DATE, ITEM.ITEM_SER " +
						" ORDER BY CHK_VAL,no_of_days,ITEM.ITEM_SER) z " +
						" GROUP BY z.no_of_days,z.ITEM_SER,z.CHK_VAL ORDER BY z.ITEM_SER) " +
						" ORDER BY CHK_VAL ASC ";*/
				
				sql = "SELECT no_of_days, ITEM_SER, NO_OF_OPEN_QCORDER, CHK_VAL,ROUND((PRODUCTION_VALUE)/100000,3) As PRODUCTION_VALUE " +
						"FROM ( SELECT z.NO_OF_DAYS AS NO_OF_DAYS,z.ITEM_SER AS ITEM_SER,SUM(z.NO_OF_OPEN_QCORDER) AS NO_OF_OPEN_QCORDER, " +
						"z.CHK_VAL AS CHK_VAL,sum(z.production_value) as Production_Value FROM( SELECT SITEITEM.ITEM_SER, " +
						"CASE WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>=0 AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)<90 " +
						"THEN '>0-90 days' WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>=90 AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)<180 " +
						"THEN '>90-180 days' WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>=90 AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)<365 " +
						"THEN '>180-365 days' WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>365 THEN '>365 days' " +
						"WHEN TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')<> TO_CHAR(SYSDATE,'YYYY')  " +
						"THEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY') END NO_OF_DAYS,COUNT(DISTINCT QC_ORDER.QORDER_NO) NO_OF_OPEN_QCORDER, " +
						"(CASE WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 0 " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)  < 90 " +
						"THEN 1 WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 90 AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)  < 180 " +
						"THEN 2 WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 180 " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)  < 365 THEN 3 " +
						"WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 365 THEN 4 " +
						"WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY') <> TO_CHAR (SYSDATE, 'YYYY') " +
						"THEN TO_NUMBER ( 4 + ABS ( TO_NUMBER (TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY' ) ) - TO_NUMBER (TO_CHAR (SYSDATE, 'YYYY')) ) ) ELSE 0 END) " +
						"AS CHK_VAL, sum(d.ACTUAL_PROD_VALUE) as production_value " +
						"FROM WORKORDER_RECEIPT,SITEITEM,qc_order,WORKORDER,dwh_production d," +
						"site e WHERE (WORKORDER_RECEIPT.ITEM_CODE = SITEITEM.ITEM_CODE) " +
						"AND workorder_RECEIPT.site_code in("+siteCode+") " +
						"and workorder_receipt.site_code=e.site_code " +
						"and e.city in("+geoLocation+") " +
						"AND WORKORDER.WORK_ORDER=WORKORDER_RECEIPT.WORK_ORDER AND WORKORDER_RECEIPT.CONFIRMED='Y' " +
						"AND workorder_receipt.lot_no=qc_order.lot_no AND workorder_receipt.tran_id=qc_order.porcp_no " +
						"AND workorder_receipt.item_code=qc_order.item_code AND QC_ORDER.STATUS='U' and d.work_order=workorder.work_order " +
						"AND SITEITEM.SITE_CODE=WORKORDER.SITE_CODE " + // Add below 3 condition on Date 14-10-2015 by Dhanendra
						"AND WORKORDER.ITEM_CODE=WORKORDER_RECEIPT.ITEM_CODE " +
						"AND WORKORDER.ITEM_CODE=D.ITEM_CODE " +
						" GROUP BY  WORKORDER_RECEIPT.TRAN_DATE, SITEITEM.ITEM_SER ORDER BY CHK_VAL,no_of_days,SITEITEM.ITEM_SER) z " +
						" GROUP BY z.no_of_days,z.ITEM_SER,z.CHK_VAL ORDER BY z.ITEM_SER) ORDER BY CHK_VAL ASC";
			    
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				String noOfOpenQCOrderVal="";
				String productionVal="";
				String noOfDay="",subType="";
				List<String> noOfDayList= new ArrayList<String>();
				List<String> subTypeList= new ArrayList<String>();
				String key="";
				LinkedHashMap<String, String> graphDataMap = new LinkedHashMap<String, String>(); 
		   		LinkedHashMap<String, String> sortedGraphDataMap = new LinkedHashMap<String, String>(); 
				while (rs.next())
				{
					noOfOpenQCOrderVal = rs.getString("NO_OF_OPEN_QCORDER");
					noOfDay = rs.getString("NO_OF_DAYS");
					subType= rs.getString("ITEM_SER");
					productionVal=rs.getString("PRODUCTION_VALUE");
					if(!noOfDayList.contains(noOfDay))
					{
						noOfDayList.add(noOfDay);
					}
					if(!subTypeList.contains(subType))
					{
						subTypeList.add(subType);
					}
					key = (noOfDay.trim()+"@"+subType.trim());
				        if(graphDataMap.size()==0)
				        {
				        	graphDataMap.put(key, (noOfOpenQCOrderVal+"-"+productionVal));
				        }
				        if(graphDataMap !=null && graphDataMap.size()>0)
				        {
				        	if(graphDataMap.containsKey(key))
				        	{
				        		//wipValue = wipValue +  graphDataMap.get(key);
				        		noOfOpenQCOrderVal = graphDataMap.get(key);
				        	}
				        	else  if(! graphDataMap.containsKey(key))
				        	{
				        		noOfOpenQCOrderVal = noOfOpenQCOrderVal+"-"+productionVal;
				        	}
				        	graphDataMap.put(key, noOfOpenQCOrderVal);
				        }
					
				}
			
			System.out.println("graphDataMap: "+graphDataMap);
			String sbType="";
			String grpKey="";
			for(int itmCtr=0;itmCtr<subTypeList.size();itmCtr++)
				{
					sbType = subTypeList.get(itmCtr);
					for (Map.Entry<String, String> grpentry : graphDataMap.entrySet())
					{
						for(int dayCtr=0;dayCtr<noOfDayList.size();dayCtr++)
						{
							grpKey = (noOfDayList.get(dayCtr).trim()+"@"+sbType.trim());
							if(graphDataMap.containsKey(grpKey))
							{
								sortedGraphDataMap.put(grpKey, graphDataMap.get(grpKey));
							}
							if(!graphDataMap.containsKey(grpKey) )
							{
								sortedGraphDataMap.put(grpKey, "0-0");
							}
						}
					}
				}
			System.out.println("sortedGraphDataMap: "+sortedGraphDataMap);
			
			
			rowData = new JSONObject();
			String noDays="",qcOrd="";
			String subType1="",prvsubType1="";
			LinkedHashMap<String, String> catValues = new LinkedHashMap<String, String>();
			LinkedHashMap<String, String> catGimValues = new LinkedHashMap<String, String>();
			int cnt=0;
			for (Map.Entry<String, String> entry : sortedGraphDataMap.entrySet())
				{
					cnt++;
					String mapKey     = entry.getKey();
					String value  = entry.getValue();// need to split
					String[] temp;
					temp = mapKey.split("@");
					noDays = temp[0].trim();
					subType1 = temp[1].trim();
					
					String[] qcOrdArr;
					qcOrdArr = value.split("-");
					qcOrd = qcOrdArr[0].trim();
					
					
					if( subType1 != null && ("").equals(prvsubType1) && subType1.trim().length()>0)
					{
						catValues.put(noDays,qcOrd);	
						catGimValues.put(noDays,value);	
						rowData.put("month",cnt);
						rowData.put("product_category",subType1);
						rowData.put("category_value",catValues);
						rowData.put("category_gimvalue",catGimValues);
						//rowData.put("pending_value", "100");
					}
					else if(!("").equals(prvsubType1) && prvsubType1.equals(subType1))
					{
						catValues.put(noDays,qcOrd);
						catGimValues.put(noDays,value);	
					}
					else if(!("").equals(prvsubType1) && ! prvsubType1.equals(subType1))
					{
						rowData.put("month",cnt);
						rowData.put("product_category",prvsubType1);
						rowData.put("category_value",catValues);
						rowData.put("category_gimvalue",catGimValues);
						
						rowDataPendingQCWorkOrder.put(count, rowData);
						count++;
						
						rowData = new JSONObject();
						catValues = new LinkedHashMap<String, String>();
						catGimValues = new LinkedHashMap<String, String>();
						catGimValues.put(noDays,value);	
						catValues.put(noDays,qcOrd);
					}
					if(cnt==sortedGraphDataMap.size())
					{
						rowData.put("month",++cnt);
						rowData.put("product_category",subType1);
						rowData.put("category_value",catValues);
						rowData.put("category_gimvalue",catGimValues);
						rowDataPendingQCWorkOrder.put(count, rowData);
					}
					prvsubType1=subType1;
				}
			}	
			System.out.println("rowDataPendingQCWorkOrder :"+rowDataPendingQCWorkOrder);

			
			/*Document document = new Document();
			String subtype = "";
			PdfWriter.getInstance(document,new FileOutputStream("/home/support-1/Desktop/HelloWorld-Table.pdf"));
			JSONObject fetchRowWiseValJsn = null;
            document.open();
            PdfPTable table = null; // 3 columns.
            PdfPCell cell1 = null;
            PdfPCell cell2 = null;
            PdfPCell cell3 = null;
           
            LinkedHashMap<String, String> catGimValues = null;
            DecimalFormat df = new DecimalFormat("#.###");
            List<String> valList = new ArrayList<String>();
            HashMap<Integer, String> totalMap = new HashMap<Integer, String>();
            for (int jsnCnt = 0; jsnCnt < rowDataPendingQCWorkOrder.size(); jsnCnt++)
            {
            	catGimValues = new LinkedHashMap<String, String>();
            	fetchRowWiseValJsn = new JSONObject();
            	fetchRowWiseValJsn = (JSONObject) rowDataPendingQCWorkOrder.get(jsnCnt);
            	subtype = ""+fetchRowWiseValJsn.get("product_category");
            	
            	System.out.println("subtype :"+subtype);
            	catGimValues = (LinkedHashMap<String, String>) fetchRowWiseValJsn.get("category_gimvalue");
            	System.out.println("catValuesTemp :"+catGimValues);
            	
            	count = 0;
            	
            	System.out.println("catValuesGim.size() :"+catGimValues.size());
            	if(jsnCnt == 0)
            	{
            		table = new PdfPTable(catGimValues.size()+1+catGimValues.size());
            		cell1 = new PdfPCell(new Paragraph("OPEN SINCE", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6, Font.BOLD, new Color(255,255,255))));
               		cell1.setBackgroundColor(Color.gray);
               		
                	table.addCell(cell1); 
                	for (Map.Entry<String, String> entry : catGimValues.entrySet()) 
    	            {
                		
                		cell2 = new PdfPCell(new Paragraph(entry.getKey(), FontFactory.getFont(FontFactory.TIMES_ROMAN, 6, Font.BOLD, new Color(255,255,255))));
                		cell2.setColspan(2);
                		cell2.setBackgroundColor(Color.gray);
    	            	cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
    	            	table.addCell(cell2);
    	            }
                	table.setWidthPercentage(100);
                	document.add(table);
                	
                	table = new PdfPTable(catGimValues.size()+1+catGimValues.size());
            		cell1 = new PdfPCell(new Paragraph("", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6, Font.BOLD, new Color(255,255,255))));
                	table.addCell(cell1); 
                	for (Map.Entry<String, String> entry : catGimValues.entrySet()) 
    	            {                		                               		
                		cell2 = new PdfPCell(new Paragraph("Open QC Order Count", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
                		cell3 = new PdfPCell(new Paragraph("Production Value In Lacs", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
                		
    	            	cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
    	            	cell3.setHorizontalAlignment(Element.ALIGN_CENTER);
    	            	table.addCell(cell2);
    	            	table.addCell(cell3);
    	            }
                	table.setWidthPercentage(100);
                	document.add(table);           	                	
            	}           	           	           	
            	table = new PdfPTable(catGimValues.size() * 2 + 1); 
            	cell1 = new PdfPCell(new Paragraph(subtype, FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
            	table.addCell(cell1); 
	            for (Map.Entry<String, String> entry : catGimValues.entrySet()) 
	            {	            		            	
	            		            		            		            		          	
	            	String val = entry.getValue();
	            	
	            	String[] temp;
	            	String noOfQC = "";
	            	String gimVal = "";
	            	double total= 0.0;
	            	temp = val.split("-");
	            	noOfQC = temp[0].trim();
	            	gimVal = temp[1].trim();
	            	total = Double.parseDouble(noOfQC)  + Double.parseDouble(gimVal);
	            	String totalStrVal =  "";
	            	System.out.println("noOfQC :"+noOfQC+"---- productionVal :"+gimVal);
	            	
	            	cell2 = new PdfPCell(new Paragraph(noOfQC, FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
	            	cell3 = new PdfPCell(new Paragraph(gimVal, FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
	            	cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
	            	cell3.setHorizontalAlignment(Element.ALIGN_CENTER);
	            	
	            	table.addCell(cell2);
	            	table.addCell(cell3);
	            	
	            	if(jsnCnt == 0)
					{
						totalStrVal = noOfQC+"@"+gimVal;
		            	totalMap.put(count, totalStrVal);
		            	count++;
		            	System.out.println("totalMap in if:"+totalMap);
					}
					else
					{
						totalStrVal =  totalMap.get(count);
		            	System.out.println("str in else :"+totalStrVal);
		            	String[] totalStrValArr;
		            	totalStrValArr = totalStrVal.split("@");
		            	
		            	String noOfQC1 = totalStrValArr[0].trim();
		            	String gimVal1 = totalStrValArr[1].trim();
		            	
		            	int noOfQCTotal = Integer.parseInt(noOfQC) + Integer.parseInt(noOfQC1);
		            	double gimValTotal = Double.parseDouble(gimVal) + Double.parseDouble(gimVal1);
		            	totalStrVal =  ""+noOfQCTotal+"@"+""+gimValTotal;
		            	System.out.println("str in else:"+totalStrVal);
		            	totalMap.put(count, totalStrVal);
		            	
		            	
		            	count++;
					}
	            }
	            table.setWidthPercentage(100);
	            document.add(table);
	            
			}
            System.out.println("totalMap :"+totalMap)toMailId = "birendra.pandey@baseinformation.com";
					ccMailId = "dhanendra.kasliwal@baseinformation.com";
					bccAddress = "";;
    		table = new PdfPTable(catGimValues.size()* 2 +1);
    		cell1 = new PdfPCell(new Paragraph("TOTAL", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6,Font.BOLD, new Color(255,0,0))));
       		table.addCell(cell1); 
        	for (int i=0; i<valList.size(); i++) 
            {
        		cell2 = new PdfPCell(new Paragraph(""+valList.get(i), FontFactory.getFont(FontFactory.TIMES_ROMAN, 6,Font.BOLD, new Color(255,0,0))));
        		cell2.setColspan(2);
        		cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
            	
            	table.addCell(cell2);
            	
            }
       		for (Map.Entry<Integer, String> entry : totalMap.entrySet())
            {
       			String val = entry.getValue();
            	String[] temp;
            	String noOfQC = "";
            	String gimVal = "";
            	temp = val.split("@");
            	noOfQC = temp[0].trim();
            	gimVal = temp[1].trim();
            	
       			cell2 = new PdfPCell(new Paragraph(df.format(Double.parseDouble(noOfQC)), FontFactory.getFont(FontFactory.TIMES_ROMAN, 6,Font.BOLD, new Color(255,0,0))));
       			cell3 = new PdfPCell(new Paragraph(df.format(Double.parseDouble(gimVal)), FontFactory.getFont(FontFactory.TIMES_ROMAN, 6,Font.BOLD, new Color(255,0,0))));
       			
       			cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
       			cell3.setHorizontalAlignment(Element.ALIGN_CENTER);
            	
       			table.addCell(cell2);
            	table.addCell(cell3);
            }
        	table.setWidthPercentage(100);
        	document.add(table);
            
        	document.close();
            System.out.println("PDF Create Successfully");*/
		}
            catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :PendingQCWorkOrder : getPendingQCWorkOrder():" + d.getMessage());
				throw new ITMException(d);
			}
		}

		return  rowDataPendingQCWorkOrder;
	}
	
	@SuppressWarnings("unchecked")
    public JSONObject getPendingQCWorkOrderGrid(String geoLocation, String siteCode, String dataSourceName) throws RemoteException, ITMException
    {
		JSONObject rowDataPendingQCWorkOrderGrid = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashboardUtility = null;
		try
		{
			System.out.println(" Inside PendingQCWorkOrder for getPendingQCWorkOrderGrid Data Soruc Name ="+dataSourceName);
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/	
			/*add new code for connection DB on dated:17062016 by Nikhil*/
			conn = getConnection();
			int count = 0;
			
			dashboardUtility = new DashboardUtility();
			siteCode = dashboardUtility.getCommaSeparated(siteCode);
			geoLocation= dashboardUtility.getCommaSeparated(geoLocation);
			
			if(geoLocation.trim().length()>0 && geoLocation!=null && siteCode!=null && siteCode.trim().length()>0)
			{
				
				
			/*	sql=    " SELECT no_of_days, ITEM_SER, NO_OF_OPEN_QCORDER, CHK_VAL,ROUND((PRODUCTION_VALUE)/100000,3) As PRODUCTION_VALUE " +
						" FROM ( SELECT z.NO_OF_DAYS AS NO_OF_DAYS,z.ITEM_SER AS ITEM_SER,SUM(z.NO_OF_OPEN_QCORDER) " +
						" AS NO_OF_OPEN_QCORDER, z.CHK_VAL AS CHK_VAL,sum(z.production_value) " +
						" as Production_Value FROM( SELECT ITEM.ITEM_SER, CASE " +
						" WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>=0 " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)<90 " +
						" THEN '>0-90 days' WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>=90 " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)<180 " +
						" THEN '>90-180 days' WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>=90 " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)<365 " +
						" THEN '>180-365 days' WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>365 THEN '>365 days' " +
						" WHEN TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')<> TO_CHAR(SYSDATE,'YYYY')  " +
						" THEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY') " +
						" END NO_OF_DAYS,COUNT(DISTINCT QC_ORDER.QORDER_NO) NO_OF_OPEN_QCORDER, " +
						" (CASE WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 0 " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)  < 90 THEN 1 " +
						" WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 90 " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)  < 180 " +
						" THEN 2 WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 180 " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)  < 365 THEN 3 " +
						" WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						" AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 365 THEN 4 " +
						" WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY') <> TO_CHAR (SYSDATE, 'YYYY') " +
						" THEN TO_NUMBER ( 4 + ABS ( TO_NUMBER (TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY' ) ) - TO_NUMBER (TO_CHAR (SYSDATE, 'YYYY')) ) ) ELSE 0 END) " +
						" AS CHK_VAL, sum(d.ACTUAL_PROD_VALUE) as production_value FROM WORKORDER_RECEIPT,ITEM,qc_order,WORKORDER,dwh_production d,site e " +
						" WHERE (WORKORDER_RECEIPT.ITEM_CODE = ITEM.ITEM_CODE) " +
						" AND workorder_RECEIPT.site_code in("+siteCode+") " +
						" and workorder_receipt.site_code=e.site_code " +
						" and e.city in("+geoLocation+") " +
						" AND WORKORDER.WORK_ORDER=WORKORDER_RECEIPT.WORK_ORDER " +
						" AND WORKORDER_RECEIPT.CONFIRMED='Y' " +
						" AND workorder_receipt.lot_no=qc_order.lot_no " +
						" AND workorder_receipt.tran_id=qc_order.porcp_no " +
						" AND workorder_receipt.item_code=qc_order.item_code " +
						" AND QC_ORDER.STATUS='U' and d.work_order=workorder.work_order " +
						" GROUP BY  WORKORDER_RECEIPT.TRAN_DATE, ITEM.ITEM_SER " +
						" ORDER BY CHK_VAL,no_of_days,ITEM.ITEM_SER) z " +
						" GROUP BY z.no_of_days,z.ITEM_SER,z.CHK_VAL ORDER BY z.ITEM_SER) " +
						" ORDER BY CHK_VAL ASC ";*/
			    
				sql = "SELECT no_of_days, ITEM_SER, NO_OF_OPEN_QCORDER, CHK_VAL,ROUND((PRODUCTION_VALUE)/100000,3) As PRODUCTION_VALUE " +
						"FROM ( SELECT z.NO_OF_DAYS AS NO_OF_DAYS,z.ITEM_SER AS ITEM_SER,SUM(z.NO_OF_OPEN_QCORDER) AS NO_OF_OPEN_QCORDER, " +
						"z.CHK_VAL AS CHK_VAL,sum(z.production_value) as Production_Value FROM( SELECT SITEITEM.ITEM_SER, " +
						"CASE WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>=0 AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)<90 " +
						"THEN '>0-90 days' WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>=90 AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)<180 " +
						"THEN '>90-180 days' WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>=90 AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)<365 " +
						"THEN '>180-365 days' WHEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')= TO_CHAR(SYSDATE,'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)>365 THEN '>365 days' " +
						"WHEN TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY')<> TO_CHAR(SYSDATE,'YYYY')  " +
						"THEN  TO_CHAR(WORKORDER_RECEIPT.TRAN_DATE,'YYYY') END NO_OF_DAYS,COUNT(DISTINCT QC_ORDER.QORDER_NO) NO_OF_OPEN_QCORDER, " +
						"(CASE WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 0 " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)  < 90 " +
						"THEN 1 WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 90 AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)  < 180 " +
						"THEN 2 WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 180 " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE)  < 365 THEN 3 " +
						"WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY')         = TO_CHAR (SYSDATE, 'YYYY') " +
						"AND TRUNC (TRUNC (SYSDATE) - WORKORDER_RECEIPT.TRAN_DATE) >= 365 THEN 4 " +
						"WHEN TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY') <> TO_CHAR (SYSDATE, 'YYYY') " +
						"THEN TO_NUMBER ( 4 + ABS ( TO_NUMBER (TO_CHAR (WORKORDER_RECEIPT.TRAN_DATE, 'YYYY' ) ) - TO_NUMBER (TO_CHAR (SYSDATE, 'YYYY')) ) ) ELSE 0 END) " +
						"AS CHK_VAL, sum(d.ACTUAL_PROD_VALUE) as production_value " +
						"FROM WORKORDER_RECEIPT,SITEITEM,qc_order,WORKORDER,dwh_production d," +
						"site e WHERE (WORKORDER_RECEIPT.ITEM_CODE = SITEITEM.ITEM_CODE) " +
						"AND workorder_RECEIPT.site_code in("+siteCode+") " +
						"and workorder_receipt.site_code=e.site_code " +
						"and e.city in("+geoLocation+") " +
						"AND WORKORDER.WORK_ORDER=WORKORDER_RECEIPT.WORK_ORDER AND WORKORDER_RECEIPT.CONFIRMED='Y' " +
						"AND workorder_receipt.lot_no=qc_order.lot_no AND workorder_receipt.tran_id=qc_order.porcp_no " +
						"AND workorder_receipt.item_code=qc_order.item_code AND QC_ORDER.STATUS='U' and d.work_order=workorder.work_order " +
						"AND SITEITEM.SITE_CODE=WORKORDER.SITE_CODE " + // Add below 3 condition on Date 14-10-2015 by Dhanendra
						"AND WORKORDER.ITEM_CODE=WORKORDER_RECEIPT.ITEM_CODE " +
						"AND WORKORDER.ITEM_CODE=D.ITEM_CODE " +
						" GROUP BY  WORKORDER_RECEIPT.TRAN_DATE, SITEITEM.ITEM_SER ORDER BY CHK_VAL,no_of_days,SITEITEM.ITEM_SER) z " +
						" GROUP BY z.no_of_days,z.ITEM_SER,z.CHK_VAL ORDER BY z.ITEM_SER) ORDER BY CHK_VAL ASC";
			    
			
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					rowData = new JSONObject();
					rowData.put("no_of_days", rs.getString("NO_OF_DAYS"));		
					rowData.put("item_ser", rs.getString("ITEM_SER"));
					rowData.put("no_of_open_qcorder", rs.getString("NO_OF_OPEN_QCORDER"));
					rowData.put("production_value", rs.getString("PRODUCTION_VALUE"));
					rowDataPendingQCWorkOrderGrid.put(count, rowData);
					count++;
				}
			}
			System.out.println("rowDataPendingQCWorkOrderGrid :"+rowDataPendingQCWorkOrderGrid);
				    
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in PendingQCWorkOrderGrid : getPendingQCWorkOrderGrid:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rowDataPendingQCWorkOrderGrid;
    }
	
	/*Start- this method add for generatePDF on 13Aug2015*/
	 @SuppressWarnings("unchecked")
	public String getPDFByScheduler(String rptTitle, String remark, String userID, String imgName, String city, String siteCode) throws RemoteException, ITMException 
	 {
		 System.out.println("In PendingQCWorkOrderGrid .getPDFByScheduler Method ");
			PdfWriter writer = null;	
			OutputStream file = null;
			Document document = null;		
			ConnDriver connDriver = new ConnDriver();
			Connection conn = null;
			PreparedStatement pstmt = null;
			ResultSet rs = null;		
			ArrayList<String> mailInfo=null;
			String imageName = null;
			Image image = null;
			File attachFile   = null;
			File attachExcleFile   = null;
		    String imgFilePath =null;	
		    File  existImgFile =null;
		    String pdfFileName =null;
		    String excelFileName = null;
		    String toMailId    =""; 
			String ccMailId    ="";
			String bccAddress  =""; 
			String subject     ="";
			String userWiseBodytext="";
			String resultFlage ="false";
			String exportPDFPath ="";
			String exportImagePath = "";
			String imgNameArray[] = null;  
			SimpleDateFormat simpleDateFormat = null;
			Calendar calendar = null;
			String currDate = "";
			int prntTblNo      =1;
			PdfPTable parentTable=null;
			Paragraph preface = null;
			
			PdfPTable table = null; 
			PdfPCell cell1 = null;
			PdfPCell cell2 = null;
			PdfPCell cell3 = null;
			String subtype = "";
           
			JSONObject fetchRowWiseValJsn = null;
			JSONObject rowDataforGrid = null;
			//List<String> valList = new ArrayList<String>();
			int count = 0;
			LinkedHashMap<String, String> catGimValues = null;
			DecimalFormat df = new DecimalFormat("#.###");
			
			HashMap<Integer, String> totalMap = new HashMap<Integer, String>();
			
			String noOfQC = "";
        	String productionVal = "";
        	String totalStrVal =  "";
        	String val = "";
        	int noOfQCTotal = 0;
        	double gimValTotal = 0.0;
        	String noOfQCPrev = "";
        	String productionValPrev = "";
			System.out.print("Calling for PDF created step1");
			try
			{
				
				
				System.out.println("In PendingQCWorkOrderGrid getPDFByScheduler city :"+city+"----siteCode :"+siteCode);
				rowDataforGrid = this.getPendingQCWorkOrder(city, siteCode, "DriverITM");
				
				System.out.println("rowDataforGrid in getPDFByScheduler :"+rowDataforGrid);
				this.getExcelGenerate(city, siteCode, "DriverITM");
				
				 //START CODE FOR WINDOWS
				//exportPDFPath    ="C://jboss-5.1.0.GA//server//default//deploy//ibase.ear//ibase.war//dashboard//mfg//Scheduler//ExportExample//ExportPDF//";
				//exportImagePath  ="C://jboss-5.1.0.GA//server//default//deploy//ibase.ear//ibase.war//dashboard//mfg//Scheduler//ExportExample//ExportImages//";
				 //END CODE FOR WINDOWS
				
				 //START CODE FOR LINUX
				exportPDFPath      = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "dashboard" + File.separator + "mfg"+ File.separator + "Scheduler"+File.separator +"ExportExample"+ File.separator + "ExportPDF"+File.separator;
		        exportImagePath    = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "dashboard" + File.separator + "mfg"+ File.separator + "Scheduler"+File.separator +"ExportExample"+ File.separator + "ExportImages"+File.separator;
		       //END CODE FOR LINUX
				System.out.println("exportPDFPath----->"+exportPDFPath);				
				simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");
				calendar      = Calendar.getInstance();
				currDate      = simpleDateFormat.format(calendar.getTime());			
				document      = new Document();				
				
				rptTitle      = city+" ("+siteCode+")"+" Pending QC Against Workorder Receipt as on " +currDate;
				
				System.out.println("rptTitle in PendingQCWorkOrderGrid getPDFByScheduler :"+rptTitle);
				
				pdfFileName     = exportPDFPath+rptTitle+".pdf";
				excelFileName   = exportPDFPath+rptTitle+".xls";
				
				System.out.println("excelFileName :"+excelFileName);
				System.out.println("modify PDF file name "+	pdfFileName+"current date formate==="+currDate);
				
				file          = new FileOutputStream(new File(pdfFileName));			
				writer        = PdfWriter.getInstance(document, file);
				document.open();			
				preface = new Paragraph();
				preface.setAlignment(Element.ALIGN_CENTER);
			    preface.add(new Paragraph(rptTitle, FontFactory.getFont(FontFactory.TIMES_ROMAN, 15)));
			    preface.add(new Paragraph(" "));   
			    document.add(preface);
			   
				imgNameArray = imgName.split(",");
				for(int size=0;size<prntTblNo;size++)
				{
				
					System.out.println("imageName in PendingQCWorkOrderGrid getPDFByScheduler =="+imageName);
					if(size==0)
					{
						imageName= imgNameArray[size];
						parentTable = new PdfPTable(1);
						
						imgFilePath = exportImagePath+imageName+".png";
				        
						image = Image.getInstance(imgFilePath);
						parentTable.addCell(image);
						
						existImgFile= new File(imgFilePath);
						if(existImgFile.exists())
						{
							existImgFile.delete();
							System.out.println("Image  Deleted after status **First*****"+imgFilePath ); 
						}
						parentTable.setWidthPercentage(100);
					}
					document.add(parentTable);
					preface = new Paragraph();
					/*preface.add(new Paragraph(" "));*/
					document.add(preface);
					if(size==0)
					{
						preface = new Paragraph();
						preface.add(new Paragraph("Remark: "+remark, FontFactory.getFont(FontFactory.TIMES_ROMAN, 8)));
						preface.add(new Paragraph(" "));
						document.add(preface);
						
					}
				}
				preface.add(new Paragraph(" ")); 
				for (int jsnCnt = 0; jsnCnt < rowDataforGrid.size(); jsnCnt++)
				{
	            	catGimValues = new LinkedHashMap<String, String>();
	            	fetchRowWiseValJsn = new JSONObject();
	            	fetchRowWiseValJsn = (JSONObject) rowDataforGrid.get(jsnCnt);
	            	subtype = ""+fetchRowWiseValJsn.get("product_category");
	            	
	            	System.out.println("subtype :"+subtype);
	            	catGimValues = (LinkedHashMap<String, String>) fetchRowWiseValJsn.get("category_gimvalue");
	            	System.out.println("catGimValues :"+catGimValues);
	            	
	            	count = 0;
	            	
	            	System.out.println("catValuesGim.size() :"+catGimValues.size());
	            	if(jsnCnt == 0)
	            	{
	            		table = new PdfPTable(catGimValues.size()*2+1);
	            		cell1 = new PdfPCell(new Paragraph("OPEN SINCE", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6, Font.BOLD, new Color(255,255,255))));
	               		cell1.setBackgroundColor(Color.gray);
	               		
	                	table.addCell(cell1); 
	                	for (Map.Entry<String, String> entry : catGimValues.entrySet()) 
	    	            {
	                		
	                		cell2 = new PdfPCell(new Paragraph(entry.getKey(), FontFactory.getFont(FontFactory.TIMES_ROMAN, 6, Font.BOLD, new Color(255,255,255))));
	                		cell2.setColspan(2);
	                		cell2.setBackgroundColor(Color.gray);
	    	            	cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
	    	            	table.addCell(cell2);
	    	            }
	                	table.setWidthPercentage(100);
	                	document.add(table);
	                	
	                	table = new PdfPTable(catGimValues.size()*2+1);
	            		cell1 = new PdfPCell(new Paragraph("", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6, Font.BOLD, new Color(255,255,255))));
	                	table.addCell(cell1); 
	                	for (Map.Entry<String, String> entry : catGimValues.entrySet()) 
	    	            {                		                               		
	                		cell2 = new PdfPCell(new Paragraph("Open QC Order Count", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
	                		cell3 = new PdfPCell(new Paragraph("Production Value Rs(In Lacs)", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
	                		
	    	            	cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
	    	            	cell3.setHorizontalAlignment(Element.ALIGN_CENTER);
	    	            	table.addCell(cell2);
	    	            	table.addCell(cell3);
	    	            }
	                	table.setWidthPercentage(100);
	                	document.add(table);           	                	
	            	}           	           	           	
	            	table = new PdfPTable(catGimValues.size() * 2 + 1); 
	            	cell1 = new PdfPCell(new Paragraph(subtype, FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
	            	table.addCell(cell1); 
		            for (Map.Entry<String, String> entry : catGimValues.entrySet()) 
		            {	            		            	
		            		            		            		            		          	
		            	val = entry.getValue();
		            	
		            	String[] temp;
		            	noOfQC = "";
		            	productionVal = "";
		            	temp = val.split("-");
		            	noOfQC = temp[0].trim();
		            	productionVal = temp[1].trim();
		            	//System.out.println("noOfQC :"+noOfQC+"---- productionVal :"+productionVal);
		            	
		            	cell2 = new PdfPCell(new Paragraph(noOfQC, FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
		            	cell3 = new PdfPCell(new Paragraph(productionVal, FontFactory.getFont(FontFactory.TIMES_ROMAN, 6)));
		            	cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
		            	cell3.setHorizontalAlignment(Element.ALIGN_CENTER);
		            	
		            	table.addCell(cell2);
		            	table.addCell(cell3);
		            	
		            	/*if(count == jsnCnt && jsnCnt == 0)
		            	{
		            	valList.add(""+total);
		            	}
		            	else if(count >=0 && count<catGimValues.size())
		            	{
		            	double sum = total + Double.parseDouble(valList.get(count));
		            	valList.set(count, df.format(sum));
		            	count++;
		            	}*/
		            	if(jsnCnt == 0)
						{
							totalStrVal = noOfQC+"@"+productionVal;
			            	totalMap.put(count, totalStrVal);
			            	count++;
						}
						else
						{
							noOfQCTotal = 0;
			            	gimValTotal = 0.0;
			            	noOfQCPrev = "";
			            	productionValPrev = "";
							totalStrVal =  totalMap.get(count);
			            	String[] totalStrValArr;
			            	totalStrValArr = totalStrVal.split("@");
			            	noOfQCPrev = totalStrValArr[0].trim();
			            	productionValPrev = totalStrValArr[1].trim();
			            	
			            	noOfQCTotal = Integer.parseInt(noOfQC) + Integer.parseInt(noOfQCPrev);
			            	gimValTotal = Double.parseDouble(productionVal) + Double.parseDouble(productionValPrev);
			            	totalStrVal =  ""+noOfQCTotal+"@"+""+gimValTotal;
			            	totalMap.put(count, totalStrVal);
			            	count++;
						}
		            	
		            }
		            table.setWidthPercentage(100);
		            document.add(table);
		            
				}
				
				/*Add code for total by Dhanendra on 08-09-15*/
				table = new PdfPTable(catGimValues.size()* 2 +1);
	    		cell1 = new PdfPCell(new Paragraph("TOTAL", FontFactory.getFont(FontFactory.TIMES_ROMAN, 6,Font.BOLD, new Color(255,0,0))));
	       		table.addCell(cell1); 
	        	/*for (int i=0; i<valList.size(); i++) 
	            {
	        		cell2 = new PdfPCell(new Paragraph(""+valList.get(i), FontFactory.getFont(FontFactory.TIMES_ROMAN, 6,Font.BOLD, new Color(255,0,0))));
	        		cell2.setColspan(2);
	        		cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
	            	
	            	table.addCell(cell2);
	            	
	            }*/
	       		System.out.println("totalMap in getPendingQCWorkOrder :"+totalMap);
	       		for (Map.Entry<Integer, String> entry : totalMap.entrySet())
	            {
	       			val = entry.getValue();
	            	String[] tempArr;
	            	noOfQC = "";
	            	productionVal = "";
	            	tempArr = val.split("@");
	            	noOfQC = tempArr[0].trim();
	            	productionVal = tempArr[1].trim();
	            	
	            	cell2 = new PdfPCell(new Paragraph(df.format(Double.parseDouble(noOfQC)), FontFactory.getFont(FontFactory.TIMES_ROMAN, 6,Font.BOLD, new Color(255,0,0))));
	       			cell3 = new PdfPCell(new Paragraph(df.format(Double.parseDouble(productionVal)), FontFactory.getFont(FontFactory.TIMES_ROMAN, 6,Font.BOLD, new Color(255,0,0))));
	       			
	       			cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
	       			cell3.setHorizontalAlignment(Element.ALIGN_CENTER);
	            	
	       			table.addCell(cell2);
	            	table.addCell(cell3);
	            }
		        table.setWidthPercentage(100);
		        document.add(table);
	        	/*End code for total by Dhanendra on 08-09-15*/
	        	
				document.close();
				file.close();
				
				System.out.println("PDF Created succesfully in getPendingQCWorkOrder getPDFByScheduler");
				conn = connDriver.getConnectDB("DriverITM");
				connDriver  =null;
				toMailId    =""; 
				ccMailId    ="";
				bccAddress  =""; 
				subject     =rptTitle;
				userWiseBodytext ="Dear Sir, Please find attached here with is the Weekly Output:"+rptTitle+" Report in PDF format.";
					
				city = "PQCPAR_"+city.trim();
				System.out.println("Add PQCPAR in city  :" +city);
				String sql = "SELECT SEND_TO, COPY_TO, BLIND_COPY FROM MAIL_FORMAT WHERE FORMAT_CODE = '"+city+"'";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				
				if (rs.next())
				{
					toMailId     = checkNull(rs.getString("SEND_TO")).trim();
					ccMailId     = checkNull(rs.getString("COPY_TO")).trim();
					bccAddress   = checkNull(rs.getString("BLIND_COPY")).trim();
					System.out.println("No of Users for PendingQCWorkOrder.getPDFByScheduler city = "+city+" --- toMailId ="+toMailId +"AND According to the ccMailId ======="+ccMailId+"---- bccAddress ==  "+bccAddress);
				}

				/*toMailId = "Julian.Soares@sunpharma.com,Bhaumik.Joshi@sunpharma.com,Jigar.Gohil@sunpharma.com";
				ccMailId = "birendra.pandey@baseinformation.com,nikhil.sawalakhe@baseinformation.com,dhanendra.kasliwal@baseinformation.com";
				bccAddress = "";*/
				
				/*toMailId = "birendra.pandey@baseinformation.com";
				ccMailId = "dhanendra.kasliwal@baseinformation.com";
				bccAddress = "";*/
				
				System.out.println("Export Pdf path for PendingQCWorkOrder.getPDFByScheduler ="+pdfFileName);
				attachFile = new File(pdfFileName);	
				attachExcleFile = new File(excelFileName);
				if(attachFile.exists() && attachFile.length()>0 && attachExcleFile.exists() && attachExcleFile.length()>0)
	            {
					mailInfo =new ArrayList<String>();
					mailInfo.add(toMailId);
					mailInfo.add(ccMailId);
					mailInfo.add(bccAddress);
					mailInfo.add(subject);
					mailInfo.add(userWiseBodytext);
					mailInfo.add(attachFile.getPath());
					mailInfo.add(attachExcleFile.getPath());
					this.sendingMail(mailInfo);
					resultFlage="true";
				}
				System.out.println("*sending  mail done succesfully for PendingQCWorkOrder.getPDFByScheduler*");
			} catch (Exception e)
			{
				System.out.println("Exception :PendingQCWorkOrder :getPDFByScheduler "+e.getMessage());
				e.printStackTrace();
			}
			finally
			{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						rs.close();
						rs = null;
						if (pstmt != null)
						pstmt.close();
						pstmt = null;
						conn.close();
						conn = null;
					}
					conn = null;
				} catch (Exception d)
				{
					d.printStackTrace();
					System.out.println("Exception in PendingQCWorkOrderGrid.getPDFByScheduler" + d.getMessage());
					throw new ITMException(d);
				}
			}
			return 	resultFlage;
		 	 
	 }
	 
	 public void sendingMail(ArrayList<String> mailInfo)
	 {
			StringBuffer commInfo = new StringBuffer();
			commInfo.append("<ROOT>");
			commInfo.append("<MAILINFO>");
			commInfo.append("<EMAIL_TYPE>").append("page").append("</EMAIL_TYPE>");
			commInfo.append("<TO_ADD>").append("<![CDATA[" + mailInfo.get(0) + "]]>").append("</TO_ADD>");
			commInfo.append("<CC_ADD>").append("<![CDATA[" + mailInfo.get(1) + "]]>").append("</CC_ADD>");
			commInfo.append("<BCC_ADD>").append("<![CDATA[" + mailInfo.get(2) + "]]>").append("</BCC_ADD>");
			commInfo.append("<SUBJECT>").append("<![CDATA[" + mailInfo.get(3) + "]]>").append("</SUBJECT>");
			commInfo.append("<BODY_TEXT>").append("<![CDATA[" +  mailInfo.get(4) + "]]>").append("</BODY_TEXT>");
			commInfo.append("<XML_DATA_FILE_PATH>").append("<![CDATA[" +  mailInfo.get(5)+";"+ mailInfo.get(6) + "]]>").append("</XML_DATA_FILE_PATH>");
			commInfo.append("</MAILINFO>");
			commInfo.append("</ROOT>");
			EMail email = new EMail();
			try
			{
			 System.out.println(" calling sendMail  method() for PendingQCWorkOrder.getPDFByScheduler");
			  email.sendMail(commInfo.toString(), "ITM", null);
			  System.out.println(" ********Email send succesfully for PendingQCWorkOrder.getPDFByScheduler ***********");
			} catch (Exception e)
			{
				e.printStackTrace();
				System.out.println("Exception :PendingQCWorkOrderGrid :sendMail(String ,String)" + e.getMessage());
			}
			email = null;
	}
	 /*End- this method add for generatePDF on 13Aug2015*/

	 /*Add this method for generate Excel file on Date 21-09-15 by Nikhil*/
		
    public void getExcelGenerate(String city, String siteCode, String dataSourceName)throws RemoteException, ITMException 
	{
		System.out.println("in getExcelGenerate PendingQCWorkOrder city :"+city+"-----siteCode :"+siteCode);
		System.out.println("dataSourceName :"+dataSourceName);
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String excelFileName = null;
		String exportPDFPath = "";
		String currDate="";
		SimpleDateFormat simpleDateFormat = null;
		Calendar calendar = null;
		DashboardUtility dashboardUtility = null;
		try
		{
			/*conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;*/
			/*add new code for connection DB on dated:17062016 by Nikhil*/
			conn = getConnection();
			simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");
			dashboardUtility = new DashboardUtility();
			calendar      = Calendar.getInstance();
			exportPDFPath      = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "dashboard" + File.separator + "mfg"+ File.separator + "Scheduler"+File.separator +"ExportExample"+ File.separator + "ExportPDF"+File.separator;
			currDate      = simpleDateFormat.format(calendar.getTime());
			
			excelFileName   = city+" ("+siteCode+")"+" Pending QC Against Workorder Receipt as on " +currDate;
			
			
			city = dashboardUtility.getCommaSeparated(city);
			siteCode = dashboardUtility.getCommaSeparated(siteCode);
			
			System.out.println("in getExcelGenerate after dashboardUtility city :"+city+"-----siteCode :"+siteCode);
			
			HSSFWorkbook wb = new HSSFWorkbook();
			HSSFSheet sheet = wb.createSheet("Excel Sheet");
			HSSFRow rowhead = sheet.createRow(0);
			  
			HSSFCellStyle cellStyleLeft=wb.createCellStyle() ;
			cellStyleLeft.setAlignment(HSSFCellStyle.ALIGN_LEFT);
			 
			HSSFCellStyle cellStyleRight=wb.createCellStyle() ;
			cellStyleRight.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
						 
			HSSFFont font=wb.createFont();
			font.setFontName("Calibri");
			font.setFontHeightInPoints((short)10);
			   
			cellStyleLeft.setFont(font);
			cellStyleRight.setFont(font);
			/*
			sql = "SELECT WORKORDER_RECEIPT.TRAN_ID, WORKORDER_RECEIPT.TRAN_DATE, WORKORDER_RECEIPT.WORK_ORDER, wORKORDER.ORDER_TYPE, " +
					"WORKORDER_RECEIPT.DATE__START, WORKORDER_RECEIPT.DATE__COMPL, WORKORDER_RECEIPT.ITEM_CODE, ITEM.ITEM_SER, " +
					"TRUNC(SYSDATE)-TRUNC(WORKORDER_RECEIPT.TRAN_DATE) AS DAYS, ITEM.DESCR as descr, WORKORDER_RECEIPT.lot_no, " +
					"WORKORDER_RECEIPT.QUANTITY AS quantity, WORKORDER_RECEIPT.UNIT, QC_ORDER.QORDER_NO, qc_order.status as Qc_Release_Pending, " +
					"sum(d.ACTUAL_PROD_VALUE) as production_value " +
					"FROM WORKORDER_RECEIPT,ITEM,qc_order,WORKORDER ,dwh_production d,SITE E " +
					"WHERE (WORKORDER_RECEIPT.ITEM_CODE = ITEM.ITEM_CODE) " +
					"and workorder_RECEIPT.site_code IN ("+siteCode+") " +
					"AND WORKORDER.WORK_ORDER=WORKORDER_RECEIPT.WORK_ORDER AND WORKORDER_RECEIPT.CONFIRMED='Y' " +
					"and workorder_receipt.lot_no=qc_order.lot_no and workorder_receipt.tran_id=qc_order.porcp_no " +
					"and workorder_receipt.item_code=qc_order.item_code AND QC_ORDER.STATUS='U' and d.work_order=workorder.work_ordeR " +
					"AND workorder_RECEIPT.site_code=E.SITE_CODE " +
					"AND E.CITY in("+city+") " +
					"GROUP By WORKORDER_RECEIPT.lot_no," +
					"workorder_receipt.confirmed, WORKORDER_RECEIPT.TRAN_DATE,wORKORDER.ORDER_TYPE,WORKORDER_RECEIPT.TRAN_ID, " +
					"WORKORDER_RECEIPT.WORK_ORDER,WORKORDER_RECEIPT.DATE__START,WORKORDER_RECEIPT.DATE__COMPL, " +
					"WORKORDER_RECEIPT.ITEM_CODE,ITEM.ITEM_SER,ITEM.DESCR,WORKORDER_RECEIPT.UNIT,QC_ORDER.QORDER_NO ," +
					"qc_order.status,workorder_receipt.quantity ORDER BY WORKORDER_RECEIPT.TRAN_DATE ";
			*/
			
			sql = "SELECT WORKORDER_RECEIPT.TRAN_ID, to_char(WORKORDER_RECEIPT.TRAN_DATE,'dd/mm/yy') AS TRAN_DATE, WORKORDER_RECEIPT.WORK_ORDER, " +
					"WORKORDER.ORDER_TYPE, to_char(WORKORDER_RECEIPT.DATE__START,'dd/mm/yy') AS DATE__START, to_char(WORKORDER_RECEIPT.DATE__COMPL,'dd/mm/yy') AS DATE__COMPL, WORKORDER_RECEIPT.ITEM_CODE, " +
					"SITEITEM.ITEM_SER, TRUNC(SYSDATE)-TRUNC(WORKORDER_RECEIPT.TRAN_DATE) AS DAYS, ITEM.DESCR as DESCR, " +
					"WORKORDER_RECEIPT.LOT_NO, WORKORDER_RECEIPT.QUANTITY AS QUANTITY, WORKORDER_RECEIPT.UNIT, QC_ORDER.QORDER_NO, " +
					"qc_order.status as QC_RELEASE_PENDING, to_char(QC_ORDER.MFG_DATE,'dd/mm/yy') AS MFG_DATE, to_char(QC_ORDER.EXPIRY_DATE,'dd/mm/yy') AS EXPIRY_DATE, sum(D.ACTUAL_PROD_VALUE) as PRODUCTION_VALUE " +
					"FROM WORKORDER_RECEIPT," +
					"SITEITEM,qc_order,WORKORDER ,dwh_production d,SITE E,ITEM WHERE (WORKORDER_RECEIPT.ITEM_CODE = SITEITEM.ITEM_CODE) " +
					"AND SITEITEM.ITEM_CODE=ITEM.ITEM_CODE " +
					"and workorder_RECEIPT.site_code IN ("+siteCode+") " +
					"AND WORKORDER.WORK_ORDER=WORKORDER_RECEIPT.WORK_ORDER " +
					"AND WORKORDER_RECEIPT.CONFIRMED='Y' " +
					"and workorder_receipt.lot_no=qc_order.lot_no " +
					"and workorder_receipt.tran_id=qc_order.porcp_no and workorder_receipt.item_code=qc_order.item_code " +
					"AND QC_ORDER.STATUS='U' and d.work_order=workorder.work_ordeR " +
					"AND workorder_RECEIPT.site_code=E.SITE_CODE " +
					"AND E.CITY in("+city+") " +
					"AND SITEITEM.site_CODE=Workorder.site_code " +  // Add below 3 condition on Date 14-10-2015 by Dhanendra
					"AND WORKORDER.item_code=WORKORDER_RECEIPT.item_code " +
					"AND WORKORDER.item_code=d.item_code " +
					" GROUP By WORKORDER_RECEIPT.lot_no,workorder_receipt.confirmed, " +
					"WORKORDER_RECEIPT.TRAN_DATE,wORKORDER.ORDER_TYPE,WORKORDER_RECEIPT.TRAN_ID, " +
					"WORKORDER_RECEIPT.WORK_ORDER,WORKORDER_RECEIPT.DATE__START,WORKORDER_RECEIPT.DATE__COMPL, " +
					"WORKORDER_RECEIPT.ITEM_CODE,SITEITEM.ITEM_SER,ITEM.DESCR,WORKORDER_RECEIPT.UNIT,QC_ORDER.QORDER_NO ," +
					"qc_order.status,workorder_receipt.quantity,QC_ORDER.MFG_DATE,QC_ORDER.EXPIRY_DATE ORDER BY WORKORDER_RECEIPT.TRAN_DATE";
			
			
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			ResultSetMetaData rsmtdt= rs.getMetaData();
			int columncount=rsmtdt.getColumnCount();
			
			int index = 0;
			boolean flag=true;
			HSSFRow row=null;
			
			while(rs.next())
			{
				//System.out.println("index :"+index);
				row = sheet.createRow(index);
				if(flag)
				{
					for(int i=1;i<=columncount;i++)
					{
					    createCell(wb, rowhead, i-1,cellStyleLeft, rsmtdt.getColumnLabel(i), "String");
					}
					flag=false;
					index++;
					row = sheet.createRow(index);
				}
				/*for(int i=1;i<=columncount;i++)
				{
					if(isNumeric(checkNull(rs.getString(i)).trim()))
					{
						if("QUANTITY".equalsIgnoreCase(rsmtdt.getColumnLabel(i)))
						{
							createCell(wb,row, i-1,cellStyleRight,checkNull(rs.getString(i)).trim(),"Number");
						}else if("PRODUCTION_VALUE".equalsIgnoreCase(rsmtdt.getColumnLabel(i)))
						{
							createCell(wb,row, i-1,cellStyleRight,checkNull(rs.getString(i)).trim(),"Number");
						}
						else if("DAYS".equalsIgnoreCase(rsmtdt.getColumnLabel(i)))
						{
							HSSFCell cell = row.createCell((short) (i-1), HSSFCell.CELL_TYPE_NUMERIC);
							cell.setCellValue(rs.getLong(i));
						}else
						{
							createCell(wb,row, i-1,cellStyleLeft,checkNull(rs.getString(i)).trim(),"String");
						}
					}else
					{
						createCell(wb,row, i-1,cellStyleLeft,checkNull(rs.getString(i)).trim(),"String");
					}
				}*/
				createCell(wb,row, 0,cellStyleLeft,checkNull(rs.getString(1)).trim(),"String"); //TRAN_ID
				createCell(wb,row, 1,cellStyleLeft,checkNull(rs.getString(2)).trim(),"String"); //TRAN_DATE
				createCell(wb,row, 2,cellStyleLeft,checkNull(rs.getString(3)).trim(),"String"); //WORK_ORDER
				
				createCell(wb,row, 3,cellStyleLeft,checkNull(rs.getString(4)).trim(),"String"); //ORDER_TYPE
				createCell(wb,row, 4,cellStyleLeft,checkNull(rs.getString(5)).trim(),"String"); //DATE__START
				createCell(wb,row, 5,cellStyleLeft,checkNull(rs.getString(6)).trim(),"String"); //DATE__COMPL
				
				createCell(wb,row, 6,cellStyleLeft,checkNull(rs.getString(7)).trim(),"String"); //ITEM_CODE
				createCell(wb,row, 7,cellStyleLeft,checkNull(rs.getString(8)).trim(),"String"); //ITEM_SER
				createCell(wb,row, 8,cellStyleRight,checkZero(rs.getString(9)).trim(),"String"); //DAYS
				
				createCell(wb,row, 9,cellStyleLeft,checkNull(rs.getString(10)).trim(),"String"); //DESCR
				createCell(wb,row, 10,cellStyleLeft,checkNull(rs.getString(11)).trim(),"String"); //LOT_NO
				createCell(wb,row, 11,cellStyleRight,checkZero(rs.getString(12)).trim(),"Number"); //QUANTITY
				
				createCell(wb,row, 12,cellStyleLeft,checkNull(rs.getString(13)).trim(),"String"); //UNIT
				createCell(wb,row, 13,cellStyleLeft,checkNull(rs.getString(14)).trim(),"String"); //QORDER_NO
				createCell(wb,row, 14,cellStyleLeft,checkNull(rs.getString(15)).trim(),"String"); //QC_RELEASE_PENDING
				
				createCell(wb,row, 15,cellStyleLeft,checkNull(rs.getString(16)).trim(),"String"); //MFG_DATE
				createCell(wb,row, 16,cellStyleLeft,checkNull(rs.getString(17)).trim(),"String"); //EXPIRY_DATE
				createCell(wb,row, 17,cellStyleRight,checkZero(rs.getString(18)).trim(),"Number"); //PRODUCTION_VALUE
				
	            index++;
			}
			
			excelFileName   = exportPDFPath+excelFileName+".xls";
			System.out.println("excelFileName in getExcelGenerate :"+excelFileName);
			FileOutputStream out = new FileOutputStream(excelFileName);
			wb.write(out);
			out.close();
			
		}catch (Exception e) 
		{
			System.out.println("Exception :PendingQCWorkOrder :getExcelGenerate(String city, String siteCode, String dataSourceName :"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in PendingQCWorkOrder.getPDFByScheduler" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
	}
	@SuppressWarnings("deprecation")
	private void createCell(HSSFWorkbook wb, HSSFRow row, int column, HSSFCellStyle cellStyle, String data, String dataType)
	 {
	 	HSSFCell cell = null;
	 	if("String".equalsIgnoreCase(dataType))
	 	{
	 		cell = row.createCell((short) column, HSSFCell.CELL_TYPE_STRING);
	 		cell.setCellValue(data);
	 	}
	 	if("Number".equalsIgnoreCase(dataType))
	 	{
	 		cellStyle.setDataFormat((short)2);
	 		cell = row.createCell((short) column, HSSFCell.CELL_TYPE_NUMERIC);
	 		cell.setCellValue(Double.parseDouble(data));
	 	}
		cell.setCellStyle(cellStyle);		
	 }
	/*End this method for generate Excel file on Date 21-09-15 by Nikhil*/
	private String checkNull(String str)
	{
		if(str == null || str == "null")
		{
			return "";
		}
		else
		{
			return str ;
		}

	}
	public boolean isNumeric(String str)  
	{  
	  try  
	  {  
	    double d = Double.parseDouble(str);  
	  }  
	  catch(NumberFormatException nfe)  
	  {  
		  return false;  
	  }  
	  return true;  
	}
	private String checkZero(String str)
	{
		if(str == null || str.equals(null) || str.equalsIgnoreCase(""))
		{
			return "0";
		}
		else
		{
			return str ;
		}

	}

	
	}	

