/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.tree;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.tree.BaseSchemaTree;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.tree.key.SchemaKey;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public final class InlineSchemaTree
extends BaseSchemaTree {
    private final Map<JsonRef, JsonPointer> absRefs;
    private final Map<JsonRef, JsonPointer> otherRefs;

    public InlineSchemaTree(SchemaKey key, JsonNode baseNode) {
        super(key, baseNode, JsonPointer.empty());
        HashMap abs = Maps.newHashMap();
        HashMap other = Maps.newHashMap();
        JsonRef loadingRef = key.getLoadingRef();
        InlineSchemaTree.walk(loadingRef, baseNode, JsonPointer.empty(), abs, other);
        this.absRefs = ImmutableMap.copyOf((Map)abs);
        this.otherRefs = ImmutableMap.copyOf((Map)other);
    }

    @Deprecated
    public InlineSchemaTree(JsonNode baseNode) {
        this(SchemaKey.anonymousKey(), baseNode);
    }

    @Deprecated
    public InlineSchemaTree(JsonRef loadingRef, JsonNode baseNode) {
        this(SchemaKey.forJsonRef(loadingRef), baseNode);
    }

    private InlineSchemaTree(InlineSchemaTree other, JsonPointer newPointer) {
        super(other, newPointer);
        this.absRefs = other.absRefs;
        this.otherRefs = other.otherRefs;
    }

    @Override
    public SchemaTree append(JsonPointer pointer) {
        JsonPointer newPointer = this.pointer.append(pointer);
        return new InlineSchemaTree(this, newPointer);
    }

    @Override
    public SchemaTree setPointer(JsonPointer pointer) {
        return new InlineSchemaTree(this, pointer);
    }

    @Override
    public boolean containsRef(JsonRef ref) {
        return this.getMatchingPointer(ref) != null;
    }

    @Override
    public JsonPointer matchingPointer(JsonRef ref) {
        JsonPointer ret = this.getMatchingPointer(ref);
        if (ret == null) {
            return null;
        }
        return ((JsonNode)ret.path((TreeNode)this.baseNode)).isMissingNode() ? null : ret;
    }

    @Nullable
    private JsonPointer getMatchingPointer(JsonRef ref) {
        if (this.otherRefs.containsKey(ref)) {
            return this.otherRefs.get(ref);
        }
        if (!ref.isLegal()) {
            return null;
        }
        return this.refMatchingPointer(ref);
    }

    @Nullable
    private JsonPointer refMatchingPointer(JsonRef ref) {
        JsonPointer refPtr = ref.getPointer();
        for (Map.Entry<JsonRef, JsonPointer> entry : this.absRefs.entrySet()) {
            if (!entry.getKey().contains(ref)) continue;
            return entry.getValue().append(refPtr);
        }
        return this.key.getLoadingRef().contains(ref) ? refPtr : null;
    }

    private static void walk(JsonRef baseRef, JsonNode node, JsonPointer ptr, Map<JsonRef, JsonPointer> absMap, Map<JsonRef, JsonPointer> otherMap) {
        if (!node.isObject()) {
            return;
        }
        JsonRef ref = InlineSchemaTree.idFromNode(node);
        JsonRef nextRef = baseRef;
        if (ref != null) {
            nextRef = baseRef.resolve(ref);
            Map<JsonRef, JsonPointer> targetMap = nextRef.isAbsolute() ? absMap : otherMap;
            targetMap.put(nextRef, ptr);
        }
        Map tmp = JacksonUtils.asMap((JsonNode)node);
        for (Map.Entry entry : tmp.entrySet()) {
            InlineSchemaTree.walk(nextRef, (JsonNode)entry.getValue(), ptr.append((String)entry.getKey()), absMap, otherMap);
        }
    }
}

