/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.CommonConstants;
import ibase.utility.ValidateXMLInput;
import ibase.webitm.utility.Column;
import ibase.webitm.utility.ITMException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericUtility {
    static GenericUtility INST = null;

    public static GenericUtility getInstance() {
        return new GenericUtility();
    }

    public Document parseString(String string) throws ITMException {
        Document document = null;
        try {
            if (string != null && string.length() > 0) {
                string = this.setXmlDec(string);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setIgnoringComments(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)System.err, "UTF-8");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(CommonConstants.ENCODING));
                document = documentBuilder.parse(byteArrayInputStream);
            }
        }
        catch (Exception exception) {
            document = null;
            System.out.println("Exception : [GenericUtility][parseString] :==>\n" + exception.getMessage());
            throw new ITMException(exception);
        }
        return document;
    }

    public byte[] transformToBytes(String string, String string2, String string3, String string4, String string5) throws ITMException {
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            ValidateXMLInput validateXMLInput = new ValidateXMLInput();
            String string6 = validateXMLInput.validate(string, string2, string3, string4, string5);
            fileInputStream = new FileInputStream(string6);
            byteArrayOutputStream = new ByteArrayOutputStream();
            int n = -1;
            while ((n = fileInputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                    fileInputStream = null;
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                    byteArrayOutputStream = null;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception in releasing file resource :");
                exception.printStackTrace();
            }
        }
        return byArray;
    }

    public String transformToString(String string, String string2, String string3, String string4, String string5) throws ITMException {
        String string6 = "";
        try {
            ValidateXMLInput validateXMLInput = new ValidateXMLInput();
            String string7 = validateXMLInput.validate(string, string2, string3, string4, string5);
            string6 = this.readFile(string7);
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
        return string6;
    }

    public String readFile(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
            }
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                    bufferedReader = null;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception in releasing file resource :[" + string + "]");
                exception.printStackTrace();
            }
        }
        return stringBuffer.toString();
    }

    public String serializeDom(Node node) throws ITMException {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(byteArrayOutputStream));
            string = byteArrayOutputStream.toString();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
        }
        catch (Exception exception) {
            System.out.println("Exception : GenericUtility : serializeDom :" + exception);
            throw new ITMException(exception);
        }
        return string;
    }

    private static String removeAllDec(String string) throws ITMException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (string.trim().startsWith("<?xml")) {
                string = string.substring(string.indexOf(">") + 1, string.length()).trim();
                stringBuffer.append(string);
            } else if (string.indexOf("<?xml") != -1) {
                String string2 = string.substring(0, string.indexOf("<?xml")).trim();
                String string3 = string.substring(string.indexOf("<?xml"), string.length());
                string3 = string3.substring(string3.indexOf(">") + 1, string3.length()).trim();
                stringBuffer.append(string2);
                stringBuffer.append(string3);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : GenericUtility : removeAllDec :" + exception);
            throw new ITMException(exception);
        }
        return stringBuffer.toString();
    }

    public String remAllXmlDec(String string) throws ITMException {
        try {
            boolean bl = true;
            while (string != null & bl) {
                if (string.indexOf("<?xml") != -1) {
                    string = GenericUtility.removeAllDec(string);
                    continue;
                }
                bl = false;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : GenericUtility : remAllXmlDec :" + exception);
            throw new ITMException(exception);
        }
        return string;
    }

    public String setXmlDec(String string) throws ITMException {
        try {
            if (string != null && string.length() > 0) {
                string = this.remAllXmlDec(string);
                StringBuffer stringBuffer = new StringBuffer("<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>");
                stringBuffer.append(string);
                string = stringBuffer.toString();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility : : remAllXmlDec :" + exception);
            throw new ITMException(exception);
        }
        return string;
    }

    public String serializeDom(Node node, boolean bl) throws ITMException {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (node.getNodeType() == 1) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.setOutputProperty("encoding", CommonConstants.ENCODING);
            transformer.transform(new DOMSource(node), new StreamResult(byteArrayOutputStream));
            string = byteArrayOutputStream.toString();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility : : serializeDom :" + exception);
            throw new ITMException(exception);
        }
        return string;
    }

    public String getColumnValue(String string, Document document) throws ITMException {
        String string2 = "";
        try {
            string2 = this.getColumnValue(string, document, "0");
        }
        catch (Exception exception) {
            System.out.println("Exception : [GenericUtility][getColumnValue(1)] :==>\n" + exception.getMessage());
            throw new ITMException(exception);
        }
        return string2;
    }

    public String getColumnValue(String string, Document document, String string2) throws ITMException {
        Node node = null;
        Node node2 = null;
        NodeList nodeList = null;
        Element element = null;
        String string3 = "";
        String string4 = null;
        boolean bl = true;
        boolean bl2 = false;
        try {
            nodeList = document.getElementsByTagName(string);
            if (Integer.parseInt(string2) < 1) {
                bl2 = true;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node = nodeList.item(i);
                node2 = node.getParentNode();
                element = (Element)node2;
                if (!element.getAttribute("objContext").equals(string2) && !element.getAttribute("formno").equals(string2) && !bl2) continue;
                string3 = node.getNodeName();
                string4 = "";
                string4 = node.getFirstChild() != null ? node.getFirstChild().getNodeValue() : null;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : [GenericUtility][getColumnValue(2)] :==>\n" + exception.getMessage());
            throw new ITMException(exception);
        }
        return string4;
    }

    public String getColumnValue(String string, Document document, String string2, String string3) throws ITMException {
        String string4 = "";
        System.out.println("GenericUtility:: getColumnValue() :  formNo[" + string2 + "]  [" + string2 + "], rowNo[" + string3 + "]");
        Node node = null;
        NodeList nodeList = null;
        Element element = null;
        NodeList nodeList2 = null;
        NodeList nodeList3 = null;
        Node node2 = null;
        Node node3 = null;
        String string5 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        String string6 = "";
        String string7 = null;
        boolean bl2 = false;
        try {
            if (string2 != null && string2.length() > 0 && Integer.parseInt(string2) < 1) {
                bl2 = true;
            }
            if (string3 == null || "".equals(string3)) {
                nodeList2 = document.getElementsByTagName("Detail" + string2);
                n4 = nodeList2.getLength();
                System.out.println(" GenericUtility::parentList.getLength  [" + nodeList2.getLength() + "]  ");
                for (n = 0; n < n4; ++n) {
                    node2 = nodeList2.item(n);
                    nodeList3 = node2.getChildNodes();
                    n3 = nodeList3.getLength();
                    System.out.println("noOfChilds length  [" + n3 + "]");
                    for (n2 = 0; n2 < n3; ++n2) {
                        node3 = nodeList3.item(n2);
                        string5 = node3.getNodeName();
                        if (!string5.equals(string) || node3.getFirstChild() == null) continue;
                        string7 = node3.getFirstChild().getNodeValue().trim();
                        string4 = n == 0 ? string7 : string4 + "," + string7;
                    }
                }
            } else {
                nodeList = document.getElementsByTagName(string);
                for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                    node = nodeList.item(n2);
                    node2 = node.getParentNode();
                    element = (Element)node2;
                    if (!element.getAttribute("objContext").equals(string2) && !element.getAttribute("formno").equals(string2) && !bl2 || !element.getAttribute("domID").equals(string3)) continue;
                    string6 = node.getNodeName();
                    string7 = "";
                    string4 = node.getFirstChild() != null ? node.getFirstChild().getNodeValue() : null;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : GenericUtility: getColumnValue() :==>\n" + exception.getMessage());
            throw new ITMException(exception);
        }
        System.out.println(" returnVal [" + string4 + "]");
        return string4;
    }

    public String getColumnValueFromNode(String string, Node node) throws ITMException {
        String string2 = null;
        try {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2 == null || node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
                if (node2.getFirstChild() != null) {
                    string2 = node2.getFirstChild().getNodeValue();
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
        return string2;
    }

    public ArrayList getTokenList(String string, String string2) throws Exception {
        System.out.println("getTokenList tokenString :[" + string + "] delimiter :[" + string2 + "]");
        ArrayList<String> arrayList = null;
        if (string != null && string.length() > 0) {
            arrayList = new ArrayList<String>();
            while (string.indexOf(string2) != -1) {
                int n = string.indexOf(string2);
                arrayList.add(string.substring(0, n));
                string = string.substring(n + string2.length(), string.length());
            }
            arrayList.add(string.substring(0, string.length()));
        }
        return arrayList;
    }

    public java.util.Date getDateObject(String string) throws ITMException {
        java.util.Date date = null;
        Object var3_3 = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getApplDateFormat());
            date = simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getDateObject :==>\n" + exception.getMessage());
            throw new ITMException(exception);
        }
        return date;
    }

    public String getValidDateString(String string, String string2, String string3) throws ITMException {
        java.util.Date date = null;
        String string4 = "";
        try {
            if (!string2.equalsIgnoreCase(string3)) {
                if (string2.indexOf("/") != -1) {
                    string.replace('/', '-');
                } else if (string2.indexOf(".") != -1) {
                    string.replace('.', '-');
                }
                date = new SimpleDateFormat(string2).parse(string);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
                string4 = simpleDateFormat.format((Object)date);
            } else {
                string4 = string;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getValidDateString :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return string4;
    }

    public String getValidDateTimeString(String string, String string2, String string3) throws ITMException {
        System.out.println("Getting the valid datetime string for dateTimeStr :[" + string + "] which is in format :[" + string2 + "]");
        java.util.Date date = null;
        String string4 = "";
        try {
            if (!string2.equalsIgnoreCase(string3)) {
                if (string2.indexOf("/") != -1) {
                    string.replace('/', '-');
                } else if (string2.indexOf(".") != -1) {
                    string.replace('.', '-');
                }
                SimpleDateFormat simpleDateFormat = null;
                if (string2.toLowerCase().indexOf("hh:mm:ss") != -1) {
                    date = string.indexOf("00:00:00") == -1 ? new SimpleDateFormat(string2).parse(string + " 00:00:00") : new SimpleDateFormat(string2).parse(string);
                    simpleDateFormat = string3.toLowerCase().indexOf("hh:mm:ss") == -1 ? new SimpleDateFormat(string3 + " HH:mm:ss") : new SimpleDateFormat(string3);
                    string4 = simpleDateFormat.format((Object)date);
                } else {
                    date = string.indexOf("00:00:00") == -1 ? new SimpleDateFormat(string2 + " HH:mm:ss").parse(string + " 00:00:00") : new SimpleDateFormat(string2 + " HH:mm:ss").parse(string);
                    simpleDateFormat = string3.toLowerCase().indexOf("hh:mm:ss") == -1 ? new SimpleDateFormat(string3 + " HH:mm:ss") : new SimpleDateFormat(string3);
                    string4 = simpleDateFormat.format((Object)date);
                }
            } else {
                string4 = string;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getValidDateString :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        System.out.println("retDateStr :[" + string4 + "]");
        return string4;
    }

    public String getDispDateFormat() throws ITMException, Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory;
            DocumentBuilder documentBuilder;
            Document document;
            NodeList nodeList;
            Node node;
            if (CommonConstants.DISP_DATE_FORMAT == null && (node = (nodeList = (document = (documentBuilder = (documentBuilderFactory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(CommonConstants.JBOSSHOME + File.separator + "setting" + File.separator + "DateFormat.xml")).getElementsByTagName("DISP_DATE_FORMAT")).item(0)) != null && node.getFirstChild() != null) {
                CommonConstants.DISP_DATE_FORMAT = node.getFirstChild().getNodeValue();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getDispDateFormat :==>\n" + exception);
            throw new ITMException(exception);
        }
        return CommonConstants.DISP_DATE_FORMAT;
    }

    public String getDispDateTimeFormat() throws ITMException, Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory;
            DocumentBuilder documentBuilder;
            Document document;
            NodeList nodeList;
            Node node;
            if (CommonConstants.DISP_DATETIME_FORMAT == null && (node = (nodeList = (document = (documentBuilder = (documentBuilderFactory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(CommonConstants.JBOSSHOME + File.separator + "setting" + File.separator + "DateFormat.xml")).getElementsByTagName("DISP_DATETIME_FORMAT")).item(0)) != null && node.getFirstChild() != null) {
                CommonConstants.DISP_DATETIME_FORMAT = node.getFirstChild().getNodeValue();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getDispDateFormat :==>\n" + exception);
            throw new ITMException(exception);
        }
        return CommonConstants.DISP_DATETIME_FORMAT;
    }

    public String getApplDateTimeFormat() throws ITMException, Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory;
            DocumentBuilder documentBuilder;
            Document document;
            NodeList nodeList;
            Node node;
            if (CommonConstants.APPL_DATETIME_FORMAT == null && (node = (nodeList = (document = (documentBuilder = (documentBuilderFactory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(CommonConstants.JBOSSHOME + File.separator + "setting" + File.separator + "DateFormat.xml")).getElementsByTagName("APPL_DATETIME_FORMAT")).item(0)) != null && node.getFirstChild() != null) {
                String string = node.getFirstChild().getNodeValue();
                System.out.println("dateTimeFormat[" + string + "]");
                if (string.endsWith("HH:mm")) {
                    string = string + ":ss";
                }
                System.out.println("dateTimeFormat Assign SS[" + string + "]");
                CommonConstants.APPL_DATETIME_FORMAT = string;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getApplDateTimeFormat :==>\n" + exception);
            throw new ITMException(exception);
        }
        return CommonConstants.APPL_DATETIME_FORMAT;
    }

    public String getApplDateFormat() throws ITMException, Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory;
            DocumentBuilder documentBuilder;
            Document document;
            NodeList nodeList;
            Node node;
            if (CommonConstants.APPL_DATE_FORMAT == null && (node = (nodeList = (document = (documentBuilder = (documentBuilderFactory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(CommonConstants.JBOSSHOME + File.separator + "setting" + File.separator + "DateFormat.xml")).getElementsByTagName("APPL_DATE_FORMAT")).item(0)) != null && node.getFirstChild() != null) {
                CommonConstants.APPL_DATE_FORMAT = node.getFirstChild().getNodeValue();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getApplDateFormat :==>\n" + exception);
            throw new ITMException(exception);
        }
        return CommonConstants.APPL_DATE_FORMAT;
    }

    public String getDBDateFormat() throws ITMException, Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory;
            DocumentBuilder documentBuilder;
            Document document;
            NodeList nodeList;
            Node node;
            if (CommonConstants.DB_DATE_FORMAT == null && (node = (nodeList = (document = (documentBuilder = (documentBuilderFactory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(CommonConstants.JBOSSHOME + File.separator + "setting" + File.separator + "DateFormat.xml")).getElementsByTagName("DB_DATE_FORMAT")).item(0)) != null && node.getFirstChild() != null) {
                CommonConstants.DB_DATE_FORMAT = node.getFirstChild().getNodeValue();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getDBDateFormat :==>\n" + exception);
            throw new ITMException(exception);
        }
        return CommonConstants.DB_DATE_FORMAT;
    }

    public String getDisplayTimeFormat() throws ITMException, Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory;
            DocumentBuilder documentBuilder;
            Document document;
            NodeList nodeList;
            Node node;
            if (CommonConstants.DISP_TIME_FORMAT == null && (node = (nodeList = (document = (documentBuilder = (documentBuilderFactory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(CommonConstants.JBOSSHOME + File.separator + "setting" + File.separator + "DateFormat.xml")).getElementsByTagName("DISP_TIME_FORMAT")).item(0)) != null && node.getFirstChild() != null) {
                CommonConstants.DISP_TIME_FORMAT = node.getFirstChild().getNodeValue();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getDisplayTimeFormat :==>\n" + exception);
            throw new ITMException(exception);
        }
        return CommonConstants.DISP_TIME_FORMAT;
    }

    public java.util.Date getDateTimeObject(String string) throws ITMException {
        java.util.Date date = null;
        Object var3_3 = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getApplDateTimeFormat());
            date = simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getDateTimeObject :==>\n" + exception.getMessage());
            throw new ITMException(exception);
        }
        return date;
    }

    public float timeDiff(java.util.Date date, java.util.Date date2) throws ITMException {
        long l = date.getTime();
        long l2 = date2.getTime();
        long l3 = l - l2;
        float f = (float)l3 / 3600000.0f;
        float f2 = (float)((int)((f - (float)((int)f)) * 60.0f)) / 100.0f;
        float f3 = (float)((int)f) + f2;
        return f3;
    }

    public int getParameterCount(String string) throws ITMException {
        int n = 0;
        int n2 = 0;
        try {
            while (n != -1) {
                ++n;
                n = string.indexOf(63, n);
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : GenericUtility : genParameterCount :==>\n" + exception.getMessage());
            throw new ITMException(exception);
        }
        return --n2;
    }

    public String getValueFromXTRA_PARAMS(String string, String string2) throws ITMException {
        String string3 = "";
        try {
            int n = string.indexOf(string2);
            int n2 = string.indexOf("=", n);
            int n3 = string.indexOf("~", n2);
            if (n3 < 0) {
                n3 = string.length();
            }
            string3 = string.substring(n2 + 1, n3);
            System.out.println("Value of " + string2 + " : " + string3);
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getValueFromXTRA_PARAMS :==>\n" + exception.getMessage());
            throw new ITMException(exception);
        }
        return string3;
    }

    public String createErrorString(Exception exception) {
        ITMException iTMException = new ITMException(exception);
        String string = "<?xml version=\"1.0\"?>\r\n" + iTMException.getMessage();
        return string;
    }

    public String formatDouble(double d, int n) throws ITMException {
        System.out.println("GenericUtility=>Converting double value [" + d + "] by formatDouble()");
        String string = null;
        try {
            int n2;
            string = String.valueOf(d);
            if (string.indexOf(69) != -1) {
                BigDecimal bigDecimal = new BigDecimal(d);
                string = bigDecimal.toString();
            }
            if ((n2 = string.indexOf(".")) != -1) {
                Object object;
                int n3 = string.substring(n2 + 1).length();
                double d2 = 0.0;
                if (n3 > n) {
                    object = string.substring(0, n2 + n + 1);
                    String string2 = string.substring(n2 + n + 1, n2 + n + 2);
                    int n4 = Integer.parseInt(string2);
                    d2 = n4 >= 5 ? Double.parseDouble((String)object) + 1.0 / Math.pow(10.0, n) : Double.parseDouble((String)object);
                } else {
                    d2 = Double.parseDouble(string);
                }
                object = new DecimalFormat();
                ((DecimalFormat)object).applyPattern("#.#");
                ((DecimalFormat)object).setMaximumFractionDigits(n);
                string = ((NumberFormat)object).format(d2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ITMException(exception);
        }
        System.out.println("GenericUtility=>Returning converted string from by formatDouble():[" + string + "]");
        return string;
    }

    public String getNormalizeString(String string) throws ITMException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("<?xml version='1.0' encoding='ISO-8859-1'?>");
            stringBuffer.append("<DocumentRoot>");
            stringBuffer.append("<description>Datawindow Root</description>");
            stringBuffer.append("<group0>");
            stringBuffer.append("<description>Group0 description</description>");
            stringBuffer.append("<Header0>");
            stringBuffer.append("<description>Header0 members</description>");
            stringBuffer.append(string);
            stringBuffer.append("</Header0>");
            stringBuffer.append("</group0>");
            stringBuffer.append("</DocumentRoot>");
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getNormalizeString :==>\n" + exception);
            throw new ITMException(exception);
        }
        return stringBuffer.toString();
    }

    public String initCap(String string, String string2) throws ITMException {
        System.out.println("dataString [" + string + "]");
        try {
            int n = 0;
            do {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.replace(n, n + 1, string.substring(n, n + 1).toUpperCase());
                string = stringBuffer.toString();
                n = string.indexOf(string2, n + 1);
            } while (++n != 0);
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :initCap :==>\n" + exception);
            throw new ITMException(exception);
        }
        System.out.println("GenericUtility : initCap : returning : dataString " + string);
        return string;
    }

    public String removeElementValues(String string, String string2, String string3) throws ITMException {
        System.out.println("Removing Element Values :[" + string2 + "]");
        Document document = null;
        String string4 = "";
        try {
            document = this.parseString(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                NodeList nodeList = document.getElementsByTagName(string5.trim());
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node = nodeList.item(i);
                    Object var12_13 = null;
                    node.getFirstChild().setNodeValue(string4);
                }
            }
            string4 = this.serializeDom(document);
        }
        catch (Exception exception) {
            System.out.println("Exception :MasterStatefulEJB : removeElementValues :==>\n" + exception);
            exception.printStackTrace();
            throw new ITMException(exception);
        }
        return string4;
    }

    public boolean isNodePresent(String string, String string2, Document document) throws ITMException {
        NodeList nodeList = null;
        boolean bl = false;
        try {
            NodeList nodeList2 = document.getElementsByTagName("Detail" + string2);
            if (nodeList2.item(0) != null) {
                nodeList = nodeList2.item(0).getChildNodes();
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node == null || node.getNodeType() != 1 || !node.getNodeName().equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : [GenericUtility][getColumnValue(2)] :==>\n" + exception.getMessage());
            throw new ITMException(exception);
        }
        return bl;
    }

    public String generateTabSeparatedData(String string, String string2, String string3) throws ITMException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Node node = this.searchNode(this.parseString(string), string2, string3);
            if (node != null && node.getNodeType() == 1 && node.getNodeName().startsWith("Detail")) {
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node2 = nodeList.item(i);
                    if (node2 == null || node2.getNodeType() != 1 || node2.getNodeName().equalsIgnoreCase("attribute")) continue;
                    String string4 = node2.getFirstChild() != null ? node2.getFirstChild().getNodeValue() : "";
                    stringBuffer.append(string4);
                    if (i <= 0 || i == n) continue;
                    stringBuffer.append("\t");
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : [GenericUtility][ generateTabSeparatedData ] :==>\n" + exception.getMessage());
            throw new ITMException(exception);
        }
        return stringBuffer.toString();
    }

    public Document parseFile(Object object) throws Exception {
        Document document = null;
        try {
            File file = null;
            file = object.getClass().getName().equalsIgnoreCase("java.lang.String") ? new File((String)object) : (File)object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringComments(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file);
        }
        catch (Exception exception) {
            document = null;
            System.out.println("Exception :GenericUtility :parseFile :\n" + exception.getMessage());
            throw exception;
        }
        return document;
    }

    public String createITMAddDom(String string, String string2, String string3) throws ITMException {
        StringBuffer stringBuffer;
        block19: {
            stringBuffer = new StringBuffer();
            System.out.println(" -------------44444444--------- Calling GenericUtility for creating ITMAddDom....");
            try {
                if (string3 == null) break block19;
                stringBuffer.append("<?xml version='1.0' encoding='utf-8'?>");
                stringBuffer.append("<DocumentRoot>");
                stringBuffer.append("<description>Datawindow Root</description>");
                stringBuffer.append("<group0>");
                stringBuffer.append("<description>Group0 description</description>");
                stringBuffer.append("<Header0>");
                stringBuffer.append("<description>Header0 members</description>");
                if (string.equalsIgnoreCase("TAXTRAN")) {
                    stringBuffer.append("<Tax domID=''>");
                } else {
                    stringBuffer.append("<Detail" + string2 + " dbID='' domID='' objName='" + string + "' objContext='" + string2 + "'>");
                }
                stringBuffer.append("<attribute pkNames='' status='N' updateFlag='A' selected='N'/>");
                Document document = this.parseFile(string3);
                NodeList nodeList = document.getElementsByTagName("table_column");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    String string4 = "";
                    String string5 = "";
                    String string6 = "";
                    String string7 = "";
                    Node node = nodeList.item(i);
                    NodeList nodeList2 = node.getChildNodes();
                    int n2 = nodeList2.getLength();
                    for (int j = 0; j < n2; ++j) {
                        object = nodeList2.item(j);
                        if (object.getNodeName().equalsIgnoreCase("name") && object.getFirstChild() != null) {
                            string4 = object.getFirstChild().getNodeValue();
                            continue;
                        }
                        if (object.getNodeName().equalsIgnoreCase("type") && object.getFirstChild() != null) {
                            String string8;
                            string5 = object.getFirstChild().getNodeValue();
                            String string9 = string8 = object.getAttributes().getNamedItem("size") != null ? object.getAttributes().getNamedItem("size").getNodeValue().trim() : "0";
                            if (string8.length() <= 0) continue;
                            int n3 = Integer.parseInt(string8);
                            for (int k = 0; k < n3; ++k) {
                                string7 = string7 + " ";
                            }
                            continue;
                        }
                        if (!object.getNodeName().equalsIgnoreCase("initial") || object.getFirstChild() == null) continue;
                        string6 = object.getFirstChild().getNodeValue();
                    }
                    String string10 = "";
                    if ("SPACES".equalsIgnoreCase(string6)) {
                        string10 = string7;
                    } else if ("TODAY".equalsIgnoreCase(string6)) {
                        object = new Date(System.currentTimeMillis());
                        if ("DATE".equalsIgnoreCase(string5)) {
                            string10 = this.getValidDateString(((Date)object).toString(), "yyyy-MM-dd", this.getApplDateFormat());
                        } else if ("DATETIME".equalsIgnoreCase(string5)) {
                            string10 = this.getValidDateTimeString(((Date)object).toString(), "yyyy-MM-dd", this.getApplDateTimeFormat());
                        }
                    } else if (string6.length() > 0) {
                        string10 = string6;
                    }
                    stringBuffer.append("<" + string4 + ">").append(string10).append("</" + string4 + ">");
                }
                if (string.equalsIgnoreCase("TAXTRAN")) {
                    stringBuffer.append("</Tax>");
                } else {
                    stringBuffer.append("</Detail" + string2 + ">");
                }
                stringBuffer.append("</Header0>");
                stringBuffer.append("</group0>");
                stringBuffer.append("</DocumentRoot>");
            }
            catch (Exception exception) {
                System.out.println("Exception : [GenericUtility][createITMAddDom] :==>\n" + exception.getMessage());
                exception.printStackTrace();
                throw new ITMException(exception);
            }
        }
        System.out.println(" -------------77777777 --------itmAddDomBuff.toString():[" + stringBuffer.toString() + "]");
        return stringBuffer.toString();
    }

    private Node searchNode(Document document, String string, String string2) throws ITMException {
        System.out.println("Searching node from dom :[" + document + "] for objContext :[" + string + "] nodeID :[" + string2 + "]");
        Node node = null;
        try {
            string = string == null ? "1" : string;
            string2 = string2 == null ? "1" : string2;
            NodeList nodeList = document.getElementsByTagName("Detail" + string);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(string2)) continue;
                node = node2;
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : GenericUtility :searchNode :==>" + exception);
            throw new ITMException(exception);
        }
        return node;
    }

    public ResultSet executeQuery(Connection connection, String string, String string2, String string3) throws ITMException {
        System.out.println("Query Parameters :[" + string2 + "] and their types :[" + string3 + "]");
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        String string4 = ":";
        try {
            GenericUtility genericUtility = new GenericUtility();
            preparedStatement = connection.prepareStatement(string);
            if (string2 != null && string.indexOf("?") != -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                int n = 1;
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken(string4);
                    if (string3 != null) {
                        String string6 = string3.substring(0, string3.indexOf(string4));
                        System.out.println("Setting Param value :[" + string5 + "] Type :[" + string6 + "] position :[" + n + "]");
                        if (string6.equalsIgnoreCase("DATETIME")) {
                            string5 = genericUtility.getValidDateTimeString(string5, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat());
                            preparedStatement.setTimestamp(n, Timestamp.valueOf(string5));
                        } else if (string6.equalsIgnoreCase("DATE")) {
                            string5 = this.getValidDateString(string5, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat());
                            preparedStatement.setDate(n, Date.valueOf(string5));
                        } else if (string6.equalsIgnoreCase("DECIMAL")) {
                            preparedStatement.setDouble(n, Double.parseDouble(string5));
                        } else {
                            preparedStatement.setString(n, string5);
                        }
                        string3 = string3.substring(string3.indexOf(string4) + 1);
                    } else {
                        preparedStatement.setString(n, string5);
                    }
                    ++n;
                }
            }
            System.out.println("Executing Query :" + string);
            resultSet = preparedStatement.executeQuery();
        }
        catch (Exception exception) {
            System.out.println("Exception :DB2XMLGenerator :executeQuery() ==>");
            exception.printStackTrace();
            throw new ITMException(exception);
        }
        return resultSet;
    }

    public String getDBDateTimeFormat() throws ITMException, Exception {
        try {
            Node node;
            DocumentBuilderFactory documentBuilderFactory;
            DocumentBuilder documentBuilder;
            Document document;
            NodeList nodeList;
            if (CommonConstants.DB_DATETIME_FORMAT == null && (nodeList = (document = (documentBuilder = (documentBuilderFactory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(CommonConstants.JBOSSHOME + File.separator + "setting" + File.separator + "DateFormat.xml")).getElementsByTagName("DB_DATETIME_FORMAT")) != null && (node = nodeList.item(0)) != null && node.getFirstChild() != null) {
                CommonConstants.DB_DATETIME_FORMAT = node.getFirstChild().getNodeValue();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getDBDateFormat :==>\n" + exception);
            throw new ITMException(exception);
        }
        return CommonConstants.DB_DATETIME_FORMAT;
    }

    public String getValidDateTimeString(java.util.Date date, String string) throws ITMException {
        String string2 = "";
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            string2 = simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getValidDateTimeString :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        System.out.println("retDateStr :" + string2);
        return string2;
    }

    public Column getColumnObject(ArrayList arrayList, String string) throws ITMException, Exception {
        Column column = null;
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!((Column)arrayList.get(i)).getLogicalName().equalsIgnoreCase(string)) continue;
                column = (Column)arrayList.get(i);
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getColumnObject :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        return column;
    }

    public String getValidDateTimeString(String string, String string2) throws ITMException {
        String string3 = "";
        try {
            java.util.Date date = this.getDateTimeObject(string);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            string3 = simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getValidDateTimeString :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        System.out.println("retDateStr :" + string3);
        return string3;
    }

    public String getValidDateString(String string, String string2) throws ITMException {
        String string3 = "";
        try {
            java.util.Date date = this.getDateObject(string);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            string3 = simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getValidDateString :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        System.out.println("retDateStr :" + string3);
        return string3;
    }

    public String getThemeFormat() throws ITMException, Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory;
            DocumentBuilder documentBuilder;
            Document document;
            NodeList nodeList;
            Node node;
            if (CommonConstants.THEME == null && (node = (nodeList = (document = (documentBuilder = (documentBuilderFactory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse("/IBASEHOME" + File.separator + "ibase.xml")).getElementsByTagName("THEME")).item(0)) != null && node.getFirstChild() != null) {
                CommonConstants.THEME = node.getFirstChild().getNodeValue();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :GenericUtility :getThemeFormat :==>[" + exception + "]");
            throw new ITMException(exception);
        }
        System.out.println("CommonConstants.THEME:==> [" + CommonConstants.THEME + "]");
        return CommonConstants.THEME;
    }

    public boolean isErrorNodeFound(String string) throws ITMException, Exception {
        boolean bl;
        block3: {
            bl = false;
            try {
                if (string.indexOf("<Errors>") == -1) break block3;
                NodeList nodeList = this.parseString(string).getElementsByTagName("error");
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    String string2 = nodeList.item(i).getAttributes().getNamedItem("type").getNodeValue();
                    System.out.println("errorType :[" + string2 + "]");
                    if (!"E".equals(string2)) continue;
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ITMException(exception);
            }
        }
        return bl;
    }

    public void writeLoggerFile(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        Object object;
        java.util.Date date = new java.util.Date();
        String string8 = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds();
        String string9 = "Time [" + string8 + "] User::[" + string + "] SiteCode::[" + string2 + "] EventCode::[" + string3 + "] focussedColumn::[" + string4 + "]";
        String string10 = "[" + string5 + "] " + "Data Send::[" + string6 + "] " + "Data Returned::[" + string7 + "] ";
        String string11 = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + string + ".txt";
        File file = new File(string11);
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer("");
        if (file.exists()) {
            bufferedReader = new BufferedReader(new FileReader(file));
            object = null;
            while ((object = bufferedReader.readLine()) != null) {
                if (object == null || ((String)object).trim().length() <= 0) continue;
                stringBuffer = stringBuffer.append((String)object + "\n");
            }
        } else {
            stringBuffer.append("");
        }
        object = new BufferedWriter(new FileWriter(file));
        ((BufferedWriter)object).newLine();
        ((Writer)object).write(stringBuffer.append(string9).toString());
        ((BufferedWriter)object).newLine();
        ((Writer)object).write(string10);
        ((BufferedWriter)object).flush();
        ((BufferedWriter)object).close();
    }
}

