<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:variable name="top">0</xsl:variable>
<xsl:variable name="left">0</xsl:variable>
<xsl:variable name="width">450</xsl:variable>
<xsl:variable name="lwidth">170</xsl:variable>
<xsl:variable name="height">20</xsl:variable>
<xsl:variable name="stylecss">
<![CDATA[
	border-color:yellow;
	background:#D7E5F9;
	color:#102132;
	text-align:left;
	font-family:verdana;
	font-size:9pt;
  	border:1px solid #FFFFFF;
  	position:absolute;
  	border-bottom-style:none;
]]>
</xsl:variable>
<xsl:variable name="hstylecss">
<![CDATA[
	border-color:yellow;
	background:#D7E5F9;
	color:#102132;
	text-align:center;
	font-family:verdana;
	font-size:9pt;
  	border:1px solid #FFFFFF;
  	position:absolute;
  	border-bottom-style:none;
]]>
</xsl:variable>
	
<xsl:template match="/">
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
<script type="text/javascript" src="/ibase/webitm/js/ICRWizard.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.11.1.js"></script>
<script language="JavaScript" type="text/javascript">
<![CDATA[
    function setActionVal( value )
	{  

		document.getElementById("action").value = value;
	}
  
	
]]>

</script>
</head>
<body>

<style type="text/css">

.tableClass
{margin-left:10px;margin-top:10px;}

.tableClass_rep
{margin-left:0px;}

.header_td
{border:inset 0;background:#FFCCCC;font-family:verdana;font-size:9pt;font-weight:bold;height: 18px}

.reset
{border:inset 1;font-family:verdana;font-size:9pt; font-weight:bold;}

.input_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt;}

.input_num_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt;}

.td_leftAlign
{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt;}

#main1
{margin-left: 5px;margin-top: 5px;width: 3452px;position: absolute;border: 1px solid black;}

#left_menu
{width: 1723px;float: left;border: 1px solid green;}

#content
{width: 1723px;float: left;border: 1px solid black;}

.headerdiv
{width: 100px;height: 13px;}

.headerNamediv
{width: 100px;height: 30px;}

.detaildiv
{width: 100px;height: 20px;}

.detailNamediv
{width: 100px;height: 30px;}

.tRANDATE{width: 100px;height: 13px;text-align:center;}
.rEFSER{width: 80px;height: 13px;text-align:center;}
.rEFID{width: 80px;height: 13px;text-align:center;}
.aCCTCODE{width: 80px;height: 13px;text-align:center;}
.cCTRCODE{width: 80px;height: 13px;text-align:center;}
.dRAMT{width: 80px;height: 13px;text-align:center;}
.cRAMT{width: 80px;height: 13px;text-align:center;}
.sITECODE{width: 80px;height: 13px;text-align:center;}
.fINENTITY{width: 80px;height: 13px;text-align:center;}
.cURRCODE{width: 80px;height: 13px;text-align:center;}
.eXCHRATE{width: 80px;height: 13px;text-align:center;}
.aCCTPRD{width: 80px;height: 13px;text-align:center;}
.pRDCODE{width: 80px;height: 13px;text-align:center;}
.rEMARKS{width: 350px;height: 13px;text-align:center;}
.pROJCODE{width: 80px;height: 13px;text-align:center;}
.cHGDATE{width: 100px;height: 13px;text-align:center;}
.sUNDRYTYPE{width: 100px;height: 13px;text-align:center;}
.sUNDRYCODE{width: 100px;height: 13px;text-align:center;}
.cOMPREF{width: 300px;height: 13px;text-align:center;}
.sHNAME{width: 150px;height: 13px;text-align:center;}
.sUNDRYNAME{width: 300px;height: 13px;text-align:center;}
.sUNDRYDETAILS{width: 450px;height: 13px;text-align:center;}
.oRGLOCN{width: 80px;height: 13px;text-align:center;}
.ocheckBox{width: 20px;height: 13px;text-align:center;}
.gPNO{width: 130px;height: 13px;text-align:center;}

.dtRANDATE{width: 100px;height: 35px;text-align:left;}
.drEFSER{width: 80px;height: 30px;text-align:left;}
.drEFID{width: 80px;height: 30px;text-align:left;}
.daCCTCODE{width: 80px;height: 30px;text-align:left;}
.dcCTRCODE{width: 80px;height: 30px;text-align:left;}
.ddRAMT{width: 80px;height: 30px;text-align:right;}
.dcRAMT{width: 80px;height: 30px;text-align:right;}
.dsITECODE{width: 80px;height: 30px;text-align:left;}
.dfINENTITY{width: 80px;height: 30px;text-align:left;}
.dcURRCODE{width: 80px;height: 30px;text-align:left;}
.deXCHRATE{width: 80px;height: 30px;text-align:left;}
.daCCTPRD{width: 80px;height: 30px;text-align:left;}
.dpRDCODE{width: 80px;height: 30px;text-align:left;}
.drEMARKS{width: 350px;height: 30px;text-align:left;}
.dpROJCODE{width: 80px;height: 30px;text-align:left;}
.dcHGDATE{width: 100px;height: 30px;text-align:left;}
.dsUNDRYTYPE{width: 100px;height: 30px;text-align:left;}
.dsUNDRYCODE{width: 100px;height: 30px;text-align:left;}
.dcOMPREF{width: 300px;height: 30px;text-align:left;}
.dsHNAME{width: 150px;height: 30px;text-align:left;}
.dsUNDRYNAME{width: 300px;height: 30px;text-align:left;}
.dsUNDRYDETAILS{width: 450px;height: 30px;text-align:left;}
.doRGLOCN{width: 80px;height: 30px;text-align:left;}
.dcheckBox{width: 20px;height: 30px;text-align:left;}
.dgPNO{width: 130px;height: 30px;text-align:left;}

</style>

<form name = "Wizard_Travel" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet" onSubmit="javascript:return validatePlace('2');">
<!-- <xmp><xsl:copy-of select="*"/></xmp> -->
<xsl:variable name="from_tran_date"><xsl:value-of select="/Root/Detail1/from_tran_date"/></xsl:variable>
<xsl:variable name="to_tran_date"><xsl:value-of select="/Root/Detail1/to_tran_date"/></xsl:variable>
<xsl:variable name="site_code_fr"><xsl:value-of select="/Root/Detail1/site_code_fr"/></xsl:variable>
<xsl:variable name="site_code_to"><xsl:value-of select="/Root/Detail1/site_code_to"/></xsl:variable>
<xsl:variable name="chg_user"><xsl:value-of select="/Root/Detail1/chg_user"/></xsl:variable>
<xsl:variable name="chg_term"><xsl:value-of select="/Root/Detail1/chg_term"/></xsl:variable>
<xsl:variable name="sundry_type_fr"><xsl:value-of select="/Root/Detail1/sundry_type_fr"/></xsl:variable>
<xsl:variable name="sundry_type_to"><xsl:value-of select="/Root/Detail1/sundry_type_to"/></xsl:variable>
<xsl:variable name="sundry_code_fr"><xsl:value-of select="/Root/Detail1/sundry_code_fr"/></xsl:variable>
<xsl:variable name="sundry_code_to"><xsl:value-of select="/Root/Detail1/sundry_code_to"/></xsl:variable> 

<div id ="main1">
	<div id ="left_menu">
		<table border="0" style="width: 600px;" cellspacing="1" cellpadding="1">
			<tr>
				<td colspan="24" class="header_td" nowrap="true" align="center"><div class="detaildiv"><b><xsl:value-of select="/Root/Detail1/site_code_fr"/> [<xsl:value-of select="/Root/Detail1/site_code_fr_descr"/>]</b></div></td>
			</tr>
			<tr>
			    <td class="header_td"><div class="ocheckBox"><input type="hidden" name="hiden" value="" /></div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="rEFID">REF ID</div></td>
			    <td class="header_td" nowrap="true" valign="middle"><div class="tRANDATE">TRAN DATE</div></td>
			    <td class="header_td" nowrap="true" valign="middle"><div class="dRAMT">DR AMT</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="cRAMT">CR AMT</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="cURRCODE">CURR CODE</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="eXCHRATE">EXCH RATE</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="fINENTITY">FIN ENTITY</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="sITECODE">SITE CODE</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="rEFSER">REF SER</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="gPNO">GP NO</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="tRANDATE">GP DATE</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="sUNDRYTYPE">SUNDRY TYPE</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="sUNDRYCODE">SUNDRY CODE</div></td>
				<td class="header_td" nowrap="true" valign="bottom"><div class="sUNDRYNAME">SUNDRY NAME</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="rEFSER">BILL NO</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="tRANDATE">BILL DATE</div></td>
			</tr>
		</table>
	</div>
	<div id ="left_menu">
		<table border="0" style="width: 600px;" cellspacing="1" cellpadding="1">
			<tr>
				<td colspan="24" class="header_td" nowrap="true" align="center"><div class="detaildiv"><b><xsl:value-of select="/Root/Detail1/site_code_to"/> [<xsl:value-of select="/Root/Detail1/site_code_to_descr"/>]</b></div></td>
			</tr>
			<tr>
				<td class="header_td"><div class="ocheckBox"><input type="hidden" name="hiden" value="" /></div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="rEFID">REF ID</div></td>
			    <td class="header_td" nowrap="true" valign="middle"><div class="tRANDATE">TRAN DATE</div></td>
			    <td class="header_td" nowrap="true" valign="middle"><div class="dRAMT">DR AMT</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="cRAMT">CR AMT</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="cURRCODE">CURR CODE</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="eXCHRATE">EXCH RATE</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="fINENTITY">FIN ENTITY</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="sITECODE">SITE CODE</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="rEFSER">REF SER</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="gPNO">GP NO</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="tRANDATE">GP DATE</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="sUNDRYTYPE">SUNDRY TYPE</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="sUNDRYCODE">SUNDRY CODE</div></td>
				<td class="header_td" nowrap="true" valign="bottom"><div class="sUNDRYNAME">SUNDRY NAME</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="rEFSER">BILL NO</div></td>
				<td class="header_td" nowrap="true" valign="middle"><div class="tRANDATE">BILL DATE</div></td>
			</tr>
		</table>
	</div>
	<xsl:if test="count(/Root/Detail2/Detail) &gt; 0">
	<div id ="left_menu">
		<xsl:for-each select="Root/Detail2/Detail">
		 <xsl:variable name="cnt" select="position()" />
				<table border="0" style="width: 600px;border-color: 0px solid red;" cellspacing="1" cellpadding="1">
					<xsl:variable name="trandate">
					   <xsl:value-of select="TRAN_DATE"/>
					</xsl:variable>
					<xsl:variable name="refser">
					   <xsl:value-of select="REF_SER"/>
					</xsl:variable>
					<xsl:variable name="refid">
					   <xsl:value-of select="REF_ID"/>
					</xsl:variable>
					<xsl:variable name="acctcode">
					   <xsl:value-of select="ACCT_CODE"/>
					</xsl:variable>
					<xsl:variable name="cctrcode">
					   <xsl:value-of select="CCTR_CODE"/>
					</xsl:variable>
					<xsl:variable name="dramt">
					   <xsl:value-of select="DR_AMT"/>
					</xsl:variable>
					<xsl:variable name="cramt">
					   <xsl:value-of select="CR_AMT"/>
					</xsl:variable>
					<xsl:variable name="sitecode">
					   <xsl:value-of select="SITE_CODE"/>
					</xsl:variable>
				<xsl:if test="$sitecode = $site_code_fr">
					<tr>
					    <td class="td_leftAlign"><div class="dcheckBox"><input type="checkbox" name="checkbox1" value="{$cnt}" /></div></td>
						<td class="td_leftAlign" align="left"><div id="REF_ID{$cnt}" class="drEFID"><xsl:value-of select="REF_ID"/></div></td>
						<td class="td_leftAlign" align="left"><div id="TRAN_DATE{$cnt}" class="dtRANDATE"><xsl:value-of select="TRAN_DATE"/></div></td>
						<td class="td_leftAlign" align="left"><div id="DR_AMT{$cnt}" class="ddRAMT"><xsl:value-of select="DR_AMT"/></div></td>
						<td class="td_leftAlign" align="left"><div id="CR_AMT{$cnt}" class="dcRAMT"><xsl:value-of select="CR_AMT"/></div></td>
						<td class="td_leftAlign" align="left"><div id="CURR_CODE{$cnt}" class="dcURRCODE"><xsl:value-of select="CURR_CODE"/></div></td>
						<td class="td_leftAlign" align="left"><div id="EXCH_RATE{$cnt}" class="deXCHRATE"><xsl:value-of select="EXCH_RATE"/></div></td>
						<td class="td_leftAlign" align="left"><div id="FIN_ENTITY{$cnt}" class="dfINENTITY"><xsl:value-of select="FIN_ENTITY"/></div></td>
						<td class="td_leftAlign" align="left"><div id="SITE_CODE{$cnt}" class="dsITECODE"><xsl:value-of select="SITE_CODE"/></div></td>
						<td class="td_leftAlign" align="left"><div id="REF_SER{$cnt}" class="drEFSER"><xsl:value-of select="REF_SER"/></div></td>
						
						<td class="td_leftAlign" align="left"><div id="GP_NO{$cnt}" class="dgPNO"><xsl:value-of select="GP_NO"/></div></td>
						<td class="td_leftAlign" align="left"><div id="GP_DATE{$cnt}" class="dtRANDATE"><xsl:value-of select="GP_DATE"/></div></td>						
						<td class="td_leftAlign" align="left"><div id="SUNDRYTYPE{$cnt}" class="dsUNDRYTYPE"><xsl:value-of select="SUNDRYTYPE"/></div></td>
						<td class="td_leftAlign" align="left"><div id="SUNDRYCODE{$cnt}" class="dsUNDRYCODE"><xsl:value-of select="SUNDRYCODE"/></div></td>
						<td class="td_leftAlign" align="left"><div id="SUNDRY_NAME{$cnt}" class="dsUNDRYNAME"><xsl:value-of select="SUNDRY_NAME"/></div></td>
						<td class="td_leftAlign" align="left"><div id="BIL_NO{$cnt}" class="drEFSER" ><xsl:value-of select="BIL_NO"/></div></td>
						<td class="td_leftAlign" align="left"><div id="BIL_DATE{$cnt}" class="dtRANDATE"><xsl:value-of select="BIL_DATE"/></div></td>
					</tr>
				</xsl:if>
				</table>
			<!-- </xsl:if> -->
		</xsl:for-each>
	</div>
	<!-- <xsl:variable name="cnt" select="0" /> -->
	<div id ="left_menu">
		<xsl:for-each select="Root/Detail2/Detail">
		 <xsl:variable name="cnt" select="position()" />
				<table border="0" style="width: 600px;border-color: 0px solid blue;" cellspacing="1" cellpadding="1">
					<xsl:variable name="trandate">
					   <xsl:value-of select="TRAN_DATE"/>
					</xsl:variable>
					<xsl:variable name="refser">
					   <xsl:value-of select="REF_SER"/>
					</xsl:variable>
					<xsl:variable name="refid">
					   <xsl:value-of select="REF_ID"/>
					</xsl:variable>
					<xsl:variable name="acctcode">
					   <xsl:value-of select="ACCT_CODE"/>
					</xsl:variable>
					<xsl:variable name="cctrcode">
					   <xsl:value-of select="CCTR_CODE"/>
					</xsl:variable>
					<xsl:variable name="dramt">
					   <xsl:value-of select="DR_AMT"/>
					</xsl:variable>
					<xsl:variable name="cramt">
					   <xsl:value-of select="CR_AMT"/>
					</xsl:variable>
					<xsl:variable name="sitecode">
					   <xsl:value-of select="SITE_CODE"/>
					</xsl:variable>
				<xsl:if test="$sitecode = $site_code_to">
					<tr>
					    <td class="td_leftAlign"><div class="dcheckBox"><input type="checkbox" name="checkbox1" value="{$cnt}" /></div></td>
						<td class="td_leftAlign" align="left"><div id="REF_ID{$cnt}" class="drEFID"><xsl:value-of select="REF_ID"/></div></td>
						<td class="td_leftAlign" align="left"><div id="TRAN_DATE{$cnt}" class="dtRANDATE"><xsl:value-of select="TRAN_DATE"/></div></td>
						<td class="td_leftAlign" align="left"><div id="DR_AMT{$cnt}" class="ddRAMT"><xsl:value-of select="DR_AMT"/></div></td>
						<td class="td_leftAlign" align="left"><div id="CR_AMT{$cnt}" class="dcRAMT"><xsl:value-of select="CR_AMT"/></div></td>
						<td class="td_leftAlign" align="left"><div id="CURR_CODE{$cnt}" class="dcURRCODE"><xsl:value-of select="CURR_CODE"/></div></td>
						<td class="td_leftAlign" align="left"><div id="EXCH_RATE{$cnt}" class="deXCHRATE"><xsl:value-of select="EXCH_RATE"/></div></td>
						<td class="td_leftAlign" align="left"><div id="FIN_ENTITY{$cnt}" class="dfINENTITY"><xsl:value-of select="FIN_ENTITY"/></div></td>
						<td class="td_leftAlign" align="left"><div id="SITE_CODE{$cnt}" class="dsITECODE"><xsl:value-of select="SITE_CODE"/></div></td>
						<td class="td_leftAlign" align="left"><div id="REF_SER{$cnt}" class="drEFSER"><xsl:value-of select="REF_SER"/></div></td>
						
						<td class="td_leftAlign" align="left"><div id="GP_NO{$cnt}" class="dgPNO" value="{$refser}"><xsl:value-of select="GP_NO"/></div></td>
						<td class="td_leftAlign" align="left"><div id="GP_DATE{$cnt}" class="dtRANDATE"><xsl:value-of select="GP_DATE"/></div></td>						
						<td class="td_leftAlign" align="left"><div id="SUNDRYTYPE{$cnt}" class="dsUNDRYTYPE"><xsl:value-of select="SUNDRYTYPE"/></div></td>
						<td class="td_leftAlign" align="left"><div id="TSUNDRYCODE{$cnt}" class="dsUNDRYCODE"><xsl:value-of select="SUNDRYCODE"/></div></td>
						<td class="td_leftAlign" align="left"><div id="SUNDRY_NAME{$cnt}" class="dsUNDRYNAME"><xsl:value-of select="SUNDRY_NAME"/></div></td>
						<td class="td_leftAlign" align="left"><div id="BIL_NO{$cnt}" class="drEFSER" ><xsl:value-of select="BIL_NO"/></div></td>
						<td class="td_leftAlign" align="left"><div id="BIL_DATE{$cnt}" class="dtRANDATE"><xsl:value-of select="BIL_DATE"/></div></td>
					</tr>
				</xsl:if>
				</table>
			<!-- </xsl:if> -->
		</xsl:for-each>
	</div>
	<xsl:variable name="cnt" select="0" />
	</xsl:if>
	<div id="repeatPlacesDiv" style="margin-left:10px"></div>
	<div id="left_menu">
		<table>
			<tr>
			    <td>
				<input type="hidden" value="2" name="FORM_NO" ID="FORM_NO" />
				<input type="hidden" value="intercomp_reconcile" name="OBJ_NAME" />
				<input type="hidden" value="" name="action" id="action" />
				<input type="hidden" value="{$from_tran_date}" name="from_tran_date" id="from_tran_date" />
				<input type="hidden" value="{$to_tran_date}" name="to_tran_date" id="to_tran_date" />
				<input type="hidden" value="{$site_code_fr}" name="site_code_fr" id="site_code_fr" />
				<input type="hidden" value="{$site_code_to}" name="site_code_to" id="site_code_to" />
				<input type="hidden" value="{$chg_user}" name="chg_user" id="chg_user" />
				<input type="hidden" value="{$chg_term}" name="chg_term" id="chg_term" />
				<input type="hidden" value="{$sundry_type_fr}" name="sundry_type_fr" id="sundry_type_fr" />
				<input type="hidden" value="{$sundry_type_to}" name="sundry_type_to" id="sundry_type_to" />
				<input type="hidden" value="{$sundry_code_fr}" name="sundry_code_fr" id="sundry_code_fr" />
				<input type="hidden" value="{$sundry_code_to}" name="sundry_code_to" id="sundry_code_to" />
				
				<input type="submit" style="cursor:hand" value="Back" id="Cancel" name="Cancel" title="" onclick="javascript:setActionVal('previous');"/>
				<select name="reconciletype" id="reconciletype" onchange="">
					<option>Automatically</option>
					<option>Manually</option>
				</select>
				<!-- <input type="button" style="cursor:hand" value="Reconcile" name = "finish" id = "finish" title="" onclick="getCheckedValues(this.form);"/> -->
				<input type="submit" style="cursor:hand" value="Reconcile" name = "finish" id = "finish" title='' onclick="return finishAction('finish',this.form)"/>
				<!-- input type="submit" style="cursor:hand" value="Next" id="Next" name="Next" title='' onclick="javascript:setActionVal('next')"/-->
				
			    </td>
			</tr>
		</table>
		<table id="errorTravelTable" width="85%" class="tableClass" border="0" cellspacing="1" cellpadding="1">
		<xsl:for-each select="//error">
				<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
				<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
				<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
				<xsl:if test="position() = 1">
						<tr>	
							<td class="td_leftAlign" nowrap="true" valign="bottom">
								Message :
							</td>
							<td class="td_leftAlign" nowrap="true" valign="bottom">
								Description :
							</td>
						</tr>
				</xsl:if>
				<tr>
					<td class="td_leftAlign" nowrap="true">
						<xsl:value-of select="message"/>
					</td>
					<td class="td_leftAlign" nowrap="true">
						<xsl:value-of select="description"/>
					</td>
				</tr>
		</xsl:for-each>
		<xsl:for-each select="//error">
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:if test="position() = 1">
					<xsl:if test="$type = 'W'">
					<tr>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Override Warnings :
						</td>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							<input  type="checkbox"  name="forceSave"  value="false" onClick="javascript:setChecked(this)"/>
						</td>
					</tr>
					</xsl:if>
				</xsl:if>	
		</xsl:for-each>
		</table>
	</div>
</div>
</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
