package ibase.webitm.ejb.wms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ParameterMode;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterApplyEJBLocal;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.InvAllocTraceBean;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;


@Stateless
public class SapSorderEJB extends ActionHandlerEJB implements SapSorderEJBLocal,SapSorderEJBRemote
{
	String siteCodeG = "";
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String uploadSalesOrder(String xmlString,String xtraParams,String userName, String objName) throws Exception
	{
		Connection conn = null;
		PreparedStatement pstmt = null;		
		ResultSet rs = null;
		String status ="";
		String sql = "",retString = "",siteCode = "",itemCodeOrd = "",unitRate = "",custCodeH = "",
		packCode = "",quantity = "",saleOrderNo = "",itemCodeS = "",lineNoS = "",rate = "",
		custTranId = "",newCustCode = "",ErrSaleOrder = "";
		String orderCheck = "N"; //Changed by wasim on 03-07-2015 
		int taxAmt = 0, taxAmtMagento = 0; //Changed by wasim on 03-07-2015 
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB(); //Changed by wasim on 03-07-2015 
		int count = 0;
		Document dom = null;
		double quantityS = 0;
		E12GenericUtility genericUtility = null;
		HashMap <String,String> headerValuesMap=new HashMap<String,String>();
		StringWriter errors = new StringWriter();
		java.sql.Timestamp currDate = null;
		boolean isError = false;
		String batchNo = "";

		try
		{

			System.out.println("***********************Inside SapSorderEJB**************************");

			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			/*else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}*/

			genericUtility = new E12GenericUtility();
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			genericUtility = new E12GenericUtility();
			xmlString = xmlString == null ? "" :xmlString.trim();
			System.out.println("xml String in SapSorderEJB["+xmlString+"]");

			if(xmlString.length() > 0)
			{
				String orderXml = xmlString;
				//String userName = "BASE";
				writeClientXml(orderXml);

				//orderXml = setExtraData (orderXml,userName,conn); //this will set site code,chg_term,chg_user

				//orderXml = ChangeDate(orderXml);

				String xslFileName = getXSLFileName( objName+"_sapTemplate.xsl" );//file name should be obj_name_xsl 
				/*String xslFileName = "/home/user/jboss-5.1.0.GA/server/default/deploy/"
				 					+ "ibase.ear/ibase.war/webitm/xsl/Standard/WIZARD/sapIntegration.xsl";*/
				System.out.println("XSL File Name="+xslFileName);

				//String transformXsl = (ibase.webitm.utility.GenericUtility.getInstance()).transformToString( xslFileName, sorderXml,"/home/user/jboss-5.1.0.GA/server/default/deploy/ibase.ear/ibase.war/webitm/xsl/Standard/WIZARD", "Output", ".xml" );
				String transformXsl = (genericUtility).transformToString( xslFileName, orderXml,defaultPath+"/xsl/Standard/Transform", "Output", ".xml" );
				System.out.println("After Transformation = "+ transformXsl);

				//String mappedXml = sorderMapper(transformXsl,orderXml,conn);
				String mappedXml = genericMapperNew2(transformXsl,orderXml,objName,conn);


				mappedXml = "<?xml version="+1.0+" encoding=UTF-"+8+"?>"+mappedXml;
				System.out.println("Mapped XML Received="+ mappedXml);

				batchNo = generateTranId( "I-BL", siteCode, userName, conn );//need to be checked login site and userId
				System.out.println("BatchNo = "+batchNo);

				//insertBatchLoad(batchNo,"W_SORDER",userName, conn);
				insertBatchLoad(batchNo,"W_"+objName.toUpperCase(),userName, conn);

				conn.commit();
				//ApplyMaster(batchNo,sorderXml,conn);
				//ApplyMaster(batchNo,transformXsl,conn);
				//String result = ApplyMaster(batchNo,mappedXml,conn);//Changed by wasim on 18-09-2015 to pass client IP and userName
				String result = ApplyMaster(batchNo,mappedXml,xtraParams,conn);
				status = result;
			}
			else
			{
				System.out.println("sale order xml is blank or null...................");				
			}
		}
		catch(Exception e)
		{
			isError = true;
			//writeLogAndSendMail(ErrSaleOrder,retString,conn);
			System.out.println("Exception in  UploadSorderBean  : uploadSalesOrder---------");
			e.printStackTrace();
			status= e.getMessage();
			//return errors.toString();

		}
		finally
		{
			System.out.println("isError uploadSalesOrder-------"+isError);		
			System.out.println("SapSorderEJB Status -------"+status);			
			if(isError)
			{
				conn.rollback();
				status = GetErrorXml(batchNo, status, conn);
			}
			else
			{
				conn.commit();
				//Changed by wasim on 28-09-2015 to get sorder number from batch id [START]
				status = GetResponseXml(batchNo, status, conn);
				//status = GetResponseXml(xmlString, status, conn);
				//Changed by wasim on 28-09-2015 to get sorder number from batch id [END]
			}
			if(rs != null)
			{
				rs.close();
				rs = null;				
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;				
			}
			if(conn!=null)
			{
				conn.close();
				conn = null;
			}
		}
		return status;
	}
	/*private void writeLogAndSendMail(String saleOrderNo,String errorString,Connection conn) throws Exception
	{
		String mailFlag = "",attachFlag = "",formatCode = "",attachPath = "",fileName1 = "";
		CommonWmsUtil commonWmsUtil = CommonWmsUtil.getInstance();
		DistCommon discommon = new DistCommon();
		Document dom = null;
		E12GenericUtility genericUtility = null;
		final Logger logger = Logger.getLogger(SapSorderEJB.class.getName());
		try
		{		
			genericUtility  = new E12GenericUtility();
			mailFlag = checkNull(discommon.getDisparams("999999","WMS_MAIL_FLAG",conn));
			attachFlag= checkNull(discommon.getDisparams("999999","WMS_ATTACHMENT_FLAG",conn));
			formatCode = checkNull(discommon.getDisparams("999999","WMS_FORMAT_CODE",conn));
		//	dom = commonWmsUtil.getDDDom("DDSalesConfig");
			attachPath = checkNull(genericUtility.getColumnValue("SALES_INTEGRATION_LOG_PATH", dom));
			System.out.println("mailFlag-------"+mailFlag);
			System.out.println("attachement Flag-------"+attachFlag);
			System.out.println("formatCode-------"+formatCode);
			System.out.println("attachPath-------"+attachPath);

			if(saleOrderNo != null && saleOrderNo.length() > 0)
			{
				fileName1 = saleOrderNo+"_Error";
			}
			else
			{
				fileName1 = "ErrorSalesIntegration";
			}
			uploadSalesOrder
			String separator = String.valueOf( attachPath.charAt(attachPath.length() - 1));
			if(!separator.equalsIgnoreCase(File.separator) )
			{
				attachPath = attachPath + File.separator;
			}

			System.out.println("Error File Name--->>["+fileName1+"]");			
			System.out.println("Error File Path--->>["+attachPath+"]");
			File file=new File(attachPath);
			file.mkdirs();
			File file1 = new File(attachPath + fileName1);
			file1.createNewFile();
			//file.mkdirs();
			System.out.println("PATH123 :"+file1.getAbsolutePath());
			Handler fh = new FileHandler(file1.getAbsolutePath(), true);
			fh.setFormatter(new SimpleFormatter());  // Set the log format								
			logger.addHandler(fh);								
			logger.setLevel(Level.FINE);								
			logger.log(Level.SEVERE, errorString, errorString);								
		    fh.flush();
		    fh.close();	    


			//commonWmsUtil.sendMail(mailFlag,attachFlag,formatCode,attachPath +fileName1,errorString,conn);		
		}
		catch(Exception e)
		{

		}
	}*/
	/*private  void setNodeValue( Document dom, String nodeName, String nodeVal ) throws Exception
	{
		Node tempNode = dom.getElementsByTagName( nodeName ).item(0);

		if( tempNode != null )
		{
			if( tempNode.getFirstChild() == null )
			{
				CDATASection cDataSection = dom.createCDATASection( nodeVal );
				tempNode.appendChild( cDataSection );
			}
			else
			{
				tempNode.getFirstChild().setNodeValue(nodeVal);
			}
		}
		tempNode = null;
	}*/
	public String getColumnDescr(Connection conn, String columnName ,String tableName, String columnName2, String value) throws ITMException,Exception 
	{

		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";
		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{					
				findValue = checkNull(rs.getString(1));					
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
		}
		catch(Exception e)
		{				
			System.out.println("Exception in getColumnDescr ");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;    	    		
			}
			if(pstmt != null)
			{    			
				pstmt.close();    	    	
				pstmt = null;	
			}
		}
		System.out.println("returning String from getColumnDescr " + findValue);
		return findValue;

	}

	public String confirmSaleOrder(String businessObj, String tranIdFr,String xtraParams, String forcedFlag, Connection conn) throws ITMException
	{

		String methodName = "";
		String compName = "";
		String retString = "";
		String serviceCode = "";
		String serviceURI = "";
		String actionURI = "";
		String sql = "";
		PreparedStatement psmt = null;
		ResultSet rs = null;
		boolean isError = false;

		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			System.out.println("-------in confirmSaleOrder mothod----------------");			
			tranIdFr=tranIdFr==null ? "" :tranIdFr.trim();
			System.out.println("Tran id for sale order--->>"+tranIdFr+"]");
			methodName = "gbf_post";
			actionURI = "http://NvoServiceurl.org/" + methodName;

			sql = "SELECT SERVICE_CODE,COMP_NAME FROM SYSTEM_EVENTS WHERE OBJ_NAME = ? AND EVENT_CODE = 'pre_confirm' ";
			psmt = conn.prepareStatement(sql);
			psmt.setString(1,businessObj);
			rs = psmt.executeQuery();
			if ( rs.next() )
			{
				serviceCode = rs.getString("SERVICE_CODE");
				compName = rs.getString("COMP_NAME");
			}
			// Changed by Manish on 01/04/16 for max cursor issue [start]
			if (psmt != null)
			{
				psmt.close();
				psmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			// Changed by Manish on 01/04/16 for max cursor issue [end]
			compName=compName==null ? "" :compName.trim();
			System.out.println("serviceCode = ["+serviceCode+"]   compName ["+compName+"]");
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
			psmt = conn.prepareStatement(sql);
			psmt.setString(1,serviceCode);
			rs = psmt.executeQuery();
			if ( rs.next() )
			{
				serviceURI = rs.getString("SERVICE_URI");
			}
			// Changed by Manish on 01/04/16 for max cursor issue [start]
			if (psmt != null)
			{
				psmt.close();
				psmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			// Changed by Manish on 01/04/16 for max cursor issue [end]
			serviceURI=serviceURI==null ? "" :serviceURI.trim();
			System.out.println("serviceURI = ["+serviceURI+"]---> compName = ["+compName+"]");
			Service service = new Service();
			Call call = (Call)service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(serviceURI));
			call.setOperationName( new javax.xml.namespace.QName("http://NvoServiceurl.org", methodName ) );
			call.setUseSOAPAction(true);
			call.setSOAPActionURI(actionURI);
			Object[] aobj = new Object[4];

			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "tran_id"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "forced_flag"), XMLType.XSD_STRING, ParameterMode.IN);

			aobj[0] = new String(compName);
			aobj[1] = new String(tranIdFr);
			aobj[2] = new String("");
			aobj[3] = new String(forcedFlag);
			//System.out.println("@@@@@@@@@@loginEmpCode:" +genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode")+":");
			System.out.println("@@@@@@ call.setReturnType(XMLType.XSD_STRING) executed........");
			call.setReturnType(XMLType.XSD_STRING);

			retString = (String)call.invoke(aobj);

			System.out.println("Confirm Complete @@@@@@@@@@@ Return string from NVO is:==>["+retString+"]");

		}
		catch(Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{		
			try{
				if (psmt != null )
				{
					psmt.close();
					psmt = null;
				}	
				if (rs !=null)
				{
					rs.close();
					rs=null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception inCalling confirmed");
				e.printStackTrace();
				try{
					conn.rollback();

				}catch (Exception s)
				{
					System.out.println("Unable to rollback");
					s.printStackTrace();
				}
				throw new ITMException(e);
			}

		}
		return retString;

	}
	private String insertInCustomerMaster (HashMap <String,String>headerValesMap,String xtraParams,Connection conn) throws Exception
	{
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		int count = 0;
		String sql="",loginCode = "",remoteHost = "",stateCodeDlv = "",stationCode = "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		loginCode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
		Calendar currentDate = Calendar.getInstance();
		SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
		String currDate = simpleDateFormatObj.format(currentDate.getTime());
		remoteHost = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
		java.sql.Timestamp currentDate1 = new Timestamp(System.currentTimeMillis());

		//currDate =genericUtility.getValidDateString( tranDate, genericUtility.getApplDateFormat(),dateFormat );
		System.out.println("currDate---->>"+currDate);
		System.out.println("----------new Customer found ---------------------- ");

		try
		{
			if(headerValesMap.containsKey("stan_code"))
			{
				stationCode = checkNull(headerValesMap.get("stan_code"));
				sql = "SELECT COUNT(*) FROM STATION WHERE STAN_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, stateCodeDlv);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					count = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(count == 0)
				{
					stationCode = "UKE40";
				}
			}
			else
			{
				stationCode = "UKE40";
			}
			if(headerValesMap.containsKey("state_code__dlv"))
			{
				stateCodeDlv = checkNull(headerValesMap.get("state_code__dlv"));
				sql = "SELECT COUNT(*) FROM STATE WHERE STATE_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, stateCodeDlv);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					count = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(count == 0)
				{
					stateCodeDlv = "UKENG";
				}
			}
			else
			{
				stateCodeDlv = "UKENG";
			}

			sql = "insert into customer ( cust_code,cust_type,cust_name,sh_name,group_code,addr1,addr2,addr3,city,state_code,"
				+ "pin,count_code,stan_code, tele1,tele2,tele3,fax,cust_code__bil,credit_lmt,chq_name,"
				+ "curr_code,acct_code__ar,cctr_code__ar,tax_chap,cr_term,tran_code,sales_pers,channel_partner,site_code,dis_link,"
				+ "fin_link,black_listed,contact_code,trans_mode,rcp_mode,ignore_credit,pending_order,ignore_days,round,round_to,"
				+ "located_at,stop_business,sales_option,dlv_term,hold_shipment,acct_code__adv,cctr_code__adv,site_code__pbus,part_qty,split_factor,"
				+ "curr_code__frt,curr_code__ins,adhoc_repl_perc,full_name,rate_round,rate_round_to,master_pack,cancel_bo,single_lot,asn_reqd,"
				+ "return_allowed,edi_reqd,chg_date,chg_term,chg_user,wave_type,email_addr) "//6
				+ "values (?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?)"; //67
			pstmt=conn.prepareStatement(sql);

			pstmt.setString(1, headerValesMap.get("cust_code")); //cust_code
			pstmt.setString(2,"D"); //cust_type
			pstmt.setString(3, headerValesMap.get("buyer_name")); //cust_name 
			pstmt.setString(4, headerValesMap.get("buyer_name")); //sh_name  
			pstmt.setString(5, headerValesMap.get("cust_code"));//group_code
			pstmt.setString(6, headerValesMap.get("dlv_add1"));//addr1
			pstmt.setString(7, headerValesMap.get("dlv_add2"));//addr2
			pstmt.setString(8, headerValesMap.get("dlv_add2"));//addr3
			pstmt.setString(9, headerValesMap.get("dlv_city"));//city

			pstmt.setString(10, stateCodeDlv);//state_code

			//pstmt.setString(11, headerValesMap.get("dlv_pin"));//pin
			String dlvPin=  headerValesMap.get("dlv_pin");
			if(dlvPin.length() > 7)
			{
				pstmt.setString(11, dlvPin);//pin
			}
			else
			{	    		
				dlvPin = "000000" + dlvPin;
				dlvPin = dlvPin.substring(dlvPin.length() - 6);
				pstmt.setString(11, dlvPin);//pin
			}
			pstmt.setString(12, headerValesMap.get("count_code__dlv"));//count_code
			pstmt.setString(13, stationCode);//stan_code    			
			pstmt.setString(14, headerValesMap.get("tel1__dlv"));//tele1
			pstmt.setString(15, headerValesMap.get("tel2__dlv"));//tele2
			pstmt.setString(16, headerValesMap.get("tel3__dlv"));//tele3
			pstmt.setString(17, headerValesMap.get("fax__dlv"));//fax
			pstmt.setString(18, headerValesMap.get("cust_code"));//cust_code__bil
			pstmt.setString(19, "0");//credit_lmt
			pstmt.setString(20, "");//chq_name


			pstmt.setString(21, headerValesMap.get("curr_code"));//curr_code
			pstmt.setString(22, "1030001");//acct_code__ar
			pstmt.setString(23, "CC01");//cctr_code__ar
			pstmt.setString(24, "");//tax_chap
			pstmt.setString(25, headerValesMap.get("cr_term"));//cr_term
			pstmt.setString(26, headerValesMap.get("tran_code"));//tran_code
			pstmt.setString(27, "SP00001");//sales_pers
			pstmt.setString(28, "N");//channel_partner
			pstmt.setString(29, headerValesMap.get("site_code"));//site_code
			pstmt.setString(30, "N");//dis_link

			pstmt.setString(31, "N");//fin_link
			pstmt.setString(32, "N");//black_listed
			pstmt.setString(33, "DUMMY");//contact_code
			pstmt.setString(34, headerValesMap.get("trans_mode"));//trans_mode
			pstmt.setString(35, headerValesMap.get("rcp_mode"));//rcp_mode
			pstmt.setString(36, "0");//ignore_credit
			pstmt.setString(37,"N");//pending_order
			pstmt.setString(38, "0");//ignore_days
			pstmt.setString(39, "N");//round
			pstmt.setString(40, "0");//round_to

			pstmt.setString(41, "");//located_at
			pstmt.setString(42, "N");//stop_business
			pstmt.setString(43, "A");//sales_option
			pstmt.setString(44, "NA");//dlv_term
			pstmt.setString(45, "N");//hold_shipment
			pstmt.setString(46, "1030001");//acct_code__adv
			pstmt.setString(47, "CC01");//cctr_code__adv
			pstmt.setString(48, "");//site_code__pbus
			pstmt.setString(49, "0");//part_qty
			pstmt.setString(50, "0");//split_factor

			pstmt.setString(51, headerValesMap.get("curr_code"));//curr_code__frt  
			pstmt.setString(52, headerValesMap.get("curr_code"));//curr_code__ins
			pstmt.setString(53, "0");//adhoc_repl_perc
			pstmt.setString(54, headerValesMap.get("buyer_name"));//full_name
			pstmt.setString(55, "N");//rate_round
			pstmt.setString(56, "0");//rate_round_to
			pstmt.setString(57, "N");//master_pack
			pstmt.setString(58, "0");//cancel_bo
			pstmt.setString(59, "N");//single_lot
			pstmt.setString(60, "N");//asn_reqd

			pstmt.setString(61, "N");//return_allowed
			pstmt.setString(62, "N");//edi_reqd
			System.out.println("before Time stamp chg_date tranDate...................");		
			//pstmt.setString(63, currDate);//chg_date tranDate
			pstmt.setTimestamp(63, currentDate1);
			pstmt.setString(64, remoteHost);//chg_term
			pstmt.setString(65, loginCode);//chg_user
			pstmt.setString(66, "W0001");//wave_type
			pstmt.setString(67, headerValesMap.get("notify_to"));//email_addr

			int rows=pstmt.executeUpdate();
			System.out.println("Customer rows inserted------->>"+rows);    	
			if(rows > 0)
				return "Success";
			else
				return "Error";
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}


	}
	private String sorderAllocate(String saleOrder, String lineNo, String itemCode, double allocQty,String xtraParams, Connection conn ) throws ITMException
	{


		System.out.println("updateSOrder calling ....**************..........["+saleOrder+"]");
		String getDataSql = null;
		String sorditemSql=null;
		String itemCodeOrd = null ;
		String unitStd = null ;
		String lotSl= null;
		String lotNo = null;
		String locCode = null;
		String itemShDescr = null;
		String locDescr = null;
		String unit = null;
		String grade = null;
		String siteCodeMfg =null;
		String itemRef = null;
		String status =null;
		//Changed By Pragyan 
		String invStat = "";
		//Changed By Pragyan 18/02/13 to check previous replenishment Location.start
		String replHistStr = "",prvReplID="",prvLocCodeTo="",prvPickOrd="",isRepl="",replQuantity="";
		String locType = "",locTypeParent="";	
		int prvReplLineNo = 0;	
		int prvPickLineNo = 0;
		int locZonePref = 0;
		double height = 0,len = 0,width =0,netwt=0;
		int noArt;
		java.sql.Date expDate = new java.sql.Date(System.currentTimeMillis());
		java.sql.Date mfgDate = new java.sql.Date(System.currentTimeMillis());
		java.sql.Date dateAlloc= new java.sql.Date(System.currentTimeMillis());
		String updateSorditem = null;
		String insertSql = null;
		String updateSordalloc = null;
		String updateSql= null;
		String flag = null;
		//Changed by Rohan on 29-12-11 as said by gulzar.start
		String resrvLoc  = "",casePickLoc="",activePickLoc="",deepStoreLoc="",partialResrvLoc="";		
		double stockQuantity = 0;
		double qtyAvailAlloc = 0;
		double lotQtyToBeAllocated = 0;
		double qtyDesp =0;
		double quantity =0;
		double convQtyStduom = 0 ;
		double quantityStduom = 0 ;
		double pendingQuantity = 0;
		int intCnt=0;
		int updCnt=0;
		String orderByStkStr = "";
		String errString = "";
		String error = "";
		String errCode = "",sql="",expLev="";
		//Connection conn = null;
		PreparedStatement pstmtStock = null,pstmt=null;

		PreparedStatement pstmtStockInsertSordAlloc = null;
		//Changed by Rohan on 13-04-12 To create prepared statement & result set.start
		String manStockData = ""; 
		//PreparedStatement pstmt = null;
		ResultSet rSet = null;
		//Change by Rohan on 4/7/12 To add min_shilf_life
		String minShelf = "";
		PreparedStatement pstmtShelf = null;
		ResultSet rSetShelf = null;
		int minShelfLife = 0; 
		//Changed by Rohan on 27-08-13 for define variable
		int maxShelfLife = 0;
		//Change by Rohan on 4/7/12 To add min_shilf_life
		Statement st = null;
		ResultSet rs = null ;
		ResultSet rsSItem = null;
		HashMap tempMap = null;
		ArrayList tempList = null;
		HashMap strAllocate = null;
		boolean isStockToDock = false;
		boolean isActives = false;

		ArrayList tempListForRepl =null;//Added by Ashish
		String directPickLoc = "";
		double palletVolume = 0.0 ,packSize = 0.0, perItemVolume = 0.0,
		caseVolume = 0.0,packSize1 = 0.0,caseVolume1 = 0.0,
		caseWeight =0.0,itemWeight = 0.0,caseCount =0.0;
		//Changed By Pragyan 06-DEC-13 to get Stock alloc quantity as per KB sir
		double stkAllocQty = 0.0;
		String hazardous = "";
		//changed by pragyan on 31/05/14 for single lot
		String currentSelectdLotNo = "";
		InvAllocTraceBean invAllocTrace = new InvAllocTraceBean();
		DistCommon discommon = new DistCommon();
		E12GenericUtility genericUtility=new E12GenericUtility();
		try
		{			
			String dbDateFormat = genericUtility.getDBDateFormat();
			String applDateFormat = genericUtility.getApplDateFormat();
			java.util.Date currDate1 = new java.util.Date();
			SimpleDateFormat sdf = new SimpleDateFormat(applDateFormat);
			String currDateStr = sdf.format(currDate1);
			java.sql.Timestamp tranDate = java.sql.Timestamp.valueOf(genericUtility.getValidDateString( currDateStr , applDateFormat, dbDateFormat ) + " 00:00:00.0") ;

			//siteCode = genericUtility.getColumnValue("site_code",headerDom);
			System.out.println("siteCode------>>>>"+ this.siteCodeG+"]");
			sql="SELECT EXP_LEV FROM SORDITEM WHERE SALE_ORDER = ? AND LINE_NO = ?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1,saleOrder);
			pstmt.setString(2,lineNo);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				expLev=checkNull(rs.getString(1));				
			}	
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			System.out.println("expLev---------->>["+expLev+"]");
			//palletVolume  = Double.parseDouble(discommon.getDisparams("999999","PER_PALLET__VOLUME",conn));
			resrvLoc  = discommon.getDisparams("999999","RESERV_LOCATION",conn);
			casePickLoc  = discommon.getDisparams("999999","CASE_PICK_INVSTAT",conn);
			activePickLoc  = discommon.getDisparams("999999","ACTIVE_PICK_INVSTAT",conn);
			deepStoreLoc = discommon.getDisparams("999999","DEEP_STORE_INVSTAT",conn);
			//partialResrvLoc = discommon.getDisparams("999999","PRSRV_INVSTAT",conn);
			//directPickLoc = genericUtility.getColumnValue("direct_pick_loc",headerDom);
			System.out.println("CASE_PICK_INVSTAT"+casePickLoc+"ACTIVE_PICK_INVSTAT"+activePickLoc+"RESERV_LOCATION"+resrvLoc+"Reserve Location["+partialResrvLoc+"]");


			getDataSql = "SELECT STOCK.LOT_NO,STOCK.LOT_SL,"
				+"STOCK.LOC_CODE, "
				+"STOCK.UNIT,  "
				+"(STOCK.QUANTITY - STOCK.ALLOC_QTY - (CASE WHEN STOCK.HOLD_QTY IS NULL THEN 0 ELSE STOCK.HOLD_QTY END)) AS QTY_AVAIL_ALLOC ,"
				+"STOCK.GRADE,STOCK.EXP_DATE,STOCK.CONV__QTY_STDUOM,STOCK.QUANTITY, " 
				+"STOCK.MFG_DATE,STOCK.SITE_CODE__MFG, "						  
				+"STOCK.NO_ART,INVSTAT.INV_STAT,ITEM.LOC_TYPE__PARENT,ITEM.LOC_TYPE,ITEM.LOC_ZONE__PREF,STOCK.ALLOC_QTY "  
				+"FROM STOCK,ITEM,LOCATION,INVSTAT " 
				+"WHERE (ITEM.ITEM_CODE = STOCK.ITEM_CODE) "
				+"AND (LOCATION.LOC_CODE = STOCK.LOC_CODE ) "
				+"AND (LOCATION.INV_STAT = INVSTAT.INV_STAT) "
				+"AND INVSTAT.AVAILABLE = 'Y' "
				+"AND STOCK.ITEM_CODE = ? AND STOCK.SITE_CODE = ? "
				+"AND (STOCK.QUANTITY - STOCK.ALLOC_QTY - CASE WHEN STOCK.HOLD_QTY IS NULL THEN 0 ELSE STOCK.HOLD_QTY END) > 0  " // 25/06/12 manoharan 
				+"AND NOT EXISTS (SELECT 1 FROM INV_RESTR I WHERE I.INV_STAT = INVSTAT.INV_STAT AND I.REF_SER = 'S-DSP' ) "
				+" AND LOCATION.INV_STAT IN(?,?,?,?,?) ORDER BY STOCK.EXP_DATE,INVSTAT.ALLOC_PREF, STOCK.LOC_CODE ";
			pstmtStock = conn.prepareStatement(getDataSql);

			pstmtStock.setString(1,itemCode);
			pstmtStock.setString(2,siteCodeG);
			pstmtStock.setString(3,resrvLoc);
			pstmtStock.setString(4,casePickLoc);
			pstmtStock.setString(5,activePickLoc);
			pstmtStock.setString(6,deepStoreLoc);
			pstmtStock.setString(7,partialResrvLoc);
			rs = pstmtStock.executeQuery();
			System.out.println("siteCode------"+ siteCodeG);
			System.out.println("itemCode------"+ itemCode);
			System.out.println("Select completed");


			while(rs.next())
			{
				isStockToDock = false;
				System.out.println( "INSIDE WHILE LOOP...........For allocation.["+allocQty);
				//LOT_NO
				lotNo = rs.getString(1);
				//LOT_SL
				lotSl = rs.getString(2);
				//LOC_CODE
				locCode = rs.getString(3);
				//UNIT
				unit = rs.getString(4);
				//QTY_AVAIL_ALLO
				qtyAvailAlloc = rs.getDouble(5);
				System.out.println("qtyAvailAlloc--------------->"+qtyAvailAlloc);
				//GRADE
				grade = rs.getString(6);
				//EXP_DATE
				expDate =rs.getDate(7);
				//CONV__QTY_STDUOM
				convQtyStduom=rs.getDouble(8);
				//QUANTITY
				quantity= rs.getDouble(9);
				//MFG_DATE
				mfgDate = rs.getDate(10);
				//SITE_CODE__MFG
				siteCodeMfg = rs.getString(11);
				noArt = rs.getInt(12);
				invStat = rs.getString(13);
				locTypeParent = checkNull(rs.getString(14)); //Changes done by chandni 08-06-12(instead of loc_type, loc_type__parent should be selected)
				//Changed by sankara on 03-08-2012 for adding locType
				locType= rs.getString(15);
				locZonePref = rs.getInt(16);
				//Changed By Pragyan 06-DEC-13 to get Stock alloc quantity as per KB sir
				stkAllocQty = rs.getDouble(17);


				//Changed By Pragyan 31-MAY-14 for single lot start


				HashMap itmVolumeMap = getItemVoumeMap(itemCode,lotNo,conn);
				double packSizeActive = (Double)itmVolumeMap.get("PACK_SIZE");
				//Changed by Rohan on 8/2/12 to get packsize of item.end
				System.out.println("GOING FOR populateReplHistory************************");
				System.out.println("Return qty from function:::::"+qtyAvailAlloc);

				invStat = invStat != null?invStat.trim():"";
				System.out.println("allocQty"+allocQty+"qtyAvailAlloc:::"+qtyAvailAlloc);




				if (allocQty >= qtyAvailAlloc)
				{
					lotQtyToBeAllocated = qtyAvailAlloc;
				}
				else
				{
					System.out.println("Enetr in else");
					lotQtyToBeAllocated = allocQty;
				}


				System.out.println("Stock To Dock change["+isStockToDock+"]");

				allocQty -= lotQtyToBeAllocated ;

				System.out.print("AllocQty = " + lotQtyToBeAllocated);
				System.out.print("AllocQty2 = " + allocQty);
				if (lotQtyToBeAllocated > 0) 
				{		

					invStat = invStat != null?invStat.trim():"";


					System.out.println("Finally  Loc Code["+locCode+"]");

					strAllocate = new HashMap();
					strAllocate.put("tran_date",tranDate);
					strAllocate.put("ref_ser","S-ALC");
					strAllocate.put("ref_id",saleOrder);
					strAllocate.put("ref_line", "" + lineNo);
					strAllocate.put("site_code",siteCodeG);
					strAllocate.put("item_code",itemCode);
					strAllocate.put("loc_code",locCode);
					strAllocate.put("lot_no",lotNo);
					strAllocate.put("lot_sl",lotSl);
					strAllocate.put("alloc_qty",new Double(lotQtyToBeAllocated));
				    strAllocate.put("chg_user",genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode"));
					strAllocate.put("chg_term",genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId"));
					strAllocate.put("chg_win","W_SORDER");

					System.out.println("To allocate ::: " + strAllocate.toString()+"]lotQtyToBeAllocated["+lotQtyToBeAllocated+"]");

					errString = invAllocTrace.updateInvallocTrace(strAllocate, conn);


					System.out.println("invAllocTrace errString ::: " + errString);
					if (errString != null && errString.trim().length() > 0 )
					{
						break;
					}
					strAllocate = null;		

					sorditemSql = "SELECT ITEM_CODE,ITEM_CODE__ORD,UNIT, QTY_DESP, ITEM_REF,"
						+" QUANTITY - QTY_DESP PENDING_QUANTITY "
						+" FROM SORDITEM WHERE SALE_ORDER = '" + saleOrder + "' "
						+" AND LINE_NO = '" + lineNo + "' ";

					System.out.println("sorditemSql:::"+sorditemSql);
					st = conn.createStatement();
					rsSItem = st.executeQuery(sorditemSql);
					if (rsSItem.next())
					{
						//ITEM_CODE
						itemCode = rsSItem.getString(1);
						System.out.println("itemCode::::"+ itemCode);
						//ITEM_CODE__ORD
						itemCodeOrd = rsSItem.getString(2);	
						//UNIT
						unitStd = rsSItem.getString(3);	
						//QTY_DESP
						qtyDesp = 0;
						//ITEM_REF
						itemRef = rsSItem.getString(5);	
						//PENDING_QUANTITY
						pendingQuantity = rsSItem.getDouble(6);
					}					
					rsSItem.close();

					//Changed by sumit on 31/01/13 changing below quantity as per unit start
					pendingQuantity = getStockQtyAfterConvert(saleOrder, lineNo, itemCodeOrd, pendingQuantity, 1, conn);					
					updateSorditem ="UPDATE SORDITEM  SET QTY_ALLOC = CASE WHEN QTY_ALLOC IS NULL THEN 0 ELSE QTY_ALLOC END  +   " + new Double(lotQtyToBeAllocated).toString()
					+" WHERE SALE_ORDER = '" + saleOrder + "' "
					+" AND LINE_NO = '" + lineNo + "' "
					+" AND EXP_LEV = '" + expLev + "' ";

					System.out.println("updateSql------->"+updateSorditem);
					st.executeUpdate(updateSorditem);
					System.out.println("UPDATE  SUCCESS FOR SORDITEM....>>>>>>>>");

					sorditemSql = "SELECT COUNT(1) FROM SORDALLOC " 
						+ " WHERE SALE_ORDER = '" + saleOrder + "' "
						+ " AND LINE_NO = '" + lineNo + "' "
						+ " AND EXP_LEV = '" + expLev + "' "
						+ " AND ITEM_CODE__ORD = '" + itemCodeOrd + "' "
						+ " AND ITEM_CODE = '" + itemCode + "' "
						+ " AND LOT_NO = '" + lotNo + "' "
						+ " AND LOT_SL = '" + lotSl + "' "
						+ " AND LOC_CODE = '" + locCode + "' " ;
					rsSItem =  st.executeQuery(sorditemSql);
					int count = 0 ;
					if (rsSItem.next())
					{
						count = rsSItem.getInt(1);
					}
					if (count > 0 )
					{					
						//updateSql = "UPDATE SORDALLOC SET QTY_ALLOC =  QTY_ALLOC + " + new Double(lotQtyToBeAllocated).toString()
						updateSql = "UPDATE SORDALLOC SET WAVE_FLAG = 'Y' , QTY_ALLOC =  QTY_ALLOC + " + new Double(lotQtyToBeAllocated).toString()
						+ " WHERE SALE_ORDER = '" + saleOrder + " ' "
						+ " AND LINE_NO = '" + lineNo + "' "
						+ " AND EXP_LEV = '" + expLev + "' "
						+ " AND ITEM_CODE__ORD = '" + itemCodeOrd + "' "
						+ " AND ITEM_CODE = '" + itemCode + "' "
						+ " AND LOT_NO = '" + lotNo + "' "
						+ " AND LOT_SL = '" + lotSl + "' "
						+ " AND LOC_CODE = '" + locCode + "' " ;
						System.out.println("updateSql:::>>>>"+ updateSql);	
						st.executeUpdate(updateSql);
						System.out.println("UPDATE  SUCCESS FOR SORDALLOC....");
					}
					else
					{					
						insertSql ="INSERT INTO SORDALLOC (SALE_ORDER,LINE_NO,EXP_LEV,ITEM_CODE__ORD,SITE_CODE ,"
							+"ITEM_CODE,QUANTITY ,LOT_NO, LOT_SL, LOC_CODE, UNIT, QTY_ALLOC,"
							+"ITEM_REF, DATE_ALLOC, STATUS,ITEM_GRADE, EXP_DATE, ALLOC_MODE, "
							+" CONV__QTY_STDUOM, UNIT__STD, QUANTITY__STDUOM, "
							//+"MFG_DATE, SITE_CODE__MFG ) "
							+"MFG_DATE, SITE_CODE__MFG,WAVE_FLAG ) "
							+"VALUES ( ?, ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? ,"
							//+" ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) " ;
							+" ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,? ) " ;

						pstmtStockInsertSordAlloc = conn.prepareStatement(insertSql);

						System.out.println("Insert Sql :"+ insertSql );					
						pstmtStockInsertSordAlloc.setString(1, saleOrder);
						System.out.println("saleOrder------->"+saleOrder);					
						pstmtStockInsertSordAlloc.setString(2, lineNo);
						System.out.println("lineNo------->"+lineNo);					
						pstmtStockInsertSordAlloc.setString(3, expLev);
						System.out.println("EXP_LEV------->"+expLev);					
						pstmtStockInsertSordAlloc.setString(4, itemCodeOrd);
						System.out.println("itemCode------->"+itemCodeOrd);					
						pstmtStockInsertSordAlloc.setString(5, siteCodeG);
						System.out.println("siteCode------->"+siteCodeG);					
						pstmtStockInsertSordAlloc.setString(6, itemCode);
						System.out.println("itemCode------->"+itemCode);					
						pstmtStockInsertSordAlloc.setDouble(7, pendingQuantity);
						System.out.println("pendingQuantity------->"+pendingQuantity);

						pstmtStockInsertSordAlloc.setString(8, lotNo);
						System.out.println("lotNo------->"+lotNo);					
						pstmtStockInsertSordAlloc.setString(9, lotSl);
						System.out.println("lotSl------->"+lotSl);				
						pstmtStockInsertSordAlloc.setString(10, locCode);
						System.out.println("locCode------->"+locCode);					
						pstmtStockInsertSordAlloc.setString(11, unit);
						System.out.println("unit------->"+unit);				
						pstmtStockInsertSordAlloc.setDouble(12, lotQtyToBeAllocated);
						System.out.println("lotQtyToBeAllocated------->"+lotQtyToBeAllocated);

						pstmtStockInsertSordAlloc.setString(13,itemRef);
						System.out.println("itemRef------->"+itemRef);					
						pstmtStockInsertSordAlloc.setDate(14,dateAlloc);
						System.out.println("dateAlloc------->"+dateAlloc);					
						pstmtStockInsertSordAlloc.setString(15,"P");
						System.out.println("status------->P");					
						pstmtStockInsertSordAlloc.setString(16,grade);
						System.out.println("grade------->"+grade);					
						pstmtStockInsertSordAlloc.setDate(17,expDate);
						System.out.println("expDate------->"+expDate);					
						pstmtStockInsertSordAlloc.setString(18,"M");					
						pstmtStockInsertSordAlloc.setDouble(19,convQtyStduom);
						System.out.println("convQtyStduom------->"+convQtyStduom);					
						pstmtStockInsertSordAlloc.setString(20,unitStd);
						System.out.println("unitStd------->"+unitStd);					
						quantityStduom = convQtyStduom * lotQtyToBeAllocated ;					
						pstmtStockInsertSordAlloc.setDouble(21,quantityStduom);
						System.out.println("quantityStduom------->"+quantityStduom);					
						pstmtStockInsertSordAlloc.setDate(22,mfgDate);
						System.out.println("mfgDate------->"+mfgDate);					
						pstmtStockInsertSordAlloc.setString(23,siteCodeMfg);
						System.out.println("siteCodeMfg------->"+siteCodeMfg);
						pstmtStockInsertSordAlloc.setString(24,"N");
						System.out.println("WAVE FLAG-------> Y");


						intCnt = pstmtStockInsertSordAlloc.executeUpdate();
						System.out.println("insertion  success ...............>>>>>>>>");
						pstmtStockInsertSordAlloc.close();
					}//end else
					st.close();
					//Changed By Pragyan.end



				}//end of if(lotQtyToBeAllocated > 0)
			}//end of while

			if(st != null)
			{
				st.close();
				st = null;
			}
			if(pstmtStock != null)
			{
				pstmtStock.close();
				pstmtStock = null;
			}
			if(pstmtStockInsertSordAlloc != null)
			{
				pstmtStockInsertSordAlloc.close();
				pstmtStockInsertSordAlloc = null;
			}
			if(pstmtShelf != null)
			{
				pstmtShelf.close();
				pstmtShelf = null;
			}
			if(rSetShelf != null)
			{
				rSetShelf.close();
				rSetShelf = null;
			}
			if(rsSItem != null)
			{
				rsSItem.close();
				rsSItem = null;
			}
			if(rs != null)
			{
				rs.close();
				rs =null;
			}
			//Changed by Rohan on 29-08-12 for bug fixing
			//pstmtStock.clearParameters();

		}
		catch(SQLException se)
		{
			System.out.println("SQLException :" + se);	
			se.printStackTrace();
			errString = se.getMessage();
			//return errString;
			throw se;
		}

		catch(Exception e)
		{
			System.out.println("Exception :" + e);	
			errString = e.getMessage();
			e.printStackTrace();	
			throw e;


		}
		finally
		{
			try
			{
				if(conn != null)
				{	
					if(st != null)
					{
						st.close();
						st = null;
					}
					if(pstmtStock != null)
					{
						pstmtStock.close();
						pstmtStock = null;
					}
					if(rs != null)
					{
						rs.close();
						rs =null;
					}

					if(rsSItem != null)
					{
						rsSItem.close();
						rsSItem = null;
					}
					if(pstmtStockInsertSordAlloc != null)
					{
						pstmtStockInsertSordAlloc.close();
						pstmtStockInsertSordAlloc = null;
					}
					if(st != null)
					{
						st.close();
						st = null;
					}
					if(pstmtShelf != null)
					{
						pstmtShelf.close();
						pstmtShelf = null;
					}
					if(rSetShelf != null)
					{
						rSetShelf.close();
						rSetShelf = null;
					}
					//conn.close();
					//conn = null;
				}
			}
			catch(Exception e)
			{
				errString = e.getMessage();
				e.printStackTrace();
				return errString ;

			}
			return errString;
		}



	}

	/*private String generateTranId( String windowName, String siteCode, String tranDateStr, Connection conn )throws ITMException,Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";	

		try
		{
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			//System.out.println("selSql :"+selSql);
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +		"<tran_id></tran_id>";
			xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);

		}
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{

			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		return tranId;
	}//generateTranTd()
	 */	private HashMap getItemVoumeMap(String itemCode,String lotNo,Connection con)throws Exception
	 {
		 double packSize = 0,itemSize = 0,lotSize = 0;
		 PreparedStatement pstmt = null;
		 //Changed By Pragyan 12/03/13 To set hazardous item check
		 String sql="",hazardous = "";
		 //Changed By Rekha To add columns required for ADSI
		 String harmonizCode = "",harmonizDescr = "",originCountry = "";
		 ResultSet rs = null;
		 double itmLen = 0,itmWidth = 0,itmHeight = 0,itemWeight = 0,lotLen = 0 ,lotHeight = 0,lotWidth = 0,lotWeight = 0;
		 HashMap dataVolumeMap = new HashMap();

		 try {		
			 sql = "SELECT I.LENGTH ITEM_LEN,I.WIDTH ITEM_WID,I.HEIGHT ITEM_HEIGHT,I.GROSS_WEIGHT ITEM_WEIGHT,I.HAZARDOUS HAZARD, " 
				 +" I.HARMONIZATION_NO HARMONIZATION_NO,I.HARMONIZATION_DESCR HARMONIZATION_DESCR,I.COUNT_CODE__MFG ORIGIN_COUNTRY,"
				 +" L.LENGTH LITEM_LEN,L.WIDTH LITEM_WID,L.HEIGHT LITEM_HEIGHT,L.SHIPPER_SIZE SHIPSIZE,L.GROSS_WEIGHT LOT_WEIGHT FROM"
				 +" ITEM I,ITEM_LOT_PACKSIZE L"
				 +" WHERE I.ITEM_CODE = L.ITEM_CODE"
				 +" AND L.LOT_NO__FROM <= ? AND L.LOT_NO__TO >= ?"
				 +" AND  I.ITEM_CODE = ?";


			 pstmt = con.prepareStatement(sql);
			 if(lotNo != null && lotNo.length() > 0)
			 {
				 pstmt.setString(1, lotNo);
				 pstmt.setString(2, lotNo);
			 }
			 else
			 {				
				 return dataVolumeMap = getItemVoumeMap(itemCode, con);
				 //Changed By Pragyan 05-DEC-13 as per KB sir in case of blank lot no take the data for max of lot_no__to.end
			 }
			 pstmt.setString(3, itemCode);
			 rs = pstmt.executeQuery();

			 if(rs.next())
			 {
				 itmLen = rs.getDouble("ITEM_LEN");
				 itmWidth = rs.getDouble("ITEM_WID");
				 itmHeight = rs.getDouble("ITEM_HEIGHT");
				 itemWeight = rs.getDouble("ITEM_WEIGHT");
				 //Changed By Pragyan 12/03/13 To set hazardous item check
				 hazardous = rs.getString("HAZARD");
				 lotLen = rs.getDouble("LITEM_LEN");
				 lotWidth = rs.getDouble("LITEM_WID");
				 lotHeight = rs.getDouble("LITEM_HEIGHT");				
				 packSize = rs.getDouble("SHIPSIZE");				
				 lotWeight = rs.getDouble("LOT_WEIGHT");
				 harmonizCode = rs.getString("HARMONIZATION_NO");
				 harmonizDescr = rs.getString("HARMONIZATION_DESCR");
				 originCountry = rs.getString("ORIGIN_COUNTRY");
			 }			

			 itemSize = itmLen * itmWidth * itmHeight;
			 lotSize = lotHeight * lotWidth * lotLen;

			 dataVolumeMap.put("PACK_SIZE", packSize);
			 dataVolumeMap.put("ITEM_SIZE", itemSize);
			 dataVolumeMap.put("LOT_SIZE", lotSize);
			 //Changed By Pragyan 12/03/13 To set hazardous item check
			 dataVolumeMap.put("HAZARDOUS", hazardous);
			 dataVolumeMap.put("ITEM_WEIGHT", itemWeight);
			 dataVolumeMap.put("PACK_WEIGHT", lotWeight);
			 dataVolumeMap.put("HARMONIZATION_NO", harmonizCode);
			 dataVolumeMap.put("HARMONIZATION_DESCR", harmonizDescr);
			 dataVolumeMap.put("ORIGIN_COUNTRY", originCountry);
			 dataVolumeMap.put("ITEM_LEN", itmLen);
			 dataVolumeMap.put("ITEM_WID", itmWidth);
			 dataVolumeMap.put("ITEM_HEIGHT", itmHeight);
			 dataVolumeMap.put("LITEM_LEN", lotLen);
			 dataVolumeMap.put("LITEM_WID", lotWidth);
			 dataVolumeMap.put("LITEM_HEIGHT", lotHeight);




			 if(pstmt != null)
			 {
				 pstmt.close();
				 pstmt = null;

			 }
			 if(rs != null)
			 {
				 rs.close();
				 rs = null;

			 }



		 } catch (Exception e) {
			 // TODO: handle exception		
			 throw e;
		 }
		 finally
		 {
			 try
			 {
				 if(pstmt != null)
				 {
					 pstmt.close();
					 pstmt = null;

				 }
				 if(rs != null)
				 {
					 rs.close();
					 rs = null;

				 }
			 }
			 catch(Exception e)
			 {
				 throw e;
			 }
		 }

		 return dataVolumeMap;


	 }
	 private double getStockQtyAfterConvert(String saleOrder, String lineNo,String itemCode,double quantity,int check, Connection conn) throws ITMException
	 {


		 String sql = "";
		 String itemUnit = "";
		 String orderUnit = "";
		 String unitStd = "";	 
		 double convQtyStduom = 0.0;
		 double newQty = 0.0;
		 double convFact = 0;
		 PreparedStatement pstmt = null;
		 ResultSet rs = null;
		 DistCommon discommon = new DistCommon();
		 E12GenericUtility genericUtility=new E12GenericUtility();

		 try
		 {
			 //System.out.println(" -- saleOrder ["+saleOrder+"] lineNo ["+lineNo+"] itemCode ["+itemCode+"] ");
			 sql = "SELECT DISTINCT ITEM.UNIT ,SORDDET.UNIT AS ORDER_UNIT,SORDDET.UNIT__STD AS  UNIT__STD, " +
			 " SORDDET.CONV__QTY_STDUOM FROM ITEM, SORDDET WHERE ITEM.ITEM_CODE = ? " +
			 " AND SORDDET.SALE_ORDER = ? AND SORDDET.LINE_NO = ? AND ITEM.ITEM_CODE = SORDDET.ITEM_CODE ";
			 pstmt = conn.prepareStatement(sql);
			 pstmt.setString(1, itemCode);
			 pstmt.setString(2, saleOrder);
			 pstmt.setString(3, lineNo);
			 rs = pstmt.executeQuery();
			 if( rs.next())
			 {
				 itemUnit = rs.getString("UNIT");
				 orderUnit = rs.getString("ORDER_UNIT");
				 unitStd = checkNull(rs.getString("UNIT__STD"));
				 convQtyStduom = rs.getDouble("CONV__QTY_STDUOM");			
			 }
			 rs.close(); rs = null;
			 pstmt.close(); pstmt = null;
			 ArrayList convQtyList = new ArrayList();

			 if(!orderUnit.equalsIgnoreCase(unitStd))
			 {
				 if(convQtyStduom != 0 && check == 1)
				 {
					 convFact = convQtyStduom;
				 }
				 System.out.println(" orderUnit ["+orderUnit+"] itemUnit ["+itemUnit+"] unitStd ["+unitStd+"] convQtyStduom ["+convQtyStduom+"]  convFact["+convFact+"]");
				 if( check == 1 )
				 {
					 convQtyList = new ArrayList();
					 convQtyList = discommon.getConvQuantityFact(orderUnit, unitStd, itemCode, quantity, convFact,conn);
				 }
				 else if ( check == 2 )
				 {
					 convQtyList = new ArrayList();
					 convQtyList = discommon.getConvQuantityFact(unitStd, orderUnit, itemCode, quantity, convFact,conn);
				 }
				 System.out.println("convQtyList = "+convQtyList);
				 newQty = Double.parseDouble(convQtyList.get(1).toString());
				 System.out.println("newQty ["+newQty+"]");

				 if(newQty == -999999999)
				 {
					 newQty = 0;								
				 }
				 if (convQtyStduom == 0)
				 {
					 convQtyStduom= Double.parseDouble(convQtyList.get(0).toString());
				 }
			 }
			 else
			 {
				 newQty = quantity;
			 }
			 //pendingQty = meffQty;

		 }
		 catch(Exception ex)
		 {		 
			 ex.printStackTrace();
			 throw new ITMException(ex);
		 }
		 return newQty;


	 }
	 private HashMap getItemVoumeMap(String itemCode,Connection con)throws Exception
	 {


		 double packSize = 0,itemSize = 0,lotSize = 0;
		 PreparedStatement pstmt = null;
		 String sql="",hazardous = "";
		 String harmonizCode = "",harmonizDescr = "",originCountry = "";
		 ResultSet rs = null;
		 double itmLen = 0,itmWidth = 0,itmHeight = 0,itemWeight = 0,lotLen = 0 ,lotHeight = 0,lotWidth = 0,lotWeight = 0;
		 HashMap dataVolumeMap = new HashMap();

		 System.out.println("As Lot No Passed as Blank Calling Override method for getItemVoumeMap");
		 try {

			 sql = "SELECT I.LENGTH ITEM_LEN,I.WIDTH ITEM_WID,I.HEIGHT ITEM_HEIGHT,I.GROSS_WEIGHT ITEM_WEIGHT,I.HAZARDOUS HAZARD, " 
				 +" I.HARMONIZATION_NO HARMONIZATION_NO,I.HARMONIZATION_DESCR HARMONIZATION_DESCR,I.COUNT_CODE__MFG ORIGIN_COUNTRY,"
				 +" L.LENGTH LITEM_LEN,L.WIDTH LITEM_WID,L.HEIGHT LITEM_HEIGHT,L.SHIPPER_SIZE SHIPSIZE,L.GROSS_WEIGHT LOT_WEIGHT FROM"
				 +" ITEM I,ITEM_LOT_PACKSIZE L"
				 +" WHERE I.ITEM_CODE = L.ITEM_CODE"
				 +" AND L.LOT_NO__TO IN (SELECT MAX(LOT_NO__TO) FROM ITEM_LOT_PACKSIZE WHERE ITEM_CODE = ?)"
				 +" AND  I.ITEM_CODE = ?";


			 pstmt = con.prepareStatement(sql);
			 pstmt.setString(1, itemCode);
			 pstmt.setString(2, itemCode);

			 rs = pstmt.executeQuery();

			 if(rs.next())
			 {
				 itmLen = rs.getDouble("ITEM_LEN");
				 itmWidth = rs.getDouble("ITEM_WID");
				 itmHeight = rs.getDouble("ITEM_HEIGHT");
				 itemWeight = rs.getDouble("ITEM_WEIGHT");
				 //Changed By Pragyan 12/03/13 To set hazardous item check
				 hazardous = rs.getString("HAZARD");
				 lotLen = rs.getDouble("LITEM_LEN");
				 lotWidth = rs.getDouble("LITEM_WID");
				 lotHeight = rs.getDouble("LITEM_HEIGHT");				
				 packSize = rs.getDouble("SHIPSIZE");				
				 lotWeight = rs.getDouble("LOT_WEIGHT");
				 harmonizCode = rs.getString("HARMONIZATION_NO");
				 harmonizDescr = rs.getString("HARMONIZATION_DESCR");
				 originCountry = rs.getString("ORIGIN_COUNTRY");
			 }
			 itemSize = itmLen * itmWidth * itmHeight;
			 lotSize = lotHeight * lotWidth * lotLen;

			 dataVolumeMap.put("PACK_SIZE", packSize);
			 dataVolumeMap.put("ITEM_SIZE", itemSize);
			 dataVolumeMap.put("LOT_SIZE", lotSize);
			 dataVolumeMap.put("HAZARDOUS", hazardous);
			 dataVolumeMap.put("ITEM_WEIGHT", itemWeight);
			 dataVolumeMap.put("PACK_WEIGHT", lotWeight);
			 dataVolumeMap.put("HARMONIZATION_NO", harmonizCode);
			 dataVolumeMap.put("HARMONIZATION_DESCR", harmonizDescr);
			 dataVolumeMap.put("ORIGIN_COUNTRY", originCountry);
			 dataVolumeMap.put("ITEM_LEN", itmLen);
			 dataVolumeMap.put("ITEM_WID", itmWidth);
			 dataVolumeMap.put("ITEM_HEIGHT", itmHeight);
			 dataVolumeMap.put("LITEM_LEN", lotLen);
			 dataVolumeMap.put("LITEM_WID", lotWidth);
			 dataVolumeMap.put("LITEM_HEIGHT", lotHeight);




			 if(pstmt != null)
			 {
				 pstmt.close();
				 pstmt = null;

			 }
			 if(rs != null)
			 {
				 rs.close();
				 rs = null;

			 }



		 } catch (Exception e) {
			 // TODO: handle exception

			 throw e;
		 }
		 finally
		 {
			 try
			 {
				 if(pstmt != null)
				 {
					 pstmt.close();
					 pstmt = null;

				 }
				 if(rs != null)
				 {
					 rs.close();
					 rs = null;

				 }
			 }
			 catch(Exception e)
			 {			
				 throw e;
			 }
		 }

		 return dataVolumeMap;


	 }
	 private HashMap<String,String> getSorderHdrData(Document dom) throws Exception
	 {
		 HashMap<String,String> headerValesMap = new HashMap<String,String>();
		 E12GenericUtility genericUtility = new E12GenericUtility();
		 String custCode = "",custName = "",groupCode = "",addr1 = "",addr2 = "",addr3 = "",stateCode = "";
		 String pin = "",countCode = "",stanCode = "",tele1 = "",tele2 = "",tele3 = "",emailAdd = "";
		 String fax = "",custCodeBil = "",currCode = "",tranCode = "",siteCode = "",transMode = "";
		 String loginCode = "",remoteHost = "",currCodeFrt = "",dlvCity= "",stateCodeDlv = "",dlvPin = "";
		 String countCodeDlv = "", crTerm= "",rcpMode = "",buyerName = "",notifyTo = "",siteCodeHdr = "";

		 String salesPers = "",taxEnv = "",pordDateStr = "",itemSer = "",saleOrderMangento = "",udfStr1 = "",
		 trnAmountStr = "",pordMode = "",siteCodeShip = "",remarks = "",totAmt = "",dlvTo = "",
		 vendorTxCode = "",exchRateStr = "",ordAmtStr = "",dueDateStr = "",taxDateStr = "",acctCodeSal = "",
		 securityKey = "",frtAmtStr = "",empCodeOrd = "",orderDateStr = "",taxAmtStr = "",dlvTerm = "",
		 vpsTxId = "",saleOrder = "",priceList = "";

		 NodeList parentNodeList = null;
		 NodeList childNodeList = null;
		 Node parentNode = null;
		 Node childNode = null;
		 int childNodeListLength = 0;

		 if(dom != null)
		 {	    
			 System.out.println("dom in getSorderHdrData----->>["+genericUtility.serializeDom(dom)+"]");	
			 parentNodeList = dom.getElementsByTagName("Detail1");
			 childNodeListLength = parentNodeList.getLength();
			 System.out.println("childNodeListLength@----->>"+childNodeListLength);
			 for (int ctr = 0; ctr < childNodeListLength; ctr++)
			 {				
				 childNode = parentNodeList.item(ctr);			
				 String childNodeName = childNode.getNodeName();
				 System.out.println("Child name --->> "+childNodeName);	

				 if (childNode.getNodeType() == Node.ELEMENT_NODE)
				 {
					 Element eElement = (Element) childNode;
					 saleOrder =  checkNull(eElement.getElementsByTagName("sale_order").item(0).getTextContent());	
					 siteCodeHdr =  checkNull(eElement.getElementsByTagName("site_code").item(0).getTextContent());	
					 System.out.println("siteCodeHdr----->"+siteCodeHdr);
					 custCode =  checkNull(eElement.getElementsByTagName("cust_code").item(0).getTextContent());	
					 addr1 =  checkNull(eElement.getElementsByTagName("dlv_add1").item(0).getTextContent());	
					 addr2 =  checkNull(eElement.getElementsByTagName("dlv_add2").item(0).getTextContent());	
					 addr3 =  checkNull(eElement.getElementsByTagName("dlv_add3").item(0).getTextContent());						
					 dlvCity =  checkNull(eElement.getElementsByTagName("dlv_city").item(0).getTextContent());	
					 stateCodeDlv =  checkNull(eElement.getElementsByTagName("state_code__dlv").item(0).getTextContent());	
					 System.out.println("cust_code----->"+custCode+ "stateCodeDlv---->"+stateCodeDlv);
					 dlvPin =  checkNull(eElement.getElementsByTagName("dlv_pin").item(0).getTextContent());	
					 countCodeDlv =  checkNull(eElement.getElementsByTagName("count_code__dlv").item(0).getTextContent());	
					 tele1 =  checkNull(eElement.getElementsByTagName("tel1__dlv").item(0).getTextContent());					
					 tele2 =  checkNull(eElement.getElementsByTagName("tel2__dlv").item(0).getTextContent());	
					 stanCode =  checkNull(eElement.getElementsByTagName("stan_code").item(0).getTextContent());	
					 fax =  checkNull(eElement.getElementsByTagName("fax__dlv").item(0).getTextContent());					
					 currCode =  checkNull(eElement.getElementsByTagName("curr_code").item(0).getTextContent());	
					 crTerm =  checkNull(eElement.getElementsByTagName("cr_term").item(0).getTextContent());	
					 tranCode =  checkNull(eElement.getElementsByTagName("tran_code").item(0).getTextContent());	
					 transMode =  checkNull(eElement.getElementsByTagName("trans_mode").item(0).getTextContent());	
					 rcpMode =  checkNull(eElement.getElementsByTagName("rcp_mode").item(0).getTextContent());
					 System.out.println("curr_code----->"+currCode+ "rcp_mode---->"+rcpMode);
					 buyerName =  checkNull(eElement.getElementsByTagName("buyer_name").item(0).getTextContent());	
					 notifyTo =  checkNull(eElement.getElementsByTagName("notify_to").item(0).getTextContent());	
					 System.out.println("buyerName----->"+buyerName);	


					 orderDateStr =  checkNull(eElement.getElementsByTagName("order_date").item(0).getTextContent());
					 itemSer =  checkNull(eElement.getElementsByTagName("item_ser").item(0).getTextContent());
					 saleOrderMangento =  checkNull(eElement.getElementsByTagName("cust_pord").item(0).getTextContent());
					 pordDateStr =  checkNull(eElement.getElementsByTagName("pord_date").item(0).getTextContent());
					 salesPers =  checkNull(eElement.getElementsByTagName("sales_pers").item(0).getTextContent());
					 taxEnv =  checkNull(eElement.getElementsByTagName("tax_env").item(0).getTextContent());			


					 taxDateStr =  checkNull(eElement.getElementsByTagName("tax_date").item(0).getTextContent());
					 priceList =  checkNull(eElement.getElementsByTagName("price_list").item(0).getTextContent());
					 crTerm =  checkNull(eElement.getElementsByTagName("cr_term").item(0).getTextContent());
					 exchRateStr =  checkNull(eElement.getElementsByTagName("exch_rate").item(0).getTextContent());
					 dueDateStr =  checkNull(eElement.getElementsByTagName("due_date").item(0).getTextContent());


					 System.out.println("dueDateStr----->"+dueDateStr);
					 remarks =  checkNull(eElement.getElementsByTagName("remarks").item(0).getTextContent());					
					 ordAmtStr =  checkNull(eElement.getElementsByTagName("ord_amt").item(0).getTextContent());
					 taxAmtStr =  checkNull(eElement.getElementsByTagName("tax_amt").item(0).getTextContent());				
					 totAmt =  checkNull(eElement.getElementsByTagName("tot_amt").item(0).getTextContent());					

					 dlvTerm =  checkNull(eElement.getElementsByTagName("dlv_term").item(0).getTextContent());
					 frtAmtStr =  checkNull(eElement.getElementsByTagName("frt_amt").item(0).getTextContent());
					 empCodeOrd =  checkNull(eElement.getElementsByTagName("emp_code__ord").item(0).getTextContent());					


					 dlvTo =  checkNull(eElement.getElementsByTagName("dlv_to").item(0).getTextContent());
					 //acctCodeSal =  checkNull(eElement.getElementsByTagName("acct_code__sal").item(0).getTextContent());
					 siteCodeShip =  checkNull(eElement.getElementsByTagName("site_code__ship").item(0).getTextContent());
					 pordMode =  checkNull(eElement.getElementsByTagName("pord_mode").item(0).getTextContent());
					 udfStr1 =  checkNull(eElement.getElementsByTagName("udf__str1").item(0).getTextContent());

					 System.out.println("udfStr1----->"+udfStr1);
					 vendorTxCode =  checkNull(eElement.getElementsByTagName("vendor_tx_code").item(0).getTextContent());
					 vpsTxId =  checkNull(eElement.getElementsByTagName("vps_tx_id").item(0).getTextContent());
					 securityKey =  checkNull(eElement.getElementsByTagName("security_key").item(0).getTextContent());
					 trnAmountStr =  checkNull(eElement.getElementsByTagName("trn_amount").item(0).getTextContent());
					 System.out.println("vendorTxCode----->"+vendorTxCode+"] vpsTxId--->>["+vpsTxId+"]");
					 System.out.println("securityKey----->"+securityKey+"] trnAmountStr--->>["+trnAmountStr+"]");				


				 }
			 }	    	 

			 /*custCode=genericUtility.getColumnValue("cust_code", dom);
	    	addr1=genericUtility.getColumnValue("dlv_add1", dom);
	    	addr2=genericUtility.getColumnValue("dlv_add2", dom);
	    	addr3=genericUtility.getColumnValue("dlv_add3", dom);
	    	dlvCity=genericUtility.getColumnValue("dlv_city", dom);
	    	stateCodeDlv=genericUtility.getColumnValue("state_code__dlv", dom);
	    	dlvPin=genericUtility.getColumnValue("dlv_pin", dom);

	    	countCodeDlv=genericUtility.getColumnValue("count_code__dlv", dom);
	    	stanCode=genericUtility.getColumnValue("stan_code", dom);
	    	tele1=genericUtility.getColumnValue("tel1__dlv", dom);
	    	tele2=genericUtility.getColumnValue("tel2__dlv", dom);
	    	//tele3=genericUtility.getColumnValue("tel3__dlv", dom);
	    	fax=genericUtility.getColumnValue("fax__dlv", dom);

	    	currCode=genericUtility.getColumnValue("curr_code", dom);
	    	crTerm=genericUtility.getColumnValue("cr_term", dom);

	    	tranCode=genericUtility.getColumnValue("tran_code", dom);
	    	siteCode=genericUtility.getColumnValue("site_code", dom);

	    	transMode=genericUtility.getColumnValue("trans_mode", dom);
	    	rcpMode=genericUtility.getColumnValue("rcp_mode", dom); 

	    	buyerName=genericUtility.getColumnValue("buyer_name", dom);
	    	notifyTo=genericUtility.getColumnValue("notify_to", dom);*/

			 headerValesMap.put("sale_order",saleOrder);

			 headerValesMap.put("cust_code",custCode);
			 headerValesMap.put("dlv_add1",addr1);
			 headerValesMap.put("dlv_add2",addr2);
			 headerValesMap.put("dlv_add3",addr3);
			 headerValesMap.put("dlv_city",dlvCity);
			 headerValesMap.put("state_code__dlv",stateCodeDlv);
			 headerValesMap.put("dlv_pin",dlvPin);
			 headerValesMap.put("count_code__dlv",countCodeDlv);

			 headerValesMap.put("stan_code",stanCode);
			 headerValesMap.put("tel1__dlv",tele1);
			 headerValesMap.put("tel2__dlv",tele2);
			 headerValesMap.put("tel3__dlv",tele3);
			 headerValesMap.put("fax__dlv",fax);
			 headerValesMap.put("curr_code",currCode);
			 headerValesMap.put("cr_term",crTerm);
			 headerValesMap.put("tran_code",tranCode);
			 headerValesMap.put("site_code",siteCodeHdr);

			 headerValesMap.put("trans_mode",transMode);
			 headerValesMap.put("rcp_mode",rcpMode);
			 headerValesMap.put("buyer_name",buyerName);
			 headerValesMap.put("notify_to",notifyTo);	

			 headerValesMap.put("order_date",orderDateStr);
			 headerValesMap.put("item_ser",itemSer);
			 headerValesMap.put("cust_pord",saleOrderMangento);
			 headerValesMap.put("pord_date",pordDateStr);
			 headerValesMap.put("sales_pers",salesPers);

			 headerValesMap.put("tax_date",taxDateStr);
			 headerValesMap.put("price_list",priceList);
			 headerValesMap.put("cr_term",crTerm);
			 headerValesMap.put("exch_rate",exchRateStr);
			 headerValesMap.put("due_date",dueDateStr);

			 headerValesMap.put("remarks",remarks);
			 headerValesMap.put("ord_amt",ordAmtStr);
			 headerValesMap.put("tax_amt",taxAmtStr);
			 headerValesMap.put("tot_amt",totAmt);

			 headerValesMap.put("dlv_term",dlvTerm);
			 headerValesMap.put("frt_amt",frtAmtStr);
			 headerValesMap.put("emp_code__ord",empCodeOrd);
			 headerValesMap.put("dlv_to",dlvTo);
			 headerValesMap.put("acct_code__sal",acctCodeSal);
			 headerValesMap.put("site_code__ship",siteCodeShip);
			 headerValesMap.put("pord_mode",pordMode);
			 headerValesMap.put("udf__str1",udfStr1);

			 headerValesMap.put("vendor_tx_code",vendorTxCode);
			 headerValesMap.put("vps_tx_id",vpsTxId);
			 headerValesMap.put("security_key",securityKey);
			 headerValesMap.put("trn_amount",trnAmountStr);
		 }
		 else
		 {
			 System.out.println("in getSorderHdrData dom is null...............................");
		 }
		 return headerValesMap;
	 }
	 private String saveData(String siteCode, String xmlString, Connection conn) throws ITMException, Exception
	 {

		 System.out.println("saving data...........");
		 InitialContext ctx = null;
		 String retString = null;
		 MasterStatefulLocal masterStateful = null; // for ejb3
		 try
		 {
			 AppConnectParm appConnect = new AppConnectParm();
			 ctx = new InitialContext(appConnect.getProperty());
			 masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");

			 String [] authencate = new String[2];
			 authencate[0] = "";
			 authencate[1] = "";
			 System.out.println("xmlString in masterStateful :::: " + xmlString);
			 retString = masterStateful.processRequest(authencate, siteCode, true, xmlString, true, conn);
			 masterStateful = null;			

		 }
		 catch(ITMException e)
		 {			
			 System.out.println("ITMException ::saveData :==>");
			 throw new ITMException(e);
		 }
		 catch(Exception e)
		 {			
			 System.out.println("Exception ::saveData :==>");
			 throw new Exception(e);
		 }
		 return retString;

	 }

	 public String checkNull(String str)
	 {
		 if(str == null)
		 {
			 str="";
		 }
		 return str.trim();

	 }


	 //For sap Integration 

	 public void writeClientXml(String clientXml) throws Exception
	 {
		 try
		 {
			 int number = 0;
			 String fileName = "";

			 number = GetRandomNumber();

			 fileName = "sorder_"+ number;

			 System.out.println("Client File Name is ="+fileName);

			 FileOutputStream fos1 = null;
			 File dir = new File ( CommonConstants.JBOSSHOME + File.separator + "web_input" );
			 if(!dir.exists())
			 {
				 dir.mkdirs();
			 }
			 File file = new File( dir ,fileName+".xml");
			 if(!file.exists())
			 {
				 file.createNewFile();
				 fos1 = new FileOutputStream(file);
			 }
			 else
			 {
				 fos1 = new FileOutputStream(file);
			 }
			 byte convertStringToByte1[] = clientXml.getBytes();
			 fos1.write(convertStringToByte1);
			 fos1.close();
		 }
		 catch(Exception e)
		 {
			 throw new Exception(e);
		 }
	 }

	 public void insertBatchLoad(String batchNo, String winName, String userName, Connection conn) throws Exception
	 {
		 System.out.println("Inside insertBatchLoad function");
		 PreparedStatement batchLoadPstmt = null;

		 try
		 {
			 String insBatchLoad = "INSERT INTO BATCHLOAD( BATCH_ID, TRAN_SL, WIN_NAME, LOAD_STAT, CHG_DATE, CHG_USER, CHG_TERM, DATA_INPUT ) " 
				 +" VALUES( ?, ?, ?, ?, ?, ?, ?, ? )";

			 batchLoadPstmt = conn.prepareStatement( insBatchLoad );

			 batchLoadPstmt.setString( 1, batchNo );
			 batchLoadPstmt.setInt( 2, 1 );
			 batchLoadPstmt.setString( 3, winName );
			 batchLoadPstmt.setString( 4, "N" );
			 batchLoadPstmt.setTimestamp( 5, new java.sql.Timestamp( System.currentTimeMillis() ) );
			 batchLoadPstmt.setString( 6, userName );
			 batchLoadPstmt.setString( 7, userName );
			 batchLoadPstmt.setString( 8, "X" );

			 int batchLoadUpd = batchLoadPstmt.executeUpdate();
			 System.out.println("batchLoadDetUpd ["+batchLoadUpd+"]");

			 if ( batchLoadPstmt != null)
			 {	
				 batchLoadPstmt.close();
				 batchLoadPstmt = null;
			 }

		 }
		 catch(Exception e)
		 {
			 try
			 {
				 if (batchLoadPstmt != null)
				 {	
					 batchLoadPstmt.close();
					 batchLoadPstmt = null;
				 }
			 }
			 catch(Exception ex)
			 {
				 ex.printStackTrace();
			 }
			 e.printStackTrace();
			 throw new Exception(e);

		 }
		 finally
		 {
			 System.out.println("Inside finally insertBatchLoad");
		 }

	 }

	 public String ApplyMaster(String batchId, String scheduleParamXML,String xtraParams,Connection conn) throws Exception
	 {
		 try
		 {
			 System.out.println("@@Inside Apply Master");

			 FileOutputStream fos1 = null;
			 File dir = new File ( CommonConstants.JBOSSHOME + File.separator + "edi_input" );
			 if(!dir.exists())
			 {
				 dir.mkdirs();
			 }
			 File file = new File( dir ,batchId+".xml");
			 if(!file.exists())
			 {
				 file.createNewFile();
				 fos1 = new FileOutputStream(file);
			 }
			 else
			 {
				 fos1 = new FileOutputStream(file);
			 }
			 byte convertStringToByte1[] = scheduleParamXML.getBytes();
			 fos1.write(convertStringToByte1);
			 fos1.close();

			 /*FileOutputStream fileOutputStream = new FileOutputStream( CommonConstants.JBOSSHOME + File.separator + "edi_input/"+batchId+".xml" );
			System.out.println("File Name="+fileOutputStream.toString());

			byte convertStringToByte[] = scheduleParamXML.toString().getBytes();
			fileOutputStream.write( convertStringToByte );
			fileOutputStream.close( );*/

			 /*xtraParams = "loginCode=BASE~~loginEmpCode=99999     ~~loginSiteCode=DDUK ~~entityCode=99999     "
					+ "~~profileId=BASE      ~~userType=E~~runMode=I~~user_lang=en~~user_country=US~~charEnc=UTF-8~~"
					+ "termId=192.168.0.24~~chgTerm=192.168.0.24~~tranId=null";*/

			 String userInfo = getUserInfo(xtraParams);

			 AppConnectParm appConnect = new AppConnectParm();
			 ibase.utility.UserInfoBean userInfoBean = new ibase.utility.UserInfoBean( userInfo );
			 InitialContext ctx = new InitialContext ( appConnect.getProperty() );
			 MasterApplyEJBLocal masterApplyLocal = ( MasterApplyEJBLocal ) ctx.lookup("ibase/MasterApplyEJB/local");
			 String returnResult = 	masterApplyLocal.applyMasterTable( batchId, xtraParams, userInfoBean );
			 System.out.println("Final Result from master apply="+returnResult);

			 if(returnResult.indexOf("VTEDIFA") > -1)
			 {
				 throw new Exception(returnResult);
			 }
			 else
			 {	
				 return returnResult;
			 }	
		 }
		 catch(Exception e)
		 {
			 e.printStackTrace();
			 throw new Exception(e);
		 }
		 //return returnResult
	 }

	 private String  generateTranId( String winName, String xsiteCode, String userID, Connection conn ) throws Exception
	 {
		 PreparedStatement lstmt = null;
		 ResultSet lrs = null;
		 String tranId = null;

		 try
		 {
			 String keyStringQuery = null;
			 String tranDate = null;
			 String tranSer = "";
			 String keyString = "";
			 String keyCol = "";

			 keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE UPPER(TRAN_WINDOW) = ?";
			 System.out.println( "keyStringQuery  :: " + keyStringQuery );
			 lstmt = conn.prepareStatement( keyStringQuery );
			 lstmt.setString(1,winName);
			 lrs = lstmt.executeQuery();
			 if( lrs.next() )
			 {
				 keyString = lrs.getString( "KEY_STRING" );
				 keyCol = lrs.getString( "TRAN_ID_COL" );
				 tranSer = lrs.getString( "REF_SER" );
			 }
			 else
			 {
				 if( lrs != null )
				 {
					 lrs.close();
				 }
				 lrs = null;
				 if( lstmt != null )
				 {
					 lstmt.close();
				 }
				 String sqlStr = "SELECT  KEY_STRING, TRAN_ID_COL, REF_SER  FROM  TRANSETUP WHERE  TRAN_WINDOW = 'GENERAL' ";
				 System.out.println( " sqlStr : " + sqlStr );

				 lstmt = conn.prepareStatement( sqlStr );
				 lrs = lstmt.executeQuery();

				 if( lrs.next() )
				 {
					 keyString = lrs.getString( "KEY_STRING" );
					 keyCol = lrs.getString( "TRAN_ID_COL" );
					 tranSer = lrs.getString( "REF_SER" );
				 }
			 	// Changed by Sneha on 01-09-2016, for Closing the Open Cursor [Start]
				if( lstmt != null )
				{
					lstmt.close();
					lstmt = null;
				}
				if ( lrs != null )
				{
					lrs.close();
					lrs = null;
				}
				// Changed by Sneha on 01-09-2016, for Closing the Open Cursor [End]
			 }
			 /*lrs.close();
			 lrs = null;
			 lstmt.close();
			 lstmt = null;*/
			 if( lstmt != null )
			 {
				 lstmt.close();
				 lstmt = null;
			 }
			 if ( lrs != null )
			 {
				 lrs.close();
				 lrs = null;
			 }
			 
			 tranDate = getCurrdateAppFormat();

			 StringBuffer xmlValues = new StringBuffer("<?xml version=\"1.0\" encoding=\"").append(CommonConstants.ENCODING).append("\"?><Root>");
			 xmlValues.append("<Header></Header><Detail1><site_code>").append( xsiteCode ).append("</site_code>");
			 xmlValues.append("<tran_date>").append( tranDate ).append("</tran_date></Detail1></Root>");

			 TransIDGenerator tg = new TransIDGenerator(xmlValues.toString(), userID, CommonConstants.DB_NAME);
			 tranId = tg.generateTranSeqID( tranSer, keyCol, keyString, conn );
		 }
		 catch(Exception ex)
		 {
			 //System.out.println("Exception8:Generating id [failed]:" + "\n" +ex.getMessage());
			 ex.printStackTrace();
			 throw new Exception(ex);
		 }
		 finally
		 {
			 if (lstmt != null )
			 {
				 lstmt.close();
				 lstmt = null;
			 }
		 }
		 return tranId;
	 }//trnId

	 private String getCurrdateAppFormat() throws Exception
	 {
		 String currAppdate ="";
		 try
		 {
			 E12GenericUtility genericUtility = new E12GenericUtility();
			 java.sql.Timestamp currDate = new java.sql.Timestamp(System.currentTimeMillis()) ;
			 SimpleDateFormat sdf = new SimpleDateFormat( genericUtility.getDBDateFormat() );
			 Object date = sdf.parse( currDate.toString() );
			 currDate = java.sql.Timestamp.valueOf( sdf.format(date).toString() + " 00:00:00.0");
			 currAppdate = new SimpleDateFormat( genericUtility.getApplDateFormat() ).format( currDate ).toString();
		 }
		 catch(Exception e)
		 {
			 e.printStackTrace();
			 throw new Exception(e);
		 }
		 return (currAppdate);
	 }
	 private String getXSLFileName( String xslFileName )throws Exception
	 {   
		 String retFileName = null;
		 try
		 {
			 String defaultPath = null;
			 if( CommonConstants.APPLICATION_CONTEXT != null )
			 {
				 defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			 }
			 /*else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}*/
			 //File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			 File xslPath = new File(defaultPath+"/xsl/Standard/Transform");
			 if ( !xslPath.exists() )
			 {
				 xslPath.mkdir();
			 }
			 System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			 File xslFile = new File(xslPath , xslFileName);
			 if( xslFile.exists() )
			 {
				 retFileName = xslFile.getAbsolutePath();
			 }
			 else
			 {
				 throw new Exception(retFileName + " Wizard XSL file Not Found");	
			 }
		 }
		 catch (Exception e)
		 {
			 throw new Exception(e);
		 }
		 return retFileName;
	 }

	 public String sorderMapper(String xml,String clientXml,Connection conn) throws Exception
	 {
		 System.out.println("Inside sorderMapper");
		 String mappedXml = "";
		 Document dom = null,clientDom = null,transformDom = null;

		 NodeList parentNodeList = null;
		 NodeList childNodeList = null;
		 Node parentNode = null;
		 Node childNode = null;
		 String childNodeName = null;
		 int childNodeListLength;
		 int ctr =0 ;
		 FileInputStream fis = null;
		 ArrayList param =new ArrayList();
		 ArrayList totalNode = new ArrayList();
		 ArrayList clientNode = new ArrayList();

		 String sql = "";
		 PreparedStatement pstmt = null;
		 ResultSet rs = null;
		 String columnName = "";

		 NodeList xmlList = null;
		 Node xmlParentNode = null;
		 NodeList xmlchildNodeList = null;
		 int xmlchildNodeListLength = 0;

		 try
		 {
			 String defaultPath = null;
			 if( CommonConstants.APPLICATION_CONTEXT != null )
			 {
				 defaultPath = CommonConstants.APPLICATION_CONTEXT + File.separator;
			 }
			 /*else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator ;
			}*/
			 E12GenericUtility genericUtility = new E12GenericUtility();
			 File file = new File(defaultPath+"/setting/generic_map.xml");

			 StringBuffer sb = new StringBuffer();

			 fis = new FileInputStream(file);
			 System.out.println("Total file size to read (in bytes) : "+ fis.available());

			 int content;
			 while ((content = fis.read()) != -1)
			 {
				 sb.append((char) content);
			 }
			 System.out.println("Final XML is= "+sb);

			 dom = genericUtility.parseString(sb.toString());
			 clientDom = genericUtility.parseString(clientXml.toString());
			 transformDom = genericUtility.parseString(xml.toString());

			 parentNodeList = dom.getElementsByTagName("order");
			 parentNode = parentNodeList.item(0);
			 childNodeList = parentNode.getChildNodes();
			 childNodeListLength = childNodeList.getLength();
			 System.out.println("@@Length="+childNodeListLength);

			 //System.out.println("eewr"+dom.getElementsByTagName("order").item(0).getChildNodes().getLength());
			 for(ctr=0;ctr<childNodeListLength;ctr++)
			 {
				 childNode = childNodeList.item(ctr);
				 childNodeName = childNode.getNodeName();
				 if (!(childNode instanceof Text)) 
				 {
					 System.out.println("Node Name = "+childNodeName);

					 xmlList = transformDom.getElementsByTagName(childNodeName);
					 System.out.println("Node Length="+xmlList.getLength());

					 if(xmlList.getLength() > 1)
					 {	 
						 for(int y=0;y<xmlList.getLength();y++)
						 {
							 System.out.println("Client Node Value="+xmlList.item(y).getChildNodes().item(0).getNodeValue());
							 System.out.println("Client Node Name="+xmlList.item(y).getNodeName());
							 totalNode.add(xmlList.item(y).getChildNodes().item(0).getNodeValue());

							 /* xmlList.item(y).getChildNodes().item(0).setNodeValue("WWWASSIIIM"+y);
							System.out.println("NOw="+xmlList.item(y).getChildNodes().item(0).getNodeValue());
							 System.out.println("Meeee===="+genericUtility.serializeDom(transformDom));*/
						 }
					 }

					 for(int i = 1; i <= childNode.getChildNodes().getLength(); i++)
					 {	 
						 Node columnChildNode =  childNode.getChildNodes().item(i);

						 if (!(columnChildNode instanceof Text)) 
						 {
							 if(columnChildNode != null)
							 {	
								 System.out.println("ColumnChildNodeName="+columnChildNode.getNodeName());

								 if(columnChildNode.getNodeName().equalsIgnoreCase("sql_input"))
								 {
									 for(int j = 1; j <= columnChildNode.getChildNodes().getLength(); j++)
									 {
										 Node sqlChildNode =  columnChildNode.getChildNodes().item(j);

										 if (!(sqlChildNode instanceof Text)) 
										 {
											 if(sqlChildNode != null)
											 {	
												 System.out.println("SQL Params="+sqlChildNode.getNodeName());
												 System.out.println("SQL Input="+sqlChildNode.getChildNodes().item(0).getNodeValue());
												 param.add(sqlChildNode.getChildNodes().item(0).getNodeValue());
											 }	
										 }
									 }
								 }
								 else
								 {
									 sql = columnChildNode.getChildNodes().item(0).getNodeValue();
									 System.out.println("SQL="+sql);
								 }
							 }
						 }
					 }

					 System.out.println("Column is="+childNodeName);
					 System.out.println("@@Parameters are="+param);
					 System.out.println("SQL is="+sql);

					 for(int y=0; y<xmlList.getLength(); y++)
					 {	
						 pstmt = conn.prepareStatement(sql);
						 int count = 1;

						 for(Object paramVal : param)
						 {	
							 if(xmlList.getLength() > 1)
							 {
								 String paramValue = totalNode.get(y).toString();
								 System.out.println("Detail Value from client DOM="+paramValue);
								 pstmt.setString(count++, paramValue);
							 }
							 else
							 {	
								 String[] split =  paramVal.toString().split(":");
								 String splitValue = "";
								 System.out.println("Split Length="+split.length);

								 if(split.length > 1)
								 {
									 System.out.println("Parent="+split[0]);
									 System.out.println("Value="+split[1]);

									 NodeList splitList = clientDom.getElementsByTagName(split[0]);
									 Node splitNode = splitList.item(0);

									 NodeList splitNodeList = splitNode.getChildNodes();
									 int splitchildNodeListLength = splitNodeList.getLength();
									 System.out.println("@@Length="+splitchildNodeListLength);

									 for(int x=0;x<splitchildNodeListLength;x++)
									 {
										 String name = splitNodeList.item(x).getNodeName();
										 System.out.println("@@Node name get="+name);

										 if(name.equals(split[1]))
										 {
											 splitValue = splitNodeList.item(x).getChildNodes().item(0).getNodeValue();
											 System.out.println("Split Value="+splitValue);
											 break;
										 }
									 }

									 System.out.println("Head Value from client DOM="+splitValue);
									 pstmt.setString(count++, splitValue);
								 }
								 else
								 {	
									 String paramValue = genericUtility.getColumnValue(paramVal.toString(), clientDom);
									 System.out.println("Head Value from client DOM="+paramValue);
									 pstmt.setString(count++, paramValue);
								 }	
							 }
						 }
						 //pstmt.setString(count, "1234");
						 rs = pstmt.executeQuery();
						 if (rs.next()) 
						 {
							 String value = checkNullAndTrim(rs.getString(childNodeName));
							 System.out.println(childNodeName+"="+value);

							 if(xmlList.getLength() > 1)
							 {
								 xmlList.item(y).getChildNodes().item(0).setNodeValue(value);
							 }
							 else
							 {	
								 setNodeValue(transformDom,childNodeName,value);
							 }	
						 }
						 if(rs != null) {rs.close();rs = null;}
						 if(pstmt != null) {pstmt.close();pstmt = null;}
					 }
					 param.clear();
					 totalNode.clear();
				 }
			 }
			 mappedXml = genericUtility.serializeDom(transformDom);//returning final xml after mapping

			 //System.out.println("Column="+dom.getElementsByTagName("order").item(0).getChildNodes().item(1).getNodeName());
			 //System.out.println("SQL="+dom.getElementsByTagName("order").item(0).getChildNodes().item(1).getChildNodes().item(1).getNodeName());
			 //System.out.println("Input="+dom.getElementsByTagName("order").item(0).getChildNodes().item(1).getChildNodes().item().getNodeName());


			 /*String column = dom.getElementsByTagName("order").item(0).getChildNodes().item(1).getChildNodes().item(0).getNodeName();
			String sql = dom.getElementsByTagName("order").item(0).getChildNodes().item(1).getChildNodes().item(1).getNodeName();
			String input = "";*/

			 /*for(ctr=0;ctr<childNodeListLength;ctr++)
			{
				childNode = childNodeList.item(ctr);
				childNodeName = childNode.getNodeName();

				System.out.println("NAme is="+childNodeName);
				if (childNodeName.equalsIgnoreCase("cust_code")) 
				{
					int paramName = 0;
					String custCode = genericUtility.getColumnValue("cust_code", dom);

					if(custCode != null)
					{
						System.out.println("Cutomer code is ="+custCode);
					}
				}
			}*/

		 }
		 catch(Exception e)
		 {
			 e.printStackTrace();
			 throw new Exception(e);
		 }
		 finally
		 {
			 System.out.println("@@Inside finally");
			 try
			 {
				 if (fis != null)
					 fis.close();
				 if(rs != null) {rs.close();rs = null;}
				 if(pstmt != null) {pstmt.close();pstmt = null;}
			 } 
			 catch (Exception ex) 
			 {
				 ex.printStackTrace();
			 }
		 }
		 return mappedXml;
	 }

	 private static String checkNullAndTrim(String input)
	 {
		 if (input==null)
		 {
			 input="";
		 }
		 return input.trim();
	 }

	 private static void setNodeValue( Document dom, String nodeName, String nodeVal ) throws Exception
	 {
		 Node tempNode = dom.getElementsByTagName( nodeName ).item(0);

		 if( tempNode != null )
		 {
			 if( tempNode.getFirstChild() == null )
			 {
				 CDATASection cDataSection = dom.createCDATASection( nodeVal );
				 tempNode.appendChild( cDataSection );
			 }
			 else
			 {
				 tempNode.getFirstChild().setNodeValue(nodeVal);
			 }
		 }
		 tempNode = null;
	 }

	 private Node searchNode(Document dom, String objContext, String nodeID) throws ITMException
	 {
		 Node detailNode = null;
		 try
		 {
			 objContext = (objContext == null) || (objContext.length() == 0) ? "1" : objContext;
			 nodeID = (nodeID == null) || (nodeID.length() == 0) ? "1" : nodeID;

			 NodeList detailList = dom.getElementsByTagName("Detail" + objContext);
			 int detListLength = detailList.getLength();
			 for (int ctr = 0; ctr < detListLength; ctr++)
			 {
				 Node curDetail = detailList.item(ctr);
				 if (!curDetail.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(nodeID))
					 continue;
				 detailNode = curDetail;
				 break;
			 }

		 }
		 catch (Exception e)
		 {
			 System.out.println("Exception : MasterStatefulEJB : searchNode :" + e);
			 throw new ITMException(e);
		 }
		 return detailNode;
	 }

	 public int GetRandomNumber()
	 {
		 long timeSeed = System.nanoTime(); // to get the current date time value
		 double randSeed = Math.random() * 1000; // random number generation
		 long midSeed = (long) (timeSeed * randSeed); 
		 String s = midSeed + "";
		 String subStr = s.substring(0, 9);
		 int finalSeed = Integer.parseInt(subStr);    // integer value
		 return finalSeed;
	 }

	 public String ChangeDate(String clientXml) throws Exception
	 {
		 Document dom = null;
		 dom = genericUtility.parseString(clientXml.toString());
		 String xml = ""; 

		 String applDateFormat = genericUtility.getApplDateFormat();
		 SimpleDateFormat sdf = new SimpleDateFormat(applDateFormat);

		 try
		 {

			 StringBuffer newDate = new StringBuffer();
			 String date = genericUtility.getColumnValue("deliveryRequestedDate", dom);
			 System.out.println("Request Date from client DOM = "+date); //20150831 in this format received

			 newDate.append(date);
			 newDate.insert(4, '-');
			 newDate.insert(7, '-');
			 System.out.println("New Date="+newDate);

			 java.sql.Timestamp ts =  Timestamp.valueOf(newDate.toString()+" 00:00:00");
			 String finalDate = sdf.format(ts);

			 setNodeValue(dom,"deliveryRequestedDate",finalDate);

			 xml = genericUtility.serializeDom(dom);
		 }
		 catch(Exception e)
		 {
			 throw new Exception(e);
		 }
		 return xml;
	 }


	 public String setExtraData(String clientXml,String user,Connection conn) throws Exception
	 {
		 Document dom = null;
		 PreparedStatement pstmt = null;
		 ResultSet rs = null;
		 String xml = "", siteCode = "",sql = "", crTerm = "",custCode = "", itemSer = "", empCode = ""; 

		 try
		 {

			 dom = genericUtility.parseString(clientXml.toString());
			 custCode = genericUtility.getColumnValue("identificationCode", dom);
			 itemSer = genericUtility.getColumnValue("salesOrg", dom);

			 sql = "SELECT SITE_CODE__DEF,EMP_CODE FROM USERS WHERE CODE = ?";
			 pstmt = conn.prepareStatement(sql);
			 pstmt.setString(1, user);
			 rs = pstmt.executeQuery();
			 if ( rs.next() )
			 {
				 siteCode = checkNullAndTrim(rs.getString("SITE_CODE__DEF"));
				 empCode = checkNullAndTrim(rs.getString("EMP_CODE"));
			 }
			 rs.close();rs = null;
			 pstmt.close();pstmt = null;
			 System.out.println("Site code is from user table="+siteCode);

			 sql = "SELECT CR_TERM FROM CUSTOMER_SERIES WHERE CUST_CODE = ? AND ITEM_SER = ?";
			 pstmt = conn.prepareStatement(sql);
			 pstmt.setString(1, custCode);
			 pstmt.setString(2, itemSer);
			 rs = pstmt.executeQuery();
			 if ( rs.next() )
			 {
				 crTerm = checkNullAndTrim(rs.getString("CR_TERM"));
			 }
			 rs.close();rs = null;
			 pstmt.close();pstmt = null;
			 System.out.println("Credit Term is from CUSTOMER_SERIES table="+crTerm);

			 Text a = dom.createTextNode(siteCode);//here we create a node in client xml and set value site code 
			 Element p = dom.createElement("siteCode"); 
			 p.appendChild(a); 
			 NodeList main = dom.getElementsByTagName("header");
			 main.item(0).appendChild(p);

			 Text b = dom.createTextNode(user); //here we create a node in client xml and set value change user 
			 Element q = dom.createElement("chgUser"); 
			 q.appendChild(b);
			 main.item(0).appendChild(q);

			 Text c = dom.createTextNode(crTerm); //here we create a node in client xml and set value credit term
			 Element r = dom.createElement("crTerm"); 
			 r.appendChild(c);
			 main.item(0).appendChild(r);

			 Text d = dom.createTextNode(empCode); //here we create a node in client xml and set value emp code
			 Element s = dom.createElement("empCode"); 
			 s.appendChild(d);
			 main.item(0).appendChild(s);

			 xml = genericUtility.serializeDom(dom);

			 System.out.println("After adding new node Client XML is  ="+xml);

			 //xml = genericUtility.serializeDom(dom);
		 }
		 catch(Exception e)
		 {
			 throw new Exception(e);
		 }
		 return xml;
	 }


	 public String GetResponseXml(String batchNo,String status,Connection conn) throws Exception
	 {
		 StringBuffer sb = new StringBuffer();
		 Document dom = null,dom2 = null;
		 String sql = "", saleOrder = "";
		 PreparedStatement pstmt = null;
		 ResultSet rs = null;
		 try
		 {
			 //sql = "SELECT SALE_ORDER FROM SORDER WHERE UDF__STR2 = ?";
			 sql = "SELECT TRAN_ID__REF FROM BATCHLOAD WHERE BATCH_ID = ?";//Changed by wasim to get sorder from bathcload on 28-09-2015
			 pstmt = conn.prepareStatement(sql);
			 pstmt.setString(1, batchNo);
			 rs = pstmt.executeQuery();
			 if ( rs.next() )
			 {
				 saleOrder = checkNullAndTrim(rs.getString("TRAN_ID__REF"));

				 System.out.println("Sale Order number is = "+saleOrder);

				 sb.append("<root>\r\n");
				 sb.append("<MESSAGE>").append("<![CDATA[Transaction saved successfully......]]>").append("</MESSAGE>\r\n");
				 sb.append("<TRAN_ID>").append("<![CDATA["+saleOrder+"]]>").append("</TRAN_ID>\r\n");
				 sb.append("</root>");	
			 }
			 else
			 {
				 System.out.println("No batch id made");
				 return status;
			 }
			 rs.close();rs = null;
			 pstmt.close();pstmt = null;
		 }
		 catch(Exception e)
		 {
			 throw new Exception(e);
		 }

		 return sb.toString();
	 }
	 public String GetErrorXml(String batchNo,String status,Connection conn) throws Exception
	 {
		 StringBuffer sb = new StringBuffer();
		 String sql = "",msg = "";
		 PreparedStatement pstmt = null;
		 ResultSet rs = null;
		 try
		 {


			 sql = " SELECT ERROR_MSG FROM BATCHLOAD WHERE BATCH_ID = ? ";
			 pstmt = conn.prepareStatement(sql);
			 pstmt.setString(1, batchNo);

			 rs = pstmt.executeQuery();
			 if ( rs.next() )
			 {
				 msg = rs.getString("ERROR_MSG");

				 sb.append("<root>\r\n");
				 sb.append("<error>\r\n");
				 if(msg!= null)
				 {	
					 sb.append("<msg_descr>").append(rs.getString("ERROR_MSG")).append("</msg_descr>\r\n");
				 }
				 else
				 {
					 sb.append("<msg_descr>").append("EDI Loading failed").append("</msg_descr>\r\n");
				 }

				 sb.append("</error>");	
				 sb.append("</root>\r\n");
			 }
			 else
			 {
				 System.out.println("No batch id made");
				 return status;
			 }
			 rs.close();rs = null;
			 pstmt.close();pstmt = null;

		 }
		 catch(Exception e)
		 {
			 throw new Exception(e);
		 }

		 return sb.toString();
	 }
	 public String getXtraParams(String userCode,String clientIp,Connection conn)throws Exception
	 {
		 String extraParams ="";
		 String userId = "";
		 String loginEmpCode = "";
		 String loginSiteCode = "";
		 String entityCode = "";
		 String profileId = "";
		 String userType = "";
		 String userLang = "";
		 String userCountry = "";
		 String chgTerm = clientIp;
		 java.sql.PreparedStatement pstmt = null;
		 ResultSet rs = null;
		 try
		 {

			 String userSql = "SELECT U.CODE,U.EMP_CODE,U.SITE_CODE__DEF,U.ENTITY_CODE,U.PROFILE_ID,U.USER_TYPE,U.USER_LANG,U.USER_COUNTRY FROM USERS U WHERE U.CODE= ? ";

			 pstmt = conn.prepareStatement(userSql);
			 pstmt.setString(1, userCode);
			 //pstmt.setString(2, password);
			 rs = pstmt.executeQuery();

			 if(rs.next())
			 {
				 userId = rs.getString(1);
				 loginEmpCode = rs.getString(2);
				 loginSiteCode = rs.getString(3);
				 entityCode = rs.getString(4);
				 profileId = rs.getString(5);
				 userType = rs.getString(6);
				 userLang = rs.getString(7);
				 userCountry = rs.getString(8);

			 }
			 extraParams = "loginCode="+userId+"~~loginEmpCode="+loginEmpCode+" ~~loginSiteCode="+loginSiteCode+" ~~entityCode="+entityCode+"     "
			 + "~~profileId="+profileId+"      ~~userType="+userType+"~~runMode=null~~user_lang="+userLang+"~~user_country="+userCountry+"~~charEnc=UTF-8~~"
			 + "termId="+chgTerm+"~~chgTerm="+chgTerm+"~~tranId=null";
			 pstmt.close();
			 rs.close();
		 }
		 catch ( Exception e )
		 {
			 throw new Exception(e) ;
		 }
		 finally
		 {
			 if (pstmt != null )
			 {
				 try 
				 {
					 pstmt.close();
					 rs.close();
				 } 
				 catch (SQLException e)
				 {

				 }
			 }
		 }
		 return extraParams;
	 } 

	 public String getUserInfo( String xtraParams )throws ITMException
	 {
		 StringBuffer userInfoStr = new StringBuffer();
		 String userId = "";
		 String loginEmpCode = "";
		 String loginSiteCode = "";
		 String entityCode = "";
		 String profileId = "";
		 String userType = "";

		 String chgTerm = "";
		 try
		 {
			 E12GenericUtility genericUtility = new E12GenericUtility();
			 userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			 loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			 loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			 entityCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode");
			 profileId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"profileId");
			 userType = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userType");

			 chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");

			 System.out.println("xtraParams  is @@@@@ " + xtraParams);

			 userInfoStr.append("<UserInfo>");
			 userInfoStr.append("<loginCode>").append("<![CDATA["+userId+"]]>").append("</loginCode>\r\n");
			 userInfoStr.append("<empCode>").append("<![CDATA["+loginEmpCode+"]]>").append("</empCode>\r\n");
			 userInfoStr.append("<siteCode>").append("<![CDATA["+loginSiteCode+"]]>").append("</siteCode>\r\n");
			 userInfoStr.append("<entityCode>").append("<![CDATA["+entityCode+"]]>").append("</entityCode>\r\n");
			 userInfoStr.append("<profileId>").append("<![CDATA["+profileId+"]]>").append("</profileId>\r\n");
			 userInfoStr.append("<userType>").append("<![CDATA["+userType+"]]>").append("</userType>\r\n");
			 userInfoStr.append("<remoteHost>").append("<![CDATA["+chgTerm+"]]>").append("</remoteHost>\r\n");
			 userInfoStr.append("<userLevel>").append("<![CDATA["+1+"]]>").append("</userLevel>\r\n");
			 userInfoStr.append("</UserInfo>");
		 }
		 catch ( Exception e )
		 {
			 throw new ITMException(e);
		 }
		 return userInfoStr.toString();
	 }

	 //Samadhan 
	 public String genericMapper(String xml,String clientXml,String objName,Connection conn) throws Exception
	 {
		 System.out.println("Inside Generic Mapper...................");
		 String mappedXml = "";
		 Document mapperDom = null,clientDom = null,transformDom = null;

		 NodeList mapperParentNodeList = null;
		 NodeList mapperFieldsNodeList = null;
		 Node mapperParentNode = null;
		 Node mapperFieldNode = null;
		 String mapperFieldNodeName = null;
		 int mapperFieldsNodeListLen;
		 int ctr =0 ;
		 FileInputStream genericMapFis = null;
		 ArrayList mappingSqlParam =new ArrayList();
		 ArrayList totalMatchNodeArr = new ArrayList();
		 ArrayList clientNode = new ArrayList();

		 String mappingSql = "";
		 PreparedStatement pstmt = null;
		 ResultSet rs = null;
		 String columnName = "";

		 NodeList matchNodeList = null;
		 Node xmlParentNode = null;
		 NodeList xmlchildNodeList = null;
		 int xmlchildNodeListLength = 0;

		 try
		 {
			 String defaultPath = null;
			 if( CommonConstants.APPLICATION_CONTEXT != null )
			 {
				 defaultPath = CommonConstants.APPLICATION_CONTEXT + File.separator;
			 }

			 E12GenericUtility genericUtility = new E12GenericUtility();
			 File genericMapFile = new File(defaultPath+"/setting/generic_map.xml");

			 StringBuffer mapperStrBuf = new StringBuffer();

			 genericMapFis = new FileInputStream(genericMapFile);
			 System.out.println("Total file size to read (in bytes) : "+ genericMapFis.available());

			 int content;
			 while ((content = genericMapFis.read()) != -1)
			 {
				 mapperStrBuf.append((char) content);
			 }
			 System.out.println("Generic Mapper XML file is= "+mapperStrBuf);

			 mapperDom = genericUtility.parseString(mapperStrBuf.toString());
			 clientDom = genericUtility.parseString(clientXml.toString());
			 transformDom = genericUtility.parseString(xml.toString());

			 mapperParentNodeList = mapperDom.getElementsByTagName(objName);
			 mapperParentNode = mapperParentNodeList.item(0);
			 mapperFieldsNodeList = mapperParentNode.getChildNodes();
			 mapperFieldsNodeListLen = mapperFieldsNodeList.getLength();
			 System.out.println("@@Mapper Fields Node Length ="+mapperFieldsNodeListLen);

			 for(ctr=0;ctr<mapperFieldsNodeListLen;ctr++)
			 {
				 mapperFieldNode = mapperFieldsNodeList.item(ctr);
				 mapperFieldNodeName = mapperFieldNode.getNodeName();
				 if (!(mapperFieldNode instanceof Text)) 
				 {
					 System.out.println("Mapper Field Node Name = "+mapperFieldNodeName);

					 matchNodeList = transformDom.getElementsByTagName(mapperFieldNodeName);
					 System.out.println("Match Fields NodeList Length="+matchNodeList.getLength());

					 if(matchNodeList.getLength() > 1)
					 {	 
						 for(int y=0;y<matchNodeList.getLength();y++)
						 {
							 System.out.println("Client Node Value="+matchNodeList.item(y).getChildNodes().item(0).getNodeValue());
							 System.out.println("Client Node Name="+matchNodeList.item(y).getNodeName());
							 totalMatchNodeArr.add(matchNodeList.item(y).getChildNodes().item(0).getNodeValue());
						 }
					 }

					 for(int i = 1; i <= mapperFieldNode.getChildNodes().getLength(); i++)
					 {	 
						 Node mapperFieldChildNodes =  mapperFieldNode.getChildNodes().item(i);

						 if (!(mapperFieldChildNodes instanceof Text)) 
						 {
							 if(mapperFieldChildNodes != null)
							 {	
								 System.out.println("Mapper Fields Child Node Name= "+mapperFieldChildNodes.getNodeName());

								 if(mapperFieldChildNodes.getNodeName().equalsIgnoreCase("sql_input"))
								 {
									 for(int j = 1; j <= mapperFieldChildNodes.getChildNodes().getLength(); j++)
									 {
										 Node sqlChildNode =  mapperFieldChildNodes.getChildNodes().item(j);

										 if (!(sqlChildNode instanceof Text)) 
										 {
											 if(sqlChildNode != null)
											 {	
												 System.out.println("SQL Params="+sqlChildNode.getNodeName());
												 System.out.println("SQL Input="+sqlChildNode.getChildNodes().item(0).getNodeValue());
												 mappingSqlParam.add(sqlChildNode.getChildNodes().item(0).getNodeValue());
											 }	
										 }
									 }
								 }
								 else
								 {
									 mappingSql = mapperFieldChildNodes.getChildNodes().item(0).getNodeValue();
									 System.out.println("Mapping SQL Query= "+mappingSql);
								 }
							 }
						 }
					 }

					 System.out.println("Mapping Field is= "+mapperFieldNodeName);
					 System.out.println("Mapping SQL is= "+mappingSql);
					 System.out.println("Mapping SQL Parameters are");
					 for (Iterator<String> iter = mappingSqlParam.iterator() ; iter.hasNext(); )
					 {
						 System.out.println("\t"+iter.next());
					 }

					 for(int y=0; y<matchNodeList.getLength(); y++)
					 {	
						 pstmt = conn.prepareStatement(mappingSql);
						 int count = 1;

						 for(Object sqlParamIter : mappingSqlParam)
						 {	
							 if(matchNodeList.getLength() > 1)
							 {
								 String sqlParamValue = totalMatchNodeArr.get(y).toString();
								 System.out.println("SQL Param Value from client DOM is = "+sqlParamValue);
								 pstmt.setString(count++, sqlParamValue.trim());
							 }
							 else
							 {	
								 String[] splitSqlParam =  sqlParamIter.toString().split(":");
								 String sqlParamValue = "";
								 System.out.println("SQL Param Hierarchy ="+splitSqlParam.length);

								 if(splitSqlParam.length > 1)
								 {
									 NodeList curentNodeList = clientDom.getElementsByTagName(splitSqlParam[0]);
									 Node splitNode = curentNodeList.item(0);
									 NodeList currNodeChildList = splitNode.getChildNodes();
									 int pos = 1;
									 System.out.println("searching node = "+splitSqlParam[pos]);
									 for(int paramNodeLevel = 0; paramNodeLevel<currNodeChildList.getLength(); paramNodeLevel++)
									 {
										 String name = currNodeChildList.item(paramNodeLevel).getNodeName();
										 System.out.println("getting node from client dom = "+name);

										 if(name.equalsIgnoreCase(splitSqlParam[pos]))
										 {
											 System.out.println("Node Found pos="+pos);
											 if((pos+1)==splitSqlParam.length)
											 {
												 sqlParamValue = currNodeChildList.item(paramNodeLevel).getChildNodes().item(0).getNodeValue();
												 break;
											 }
											 else
											 {
												 currNodeChildList = currNodeChildList.item(paramNodeLevel).getChildNodes();
												 pos++;
												 paramNodeLevel=0;
												 //continue;
											 }
										 }
									 }
									 System.out.println("Read Value from client DOM="+sqlParamValue);
									 pstmt.setString(count++, sqlParamValue.trim());
								 }
								 else
								 {	
									 sqlParamValue = genericUtility.getColumnValue(sqlParamIter.toString(), clientDom);
									 System.out.println("Read Value from client DOM="+sqlParamValue);
									 pstmt.setString(count++, sqlParamValue.trim());
								 }	
							 }
						 }
						 rs = pstmt.executeQuery();
						 if (rs.next()) 
						 {
							 String value = checkNullAndTrim(rs.getString(mapperFieldNodeName));
							 System.out.println(mapperFieldNodeName+"="+value);

							 if(matchNodeList.getLength() > 1)
							 {
								 matchNodeList.item(y).getChildNodes().item(0).setNodeValue(value);
							 }
							 else
							 {	
								 setNodeValue(transformDom,mapperFieldNodeName,value);
							 }	
						 }
						 if(rs != null) {rs.close();rs = null;}
						 if(pstmt != null) {pstmt.close();pstmt = null;}
					 }
					 mappingSqlParam.clear();
					 totalMatchNodeArr.clear();
				 }
			 }
			 mappedXml = genericUtility.serializeDom(transformDom);//returning final xml after mapping
		 }
		 catch(Exception e)
		 {
			 e.printStackTrace();
			 throw new Exception(e);
		 }
		 finally
		 {
			 System.out.println("@@Inside genericMapper finally");
			 try
			 {
				 if (genericMapFis != null)
					 genericMapFis.close();
				 if(rs != null) {rs.close();rs = null;}
				 if(pstmt != null) {pstmt.close();pstmt = null;}
			 } 
			 catch (Exception ex) 
			 {
				 ex.printStackTrace();
			 }
		 }
		 return mappedXml;
	 }

	 public String genericMapperNew(String xml,String clientXml,String objName,Connection conn) throws Exception
	 {
		 System.out.println("Inside Generic Mapper...................");
		 String mappedXml = "";
		 Document mapperDom = null,clientDom = null,transformDom = null;

		 NodeList mapperParentNodeList = null;
		 NodeList mapperFieldsNodeList = null;
		 NodeList mapperDetailNodeList = null;
		 NodeList transformFieldList = null;


		 Node mapperParentNode = null;
		 Node mapperFieldNode = null;
		 Node mapperDetailNode = null;
		 Node matchNode = null;

		 String currentMapperDetail = "";
		 String currentTransformDetail = "";


		 String mapperFieldNodeName = null;
		 int mapperFieldsNodeListLen;
		 int ctr =0 ;
		 FileInputStream genericMapFis = null;
		 ArrayList mappingSqlParam =new ArrayList();
		 ArrayList totalMatchNodeArr = new ArrayList();
		 ArrayList clientNode = new ArrayList();

		 String mappingSql = "";
		 PreparedStatement pstmt = null;
		 ResultSet rs = null;
		 String columnName = "";

		 NodeList matchNodeList = null;
		 Node xmlParentNode = null;
		 NodeList xmlchildNodeList = null;
		 int xmlchildNodeListLength = 0;
		 Element element= null;

		 try
		 {
			 String defaultPath = null;
			 if( CommonConstants.APPLICATION_CONTEXT != null )
			 {
				 defaultPath = CommonConstants.APPLICATION_CONTEXT + File.separator;
			 }

			 E12GenericUtility genericUtility = new E12GenericUtility();
			 File genericMapFile = new File(defaultPath+"/setting/generic_map.xml");

			 StringBuffer mapperStrBuf = new StringBuffer();

			 genericMapFis = new FileInputStream(genericMapFile);
			 System.out.println("Total file size to read (in bytes) : "+ genericMapFis.available());

			 int content;
			 while ((content = genericMapFis.read()) != -1)
			 {
				 mapperStrBuf.append((char) content);
			 }
			 System.out.println("Generic Mapper XML file is= "+mapperStrBuf);

			 mapperDom = genericUtility.parseString(mapperStrBuf.toString());
			 clientDom = genericUtility.parseString(clientXml.toString());
			 transformDom = genericUtility.parseString(xml.toString());

			 mapperParentNodeList = mapperDom.getElementsByTagName(objName);
			 mapperParentNode = mapperParentNodeList.item(0);
			 mapperDetailNodeList = mapperParentNode.getChildNodes();

			 System.out.println("@@Mapper Detail Node Length ="+mapperDetailNodeList.getLength());

			 for(int ctrDtl = 0; ctrDtl<mapperDetailNodeList.getLength();ctrDtl++)
			 {
				 mapperDetailNode = mapperDetailNodeList.item(ctrDtl);
				 if (!(mapperDetailNode instanceof Text)) 
				 {
					 currentMapperDetail = mapperDetailNodeList.item(ctrDtl).getNodeName();
					 System.out.println("Mapper Current Detail Node ="+currentMapperDetail);
					 mapperFieldsNodeList =  mapperDetailNodeList.item(ctrDtl).getChildNodes();
					 mapperFieldsNodeListLen = mapperFieldsNodeList.getLength();
					 System.out.println("@@Mapper Fields Node Length ="+mapperFieldsNodeListLen);

					 transformFieldList  = transformDom.getElementsByTagName(currentMapperDetail);

					 for(ctr=0;ctr<mapperFieldsNodeListLen;ctr++)
					 {

						 mapperFieldNode = mapperFieldsNodeList.item(ctr);
						 mapperFieldNodeName = mapperFieldNode.getNodeName();
						 if (!(mapperFieldNode instanceof Text)) 
						 {
							 System.out.println("Mapper Field Node Name = "+mapperFieldNodeName);

							 matchNodeList = transformFieldList.item(0).getChildNodes();
							 element = (Element) transformFieldList.item(0);
							 for(int cntTran = 0;cntTran<matchNodeList.getLength();cntTran++)
							 {
								 matchNode = matchNodeList.item(cntTran);
								 if(mapperFieldNodeName.equalsIgnoreCase(matchNode.getNodeName()))
								 {	
									 System.out.println("Match Fields node Name="+matchNode.getNodeName());

									 for(int i = 1; i <= mapperFieldNode.getChildNodes().getLength(); i++)
									 {	 
										 Node mapperFieldChildNodes =  mapperFieldNode.getChildNodes().item(i);

										 if (!(mapperFieldChildNodes instanceof Text)) 
										 {
											 if(mapperFieldChildNodes != null)
											 {	
												 System.out.println("Mapper Fields Child Node Name= "+mapperFieldChildNodes.getNodeName());

												 if(mapperFieldChildNodes.getNodeName().equalsIgnoreCase("sql_input"))
												 {
													 for(int j = 1; j <= mapperFieldChildNodes.getChildNodes().getLength(); j++)
													 {
														 Node sqlChildNode =  mapperFieldChildNodes.getChildNodes().item(j);

														 if (!(sqlChildNode instanceof Text)) 
														 {
															 if(sqlChildNode != null)
															 {	
																 System.out.println("SQL Params="+sqlChildNode.getNodeName());
																 System.out.println("SQL Input="+sqlChildNode.getChildNodes().item(0).getNodeValue());
																 mappingSqlParam.add(sqlChildNode.getChildNodes().item(0).getNodeValue());
															 }	
														 }
													 }
												 }
												 else
												 {
													 mappingSql = mapperFieldChildNodes.getChildNodes().item(0).getNodeValue();
													 System.out.println("Mapping SQL Query= "+mappingSql);
												 }
											 }
										 }
									 }

									 System.out.println("Mapping Field is= "+mapperFieldNodeName);
									 System.out.println("Mapping SQL is= "+mappingSql);
									 System.out.println("Mapping SQL Parameters are");
									 for (Iterator<String> iter = mappingSqlParam.iterator() ; iter.hasNext(); )
									 {
										 System.out.println("\t"+iter.next());
									 }


									 pstmt = conn.prepareStatement(mappingSql);
									 int count = 1;

									 for(Object sqlParamIter : mappingSqlParam)
									 {	
										 String[] splitSqlParam =  sqlParamIter.toString().split(":");
										 String sqlParamValue = "";
										 System.out.println("SQL Param Hierarchy ="+splitSqlParam.length);

										 if(splitSqlParam.length > 1)
										 {
											 NodeList curentNodeList = clientDom.getElementsByTagName(splitSqlParam[0]);
											 Node splitNode = curentNodeList.item(0);
											 NodeList currNodeChildList = splitNode.getChildNodes();
											 int pos = 1;
											 System.out.println("searching node = "+splitSqlParam[pos]);
											 for(int paramNodeLevel = 0; paramNodeLevel<currNodeChildList.getLength(); paramNodeLevel++)
											 {
												 String name = currNodeChildList.item(paramNodeLevel).getNodeName();
												 System.out.println("getting node from client dom = "+name);

												 if(name.equalsIgnoreCase(splitSqlParam[pos]))
												 {
													 System.out.println("Node Found pos="+pos);
													 if((pos+1)==splitSqlParam.length)
													 {
														 sqlParamValue = currNodeChildList.item(paramNodeLevel).getChildNodes().item(0).getNodeValue();
														 break;
													 }
													 else
													 {
														 currNodeChildList = currNodeChildList.item(paramNodeLevel).getChildNodes();
														 pos++;
														 paramNodeLevel=0;
														 //continue;
													 }
												 }
											 }
											 System.out.println("Read Value from client DOM="+sqlParamValue);
											 pstmt.setString(count++, sqlParamValue.trim());
										 }
										 else
										 {	
											 sqlParamValue = genericUtility.getColumnValue(sqlParamIter.toString(), clientDom);
											 System.out.println("Read Value from client DOM="+sqlParamValue);
											 pstmt.setString(count++, sqlParamValue.trim());
										 }	

									 }
									 rs = pstmt.executeQuery();
									 if (rs.next()) 
									 {
										 String value = checkNullAndTrim(rs.getString(mapperFieldNodeName));
										 System.out.println(mapperFieldNodeName+"="+value);
										 matchNode.setNodeValue(value);	
										 System.out.println("Element:"+element);
										 //Node fieldNode = element.getElementsByTagName(mapperFieldNodeName).item(0).getFirstChild();
										 //fieldNode.setNodeValue(value);

									 }
									 if(rs != null) {rs.close();rs = null;}
									 if(pstmt != null) {pstmt.close();pstmt = null;}

									 mappingSqlParam.clear();
									 totalMatchNodeArr.clear();
								 }
							 }
							 mappedXml = genericUtility.serializeDom(transformDom);//returning final xml after mapping
						 }
					 }
				 }
			 }
		 }
		 catch(Exception e)
		 {
			 e.printStackTrace();
			 throw new Exception(e);
		 }
		 finally
		 {
			 System.out.println("@@Inside genericMapper finally");
			 try
			 {
				 if (genericMapFis != null)
					 genericMapFis.close();
				 if(rs != null) {rs.close();rs = null;}
				 if(pstmt != null) {pstmt.close();pstmt = null;}
			 } 
			 catch (Exception ex) 
			 {
				 ex.printStackTrace();
			 }
		 }
		 return mappedXml;
	 }


	 public String genericMapperNew1(String xml,String clientXml,String objName,Connection conn) throws Exception
	 {
		 System.out.println("Inside Generic Mapper...................");
		 String mappedXml = "";
		 Document mapperDom = null,clientDom = null,transformDom = null;

		 NodeList mapperParentNodeList = null;
		 NodeList mapperFieldsNodeList = null;
		 NodeList mapperDetailNodeList = null;
		 NodeList transformFieldList = null;


		 Node mapperParentNode = null;
		 Node mapperFieldNode = null;
		 Node mapperDetailNode = null;
		 Node matchNode = null;

		 String currentMapperDetail = "";
		 String currentTransformDetail = "";


		 String mapperFieldNodeName = null;
		 int mapperFieldsNodeListLen;
		 int ctr =0 ;
		 FileInputStream genericMapFis = null;
		 ArrayList mappingSqlParam =new ArrayList();
		 ArrayList totalMatchNodeArr = new ArrayList();
		 ArrayList clientNode = new ArrayList();

		 String mappingSql = "";
		 PreparedStatement pstmt = null;
		 ResultSet rs = null;
		 String columnName = "";

		 NodeList matchNodeList = null;
		 Node xmlParentNode = null;
		 NodeList xmlchildNodeList = null;
		 int xmlchildNodeListLength = 0;
		 Element element= null;

		 try
		 {
			 String defaultPath = null;
			 if( CommonConstants.APPLICATION_CONTEXT != null )
			 {
				 defaultPath = CommonConstants.APPLICATION_CONTEXT + File.separator;
			 }

			 E12GenericUtility genericUtility = new E12GenericUtility();
			 File genericMapFile = new File(defaultPath+"/setting/generic_map.xml");

			 StringBuffer mapperStrBuf = new StringBuffer();

			 genericMapFis = new FileInputStream(genericMapFile);
			 System.out.println("Total file size to read (in bytes) : "+ genericMapFis.available());

			 int content;
			 while ((content = genericMapFis.read()) != -1)
			 {
				 mapperStrBuf.append((char) content);
			 }
			 System.out.println("Generic Mapper XML file is= "+mapperStrBuf);

			 mapperDom = genericUtility.parseString(mapperStrBuf.toString());
			 clientDom = genericUtility.parseString(clientXml.toString());
			 transformDom = genericUtility.parseString(xml.toString());

			 mapperParentNodeList = mapperDom.getElementsByTagName(objName);
			 mapperParentNode = mapperParentNodeList.item(0);
			 mapperDetailNodeList = mapperParentNode.getChildNodes();

			 System.out.println("@@Mapper Detail Node Length ="+mapperDetailNodeList.getLength());

			 for(int ctrDtl = 0; ctrDtl<mapperDetailNodeList.getLength();ctrDtl++)
			 {
				 mapperDetailNode = mapperDetailNodeList.item(ctrDtl);
				 if (!(mapperDetailNode instanceof Text)) 
				 {
					 currentMapperDetail = mapperDetailNodeList.item(ctrDtl).getNodeName();
					 System.out.println("Mapper Current Detail Node ="+currentMapperDetail);
					 mapperFieldsNodeList =  mapperDetailNodeList.item(ctrDtl).getChildNodes();
					 mapperFieldsNodeListLen = mapperFieldsNodeList.getLength();
					 System.out.println("@@Mapper Fields Node Length ="+mapperFieldsNodeListLen);

					 transformFieldList  = transformDom.getElementsByTagName(currentMapperDetail);

					 for(ctr=0;ctr<mapperFieldsNodeListLen;ctr++)
					 {
						 mapperFieldNode = mapperFieldsNodeList.item(ctr);
						 mapperFieldNodeName = mapperFieldNode.getNodeName();
						 if (!(mapperFieldNode instanceof Text)) 
						 {
							 System.out.println("Mapper Field Node Name = "+mapperFieldNodeName);

							 for(int cnt=0; cnt<transformFieldList.getLength();cnt++)
							 {
								 element = (Element) transformFieldList.item(cnt); 
								 Node name = element.getElementsByTagName(mapperFieldNodeName).item(0).getFirstChild();

								 for(int i = 1; i <= mapperFieldNode.getChildNodes().getLength(); i++)
								 {	 
									 Node mapperFieldChildNodes =  mapperFieldNode.getChildNodes().item(i);

									 if (!(mapperFieldChildNodes instanceof Text)) 
									 {
										 if(mapperFieldChildNodes != null)
										 {	
											 System.out.println("Mapper Fields Child Node Name= "+mapperFieldChildNodes.getNodeName());

											 if(mapperFieldChildNodes.getNodeName().equalsIgnoreCase("sql_input"))
											 {
												 for(int j = 1; j <= mapperFieldChildNodes.getChildNodes().getLength(); j++)
												 {
													 Node sqlChildNode =  mapperFieldChildNodes.getChildNodes().item(j);

													 if (!(sqlChildNode instanceof Text)) 
													 {
														 if(sqlChildNode != null)
														 {	
															 System.out.println("SQL Params="+sqlChildNode.getNodeName());
															 System.out.println("SQL Input="+sqlChildNode.getChildNodes().item(0).getNodeValue());
															 mappingSqlParam.add(sqlChildNode.getChildNodes().item(0).getNodeValue());
														 }	
													 }
												 }
											 }
											 else
											 {
												 mappingSql = mapperFieldChildNodes.getChildNodes().item(0).getNodeValue();
												 System.out.println("Mapping SQL Query= "+mappingSql);
											 }
										 }
									 }
								 }

								 name.setNodeValue(name.getNodeValue().toUpperCase());
							 }


							 matchNodeList = transformFieldList.item(0).getChildNodes();
							 element = (Element) transformFieldList.item(0);
							 for(int cntTran = 0;cntTran<matchNodeList.getLength();cntTran++)
							 {
								 matchNode = matchNodeList.item(cntTran);
								 if(mapperFieldNodeName.equalsIgnoreCase(matchNode.getNodeName()))
								 {	
									 System.out.println("Match Fields node Name="+matchNode.getNodeName());

									 for(int i = 1; i <= mapperFieldNode.getChildNodes().getLength(); i++)
									 {	 
										 Node mapperFieldChildNodes =  mapperFieldNode.getChildNodes().item(i);

										 if (!(mapperFieldChildNodes instanceof Text)) 
										 {
											 if(mapperFieldChildNodes != null)
											 {	
												 System.out.println("Mapper Fields Child Node Name= "+mapperFieldChildNodes.getNodeName());

												 if(mapperFieldChildNodes.getNodeName().equalsIgnoreCase("sql_input"))
												 {
													 for(int j = 1; j <= mapperFieldChildNodes.getChildNodes().getLength(); j++)
													 {
														 Node sqlChildNode =  mapperFieldChildNodes.getChildNodes().item(j);

														 if (!(sqlChildNode instanceof Text)) 
														 {
															 if(sqlChildNode != null)
															 {	
																 System.out.println("SQL Params="+sqlChildNode.getNodeName());
																 System.out.println("SQL Input="+sqlChildNode.getChildNodes().item(0).getNodeValue());
																 mappingSqlParam.add(sqlChildNode.getChildNodes().item(0).getNodeValue());
															 }	
														 }
													 }
												 }
												 else
												 {
													 mappingSql = mapperFieldChildNodes.getChildNodes().item(0).getNodeValue();
													 System.out.println("Mapping SQL Query= "+mappingSql);
												 }
											 }
										 }
									 }

									 System.out.println("Mapping Field is= "+mapperFieldNodeName);
									 System.out.println("Mapping SQL is= "+mappingSql);
									 System.out.println("Mapping SQL Parameters are");
									 for (Iterator<String> iter = mappingSqlParam.iterator() ; iter.hasNext(); )
									 {
										 System.out.println("\t"+iter.next());
									 }


									 pstmt = conn.prepareStatement(mappingSql);
									 int count = 1;

									 for(Object sqlParamIter : mappingSqlParam)
									 {	
										 String[] splitSqlParam =  sqlParamIter.toString().split(":");
										 String sqlParamValue = "";
										 System.out.println("SQL Param Hierarchy ="+splitSqlParam.length);

										 if(splitSqlParam.length > 1)
										 {
											 NodeList curentNodeList = clientDom.getElementsByTagName(splitSqlParam[0]);
											 Node splitNode = curentNodeList.item(0);
											 NodeList currNodeChildList = splitNode.getChildNodes();
											 int pos = 1;
											 System.out.println("searching node = "+splitSqlParam[pos]);
											 for(int paramNodeLevel = 0; paramNodeLevel<currNodeChildList.getLength(); paramNodeLevel++)
											 {
												 String name = currNodeChildList.item(paramNodeLevel).getNodeName();
												 System.out.println("getting node from client dom = "+name);

												 if(name.equalsIgnoreCase(splitSqlParam[pos]))
												 {
													 System.out.println("Node Found pos="+pos);
													 if((pos+1)==splitSqlParam.length)
													 {
														 sqlParamValue = currNodeChildList.item(paramNodeLevel).getChildNodes().item(0).getNodeValue();
														 break;
													 }
													 else
													 {
														 currNodeChildList = currNodeChildList.item(paramNodeLevel).getChildNodes();
														 pos++;
														 paramNodeLevel=0;
														 //continue;
													 }
												 }
											 }
											 System.out.println("Read Value from client DOM="+sqlParamValue);
											 pstmt.setString(count++, sqlParamValue.trim());
										 }
										 else
										 {	
											 sqlParamValue = genericUtility.getColumnValue(sqlParamIter.toString(), clientDom);
											 System.out.println("Read Value from client DOM="+sqlParamValue);
											 pstmt.setString(count++, sqlParamValue.trim());
										 }	

									 }
									 rs = pstmt.executeQuery();
									 if (rs.next()) 
									 {
										 String value = checkNullAndTrim(rs.getString(mapperFieldNodeName));
										 System.out.println(mapperFieldNodeName+"="+value);
										 matchNode.setNodeValue(value);	
										 System.out.println("Element:"+element);
										 //Node fieldNode = element.getElementsByTagName(mapperFieldNodeName).item(0).getFirstChild();
										 //fieldNode.setNodeValue(value);

									 }
									 if(rs != null) {rs.close();rs = null;}
									 if(pstmt != null) {pstmt.close();pstmt = null;}

									 mappingSqlParam.clear();
									 totalMatchNodeArr.clear();
								 }
							 }
							 mappedXml = genericUtility.serializeDom(transformDom);//returning final xml after mapping
						 }
					 }
				 }
			 }
		 }
		 catch(Exception e)
		 {
			 e.printStackTrace();
			 throw new Exception(e);
		 }
		 finally
		 {
			 System.out.println("@@Inside genericMapper finally");
			 try
			 {
				 if (genericMapFis != null)
					 genericMapFis.close();
				 if(rs != null) {rs.close();rs = null;}
				 if(pstmt != null) {pstmt.close();pstmt = null;}
			 } 
			 catch (Exception ex) 
			 {
				 ex.printStackTrace();
			 }
		 }
		 return mappedXml;
	 }


	 public String genericMapperNew2(String xml,String clientXml,String objName,Connection conn) throws Exception
	 {
		 System.out.println("Inside Generic Mapper...................");
		 String mappedXml = "";
		 Document mapperDom = null,clientDom = null,transformDom = null,tempTransDom = null;

		 NodeList mapperParentNodeList = null;
		 NodeList mapperFieldsNodeList = null;
		 NodeList mapperDetailNodeList = null;
		 NodeList transformFieldList = null;


		 Node mapperParentNode = null;
		 Node mapperFieldNode = null;
		 Node mapperDetailNode = null;
		 Node matchNode = null;

		 String currentMapperDetail = "";
		 String currentTransformDetail = "";


		 String mapperFieldNodeName = null;
		 int mapperFieldsNodeListLen;
		 int ctr =0 ;
		 FileInputStream genericMapFis = null;
		 ArrayList mappingSqlParam =new ArrayList();
		 ArrayList mappingSqlParamType =new ArrayList();
		 ArrayList totalMatchNodeArr = new ArrayList();
		 ArrayList clientNode = new ArrayList();

		 String mappingSql = "";
		 PreparedStatement pstmt = null;
		 ResultSet rs = null;
		 String columnName = "";

		 NodeList matchNodeList = null;
		 Node xmlParentNode = null;
		 NodeList xmlchildNodeList = null;
		 int xmlchildNodeListLength = 0;
		 Element element= null;
		 String domId = "";
		 try
		 {
			 String defaultPath = null;
			 if( CommonConstants.APPLICATION_CONTEXT != null )
			 {
				 defaultPath = CommonConstants.APPLICATION_CONTEXT + File.separator;
			 }

			 E12GenericUtility genericUtility = new E12GenericUtility();
			 File genericMapFile = new File(defaultPath+"/setting/generic_map.xml");

			 StringBuffer mapperStrBuf = new StringBuffer();

			 genericMapFis = new FileInputStream(genericMapFile);
			 System.out.println("Total file size to read (in bytes) : "+ genericMapFis.available());

			 int content;
			 while ((content = genericMapFis.read()) != -1)
			 {
				 mapperStrBuf.append((char) content);
			 }
			 System.out.println("Generic Mapper XML file is= "+mapperStrBuf);

			 mapperDom = genericUtility.parseString(mapperStrBuf.toString());
			 clientDom = genericUtility.parseString(clientXml.toString());
			 transformDom = genericUtility.parseString(xml.toString());
			 tempTransDom = genericUtility.parseString(xml.toString());

			 mapperParentNodeList = mapperDom.getElementsByTagName(objName);
			 mapperParentNode = mapperParentNodeList.item(0);
			 mapperDetailNodeList = mapperParentNode.getChildNodes();

			 System.out.println("@@Mapper Detail Node Length ="+mapperDetailNodeList.getLength());

			 for(int ctrDtl = 0; ctrDtl<mapperDetailNodeList.getLength();ctrDtl++)
			 {
				 mapperDetailNode = mapperDetailNodeList.item(ctrDtl);
				 if (!(mapperDetailNode instanceof Text)) 
				 {
					 currentMapperDetail = mapperDetailNodeList.item(ctrDtl).getNodeName();
					 System.out.println("Mapper Current Detail Node ="+currentMapperDetail);
					 mapperFieldsNodeList =  mapperDetailNodeList.item(ctrDtl).getChildNodes();
					 mapperFieldsNodeListLen = mapperFieldsNodeList.getLength();
					 System.out.println("@@Mapper Fields Node Length ="+mapperFieldsNodeListLen);

					 transformFieldList  = transformDom.getElementsByTagName(currentMapperDetail);

					 for(ctr=0;ctr<mapperFieldsNodeListLen;ctr++)
					 {
						 mapperFieldNode = mapperFieldsNodeList.item(ctr);
						 mapperFieldNodeName = mapperFieldNode.getNodeName();
						 if (!(mapperFieldNode instanceof Text)) 
						 {
							 System.out.println("Mapper Field Node Name = "+mapperFieldNodeName);

							 for(int cnt=0; cnt<transformFieldList.getLength();cnt++)
							 {
								 Node curDetail = transformFieldList.item(cnt);
								 domId = curDetail.getAttributes().getNamedItem("domID").getNodeValue();

								 element = (Element) transformFieldList.item(cnt); 
								 Node transformNode = element.getElementsByTagName(mapperFieldNodeName).item(0);
								 System.out.println("Current Dom Id = "+domId);
								 System.out.println("Current Element = "+element);
								 for(int i = 1; i <= mapperFieldNode.getChildNodes().getLength(); i++)
								 {	 
									 Node mapperFieldChildNodes =  mapperFieldNode.getChildNodes().item(i);

									 if (!(mapperFieldChildNodes instanceof Text)) 
									 {
										 if(mapperFieldChildNodes != null)
										 {	
											 if(mapperFieldChildNodes.getNodeName().equalsIgnoreCase("sql_input"))
											 {
												 for(int j = 1; j < mapperFieldChildNodes.getChildNodes().getLength(); j++)
												 {
													 NodeList sqlChildNodeList =  mapperFieldChildNodes.getChildNodes().item(j).getChildNodes();
													 for(int cntParam = 0;cntParam < sqlChildNodeList.getLength();cntParam++)
													 {
														 Node sqlChildNode = sqlChildNodeList.item(cntParam);
														 if (!(sqlChildNode instanceof Text)) 
														 {
															 if(sqlChildNode.getNodeName().equalsIgnoreCase("sql_input_col_name"))
															 {	
																 System.out.println("SQL Input="+sqlChildNode.getChildNodes().item(0).getNodeValue());
																 mappingSqlParam.add(sqlChildNode.getChildNodes().item(0).getNodeValue());
															 }	
															 if(sqlChildNode.getNodeName().equalsIgnoreCase("sql_input_type"))
															 {
																 System.out.println("SQL Input Type="+sqlChildNode.getChildNodes().item(0).getNodeValue());
																 mappingSqlParamType.add(sqlChildNode.getChildNodes().item(0).getNodeValue());
															 }
														 }
													 }

												 }
											 }
											 else
											 {
												 mappingSql = mapperFieldChildNodes.getChildNodes().item(0).getNodeValue();
												 System.out.println("Mapping SQL Query= "+mappingSql);
											 }
										 }
									 }
								 }


								 System.out.println("Mapping Field is= "+mapperFieldNodeName);
								 System.out.println("Mapping SQL is= "+mappingSql);
								 System.out.println("Mapping SQL Parameters are");
								 for (Iterator<String> iter = mappingSqlParam.iterator() ; iter.hasNext(); )
								 {
									 System.out.println("\t"+iter.next());
								 }


								 pstmt = conn.prepareStatement(mappingSql);
								 int count = 1;

								 for(Object sqlParamIter : mappingSqlParam)
								 {
									 String sqlParamValue = getNodeValue(sqlParamIter.toString(), domId, tempTransDom);
									 String dataType = mappingSqlParamType.get(count-1).toString();
									 String val = sqlParamValue.trim();
									 int prepCount = count++;
									 System.out.println("Sql Parameter Data Type= "+dataType);
									 if((dataType.toUpperCase().indexOf("STRING") != -1) || (dataType.toUpperCase().indexOf("CHAR") != -1) || (dataType.toUpperCase().indexOf("VARCHAR") != -1)) 
									 {
										 pstmt.setString(prepCount, String.valueOf(val));
									 }
									 else if((dataType.toUpperCase().indexOf("DECIMAL") != -1) || (dataType.toUpperCase().indexOf("DOUBLE") != -1) || (dataType.toUpperCase().indexOf("NUMBER") != -1) || (dataType.toUpperCase().indexOf("LONG") != -1)) 
									 {
										 pstmt.setDouble(prepCount, Double.valueOf(val).doubleValue());
									 }
									 else if((dataType.toUpperCase().indexOf("DATETIME") != -1) || (dataType.toUpperCase().indexOf("TIMESTAMP") != -1)) 
									 {
										 String dbDateStr = getValidDateTimeString(val, getApplDateFormat(), getDBDateFormat());
										 pstmt.setTimestamp(prepCount, java.sql.Timestamp.valueOf(dbDateStr));
									 }
									 else if(dataType.toUpperCase().indexOf("DATE") != -1 ) 
									 {
										 String dbDateStr = getValidDateString(val, getApplDateFormat(), getDBDateFormat());
										 pstmt.setDate(prepCount, java.sql.Date.valueOf(dbDateStr));
									 }

								 }

								 rs = pstmt.executeQuery();
								 if (rs.next()) 
								 {
									 String value = checkNullAndTrim(rs.getString(1));
									 System.out.println(mapperFieldNodeName+"="+value);
									 //matchNode.setNodeValue(value);	
									 System.out.println("Element:"+element);

									 System.out.println("TransformNode:"+transformNode);
									 /*if(transformNode != null)
										{
										System.out.println("TransformNode:"+transformNode.getNodeName());
										transformNode.setNodeValue(value);
										}*/

									 Node colValueNode = transformNode.getFirstChild();
									 if(colValueNode != null && colValueNode.getNodeValue() != null)
									 {
										 colValueNode.setNodeValue(value);
									 }
									 else
									 {
										 CDATASection cDataSection = transformDom.createCDATASection(value);
										 transformNode.appendChild(cDataSection);
									 }
									 System.out.println(mapperFieldNodeName+" mapping done!!!!!!!!!!!!!!!!\n\n\n");
									 System.out.println("********************************************************");
								 }
								 if(rs != null) {rs.close();rs = null;}
								 if(pstmt != null) {pstmt.close();pstmt = null;}

								 mappingSqlParam.clear();
								 totalMatchNodeArr.clear();
								 mappingSqlParamType.clear();
							 }


						 }
					 }
					 mappedXml = genericUtility.serializeDom(transformDom);//returning final xml after mapping
				 }
			 }
		 }
		 catch(Exception e)
		 {
			 e.printStackTrace();
			 throw new Exception(e);
		 }
		 finally
		 {
			 System.out.println("@@Inside genericMapper finally");
			 try
			 {
				 if (genericMapFis != null)
					 genericMapFis.close();
				 if(rs != null) {rs.close();rs = null;}
				 if(pstmt != null) {pstmt.close();pstmt = null;}
			 } 
			 catch (Exception ex) 
			 {
				 ex.printStackTrace();
			 }
		 }
		 return mappedXml;
	 }



	 private static void updateElementValue(Document doc) {
		 NodeList employees = doc.getElementsByTagName("Employee");
		 Element emp = null;
		 //loop for each employee
		 for(int i=0; i<employees.getLength();i++)
		 {
			 emp = (Element) employees.item(i);
			 Node name = emp.getElementsByTagName("name").item(0).getFirstChild();
			 name.setNodeValue(name.getNodeValue().toUpperCase());
		 }
	 }

	 private String getNodeValue(String fieldName,String domId,Document tempDom)
	 {
		 String[] fieldArr = fieldName.split("\\.");
		 String formNo = fieldArr[1];
		 String rowNo = fieldArr[2];
		 String parameterName = fieldArr[3];
		 if("X".equalsIgnoreCase(rowNo))
		 {
			 rowNo = domId;
		 }
		 String actualValue ="";
		 try 
		 {
			 actualValue = new E12GenericUtility().getColumnValue(parameterName,tempDom,formNo,rowNo);
		 } catch (ITMException e) {

			 e.printStackTrace();
		 }

		 return actualValue;
	 }

	 public  String prettyXMLFormat(String input, int indent) 
	 {
		 try 
		 {
			 Source xmlInput = new StreamSource(new StringReader(input));
			 StringWriter stringWriter = new StringWriter();
			 StreamResult xmlOutput = new StreamResult(stringWriter);
			 TransformerFactory transformerFactory = TransformerFactory.newInstance();
			 transformerFactory.setAttribute("indent-number", indent);
			 Transformer transformer = transformerFactory.newTransformer(); 
			 transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			 transformer.transform(xmlInput, xmlOutput);
			 return xmlOutput.getWriter().toString();
		 } catch (Exception e) {
			 throw new RuntimeException(e); // simple exception handling, please review it
		 }
	 }
	 private String getApplDateFormat()throws ITMException,Exception
	 {
		 String dateFormatStr = null;
		 try
		 {
			 DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			 DocumentBuilder db = dbf.newDocumentBuilder();
			 Document doc = db.parse(CommonConstants.APPLICATION_CONTEXT + File.separator + "setting" + File.separator + "DateFormat.xml"); 
			 NodeList nlDateFormat = doc.getElementsByTagName("APPL_DATE_FORMAT"); 
			 Node ndDateFormat = nlDateFormat.item(0);
			 dateFormatStr = ndDateFormat.getFirstChild().getNodeValue();
		 }
		 catch(Exception e)
		 {
			 System.out.println("Exception :SapSorderEJB :getApplDateFormat :==>\n"+e); 
			 throw new ITMException(e);
		 }
		 return dateFormatStr;
	 }
	 private String getDBDateFormat()throws ITMException, Exception
	 {
		 String dateFormatStr = null;
		 try
		 {
			 DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			 DocumentBuilder db = dbf.newDocumentBuilder();
			 Document doc = db.parse(CommonConstants.APPLICATION_CONTEXT + File.separator + "setting" + File.separator + "DateFormat.xml");
			 NodeList nlDateFormat = doc.getElementsByTagName("DB_DATE_FORMAT"); 
			 Node ndDateFormat = nlDateFormat.item(0);
			 dateFormatStr = ndDateFormat.getFirstChild().getNodeValue();
			 System.out.println("dateFormatStr:"+dateFormatStr); 
		 }
		 catch(Exception e)
		 {
			 System.out.println("Exception :SapSorderEJB :getDBDateFormat :==>\n"+e); 
			 throw new ITMException(e);
		 }
		 return dateFormatStr;
	 }

	 private String getValidDateTimeString(String dateTimeStr, String sourceDateTimeFormat, String targetDateTimeFormat) throws ITMException
	 {
		 System.out.println("Getting the valid datetime string for dateTimeStr :"+dateTimeStr+": which is in format :"+sourceDateTimeFormat); 
		 Object date = null;
		 String retDateStr = ""; 
		 try
		 {
			 if (!(sourceDateTimeFormat.equalsIgnoreCase(targetDateTimeFormat)))
			 {
				 if (sourceDateTimeFormat.indexOf("/") != -1) 
				 {
					 dateTimeStr.replace('/', '-');
				 }
				 else if (sourceDateTimeFormat.indexOf(".") != -1) 
				 {
					 dateTimeStr.replace('.', '-');
				 }
				 date = new SimpleDateFormat(sourceDateTimeFormat).parse(dateTimeStr+((dateTimeStr.length() > 10 ) ? "" : " 00:00:00" ) ); 

				 SimpleDateFormat sdfOutput = new SimpleDateFormat( targetDateTimeFormat+" HH:mm:ss" ); 
				 retDateStr = sdfOutput.format(date);
			 }
			 else
			 {
				 retDateStr = dateTimeStr;
			 }
		 }
		 catch (Exception e)
		 {
			 System.out.println("Exception :SapSorderEJB :getValidDateTimeString :==>"+e.getMessage()); 
			 throw new ITMException(e);
		 }
		 //System.out.println("retDateStr :"+retDateStr);
		 return retDateStr;
	 }


	 private String getValidDateString(String dateStr, String sourceDateFormat, String targetDateFormat) throws ITMException
	 {
		 System.out.println("[SapSorderEJB]Converting dateStr :["+dateStr+"] From format :["+sourceDateFormat +"] To Format :["+targetDateFormat+"]"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
		 Object date = null;
		 String retDateStr = ""; 
		 try
		 {
			 if (!(sourceDateFormat.equalsIgnoreCase(targetDateFormat)))
			 {
				 if (sourceDateFormat.indexOf("/") != -1) 
				 {
					 dateStr.replace('/', '-');
				 }
				 else if (sourceDateFormat.indexOf(".") != -1) 
				 {
					 dateStr.replace('.', '-');
				 }

				 date = new SimpleDateFormat(sourceDateFormat).parse(dateStr);
				 SimpleDateFormat sdfOutput = new SimpleDateFormat(targetDateFormat);
				 retDateStr = sdfOutput.format(date);
			 }
			 else
			 {
				 retDateStr = dateStr;
			 }
		 }
		 catch (Exception e)
		 {
			 System.out.println("Exception :SapSorderEJB :getValidDateString :==>"+e.getMessage()); 
			 throw new ITMException(e);
		 }
		 System.out.println("[SapSorderEJB]Converted Datestr :["+retDateStr+"]"); 
		 return retDateStr;
	 }

}
