SET DEFINE OFF

--- Employee Bond Master [Request ID: A15DSUN002].Start ---

CREATE TABLE EMPLOYEE_BOND 
(
	EMP_CODE CHAR(10) NOT NULL, 
	LINE_NO NUMBER(3,0) NOT NULL, 
	BOND_PRD NUMBER(2,0), 
	BOND_AMT NUMBER(14,3),
	CHG_DATE DATE ,
	CHG_USER VARCHAR2(10) ,
	CHG_TERM VARCHAR2(15) 
) ;
ALTER TABLE EMPLOYEE_BOND ADD ( CONSTRAINT EMPLOYEE_BOND_X PRIMARY KEY ( EMP_CODE, LINE_NO )) ;
ALTER TABLE EMPLOYEE_BOND ADD ( CHG_DATE DATE);
ALTER TABLE EMPLOYEE_BOND ADD ( CHG_USER VARCHAR2(10));
ALTER TABLE EMPLOYEE_BOND ADD ( CHG_TERM VARCHAR2(15));

ALTER TABLE EMPLOYEE_BOND ADD ( CONSTRAINT FK_EMPLOYEE_BOND1 FOREIGN KEY ( EMP_CODE ) REFERENCES EMPLOYEE ) ;

INSERT INTO ITM2MENU 
(
	APPLICATION,
	LEVEL_1,
	LEVEL_2,
	LEVEL_3,
	LEVEL_4,
	LEVEL_5,
	WIN_NAME,
	DESCR,
	COMMENTS,
	MENU_PATH,
	ICON_PATH,
	OBJ_TYPE,
	MOB_DEPLOY,
	CHG_USER,
	CHG_TERM,
	CHG_DATE
) 
VALUES 
(
	'ADM',
	9,
	0,
	0,
	0,
	0,
	'-',
	'Bond Recovery',
	'Bond Recovery',
	'ADM.9.0.0.0.0',
	'e12_logo.gif',
	NULL,
	NULL,
	'BASE',
	'BASE',
	FN_SYSDATE()
);

INSERT INTO ITM2MENU 
(
	APPLICATION,
	LEVEL_1,
	LEVEL_2,
	LEVEL_3,
	LEVEL_4,
	LEVEL_5,
	WIN_NAME,
	DESCR,
	COMMENTS,
	MENU_PATH,
	ICON_PATH,
	OBJ_TYPE,
	MOB_DEPLOY,
	CHG_USER,
	CHG_TERM,
	CHG_DATE
) 
VALUES 
(
	'ADM',
	9,
	1,
	0,
	0,
	0,
	'w_employee_bond',
	'Employee Bond',
	'Employee Bond Master',
	'ADM.9.1.0.0.0',
	'e12_logo.gif',
	'T',
	NULL,
	'BASE',
	'BASE',
	FN_SYSDATE()
);

COMMIT;

INSERT INTO TRANSETUP (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,UDF_1,UDF_2,UDF_3,UDF_4,UDF_5,REPEATE_ADD,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,SITE_ACC_COL,CONFIRM_COL,CONFIRM_VAL,REPEAT_ADD_DET,REPEATADDDET,LOAD_MODE,AUTO_CONFIRM,LEDG_POST_CONF,CHG_DATE_ON_CONF,TRAN_ID_COL,MAIL_OPTION,CONFIRM_MODE,GARBAGE_OPT,VAL_FLAG_EDI,VERIFY_PASSWORD,CUST_ACC_COL,SALES_PERS_ACC_COL,SUPP_ACC_COL,ITEM_SER_ACC_CODE,EMP_ACC_COL,ITEM_SER_ACC_COL,WORKFLOW_OPT,TABLE_NAME,APPLICATION,TABLE_DESC,TRAN_DATE_COL,TRAN_ID__FROM,TRAN_ID__TO,TABLE_NAME_DET1,TABLE_NAME_DET2,TABLE_NAME_DET3,MULTITIRE_OPT,REF_SER,VIEW_MODE,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CUSTOM_PREVIEW_OBJ,IGNOREERRLIST_ONLOAD,CHILDDATA_ARGOPT,EDIT_TMPLT,WRKFLW_INIT,EDITTAX,FORMAL_ARGS,AUDIT_TRAIL_OPT,EDIT_OPT,CACHE_OPT,OPTIMIZE_MODE,EDIT_EXPR,RATE_COL,QTY_COL,EDIT_EXPR_INP,RCP_CACHE_STATUS,PRINT_CONTROL,TRANSFER_MODE,PROFILE_ID__RES,TRAN_COMPL_MSG,PERIOD_OPTION,WRKFLW_PRIORITY,EXEC_TYPE,DISP_META_DATA,START_FORM,ISATTACHMENT,HEADER_FORM_NO,ALLOW_ATTACH,MSG_ONSAVE,CONFIRM_DATE_COL,CONFIRM_BY_COL,WF_STATUS,ISGWTINITIATED,RESTART_FORM,BROW_DATA_DEF,CMS_PATH,DEF_VIEW,VIEW_OPTS) 
VALUES 
('w_employee_bond','2','2','M','seq10',null,null,null,null,null,null,FN_SYSDATE(),'BASE','BASE','0','EMPLOYEE.EMP_SITE',null,'Y','N',null,null,null,'N','N','EMP_CODE,LINE_NO','0','0',null,null,null,null,null,null,null,null,null,'0','EMPLOYEE_BOND','ADM','Employee Bond Master',null,null,null,null,null,null,null,'EBONDM','F',null,null,null,null,null,'2',null,null,null,null,null,'0',null,null,null,null,null,null,null,null,null,null,null,'M',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null);

UPDATE TRANSETUP SET WORKFLOW_OPT = 0, APPLICATION='ADM', AUDIT_TRAIL_OPT = CASE WHEN AUDIT_TRAIL_OPT IS NULL THEN '0' ELSE AUDIT_TRAIL_OPT END, TRAN_ID_COL = 'EMP_CODE,LINE_NO', SITE_ACC_COL = 'EMPLOYEE.EMP_SITE', TABLE_NAME = 'EMPLOYEE_BOND' WHERE TRAN_WINDOW = 'w_employee_bond' ;

COMMIT;

INSERT INTO OBJ_FORMS (WIN_NAME,TITLE,OBJ_BROW_NAME,OBJ_EDIT_NAME,CROSS_UPDATE_EXPR,EXPR_FLD_INFO,TARGET_FLD_INFO,EXPR_COMMENT,FORM_NO,SCR_FLAG,AUTO_ACCEPT_SCAN,SCAN_FLAG,SCAN_METADATA,PROPERTY_INFO,SCAN_DELIMITER,COLUMN_ON_SAVE,AFTER_SAVE,EXT_SETUP,EXT_METADATA,EXT_COM,AUTO_ACCEPT_WEIGHDATA,FORM_TYPE,DISP_METADATA,PARENT_KEY_COL,QTY_COL,RATE_COL,ASSISTED_MODE,STORAGE_KEY_METADATA,SELECTION_MODE,DEFAULT_VIEW,AUTO_ADDON_ENTRY) 
VALUES 
('w_employee_bond','Bond Detail','d_employee_bond11','d_employee_bond21',null,null,null,null,'1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null);

UPDATE OBJ_FORMS SET TITLE = 'Bond Detail' , OBJ_BROW_NAME = 'd_employee_bond11', OBJ_EDIT_NAME = 'd_employee_bond21' WHERE WIN_NAME = 'w_employee_bond';

COMMIT;

INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) 
VALUES 
('employee_bond',1,'add.gif','Adding new','a','a','A','Add','1',NULL,NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL,NULL,NULL);

INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) 
VALUES 
('employee_bond',2,'edit.gif','Editing Existing Record','a','a','E','Edit','1',NULL,NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL,NULL,NULL);

INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT) 
VALUES 
('employee_bond',5,NULL,'View Audit Trail','audit_trail','1','X','View Audit','1',1,1,'U',NULL,FN_SYSDATE(),'BASE','BASE',NULL,NULL,NULL);

COMMIT;

INSERT INTO OBJ_ITEMCHANGE  (
	OBJ_NAME ,
	FORM_NO ,
	FIELD_NAME ,
	MANDATORY )
VALUES (
	'employee_bond',
	'1',
	'itm_default',
	'Y');

INSERT INTO OBJ_ITEMCHANGE  (
	OBJ_NAME ,
	FORM_NO ,
	FIELD_NAME ,
	MANDATORY )
VALUES (
	'employee_bond',
	'1',
	'emp_code',
	'Y');

COMMIT;

INSERT INTO SYSTEM_EVENTS (
	OBJ_NAME,
	EVENT_CODE,
	EVENT_CONTEXT,
	SERVICE_CODE,
	METHOD_RULE,
	OVERWRITE_CORE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	RESULT_HANDLE,
	COMP_NAME,
	COMP_TYPE,
	COMM_FORMAT)
VALUES (
	'employee_bond',
	'post_validate',
	'1',
	'post_gen_val',
	NULL,
	'0',
	fn_sysdate(),
	'BASE',
	'BASE',
	'2',
	'GenValidate',
	'EJB',
	NULL);

INSERT INTO SYSTEM_EVENTS (
	OBJ_NAME,
	EVENT_CODE,
	EVENT_CONTEXT,
	SERVICE_CODE,
	METHOD_RULE,
	OVERWRITE_CORE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	RESULT_HANDLE,
	COMP_NAME,
	COMP_TYPE,
	COMM_FORMAT)
VALUES (
	'employee_bond',
	'pre_validate',
	'1',
	'prv_employee_bond',
	NULL,
	'0',
	fn_sysdate(),
	'BASE',
	'BASE',
	'2',
	'EmpBondAmount',
	'EJB',
	NULL);

INSERT INTO SYSTEM_EVENTS (
	OBJ_NAME,
	EVENT_CODE,
	EVENT_CONTEXT,
	SERVICE_CODE,
	METHOD_RULE,
	OVERWRITE_CORE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	RESULT_HANDLE,
	COMP_NAME,
	COMP_TYPE,
	COMM_FORMAT)
VALUES (
	'employee_bond',
	'post_item_change',
	'1',
	'poic_employee_bond',
	NULL,
	'0',
	fn_sysdate(),
	'BASE',
	'BASE',
	'2',
	'EmpBondAmount',
	'EJB',
	NULL);

INSERT INTO SYSTEM_EVENTS (
	OBJ_NAME,
	EVENT_CODE,
	EVENT_CONTEXT,
	SERVICE_CODE,
	METHOD_RULE,
	OVERWRITE_CORE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	RESULT_HANDLE,
	COMP_NAME,
	COMP_TYPE,
	COMM_FORMAT)
VALUES (
	'employee_bond',
	'audit_trail',
	'1',
	'project_audit_trail',
	NULL,
	'0',
	fn_sysdate(),
	'BASE',
	'BASE',
	'2',
	NULL,
	NULL,
	NULL);

COMMIT;

UPDATE SYSTEM_EVENTS SET SERVICE_CODE = 'poic_employee_bond' WHERE OBJ_NAME = 'employee_bond' AND EVENT_CODE = 'post_item_change';

UPDATE SYSTEM_EVENTS SET SERVICE_CODE = 'prv_employee_bond' WHERE OBJ_NAME = 'employee_bond' AND EVENT_CODE = 'pre_validate';

COMMIT;

INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES 
('poic_employee_bond','post item change','http://localhost:9090/axis/services/ValidatorService','BASE','itemChanged','String','S',NULL,NULL,FN_SYSDATE(),'BASE','BASE');

Insert into SYSTEM_EVENT_SERVICES (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) values ('prv_employee_bond','Validatation','http://localhost:9090/axis/services/ValidatorService','BASE','wfValData','String','S',NULL,NULL,FN_SYSDATE(),'BASE','BASE');

COMMIT;

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('poic_employee_bond',1,'COMPONENT_TYPE','I','Component Type','S',NULL,FN_SYSDATE(),'BASE','BASE','EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('poic_employee_bond',2,'COMPONENT_NAME','I','Component name','S',NULL,FN_SYSDATE(),'BASE','BASE','EmpBondAmount');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('poic_employee_bond',3,'XML_DATA','I',NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('poic_employee_bond',4,'XML_DATA_1','I',NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('poic_employee_bond',5,'XML_DATA_ALL','I',NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('poic_employee_bond',6,'OBJ_CONTEXT','I',NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('poic_employee_bond',7,'FOCUSED_COLUMN','I',NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('poic_employee_bond',8,'EDIT_FLAG','I',NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('poic_employee_bond',9,'XTRA_PARAMS','I',NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('prv_employee_bond',1,'COMPONENT_TYPE','I','Component Type','S',NULL,FN_SYSDATE(),'BASE','BASE','EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('prv_employee_bond',2,'COMPONENT_NAME','I','Component name','S',NULL,FN_SYSDATE(),'BASE','BASE','EmpBondAmount');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('prv_employee_bond',3,'XML_DATA','I',NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('prv_employee_bond',4,'XML_DATA_1','I',NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('prv_employee_bond',5,'XML_DATA_ALL','I',NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('prv_employee_bond',6,'OBJ_CONTEXT','I',NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('prv_employee_bond',7,'EDIT_FLAG','I',NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES 
('prv_employee_bond',8,'XTRA_PARAMS','I',NULL,'S',NULL,FN_SYSDATE(),'BASE','BASE',NULL);

COMMIT;

------------------------
INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPBND01',
	'Invalid Employee!',
	'Login site does not match with employment site of the employee',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	NULL
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPBND02',
	'Duplicate bond period!',
	'Bond period is already defined for the entered employee',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	NULL
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPBND03',
	'Invalid Bond Period!',
	'The bond period of the employee must be greater than 0',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	NULL
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPBND04',
	'Invalid Bond Amount!',
	'The bond amount of the employee must be greater than or equal to 0',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	NULL
);
INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPBND05',
	'Invalid Bond Period!',
	'The Bond Period must be a Positive Number',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	NULL
);


INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPBND06',
	'Invalid Bond Amount!',
	'The Bond Amount must be a Positive Number',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	NULL
);
INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPBND07',
	'Invalid Bond Amount!',
	'Bond amount cannot be 0',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	NULL
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	MSG_TIME,
	ALARM,
	ERR_SOURCE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	OVERRIDE_INPUT,
	MAIL_OPTION
) 
VALUES 
(
	'VMEMPBND08',
	'Invalid Employee!',
	'The employee has been relieved hence you cannot add or modify bond definition',
	'E',
	'Y',
	NULL,
	NULL,
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	NULL
);


COMMIT;

INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'EMP_CODE',
	'W_EMPLOYEE_BOND',
	'SELECT EMP_CODE AS Code,TRIM(EMP_FNAME) || '' '' || TRIM(EMP_MNAME) || '' '' || TRIM(EMP_LNAME)  AS Employee_Name FROM EMPLOYEE WHERE (DATE_JOIN  IS NOT NULL) AND (RELIEVE_DATE IS NOT NULL) AND LENGTH(TRIM(''?'')) >= 3 AND EMP_FNAME || EMP_MNAME || EMP_LNAME LIKE ''%?%'' UNION ALL SELECT CAST(SPACE(10) AS CHAR(10)) AS Code, ''Enter minimum three characters in code to populate employee list'' AS Employee_Name FROM DUAL WHERE LENGTH(TRIM(''?'')) < 3 ',
	'Employees',
	0,
	0,
	fn_sysdate(),
	'AALI',
	'BASE',
	':0.emp_code,:0.emp_code,:0.emp_code',
	1,
	1
);
COMMIT;

--- Employee Bond Master [Request ID: A15DSUN002].End ---


