package ibase.webitm.ejb.adm;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.sys.UtilMethods;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.ejb.Stateless;

import org.glassfish.grizzly.filterchain.RerunFilterAction;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class DeptIC extends ValidatorEJB implements DeptICRemote, DeptICLocal {

	public String itemChanged() throws RemoteException, ITMException {
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1,
			String xmlString2, String objContext, String currentColumn,
			String editFlag, String xtraParams) throws RemoteException,
			ITMException {
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";

		E12GenericUtility genericUtility = new E12GenericUtility();

		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				dom2 = genericUtility.parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext,
					currentColumn, editFlag, xtraParams);
		} catch (Exception e) {
			System.out.println("Exception :DeptIC :itemChanged(String,String):"+ e.getMessage() + ":");
			valueXmlString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("returning from DeptIC itemChanged");
		return (valueXmlString);
	}

	public String itemChanged(Document dom, Document dom1, Document dom2,
			String objContext, String currentColumn, String editFlag,
			String xtraParams) throws RemoteException, ITMException {
		String colName = " ", mcode = " ", mdescr = " ", mdescr1 = " ", err = " ";
		String deptCodeParent = " ", deptCode = " ";
		colName = currentColumn;
		Connection connectionObject = null;
		int currentFormNo = 0;
		StringBuffer valueXmlString = null;
		ResultSet resultSet = null;
		PreparedStatement pstmt = null;
		String sql = " ";

		E12GenericUtility genericUtility = new E12GenericUtility();
		try {
			System.out.println("currentFormNo...." + currentFormNo);
			connectionObject = getConnection();

			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			System.out.println("current form no: " + currentFormNo);

			switch (currentFormNo) {
			case 1:
				System.out.println("Case1");
				valueXmlString.append("<Detail1>\r\n");
				if (currentColumn.trim().equals("dept_head"))
				{
					mcode = genericUtility.getColumnValue("dept_head", dom);
					if(mcode !=null && mcode.length()>0)
					{
						sql = "Select emp_fname, emp_lname  from employee where emp_code = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, mcode);
						resultSet = pstmt.executeQuery();
						if (resultSet.next())
						{
							mdescr = resultSet.getString("emp_fname");
							mdescr1 = resultSet.getString("emp_lname");
						}
						if (resultSet != null) 
						{
							resultSet.close();
							resultSet = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
						valueXmlString.append("<emp_fname>").append(mdescr).append("</emp_fname>\r\n");
						valueXmlString.append("<emp_lname>").append(mdescr1).append("</emp_lname>\r\n");
				} 
				else if (currentColumn.trim().equals("dept_head_1")) 
				{
					mcode = genericUtility.getColumnValue("dept_head_1", dom);
					if(mcode != null && mcode.length()>0)
					{
						sql = "Select emp_fname, emp_lname from employee where emp_code = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, mcode);
						resultSet = pstmt.executeQuery();
						if (resultSet.next()) 
						{
							mdescr = resultSet.getString("emp_fname");
							mdescr1 = resultSet.getString("emp_lname");
						}
						if (resultSet != null) 
						{
							resultSet.close();
							resultSet = null;
						}
						if (pstmt != null) 
						{
							pstmt.close();
							pstmt = null;
						}
					}
						valueXmlString.append("<emp_fname_1>").append(mdescr).append("</emp_fname_1>\r\n");
						valueXmlString.append("<emp_lname_1>").append(mdescr1).append("</emp_lname_1>\r\n");
				} 
				else if (currentColumn.trim().equals("acct_code"))
				{
					mcode = genericUtility.getColumnValue("acct_code", dom);
					if(mcode != null && mcode.length()>0)
					{
						sql = "select descr from accounts where acct_code = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, mcode);
						resultSet = pstmt.executeQuery();
						if (resultSet.next()) 
						{
							mdescr = resultSet.getString("descr");
						}
						if (resultSet != null) 
						{
							resultSet.close();
							resultSet = null;
						}
						if (pstmt != null) 
						{
							pstmt.close();
							pstmt = null;
						}
					}
						valueXmlString.append("<accounts_descr>").append(mdescr).append("</accounts_descr>\r\n");
				}

				else if (currentColumn.trim().equals("cctr_code"))
				{
					mcode = genericUtility.getColumnValue("cctr_code", dom);
					if(mcode != null && mcode.length()>0 )
					{	
						sql = "select descr from costctr where cctr_code = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, mcode);
						resultSet = pstmt.executeQuery();

						if (resultSet.next()) 
						{
							mdescr = resultSet.getString("descr");
						}
						if (resultSet != null) 
						{
							resultSet.close();
							resultSet = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
						valueXmlString.append("<costctr_descr>").append(mdescr).append("</costctr_descr>\r\n");
				}

				else if (currentColumn.trim().equals("acct_code__ap")) 
				{
					mcode = genericUtility.getColumnValue("acct_code__ap", dom);
					if(mcode !=null && mcode.length()>0)
					{
						sql = "select descr from accounts where acct_code = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, mcode);
						resultSet = pstmt.executeQuery();

						if (resultSet.next()) 
						{
							mdescr = resultSet.getString("descr");
						}
						if (resultSet != null) 
						{
							resultSet.close();
							resultSet = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
						valueXmlString.append("<accounts_descr__ap>").append(mdescr).append("</accounts_descr__ap>\r\n");
				}

				else if (currentColumn.trim().equals("cctr_code__ap"))
				{
					mcode = genericUtility.getColumnValue("cctr_code__ap", dom);
					if(mcode!=null && mcode.length()>0)
					{
						sql = "select descr from costctr where cctr_code = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, mcode);
						resultSet = pstmt.executeQuery();
						if (resultSet.next()) 
						{
							mdescr = resultSet.getString("descr");
						}
						if (resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
						valueXmlString.append("<costctr_descr__ap>").append(mdescr).append("</costctr_descr__ap>\r\n");
				}

				else if (currentColumn.trim().equals("dept_code"))
				{
					System.out.println("dept_code>>>");
					deptCode = genericUtility.getColumnValue("dept_code", dom);
					deptCodeParent = genericUtility.getColumnValue("dept_code__parent", dom);
					if ((deptCode != null && deptCode.trim().length() > 0) && (deptCodeParent == null || deptCodeParent.trim().length() == 0)) 
					{
						valueXmlString.append("<dept_code__parent>").append(deptCode).append("</dept_code__parent>\r\n");
					}
					else
					{
						valueXmlString.append("<dept_code__parent>").append(deptCode).append("</dept_code__parent>\r\n");
					}
				}

				else if (currentColumn.trim().equals("descr")) 
				{
					deptCode = genericUtility.getColumnValue("dept_code", dom);
					deptCodeParent = genericUtility.getColumnValue("dept_code__parent", dom);
					mdescr = genericUtility.getColumnValue("descr", dom);
					if ((deptCode != null && deptCode.trim().length() > 0) && (deptCodeParent != null && deptCodeParent.trim().equalsIgnoreCase(deptCode.trim()))) 
					{
						valueXmlString.append("<parent_dept_descr>").append(mdescr).append("</parent_dept_descr>\r\n");
					}
					else{
						valueXmlString.append("<parent_dept_descr>").append(mdescr).append("</parent_dept_descr>\r\n");
					}

				} 
				else if (currentColumn.trim().equals("dept_code__parent")) 
				{

					deptCodeParent = genericUtility.getColumnValue("dept_code__parent", dom);
					mdescr = "";
					if (deptCodeParent != null && deptCodeParent.trim().length() > 0) 
					{
						deptCode = genericUtility.getColumnValue("dept_code",dom);
						if (!deptCodeParent.trim().equalsIgnoreCase(deptCode.trim())) 
						{
							sql = "select FN_GET_DEPT_DESCR(?)  from dual";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, deptCodeParent);
							resultSet = pstmt.executeQuery();

							if (resultSet.next()) 
							{
								mdescr = resultSet.getString(1);
							}
							if (resultSet != null) 
							{
								resultSet.close();
								resultSet = null;
							}
							if (pstmt != null) 
							{
								pstmt.close();
								pstmt = null;
							}

						} 
						else 
						{
							mdescr = genericUtility.getColumnValue("descr", dom);
						}
						valueXmlString.append("<parent_dept_descr>").append(mdescr).append("</parent_dept_descr>\r\n");
					}

				}

				else if (currentColumn.trim().equals("bu_code")) 
				{
					mcode = genericUtility.getColumnValue("bu_code", dom);
					mdescr = "";
					System.out.println("mcode bu_code==="+mcode);
					if (mcode != null && mcode.trim().length() > 0) 
					{
						sql = "select FN_GET_BUCODE_DESCR(?) from dual";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, mcode);
						resultSet = pstmt.executeQuery();
						if (resultSet.next()) 
						{
							mdescr = resultSet.getString(1);
						}
						if (resultSet != null) 
						{
							resultSet.close();
							resultSet = null;
						}
						if (pstmt != null) 
						{
							pstmt.close();
							pstmt = null;
						}

					}
					valueXmlString.append("<bu_descr>").append(mdescr).append("</bu_descr>\r\n");
				}

				else if (currentColumn.trim().equals("func_code")) 
				{
					mcode = genericUtility.getColumnValue("func_code", dom);
					mdescr = "";
					System.out.println("mcode func_code"+mcode);
					if (mcode != null && mcode.trim().length() > 0)
					{
						sql = "select FN_GET_BUFUNC_DESCR(?) from dual";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, mcode);
						resultSet = pstmt.executeQuery();
						if (resultSet.next()) 
						{
							mdescr = resultSet.getString(1);
						}
						if (resultSet != null) {
							resultSet.close();
							resultSet = null;
						}
						if (pstmt != null) {
							pstmt.close();
							pstmt = null;
						}
					}
					valueXmlString.append("<func_descr>").append(mdescr).append("</func_descr>\r\n");
				}

				else if (currentColumn.trim().equals("emp_code__funchead")) 
				{
					mcode = genericUtility.getColumnValue("emp_code__funchead",dom);
					mdescr = "";
					System.out.println("mcode emp_code__funchead"+mcode);
					if (mcode != null && mcode.trim().length() > 0) 
					{
						sql = "select FN_GET_EMP_NAME(?,'X') from dual";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, mcode);
						resultSet = pstmt.executeQuery();
						if (resultSet.next()) 
						{
							mdescr = resultSet.getString(1);
						}
						if (resultSet != null) 
						{
							resultSet.close();
							resultSet = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}

					}
					valueXmlString.append("<funchead_name>").append(mdescr).append("</funchead_name>\r\n");
				}

				else if (currentColumn.trim().equals("item_ser"))
				{

					mcode = genericUtility.getColumnValue("item_ser", dom);
					mdescr = "";
					System.out.println("mcode item_ser"+mcode);
					if (mcode != null && mcode.trim().length() > 0) 
					{
						sql = "select descr from itemser where item_ser = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, mcode);
						resultSet = pstmt.executeQuery();
						if (resultSet.next()) 
						{
							mdescr = resultSet.getString("descr");
						}
						if (resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					valueXmlString.append("<itemser_descr>").append(mdescr).append("</itemser_descr>\r\n");
				}
				valueXmlString.append("</Detail1>\r\n");
				break;
			}
			valueXmlString.append("</Root>\r\n");
		} catch (Exception e) {
			System.out.println("Exception :DeptIC :itemChanged(Document,String):"+ e.getMessage() + ":");
			valueXmlString.delete(0, valueXmlString.length());
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
			e.printStackTrace();
		} finally {
			try {
				if (connectionObject != null) {
					if (pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
					if (resultSet != null) 
					{
						resultSet.close();
						resultSet = null;
					}
					connectionObject.close();
					connectionObject = null;
				}
			} catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();

	}

	public String wfValData() throws RemoteException, ITMException {
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,
			String xmlString2, String objContext, String editFlag,
			String xtraParams) throws RemoteException,
			ITMException {

		System.out.println(xmlString);
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();

		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				dom = genericUtility.parseString(xmlString);
				System.out.println("Print dom>>>> "+dom);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag,
					xtraParams);
			System.out.println("ErrString :" + errString);
		} catch (Exception e) {
			System.out
					.println("Exception :DeptIC :wfValData(String xmlString):"
							+ e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("returning from DeptIC wfvaldata");
		return errString;

	}

	public String wfValData(Document dom, Document dom1, Document dom2,
			String objContext, String editFlag, String xtraParams)
			throws RemoteException, ITMException {
		boolean checkNextCol = true;
		String columnName = "";
		String columnValue = "";
		String userId = "";
		String sql = "";
		String errString = "";
		Connection connectionObject = null;
		ResultSet resultSet = null;
		PreparedStatement pstmt = null;
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		int counter;
		int noOfChilds = 0;
		int currentFormNo = 0;
		int cnt = 0;
		String mVal = "";
		String mVal1 = "";
		String mVal2 = "";
		java.sql.Timestamp mdate1 = null;
		java.sql.Timestamp mdate2 = null;
		String deptCodeParent = "";
		String deptCode = "";

		E12GenericUtility genericUtility = new E12GenericUtility();
		UtilMethods utilmethod = new UtilMethods();
		
		try {
			connectionObject = getConnection();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("Line no--468");
			if(objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			
			System.out.println("noOfChilds--->>>"+noOfChilds);

			for (counter = 0; counter < noOfChilds; counter++) {
				childNode = childList.item(counter);
				childNodeName = childNode.getNodeName();
				System.out.println("childNodeName>>>>>"+childNodeName);
				System.out.println("childNode>>>>>>"+childNode);
				System.out.println("counter>>>"+counter);
				switch (currentFormNo) {
				case 1:
					if(childNodeName.equals("dept_code")) 
					{
						mVal = genericUtility.getColumnValue("dept_code", dom);
						System.out.println("EditFlag--------"+editFlag);
						if("A".equalsIgnoreCase(editFlag)) 
						{
							if(mVal == null || mVal.length() == 0) 
							{
								errString = getErrorString("dept_code","VEDEP2", userId);
							} 
							else 
							{
								sql = "select count(*) as cnt from department where dept_code = ?";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, mVal);
								resultSet = pstmt.executeQuery();
								if(resultSet.next())
								{
									cnt = resultSet.getInt("cnt");
								}
								if(cnt > 0) 
								{
									errString = getErrorString("dept_code","VMDUPL1", userId);
								}
								if (resultSet != null) {
									resultSet.close();
									resultSet = null;
								}
								if (pstmt != null) {
									pstmt.close();
									pstmt = null;
								}
							}
						}
					} 
					else if(childNodeName.equalsIgnoreCase("descr")) 
					{
						System.out.println("line --509");
						mVal = genericUtility.getColumnValue("descr", dom);
						if(mVal == null || mVal.length() == 0) 
						{
							errString = getErrorString("descr", "VTDESC1",userId);
						}
					} 
					else if(childNodeName.equalsIgnoreCase("dept_head")) 
					{
						System.out.println("line--515");
						mVal = genericUtility.getColumnValue("dept_head", dom);
						if(mVal != null && mVal.trim().length() != 0) 
						{
							sql = "select count(*) as cnt from employee where emp_code = ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, mVal);
							resultSet = pstmt.executeQuery();
							if(resultSet.next())
							{
								cnt = resultSet.getInt("cnt");
							}
							if(cnt == 0) 
							{
								errString = getErrorString("dept_head","VMEMP1", userId);
							}
							if (resultSet != null) {
								resultSet.close();
								resultSet = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}
						}
					} 
					else if(childNodeName.equalsIgnoreCase("dept_head_1")) 
					{
						System.out.println("line--530");
						mVal = genericUtility.getColumnValue("dept_head_1", dom);
						if(mVal != null && mVal.trim().length() != 0) 
						{
							sql = "select count(*) as cnt from employee where emp_code =?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, mVal);
							resultSet = pstmt.executeQuery();
							if(resultSet.next()) 
							{
								cnt = resultSet.getInt("cnt");
							}
							if(cnt == 0) 
							{
								errString = getErrorString("dept_head_1","VMDEPTHD01", userId);
							}
							if (resultSet != null) {
								resultSet.close();
								resultSet = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}
						}
					} 
					else if(childNodeName.equalsIgnoreCase("acct_code"))
					{
						System.out.println("line --545");
						mVal = genericUtility.getColumnValue("acct_code", dom);
						//if(mVal != null && mVal.trim().length()>0)
						//{
							sql = "select count(*) as cnt from accounts where acct_code = ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, mVal);
							resultSet = pstmt.executeQuery();
							if(resultSet.next()) 
							{
								cnt = resultSet.getInt("cnt");
							}
							if(cnt == 0) 
							{
								errString = getErrorString("acct_code", "VMACCT1",userId);
							}
							if (resultSet != null) {
								resultSet.close();
								resultSet = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}
						//}
					}
					else if(childNodeName.equalsIgnoreCase("cctr_code")) 
					{
						System.out.println("line --558");
						mVal = genericUtility.getColumnValue("cctr_code", dom);
						if(mVal !=null && mVal.trim().length() != 0)
						{
							sql = "select count(*) as cnt from costctr where cctr_code = ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, mVal);
							resultSet = pstmt.executeQuery();
							if (resultSet.next()) 
							{
								cnt = resultSet.getInt("cnt");
							}
							if (cnt == 0) 
							{
								errString = getErrorString("cctr_code","VMCCTR1", userId);
							}
							if (resultSet != null) {
								resultSet.close();
								resultSet = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("pay_table")) 
					{
						System.out.println("573");
						mVal = genericUtility.getColumnValue("pay_table", dom);
						if(mVal !=null && mVal.trim().length() != 0)
						{
							sql = "select count(*) as cnt from paytable where pay_table = ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, mVal);
							resultSet = pstmt.executeQuery();
							if(resultSet.next()) 
							{
								cnt = resultSet.getInt("cnt");
							}
							if(cnt == 0)
							{
								errString = getErrorString("pay_table","VMPYTAB2", userId);
							}
							if (resultSet != null) {
								resultSet.close();
								resultSet = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("dept_code__parent")) 
					{
						System.out.println("line 589"); 
						deptCodeParent = genericUtility.getColumnValue("dept_code__parent", dom);
						cnt = 0;
						if(deptCodeParent != null && deptCodeParent.trim().length() > 0) 
						{
							deptCode = genericUtility.getColumnValue("dept_code", dom);
							if(!deptCodeParent.trim().equalsIgnoreCase(deptCode))
							{
								sql = "select count(1) as cnt from department where dept_code = ?";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, deptCodeParent);
								resultSet = pstmt.executeQuery();
								if(resultSet.next()){
									cnt = resultSet.getInt("cnt");
								}
								if(cnt == 0) 
								{
									errString = getErrorString("dept_code__parent", "VMDEPTPD01",userId);
								}
								if (resultSet != null) {
									resultSet.close();
									resultSet = null;
								}
								if (pstmt != null) {
									pstmt.close();
									pstmt = null;
								}
							} 
							else 
							{
								System.out.println("line--606");
								cnt = 0;
								if(CommonConstants.DB_NAME.equalsIgnoreCase("ORACLE"))
								{

									sql = "select count(1) as cnt from DUAL where ? in "
											+ " (select dept_code from department where dept_code <> dept_code__parent "
											+ " start with  dept_code =? connect by prior dept_code = dept_code__parent) ";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, deptCodeParent);
									pstmt.setString(2, mVal);
									resultSet = pstmt.executeQuery();
									if(resultSet.next()) 
									{
										cnt = resultSet.getInt("cnt");
									}
									if(cnt > 0) 
									{
										errString = getErrorString("dept_code__parent","VMDEPTPD02", userId);
									}
									if (resultSet != null) {
										resultSet.close();
										resultSet = null;
									}
									if (pstmt != null) {
										pstmt.close();
										pstmt = null;
									}
								}
							}

						} 
						else 
						{
							errString = getErrorString("dept_code__parent","VMDEPTPD03", userId);
						}
					} 
					else if(childNodeName.equalsIgnoreCase("bu_code")) 
					{
						System.out.println("line--639");
						mVal = genericUtility.getColumnValue("bu_code", dom);
						cnt = 0;
						if(mVal != null && mVal.length() > 0) 
						{
							sql = "select count(1) as cnt from business_units where bu_code = ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, mVal);
							resultSet = pstmt.executeQuery();
							if (resultSet.next())
							{
								cnt = resultSet.getInt("cnt");
							}
							if (cnt == 0)
							{
								errString = getErrorString("bu_code","VMDEPTBU01", userId);
							}
							if (resultSet != null) {
								resultSet.close();
								resultSet = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}
						}
					} 
					else if(childNodeName.equalsIgnoreCase("func_code")) 
					{
						System.out.println("line --662");
						mVal = genericUtility.getColumnValue("func_code", dom);
						cnt = 0;
						if(mVal != null && mVal.length() > 0) 
						{
							sql = "select count(1) as cnt from BUSI_FUNCTIONS where func_code = ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, mVal);
							resultSet = pstmt.executeQuery();
							if (resultSet.next())
							{
								cnt = resultSet.getInt("cnt");
							}
							if(cnt == 0)
							{
								errString = getErrorString("func_code","VMDEPTFU01", userId);
							}
							if (resultSet != null) {
								resultSet.close();
								resultSet = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}
						}
					} 
					else if(childNodeName.equalsIgnoreCase("emp_code__funchead")) 
					{
						System.out.println("line--679");
						mVal = genericUtility.getColumnValue("emp_code__funchead", dom);
						cnt = 0;
						mVal1 = "";
						mdate1 = null;
						
						if(mVal != null && mVal.length() > 0) 
						{
							sql = "select count(1) as cnt from EMPLOYEE where emp_code = ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, mVal);
							resultSet = pstmt.executeQuery();
							if(resultSet.next()) 
							{
								cnt = resultSet.getInt("cnt");
							}
							if(cnt == 0) 
							{
								errString = getErrorString("emp_code__funchead", "VMDEPTFH01",userId);
							}
							else
							{
								sql = "select status, relieve_date from EMPLOYEE where emp_code = ?";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, mVal);
								resultSet = pstmt.executeQuery();
								if(resultSet.next()) 
								{
									mVal1 = resultSet.getString("status");
									mdate1 = resultSet.getTimestamp("relieve_date");
								}
								if(mVal1 != null && mVal1.trim().equalsIgnoreCase("S"))
								{
									errString = getErrorString("emp_code__funchead", "VMDEPTFH02",userId);
								}
								else if(mdate1 != null &&( utilmethod.date(mdate1).equals(utilmethod.today()) || utilmethod.date(mdate1).before(utilmethod.today())))
								{
									errString = getErrorString("emp_code__funchead", "VMDEPTFH03",userId);
									System.out.println("relieve_date line 835>>>>"+mdate1);
								}
								if (resultSet != null) {
									resultSet.close();
									resultSet = null;
								}
								if (pstmt != null) {
									pstmt.close();
									pstmt = null;
								}
							}
							if (resultSet != null) {
								resultSet.close();
								resultSet = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}
						}
						
					}
					else if(childNodeName.equalsIgnoreCase("item_ser"))
					{
						System.out.println("line--723");
						mVal = genericUtility.getColumnValue("item_ser", dom);
						if(mVal != null && mVal.length()>0)
						{
							cnt = 0;
							sql = "select count(1) as cnt from itemser where item_ser = ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1,mVal);
							resultSet = pstmt.executeQuery();
							if (resultSet.next()) 
							{
								cnt = resultSet.getInt("cnt");
							}
							if(cnt == 0)
							{
								errString = getErrorString("item_ser", "VMDEPTIS01",userId);
							}
							if (resultSet != null) {
								resultSet.close();
								resultSet = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}
						}
					}
					
				}
			}
		} catch (Exception e) 
		{
			System.out.println("Exception :DeptIC :wfValData(Document,String):"+ e.getMessage() + ":");
			e.printStackTrace();
		}finally 
		{
			try 
			{
				if (connectionObject != null)
				{
					if (resultSet != null) {
						resultSet.close();
						resultSet = null;
					}
					
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					connectionObject.close();
					connectionObject = null;
				}
			} 
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;
	}

}
