package ibase.webitm.ejb.wms;

import ibase.utility.E12GenericUtility;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.utility.CommonConstants;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.ejb.Stateless;

import org.w3c.dom.Document;

@Stateless
public class PhysicalCountAct extends ActionHandlerEJB implements PhysicalCountActLocal, PhysicalCountActRemote {

	public String actionHandler(String actionType, String xmlString, String xmlString1, String objContext, String xtraParams) throws RemoteException, ITMException {
		System.out.println("In " + this.getClass().getSimpleName() + " params:\n\t actionType [" + actionType + "] \n\t xmlString[" + xmlString + "] \n\t xmlString1 [" + xmlString1 + "] \n\t xtraParams [" + xtraParams + "]");
		Document dom = null, dom1 = null;
		String retString = "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		try {
			if (xmlString != null && xmlString.trim().length() > 0) {
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}

			if (actionType.equalsIgnoreCase("Stock")) {
				retString = actionStock(dom, dom1, objContext, xtraParams);
			}
		} catch (Exception e) {
			System.out.println("Exception in " + this.getClass().getSimpleName() + " actionHandler (S) [" + e.getMessage() + "]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("Returning from " + this.getClass().getSimpleName() + " :actionHandler (S) [" + retString +"]");
		return retString;
	}

	private String checkNull(String input) {
		return input == null ? "" : input.trim();
	}

	private String actionStock(Document dom, Document dom1, String objContext, String xtraParams) throws RemoteException, ITMException {
		
		String sql = "", itemCode = "", locCode = "", quantity = "", siteCode = "", stkItemCode = "", stkSiteCode = "",
				stkUnit = "",  stklotNo = "", stklotSl = "", stkLocCode = "", lotSl = "", lotNo = "";
		StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		E12GenericUtility genericUtility = new E12GenericUtility();
		
		try {
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			itemCode = checkNull(genericUtility.getColumnValue("item_code", dom));
			locCode = checkNull(genericUtility.getColumnValue("loc_code", dom));
			quantity = checkNull(genericUtility.getColumnValue("quantity", dom));
			siteCode = checkNull(genericUtility.getColumnValue("site_code", dom1));
			lotSl = checkNull(genericUtility.getColumnValue("lot_sl", dom));
			lotNo = checkNull(genericUtility.getColumnValue("lot_no", dom));

			System.out.println("ItemCode:" + itemCode + ":locCode:" + locCode + ":siteCode:" + siteCode + ":" + ":lotNo:" + lotNo + ":locSl:" + lotSl);

			sql = "select site_code, item_code, lot_no, lot_sl, loc_code, unit, nvl(quantity,0) as quantity from stock where site_code= ? "
					+ " AND ITEM_CODE LIKE '" + itemCode + "%' "
					+ " AND LOT_NO LIKE '" + lotNo + "%' "
					+ " AND LOT_SL LIKE  '" + lotSl + "%' "
					+ " AND LOC_CODE LIKE '" + locCode + "%' ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			rs = pstmt.executeQuery();
			System.out.println("itemCode:" + itemCode + ":locCode:" + locCode + ":quantity:" + quantity + ":siteCode:" + siteCode + ":");
			while (rs.next()) {
				stkSiteCode = checkNull(rs.getString("SITE_CODE"));
				stkItemCode = checkNull(rs.getString("ITEM_CODE"));
				stklotNo = checkNull(rs.getString("LOT_NO"));
				stklotSl = checkNull(rs.getString("LOT_SL"));
				stkLocCode = checkNull(rs.getString("LOC_CODE"));
				stkUnit = checkNull(rs.getString("UNIT"));				
				valueXmlString.append("<Detail>\r\n");
				valueXmlString.append("<item_code>").append("<![CDATA[").append(stkItemCode).append("]]>").append("</item_code>\r\n");
				valueXmlString.append("<loc_code>").append("<![CDATA[").append(stkLocCode).append("]]>").append("</loc_code>\r\n");
				valueXmlString.append("<lot_no>").append("<![CDATA[").append(stklotNo).append("]]>").append("</lot_no>\r\n");
				valueXmlString.append("<lot_sl>").append("<![CDATA[").append(stklotSl).append("]]>").append("</lot_sl>\r\n");
				valueXmlString.append("<unit>").append("<![CDATA[").append(stkUnit).append("]]>").append("</unit>\r\n");
				valueXmlString.append("</Detail>\r\n");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			valueXmlString.append("</Root>\r\n");
			/*String retXmlString = valueXmlString.toString();//genericUtility.serializeDom(genericUtility.parseString(valueXmlString.toString()));
			valueXmlString = null;
			valueXmlString = new StringBuffer(retXmlString);*/
		} catch (Exception e) {
			System.out.println("Exception in " + this.getClass().getSimpleName() + " actionHandler (S) [" + e.getMessage() + "]");
			e.printStackTrace();
			throw new ITMException(e);
		} finally {
			try {
				if(conn != null) {
					conn.close();
					conn = null;
				} if(rs != null) {
					rs.close();
					rs = null;
				} if(pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e) {
				System.out.println("Exception in " + this.getClass().getSimpleName() + " actionHandler (S) [" + e.getMessage() + "]");
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("PhysicalCountAct:actionStock:Final Value :valueXmlString.toString():" + valueXmlString.toString());
		return valueXmlString.toString();
	}

}
