/**
 * PURPOSE : DespatchConf component
 * AUTHOR : Sneha Mestry
 * DATE : 08-03-2016
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.reports.utility.XSDParser;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.wms.CommonWmsUtil;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;

import javax.xml.rpc.ParameterMode;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.*;

@javax.ejb.Stateless
public class DespatchConfWiz extends ValidatorEJB implements DespatchConfWizLocal, DespatchConfWizRemote
{
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave( String domString, String tranId, String editFlag, String xtraParams, Connection conn ) throws RemoteException, ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn1 = null;

		String errString = "", siteCode = "", childNodeName = "", userId = "", errorType = "", errCode = "";
		int ctr = 0, childNodeListLength = 0, cnt = 0;
		boolean isError = false;

		ArrayList <String> errList = new ArrayList<String>();
		ArrayList <String> errFields = new ArrayList <String>();

		String ptcn = "", despatchId = "", printer = "";
		int printerNameCount = 0;
		
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();

			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn1 = connDriver.getConnectDB("DriverITM");
			conn1 = getConnection();
			conn1.setAutoCommit(false);
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]

			Document dom = null;
			dom = genericUtility.parseString(domString);

			siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));	
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");	
			
			ptcn = checkNull(genericUtility.getColumnValue("ptcn", dom, "1" ));
			printer = checkNull(genericUtility.getColumnValue("printer_name", dom, "1" ));
			
			System.out.println("domString ----------->> " + domString);
			System.out.println("xtraParams ----------->> " + xtraParams);
			System.out.println("ptcn ----------->>["+ptcn+"]");
			System.out.println("printer name ----------->>["+printer+"]");

/*			System.out.println("siteCode ::::::::::::: " + siteCode);
			System.out.println("userId ::::::::::::: " + userId);*/

			parentNodeList = dom.getElementsByTagName("Detail1");
			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			//System.out.println("childNodeListLength----------->>["+childNodeListLength+"]");

			for (ctr = 0; ctr < childNodeListLength; ctr++) 
			{					
				childNode = childNodeList.item(ctr);
				childNodeName = childNode.getNodeName();
				System.out.println("childNodeName ------->>["+childNodeName+"]");
				
				if("ptcn".equalsIgnoreCase(childNodeName))
				{
					despatchId = getDespatchId(ptcn, siteCode, conn1);
					printerNameCount = getPrinterNameCount(printer, conn1);
					
					if(ptcn.length() <= 0) 
					{
						System.out.println("PTCN found blank :::::::::: "); 
						errCode = "VTNULPTCN";		
						errList.add( errCode );
						errFields.add(childNodeName.toLowerCase());
					}
					else if(despatchId.length() <= 0)
					{
						System.out.println("PTCN not found ::::::::::  "); 
						errCode = "VTINVPTCN";		
						errList.add( errCode );
						errFields.add(childNodeName.toLowerCase());
					}
					else if(printer.length() <= 0)
					{
						System.out.println("Printer name blank ::::::::::  "); 
						errCode = "VTPRINTNUL";		
						errList.add( errCode );
						errFields.add(childNodeName.toLowerCase());
					}
					else if(printerNameCount <= 0)
					{
						System.out.println("Printer name not found  ::::::::::  "); 
						errCode = "VTPRINTINV";		
						errList.add( errCode );
						errFields.add(childNodeName.toLowerCase());
					}
					else
					{
						System.out.println("Calling confirmDespatch :::::::::::::::::::: "); 
						confirmDespatch("despatch", despatchId, xtraParams, "", conn1);
						generateInvoiceReport(ptcn, despatchId, printer, conn1, xtraParams);						
					}
				}
			}

			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn1, errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				return getError(despatchId, "VTDESPCON", conn1);
			}	
			errString = errStringXml.toString();
		}
		catch(Exception e)
		{
			try
			{
				System.out.println("Exception "+e.getMessage());
				e.printStackTrace();			
				throw new ITMException(e);
			}
			catch (Exception e1)
			{
				isError = true;
				e1.printStackTrace();
				throw new ITMException(e1);
			}
		}
		finally
		{
			try
			{				
				if( !isError  )
				{
					System.out.println("commmit");
					conn1.commit(); 
				}
				else if ( isError )
				{
					System.out.println("rollback");
					conn1.rollback();
				}
				if (conn1 != null)
				{
					conn1.close();
					conn1 = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}	

	public String confirmDespatch(String businessObj, String tranIdFr, String xtraParams, String forcedFlag, Connection conn1) throws ITMException
	{

		String methodName = "";
		String compName = "";
		String retString = "";
		String serviceCode = "";
		String serviceURI = "";
		String actionURI = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			System.out.println("-------in confirmDespatch mothod@@----------------["+xtraParams+"]");			
			tranIdFr=tranIdFr==null ? "" :tranIdFr.trim();
			System.out.println("Tran id for sale order--->>"+tranIdFr+"]");
			methodName = "gbf_post";
			actionURI = "http://NvoServiceurl.org/" + methodName;

			sql = "SELECT SERVICE_CODE,COMP_NAME FROM SYSTEM_EVENTS WHERE OBJ_NAME = ? AND EVENT_CODE = 'pre_confirm' ";
			pstmt = conn1.prepareStatement(sql);
			pstmt.setString(1,businessObj);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				serviceCode = rs.getString("SERVICE_CODE");
				compName = rs.getString("COMP_NAME");
			}
			// Changed by Manish on 01/04/16 for max cursor issue [start]
			if (pstmt != null)
			{
				pstmt.close();
				pstmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			// Changed by Manish on 01/04/16 for max cursor issue [end]
			compName=compName==null ? "" :compName.trim();
			System.out.println("serviceCode = ["+serviceCode+"]   compName ["+compName+"]");
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
			pstmt = conn1.prepareStatement(sql);
			pstmt.setString(1,serviceCode);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				serviceURI = rs.getString("SERVICE_URI");
			}
			// Changed by Manish on 01/04/16 for max cursor issue [start]
			if (pstmt != null)
			{
				pstmt.close();
				pstmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			// Changed by Manish on 01/04/16 for max cursor issue [end]
			serviceURI=serviceURI==null ? "" :serviceURI.trim();
			System.out.println("serviceURI = ["+serviceURI+"]---> compName = ["+compName+"]");
			Service service = new Service();
			Call call = (Call)service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(serviceURI));
			call.setOperationName( new javax.xml.namespace.QName("http://NvoServiceurl.org", methodName ) );
			call.setUseSOAPAction(true);
			call.setSOAPActionURI(actionURI);
			Object[] aobj = new Object[4];

			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "tran_id"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "forced_flag"), XMLType.XSD_STRING, ParameterMode.IN);

			aobj[0] = new String(compName);
			aobj[1] = new String(tranIdFr);
			aobj[2] = new String(xtraParams);
			aobj[3] = new String(forcedFlag);
			//System.out.println("@@@@@@@@@@loginEmpCode:" +genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode")+":");
			System.out.println("@@@@@@ call.setReturnType(XMLType.XSD_STRING) executed........");
			call.setReturnType(XMLType.XSD_STRING);

			retString = (String)call.invoke(aobj);

			System.out.println("Confirm Complete @@@@@@@@@@@ Return string from NVO is:==>["+retString+"]");

		}
		catch(Exception e)
		{			
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{		
			try{
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}	
				if (rs !=null)
				{
					rs.close();
					rs=null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception inCalling confirmed");
				e.printStackTrace();
				try{
					conn1.rollback();

				}catch (Exception s)
				{
					System.out.println("Unable to rollback");
					s.printStackTrace();
				}
				throw new ITMException(e);
			}

		}
		return retString;

	}
	
	private String generateInvoiceReport(String ptcn, String despatchID, String printer, Connection conn1, String xtraParams) throws ITMException
	{

		String reportObjName = ""; 
		String errString = "";
		String loginCode = "";
		String loginSite = "", custCodeFr = "00", custCodeTo = "ZZ", invoiceIdFr = "00", invoiceIdTo = "ZZ";

		java.util.Date currDate = null ;
		String dbDateFormat = null;
		String applDateFormat = null;
		DateFormat dateFormat = null;
		String currDateStr = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		String custLang = "", operLang = "", custCode = "", siteCode = "";
		String sql1 = "", sql2 = "", sql3 = "";

		try
		{

			if(ptcn != null && !(ptcn.trim().length() > 0))
			{
				ptcn = null;
			}

			if(ptcn == null || ptcn.trim().length() <= 0)
			{
				ptcn = "";
				System.out.println("inside blank ptcn["+ptcn+"]");
			}

			E12GenericUtility genericUtility = new E12GenericUtility();
			currDate = new java.util.Date();
			dbDateFormat = genericUtility.getDBDateFormat();
			applDateFormat = genericUtility.getApplDateFormat();
			dateFormat = new SimpleDateFormat(applDateFormat);
			currDateStr = dateFormat.format(currDate);
			SimpleDateFormat simpleDateFormatDB = new SimpleDateFormat(genericUtility.getDBDateFormat());
			Timestamp timestamp = Timestamp.valueOf(simpleDateFormatDB.format(currDate).toString() + " 00:00:00.0");
			loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));
			loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");


			sql3 = "SELECT INVOICE_ID FROM INVOICE where DESP_ID = ?";			   
			pstmt = conn1.prepareStatement(sql3);
			pstmt.setString(1, despatchID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				invoiceIdFr = rs.getString(1);					 
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;

			}
			if(rs != null)
			{
				rs.close();
				rs = null;

			}

			DistCommon discommon = new DistCommon();	

			//reportObjName = "d_invoice_rev";	

			ibase.webitm.reports.utility.JasperReportGenerator jrGenerator = new ibase.webitm.reports.utility.JasperReportGenerator();
			String xsdString ="<Arguments>" +
			"<Argument id=\"arg1\" name=\"as_site_code\">" +
			"<argType>java.lang.String</argType>" +						
			"<value>"+loginSite+"</value>" +
			"</Argument>" +

			"<Argument id=\"arg1\" name=\"as_cust_code_fr\">" +
			"<argType>java.lang.String</argType>" +						
			"<value>"+custCodeFr+"</value>" +
			"</Argument>" +

			"<Argument id=\"arg1\" name=\"as_cust_code_to\">" +
			"<argType>java.lang.String</argType>" +						
			"<value>"+custCodeTo+"</value>" +
			"</Argument>" +

			"<Argument id=\"arg1\" name=\"as_invoice_id_fr\">" +
			"<argType>java.lang.String</argType>" +						
			"<value>"+invoiceIdFr+"</value>" +
			"</Argument>" +

			"<Argument id=\"arg1\" name=\"as_invoice_id_to\">" +
			"<argType>java.lang.String</argType>" +						
			"<value>"+invoiceIdFr+"</value>" +
			"</Argument>" +

			"<Argument id=\"arg1\" name=\"as_date_fr\">" +
			"<argType>java.util.Date</argType>" +						
			"<value>"+currDateStr+"</value>" +
			"</Argument>" +

			"<Argument id=\"arg1\" name=\"as_date_to\">" +
			"<argType>java.util.Date</argType>" +						
			"<value>"+currDateStr+"</value>" +
			"</Argument>" +

			"<Argument id=\"arg8\" name=\"x_path\">" +
			"<argType>java.lang.String</argType>" +
			"<value>/DocumentRoot/d_invoice_rev</value>" +
			"</Argument>" +

			"<Argument id=\"arg9\" name=\"design_source\">" +
			"<argType>java.lang.String</argType>" +
			"<value>d_invoice_rev.jrxml</value>" +
			"</Argument>" +

			"<Argument id=\"arg9\" name=\"data_source\">" +
			"<argType>java.lang.String</argType>" +
			"<value>SQL</value>" +
			"</Argument>" +

			"<Argument id=\"arg9\" name=\"bind_type\">" +
			"<argType>java.lang.Integer</argType>" +
			"<value>0</value>" +
			"</Argument>" +

			"<Argument id=\"arg9\" name=\"report_type\">" +
			"<argType>java.lang.String</argType>" +
			"<value>JASPER</value>" +
			"</Argument>" +

			"<Argument id=\"arg7\" name=\"report_save_type\">" +
			"<argType>java.lang.String</argType>" +								
			"<value>NATIVE</value>" +
			"</Argument>" +
			"</Arguments>";
			System.out.println("XSD parser **->["+xsdString+"]");	
			siteCode = loginSite;

			if(siteCode!=null)
			{
				sql1 = "select report_name from site_spec_report where site_code = ?";			   

				pstmt1 = conn1.prepareStatement(sql1);
				pstmt1.setString(1, siteCode);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					reportObjName = rs1.getString(1);

				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;

				}
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;

				}
			}

			String objName = "";
			//String outputFilename = this.objName + loginSite + System.currentTimeMillis();
			XSDParser xsdParser = new XSDParser(reportObjName);	
			TreeMap argMap = jrGenerator.createArgMap(xsdString);
			errString = jrGenerator.callRemotePrintServlet(reportObjName, xsdString, loginCode, printer.trim(), 1, conn1);


			System.out.println("DONE");
		}
		catch(Exception e)
		{
			System.err.println("Exception : calling Invoice Print report ------------------- :\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		return null;
	}
	
	
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}

	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	
	private String getDespatchId(String ptcn, String siteCode, Connection conn1) throws Exception
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";

		String despatchId = "";
		try
		{				
			sql = " select distinct d.desp_id, d.ptcn from despatch d, despatchdet dd, wave_task_det w where d.confirmed = ? and d.site_code = ? " 
				+ " and d.site_code = dd.site_code and d.desp_id = dd.desp_id and w.status = ? and d.ptcn = w.ptcn and d.ptcn = ? ";	
			pstmt = conn1.prepareStatement(sql);
			pstmt.setString(1, "N");
			pstmt.setString(2, siteCode);
			pstmt.setString(3, "Y");
			pstmt.setString(4, ptcn);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				despatchId = checkNullAndTrim(rs.getString(1));	
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getDespatchId ::::::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("Return value form getDespatchId ------>>" + despatchId);		
		return despatchId;
	}

	private int getPrinterNameCount(String printer, Connection conn1) throws Exception
	{
		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		int count = 0;
		try
		{				
			sql = "select count(printer_name) from net_printers where printer_name = ? ";						
			pstmt = conn1.prepareStatement(sql);
			pstmt.setString(1, printer);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);	
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in getPrinterNameCount ::::::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("Return value form getPrinterNameCount ------>>" + count);		
		return count;
	}
	
	public String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " select msg_type from messages where msg_no =  ? ";
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}		
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

	public String getError(String despatchId, String Code, Connection conn1)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn1);
			String begPart = errString.substring(0,errString.indexOf("<message>")+9);
			String endDesc = errString.substring(errString.indexOf("</description>"));
			mainStr= begPart+"Transaction confirmed."+"</message><description>";
			mainStr= mainStr+"Transaction confirmed for Despatch ID : ["+despatchId+"]."+endDesc;
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	
}


