package ibase.webitm.ejb.fin;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class EcollectionPostSave extends ValidatorEJB implements EcollectionPostSaveLocal, EcollectionPostSaveRemote {
	
	public String postSave(String xmlString, String tranId, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException {

		System.out.println("------------ postSave method called-----------------EcollectionPostSave : ");
		System.out.println("tranId111--->>[" + tranId + "]");
		System.out.println("xml String--->>[" + xmlString + "]");
		Document dom = null;
		String errString = "";
		try {
			if (xmlString != null && xmlString.trim().length() > 0) {
				dom = parseString(xmlString);
				errString = postSave(dom, tranId, xtraParams, conn);
			}
		} catch (Exception e) {
			System.out.println("Exception : EcollectionPostSave.java : postSave : ==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return errString;
	}

	public String postSave(Document dom, String tranId, String xtraParams, Connection conn) {
		System.out.println("in EcollectionPostSave tran_id---->>[" + tranId + "]");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql = "", errorString = "", custCode = "", siteCode = "", errCode = "";
		double rcpAmt = 0, chqAmt = 0, rcpamtSum = 0, rcpAmtT = 0, rcpAmtNew = 0, rcpAmtStatus = 0;
		int count = 0;
		
		try {
			// GenericUtility genericUtility = GenericUtility.getInstance();
			E12GenericUtility genericUtility = new E12GenericUtility();
			String userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			tranId = genericUtility.getColumnValue("tran_id", dom);
			chqAmt = Double.parseDouble(genericUtility.getColumnValue("chq_amt", dom, "1"));
			custCode = genericUtility.getColumnValue("cust_code", dom, "1");
			siteCode = genericUtility.getColumnValue("site_code", dom, "1");
			
			sql = "SELECT (TOT_AMT - ADJ_AMT) AS AMT FROM RECEIVABLES WHERE TRAN_SER = ? AND REF_NO = ?  AND cust_code = ?  and site_code= ?  ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, checkNull(genericUtility.getColumnValue("ref_ser", dom)));
			pstmt.setString(2, checkNull(genericUtility.getColumnValue("ref_no", dom)));
			pstmt.setString(3, custCode);
			pstmt.setString(4, siteCode);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				rcpAmt = rs.getDouble(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("rcpAmtNew>>>[" + rcpAmtNew + "]rcpAmt[" + rcpAmt + "]");
			// Start added by chandr shekar on 21-mar-2016
			sql = "select nvl(sum(rcpdet.rcp_amt), 0) as amt from rcpdet_form rcpdet, receipt_form rcpform "
					+ "where rcpform.tran_id=rcpdet.tran_id and rcpdet.ref_ser=?  "
					+ "and rcpdet.rcp_amt>0 and rcpform.status !='X' and rcpdet.ref_no=? "
					+ "AND rcpform.cust_code = ? and rcpform.site_code= ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, checkNull(genericUtility.getColumnValue("ref_ser", dom)));
			pstmt.setString(2, checkNull(genericUtility.getColumnValue("ref_no", dom)));
			pstmt.setString(3, custCode);
			pstmt.setString(4, siteCode);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				rcpAmtStatus = rs.getDouble(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("rcpAmtStatus>>>" + rcpAmtStatus);
			// End added by chandrashekar on 21-mar-2016
			if (rcpAmt - rcpAmtStatus < rcpAmtNew) {
				errCode = "VTINVTLAMT";
				errorString = getErrorString("", errCode, userId);
				return errorString;
			}
			
			if(isChqAmtGreater(dom, chqAmt)){
				errCode = "VTINVCQAMT";
				errorString =  getErrorString("rcp_amt", errCode, userId);
				return errorString;
			}
			System.out.println("tranId--->>[" + tranId + "]");

			sql = "SELECT NVL(SUM(RCP_AMT), 0) FROM RCPDET_FORM WHERE TRAN_ID = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				count++;
				rcpAmtT = rs.getDouble(1);
				rcpamtSum = rcpamtSum + rcpAmtT;
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("rcpamtSum>>>>>>>>" + rcpamtSum);
			
			if(chqAmt > rcpamtSum) {
				System.out.println("Receipt Amount is Less... :)");
				errCode = "VTINVCQAMT";
				errorString =  getErrorString("rcp_amt", errCode, userId);
				return errorString;
			}
			
			System.out.println("count>>>>>>>>" + count);

			/*if (count > 0) {
				sql = "update receipt_form set chq_amt = ?   where tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1, rcpamtSum);
				pstmt.setString(2, tranId);
				count = pstmt.executeUpdate();
				System.out.println("post count---->>[" + count + "]");
				if (count > 0) {
					conn.commit();
				}
			} else {
				conn.rollback();
			}*/
		} catch (Exception e) {
			System.out.println("Exception : EcollectionPostSave -->["
					+ e.getMessage() + "]");
			e.printStackTrace();
			try {
				conn.rollback();
			} catch (Exception e1) {
				System.out
						.println("Exception while rollbacking transaction....");
				e1.printStackTrace();
			}
		}
		return errorString;
	}
	
	private String checkNull(String columnValue) {
		return columnValue == null ? "" : columnValue;
	}

	private boolean isChqAmtGreater(Document dom, double chqAmt) {
		NodeList parentList = null, childList = null;
		Node parentNode = null, childNode = null;

		String lineNoDom = "", rcpAmtSt = "";
		boolean ischqAmtGreater = false;
		double chqAmtMeth = 0.0, chqAmtSum = 0.0;
		String refNoDom = "", refSerDom = "";
		System.out.println("---inside ischqAmtGreater--");
		try {
			parentList = dom.getElementsByTagName("Detail2");
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = parentNodeListLength; prntCtr > 0; prntCtr--) {
				parentNode = parentList.item(prntCtr - 1);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++) {
					childNode = childList.item(ctr);
					System.out.println("childNode>>>" + childNode);
					if (childNode != null && childNode.getNodeName().equalsIgnoreCase("attribute")) {
						String updateFlag = "";
						updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
						System.out.println("updateFlag>>>" + updateFlag);
						if (updateFlag.equalsIgnoreCase("D")) {
							System.out.println("Break from here as the record is deleted");
							break;
						}
					}
					if (childNode != null && childNode.getFirstChild() != null && childNode.getNodeName().equalsIgnoreCase("rcp_amt")) {
						rcpAmtSt = childNode.getFirstChild().getNodeValue().trim();
						if (rcpAmtSt != null && rcpAmtSt.trim().length() > 0) {
							try {
								chqAmtMeth = Double.parseDouble(rcpAmtSt);
							} catch (NumberFormatException n) {
								chqAmtMeth = 0;
							}
						}
					}
				}
				chqAmtSum = chqAmtSum + chqAmtMeth;
			}// for loop
			System.out.println("chqAmtSum>>>[" + chqAmtSum + "] : chqAmt>>>>[" + chqAmt + "]");
			if (chqAmt < chqAmtSum) {
				ischqAmtGreater = true;
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		System.out.println("ischqAmtGreater>>>>>> [" + ischqAmtGreater + "]");
		return ischqAmtGreater;
	}
}
