package ibase.dashboard.sfa.ejb;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.ejb.Stateless;

/**
 * Session Bean implementation class ImpEvents
 */
@Stateless
public class ImpEvents  extends ValidatorEJB implements ImpEventsRemote, ImpEventsLocal {

    /**
     * Default constructor. 
     */
    public ImpEvents() {
        // TODO Auto-generated constructor stub
    }

	@Override
    public String getData() throws RemoteException, ITMException
    {
	    // TODO Auto-generated method stub
	    return null;
    }

	@Override
    public String getData(String loginCode) throws RemoteException, ITMException
    {

		String sql = "";
		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer xmlData =null;

		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
				
			    xmlData = new StringBuffer("<?xml version=\"1.0\"?><Root>");
				sql = "select STRG_EVENTS.EVENT_DATE as Event_Date, STRG_CUSTOMER.SC_CODE, INITCAP(strg_customer.first_name||' '||strg_customer.middle_name||' '||strg_customer.last_name )AS DrName, LISTAGG(STRG_EVENTS.DESCR, ', ') WITHIN GROUP (ORDER BY STRG_EVENTS.DESCR) as Event FROM SALES_PERS INNER JOIN STRG_SERIES on STRG_SERIES.SALES_PERS = SALES_PERS.SALES_PERS and STRG_SERIES.Cust_Type = 'D' and STRG_SERIES.Status = 'Y' INNER JOIN STRG_CUSTOMER ON STRG_CUSTOMER.SC_CODE = STRG_SERIES.SC_CODE INNER JOIN STRG_EVENTS ON STRG_CUSTOMER.SC_CODE = STRG_EVENTS.SC_CODE WHERE SALES_PERS.SALES_PERS = ? AND STRG_EVENTS.EVENT_DATE  = TO_DATE(sysdate,'dd/mm/yy HH24:MI:SS') group by STRG_EVENTS.EVENT_DATE , STRG_CUSTOMER.SC_CODE, strg_customer.first_name, strg_customer.middle_name, strg_customer.last_name";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, loginCode);
				rs = pstmt.executeQuery();
			
				while (rs.next())
				{
					xmlData.append("<Detail1>");
					xmlData.append("<drname>").append("<![CDATA[" + checkNull(rs.getString("DrName")) + "]]>").append("</drname>");
					xmlData.append("<event>").append("<![CDATA[" + checkNull(rs.getString("Event"))+"]]>").append("</event>");
					xmlData.append("</Detail1>");
				}
				
				pstmt.close();
				pstmt = null;
				rs.close();
				rs = null;
				
				sql="select STRG_EVENTS.EVENT_DATE as Event_Date, STRG_CUSTOMER.SC_CODE, INITCAP(strg_customer.first_name||' '||strg_customer.middle_name||' '||strg_customer.last_name )AS DrName, LISTAGG(STRG_EVENTS.DESCR, ', ') WITHIN GROUP (ORDER BY STRG_EVENTS.DESCR) as Event FROM SALES_PERS INNER JOIN STRG_SERIES on STRG_SERIES.SALES_PERS = SALES_PERS.SALES_PERS and STRG_SERIES.Cust_Type = 'D' and STRG_SERIES.Status = 'Y' INNER JOIN STRG_CUSTOMER ON STRG_CUSTOMER.SC_CODE = STRG_SERIES.SC_CODE INNER JOIN STRG_EVENTS ON STRG_CUSTOMER.SC_CODE = STRG_EVENTS.SC_CODE WHERE SALES_PERS.SALES_PERS = ?  AND STRG_EVENTS.EVENT_DATE  = TO_DATE(sysdate,'dd/mm/yy HH24:MI:SS') + 1 group by STRG_EVENTS.EVENT_DATE , STRG_CUSTOMER.SC_CODE, strg_customer.first_name, strg_customer.middle_name, strg_customer.last_name";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, loginCode);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					xmlData.append("<Detail2>");
					xmlData.append("<drname>").append("<![CDATA[" + checkNull(rs.getString("DrName"))+ "]]>").append("</drname>");
					xmlData.append("<event>").append("<![CDATA[" + checkNull(rs.getString("Event"))+"]]>").append("</event>");
					xmlData.append("</Detail2>");
				}
				
				pstmt.close();
				pstmt = null;
				rs.close();
				rs = null;
				
				sql="select STRG_EVENTS.EVENT_DATE as Event_Date, STRG_CUSTOMER.SC_CODE, INITCAP(strg_customer.first_name||' '||strg_customer.middle_name||' '||strg_customer.last_name )AS DrName, LISTAGG(STRG_EVENTS.DESCR, ', ') WITHIN GROUP (ORDER BY STRG_EVENTS.DESCR) as Event FROM SALES_PERS INNER JOIN STRG_SERIES on STRG_SERIES.SALES_PERS = SALES_PERS.SALES_PERS and STRG_SERIES.Cust_Type = 'D' and STRG_SERIES.Status = 'Y' INNER JOIN STRG_CUSTOMER ON STRG_CUSTOMER.SC_CODE = STRG_SERIES.SC_CODE INNER JOIN STRG_EVENTS ON STRG_CUSTOMER.SC_CODE = STRG_EVENTS.SC_CODE WHERE SALES_PERS.SALES_PERS = ? AND STRG_EVENTS.EVENT_DATE >= TO_DATE(sysdate,'dd/mm/yy HH24:MI:SS')+2 AND STRG_EVENTS.EVENT_DATE <= TO_DATE(sysdate,'dd/mm/yy HH24:MI:SS')+8 group by STRG_EVENTS.EVENT_DATE, STRG_CUSTOMER.SC_CODE, strg_customer.first_name, strg_customer.middle_name, strg_customer.last_name"; 
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, loginCode);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					xmlData.append("<Detail3>");
					xmlData.append("<drname>").append("<![CDATA[" + checkNull(rs.getString("DrName")) + "]]>").append("</drname>");
					xmlData.append("<event>").append("<![CDATA[" + rs.getString(("Event"))+"]]>").append("</event>");
					xmlData.append("<event_date >").append("<![CDATA[" + rs.getDate("Event_Date") + "]]>").append("</event_date>");
					xmlData.append("</Detail3>");
				}
				pstmt.close();
				pstmt = null;
				rs.close();
				rs = null;
				xmlData.append("</Root>");
			
		} catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :ImpEvents:" + e.getMessage());
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception :ImpEvents:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return xmlData.toString();
	
    
    
    }
	
	private String checkNull(String input)
	{
		if (input == null)
		{
			input = "";
		} else
		{
			input = input.trim();
		}
		return input;
	}

}
