package ibase.webitm.ejb.fin.adv;

//import java.io.BufferedReader;
//import java.io.File;
//import java.io.FileReader;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
//import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
//import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

import javax.ejb.Stateless;

import ibase.system.config.ConnDriver;
//import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.E12CreateBatchLoadEjb;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.utility.ITMException;
import org.w3c.dom.Document;


@Stateless
public class SupplierBankConf extends ActionHandlerEJB implements SupplierBankConfLocal, SupplierBankConfRemote 
{
	E12GenericUtility genericUtility = new E12GenericUtility();

	public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException, ITMException 
	{
		System.out.println("Inside SupplierBankConf method>>>>>  : " + tranId);
		String retString = "";
		try 
		{
			retString = confirmSuppBank(tranId, xtraParams, forcedFlag);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception :SuppBankConf :confirm():"+ e.getMessage() + ":");
			retString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		return retString;
	}

	private String confirmSuppBank(String tranId, String xtraParams,String forcedFlag) throws RemoteException,ITMException 
	{
		System.out.println("SuppBankConf>>>> confirm method called>>>>>>>");
		String suppCode = "";
		String bankCode = "";
		String runMode = "", ediOption = "", dataStr = "", confirmed = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean isPreExist=false;
		ConnDriver connDriver = new ConnDriver();
		String errString = "", retString = "", sql = "", empCodeAprv = "", activeYn = "";
		String effFromStr="",validUptoStr="";
		SimpleDateFormat sdf = null,sdf1=null;
		Timestamp preTmstp=null,effFromTmstp=null,validUptoTmstp=null,effFromTmstp1=null,validUptoTmstp1=null;
		Timestamp validUptoDt=null,validUpto=null,effFromDt=null;
		Date effFrom=null,prevDate=null,validUptoNew=null,effFromNew=null;
		Date validUptoDate=null,effFromDate=null;
		int updateCount = 0, updateCount1=0,ediOpt = 0;
		
		String effFromStr1="",validUptoSrt1="";
		
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		try 
		{
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			conn.setAutoCommit(false);
			connDriver = null;
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			String[] pkValuesArr = string2StringArray(tranId, ":");
			suppCode = checkNull(pkValuesArr[0]).trim();
			effFromStr = checkNull(pkValuesArr[1]).trim();
			validUptoStr = pkValuesArr[2].trim();
			
			effFromDt = Timestamp.valueOf(genericUtility.getValidDateString(effFromStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");
			validUptoDt = Timestamp.valueOf(genericUtility.getValidDateString(validUptoStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())+ " 00:00:00.0");
			
			System.out.println("Effective from TimeStamp pkvalues>>>>>>>>"+effFromDt);
			System.out.println("Valid from TimeStamp pkvalues>>>>>>>>"+validUptoDt);
			
			empCodeAprv = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			runMode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"runMode");
			System.out.println("Employee Code ------->> " + empCodeAprv+"Run Mode>>>" + runMode);
			
			Date currdt = new java.sql.Date(new java.util.Date().getTime());
			System.out.println("Date>>>>>>>>>>" + currdt);

			sdf1 = new SimpleDateFormat(genericUtility.getDBDateFormat());
			Timestamp currDate = java.sql.Timestamp.valueOf(sdf1.format(currdt).toString() + " 00:00:00.0");
			
			System.out.println("TimeStamp currDate>>>"+currDate);
			System.out.println("Tran ID>>>>>>>>"+tranId);
			System.out.println("Supplier Code>>>>>>>>"+suppCode);
			
			sql = "select confirmed, active_yn from supplier_bank where supp_code= ? and eff_from = ? and valid_upto = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, suppCode);
			pstmt.setTimestamp(2, effFromDt);
			pstmt.setTimestamp(3, validUptoDt);
			rs = pstmt.executeQuery();
			if (rs.next()) 
			{
				confirmed = checkNull(rs.getString("confirmed"));
				activeYn = checkNull(rs.getString("active_yn"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			System.out.println("Confirm>>>>>>>>>" + confirmed);
			System.out.println("ActiveYn>>>>>>>>" + activeYn);
			
			if (confirmed != null && confirmed.equalsIgnoreCase("Y")) 
			{
				System.out.println("This tansaction is  already confirmed");
				errString = itmDBAccessEJB.getErrorString("", "VTINVCONF2", "","", conn);
				System.out.println("ErrorString inside Confirmed YES"+errString);
				return errString;
			} 
			else 
			{
				sql="select eff_from,valid_upto from supplier_bank where supp_code = ?" +
				" and active_yn = 'N' and confirmed= 'N' ";                    
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, suppCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					effFromTmstp1 = rs.getTimestamp("eff_from");
					validUptoTmstp1 = rs.getTimestamp("valid_upto");
					
					System.out.println("Effective effFromTmstp1>>>>>"+effFromTmstp1);
					System.out.println("Valid upto validUptoTmstp1>>>>>"+validUptoTmstp1);
				}
				pstmt.close();
				pstmt = null;
				rs.close();
				rs = null;
				if(effFromTmstp1.after(validUptoTmstp1))
				{
					System.out.println("Active_N $ Confirm_N>>>");
					errString = itmDBAccessEJB.getErrorString("", "VMSDLTED","", "", conn);
					return errString;
				}
				
				/**
				 * To get eff_from & valid_upto from previous saved record if any
				 * */
				
				sql="select eff_from,valid_upto from supplier_bank where supp_code = ?" +
						" and active_yn = 'Y' and confirmed= 'Y' ";                    
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, suppCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					effFromTmstp = rs.getTimestamp("eff_from");
					validUptoTmstp = rs.getTimestamp("valid_upto");
					isPreExist=true;
					
					System.out.println("Effective Date>>>>>"+effFromTmstp);
					System.out.println("Valid upto Date>>>>>"+validUptoTmstp);
					System.out.println("isPreExist>>>>>"+isPreExist);
				}
				pstmt.close();
				pstmt = null;
				rs.close();
				rs = null;
				if(effFromTmstp == null && validUptoTmstp == null)
				{
					System.out.println("Inside if(effFromTmstp==null && validUptoTmstp==null)");
//					/**
//					 * update the current record with confirmed='Y' and active_yn='Y'
//			
//					sql = "update supplier_bank set confirmed = 'Y', wf_status='C', active_yn='Y', conf_date = ?,emp_code__aprv = ?, eff_from =?, status_date= ? where supp_code = ? and eff_from = ? and valid_upto= ?";
					sql = "update supplier_bank set confirmed = 'Y', wf_status='C', active_yn='Y', conf_date = ?,emp_code__aprv = ?, eff_from =?, status_date= ? where supp_code = ? and eff_from = ? and valid_upto= ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1, currDate);
					pstmt.setString(2, empCodeAprv);
					pstmt.setTimestamp(3, currDate);
					pstmt.setTimestamp(4, currDate);
					pstmt.setString(5, suppCode);
					pstmt.setTimestamp(6, effFromDt);
					pstmt.setTimestamp(7, validUptoDt);
					updateCount = pstmt.executeUpdate();
					System.out.println("no of row update updateCount: " + updateCount);
					System.out.println("Confirm Date>>>>>" + currDate);
					System.out.println("Employee Approved Code>>> " + empCodeAprv);
					System.out.println("Supplier Code>>>>" + suppCode);
					System.out.println("new java.sql.Date(new java.util.Date().getTime())"+new java.sql.Date(new java.util.Date().getTime()));
					pstmt.close();
					pstmt = null;
					if (updateCount > 0) 
					{
						System.out.println("The selected transaction Updated");
						conn.commit();
						errString = itmDBAccessEJB.getErrorString("", "VTCONSUCF","", "", conn);
						System.out.println("ErrorString inside 1st Confirm"+errString);
						return errString;
						
					}
				}
				else
				{
					System.out.println("Inside ELSE OF (effFromTmstp==null && validUptoTmstp==null)");
					//Updating the field confirmed = 'Y', active_yn='Y', conf_date,emp_code__aprv, eff_from   
					sql = "update supplier_bank set confirmed = 'Y', wf_status='C', active_yn='Y', conf_date = ?,emp_code__aprv = ?, eff_from =?, status_date= ? where supp_code = ? and eff_from = ? and valid_upto= ?";
					pstmt = conn.prepareStatement(sql);
//					pstmt.setTimestamp(1, currDate);
					pstmt.setTimestamp(1, currDate);
					pstmt.setString(2, empCodeAprv);
					pstmt.setTimestamp(3, currDate);
					pstmt.setTimestamp(4, currDate);
					pstmt.setString(5, suppCode);
					pstmt.setTimestamp(6, effFromDt);
					pstmt.setTimestamp(7, validUptoDt);
					updateCount = pstmt.executeUpdate();
					System.out.println("no of row update: " + updateCount);
					System.out.println("Confirm Date>>>>>" + currDate);
					System.out.println("Employee Approved Code>>> " + empCodeAprv);
					System.out.println("Supplier Code>>>>" + suppCode);
					pstmt.close();
					pstmt = null;

					if (updateCount > 0) 
					{
						System.out.println("The selected transaction is confirmed successfully");
						System.out.println("validUptoTmstp>>>>>"+validUptoTmstp);
						System.out.println("effFromDt>>>>>"+effFromDt);
						if(isPreExist)
						{
							/** if validUptoTmstp(Saved Record) is greater than Effective date(Current Record)
							  * then previous date of Confirmation date will be saved*/  
							if(validUptoTmstp.after(effFromDt) || validUptoTmstp.before(effFromDt))
							{
								System.out.println("Inside Previous Date ");
								prevDate=this.getPreDate(currDate, 1);
								System.out.println("Previous date>>>>>"+prevDate);
								
								sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
								preTmstp = java.sql.Timestamp.valueOf(sdf.format(prevDate).toString() + " 00:00:00.0");
								System.out.println("Previous date in Timestamp>>>>>"+preTmstp);
							}
							else
							{
								System.out.println("Previous date inside else>>>>>"+validUptoTmstp);
								preTmstp = validUptoTmstp;
								System.out.println("Previous date inside else>>>>>"+preTmstp);
							}
							//If validUptoTmstp(preTmstp) is less than Effective Date(Previous Record)
							if(preTmstp.before(effFromTmstp))
							{
								System.out.println("if(preTmstp.before(effFromTmstp))");
								System.out.println("preTmstp < effFromTmstp : "+preTmstp+" < "+effFromTmstp);
								System.out.println("Previous date inside else>>>>>"+preTmstp);
								System.out.println("Effective from date(Database)>>>>>"+effFromTmstp);
								
//								conn.rollback();
								System.out.println("Commited after previous");
								errString = itmDBAccessEJB.getErrorString("", "VTINVPREDT","", "", conn);
								System.out.println("if(preTmstp.before(currDate)) Error String"+errString);
								System.out.println("ErrorString inside if(preTmstp.before(effFromTmstp))"+errString);
								return errString;
							}
							//Updating previous saved to active_yn = 'N', valid_upto=preTmstp
							sql="update supplier_bank set active_yn = 'N', valid_upto= ? where trim(supp_code)=? and trim(eff_from) = ? and trim(valid_upto)= ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setTimestamp(1, preTmstp);
							pstmt.setString(2, suppCode);
							pstmt.setTimestamp(3, effFromTmstp);
							pstmt.setTimestamp(4, validUptoTmstp);
							updateCount1 = pstmt.executeUpdate();
							System.out.println("no of row update: " + updateCount1);
							System.out.println("Valid Upto New (Previous Date)>>>>>" + preTmstp);
							System.out.println("Supplier Code>>>>" + suppCode);
							System.out.println("Effective Date in TimeStamp>>>>" + effFromTmstp);
							System.out.println("Valid Upto Date in TimeStamp>>>>" + validUptoTmstp);
							pstmt.close();
							pstmt = null;
						}
						if (updateCount1 > 0) 
						{
							System.out.println(">>The selected transaction is confirmed");
							errString = itmDBAccessEJB.getErrorString("","VTCONSUCF","","",conn);
							return errString;
						}
				}
			}
			System.out.println("Run Mode>>>>>>" + runMode);
			if (runMode != "I" && (errString == null || (errString.trim().length() == 0))) 
			{
				sql = "select edi_option from transetup where tran_window = 'w_supplier_bank' ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if (rs.next()) 
				{
					ediOption = rs.getString("edi_option");
					System.out.println("Edi OPtion>>>>>>"+ediOption);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				ediOption = (ediOption) != null ? ediOption : "0";
				ediOpt = Integer.parseInt(ediOption);
				System.out.println("Edit Opt (Integer)>>>>>>>>>>" + ediOpt);
				if (ediOpt > 0) 
				{
					CreateRCPXML createRCPXML = new CreateRCPXML("w_supplier_bank", "tran_id");
					dataStr = createRCPXML.getTranXML(tranId, conn);
					System.out.println("dataStr =[ " + dataStr + "]");
					Document ediDataDom = genericUtility.parseString(dataStr);

					E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
					retString = e12CreateBatchLoad.createBatchLoad(ediDataDom,"w_supplier_bank", "" + ediOpt, xtraParams, conn);
					createRCPXML = null;
					e12CreateBatchLoad = null;

					if (retString != null && "SUCCESS".equals(retString))
					{
						System.out.println("retString = [" + retString + "]");
					}
				}
			}
		} 
	}
		catch (SQLException se) 
		{
			System.out.println("SQLException : class SupplierBankConf : ");
			se.printStackTrace();
			try 
			{
				conn.rollback();
			} 
			catch (Exception e) 
			{
				System.out.println("Exception : Occured during rollback........");
				e.printStackTrace();
			}
		}
		catch (Exception e)
		{
			try 
			{
				conn.rollback();
			} 
			catch (Exception e1)
			{
				e1.printStackTrace();
				System.out.println("Exception Class [SupplierBankConf]::"+ e.getMessage());
			}
		} 
		finally 
		{
			try
			{
				System.out.println(">>>>>In finally errString:"+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					if(errString.indexOf("VTCONSUCF") > -1)
					{
						conn.commit();
						System.out.println("Commit Completed");
					}
					else
					{
						conn.rollback();
					}
				}
				if(rs != null)
				{	
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				conn.close();
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("[SupplierBankConf]errstring :" + errString);
		return errString;
	}

	private String[] string2StringArray(String str1, String delimeter) 
	{
		StringTokenizer st = new StringTokenizer(str1, delimeter);
		int count = st.countTokens();
		System.out.println("TOKEN COUNT" + count);
		String[] arry1 = new String[count];
		int i = 0;
		while (st.hasMoreTokens()) 
		{
			arry1[i] = st.nextToken();
			System.out.println("Token " + i + " :[" + arry1[i] + "]");
			i++;
		}
		return arry1;
	}

	private String checkNull(String input) 
	{
		if (input == null) 
		{
			input = "";
		}
		return input;
	}// end of checkNull
	
	private Date getPreDate(Date currDate, int noOfMonths)
	{
		java.util.Date preDate=null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(currDate);
		cal.add(Calendar.DAY_OF_MONTH , -1);
		preDate = cal.getTime();
		System.out.println(">>>>Previous Date:"+ preDate);
		
		return preDate;
	}
	
}
	
