package ibase.dashboard.sfa.ejb;

import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.io.File;
import java.rmi.RemoteException;
import org.json.simple.JSONObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Calendar;

import javax.ejb.Stateless;

@Stateless
public class PlanVsActual extends ValidatorEJB implements PlanVsActualLocal,PlanVsActualRemote 
{
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getPlanVsActualTreeStructure(String dataSourceName,String loginId,String fromDate,String toDate,String salePersons) throws RemoteException, ITMException 
	{
		JSONObject rawDataPlanDtlJson = new JSONObject();
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String appendSQL = "";
		DashboardUtility dashboardUtility = null;
		SimpleDateFormat formatter = null;
		E12GenericUtility e12GenericUtility = null;
		try 
		{
			fromDate = fromDate == null ? "": fromDate.trim();
			toDate = toDate == null ? "": toDate.trim();
			salePersons = salePersons == null ? "": salePersons.trim();
			dashboardUtility = new DashboardUtility();
			salePersons = dashboardUtility.getCommaSeparated(salePersons);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			formatter = new SimpleDateFormat("dd-MMM-yy");
			HashMap<String, ArrayList<String>> planHashMap = new HashMap<String, ArrayList<String>>();
			
			ArrayList<String> docList = new ArrayList<String>();
			
			//HashMap<String, HashMap<String, ArrayList<String>>> finalMap = new HashMap<String, HashMap<String,ArrayList<String>>>();
			TreeMap<String, HashMap<String, ArrayList<String>>> finalMap = new TreeMap<String, HashMap<String,ArrayList<String>>>();
			
			/*----------Planned doctors visited-----Planned--------*/
			if("".equalsIgnoreCase(fromDate) && "".equalsIgnoreCase(toDate)){
				fromDate = getDateString("firstDayOfWeek",formatter);
				toDate = getDateString("lastDayOfWeek",formatter);
				
				appendSQL = " AND SP.SALES_PERS IN (SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = (SELECT EMP_CODE FROM USERS WHERE CODE='"+loginId+"') connect by prior emp_code = report_to))";
			}
			else {
				appendSQL = " AND sp.sales_pers in("+salePersons+")) ";
				e12GenericUtility = new E12GenericUtility();
				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd-MMM-yy");
				toDate = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy", "dd-MMM-yy");
			}
			
			sql = "(SELECT TO_CHAR(SM.EVENT_DATE,'DD-MON-YYYY') AS EVENTDATE , SP.SALES_PERS ,SP.SP_NAME ,SM.STRG_CODE ,INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY  FROM SALES_PERS SP INNER JOIN STRG_MEET SM ON SP.SALES_PERS=SM.SALES_PERS INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SM.EVENT_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'"+appendSQL+" INTERSECT  (SELECT TO_CHAR(SPH.PLAN_DATE,'DD-MON-YYYY') AS EVENTDATE , SP.SALES_PERS , SP.SP_NAME ,SPC.SC_CODE ,INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME , L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY  FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS=SPH.SPRS_CODE__PLAN INNER JOIN SPRS_PLAN_CUST SPC ON SPH.PLAN_ID=SPC.PLAN_ID INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SPC.SC_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SPH.PLAN_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'"+appendSQL+"";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			String docName = "",locality = "", speciality = "";
			String eventDate = "",docNamewithImage = "";
			
			
			while(rs.next())
			{
				eventDate = rs.getString("eventdate");
				docName = rs.getString("DoctorName");
				docNamewithImage = getImageStrfromName(docName);
				locality = rs.getString("LOCALITY");
				speciality = rs.getString("SPECIALITY");
				planHashMap = new  HashMap<String, ArrayList<String>>();
				if(finalMap!=null && finalMap.containsKey(eventDate))
				{
					planHashMap = finalMap.get(eventDate);
					docList = planHashMap.get("plan");
					//docList.add(docName+"@"+speciality+"@"+locality);
					docList.add(docNamewithImage+"@"+speciality+"@"+locality);
					planHashMap.put("plan", docList);
					planHashMap.put("missed", new ArrayList<String>());
					planHashMap.put("unplan", new ArrayList<String>());
					finalMap.put(eventDate, planHashMap);
				}
				else
				{
					docList = new ArrayList<String>();
					docList.add(docNamewithImage+"@"+speciality+"@"+locality);
					planHashMap.put("plan", docList);
					planHashMap.put("missed", new ArrayList<String>());
					planHashMap.put("unplan", new ArrayList<String>());
					finalMap.put(eventDate, planHashMap);
					
				}
			}
			rs = null;
			pstmt =null;
			System.out.println(" Planned doctors visited finalMap :"+finalMap);
			
			docList = new ArrayList<String>();
			/*----------Planned doctors not visited-----Missed-------*/
			//sql="(select to_char(SPH.PLAN_DATE,'dd-mm-yy')  as eventdate ,sp.sales_pers ,sp.sp_name ,spc.SC_CODE ,INITCAP(SC.first_name||' '||SC.middle_name||' '||SC.last_name )AS DoctorName ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY from sales_pers sp inner join sprs_plan_hdr sph on sp.sales_pers=sph.sprs_code__plan inner join sprs_plan_cust spc on sph.plan_id=spc.plan_id inner join STRG_CUSTOMER SC ON SC.SC_CODE=spc.SC_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SPH.PLAN_DATE between '06-AUG-16' and '16-AUG-16' AND SPRS_CODE__PLAN='M00005') MINUS (select to_char(sm.event_date,'dd-mm-yy')  as eventdate ,sp.sales_pers ,sp.sp_name ,SM.STRG_CODE ,INITCAP(SC.first_name||' '||SC.middle_name||' '||SC.last_name )AS DoctorName ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY from sales_pers sp inner join strg_meet sm on sp.sales_pers=sm.sales_pers INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE where sm.event_date between '06-AUG-16' and '16-AUG-16' AND SM.SALES_PERS='M00005' and sp.sales_pers in (select emp_code from employee start with emp_code = (select emp_code from users where code='M00001') connect by prior emp_code = report_to) and sp.sales_pers in ('M00005') )";
			sql = "(SELECT TO_CHAR(SPH.PLAN_DATE,'DD-MON-YYYY')  AS EVENTDATE ,SP.SALES_PERS ,SP.SP_NAME ,SPC.SC_CODE , INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS=SPH.SPRS_CODE__PLAN INNER JOIN SPRS_PLAN_CUST SPC ON SPH.PLAN_ID=SPC.PLAN_ID INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SPC.SC_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SPH.PLAN_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'"+appendSQL+" MINUS (SELECT TO_CHAR(SM.EVENT_DATE,'DD-MON-YYYY')  AS EVENTDATE ,SP.SALES_PERS , SP.SP_NAME ,SM.STRG_CODE ,INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY FROM SALES_PERS SP INNER JOIN STRG_MEET SM ON SP.SALES_PERS=SM.SALES_PERS INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SM.EVENT_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'"+appendSQL+"";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				eventDate = rs.getString("eventdate");
				docName = rs.getString("DoctorName");
				docNamewithImage = getImageStrfromName(docName);
				locality = rs.getString("LOCALITY");
				speciality = rs.getString("SPECIALITY");
				planHashMap = new  HashMap<String, ArrayList<String>>();
				if(finalMap!=null && finalMap.containsKey(eventDate))
				{
					planHashMap = finalMap.get(eventDate);
					docList = planHashMap.get("missed");
					//docList.add(docName+"@"+speciality+"@"+locality);
					docList.add(docNamewithImage+"@"+speciality+"@"+locality);
					planHashMap.put("plan", planHashMap.get("plan"));
					planHashMap.put("missed", docList);
					planHashMap.put("unplan", new ArrayList<String>());
					finalMap.put(eventDate, planHashMap);
				}
				else
				{
					docList = new ArrayList<String>();
					docList.add(docNamewithImage+"@"+speciality+"@"+locality);
					planHashMap.put("plan", planHashMap.get("plan"));
					planHashMap.put("missed", docList);
					planHashMap.put("unplan", new ArrayList<String>());
					finalMap.put(eventDate, planHashMap);
					
				}
			}
			System.out.println(" Planned doctors not visited :"+finalMap);
			
			rs = null;
			pstmt =null;
			docList = new ArrayList<String>();
			
			/*----------Unplanned doctors visited----Unplanned--------*/
			//sql="(select to_char(sm.event_date,'dd-mm-yy')  as eventdate ,sp.sales_pers ,sp.sp_name ,SM.STRG_CODE ,INITCAP(SC.first_name||' '||SC.middle_name||' '||SC.last_name )AS DoctorName ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY from sales_pers sp inner join strg_meet sm on sp.sales_pers=sm.sales_pers INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE where sm.event_date between '06-AUG-16' and '16-AUG-16' AND SM.SALES_PERS='M00005') minus (select to_char(SPH.PLAN_DATE,'dd-mm-yy')  as eventdate ,sp.sales_pers ,sp.sp_name ,spc.SC_CODE ,INITCAP(SC.first_name||' '||SC.middle_name||' '||SC.last_name )AS DoctorName ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY from sales_pers sp inner join sprs_plan_hdr sph on sp.sales_pers=sph.sprs_code__plan inner join sprs_plan_cust spc on sph.plan_id=spc.plan_id inner join STRG_CUSTOMER SC ON SC.SC_CODE=spc.SC_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SPH.PLAN_DATE between '06-AUG-16' and '16-AUG-16' AND SPRS_CODE__PLAN='M00005' and sp.sales_pers in (select emp_code from employee start with emp_code = (select emp_code from users where code='M00001') connect by prior emp_code = report_to) and sp.sales_pers in ('M00005'))";
			sql = "(SELECT TO_CHAR(SM.EVENT_DATE,'DD-MON-YYYY')  AS EVENTDATE ,SP.SALES_PERS ,SP.SP_NAME ,SM.STRG_CODE , INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME ,L.DESCR AS LOCALITY , SPL.DESCR AS SPECIALITY FROM SALES_PERS SP INNER JOIN STRG_MEET SM ON SP.SALES_PERS=SM.SALES_PERS INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SM.EVENT_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'"+appendSQL+" MINUS (SELECT TO_CHAR(SPH.PLAN_DATE,'DD-MON-YYYY')  AS EVENTDATE ,SP.SALES_PERS ,SP.SP_NAME ,SPC.SC_CODE , INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS=SPH.SPRS_CODE__PLAN INNER JOIN SPRS_PLAN_CUST SPC ON SPH.PLAN_ID=SPC.PLAN_ID INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SPC.SC_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SPH.PLAN_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'"+appendSQL+"";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				eventDate = rs.getString("eventdate");
				docName = rs.getString("DoctorName");
				docNamewithImage = getImageStrfromName(docName);
				locality = rs.getString("LOCALITY");
				speciality = rs.getString("SPECIALITY");
				planHashMap = new  HashMap<String, ArrayList<String>>();
				if(finalMap!=null && finalMap.containsKey(eventDate))
				{
					planHashMap = finalMap.get(eventDate);
					docList = planHashMap.get("unplan");
					//docList.add(docName+"@"+speciality+"@"+locality);
					docList.add(docNamewithImage+"@"+speciality+"@"+locality);
					planHashMap.put("plan", planHashMap.get("plan"));
					planHashMap.put("missed", planHashMap.get("missed"));
					planHashMap.put("unplan", docList);
					finalMap.put(eventDate, planHashMap);
				}
				else
				{
					docList = new ArrayList<String>();
					docList.add(docNamewithImage+"@"+speciality+"@"+locality);
					planHashMap.put("plan", planHashMap.get("plan"));
					planHashMap.put("missed", planHashMap.get("missed"));
					planHashMap.put("unplan", docList);
					finalMap.put(eventDate, planHashMap);
					
				}
			}
			System.out.println(" Unplanned doctors visited hashMap :"+finalMap);
			rs = null;
			pstmt =null;
			int count = 0;
			for (Map.Entry<String, HashMap<String, ArrayList<String>>> entry : finalMap.entrySet())
			{
				rawJson = new JSONObject();
				if((getDateString("", formatter)).equalsIgnoreCase(entry.getKey())){
					rawJson.put("eventdate", "Today");
				}
				else if((getDateString("yesterday", formatter)).equalsIgnoreCase(entry.getKey())){
					rawJson.put("eventdate", "Yesterday");
				}
				else{
					rawJson.put("eventdate", entry.getKey());
				}
				rawJson.put("category", entry.getValue());
				rawDataPlanDtlJson.put(count, rawJson);
				count++;
			}
			System.out.println("rawDataPlanDtlJson :"+rawDataPlanDtlJson);
			
	    } 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in PlanVsActual:getPlanVsActualTreeStructure()" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataPlanDtlJson;
	}
	
	private String getImageStrfromName(String doctorName) {
		String userImagePath    = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "resource" + File.separator + "images"+ File.separator + "users"+File.separator; 
		File file = new File(userImagePath+doctorName+".png");
		String retString = "";
		if(file.exists())
		{
			retString = "<img class='cardProdImg1' src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/"+doctorName+".png'/>";
		}else
		{
			doctorName = doctorName.trim();
			String[] splited = doctorName.split(" ");
			System.out.println("splited getImageStrfromName :"+splited[0].charAt(0));
			String defaultUserImg = ""+splited[0].charAt(0);
			
			if(splited.length>1)
			{
				String lastWord = doctorName.substring(doctorName.lastIndexOf(" ")+1);
				System.out.println("lastWord  getImageStrfromName :"+lastWord);
				defaultUserImg = defaultUserImg + ""+lastWord.charAt(0);
			}
			System.out.println("defaultUserImg :"+defaultUserImg);
			
			retString = "<div class='defaultUserImg1'> "+defaultUserImg+" </div>";
		}
		System.out.println("doctorName = "+doctorName+"retString ="+retString);
		retString = doctorName+"~"+retString;
		return retString;
	}

	/*----------Method for getting Todays Agenda--------*/
	@SuppressWarnings("unchecked")
	public JSONObject getTodayAgenda(String dataSourceName,String loginId,String salePersons) throws ITMException{
		JSONObject rawDataPlanDtlJson = new JSONObject();
		JSONObject rawJson = null;
		String sql = "", scCode = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String appendSQL = "";
		DashboardUtility dashboardUtility = null;
		SimpleDateFormat formatter = null;
		String fromDate ="",toDate = "",locality = "",prvlocality = "",doctorName = "";
		ArrayList<String> strgCodeList = null;
		try 
		{
			salePersons = salePersons == null ? "": salePersons.trim();
			dashboardUtility = new DashboardUtility();
			salePersons = dashboardUtility.getCommaSeparated(salePersons);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			formatter = new SimpleDateFormat("dd-MMM-yy");
			fromDate = getDateString("",formatter);
			toDate  = getDateString("",formatter);
			
			if("".equalsIgnoreCase(salePersons) && loginId != null){
				
				appendSQL = " AND SP.SALES_PERS IN (SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = (SELECT EMP_CODE FROM USERS WHERE CODE='"+loginId+"') connect by prior emp_code = report_to))";
			}
			else {
				appendSQL = " AND sp.sales_pers in("+salePersons+")) ";
			}
			
			sql = "(SELECT TO_CHAR(SPH.PLAN_DATE,'DD-MON-YYYY') AS EVENTDATE , SP.SALES_PERS , SP.SP_NAME , SPC.SC_CODE AS SC_CODE, INITCAP(SC.FIRST_NAME ||' ' ||SC.MIDDLE_NAME ||' ' ||SC.LAST_NAME )AS DOCTORNAME, L.DESCR         AS LOCALITY , SPL.DESCR       AS SPECIALITY FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS=SPH.SPRS_CODE__PLAN INNER JOIN SPRS_PLAN_CUST SPC ON SPH.PLAN_ID=SPC.PLAN_ID INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SPC.SC_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE    =SC.SC_CODE AND SS.SALES_PERS=SP.SALES_PERS INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SPH.PLAN_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'"+appendSQL+"";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();			
			int count = 0;
			String userImagePath    = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "resource" + File.separator + "images"+ File.separator + "users"+File.separator;
			strgCodeList = getStrgCodeList(dataSourceName, loginId, salePersons);
			
			while(rs.next())
			{
			    rawJson = new JSONObject();	
			    locality = rs.getString("LOCALITY");
			    doctorName = rs.getString("DOCTORNAME").trim();
			    scCode = rs.getString("SC_CODE").trim();
			    		
			    if(!locality.equalsIgnoreCase(prvlocality))
				{
			    	rawJson.put("locality", locality);
			    	rawJson.put("cardSalesPersonTitle", "cardSalesPersonTitle");
					System.out.println("locality :"+locality);
					prvlocality  = locality;
				}else
				{
					rawJson.put("locality", "");
				}
				
				File file = new File(userImagePath+doctorName+".png");
				if(file.exists())
				{
					rawJson.put("doctor_image", "<img class='cardProdImg1' src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/"+doctorName+".png'/>");
				}else
				{
					doctorName = doctorName.trim();
					String[] splited = doctorName.split(" ");
					System.out.println("splited getTodayAgenda :"+splited[0].charAt(0));
					String defaultUserImg = ""+splited[0].charAt(0);
					
					if(splited.length>1)
					{
						String lastWord = doctorName.substring(doctorName.lastIndexOf(" ")+1);
						System.out.println("lastWord  getTodayAgenda :"+lastWord);
						defaultUserImg = defaultUserImg + ""+lastWord.charAt(0);
					}
					System.out.println("defaultUserImg :"+defaultUserImg);
					
					rawJson.put("doctor_image", "<div class='defaultUserImg1'> "+defaultUserImg+" </div>");
				}
				
				rawJson.put("doctorName", doctorName);
				rawJson.put("time", "10:00 am");
				rawJson.put("speciality", rs.getString("SPECIALITY"));
				if(strgCodeList.contains(scCode)){
					//Changes done due to redirection of IP at client side
					//rawJson.put("meet_status", "<img class='cardProdImg1' src='"+CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/Tick-mark.png'/>");
					rawJson.put("meet_status", "<img class='cardProdImg1' src='/ibase/dwh/FusionChart/images/Tick-mark.png'/>");
				}
				else{
					rawJson.put("meet_status", "");
				}
				rawDataPlanDtlJson.put(count, rawJson);
				count++;
			}
			/*while(rs.next())
			{
				if(count == 0){
					
					rawJson.put("heading", "<table border='1' width='100%'> <tr> <td>Planning of "+rs.getString("SP_NAME")+"</td>  </tr> </table>");
					rawJson.put("tableHeader", "<table><tr><td style='text-align: left;'>Doctor Name</td><td style='text-align: left;'>Speciality</td><td style='text-align: left;'>Location</td></tr>");
					rawJson.put("doctorName", rs.getString("DoctorName"));
					rawJson.put("locality",   rs.getString("LOCALITY"));
					rawJson.put("speciality", rs.getString("SPECIALITY"));	
				}
				else{
					rawJson.put("heading", "");
					rawJson.put("tableHeader", "");
					rawJson.put("doctorName", rs.getString("DoctorName"));
					rawJson.put("locality",   rs.getString("LOCALITY"));
					rawJson.put("speciality", rs.getString("SPECIALITY"));
				}
				rawDataPlanDtlJson.put(count, rawJson);
				count++;
				
			}*/
			rs = null;
			pstmt =null;
			
	    } 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in PlanVsActual:getTodayAgenda()" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataPlanDtlJson;
	}

	public String getDateString(String dateCondition,SimpleDateFormat formatter ) {
        Calendar cal = Calendar.getInstance(); 
        
        if("firstDayOfWeek".equalsIgnoreCase(dateCondition)){
        	int currentDOW = cal.get(Calendar.DAY_OF_WEEK);
            cal.add(Calendar.DAY_OF_YEAR, (currentDOW * -1)+1);
        }
        if("yesterday".equalsIgnoreCase(dateCondition)){
        	cal.add(Calendar.DATE, -1);
        }
        if("lastDayOfWeek".equalsIgnoreCase(dateCondition)){
        	int currentDOW = cal.get(Calendar.DAY_OF_WEEK);
            cal.add(Calendar.DAY_OF_YEAR, (currentDOW * -1)+7);
        }
		return formatter.format(cal.getTime());
	}
	
	public ArrayList<String> getStrgCodeList(String dataSourceName,String loginId,String salePersons) throws ITMException{
		String todayDate = getDateString("",new SimpleDateFormat("dd-MMM-yy"));
		String appendSQL  = "",sql = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		ArrayList<String> strgCodeList = new ArrayList<String>();
		
		try {
			
			if(!salePersons.contains(",")){
				appendSQL = " AND SP.SALES_PERS IN (SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = (SELECT EMP_CODE FROM USERS WHERE CODE='"+loginId+"') connect by prior emp_code = report_to))";
			}
			else {
				appendSQL = " AND sp.sales_pers in("+salePersons+")) ";
			}
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			
			sql = "(SELECT TO_CHAR(SM.EVENT_DATE,'DD-MON-YYYY') AS EVENTDATE , SP.SALES_PERS ,SP.SP_NAME ,SM.STRG_CODE AS STRG_CODE,INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY  FROM SALES_PERS SP INNER JOIN STRG_MEET SM ON SP.SALES_PERS=SM.SALES_PERS INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SM.EVENT_DATE = '"+todayDate+"' "+appendSQL+" INTERSECT  (SELECT TO_CHAR(SPH.PLAN_DATE,'DD-MON-YYYY') AS EVENTDATE , SP.SALES_PERS , SP.SP_NAME ,SPC.SC_CODE ,INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME , L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY  FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS=SPH.SPRS_CODE__PLAN INNER JOIN SPRS_PLAN_CUST SPC ON SPH.PLAN_ID=SPC.PLAN_ID INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SPC.SC_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SPH.PLAN_DATE = '"+todayDate+"' "+appendSQL+"";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			String strg_code = "";
			
			while(rs.next())
			{
				strg_code = rs.getString("STRG_CODE");
				strg_code = strg_code == null ? "" : strg_code.trim();
				strgCodeList.add(strg_code);
			}
			rs = null;
			pstmt =null;
		} catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in PlanVsActual:getStrgCodeList()" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return strgCodeList;
	}
}
