package ibase.dashboard.mfg.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;

/**
 * Session Bean implementation class ProfitLossBalSheet
 */
@Stateless

public class MFGDashboard extends ValidatorEJB  implements MFGDashboardLocal, MFGDashboardRemote {

    /**
     * Default constructor. 
     */
	public MFGDashboard() 
    {    	
    }
    
   /* Dashboard name: Product wise delay production SUMMARY Pie Chart
    * Passing parameter :datasource,business_type ,facility code,selected_view,site_code,from date and toDate
    * develop date:25-jan-2017
    * function details: This is summary level dashboard depend on the facility code
    *  
    * (non-Javadoc)
    * @see ibase.dashboard.mfg.ejb.MFGDashboardLocal#getDelayProductionSumm(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
    */
    @SuppressWarnings("unchecked")
   	@Override
   	public JSONObject getDelayProductionSumm(String dataSourceName,String businessType,String facilityCode,String selectedView,String sessionSiteCode, String fromDate, String toDate) throws RemoteException, ITMException
    {
   		JSONObject rawDataMfgDelaySummJson = new JSONObject();
   		JSONObject rowData             = null;
   		ResultSet rs                   = null;
   		PreparedStatement pstmt        = null;
   		Connection conn                = null;
   		ConnDriver connDriver          = new ConnDriver();
   		String delayProductOrderWise   = "";
   		String delayProductValueWise   = "";
   		String delayProductQtyWise     = "";
   		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                   = null;
		String str_product_line = "";
   		try
   		{
   			
   			conn       = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;
   			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				  e12GenericUtility = new E12GenericUtility();
				  convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
				  calendar  = Calendar.getInstance();
				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
				  fromDate   = convertToDBDate.format(calendar.getTime());
				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
				  System.out.println("In facilityCode==="+facilityCode +"frmDate ====" + fromDate+" toDate==="+toDate);				
			  }
			else
			{
				e12GenericUtility = new E12GenericUtility();
				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd-MMM-yy");
				toDate   = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy", "dd-MMM-yy");
			}
			
   			if(businessType.length()>0)
			{
   				str_product_line = " and its.business_type ='"+businessType+"' ";
			}
   			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
   			{
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
   			}
   			
   			if (facilityCode!= null && facilityCode.trim().length()>0)
   			{
   				delayProductOrderWise =  "SELECT u.descr AS unit_form, COUNT(DISTINCT w.work_order)AS value FROM workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its WHERE r.work_order = w.work_order AND i.item_code = r.item_code AND t.item_type = i.item_type AND its.item_ser = i.item_ser AND u.unit = t.unit__form AND s.site_code = w.site_code AND (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 "+str_product_line+" AND s.facility_code = '"+facilityCode+"' AND to_date(r.conf_date) BETWEEN '"+fromDate+"' AND '"+toDate+"' GROUP BY u.descr " ;
				delayProductValueWise =  "SELECT u.descr AS unit_form, sum(fn_production_value(r.tran_id)) AS value FROM workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its WHERE r.work_order = w.work_order AND i.item_code = r.item_code AND t.item_type = i.item_type AND its.item_ser = i.item_ser AND u.unit = t.unit__form AND s.site_code = w.site_code AND (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 "+str_product_line+" AND s.facility_code = '"+facilityCode+"' AND to_date(r.conf_date) BETWEEN '"+fromDate+"' AND '"+toDate+"' GROUP BY u.descr ";
				delayProductQtyWise   =  "SELECT u.descr AS unit_form, sum(fn_qty_form(r.item_code,w.unit,t.unit__form, r.quantity)) AS value FROM workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its WHERE r.work_order = w.work_order AND i.item_code = r.item_code AND t.item_type = i.item_type AND its.item_ser = i.item_ser AND u.unit = t.unit__form AND s.site_code = w.site_code AND (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 "+str_product_line+" AND s.facility_code = '"+facilityCode+"' AND to_date(r.conf_date) BETWEEN '"+fromDate+"' AND '"+toDate+"' GROUP BY u.descr  ";
			}
   				
   	
   			if("Order".equalsIgnoreCase(selectedView))
   			{
   				System.out.println("in  order");
   				pstmt = conn.prepareStatement(delayProductOrderWise);
   			}
   			else if ("Quantity".equalsIgnoreCase(selectedView))
   			{
   				System.out.println("in  quantity");
   				pstmt = conn.prepareStatement(delayProductQtyWise);
   			}
   			else if ("Value".equalsIgnoreCase(selectedView))
   			{
   				System.out.println("in  value");
   				pstmt = conn.prepareStatement(delayProductValueWise);
   			}
   			rs = pstmt.executeQuery();
   			int count = 0;	
   			
   			while (rs.next())
   			{
   				if(!(rs.getString("value").equalsIgnoreCase("0")))
   	   			{
	   				rowData = new JSONObject();
	   				rowData.put("label",rs.getString("unit_form"));
	   				rowData.put("value",rs.getString("value"));	   				
	   				rawDataMfgDelaySummJson.put(count, rowData);
	   				count++;
   			    }
		    }
   			
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :MFGDashboard:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		return rawDataMfgDelaySummJson;
   	}
    
    /** Dashboard name: Product wise delay Days production BUBBLE CHART
     * Passing parameter :datasource,business_type ,facility code,selected_view,site_code,from date and toDate
     * develop date:02-Feb-2017
     * function details: This is summary level dashboard depend on the facility code
     *  
     * (non-Javadoc)
     * @see ibase.dashboard.mfg.ejb.MFGDashboardLocal#getDelayDaysProductionSumm(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
     **/
     @SuppressWarnings("unchecked")
    	@Override
    public JSONObject getDelayDaysProductionSumm(String dataSourceName,String businessType,String facilityCode,String selectedView,String sessionSiteCode, String fromDate, String toDate) throws RemoteException, ITMException
    {
    		JSONObject rawDataMfgDelayDaysSummJson = new JSONObject();
    		JSONObject rowData             = null;
    		ResultSet rs                   = null;
    		PreparedStatement pstmt        = null;
    		Connection conn                = null;
    		ConnDriver connDriver          = new ConnDriver();
    		String delayProductOrderWise   = "";
    		String delayProductValueWise   = "";
    		String delayProductQtyWise     = "";
    		E12GenericUtility e12GenericUtility = null;
    		SimpleDateFormat convertToDBDate    = null;
 		    Calendar calendar                   = null;
 		    String str_product_line = "";
 		    double orderValue_sum=0.0;
 		    String	delayProductOrderWise_sum =null;
 		    
    		try
    		{
    			
    			conn       = connDriver.getConnectDB(dataSourceName);
    			connDriver = null;
    			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
    			{ 				
 				  e12GenericUtility = new E12GenericUtility();
 				  convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
 				  calendar  = Calendar.getInstance();
 				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
 				  fromDate   = convertToDBDate.format(calendar.getTime());
 				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
 				  System.out.println("In facilityCode==="+facilityCode +"frmDate ====" + fromDate+" toDate==="+toDate);				
    			}
    			else
    			{
	 				e12GenericUtility = new E12GenericUtility();
	 				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd-MMM-yy");
	 				toDate   = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy", "dd-MMM-yy");
    			}
 			
    			if(businessType.length()>0)
    			{
    				str_product_line = " and its.business_type ='"+businessType+"' ";
    			}
    			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
    			{
    				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
    				System.out.println("facilityCode comming ,when facility code not pass as argument ="+facilityCode);				
    			}
    			
    			if (facilityCode!= null && facilityCode.trim().length()>0)
    			{
    				delayProductOrderWise_sum = "select u.descr AS unit_form, (to_date(r.conf_date) - to_date(w.due_date) + 1) as delaydays, count(distinct w.work_order) as no_of_order,sum(w.quantity * fn_pick_max_item_rate(w.item_code)) as value from workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its where r.work_order = w.work_order and i.item_code = r.item_code and t.item_type = i.item_type and its.item_ser = i.item_ser and u.unit = t.unit__form and s.site_code = w.site_code and (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0  "+str_product_line+"  and s.facility_code = '"+facilityCode+"' and to_date(r.conf_date) between '"+fromDate+"' AND '"+toDate+"' group by u.descr,(to_date(r.conf_date) - to_date(w.due_date) + 1)";
		   	    	delayProductOrderWise= "select u.descr AS unit_form, (to_date(r.conf_date) - to_date(w.due_date) + 1) as delaydays, count(distinct w.work_order) as no_of_order,sum(w.quantity * fn_pick_max_item_rate(w.item_code)) as value from workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its where r.work_order = w.work_order and i.item_code = r.item_code and t.item_type = i.item_type and its.item_ser = i.item_ser and u.unit = t.unit__form and s.site_code = w.site_code and (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0  "+str_product_line+"  and s.facility_code = '"+facilityCode+"' and to_date(r.conf_date) between '"+fromDate+"' AND '"+toDate+"' group by u.descr,(to_date(r.conf_date) - to_date(w.due_date) + 1)";
    		     //delayProductOrderWise   =  "SELECT u.descr AS unit_form, COUNT(DISTINCT w.work_order) AS no_of_order, (to_date(r.conf_date) - to_date(w.due_date) + 1) AS delaydays,  SUM(fn_pick_max_item_rate(i.item_code)) AS value FROM workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its WHERE r.work_order = w.work_order AND i.item_code = r.item_code AND t.item_type = i.item_type AND its.item_ser = i.item_ser AND u.unit = t.unit__form AND s.site_code = w.site_code AND (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 "+str_product_line+" AND s.facility_code = '"+facilityCode+"' AND to_date(r.conf_date) BETWEEN '"+fromDate+"' AND '"+toDate+"' GROUP BY u.descr,(to_date(r.conf_date) - to_date(w.due_date) + 1)";
    				delayProductValueWise =  "SELECT u.descr AS unit_form, sum(fn_production_value(r.tran_id)) AS value, (to_date(r.conf_date) - to_date(w.due_date)+1) AS delaydays FROM workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its WHERE r.work_order = w.work_order AND i.item_code = r.item_code AND t.item_type = i.item_type AND its.item_ser = i.item_ser AND u.unit = t.unit__form AND s.site_code = w.site_code AND (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 "+str_product_line+" AND s.facility_code = '"+facilityCode+"' AND to_date(r.conf_date) BETWEEN '"+fromDate+"' AND '"+toDate+"' GROUP BY u.descr,(to_date(r.conf_date) - to_date(w.due_date) + 1) ";
    				delayProductQtyWise   =  "SELECT u.descr AS unit_form, sum(fn_qty_form(r.item_code,w.unit,t.unit__form, r.quantity)) AS value, (to_date(r.conf_date) - to_date(w.due_date)+1) AS delaydays FROM workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its WHERE r.work_order = w.work_order AND i.item_code = r.item_code AND t.item_type = i.item_type AND its.item_ser = i.item_ser AND u.unit = t.unit__form AND s.site_code = w.site_code AND (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 "+str_product_line+" AND s.facility_code = '"+facilityCode+"' AND to_date(r.conf_date) BETWEEN '"+fromDate+"' AND '"+toDate+"' GROUP BY u.descr,(to_date(r.conf_date) - to_date(w.due_date) + 1)  ";
 				}
    			
    			if("Order".equalsIgnoreCase(selectedView))
    			{
    				System.out.println("in  order");
    				pstmt= conn.prepareStatement(delayProductOrderWise_sum);
       			    rs  = pstmt.executeQuery();
       			    
    	   			while (rs.next())
    	 			{
    	   				orderValue_sum = orderValue_sum+ Double.parseDouble(checkDouble(rs.getString("value")));
    	 			}			    
    	   			
    	   			pstmt.close();
    				pstmt = null;
    				rs.close();
    				rs   = null;	
    				pstmt = conn.prepareStatement(delayProductOrderWise);
    			}
    			
    			rs = pstmt.executeQuery();
    			int count = 0;	
    			while (rs.next())
    			{
    				rowData = new JSONObject();
    				rowData.put("label",rs.getString("unit_form"));
    				rowData.put("no_of_order",rs.getString("no_of_order"));
    				rowData.put("value",""+Math.round(Double.parseDouble(rs.getString("value"))/orderValue_sum*100)+"");
    				rowData.put("delaydays",rs.getString("delaydays"));    	
    				rawDataMfgDelayDaysSummJson.put(count, rowData);
    				count++;
    			}
    		}
    		catch (Exception e)
    		{
    			e.printStackTrace();
    			throw new ITMException(e);
    		}
    		finally
    		{
    			try
    			{
    				if (conn != null)
    				{
    					if (rs != null)
    					rs.close();
    					rs = null;
    					if (pstmt != null)
    					pstmt.close();
    					pstmt = null;
    					conn.close();
    					conn = null;
    				}
    				conn = null;
    			} catch (Exception d)
    			{
    				d.printStackTrace();
    				System.out.println("Exception in :MFGDashboard:" + d.getMessage());
    				throw new ITMException(d);
    			}
    		}
    		return rawDataMfgDelayDaysSummJson;
    }
     
    /* Dashboard name: Product site wise delay production DETAIL
     * Passing parameter :datasource,business_type ,facility code,selected_view, sessionSiteCode, fromDate and toDate
     * develop date:25-jan-2017
     * function details: This is detail level dashboard depend on the site code
     *  
     * (non-Javadoc)
     * @see ibase.dashboard.mfg.ejb.MFGDashboardLocal#getDelayProductionDet(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
     */
    @SuppressWarnings("unchecked")
   	@Override
   	public JSONObject getDelayProductionDet(String dataSourceName,String businessType,String facilityCode,String selectedView,String sessionSiteCode,String fromDate,String toDate) throws RemoteException, ITMException
    {
    	JSONObject rawDataMfgDelayDetJsonOuter = new JSONObject();
   		JSONObject rawDataMfgDelayDetJson      = new JSONObject();
   		JSONObject rowData             = null;   		
   		ResultSet rs                   = null;
   		PreparedStatement pstmt        = null;
   		Connection conn                = null;
   		ConnDriver connDriver          = new ConnDriver();   		
   		String delayProductOrderWise = "";
   		String delayProductValueWise = "";
   		String delayProductQtyWise   = "";
   		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                   = null;
		String str_product_line      ="";
   		try
   		{
   			conn       = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;	
   			 
   			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				  e12GenericUtility = new E12GenericUtility();
				  convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
				  calendar  = Calendar.getInstance();
				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
				  fromDate   = convertToDBDate.format(calendar.getTime());
				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
				  System.out.println("In facilityCode==="+facilityCode +"frmDate ====" + fromDate+" toDate==="+toDate);				
			}
			else
			{
				e12GenericUtility = new E12GenericUtility();
				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd-MMM-yy");
				toDate   = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy", "dd-MMM-yy");
			}
			
   			if(businessType.length()>0)
			{
   				str_product_line = " and its.business_type ='"+businessType+"' ";
			}
   			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
   			{
   				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
   			}
   		    System.out.println("Final Passing parameter into DelayProductionDetailGraph :"+selectedView +"Session site code=="+sessionSiteCode+"facility:"+facilityCode+"businessType:"+businessType +"from Date:"+fromDate+"to Date:"+toDate);
			
   			if (facilityCode!= null && facilityCode.trim().length()>0)
   			{
   				delayProductOrderWise =  "SELECT CASE WHEN s.abbrv_descr is null THEN s.sh_descr ELSE s.abbrv_descr END AS site_descr,w.site_code,u.descr AS unit_form, COUNT(DISTINCT w.work_order)AS value, sum((to_date(r.conf_date) - to_date(w.due_date) + 1))AS delaydays FROM workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its WHERE r.work_order = w.work_order AND i.item_code = r.item_code AND t.item_type = i.item_type AND its.item_ser = i.item_ser AND u.unit = t.unit__form AND s.site_code = w.site_code AND (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 "+str_product_line+" AND s.facility_code = '"+facilityCode+"' AND to_date(r.conf_date) BETWEEN '"+fromDate+"' AND '"+toDate+"' GROUP BY u.descr,w.site_code, s.abbrv_descr, s.sh_descr order by site_code " ;
				delayProductValueWise =  "SELECT CASE WHEN s.abbrv_descr is null THEN s.sh_descr ELSE s.abbrv_descr END AS site_descr,w.site_code,u.descr AS unit_form, sum(fn_production_value(r.tran_id)) AS value, sum( to_date(r.conf_date) - to_date(w.due_date)+1) AS delaydays FROM workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its WHERE r.work_order = w.work_order AND i.item_code = r.item_code AND t.item_type = i.item_type AND its.item_ser = i.item_ser AND u.unit = t.unit__form AND s.site_code = w.site_code AND (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 "+str_product_line+" AND s.facility_code = '"+facilityCode+"' AND to_date(r.conf_date) BETWEEN '"+fromDate+"' AND '"+toDate+"' GROUP BY u.descr,w.site_code, s.abbrv_descr, s.sh_descr order by site_code ";
				delayProductQtyWise   =  "SELECT CASE WHEN s.abbrv_descr is null THEN s.sh_descr ELSE s.abbrv_descr END AS site_descr,w.site_code,u.descr AS unit_form, sum(fn_qty_form(r.item_code,w.unit,t.unit__form, r.quantity)) AS value, sum(to_date(r.conf_date) - to_date(w.due_date)+1) AS delaydays FROM workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its WHERE r.work_order = w.work_order AND i.item_code = r.item_code AND t.item_type = i.item_type AND its.item_ser = i.item_ser AND u.unit = t.unit__form AND s.site_code = w.site_code AND (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 "+str_product_line+" AND s.facility_code = '"+facilityCode+"' AND to_date(r.conf_date) BETWEEN '"+fromDate+"' AND '"+toDate+"' GROUP BY u.descr,w.site_code, s.abbrv_descr, s.sh_descr order by site_code ";
			}
			
   			if("Order".equalsIgnoreCase(selectedView))
   			{
   				System.out.println("in Details  order");
   				pstmt = conn.prepareStatement(delayProductOrderWise);
   			}
   			else if ("Quantity".equalsIgnoreCase(selectedView))
   			{
   				System.out.println("in Details  quantity");
   				pstmt = conn.prepareStatement(delayProductQtyWise);
   			}
   			else if ("Value".equalsIgnoreCase(selectedView))
   			{
   				System.out.println("in Details value");
   				pstmt = conn.prepareStatement(delayProductValueWise);
   			}
   			rs = pstmt.executeQuery();
   			int count = 0;	
   			String siteDescr    = "";
   			String prvSiteDescr  = "";
   			while (rs.next())
   			{ 
   				siteDescr = rs.getString("site_descr");
   						
   				if(!siteDescr.equalsIgnoreCase(prvSiteDescr))
   				{
   					rawDataMfgDelayDetJson = new JSONObject();
   					rowData = new JSONObject();
   					count = 0;	
   					rowData.put("label", rs.getString("unit_form"));
   	   				rowData.put("value",rs.getString("value"));  	   				
   	   			    rawDataMfgDelayDetJson.put(count, rowData);
   	   				count++;
   	   				prvSiteDescr  = siteDescr;
   	   				rawDataMfgDelayDetJsonOuter.put(prvSiteDescr, rawDataMfgDelayDetJson);
   				}
   				else
   				{
   					rowData = new JSONObject();
   					rowData.put("label", rs.getString("unit_form"));
   	   				rowData.put("value",rs.getString("value"));
   	   			    rawDataMfgDelayDetJson.put(count, rowData);
   	   				count++;
   				}
   				
   			}
   			//rawDataMfgDelayDetJsonOuter.put(siteCode, rawDataMfgDelayDetJson);
   			System.out.println("rawDataMfgDelayDetJsonOuter :"+rawDataMfgDelayDetJsonOuter);
   		}	
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :MFGDashboard:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		return rawDataMfgDelayDetJsonOuter;
   		
   	}
    
    /* Dashboard name: PWD site wise order, quantity, value based order Grid view
     * Passing parameter :datasource,business_type ,facility code,selected_view,site_code,from date, toDate, siteCode, UnitForm
     * develop date:07-feb-2017
     * function details: This is summary level dashboard depend on the site code
     *  
     * (non-Javadoc)
     * @see ibase.dashboard.mfg.ejb.MFGDashboardLocal#getDelayProductionSumm(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
     */
     @SuppressWarnings("unchecked")
    	@Override
    public JSONObject getPWDSiteOrder(String dataSourceName,String businessType,String facilityCode,String selectedView,String sessionSiteCode, String fromDate, String toDate, String siteCode, String unitForm) throws RemoteException, ITMException
        {
    		JSONObject rawDataMfgSiteOrderJson = new JSONObject();
    		JSONObject rowData             = null;
    		ResultSet rs                   = null;
    		PreparedStatement pstmt        = null;
    		Connection conn                = null;
    		ConnDriver connDriver          = new ConnDriver();
    		String pwdSiteOrder_Value_Qty = "";
    		E12GenericUtility e12GenericUtility = null;
    		SimpleDateFormat convertToDBDate    = null;
 		    Calendar calendar                   = null;
 		    String str_product_line = "";
    		try
    		{
    			conn       = connDriver.getConnectDB(dataSourceName);
    			connDriver = null;
    			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
    			{ 				
 				  e12GenericUtility = new E12GenericUtility();
 				  convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
 				  calendar  = Calendar.getInstance();
 				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
 				  fromDate   = convertToDBDate.format(calendar.getTime());
 				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
 				  System.out.println("In facilityCode==="+facilityCode +"frmDate ====" + fromDate+" toDate==="+toDate);				
    			}
    			else
    			{
	 				e12GenericUtility = new E12GenericUtility();
	 				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd-MMM-yy");
	 				toDate   = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy", "dd-MMM-yy");
    			}
 			
    			if(businessType.length()>0)
    			{
    				str_product_line = " and its.business_type ='"+businessType+"' ";
    			}
    			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
    			{
    				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
    			}
    			
    			if (facilityCode!= null && facilityCode.trim().length()>0)
    			{
    				pwdSiteOrder_Value_Qty ="SELECT distinct w.site_code,w.work_order as order_no ,i.item_ser ," +
 						"its.descr as item_ser_descr,i.item_code,i.descr as item_descr ," +
 						"w.quantity,to_char(w.ord_date,'dd-MON-yy')as ord_date,to_char(w.due_date,'dd-MON-yy')as due_date," +
 						"to_char(r.conf_date,'dd-MON-yy')as conf_date,to_char(r.exp_date,'dd-MON-yy')as exp_date FROM workorder w, " +
 						"workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
 						"WHERE r.work_order = w.work_order AND i.item_code = r.item_code " +
 						"AND t.item_type = i.item_type AND its.item_ser = i.item_ser " +
 						"AND u.unit = t.unit__form AND trim(u.descr)='"+unitForm+"' AND s.site_code = w.site_code " +
 						//"AND w.site_code='"+siteCode+"' " +
 						"AND (s.abbrv_descr ='"+siteCode+"' OR s.sh_descr ='"+siteCode+"')"+
 						"AND (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 " +
 						"AND s.facility_code = '"+facilityCode+"' " +
 						"AND to_date(r.conf_date) BETWEEN '"+fromDate+"' AND '"+toDate+"' " +
 						"order by w.work_order ,i.item_code,i.descr";
 				}
    				
    			if("Order".equalsIgnoreCase(selectedView))
    			{
    				System.out.println("in  order");
    				pstmt = conn.prepareStatement(pwdSiteOrder_Value_Qty);
    			}
    			else if ("Quantity".equalsIgnoreCase(selectedView))
    			{
    				System.out.println("in  quantity");
    				pstmt = conn.prepareStatement(pwdSiteOrder_Value_Qty);
    			}
    			else if ("Value".equalsIgnoreCase(selectedView))
    			{
    				System.out.println("in  value");
    				pstmt = conn.prepareStatement(pwdSiteOrder_Value_Qty);
    			}
    			rs = pstmt.executeQuery();
    			int count = 0;	
    			
    			while (rs.next())
    			{
    				rowData = new JSONObject();
    				rowData.put("site_code", checkNull(rs.getString("site_code")));
    				rowData.put("order_no", checkNull(rs.getString("order_no")));
    				rowData.put("item_ser", checkNull(rs.getString("item_ser")));
    				rowData.put("item_ser_descr", checkNull(rs.getString("item_ser_descr")));
    				rowData.put("item_code", checkNull(rs.getString("item_code")));
    				rowData.put("item_descr", checkNull(rs.getString("item_descr")));
    				rowData.put("quantity", checkNull(rs.getString("quantity")));
    				rowData.put("ord_date", checkNull(rs.getString("ord_date")));
    				rowData.put("due_date", checkNull(rs.getString("due_date")));
    				rowData.put("conf_date", checkNull(rs.getString("conf_date")));
    				rowData.put("exp_date", checkNull(rs.getString("exp_date")));
 	   			    rawDataMfgSiteOrderJson.put(count, rowData);
 	   				count++;
    			}
    			System.out.println(" rawDataMfgSiteOrderJson is =" + rawDataMfgSiteOrderJson);
    		}
    		catch (Exception e)
    		{
    			e.printStackTrace();
    			throw new ITMException(e);
    		}
    		finally
    		{
    			try
    			{
    				if (conn != null)
    				{
    					if (rs != null)
    					rs.close();
    					rs = null;
    					if (pstmt != null)
    					pstmt.close();
    					pstmt = null;
    					conn.close();
    					conn = null;
    				}
    				conn = null;
    			} catch (Exception d)
    			{
    				d.printStackTrace();
    				System.out.println("Exception in :MFGDashboard:" + d.getMessage());
    				throw new ITMException(d);
    			}
    		}
    	return rawDataMfgSiteOrderJson;
    		
    }
    
    @SuppressWarnings("unchecked")
   	@Override
   	public JSONObject getProductDeviationSumm(String dataSourceName,String businessType,String facilityCode,String selectedView,String sessionSiteCode, String fromDate, String toDate) throws RemoteException, ITMException
    {
   		JSONObject rawDataJsonForDeviationSumm = null;
   		JSONObject rowData                 = null;   		            
   		ResultSet rs                       = null;
   		PreparedStatement pstmt            = null;
   		Connection conn                    = null;
   		ConnDriver connDriver              = new ConnDriver();   		
   		String sql                         = "";
   		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                   = null;
		String str_product_line				="";
		double percntVal                    = 0.0;
		double dashOffSet                  = 0.0;
    	try
   		 {
   			conn       = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;	
   			e12GenericUtility = new E12GenericUtility();			
			//System.out.println("getApplDateFormat()======="+"dd/MM/yyyy");
			//Add code of MTD for default on loading case
			
			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				  e12GenericUtility = new E12GenericUtility();
				  convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
				  calendar  = Calendar.getInstance();
				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
				  fromDate   = convertToDBDate.format(calendar.getTime());
				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
				  System.out.println("In facilityCode==="+facilityCode +"frmDate ====" + fromDate+" toDate==="+toDate);				
			}
			else
			{
				e12GenericUtility = new E12GenericUtility();
				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd-MMM-yy");
				toDate   = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy", "dd-MMM-yy");
			}
			
   			if(businessType.length()>0)
			{
   				str_product_line = " and its.business_type ='"+businessType+"' ";
			}
   			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
   			{
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
   			}
   				
		   //End the code of MTD format	
		    int value =0;
   			if("Order".equalsIgnoreCase(selectedView))
   			{
   				if (facilityCode!= null && facilityCode.trim().length()>0)
   	   			{
   					double totalOrder = 0.0;
	   				System.out.println("Excution of SQL"); 
	   				rawDataJsonForDeviationSumm =new JSONObject();
	   				
	   				sql =   "select count(distinct w.work_order) no_orders from workorder w, " +
							"workorder_iss iss, site s, item i, itemser its where iss.work_order = w.work_order " +
							"and s.site_code = w.site_code and i.item_code = w.item_code and its.item_ser = i.item_ser " +
							str_product_line+
							"and s.facility_code = '"+facilityCode+"' " +
							"and to_date(iss.conf_date) between '"+fromDate+"' and '"+toDate+"' ";
	   				
	   				pstmt= conn.prepareStatement(sql);
	   			    rs  = pstmt.executeQuery();
	   			    int count=0;
		   			if (rs.next())
		 			{
		   				totalOrder = Double.parseDouble(checkDouble(rs.getString("no_orders")));
		 			}			    
		   			
		   			pstmt.close();
					pstmt = null;
					rs.close();
					rs   = null;
	   				
	   				sql =   "select count(iss.work_order) no_issues from workorder w, " +
							"workorder_iss iss, site s, item i, itemser its where iss.work_order = w.work_order " +
							"and s.site_code = w.site_code and i.item_code = w.item_code and its.item_ser = i.item_ser " +
							str_product_line+
							"and iss.tran_type='D' and s.facility_code = '"+facilityCode+"' " +
							"and to_date(iss.conf_date) between '"+fromDate+"' and '"+toDate+"' ";
	   				
	   				pstmt= conn.prepareStatement(sql);
	   			    rs  = pstmt.executeQuery();
	   			    count=0;
		   			if (rs.next())
		 			{
		 				rowData = new JSONObject();
		 				value = Integer.parseInt(checkDouble(rs.getString("no_issues")));
		 				if(!(value==0))
		 				if(totalOrder==0){
		 					percntVal=0.0;
		 				}
		 				else{
		 					percntVal = value/totalOrder * 100.0D;
		 				}
		 				
		 				rowData.put("title","Deviation Issue");
		 				rowData.put("ordlabel"," Orders ");
		 				//rowData.put("no_of_orderlabel","  No. of Order");
		 				rowData.put("valuelabel","Issue");
		 				rowData.put("order",totalOrder);
		 				if(!(value==0))
		 				{
		 					rowData.put("value",value+" Deviation in");	 
		 				}
		 				else
		 				{
		 					rowData.put("value"," No deviation in ");
		 				}
		 				rowData.put("spanvalue", Math.round(percntVal) + "%");
		 				rowData.put("percentage", Long.valueOf(Math.round(percntVal)));
		 				rowData.put("dashOffSet", Double.valueOf(dashOffSet));
		 				rowData.put("tbldisplay", "style='display: visible'");
		 		        rowData.put("circledisplay", "c100");
		 		        rawDataJsonForDeviationSumm.put(count, rowData);
		 				 count++;
		 			}			    
		   			//End the Deviation issue task
		   			pstmt.close();
					pstmt = null;
					rs.close();
					rs   = null;
					
		   			sql =   "select count(distinct w.work_order) rework_orders from workorder w, site s, item i,workorder_iss iss, itemser its " +
							"where s.site_code = w.site_code and i.item_code = w.item_code and its.item_ser = i.item_ser " +
							"and w.ORDER_TYPE = 'R' " +
							str_product_line+      
							"and s.facility_code = '"+facilityCode+"' " +
							"and to_date(iss.conf_date) between '"+fromDate+"' and '"+toDate+"'  ";
	   				
					pstmt = conn.prepareStatement(sql);	
			   		rs    = pstmt.executeQuery();
			   		if (rs.next())
				 	{
		 				rowData = new JSONObject();		 				 
		 				value = Integer.parseInt(checkDouble(rs.getString("rework_orders")));			 				
		 				
		 				if(totalOrder==0){
		 					percntVal=0.0;
		 				}
		 				else{
		 					percntVal = value/totalOrder * 100.0D;
		 				}
		 				
		 				rowData.put("title","Rework Order");
		 				rowData.put("ordlabel"," Orders ");
		 				//rowData.put("no_of_orderlabel","  No. of Order");
		 				rowData.put("valuelabel","Rework");
		 				rowData.put("order",totalOrder);
		 				if(!(value==0))
		 				{
		 					rowData.put("value",value+" Rework in ");	 
		 				}
		 				else
		 				{
		 					rowData.put("value"," No rework in  ");
		 				}
		 				rowData.put("spanvalue", Math.round(percntVal) + "%");
		 				rowData.put("percentage", Long.valueOf(Math.round(percntVal)));
		 				rowData.put("dashOffSet", Double.valueOf(dashOffSet));
		 				rowData.put("tbldisplay", "style='display: visible'");
		 		        rowData.put("circledisplay", "c100");
		 		        rawDataJsonForDeviationSumm.put(count, rowData);
		 				count++;
				 	}
			   		pstmt.close();
					pstmt = null;
					rs.close();
					rs   = null;
						
					// yeild_loss
					sql = "select sum(i.receipt_quantity) receipt " +
					" ,sum(i.quantity) ordered,  " +
					" count(distinct o.work_order) as no_orders " + 
					" from ( " +
					" select w.work_order,w.quantity " +
					" ,sum(r.quantity) as receipt_quantity " + 
					" from workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
					" where r.work_order = w.work_order " +
					" and i.item_code = r.item_code " +
					" and t.item_type = i.item_type " +
					" and its.item_ser = i.item_ser " +
					" and u.unit = t.unit__form " +
					" and r.tran_type = 'F' " +
					" and s.site_code = w.site_code  and w.status='C' " +
					str_product_line+   
					" and s.facility_code = '"+facilityCode+"' " +
					" and to_date(r.conf_date) between '"+fromDate+"' and '"+toDate+"' " + 
					" group by w.work_order, w.quantity " +
					" having sum(r.quantity) < w.quantity " +
					" ) i, workorder o where o.work_order = i.work_order " +
					" and i.receipt_quantity < o.quantity " ;
					
					pstmt = conn.prepareStatement(sql);	
			   		rs    = pstmt.executeQuery();
			   		double receipt_loss = 0.0;
			   		double ordered_loss = 0.0;
			   		int no_of_order_loss = 0;
			   		
			   		if (rs.next())
			   		{
			   			receipt_loss = Double.parseDouble(checkDouble(rs.getString("receipt")));
	                    ordered_loss = Double.parseDouble(checkDouble(rs.getString("ordered")));
	                    no_of_order_loss = Integer.parseInt(checkDouble(rs.getString("no_orders")));
	                    
		 				
			 		}
		   			pstmt.close();
					pstmt = null;
					rs.close();
					rs   = null;					
					
						   			
					//Yeild_Gain
					sql = "select sum(i.receipt_quantity) receipt " +
							" ,sum(i.quantity) ordered,  " +
							" count(distinct o.work_order) as no_orders " + 
							" from ( " +
							" select w.work_order,w.quantity " +
							" ,sum(r.quantity) as receipt_quantity " + 
							" from workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
							" where r.work_order = w.work_order " +
							" and i.item_code = r.item_code " +
							" and t.item_type = i.item_type " +
							" and its.item_ser = i.item_ser " +
							" and u.unit = t.unit__form " +
							" and r.tran_type = 'F' " +
							" and s.site_code = w.site_code and w.status='C' " +
							str_product_line+   
							" and s.facility_code = '"+facilityCode+"' " +
							" and to_date(r.conf_date) between '"+fromDate+"' and '"+toDate+"' " + 
							" group by w.work_order, w.quantity " +
							" having sum(r.quantity) > w.quantity " +
							" ) i, workorder o where o.work_order = i.work_order " +
							" and i.receipt_quantity > o.quantity " ;
					
					pstmt = conn.prepareStatement(sql);	
			   		rs    = pstmt.executeQuery();
			   		double receipt_gain = 0.0;
			   		double ordered_gain = 0.0;
			   		int no_of_order_gain = 0;
			   		double totalReceipt = 0.0;
			   		double totalOrdered = 0.0;
			   		
			   		if (rs.next())
				 	{
		 				rowData = new JSONObject();
		 				receipt_gain = Double.parseDouble(checkDouble(rs.getString("receipt")));
	                    ordered_gain = Double.parseDouble(checkDouble(rs.getString("ordered")));
	                    no_of_order_gain = Integer.parseInt(checkDouble(rs.getString("no_orders")));
	                    totalReceipt = receipt_gain + receipt_loss;
	                    totalOrdered = ordered_gain + ordered_loss;
			 			if(totalOrdered==0)
			 			{
			 				percntVal=0.0;
			 			}
			 			else
			 			{
			 				percntVal = totalReceipt/totalOrdered * 100.0D;
			 			}
		 				rowData.put("title","Yeild");
		 				rowData.put("ordlabel","   ");
		 				rowData.put("valuelabel","Gain");
		 				
		 				rowData.put("receipt_gain",receipt_gain);
		 				rowData.put("ordered_gain",ordered_gain);
		 				rowData.put("no_of_order_gain",no_of_order_gain);
		 				rowData.put("receipt_loss",receipt_loss);
		 				rowData.put("ordered_loss",ordered_loss);
		 				rowData.put("no_of_order_loss",no_of_order_loss);
		 				
		 				
		 				rowData.put("order","-"+no_of_order_loss +" Orders ");
		 				rowData.put("value","+"+no_of_order_gain);
		 				rowData.put("spanvalue", Math.round(percntVal) + "%");
		 				rowData.put("percentage", Long.valueOf(Math.round(percntVal)));
		 				rowData.put("dashOffSet", Double.valueOf(dashOffSet));
		 				rowData.put("tbldisplay", "style='display: visible'");
		 		        rowData.put("circledisplay", "c100");
		 		        rawDataJsonForDeviationSumm.put(count, rowData);
		 				count++;
				 	}
		   			pstmt.close();
					pstmt = null;
					rs.close();
					rs   = null;   	   			
   	   			}   			
   			}
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :MFGDashboard:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		return rawDataJsonForDeviationSumm;
   	}
    
    @SuppressWarnings("unchecked")
   	@Override
   	public JSONObject getProductDeviationDet(String dataSourceName,String businessType,String facilityCode,String selectedView,String sessionSiteCode,String fromDate,String toDate) throws RemoteException, ITMException
    {
   		JSONObject rawDataJsonForDeviationDet = null;
   		JSONObject rowData                 = null;   		            
   		ResultSet rs                       = null;
   		PreparedStatement pstmt            = null;
   		Connection conn                    = null;
   		ConnDriver connDriver              = new ConnDriver();   		
   		String sql                         = "";
   		String str_product_line				= "";
   		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                   = null;
		double percntVal                    = 0.0;
		double dashOffSet                   = 0.0; 
		double totalNoOfOrder=0.0, devNoofOrder=0.0, reworkNoofOrder=0.0, reworkPercntVal=0.0, devPercntVal=0.0; 
		
		HashMap<String, String> noOfOrderMap=new HashMap<String, String>();
		HashMap<String, String> devIssueMap=new HashMap<String, String>();
		HashMap<String, String> reworkOrderMap=new HashMap<String, String>();
		HashMap<String, String> yeildGainMap=new HashMap<String, String>();
		HashMap<String, String> yeildLossMap=new HashMap<String, String>();
		try
  		 {
  			conn       = connDriver.getConnectDB(dataSourceName);
  			connDriver = null;	
  			e12GenericUtility = new E12GenericUtility();			
			System.out.println("getApplDateFormat()======="+"dd/MM/yyyy");
			//Add code of MTD for default on loading case
			
			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				  e12GenericUtility = new E12GenericUtility();
				  convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
				  calendar  = Calendar.getInstance();
				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
				  fromDate   = convertToDBDate.format(calendar.getTime());
				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
				  System.out.println("In facilityCode==="+facilityCode +"frmDate ====" + fromDate+" toDate==="+toDate);				
			}
			else
			{
				e12GenericUtility = new E12GenericUtility();
				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd-MMM-yy");
				toDate   = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy", "dd-MMM-yy");
			}
			
  			if(businessType.length()>0)
			{
  				str_product_line = " and its.business_type ='"+businessType+"' ";
			}
  			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
  			{
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
  			}
  				
		   //End the code of MTD format			
		    double order = 0.0D; 
		    double value = 0.0D;
  			if("Order".equalsIgnoreCase(selectedView))
  			{
  				if (facilityCode!= null && facilityCode.trim().length()>0)
  	   			{
  					double totalOrder = 0.0;
	   				System.out.println("Excution of SQL"); 
	   				rawDataJsonForDeviationDet =new JSONObject();
	   				
	   				sql =   "select CASE WHEN s.abbrv_descr IS NULL THEN s.sh_descr ELSE s.abbrv_descr" +
	   						" END AS site_descr,w.site_code,count(distinct w.work_order) no_orders from workorder w, " +
							"workorder_iss iss, site s, item i, itemser its where iss.work_order = w.work_order " +
							"and s.site_code = w.site_code and i.item_code = w.item_code and its.item_ser = i.item_ser " +
							str_product_line+
							"and s.facility_code = '"+facilityCode+"' " +
							"and to_date(iss.conf_date) between '"+fromDate+"' and '"+toDate+"' " +
									"GROUP BY w.site_code,s.abbrv_descr,s.sh_descr ";
	   				
	   				pstmt= conn.prepareStatement(sql);
	   			    rs  = pstmt.executeQuery();
	   			    int count=0;
		   			while(rs.next())
		 			{
		   				noOfOrderMap.put(rs.getString("site_code").trim()+"@"+rs.getString("site_descr").trim(), rs.getString("no_orders"));
		 			}			    
		   			
		   			pstmt.close();
					pstmt = null;
					rs.close();
					rs   = null;
	   				
	   				sql =   "select CASE WHEN s.abbrv_descr IS NULL THEN s.sh_descr ELSE s.abbrv_descr" +
	   						" END AS site_descr,w.site_code,count(iss.work_order) no_issues from workorder w, " +
							"workorder_iss iss, site s, item i, itemser its where iss.work_order = w.work_order " +
							"and s.site_code = w.site_code and i.item_code = w.item_code and its.item_ser = i.item_ser " +
							str_product_line+
							"and iss.tran_type='D' and s.facility_code = '"+facilityCode+"' " +
							"and to_date(iss.conf_date) between '"+fromDate+"' and '"+toDate+"' " +
									"GROUP BY w.site_code ,s.abbrv_descr,s.sh_descr";
	   				
	   				pstmt= conn.prepareStatement(sql);
	   			    rs  = pstmt.executeQuery();
	   			    count=0;
	   			    String siteCode     = "";
	    			String prvSitecode  = "";
	    			while(rs.next())
		 			{
	    				System.out.println("rs.getString('no_issues') :"+rs.getString("no_issues"));
	    				
	    				devIssueMap.put(rs.getString("site_descr").trim(), rs.getString("no_issues"));
	    				
		 			}			    
		   			//End the Deviation issue task
		   			pstmt.close();
					pstmt = null;
					rs.close();
					rs   = null;
					
		   			sql =   "select CASE WHEN s.abbrv_descr IS NULL THEN s.sh_descr ELSE s.abbrv_descr" +
	   						" END AS site_descr,w.site_code,count(distinct w.work_order) rework_orders from workorder w, site s, item i,workorder_iss iss, itemser its " +
							"where s.site_code = w.site_code and i.item_code = w.item_code and its.item_ser = i.item_ser " +
							"and w.ORDER_TYPE = 'R' " +
							str_product_line+      
							"and s.facility_code = '"+facilityCode+"' " +
							"and to_date(iss.conf_date) between '"+fromDate+"' and '"+toDate+"' " +
									"GROUP BY w.site_code ,s.abbrv_descr,s.sh_descr ";
	   				
			   		pstmt = conn.prepareStatement(sql);	
			   		rs    = pstmt.executeQuery();
			   		while(rs.next())
				 	{
			   			reworkOrderMap.put(rs.getString("site_descr").trim(), rs.getString("rework_orders"));
			   			
				 	}
			   		pstmt.close();
					pstmt = null;
					rs.close();
					rs   = null;
					
		   			
					// yeild_loss
					sql = "select site_descr,o.site_code,sum(i.receipt_quantity) receipt " +
					" ,sum(i.quantity) ordered,  " +
					" count(distinct o.work_order) as no_orders " + 
					" from ( " +
					" select CASE WHEN s.abbrv_descr IS NULL THEN s.sh_descr ELSE" +
					" s.abbrv_descr END AS site_descr,w.work_order,w.quantity " +
					" ,sum(r.quantity) as receipt_quantity " + 
					" from workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
					" where r.work_order = w.work_order " +
					" and i.item_code = r.item_code " +
					" and t.item_type = i.item_type " +
					" and its.item_ser = i.item_ser " +
					" and u.unit = t.unit__form " +
					" and r.tran_type = 'F' " +
					" and s.site_code = w.site_code and w.status='C'" +
					str_product_line+   
					" and s.facility_code = '"+facilityCode+"' " +
					" and to_date(r.conf_date) between '"+fromDate+"' and '"+toDate+"' " + 
					" group by w.work_order, w.quantity,s.abbrv_descr,s.sh_descr " +
					" having sum(r.quantity) < w.quantity " +
					" ) i, workorder o where o.work_order = i.work_order " +
					" and i.receipt_quantity < o.quantity group by o.site_code,site_descr" ;
					
					siteCode     = "";
	    			prvSitecode  = "";	
			   		pstmt = conn.prepareStatement(sql);	
			   		rs    = pstmt.executeQuery();
			   		
			   		while(rs.next())
			   		{
			   			yeildLossMap.put(rs.getString("site_descr").trim(), rs.getString("no_orders")+"@"+rs.getString("receipt")+"@"+rs.getString("ordered"));
			   		}
		   			pstmt.close();
					pstmt = null;
					rs.close();
					rs   = null;					
					
		   			
					//Yeild_Gain
					sql = "select site_descr,o.site_code,sum(i.receipt_quantity) receipt " +
							" ,sum(i.quantity) ordered,  " +
							" count(distinct o.work_order) as no_orders " + 
							" from ( " +
							" select CASE WHEN s.abbrv_descr IS NULL THEN s.sh_descr ELSE" +
							" s.abbrv_descr END AS site_descr,w.work_order,w.quantity " +
							" ,sum(r.quantity) as receipt_quantity " + 
							" from workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
							" where r.work_order = w.work_order " +
							" and i.item_code = r.item_code " +
							" and t.item_type = i.item_type " +
							" and its.item_ser = i.item_ser " +
							" and u.unit = t.unit__form " +
							" and r.tran_type = 'F' " +
							" and s.site_code = w.site_code and w.status='C' " +
							str_product_line+   
							" and s.facility_code = '"+facilityCode+"' " +
							" and to_date(r.conf_date) between '"+fromDate+"' and '"+toDate+"' " + 
							" group by w.work_order, w.quantity,s.abbrv_descr,s.sh_descr " +
							" having sum(r.quantity) > w.quantity " +
							" ) i, workorder o where o.work_order = i.work_order " +
							" and i.receipt_quantity > o.quantity group by o.site_code,site_descr" ;
					
					pstmt = conn.prepareStatement(sql);	
			   		rs    = pstmt.executeQuery();
			   		
			   		while(rs.next())
				 	{
			   			yeildGainMap.put(rs.getString("site_descr").trim(), rs.getString("no_orders")+"@"+rs.getString("receipt")+"@"+rs.getString("ordered"));
				 	}
		   			pstmt.close();
					pstmt = null;
					rs.close();
					rs   = null;
					
					System.out.println("noOfOrderMap: "+noOfOrderMap+"\n devIssueMap: "+devIssueMap+"\n reworkOrderMap: "+reworkOrderMap+"\n yeildGainMap: "+yeildGainMap+"\n yeildLossMap: "+yeildLossMap);
					
	  				count = 0;
	  				double yeildGainNoOrder = 0.0;
	  		   		double yeildGainReceipt = 0.0;
	  		   		double yeildGainOrder = 0.0;
	  				double yeildPercentage = 0.0;
	  				
	  				double yeildLossNoOrder = 0.0;
	  				double yeildLossReceipt = 0.0;
	  				double yeildLossOrder = 0.0;
	  				
	  				for (Map.Entry<String, String> entry : noOfOrderMap.entrySet())
	  				{
	  		   			String [] yeildLossArr = null;
	  		   			String [] yeildGainArr = null;
	  		   			
	  					yeildGainNoOrder = 0.0;
	  			   		yeildGainReceipt = 0.0;
	  			   		yeildGainOrder = 0.0;
	  					yeildPercentage = 0.0;
	  					
	  					yeildLossNoOrder = 0.0;
	  					yeildLossReceipt = 0.0;
	  					yeildLossOrder = 0.0;
	  		   			yeildPercentage = 0.0;
	  					String site_descr = entry.getKey();
	  					String siteDecArr[]=site_descr.split("@");
	  					rowData = new JSONObject();
	  					rowData.put("sitecode", siteDecArr[0]);
	  					rowData.put("sitedescr", siteDecArr[1]);
	  					String site_descr1=siteDecArr[1];
	  					String descrofdev = siteDecArr[1];
	  					System.out.println("site_code :"+siteDecArr[0]);
	  					System.out.println("sitedescr :"+siteDecArr[1]);
	  					
	  					rowData.put("nooforder",entry.getValue());
	  					
	  					
	  					totalNoOfOrder = Double.parseDouble(checkDouble(entry.getValue()));
	  					
	  					//System.out.println("totalNoOfOrder :"+totalNoOfOrder);
	  					
	  					devNoofOrder = Double.parseDouble(checkDouble(devIssueMap.get(site_descr1)));
	  					reworkNoofOrder = Double.parseDouble(checkDouble(reworkOrderMap.get(site_descr1)));
	  					
	  					String yeildLossStr = checkNull(yeildLossMap.get(site_descr1)).trim();
	  					String yeildGainStr = checkNull(yeildGainMap.get(site_descr1)).trim();
	  					System.out.println(" Sitedescr :"+site_descr1+" yeildLossStr" +yeildLossStr);
	  					System.out.println(" Sitedescr :"+site_descr1+" yeildGainStr" +yeildGainStr);
	  					
	  					if(yeildLossStr.length()>0)
	  					{
	  						//System.out.println("in if");
	  						yeildLossArr = yeildLossStr.split("@");
	  						
	  						yeildLossNoOrder = Double.parseDouble(yeildLossArr[0]);
	  						yeildLossReceipt = Double.parseDouble(yeildLossArr[1]);
	  						yeildLossOrder = Double.parseDouble(yeildLossArr[2]);
	  						
	  						
	  					}
	  					
	  					if(yeildGainStr.length()>0)
	  					{
	  						//System.out.println("in if");
	  						yeildGainArr = yeildGainStr.split("@");
	  						
	  						yeildGainNoOrder = Double.parseDouble(yeildGainArr[0]);
	  						yeildGainReceipt = Double.parseDouble(yeildGainArr[1]);
	  						yeildGainOrder = Double.parseDouble(yeildGainArr[2]);
	  						
	  						
	  					}
	  					yeildPercentage = ((yeildLossReceipt+yeildGainReceipt) / (yeildLossOrder+yeildGainOrder))*100; 
	  					
	  					System.out.println("yeildPercentage :"+yeildPercentage);
	  					
	  					
	  					//System.out.println("percntVal :"+devPercntVal);
	  					System.out.println("devIssueMap.get(site_code) :"+checkNull(devIssueMap.get(site_descr1)));
	  					if(checkNull(devIssueMap.get(site_descr1)).length()== 0)
	  					{
	  						rowData.put("deviatn_site", "No ");	
	  					}else{
	  						rowData.put("deviatn_site", devIssueMap.get(site_descr1));
	  					}
	  					if(checkNull(reworkOrderMap.get(site_descr1)).length()== 0)
	  					{
	  						rowData.put("rework_site", "No ");	
	  					}else{
	  						rowData.put("rework_site", reworkOrderMap.get(site_descr1));
	  					}
	  					rowData.put("gain", yeildGainNoOrder);
	  					rowData.put("loss", yeildLossNoOrder);
	  					rowData.put("receipt", yeildLossReceipt+yeildGainReceipt);
	  					rowData.put("orderd", yeildLossOrder+yeildGainOrder);
	  					rowData.put("circledisplay", "c100");
	  					rowData.put("fromDate", fromDate);
	  					rowData.put("toDate", toDate);
	  					rowData.put("facilityCode", facilityCode);
	  					descrofdev=descrofdev.replace(" ", "%20");
	  					System.out.println("descrofdev: "+descrofdev);
	  					rowData.put("descrofdev", descrofdev);
	  					if(devNoofOrder == 0)
	  					{
	  						devPercntVal=0.0;
	  					}
	  					else
	  					{
	  						devPercntVal = devNoofOrder/totalNoOfOrder * 100;
	  					}
	  					rowData.put("devpercentage", Long.valueOf(Math.round(devPercntVal)));
	  					
	  					
	  					
	  					if(reworkNoofOrder == 0)
	  					{
	  						reworkPercntVal=0.0;
	  					}
	  					else
	  					{
	  						reworkPercntVal = reworkNoofOrder/totalNoOfOrder * 100;
	  					}
	  					rowData.put("rewrkpercentage", Long.valueOf(Math.round(reworkPercntVal)));
	  					rowData.put("yeildpercentage", Long.valueOf(Math.round(yeildPercentage)));
	  					
	  					rawDataJsonForDeviationDet.put(count, rowData);
	  					
	  					count++;
	  				}
  	   			}  
  			}
  		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :MFGDashboard:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		return rawDataJsonForDeviationDet;
   	}
    
    @SuppressWarnings("unchecked")
   	@Override
   	public JSONObject getWtNGainLossSumm(String dataSourceName,String businessType,String facilityCode,String selectedView) throws RemoteException, ITMException
    {
   		JSONObject rawDataWtGainLossSummJson = new JSONObject();
   		JSONObject rowData = null;
   		ResultSet rs = null;
   		PreparedStatement pstmt = null;
   		Connection conn = null;
   		ConnDriver connDriver = new ConnDriver();
   		String delayProductOrderWise  = "";
   		String delayProductValueWise  = "";
   		String delayProductQtyWise    = "";
   		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                   = null;
		String fromDate = "";
		String toDate = "";
		
   		try
   		{
   			conn = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;	
   			
          //Add code of MTD for default on loading case
			
			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				  e12GenericUtility = new E12GenericUtility();
				  convertToDBDate   = new SimpleDateFormat("dd/MM/yyyy");
				  calendar  = Calendar.getInstance();
				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
				  fromDate   = convertToDBDate.format(calendar.getTime());
				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
				  System.out.println("In facilityCode==="+facilityCode +"frmDate ====" + fromDate+" toDate==="+toDate);				
			}
			else
			{
				e12GenericUtility = new E12GenericUtility();
				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd/MM/yyyy");
				toDate   = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy",  "dd/MM/yyyy");
			}
		   //End the code of MTD format
			delayProductOrderWise = "select u.descr as unit_form, count(distinct w.work_order) as value " +             //no_orders
   					"from workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
   					"where r.work_order = w.work_order and i.item_code = r.item_code " +
   					//"--and t.item_type = i.item_type " +
   					"and its.item_ser = i.item_ser " +
   					"and u.unit = t.unit__form and s.site_code = w.site_code " +
   					"and (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 " +
   					//"--and its.PRODUCT_LINE = ? --// optional " +
   					//"--and s.facility_code = ? " +
   					//"--and to_date(r.conf_date) between ? and ? " +
   					"group by u.descr ";
 
   			delayProductValueWise = "select u.descr as unit_form, 100 as value from workorder w, " +       //production_value
   					"workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
   					"where r.work_order = w.work_order and i.item_code = r.item_code " +
   					//"--and t.item_type = i.item_type 
   					"and its.item_ser = i.item_ser and u.unit = t.unit__form " +
   					"and s.site_code = w.site_code and (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 " +
   					//"--and its.PRODUCT_LINE = ? // optional " +
   					//"--and s.facility_code = ? " +
   					//"--and to_date(r.conf_date) between ? and ? " +
   					"group by u.descr ";
   	 
   			delayProductQtyWise = "select u.descr as unit_form, 400 as value from workorder w, " +     //quantity
   					"workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
   					"where r.work_order = w.work_order and i.item_code = r.item_code " +
   					//"--and t.item_type = i.item_type 
   					"and its.item_ser = i.item_ser and u.unit = t.unit__form " +
   					"and s.site_code = w.site_code and (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 " +
   					//"--and its.PRODUCT_LINE = ? // optional " +
   					//"--and s.facility_code = ? " +
   					//"--and to_date(r.conf_date) between ? and ? " +
   					"group by u.descr ";
   	 
   			/*live sql*/
   			
   			/*delayProductOrderWise = "select u.descr as unit_form, count(distinct w.work_order) as value " +             //no_orders
   					"from workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
   					"where r.work_order = w.work_order and i.item_code = r.item_code " +
   					"and t.item_type = t.item_type " +
   					"and its.item_ser = i.item_ser " +
   					"and u.unit = t.unit__form and s.site_code = w.site_code " +
   					"and (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 " +
   					"and its.PRODUCT_LINE = '"+businessType+"'  " +
   					"and s.facility_code = '"+facilityCode+"' " +
   					"and to_date(r.conf_date) between '"+fromDate+"' and '"+toDate+"' " +
   					"group by u.descr ";
 
   			delayProductValueWise = "select u.descr as unit_form, 100 as value from workorder w, " +       //production_value
   					"workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
   					"where r.work_order = w.work_order and i.item_code = r.item_code " +
   					"and t.item_type = t.item_type " +
   					"and its.item_ser = i.item_ser and u.unit = t.unit__form " +
   					"and s.site_code = w.site_code and (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 " +
   					"and its.PRODUCT_LINE = '"+businessType+"'  " +
   					"and s.facility_code = '"+facilityCode+"' " +
   					"and to_date(r.conf_date) between '"+fromDate+"' and '"+toDate+"' " +
   					"group by u.descr ";
   	 
   			delayProductQtyWise = "select u.descr as unit_form, 400 as value from workorder w, " +     //quantity
   					"workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
   					"where r.work_order = w.work_order and i.item_code = r.item_code " +
   					"and t.item_type = t.item_type " +
   					"and its.item_ser = i.item_ser and u.unit = t.unit__form " +
   					"and s.site_code = w.site_code and (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 " +
   					"and its.PRODUCT_LINE = '"+businessType+"'  " +
   					"and s.facility_code = '"+facilityCode+"' " +
   					"and to_date(r.conf_date) between '"+fromDate+"' and '"+toDate+"' " +
   					"group by u.descr ";*/
   			
   		    if("Order".equalsIgnoreCase(selectedView))
			{
				System.out.println("in  order");
				pstmt = conn.prepareStatement(delayProductOrderWise);
			}
			else if ("Quantity".equalsIgnoreCase(selectedView))
			{
				System.out.println("in  quantity");
				pstmt = conn.prepareStatement(delayProductQtyWise);
			}
			else if ("Value".equalsIgnoreCase(selectedView))
			{
				System.out.println("in  value");
				pstmt = conn.prepareStatement(delayProductValueWise);
			}
   			
   			rs = pstmt.executeQuery();
   			int count = 0;	
   			while (rs.next())
   			{
   				rowData = new JSONObject();
   				
   				rowData.put("label",rs.getString("unit_form"));
   				rowData.put("value",rs.getString("value"));
   				
   				/*rowData.put("yield_gain",rs.getString("YIELD_GAIN"));
   				rowData.put("no_orders",rs.getString("NO_ORDERS"));*/
   				rawDataWtGainLossSummJson.put(count, rowData);
   				count++;
   			}
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :MFGDashboard:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		return rawDataWtGainLossSummJson;
   		
   	}
 
    @SuppressWarnings("unchecked")
   	@Override
   	public JSONObject getWtNGainLossDet(String dataSourceName,String businessType,String facilityCode,String selectedView) throws RemoteException, ITMException
       {
    	JSONObject rawDataWtGainLossDetJsonOuter = new JSONObject();
   		JSONObject rawDataWtGainLossDetJson = new JSONObject();
   		JSONObject rowData = null;
   		ResultSet rs = null;
   		PreparedStatement pstmt = null;
   		Connection conn = null;
   		ConnDriver connDriver = new ConnDriver();
   		String delayProductOrderWise  = "";
   		String delayProductValueWise  = "";
   		String delayProductQtyWise    = "";
   		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                   = null;
		String fromDate = "";
		String toDate = "";
		
   		try
   		{
   			conn = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;	
   			
          //Add code of MTD for default on loading case
			
			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				  e12GenericUtility = new E12GenericUtility();
				  convertToDBDate   = new SimpleDateFormat("dd/MM/yyyy");
				  calendar  = Calendar.getInstance();
				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
				  fromDate   = convertToDBDate.format(calendar.getTime());
				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
				  System.out.println("In facilityCode==="+facilityCode +"frmDate ====" + fromDate+" toDate==="+toDate);				
			}
			else
			{
				e12GenericUtility = new E12GenericUtility();
				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd/MM/yyyy");
				toDate   = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy",  "dd/MM/yyyy");
			}
		   //End the code of MTD format
			delayProductOrderWise = "select w.site_code,u.descr as unit_form, count(distinct w.work_order) as value " +             //no_orders
   					"from workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
   					"where r.work_order = w.work_order and i.item_code = r.item_code " +
   					//"--and t.item_type = i.item_type " +
   					"and its.item_ser = i.item_ser " +
   					"and u.unit = t.unit__form and s.site_code = w.site_code " +
   					"and (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 " +
   					//"--and its.PRODUCT_LINE = ? --// optional " +
   					//"--and s.facility_code = ? " +
   					//"--and to_date(r.conf_date) between ? and ? " +
   					"group by u.descr ,w.site_code order by w.site_code ";
 
   			delayProductValueWise = "select w.site_code,u.descr as unit_form, 100 as value from workorder w, " +       //production_value
   					"workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
   					"where r.work_order = w.work_order and i.item_code = r.item_code " +
   					//"--and t.item_type = i.item_type 
   					"and its.item_ser = i.item_ser and u.unit = t.unit__form " +
   					"and s.site_code = w.site_code and (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 " +
   					//"--and its.PRODUCT_LINE = ? // optional " +
   					//"--and s.facility_code = ? " +
   					//"--and to_date(r.conf_date) between ? and ? " +
   					"group by u.descr ,w.site_code order by w.site_code ";
   	 
   			delayProductQtyWise = "select w.site_code,u.descr as unit_form, 400 as value from workorder w, " +     //quantity
   					"workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
   					"where r.work_order = w.work_order and i.item_code = r.item_code " +
   					//"--and t.item_type = i.item_type 
   					"and its.item_ser = i.item_ser and u.unit = t.unit__form " +
   					"and s.site_code = w.site_code and (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 " +
   					//"--and its.PRODUCT_LINE = ? // optional " +
   					//"--and s.facility_code = ? " +
   					//"--and to_date(r.conf_date) between ? and ? " +
   					"group by u.descr ,w.site_code order by w.site_code ";
   	 
   			/*live sql*/
   			
   			/*delayProductOrderWise = "select w.site_code,u.descr as unit_form, count(distinct w.work_order) as value " +             //no_orders
   					"from workorder w, workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
   					"where r.work_order = w.work_order and i.item_code = r.item_code " +
   					"and t.item_type = i.item_type " +
   					"and its.item_ser = i.item_ser " +
   					"and u.unit = t.unit__form and s.site_code = w.site_code " +
   					"and (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 " +
   					"and its.PRODUCT_LINE = '"+businessType+"'  " +
   					"and s.facility_code = '"+facilityCode+"' " +
   					"and to_date(r.conf_date) between '"+fromDate+"' and '"+toDate+"' " +
   					"group by u.descr ,w.site_code order by w.site_code ";
 
   			delayProductValueWise = "select w.site_code,u.descr as unit_form, 100 as value from workorder w, " +       //production_value
   					"workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
   					"where r.work_order = w.work_order and i.item_code = r.item_code " +
   					"and t.item_type = i.item_type " +
   					"and its.item_ser = i.item_ser and u.unit = t.unit__form " +
   					"and s.site_code = w.site_code and (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 " +
   					"and its.PRODUCT_LINE = '"+businessType+"'  " +
   					"and s.facility_code = '"+facilityCode+"' " +
   					"and to_date(r.conf_date) between '"+fromDate+"' and '"+toDate+"' " +
   					"group by u.descr ,w.site_code order by w.site_code ";
   	 
   			delayProductQtyWise = "select w.site_code,u.descr as unit_form, 400 as value from workorder w, " +     //quantity
   					"workorder_receipt r, item i, item_type t, uom u, site s, itemser its " +
   					"where r.work_order = w.work_order and i.item_code = r.item_code " +
   					"and t.item_type = i.item_type " +
   					"and its.item_ser = i.item_ser and u.unit = t.unit__form " +
   					"and s.site_code = w.site_code and (to_date(r.conf_date) - to_date(w.due_date) + 1) > 0 " +
   					"and its.PRODUCT_LINE = '"+businessType+"'  " +
   					"and s.facility_code = '"+facilityCode+"' " +
   					"and to_date(r.conf_date) between '"+fromDate+"' and '"+toDate+"' " +
   					"group by u.descr ,w.site_code order by w.site_code ";
   	 */
   			
 
   			if("Order".equalsIgnoreCase(selectedView))
   			{
   				System.out.println("in Details  order");
   				pstmt = conn.prepareStatement(delayProductOrderWise);
   			}
   			else if ("Quantity".equalsIgnoreCase(selectedView))
   			{
   				System.out.println("in Details  quantity");
   				pstmt = conn.prepareStatement(delayProductQtyWise);
   			}
   			else if ("Value".equalsIgnoreCase(selectedView))
   			{
   				System.out.println("in Details value");
   				pstmt = conn.prepareStatement(delayProductValueWise);
   			}
   			
   			
   			rs = pstmt.executeQuery();
   			int count = 0;	
   			String siteCode     = "";
   			String prvSitecode  = "";
   			while (rs.next())
   			{ 
   				siteCode = rs.getString("site_code");
   						
   				if(!siteCode.equalsIgnoreCase(prvSitecode))
   				{
   					rawDataWtGainLossDetJson = new JSONObject();
   					rowData = new JSONObject();
   					count = 0;	
   					rowData.put("label", rs.getString("unit_form"));
   	   				rowData.put("value",rs.getString("value"));  	   				
   	   			    rawDataWtGainLossDetJson.put(count, rowData);
   	   				count++;
   	   				prvSitecode  = siteCode;
   	   			    rawDataWtGainLossDetJsonOuter.put(prvSitecode, rawDataWtGainLossDetJson);
   				}
   				else
   				{
   					rowData = new JSONObject();
   					rowData.put("label", rs.getString("unit_form"));
   	   				rowData.put("value",rs.getString("value"));
   	   			    rawDataWtGainLossDetJson.put(count, rowData);
   	   				count++;
   				}
   			}
   			//rawDataMfgDelayDetJsonOuter.put(siteCode, rawDataMfgDelayDetJson);
   			System.out.println("rawDataWtGainLossDetJsonOuter :"+rawDataWtGainLossDetJsonOuter);
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :MFGDashboard:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		return rawDataWtGainLossDetJsonOuter;
   	}
 
    /* Dashboard name: Product wise delay production SUMMARY Stack Chart
     * Passing parameter :datasource,business_type ,facility code,selected_view,site_code,from date and toDate
     * develop date:25-jan-2017
     * function details: This is summary level dashboard depend on the facility code
     *  
     * (non-Javadoc)
     * @see ibase.dashboard.mfg.ejb.MFGDashboardLocal#getDelayProductionSumm(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
     */
    @SuppressWarnings("unchecked")
   	@Override
   	public JSONObject getProcessStageSumm(String dataSourceName,String businessType,String facilityCode,String selectedView, String sessionSiteCode, String fromDate, String toDate) throws RemoteException, ITMException
    {
   		JSONObject rawDataProcessStageSummJson = new JSONObject();
   		JSONObject rowData = null;
   		ResultSet rs = null;
   		PreparedStatement pstmt = null;
   		Connection conn = null;
   		ConnDriver connDriver = new ConnDriver();
   		String delayProductOrderWise  = "";
   		String delayProductValueWise  = "";
   		String delayProductQtyWise    = "";
   		String str_product_line       = "";
   		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                   = null;
		
		LinkedHashMap<String, String> catValues = null;
   		try
   		{
   			conn = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;

			//Added coding for adding as per default condition on 31-01-2017
   			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				  e12GenericUtility = new E12GenericUtility();
				  convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
				  calendar  = Calendar.getInstance();
				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
				  fromDate   = convertToDBDate.format(calendar.getTime());
				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
				  System.out.println("In facilityCode==="+facilityCode +"frmDate ====" + fromDate+" toDate==="+toDate);				
			}
			else
			{
				e12GenericUtility = new E12GenericUtility();
				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd-MMM-yy");
				toDate   = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy", "dd-MMM-yy");
			}
			
   			if(businessType.length()> 0)
			{
   				str_product_line = " and its.business_type ='"+businessType+"' ";
			}
   			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
   			{
				
   				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
   					
   			}
   			
   			if (facilityCode!= null && facilityCode.trim().length()>0)
   			{
   				delayProductOrderWise="select u.descr as product_form, p.descr as process_descr, " +
				"count(distinct f.work_order) no_order from workorder_feedback f, workorder w, " +
				"item i, item_type t, itemser its, procroute pr,process p, uom u, site s " +
				"where f.work_order = w.work_order and s.site_code = w.site_code " +
				"and i.item_code = w.item_code and t.item_type = i.item_type and u.unit = t.unit__form " +
				"and its.item_ser = i.item_ser " +
				//"and pr.route_code = w.route_code " +
				"and (select count(1) " +
				"from workorder_feedback fb where fb.work_order = w.work_order ) > 0 and " +
				"p.proc_code = pr.proc_code and pr.operation = f.operation and w.status = 'R' " +
				str_product_line+
				"and s.facility_code = '"+facilityCode+"' and to_date(w.status_date) between '"+fromDate+"' and '"+toDate+"' " +
				"group by u.descr, p.descr union all select u.descr as product_form, " +
				"'Others' as process_descr, count(distinct w.work_order) no_order from workorder w," +
				" item i, item_type t, itemser its, uom u, site s where s.site_code = w.site_code " +
				"and i.item_code = w.item_code and t.item_type = i.item_type and u.unit = t.unit__form" +
				" and its.item_ser = i.item_ser and (select count(1) from workorder_feedback fb where " +
				"fb.work_order = w.work_order ) = 0 and w.status = 'R' "+
				str_product_line+
				"and s.facility_code = '"+facilityCode+"' and to_date(w.status_date) between '"+fromDate+"' and '"+toDate+"' " +
				"group by u.descr, 'Others' order by 1,2";
			
		   		delayProductValueWise = "select u.descr as product_form, p.descr as process_descr, " +
				"sum(w.quantity * fn_pick_max_item_rate(w.item_code)) as no_order from workorder_feedback f, workorder w, " +
				"item i, item_type t, itemser its, procroute pr,process p, uom u, site s " +
				"where f.work_order = w.work_order and s.site_code = w.site_code " +
				"and i.item_code = w.item_code and t.item_type = i.item_type and u.unit = t.unit__form " +
				"and its.item_ser = i.item_ser " +
				//"and pr.route_code = w.route_code " +
				"and (select count(1) " +
				"from workorder_feedback fb where fb.work_order = w.work_order ) > 0 and " +
				"p.proc_code = pr.proc_code and pr.operation = f.operation and w.status = 'R' " +
				str_product_line+
				"and s.facility_code = '"+facilityCode+"' and to_date(w.status_date) between '"+fromDate+"' and '"+toDate+"' " +
				"group by u.descr, p.descr union all select u.descr as product_form, " +
				"'Others' as process_descr, count(distinct w.work_order) no_order from workorder w," +
				" item i, item_type t, itemser its, uom u, site s where s.site_code = w.site_code " +
				"and i.item_code = w.item_code and t.item_type = i.item_type and u.unit = t.unit__form" +
				" and its.item_ser = i.item_ser and (select count(1) from workorder_feedback fb where " +
				"fb.work_order = w.work_order ) = 0 and w.status = 'R' "+
				str_product_line+
				"and s.facility_code = '"+facilityCode+"' and to_date(w.status_date) between '"+fromDate+"' and '"+toDate+"' " +
				"group by u.descr, 'Others' order by 1,2";
		   	    
		   		delayProductQtyWise = "select u.descr as product_form, p.descr as process_descr, " +
				"sum(w.quantity)as no_order from workorder_feedback f, workorder w, " +
				"item i, item_type t, itemser its, procroute pr,process p, uom u, site s " +
				"where f.work_order = w.work_order and s.site_code = w.site_code " +
				"and i.item_code = w.item_code and t.item_type = i.item_type and u.unit = t.unit__form " +
				"and its.item_ser = i.item_ser " +
				//"and pr.route_code = w.route_code " +
				"and (select count(1) " +
				"from workorder_feedback fb where fb.work_order = w.work_order ) > 0 and " +
				"p.proc_code = pr.proc_code and pr.operation = f.operation and w.status = 'R' " +
				str_product_line+
				"and s.facility_code = '"+facilityCode+"' and to_date(w.status_date) between '"+fromDate+"' and '"+toDate+"' " +
				"group by u.descr, p.descr union all select u.descr as product_form, " +
				"'Others' as process_descr, count(distinct w.work_order) no_order from workorder w," +
				" item i, item_type t, itemser its, uom u, site s where s.site_code = w.site_code " +
				"and i.item_code = w.item_code and t.item_type = i.item_type and u.unit = t.unit__form" +
				" and its.item_ser = i.item_ser and (select count(1) from workorder_feedback fb where " +
				"fb.work_order = w.work_order ) = 0 and w.status = 'R' "+
				str_product_line+
				"and s.facility_code = '"+facilityCode+"' and to_date(w.status_date) between '"+fromDate+"' and '"+toDate+"' " +
				"group by u.descr, 'Others' order by 1,2"; 
   			}
			
			if("Order".equalsIgnoreCase(selectedView))
			{
				System.out.println("in  order");
				pstmt = conn.prepareStatement(delayProductOrderWise);
			}
			else if ("Quantity".equalsIgnoreCase(selectedView))
			{
				System.out.println("in  quantity");
				pstmt = conn.prepareStatement(delayProductQtyWise);
			}
			else if ("Value".equalsIgnoreCase(selectedView))
			{
				System.out.println("in  value");
				pstmt = conn.prepareStatement(delayProductValueWise);
			}  			
			rs = pstmt.executeQuery();
			int count = 0;
			/*String prevProcessDescr="";
			String processDescr="";
			String productForm = "";
			String noOfOrder = "";*/
			catValues = new  LinkedHashMap<String, String>();
			rowData = new JSONObject();
			
			
			List<String> productFormList= new ArrayList<String>();
			List<String> processDescrList= new ArrayList<String>();
			String productForm="",processDescr="";
			String key="";
			String noOfOrder="";
			LinkedHashMap<String, String> graphDataMap = new LinkedHashMap<String, String>(); 
	   		LinkedHashMap<String, String> sortedGraphDataMap = new LinkedHashMap<String, String>(); 
	   		
			while (rs.next())
			{
				processDescr = rs.getString("process_descr");
				productForm =  rs.getString("product_form");
				noOfOrder =  rs.getString("no_order");
				
				if(!productFormList.contains(productForm))
				{
					productFormList.add(productForm);
				}
				if(!processDescrList.contains(processDescr))
				{
					processDescrList.add(processDescr);
				}
				
				key = (productForm.trim()+"@"+processDescr.trim());
		        if(graphDataMap.size()==0)
		        {
		        	graphDataMap.put(key, (noOfOrder));
		        }
		        if(graphDataMap !=null && graphDataMap.size()>0)
		        {
		        	if(graphDataMap.containsKey(key))
		        	{
		        		noOfOrder = graphDataMap.get(key);
		        	}
		        	else  if(! graphDataMap.containsKey(key))
		        	{
		        		noOfOrder = noOfOrder;
		        	}
		        	graphDataMap.put(key, noOfOrder);
		        }
			}
			System.out.println("graphDataMap: "+graphDataMap);
			
			String prssDescr="";
			String grpKey="";
			for(int itmCtr=0;itmCtr<processDescrList.size();itmCtr++)
			{
				prssDescr = processDescrList.get(itmCtr);
				for (Map.Entry<String, String> grpentry : graphDataMap.entrySet())
				{
					for(int dayCtr=0;dayCtr<productFormList.size();dayCtr++)
					{
						grpKey = (productFormList.get(dayCtr).trim()+"@"+prssDescr.trim());
						if(graphDataMap.containsKey(grpKey))
						{
							sortedGraphDataMap.put(grpKey, graphDataMap.get(grpKey));
						}
						if(!graphDataMap.containsKey(grpKey) )
						{
							//sortedGraphDataMap.put(grpKey, "0");
							sortedGraphDataMap.put(grpKey, "");
						}
					}
				}
			}
			System.out.println("sortedGraphDataMap: "+sortedGraphDataMap);
			
			rowData = new JSONObject();
			String productFrm="";
			String processDescr1="",prvProcessDescr1="";
			catValues = new LinkedHashMap<String, String>();
			int cnt=0;
			for (Map.Entry<String, String> entry : sortedGraphDataMap.entrySet())
			{
				cnt++;
				String mapKey     = entry.getKey();
				String value  = entry.getValue();
				String[] temp = null;
				temp = mapKey.split("@");
				productFrm = temp[0].trim();
				processDescr1 = temp[1].trim();
				
				if( processDescr1 != null && ("").equals(prvProcessDescr1) && processDescr1.trim().length()>0)
				{
					catValues.put(productFrm,value);	
					rowData.put("unit_form",cnt);
					rowData.put("product_category",processDescr1);
					rowData.put("category_value",catValues);
				}
				else if(!("").equals(prvProcessDescr1) && prvProcessDescr1.equals(processDescr1))
				{
					catValues.put(productFrm,value);
				}
				else if(!("").equals(prvProcessDescr1) && ! prvProcessDescr1.equals(processDescr1))
				{
					rowData.put("unit_form",cnt);
					rowData.put("product_category",prvProcessDescr1);
					rowData.put("category_value",catValues);
					rawDataProcessStageSummJson.put(count, rowData);
					count++;
					rowData = new JSONObject();
					catValues = new LinkedHashMap<String, String>();
					catValues.put(productFrm,value);
				}
				if(cnt==sortedGraphDataMap.size())
				{
					rowData.put("unit_form",++cnt);
					rowData.put("product_category",processDescr1);
					rowData.put("category_value",catValues);
					rawDataProcessStageSummJson.put(count, rowData);
				}
				prvProcessDescr1=processDescr1;
			}
			
			
			System.out.println("************ rawDataProcessStageSummJson in EJB :"+rawDataProcessStageSummJson);
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :MFGDashboard:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		return rawDataProcessStageSummJson;
   	}
    
    /* Dashboard name: Process Stage site wise DETAIL
     * Passing parameter :datasource,business_type ,facility code,selected_view, sessionSiteCode, fromDate and toDate
     * develop date:25-jan-2017
     * function details: This is detail level dashboard depend on the site code
     *  
     * (non-Javadoc)
     * @see ibase.dashboard.mfg.ejb.MFGDashboardLocal#getDelayProductionDet(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
     */
    @SuppressWarnings("unchecked")
   	@Override
   	public JSONObject getProcessStageDet(String dataSourceName,String businessType,String facilityCode,String selectedView,String sessionSiteCode,String fromDate,String toDate) throws RemoteException, ITMException
       {
    	JSONObject rawDataProcessStageDetJsonOuter= new JSONObject();
    	JSONObject rawDataProcessStageDetJson = new JSONObject();
   		JSONObject rowData = null;
   		ResultSet rs = null;
   		PreparedStatement pstmt = null;
   		Connection conn = null;
   		ConnDriver connDriver = new ConnDriver();
   		String delayProductOrderWise  = "";
   		String delayProductValueWise  = "";
   		String delayProductQtyWise    = "";
   		String str_product_line       = "";
   		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                   = null;
		LinkedHashMap<String, String> catValues = null;
		
		try
   		{
   			conn = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;

			//Added coding for adding as per default condition on 31-01-2017
   			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				  e12GenericUtility = new E12GenericUtility();
				  convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
				  calendar  = Calendar.getInstance();
				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
				  fromDate   = convertToDBDate.format(calendar.getTime());
				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
				  System.out.println("In facilityCode==="+facilityCode +"frmDate ====" + fromDate+" toDate==="+toDate);				
			}
			else
			{
				e12GenericUtility = new E12GenericUtility();
				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd-MMM-yy");
				toDate   = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy", "dd-MMM-yy");
			}
			
   			if(businessType.length()> 0)
			{
   				str_product_line = " and its.business_type ='"+businessType+"' ";
			}
   			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
   			{
				
   				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
   					
   			}
   			// overwrite of facility code
   			
   			if (facilityCode!= null && facilityCode.trim().length()>0)
   			{
   				delayProductOrderWise="select * from(select w.site_code,CASE WHEN s.abbrv_descr is null THEN s.sh_descr" +
   				" ELSE s.abbrv_descr END AS site_descr,u.descr as product_form, p.descr as process_descr, " +
				"count(distinct f.work_order) no_order from workorder_feedback f, workorder w, " +
				"item i, item_type t, itemser its, procroute pr,process p, uom u, site s " +
				"where f.work_order = w.work_order and s.site_code = w.site_code " +
				"and i.item_code = w.item_code and t.item_type = i.item_type and u.unit = t.unit__form " +
				"and its.item_ser = i.item_ser " +
				//"and pr.route_code = w.route_code " +
				"and (select count(1) " +
				"from workorder_feedback fb where fb.work_order = w.work_order ) > 0 and " +
				"p.proc_code = pr.proc_code and pr.operation = f.operation and w.status = 'R' " +
				str_product_line+
				"and s.facility_code = '"+facilityCode+"' " +
				"and to_date(w.status_date) between '"+fromDate+"' and '"+toDate+"' " +
				"group by w.site_code,u.descr, p.descr, s.abbrv_descr, s.sh_descr union all " +
				"select w.site_code,CASE WHEN s.abbrv_descr is null THEN s.sh_descr"+
				" ELSE s.abbrv_descr END AS site_descr,u.descr as product_form, " +
				"'Others' as process_descr, count(distinct w.work_order) no_order from workorder w," +
				" item i, item_type t, itemser its, uom u, site s where s.site_code = w.site_code " +
				"and i.item_code = w.item_code and t.item_type = i.item_type and u.unit = t.unit__form" +
				" and its.item_ser = i.item_ser and (select count(1) from workorder_feedback fb where " +
				"fb.work_order = w.work_order ) = 0 and w.status = 'R' "+
				str_product_line+
				"and s.facility_code = '"+facilityCode+"' " +
				"and to_date(w.status_date) between '"+fromDate+"' and '"+toDate+"' " +
				"group by w.site_code,u.descr, s.abbrv_descr, s.sh_descr, s.abbrv_descr, s.sh_descr, 'Others')order by 3,4 ";
				
		   		delayProductValueWise = "select * from(select w.site_code,CASE WHEN s.abbrv_descr is null THEN s.sh_descr" +
   				" ELSE s.abbrv_descr END AS site_descr,u.descr as product_form, p.descr as process_descr, " +
				"sum(w.quantity * fn_pick_max_item_rate(w.item_code)) as no_order from workorder_feedback f, workorder w, " +
				"item i, item_type t, itemser its, procroute pr,process p, uom u, site s " +
				"where f.work_order = w.work_order and s.site_code = w.site_code " +
				"and i.item_code = w.item_code and t.item_type = i.item_type and u.unit = t.unit__form " +
				"and its.item_ser = i.item_ser " +
				//"and pr.route_code = w.route_code " +
				"and (select count(1) " +
				"from workorder_feedback fb where fb.work_order = w.work_order ) > 0 and " +
				"p.proc_code = pr.proc_code and pr.operation = f.operation and w.status = 'R' " +
				str_product_line+
				"and s.facility_code = '"+facilityCode+"' " +
				"and to_date(w.status_date) between '"+fromDate+"' and '"+toDate+"' " +
				"group by w.site_code,u.descr, p.descr, s.abbrv_descr, s.sh_descr union all " +
				"select w.site_code,CASE WHEN s.abbrv_descr is null THEN s.sh_descr" +
   				" ELSE s.abbrv_descr END AS site_descr,u.descr as product_form, " +
				"'Others' as process_descr, count(distinct w.work_order) no_order from workorder w," +
				" item i, item_type t, itemser its, uom u, site s where s.site_code = w.site_code " +
				"and i.item_code = w.item_code and t.item_type = i.item_type and u.unit = t.unit__form" +
				" and its.item_ser = i.item_ser and (select count(1) from workorder_feedback fb where " +
				"fb.work_order = w.work_order ) = 0 and w.status = 'R' "+
				str_product_line+
				"and s.facility_code = '"+facilityCode+"' " +
				"and to_date(w.status_date) between '"+fromDate+"' and '"+toDate+"' " +
				"group by w.site_code,u.descr, s.abbrv_descr, s.sh_descr, 'Others')order by 3,4 ";
		   	    
		   		delayProductQtyWise = "select * from(select w.site_code,CASE WHEN s.abbrv_descr is null THEN s.sh_descr" +
   				" ELSE s.abbrv_descr END AS site_descr,u.descr as product_form, p.descr as process_descr, " +
				"sum(w.quantity)as no_order from workorder_feedback f, workorder w, " +
				"item i, item_type t, itemser its, procroute pr,process p, uom u, site s " +
				"where f.work_order = w.work_order and s.site_code = w.site_code " +
				"and i.item_code = w.item_code and t.item_type = i.item_type and u.unit = t.unit__form " +
				"and its.item_ser = i.item_ser " +
				//"and pr.route_code = w.route_code " +
				"and (select count(1) " +
				"from workorder_feedback fb where fb.work_order = w.work_order ) > 0 and " +
				"p.proc_code = pr.proc_code and pr.operation = f.operation and w.status = 'R' " +
				str_product_line+
				"and s.facility_code = '"+facilityCode+"' " +
				"and to_date(w.status_date) between '"+fromDate+"' and '"+toDate+"' " +
				"group by w.site_code,u.descr, p.descr, s.abbrv_descr, s.sh_descr union all " +
				"select w.site_code,CASE WHEN s.abbrv_descr is null THEN s.sh_descr" +
   				" ELSE s.abbrv_descr END AS site_descr,u.descr as product_form, " +
				"'Others' as process_descr, count(distinct w.work_order) no_order from workorder w," +
				" item i, item_type t, itemser its, uom u, site s where s.site_code = w.site_code " +
				"and i.item_code = w.item_code and t.item_type = i.item_type and u.unit = t.unit__form" +
				" and its.item_ser = i.item_ser and (select count(1) from workorder_feedback fb where " +
				"fb.work_order = w.work_order ) = 0 and w.status = 'R' "+
				str_product_line+
				"and s.facility_code = '"+facilityCode+"' " +
				"and to_date(w.status_date) between '"+fromDate+"' and '"+toDate+"' " +
				"group by w.site_code,u.descr, s.abbrv_descr, s.sh_descr)order by 3,4 "; 
   			}
			
			if("Order".equalsIgnoreCase(selectedView))
			{
				System.out.println("in  order");
				pstmt = conn.prepareStatement(delayProductOrderWise);
			}
			else if ("Quantity".equalsIgnoreCase(selectedView))
			{
				System.out.println("in  quantity");
				pstmt = conn.prepareStatement(delayProductQtyWise);
			}
			else if ("Value".equalsIgnoreCase(selectedView))
			{
				System.out.println("in  value");
				pstmt = conn.prepareStatement(delayProductValueWise);
			}  			
			rs = pstmt.executeQuery();
			int count = 0;
			int cnt = 0;
			/*String prevProcessDescr="";
			String processDescr="";
			String productForm = "";
			String noOfOrder = "";
			String siteDescr     = "";
			String prvSiteDescr  = "";*/
			catValues = new  LinkedHashMap<String, String>();
			rowData = new JSONObject();
			
			
			List<String> productFormList= new ArrayList<String>();
			List<String> siteDescrList= new ArrayList<String>();
			List<String> processDescrList= new ArrayList<String>();
			String productForm="",processDescr="";
			String key="";
			String noOfOrder="";
			String siteDescr = "";
			LinkedHashMap<String, String> graphDataMap = new LinkedHashMap<String, String>(); 
	   		LinkedHashMap<String, String> sortedGraphDataMap = new LinkedHashMap<String, String>(); 
	   		LinkedHashMap<String, LinkedHashMap<String, String>> sortedGraphDataMapOuter = new LinkedHashMap<String, LinkedHashMap<String, String>>(); 
			while (rs.next())
			{
				
				processDescr = checkNull(rs.getString("process_descr")).trim();
				productForm =  checkNull(rs.getString("product_form")).trim();
				noOfOrder =  checkNull(rs.getString("no_order")).trim();
				siteDescr =  checkNull(rs.getString("site_descr")).trim();
				
				if(!productFormList.contains(productForm))
				{
					productFormList.add(productForm);
				}
				if(!processDescrList.contains(processDescr))
				{
					processDescrList.add(processDescr);
				}
				if(!siteDescrList.contains(siteDescr))
				{
					siteDescrList.add(siteDescr);
				}
				
				key = (productForm+"@"+processDescr+"@"+siteDescr);
				
		        if(graphDataMap.size()==0)
		        {
		        	graphDataMap.put(key, (noOfOrder));
		        }
		        if(graphDataMap !=null && graphDataMap.size()>0)
		        {
		        	if(graphDataMap.containsKey(key))
		        	{
		        		noOfOrder = graphDataMap.get(key);
		        	}
		        	graphDataMap.put(key, noOfOrder);
		        }
			}
			//System.out.println("siteDescrList for Detail Stack : "+siteDescrList);
			//System.out.println("processDescrList for Detail Stack : "+processDescrList);
			//System.out.println("productFormList for Detail Stack : "+productFormList);
			
			System.out.println("graphDataMap for Detail Stack : "+graphDataMap);
			
			String prssDescr="";
			String grpKey="";
			for(int siteCtr=0;siteCtr<siteDescrList.size();siteCtr++)
			{
				String site = siteDescrList.get(siteCtr);
				sortedGraphDataMap = new LinkedHashMap<String, String>();
				for(int itmCtr=0;itmCtr<processDescrList.size();itmCtr++)
				{
					prssDescr = processDescrList.get(itmCtr);
					for (Map.Entry<String, String> grpentry : graphDataMap.entrySet())
					{
						for(int dayCtr=0;dayCtr<productFormList.size();dayCtr++)
						{
							grpKey = (productFormList.get(dayCtr).trim()+"@"+prssDescr.trim()+"@"+site);
							if(graphDataMap.containsKey(grpKey))
							{
								sortedGraphDataMap.put(grpKey, graphDataMap.get(grpKey));
							}
							if(!graphDataMap.containsKey(grpKey) )
							{
								//sortedGraphDataMap.put(grpKey, "0");
								sortedGraphDataMap.put(grpKey, "");
							}
						}
					}
				}
				sortedGraphDataMapOuter.put(site, sortedGraphDataMap);
			}
			System.out.println("sortedGraphDataMapOuter: "+sortedGraphDataMapOuter);
			
			rowData = new JSONObject();
			String productFrm="";
			String processDescr1="",prvProcessDescr1="";
			catValues = new LinkedHashMap<String, String>();
			cnt=0;
			count = 0;
			//JSONObject rawDataProcessStageSummJson = new JSONObject();
			
			
			for (Map.Entry<String, LinkedHashMap<String, String>> entryOuter : sortedGraphDataMapOuter.entrySet())
			{
				rawDataProcessStageDetJson = new JSONObject();	
				cnt=0;
				count = 0;
				sortedGraphDataMap = new LinkedHashMap<String, String>();
				rowData = new JSONObject();
				productFrm="";
				processDescr1="";
				prvProcessDescr1="";
				catValues = new LinkedHashMap<String, String>();
				String siteDescrOuter = entryOuter.getKey();
				sortedGraphDataMap = entryOuter.getValue();
				System.out.println("------------------------------------------------------");
				System.out.println("siteDescrOuter :"+siteDescrOuter);
				System.out.println("sortedGraphDataMap :"+sortedGraphDataMap);
				for (Map.Entry<String, String> entry : sortedGraphDataMap.entrySet())
				{
					cnt++;
					String mapKey     = entry.getKey();
					String value  = entry.getValue();
					String[] temp = null;
					temp = mapKey.split("@");
					productFrm = temp[0].trim();
					processDescr1 = temp[1].trim();
					
					if( processDescr1 != null && ("").equals(prvProcessDescr1) && processDescr1.trim().length()>0)
					{
						catValues.put(productFrm,value);	
						rowData.put("unit_form",cnt);
						rowData.put("product_category",processDescr1);
						rowData.put("category_value",catValues);
					}
					else if(!("").equals(prvProcessDescr1) && prvProcessDescr1.equals(processDescr1))
					{
						catValues.put(productFrm,value);
					}
					else if(!("").equals(prvProcessDescr1) && ! prvProcessDescr1.equals(processDescr1))
					{
						rowData.put("unit_form",cnt);
						rowData.put("product_category",prvProcessDescr1);
						rowData.put("category_value",catValues);
						rawDataProcessStageDetJson.put(count, rowData);
						count++;
						rowData = new JSONObject();
						catValues = new LinkedHashMap<String, String>();
						catValues.put(productFrm,value);
					}
					if(cnt==sortedGraphDataMap.size())
					{
						//System.out.println("in if");
						rowData.put("unit_form",++cnt);
						rowData.put("product_category",processDescr1);
						rowData.put("category_value",catValues);
						rawDataProcessStageDetJson.put(count, rowData);
						
					}
					prvProcessDescr1=processDescr1;
				}
				//System.out.println("rawDataProcessStageDetJson: "+rawDataProcessStageDetJson);
				rawDataProcessStageDetJsonOuter.put(siteDescrOuter, rawDataProcessStageDetJson);
				
			}
			System.out.println("rawDataProcessStageSummJsonOuter: "+rawDataProcessStageDetJsonOuter);
			
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :MFGDashboard:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		
   		return rawDataProcessStageDetJsonOuter;
   	}
    
    /* Dashboard name: Process Stage site wise order, quantity, value based  Grid view
     * Passing parameter :datasource,business_type ,facility code,selected_view,site_code,from date, toDate, siteCode, UnitForm, process
     * develop date:07-feb-2017
     * function details: This is summary level dashboard depend on the site code
     *  
     * (non-Javadoc)
     * @see ibase.dashboard.mfg.ejb.MFGDashboardLocal#getDelayProductionSumm(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
     */
    @SuppressWarnings("unchecked")
   	@Override
   	public JSONObject getProcessStageSiteOrder(String dataSourceName,String businessType,String facilityCode,String selectedView, String sessionSiteCode, String fromDate, String toDate, String siteCode, String unitForm, String process) throws RemoteException, ITMException
    {
   		JSONObject rawDataProcessStageSiteOrderJson = new JSONObject();
   		JSONObject rowData = null;
   		ResultSet rs = null;
   		PreparedStatement pstmt = null;
   		Connection conn = null;
   		ConnDriver connDriver = new ConnDriver();
   		String delayProcessStageOrderWise  = "";
   		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                   = null;
		
		LinkedHashMap<String, String> catValues = null;
   		try
   		{
   			conn = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;

   			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				  e12GenericUtility = new E12GenericUtility();
				  convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
				  calendar  = Calendar.getInstance();
				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
				  fromDate   = convertToDBDate.format(calendar.getTime());
				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
				  System.out.println("In facilityCode==="+facilityCode +"frmDate ====" + fromDate+" toDate==="+toDate);				
			}
			else
			{
				e12GenericUtility = new E12GenericUtility();
				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd-MMM-yy");
				toDate   = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy", "dd-MMM-yy");
			}
			
   			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
   			{
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
   			}
   		   			
   			if (facilityCode!= null && facilityCode.trim().length()>0)
   			{
   				delayProcessStageOrderWise="select distinct w.site_code, p.descr as process_descr," +
   						"f.work_order as no_order,i.item_ser , its.descr as item_ser_descr,i.item_code," +
   						"i.descr as item_descr,w.quantity,to_char(w.ord_date,'dd-MON-yy')as ord_date,to_char(w.due_date,'dd-MON-yy')as due_date " +
   						"from workorder_feedback f, workorder w, item i, item_type t, itemser its, " +
   						"procroute pr,process p, uom u, site s where f.work_order = w.work_order " +
   						"and s.site_code = w.site_code and i.item_code = w.item_code " +
   						"and t.item_type = i.item_type and u.unit = t.unit__form " +
   						"and its.item_ser = i.item_ser and (select count(1) from workorder_feedback fb " +
   						"where fb.work_order = w.work_order ) > 0 and p.proc_code = pr.proc_code " +
   						"and pr.operation = f.operation and w.status = 'R' AND trim(u.descr)='"+unitForm+"' " +
   					//"AND w.site_code='"+siteCode+"' " +
						"AND (s.abbrv_descr ='"+siteCode+"' OR s.sh_descr ='"+siteCode+"')"+
   						"AND trim(p.descr) = '"+process+"' "+
   						"and to_date(w.status_date) between '"+fromDate+"' and '"+toDate+"' " +
   						"and s.facility_code = '"+facilityCode+"'  " +
   						"union all " +
   						"select w.site_code, 'Others' as process_descr, w.work_order as no_order ," +
   						"i.item_ser , its.descr as item_ser_descr,i.item_code,i.descr as item_descr," +
   						"w.quantity,to_char(w.ord_date,'dd-MON-yy')as ord_date,to_char(w.due_date,'dd-MON-yy')as due_date from workorder w, item i, item_type t, " +
   						"itemser its, uom u, site s where s.site_code = w.site_code " +
   						"and i.item_code = w.item_code and t.item_type = i.item_type " +
   						"and u.unit = t.unit__form and its.item_ser = i.item_ser and (select count(1) " +
   						"from workorder_feedback fb where fb.work_order = w.work_order ) = 0 " +
   						"and w.status = 'R' AND trim(u.descr)='"+unitForm+"' " +
   					//"AND w.site_code='"+siteCode+"' " +
						"AND (s.abbrv_descr ='"+siteCode+"' OR s.sh_descr ='"+siteCode+"')"+
   						"and to_date(w.status_date) between '"+fromDate+"' and '"+toDate+"' " +
   						"and s.facility_code = '"+facilityCode+"'";
   			}
				
			if("Order".equalsIgnoreCase(selectedView))
			{
				System.out.println("in  order");
				pstmt = conn.prepareStatement(delayProcessStageOrderWise);
			}
			else if ("Quantity".equalsIgnoreCase(selectedView))
			{
				System.out.println("in  quantity");
				pstmt = conn.prepareStatement(delayProcessStageOrderWise);
			}
			else if ("Value".equalsIgnoreCase(selectedView))
			{
				System.out.println("in  value");
				pstmt = conn.prepareStatement(delayProcessStageOrderWise);
			}
			rs = pstmt.executeQuery();
			int count = 0;
			
			catValues = new  LinkedHashMap<String, String>();
			rowData = new JSONObject();
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("site_code", checkNull(rs.getString("site_code")));
				rowData.put("process_descr", checkNull(rs.getString("process_descr")));
				rowData.put("no_order", checkNull(rs.getString("no_order")));
				rowData.put("item_ser", checkNull(rs.getString("item_ser")));
				rowData.put("item_ser_descr", checkNull(rs.getString("item_ser_descr")));
				rowData.put("item_code", checkNull(rs.getString("item_code")));
				rowData.put("item_descr", checkNull(rs.getString("item_descr")));
				rowData.put("quantity", checkNull(rs.getString("quantity")));
				rowData.put("ord_date", checkNull(rs.getString("ord_date")));
				rowData.put("due_date", checkNull(rs.getString("due_date")));
				rawDataProcessStageSiteOrderJson.put(count, rowData);
				count++;
			}
			System.out.println(" rawDataProcessStageSiteOrderJson is =" + rawDataProcessStageSiteOrderJson);
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :MFGDashboard:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		return rawDataProcessStageSiteOrderJson;
   	}
    
    
    @SuppressWarnings("unchecked")
	public JSONObject getProductDeviationWorkOrder(String dataSourceName,String businessType,String facilityCode,String selectedView, String sessionSiteCode, String fromDate, String toDate, String siteCode, String linkLable) throws RemoteException, ITMException
    {
    	JSONObject rawDataDeviationIssueOrderDetJson = new JSONObject();
   		JSONObject rowData = null;
   		ResultSet rs = null;
   		PreparedStatement pstmt = null;
   		Connection conn = null;
   		ConnDriver connDriver = new ConnDriver();
   		String devIssueReworkOrderWise  = "";
   		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                   = null;
		
		LinkedHashMap<String, String> catValues = null;
   		try
   		{
   			conn = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;

			//Added coding for adding as per default condition on 31-01-2017
   			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				  e12GenericUtility = new E12GenericUtility();
				  convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
				  calendar  = Calendar.getInstance();
				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
				  fromDate   = convertToDBDate.format(calendar.getTime());
				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
				  System.out.println("In facilityCode==="+facilityCode +"frmDate ====" + fromDate+" toDate==="+toDate);				
			}
						
   			
   			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
   			{
				
   				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
   					
   			}
   			// overwrite of facility code
   			
   			if (facilityCode!= null && facilityCode.trim().length()>0)
   			{
   				if(linkLable.equalsIgnoreCase("D"))
   				{
   					devIssueReworkOrderWise="SELECT w.site_code,iss.work_order ,w.item_code,i.descr," +
   						"w.quantity,to_char(w.ord_date,'dd-MON-yy')as ord_date,to_char(w.due_date,'dd-MON-yy')as due_date," +
   						"to_char(iss.conf_date,'dd-MON-yy')as conf_date,iss.confirmed " +
   						"FROM workorder w,  workorder_iss iss,  site s,  item i,  itemser its " +
   						"WHERE iss.work_order = w.work_order AND s.site_code = w.site_code " +
   						"AND i.item_code = w.item_code AND its.item_ser = i.item_ser " +
   						"AND iss.tran_type ='D' " +
   						//"AND s.facility_code = '"+facilityCode+"' " +
   						"AND w.site_code='"+siteCode+"' " +
						//"AND (s.abbrv_descr ='"+siteCode+"' OR s.sh_descr ='"+siteCode+"')"+
   						"AND to_date(iss.conf_date) BETWEEN '"+fromDate+"' AND '"+toDate+"' " +
   						"order  BY w.site_code,iss.work_order";
   				}
   				else
   				{
   					devIssueReworkOrderWise="SELECT w.site_code, w.work_order,w.item_code," +
   						"i.descr,w.quantity,to_char(w.ord_date,'dd-MON-yy')as ord_date,to_char(w.due_date,'dd-MON-yy')as due_date ," +
   						"to_char(iss.conf_date,'dd-MON-yy')as conf_date,iss.confirmed " +
   						"FROM workorder w,  site s,  item i,  workorder_iss iss,  itemser its " +
   						"WHERE s.site_code = w.site_code AND i.item_code = w.item_code AND " +
   						"its.item_ser = i.item_ser AND w.ORDER_TYPE = 'R' " +
   						//"AND s.facility_code = '"+facilityCode+"' " +
   						"AND w.site_code='"+siteCode+"' " +
						//"AND (s.abbrv_descr ='"+siteCode+"' OR s.sh_descr ='"+siteCode+"')"+
   						"AND to_date(iss.conf_date) BETWEEN '"+fromDate+"' AND '"+toDate+"' " +
   						"order  BY w.site_code";
   				}
   			}
				
				//Ended coding for adding as per default condition on 31-01-2017
   			if("Order".equalsIgnoreCase(selectedView))
			{
				System.out.println("in  order");
				pstmt = conn.prepareStatement(devIssueReworkOrderWise);
			}
			  			
			rs = pstmt.executeQuery();
			int count = 0;
			
			rowData = new JSONObject();
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("siteCode", checkNull(rs.getString("site_code")));
				rowData.put("work_order", checkNull(rs.getString("work_order")));
				rowData.put("item_code", checkNull(rs.getString("item_code")));
				rowData.put("descr", checkNull(rs.getString("descr")));
				rowData.put("quantity", checkNull(rs.getString("quantity")));
				rowData.put("ord_date", checkNull(rs.getString("ord_date")));
				rowData.put("due_date", checkNull(rs.getString("due_date")));
				rowData.put("conf_date", checkNull(rs.getString("conf_date")));
				rowData.put("confirmed", checkNull(rs.getString("confirmed")));
				
				rawDataDeviationIssueOrderDetJson.put(count, rowData);
				count++;
				
			}
			System.out.println(" rawDataDeviationIssueOrderDetJson is =" + rawDataDeviationIssueOrderDetJson);
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :MFGDashboard:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		return rawDataDeviationIssueOrderDetJson;
    }
	
    @SuppressWarnings("unchecked")
	public JSONObject getProductDevLossWorkOrder(String dataSourceName,String businessType,String facilityCode,String selectedView, String sessionSiteCode, String fromDate, String toDate, String siteCode) throws RemoteException, ITMException
	{
		JSONObject rawDataProductDevLossWorkJson = new JSONObject();
   		JSONObject rowData = null;
   		ResultSet rs = null;
   		PreparedStatement pstmt = null;
   		Connection conn = null;
   		ConnDriver connDriver = new ConnDriver();
   		String productLossWorkOrder   = "";
   		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                   = null;
		
		LinkedHashMap<String, String> catValues = null;
   		try
   		{
   			
   			conn = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;

			//Added coding for adding as per default condition on 31-01-2017
   			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				  e12GenericUtility = new E12GenericUtility();
				  convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
				  calendar  = Calendar.getInstance();
				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
				  fromDate   = convertToDBDate.format(calendar.getTime());
				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
				  System.out.println("In facilityCode==="+facilityCode +"frmDate ====" + fromDate+" toDate==="+toDate);				
			}
			
			
   			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
   			{
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
   			}
   			// overwrite of facility code
   			
   			if (facilityCode!= null && facilityCode.trim().length()>0)
   			{
   				productLossWorkOrder="SELECT w.work_order, w.quantity , SUM(r.quantity) AS receipt_quantity ," +
   						"w.site_code ,w.item_code ,to_char(w.ord_date,'dd-MON-yy')as ord_date,to_char(w.due_date,'dd-MON-yy')as due_date," +
   						"to_char(r.conf_date,'dd-MON-yy')as conf_date,r.confirmed,i.descr " +
   						"FROM workorder w, workorder_receipt r, item i, item_type t, uom u, site s, " +
   						"itemser its WHERE r.work_order  = w.work_order AND i.item_code = r.item_code " +
   						"AND t.item_type = i.item_type AND its.item_ser= i.item_ser and w.status='C' " +
   						"AND u.unit = t.unit__form AND r.tran_type = 'F' AND s.site_code = w.site_code " +
   						//"AND s.facility_code = '"+facilityCode+"' " +
   						"AND to_date(r.conf_date) BETWEEN '"+fromDate+"' AND '"+toDate+"' " +
   						"AND w.site_code='"+siteCode+"' " +
						//"AND (s.abbrv_descr ='"+siteCode+"' OR s.sh_descr ='"+siteCode+"')"+
   						"GROUP BY w.work_order, w.quantity,w.site_code,w.item_code," +
   						"w.ord_date,w.due_date,r.conf_date,r.confirmed,i.descr " +
   						"HAVING SUM(r.quantity) < w.quantity";
 
   			}
			
			System.out.println("in  order");
			pstmt = conn.prepareStatement(productLossWorkOrder);
					
			rs = pstmt.executeQuery();
			int count = 0;
			
			catValues = new  LinkedHashMap<String, String>();
			rowData = new JSONObject();
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("work_order", checkNull(rs.getString("work_order")));
				rowData.put("quantity", checkNull(rs.getString("quantity")));
				rowData.put("receipt_quantity", checkNull(rs.getString("receipt_quantity")));
				rowData.put("item_code", checkNull(rs.getString("item_code")));
				rowData.put("descr", checkNull(rs.getString("descr")));
				rowData.put("ord_date", checkNull(rs.getString("ord_date")));
				rowData.put("due_date", checkNull(rs.getString("due_date")));
				rowData.put("conf_date", checkNull(rs.getString("conf_date")));
				rowData.put("confirmed", checkNull(rs.getString("confirmed")));
				rawDataProductDevLossWorkJson.put(count, rowData);
				count++;
			}
			System.out.println(" rawDataProductDevLossWorkJson is =" + rawDataProductDevLossWorkJson);
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :MFGDashboard:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		return rawDataProductDevLossWorkJson;
	}
	
    @SuppressWarnings("unchecked")
	public JSONObject getProductDevGainWorkOrder(String dataSourceName,String businessType,String facilityCode,String selectedView, String sessionSiteCode, String fromDate, String toDate, String siteCode) throws RemoteException, ITMException
	{
		JSONObject rawDataProductDevGainWorkJson = new JSONObject();
   		JSONObject rowData = null;
   		ResultSet rs = null;
   		PreparedStatement pstmt = null;
   		Connection conn = null;
   		ConnDriver connDriver = new ConnDriver();
   		String productLossWorkOrder   = "";
   		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                   = null;
		
		LinkedHashMap<String, String> catValues = null;
   		try
   		{
   			
   			conn = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;

			//Added coding for adding as per default condition on 31-01-2017
   			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				  e12GenericUtility = new E12GenericUtility();
				  convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
				  calendar  = Calendar.getInstance();
				  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
				  fromDate   = convertToDBDate.format(calendar.getTime());
				  toDate     = convertToDBDate.format(Calendar.getInstance().getTime());
				  System.out.println("In facilityCode==="+facilityCode +"frmDate ====" + fromDate+" toDate==="+toDate);				
			}
			
			
   			if(facilityCode == null || ("".equalsIgnoreCase(facilityCode)))
   			{
				facilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
   			}
   			// overwrite of facility code
   			
   			if (facilityCode!= null && facilityCode.trim().length()>0)
   			{
   				productLossWorkOrder="SELECT w.work_order, w.quantity , SUM(r.quantity) AS receipt_quantity ," +
   						"w.site_code ,w.item_code ,to_char(w.ord_date,'dd-MON-yy')as ord_date,to_char(w.due_date,'dd-MON-yy')as due_date," +
   						"to_char(r.conf_date,'dd-MON-yy')as conf_date,r.confirmed,i.descr " +
   						"FROM workorder w, workorder_receipt r, item i, item_type t, uom u, site s, " +
   						"itemser its WHERE r.work_order  = w.work_order AND i.item_code = r.item_code " +
   						"AND t.item_type = i.item_type AND its.item_ser= i.item_ser and w.status='C' " +
   						"AND u.unit = t.unit__form AND r.tran_type = 'F' AND s.site_code = w.site_code " +
   						//"AND s.facility_code = '"+facilityCode+"' " +
   						"AND to_date(r.conf_date) BETWEEN '"+fromDate+"' AND '"+toDate+"' " +
   						"AND w.site_code='"+siteCode+"' " +
   						//"AND (s.abbrv_descr ='"+siteCode+"' OR s.sh_descr ='"+siteCode+"')"+
   						"GROUP BY w.work_order, w.quantity,w.site_code,w.item_code," +
   						"w.ord_date,w.due_date,r.conf_date,r.confirmed,i.descr " +
   						"HAVING SUM(r.quantity) > w.quantity";
 
   			}
			
			System.out.println("in  order");
			pstmt = conn.prepareStatement(productLossWorkOrder);
					
			rs = pstmt.executeQuery();
			int count = 0;
			
			catValues = new  LinkedHashMap<String, String>();
			rowData = new JSONObject();
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("work_order", checkNull(rs.getString("work_order")));
				rowData.put("quantity", checkNull(rs.getString("quantity")));
				rowData.put("receipt_quantity", checkNull(rs.getString("receipt_quantity")));
				rowData.put("item_code", checkNull(rs.getString("item_code")));
				rowData.put("descr", checkNull(rs.getString("descr")));
				rowData.put("ord_date", checkNull(rs.getString("ord_date")));
				rowData.put("due_date", checkNull(rs.getString("due_date")));
				rowData.put("conf_date", checkNull(rs.getString("conf_date")));
				rowData.put("confirmed", checkNull(rs.getString("confirmed")));
				rawDataProductDevGainWorkJson.put(count, rowData);
				count++;
			}
			System.out.println(" rawDataProductDevGainWorkJson is =" + rawDataProductDevGainWorkJson);
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :MFGDashboard:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		return rawDataProductDevGainWorkJson;
	}

    private String checkEmpty(String checkNull) 
    {
		// TODO Auto-generated method stub
		return null;
	}

	private String checkNull(String str)
   	{
   		if(str == null)
   		{
   			return "";
   		}
   		else
   		{
   			return str.trim();
   		}
   	} 	
   	
	private String checkDouble(String str)
   	{
   		if (str == null)
   		{
   			return "0";
   		} 
   		else
   		{
   			return str.trim();
   		}
   		
   	}
   	
	@SuppressWarnings("unused")
	private String getFacilityCode(String siteCode, String dataSourceName) throws  ITMException
	{
		String facilityCode = "";
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		try {
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			
			sql = "Select facility_code from site where site_code='"+siteCode+"'"; 
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				facilityCode = checkNull(rs.getString("facility_code")).trim();
			}
			
		} catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getFacilityCode:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return facilityCode;
	}
   	
}
