
//AUTHOR : SANA KHAN
// COMPONENET : EmpSeparationEJB
// DATE : 25/11/2015

package ibase.webitm.ejb.adm;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;

import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.rmi.RemoteException;

import org.w3c.dom.*;

import javax.ejb.Stateless;

/**
 * Session Bean implementation class EmpSeperationEJB
 */
@Stateless

public class EmpSeparationEJB extends ValidatorEJB implements EmpSeparationEJBRemote, EmpSeparationEJBLocal
{

    /**
     * Default constructor. 
     */
    public String wfValData() throws RemoteException , ITMException
    {
        
    	return "";
    }
    
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("EmpSeparationEJB:wfValData value of xmlString ["+xmlString+"]");
			System.out.println("EmpSeparationEJB:wfValData value of xmlString ["+xmlString1+"]");
			System.out.println("EmpSeparationEJB:wfValData value of xmlString ["+xmlString2+"]");
			
			if(xmlString != null && xmlString.trim().length()!=0)
		    {
				dom = genericUtility.parseString(xmlString);
			}
			
			if(xmlString1 != null && xmlString1.trim().length()!=0 )
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			
			if(xmlString2 != null && xmlString2.trim().length()!=0 )
			{
				dom1 = genericUtility.parseString(xmlString2);
			}
			
			errString = wfValData(dom , dom1 , dom2 , objContext , editFlag , xtraParams);
			System.out.println ("ErrString: " + errString);
    
		}
		catch(Exception e)
		{
			
			System.out.println ("Exception: EmpSeparationEJB: wfValData(String xmlString): " +e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			System.out.println ("Returning from EmpSeparationEJB wfValData");
			
		}
		  return errString;
	}
	
	
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0,currentFormNo =0,childNodeListLength =0,cnt =0;
		String childNodeName = null,childNodeValue = null;
		String errString = "";
		String errCode = "",errorCode="";
		String userId = ""; 		
		String stanCode="";
		String loginSite = "" , addTerm = "" , chgUser = "";
		String /*editFlg = "" */keyFlag = "" , tranDateStr = "";
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		
		java.util.Date joinDate = null;
		Connection conn = null;
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		String objNameDefault = "";
		String msgType = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		java.util.Date tranDate = new java.util.Date();
		java.util.Date resigDate = null;
		java.util.Date relieveDate = null;
	
		
		String sql = "", empCode = "" ;
		String resigDateStr = "" , wrkSite = "" ;
		String relieveDateStr = "" , sepModeDescr = "";
		String errFldName = "";
		AdmCommon admCommon = new AdmCommon() ;
		
		try 
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode"); 
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			
			GenericUtility genericUtility = GenericUtility.getInstance(); 			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());	
			SimpleDateFormat dbsdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			
			System.out.println("Value of edit Flag in wfvalData is :" + editFlag);
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println(" ***********Validation for EmpSeparation Detail  "+currentFormNo);
			switch(currentFormNo)
			{
				case 1 :
				{
					System.out.println("Validation for Detail 1 EmpSeparation..........");
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
				    childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					System.out.println("child Node List Length::::::"+childNodeListLength);
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{	
						
						childNode = childNodeList.item(ctr);
						System.out.println("childNode"+childNode);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}

						childNodeName = childNode.getNodeName();
						if(childNode.getFirstChild()!= null)
						{
							childNodeValue = childNode.getFirstChild().getNodeValue();
						}
						
						if(childNodeName.equalsIgnoreCase("tran_date"))
						{
							tranDateStr = genericUtility.getColumnValue ("tran_date",dom);
                            System.out.println("tran date is : " + tranDateStr);
							if(tranDateStr != null && tranDateStr.trim().length() > 0)
							{
								tranDate = sdf.parse(tranDateStr);
							}
							empCode = genericUtility.getColumnValue ("emp_code",dom);
							sql = "SELECT WORK_SITE FROM EMPLOYEE WHERE EMP_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, empCode);
							rs = pstmt.executeQuery();
							while (rs.next())
							{
								wrkSite = checkNull(rs.getString("WORK_SITE"));
								
							}
							close(pstmt, rs);
							errorCode = nfCheckPeriod("ADM",tranDate,wrkSite);
							
							if(errorCode != null && errorCode.trim().length() > 0)
							{
								System.out.println("Inside error code of tran_date");
								errList.add(errorCode);
								errFields.add( childNodeName.toLowerCase() );								
								msgType =  errorType( conn , errorCode );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						
						else if(childNodeName.equalsIgnoreCase("emp_code"))
						{
							System.out.println(" Validation   for field "+childNodeName);
							empCode = genericUtility.getColumnValue ("emp_code",dom);

							errorCode = "";
							if (empCode == null || empCode.trim().length() == 0)
							{
								errorCode = "VMEMP01";
							}
							else
							{
								System.out.println("EMPcode::::::["+empCode+"]");
								sql = "SELECT WORK_SITE FROM EMPLOYEE WHERE EMP_CODE = ?"; 
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, empCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									wrkSite = checkNull(rs.getString("WORK_SITE"));
									
								}
								else
								{
									errorCode = "VMEMP02";
								}
								close(pstmt, rs);
							}
							
							if(errorCode != null && errorCode.trim().length() > 0)
							{
								errList.add(errorCode);
								errFields.add( childNodeName.toLowerCase() );								
								msgType =  errorType( conn , errorCode );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							errorCode = "";
							resigDateStr = checkNull(genericUtility.getColumnValue("resi_date",dom));
							relieveDateStr = checkNull(genericUtility.getColumnValue("relieve_date",dom ));
                            System.out.println("Resignation date is : " + resigDateStr);

							if(resigDateStr == null || resigDateStr.trim().length() == 0)
							{
								errorCode = "VMDATENULL";
							}
							else
							{
								try
								{
									resigDate = sdf.parse(resigDateStr);
								}
								catch (Exception e0)
								{
									errorCode = "VTEMPSEP01";
								}
							}

							if(errorCode != null && errorCode.trim().length() > 0)
							{
								errList.add(errorCode);
								errFields.add( childNodeName.toLowerCase() );								
								msgType =  errorType( conn , errorCode );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}

							errorCode = "";
							
							errorCode = admCommon.gbfEmp(empCode,resigDate,wrkSite,loginSite,conn);
							
							if(errorCode != null && errorCode.trim().length() > 0)
							{
								System.out.println("Inside error code loop of emp_code");
								errList.add(errorCode);
								errFields.add( childNodeName.toLowerCase() );								
								msgType =  errorType( conn , errorCode );
								if ( msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}

							errorCode = "";
							if (editFlag.equalsIgnoreCase("A"))
							{
                                System.out.println("Inside editFlg of emp_code");
								int count = 0;
								sql = "SELECT COUNT(1) AS COUNT FROM SEPARATION WHERE EMP_CODE = ? AND STATUS <> 'X'"; 
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,empCode);
								rs = pstmt.executeQuery();								
								while(rs.next())
								{
									count = rs.getInt("COUNT");
								}
								close(pstmt , rs);
								System.out.println("value of count in emp_code:::: "+count);								
								
								if (count > 0)
								{
									errList.add("VTSEP1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn , "VTSEP1");
									if ( msgType.equalsIgnoreCase("E"))
									{
										break ;
									}
								
								}
							
							}
						}
						
						else if(childNodeName.equalsIgnoreCase("resi_date"))
						{
							errorCode = "";
							System.out.println(" Validation   for field "+childNodeName);
							resigDateStr = genericUtility.getColumnValue ("resi_date",dom);  
							relieveDateStr = genericUtility.getColumnValue("relieve_date", dom);
							
							if (resigDateStr == null || resigDateStr.trim().length() == 0)
							{
								errorCode = "VMDATENULL";
								errList.add ("VMDATENULL");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn , "VMDATENULL");
								if ( msgType.equalsIgnoreCase("E"))
								{
									break ;
								}
								errorCode = "";
							}
							else
							{    
								try
								{
									resigDate = sdf.parse(resigDateStr);
								}
								catch (Exception e1)
								{
									errorCode = "VTEMPSEP01";
									errList.add(errorCode);
									errFields.add( childNodeName.toLowerCase() );
									msgType =  errorType( conn , errorCode );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
									errorCode = "";
								}
								if(relieveDateStr == null || relieveDateStr.trim().length()== 0)
								{
									errorCode = "VMDATENULL";
									errList.add(errorCode);
									errFields.add( childNodeName.toLowerCase() );
									msgType =  errorType( conn , errorCode );
									if ( msgType.equalsIgnoreCase("E"))
									{
										break;
									}
									errorCode = "";
								}
								else
								{    
									try
									{
										relieveDate = sdf.parse(relieveDateStr);
									}
									catch (Exception e2)
									{
										errorCode = "VTEMPSEP02";
										errList.add(errorCode);
										errFields.add( childNodeName.toLowerCase() );
										msgType =  errorType( conn , errorCode );
										if ( msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									errorCode = "";
								}
								
								System.out.println("resigDate in val loop of resi_date is" + resigDateStr);
								System.out.println("relieveDate in val loop of resigDate is " +relieveDateStr);
                                if(resigDate != null && relieveDate != null )
                                {
									if (resigDate.after(relieveDate))
									{
										errList.add ("VMDT1");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn , "VMDT1");
										if ( msgType.equalsIgnoreCase("E"))
										{
											break ;
										}	
									}
                                }
							}
						}
						else if(childNodeName.equalsIgnoreCase("relieve_date"))
						{
							System.out.println(" Validation   for field "+childNodeName);
							relieveDateStr = genericUtility.getColumnValue("relieve_date", dom);
							if(relieveDateStr == null || relieveDateStr.trim().length() == 0)
							{
								errList.add ("VMDATENULL");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn , "VMDATENULL");
								if ( msgType.equalsIgnoreCase("E"))
								{
									break ;
								}
							
							}
						}
						else if(childNodeName.equalsIgnoreCase("separation_mode"))
						{
							System.out.println(" Validation   for field "+childNodeName);
							String sepMode = genericUtility.getColumnValue ("separation_mode",dom);
	
							if(sepMode == null || sepMode.trim().length() == 0)
							{
								errList.add ("VTSEPMOD01");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn , "VTSEPMOD01");
								if ( msgType.equalsIgnoreCase("E"))
								{
									break ;
								}
							}
							else
							{
								sql = "SELECT FN_GET_DESCR_GENCODES('SEPARATION_MODE' , 'W_EMP_SEPARATION' , ?) AS SEPMODE_DESCR FROM DUAL";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, sepMode);
								rs = pstmt.executeQuery();
								while(rs.next())
								{
									sepModeDescr = checkNull(rs.getString("SEPMODE_DESCR"));
								}
								close(pstmt , rs);
								if(sepModeDescr == null || sepModeDescr.trim().length() == 0)
								{
									errList.add("VTSEPMOD02");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn , "VTSEPMOD02");
									if ( msgType.equalsIgnoreCase("E"))
									{
										break; 
									}										
								}									
							}								
						}
					}	
					
					
				}break;
			}
			if ( errList != null && errList.size() > 0 )
			{
				int errListSize = errList.size();
				System.out.println("errListSize:::::::["+errListSize+"]");
				System.out.println("in error::::::::::");
				for (int i = 0; i < errListSize; i++ )
				{
					System.out.println("in error For:::::::::::::::"); 
					errCode = (String)errList.get(i);
					errFldName = (String)errFields.get(i);
					System.out.println("errCode .........."+errCode);					
					errString = getErrorString( errFldName, errCode, userId );
					System.out.println("errString is : ::::>>>> " + errString);
					msgType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( msgType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;				
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			errString = errStringXml.toString();
			
		
		}
		
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally 
		{
			try {
				
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
					if (conn != null)
					{
						conn.close();
						conn = null;
					}

			} 
			catch (Exception e)
			{
				e.printStackTrace();				
			}
		}
		
		return errString;
	}
	
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("EmpSeparationEJB:itemChanged value of xmlString ["+xmlString+"]");
			System.out.println("EmpSeparationEJB:itemChanged value of xmlString ["+xmlString1+"]");
			System.out.println("EmpSeparationEJB:itemChanged value of xmlString ["+xmlString2+"]");
			System.out.println("objContext ..:: ["+objContext+"]");
			System.out.println("currentColumn ..:: ["+currentColumn+"]");
			System.out.println("editFlag ..:: ["+editFlag+"]");

			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception : EmployeeSeparation :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from itemChanged");
		return errString;
	 }

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		
		
		int currentFormNo = 0;
		StringBuffer valueXmlString = null;
		//NodeList parentNodeList = null;
		//NodeList childNodeList = null;
		//Node parentNode = null;
		//Node childNode = null;
	//	String columnValue = "";
		//String childNodeName = null,childNodeValue = null;
		//int ctr=0,childNodeListLength =0,cnt =0;
		String sql = "",editFlg="",loginSite="" , objNameDefault = "" , errString = null;
		String sepMode = "" ,sepModeDescr = "";
		String empCode = "";
		String fname = "" , lname = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = null;
		int noticePrd = 0 , noticeDays = 0 ;
		String resigDateStr = "" , relieveDateStr = "" , noticePrdStr = "" , currDateStr = "";
		//java.util.Date chgDate = null;
		String chgDateStr="";
		String addTerm = "" , chgUser = "";
		
		
		
		
		System.out.println("Value of edit Flag in itemchanged is :" + editFlag);
		
		try
		{
			if (objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			GenericUtility genericUtility = GenericUtility.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());	
			//SimpleDateFormat dbsdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			
			java.util.Date currDate = new java.util.Date();
			currDateStr = sdf.format(currDate);	
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "logincode");
			addTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			chgDateStr = sdf.format(currDate);
		
			//java.util.Date resigDate = null;
			//java.util.Date relieveDate = null;
		
					
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
		

			objNameDefault  = checkNull(getObjName(dom ,"1"));
			System.out.println("objNameDefault ..:: ["+objNameDefault+"]");
			
			switch (currentFormNo)
			{
				case 1:	
				{
					valueXmlString.append("<Detail1 domID='1' dbID='' objContext='1' objName='"+objNameDefault+"' selected='Y'>\r\n");
					if(currentColumn.equalsIgnoreCase("itm_default"))
					{
						System.out.println("ItemChange of:::::"+currentColumn);	
						
						valueXmlString.append("<resi_date>").append("<![CDATA[" + currDateStr + "]]>").append("</resi_date>");
						valueXmlString.append("<separation_mode>").append("<![CDATA[R]]>").append("</separation_mode>");
						valueXmlString.append("<chg_date>").append("<![CDATA[" + chgDateStr + "]]>").append("</chg_date>");
						valueXmlString.append("<chg_term>").append("<![CDATA[" + addTerm + "]]>").append("</chg_term>");
						valueXmlString.append("<chg_user>").append("<![CDATA[" + chgUser + "]]>").append("</chg_user>");
						
						sql = "SELECT FN_GET_DESCR_GENCODES('SEPARATION_MODE' , 'W_EMP_SEPARATION' , ?) AS SEPMODE_DESCR FROM DUAL ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, "R");
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							sepModeDescr = checkNull(rs.getString("SEPMODE_DESCR"));
						
						}
						
						close(pstmt,rs);
					 	valueXmlString.append("<sepmode_descr>").append("<![CDATA[" + sepModeDescr + "]]>").append("</sepmode_descr>");
				}
				
				else if(currentColumn.equalsIgnoreCase("emp_code"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);	
					empCode = genericUtility.getColumnValue ("emp_code",dom);
					resigDateStr = genericUtility.getColumnValue ("resi_date",dom);
         
					sql = "SELECT EMP_LNAME, EMP_FNAME , NOTICE_PRD FROM EMPLOYEE WHERE EMP_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						lname = checkNull(rs.getString("EMP_LNAME"));
						fname = checkNull(rs.getString("EMP_FNAME"));
						noticePrd = rs.getInt("NOTICE_PRD");
					}
					close(pstmt , rs);
					
					
					if(noticePrd > 0)
					{
						noticeDays = noticePrd * 30 ;
					}
					if(empCode != null && empCode.trim().length() > 0)
					{
						valueXmlString.append("<emp_lname>").append("<![CDATA[" + lname + "]]>").append("</emp_lname>");
						valueXmlString.append("<emp_fname>").append("<![CDATA[" + fname + "]]>").append("</emp_fname>");
						valueXmlString.append("<notice_prd>").append("<![CDATA[" + noticePrd + "]]>").append("</notice_prd>");
			
						System.out.println("resigDateStr in empCode is" + resigDateStr );
						
						relieveDateStr = getRelativeDateStr(resigDateStr , noticeDays);
						System.out.println("relieve date returned from getRelativeDateStr is" + relieveDateStr );
						valueXmlString.append("<relieve_date>").append("<![CDATA[" + relieveDateStr + "]]>").append("</relieve_date>");
					}
					else
					{
						valueXmlString.append("<relieve_date>").append("<![CDATA[]]>").append("</relieve_date>");
						valueXmlString.append("<emp_lname>").append("<![CDATA[]]>").append("</emp_lname>");
						valueXmlString.append("<emp_fname>").append("<![CDATA[]]>").append("</emp_fname>");
						valueXmlString.append("<notice_prd>").append("<![CDATA[]]>").append("</notice_prd>");
					}
					
				}
				
				else if(currentColumn.equalsIgnoreCase("resi_date"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);	
					empCode = checkNull(genericUtility.getColumnValue("emp_code" , dom));
					resigDateStr = checkNull(genericUtility.getColumnValue("resi_date", dom));
					noticePrdStr=	checkNull(genericUtility.getColumnValue("notice_prd", dom));
					
					if(noticePrdStr != null && noticePrdStr.trim().length() > 0 )
					{
						try
						{
							noticePrd=Integer.parseInt(noticePrdStr);
						}
						catch (Exception e3)
						{
							noticePrd = 0;
						}
						if(noticePrd != 0 && noticePrd > 0)
						{
							noticeDays = noticePrd * 30; 
						}
					}
					if(resigDateStr != null && resigDateStr.trim().length() > 0)
					{
						
							valueXmlString.append("<resi_date>").append("<![CDATA[" + resigDateStr + "]]>").append("</resi_date>");
							System.out.println("resigDateStr in resi_date is" + resigDateStr );
						
							relieveDateStr = getRelativeDateStr( resigDateStr ,  noticeDays);
							System.out.println("relieve date returned from getRelativeDateStr is" + relieveDateStr );
	     
	                        valueXmlString.append("<relieve_date>").append("<![CDATA[" + relieveDateStr + "]]>").append("</relieve_date>");
					}
					else
					{
						valueXmlString.append("<relieve_date>").append("<![CDATA[]]>").append("</relieve_date>");
					}
				}
				
				else if(currentColumn.equalsIgnoreCase("separation_mode"))
				{
					System.out.println("ItemChange of:::::"+currentColumn);	
					sepMode = checkNull(genericUtility.getColumnValue ("separation_mode",dom));
					valueXmlString.append("<separation_mode>").append("<![CDATA[" + sepMode + "]]>").append("</separation_mode>");
					sql = "SELECT FN_GET_DESCR_GENCODES('SEPARATION_MODE' , 'W_EMP_SEPARATION' , ?) AS SEPMODE_DESCR FROM DUAL";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, sepMode);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						sepModeDescr = checkNull(rs.getString("SEPMODE_DESCR"));
					}
					close(pstmt , rs);
					if(sepMode != null && sepMode.trim().length() > 0)
					{
						 
						valueXmlString.append("<sepmode_descr>").append("<![CDATA[" + sepModeDescr + "]]>").append("</sepmode_descr>");
					}
					else
					{
						valueXmlString.append("<sepmode_descr>").append("<![CDATA[]]>").append("</sepmode_descr>");
					}
				}
				
				 valueXmlString.append ("</Detail1>\r\n");					 
				
				break;
			}
		
		}
	}
		
	catch(Exception e)
	{
		throw new ITMException(e);
	}
	finally 
	{
		try {
			
				close(pstmt, rs);
				if (conn != null)
				{
					conn.close();
					conn = null;
				}

		} 
		catch (Exception e)
		{
			e.printStackTrace();
			
		}
	}
	
	valueXmlString.append("</Root>\r\n");
	System.out.println("valueXmlString....["+valueXmlString.toString());
	return valueXmlString.toString();
}
	
	
	
	private String errorType( Connection conn , String errorCode ) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";
			
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		}		
		finally
		{
			try
			{
				close(pstmt, rs);
			}
			catch ( Exception e )
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}		
		return msgType;
	}
	
	private String checkNull(String input)
	{
		if(input == null)
		{
			input = "";
		}
		
		else 
		{
			input = input.trim();
		}
		return input;
	}
	private String getObjName(Document dom,String objContext)
	{	
		Node elementName = null;
		NodeList elementList = null;
		String objName = "";
		elementList = dom.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("objName")!=null)
				{
					objName = etlAttributes.getNamedItem("objName").getNodeValue();
				}
			}
		}
		return objName;
	}
	private void close(PreparedStatement pstmt,ResultSet rs)
	{
		try{
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	
	private String getRelativeDateStr(String sourceDateStr , int noticeDays)
	{	
		java.util.Date relieveDate = new java.util.Date();
		String relieveDateStr = "";
		try
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());	
		//	SimpleDateFormat dbsdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			System.out.println("called getRelativeDateStr method");
			if(sourceDateStr != null && sourceDateStr.trim().length() > 0)
			{
				Calendar cal = Calendar.getInstance();
		        cal.setTime(sdf.parse(sourceDateStr));
		        cal.add(Calendar.DATE , noticeDays ); 
		        relieveDate = cal.getTime();
		        relieveDateStr = sdf.format(relieveDate);
		        System.out.println("RelativeDateStr returned from getRelativeDateStr" + relieveDateStr );	       
			}
		
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		
		return relieveDateStr;
	}
	
	
}



	




