package ibase.webitm.utility.wms;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.wms.Attribute;
import ibase.webitm.bean.wms.PaypalParameters;
import ibase.webitm.bean.wms.PaypalRefundParams;
import ibase.webitm.bean.wms.Product;
import ibase.webitm.bean.wms.ShipmentStatus;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
public  class CommonWmsUtil {

	public static  int ALL_PTCN_EX_COUNT;

	public CommonWmsUtil()
	{
	}

	public static CommonWmsUtil getInstance()
	{
		return new ibase.webitm.utility.wms.CommonWmsUtil();
	}

	//Changed By Pragyan 11-AUG-14 To check and Facility Master implementation.start
	public boolean isValFacLocation(String locCode,String siteCode,Connection conn) throws ITMException
	{
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		double partialQty=0.0;
		double packSize=0.0;
		boolean isValidLocation = false;
		int count = 0;
		// Added By Manish on 27/07/15
		String sql = "";
		String DB = CommonConstants.DB_NAME;
		System.out.println("DB=====>>>"+DB);

		try {
			//changed by manish for database MS SQL server on 27/07/15
			if("mssql".equalsIgnoreCase(DB))
			{
				sql ="SELECT dbo.FN_CHECK_VALID_LOC(?,?)";
			}
			else
			{
				sql ="SELECT FN_CHECK_VALID_LOC(?,?) FROM DUAL";
			}
			pstmt =conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, locCode);

			rs = pstmt.executeQuery();

			if(rs.next())
			{
				count = rs.getInt(1);
			}

			if(count > 0)
			{
				isValidLocation = true;
			}


			if(rs != null)
			{
				rs.close();
				rs=null;
			}

			if(pstmt != null)
			{
				pstmt.close();
				pstmt=null;
			}




		} catch (Exception e) {
			// TODO Auto-generated catch block
			throw new ITMException(e); 
		}

		return isValidLocation;
	}
	// Start changed by Pragyan on 19-SEP-14  [W14FSUN003]	
	public String checkNull( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal;
	}

	public String getFacilityCode(String siteCode,Connection conn) throws ITMException
	{
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		int count = 0;
		String facilityCode = "";

		try {
			String sql ="SELECT facility_code FROM site where site_code = ?";
			pstmt =conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);


			rs = pstmt.executeQuery();

			if(rs.next())
			{
				facilityCode = checkNull(rs.getString(1));
			}


			if(rs != null)
			{
				rs.close();
				rs=null;
			}

			if(pstmt != null)
			{
				pstmt.close();
				pstmt=null;
			}




		} 
		catch (Exception e) 
		{
			// TODO Auto-generated catch block
			throw new ITMException(e); 
		}

		return facilityCode;
	}
	//Changed By Pragyan 11-AUG-14 To check and Facility Master implementation.end
	// End changed by Pragyan on 19-SEP-14   [W14FSUN003]	

	//changed by Dadaso Pawar on 04/02/15 [Start]
	//For get Stock option from item master
	//stk_opt 0 : No stk maint.
	//stk_opt 1 : By item maint.
	//stk_opt 2 : By lot maint.
	public String getStockOption (String itemCode,Connection conn) throws ITMException,Exception
	{
		System.out.println("-----------in getStockOption method ----------------");	    	
		String sql = "",stkOpt = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		itemCode = itemCode == null ? "" :itemCode.trim();
		try
		{
			//changed by wasim on 06-11-2015 to check stk_opt from siteitem first [START]
			sql = "SELECT STK_OPT FROM SITEITEM WHERE ITEM_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				stkOpt = rs.getString(1) == null ? "" : rs.getString(1).trim();
			}
			else
			{	
				//Changed by Manish on 15/03/16 [start]
				if(rs != null)
				{
					rs.close();
					rs=null;
				}

				if(pstmt != null)
				{
					pstmt.close();
					pstmt=null;
				}
				//Changed by Manish on 15/03/16 [end]
				System.out.println("Getting stk_opt from item...");
				sql = "SELECT STK_OPT FROM ITEM WHERE ITEM_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, itemCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					stkOpt = rs.getString(1) == null ? "" : rs.getString(1).trim();
				}
			}
			/*rs.close();rs = null;
			pstmt.close();pstmt = null;*/
			
			//Changed by Manish on 15/03/16 [start]
			if(rs != null)
			{
				rs.close();
				rs=null;
			}

			if(pstmt != null)
			{
				pstmt.close();
				pstmt=null;
			}
			//Changed by Manish on 15/03/16 [end]
			/*sql = "SELECT STK_OPT FROM ITEM WHERE ITEM_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				stkOpt = rs.getString(1) == null ? "" : rs.getString(1).trim();
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;*/
			//changed by wasim on 06-11-2015 to check stk_opt from siteitem first [END]
		}
		catch(Exception e)
		{
			System.out.println("Exception :CommonWmsUtil :getStockOption :==>\n"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		//Changed by Manish on 15/03/16 [start]
		finally
		{

			if(rs != null)
			{
				rs.close();
				rs=null;
			}

			if(pstmt != null)
			{
				pstmt.close();
				pstmt=null;
			}
		}
		//Changed by Manish on 15/03/16 [start]
		return stkOpt;
	}

	//Changed by wasim on 09-10-15 for AWMS interface2 table [START]
	public HashMap getPalletizedAttributes(String itemCode, String siteCode, Connection conn) throws ITMException, SQLException
	{
		HashMap hm = new HashMap();
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		String sql = "",itemSerRg1="";
		String familyGrp = "", qcType = "", stroPref = "";

		try
		{
			//Change  by Jagruti Shinde for ITEM_SER__RG1 Request ID:[W15JSUN010] [Start]
			//sql="SELECT LOC_ZONE__PREF,PROC_MTH,ANALYSIS_CLASS FROM SITEITEM WHERE ITEM_CODE = ? AND SITE_CODE = ?";
			sql = "SELECT LOC_ZONE__PREF,PROC_MTH,ANALYSIS_CLASS,ITEM_SER__RG1 FROM SITEITEM WHERE ITEM_CODE = ? AND SITE_CODE = ?";
			//Change  by Jagruti Shinde for ITEM_SER__RG1 Request ID:[W15JSUN010] [End]
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			pstmt.setString(2, siteCode);
			rs = pstmt.executeQuery();

			if (rs.next())
			{
				familyGrp = checkNullAndTrim(rs.getString("LOC_ZONE__PREF"));
				qcType = checkNullAndTrim(rs.getString("PROC_MTH"));
				stroPref = checkNullAndTrim(rs.getString("ANALYSIS_CLASS"));
				//Change  by Jagruti Shinde for ITEM_SER__RG1 Request ID:[W15JSUN010] [Start]
				itemSerRg1 = checkNullAndTrim(rs.getString("ITEM_SER__RG1"));
				//Change  by Jagruti Shinde for ITEM_SER__RG1 Request ID:[W15JSUN010] [End]
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;

			sql = "SELECT LOC_ZONE__PREF,PROC_MTH,ANALYSIS_CLASS FROM ITEM WHERE ITEM_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			rs = pstmt.executeQuery();

			if (rs.next())
			{
				if(familyGrp == null || familyGrp.length() <= 0)
				{	
					familyGrp = checkNullAndTrim(rs.getString("LOC_ZONE__PREF"));
				}
				if(qcType == null || qcType.length() <= 0)
				{
					qcType = checkNullAndTrim(rs.getString("PROC_MTH"));
				}
				if(stroPref == null || stroPref.length() <= 0)
				{
					stroPref = checkNullAndTrim(rs.getString("ANALYSIS_CLASS"));
				}
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;

			hm.put("LOC_ZONE__PREF", familyGrp);
			hm.put("PROC_MTH", qcType);
			hm.put("ANALYSIS_CLASS", stroPref);
			//Change  by Jagruti Shinde for ITEM_SER__RG1 Request ID:[W15JSUN010] [Start]
			hm.put("ITEM_SER__RG1", itemSerRg1);
			//Change  by Jagruti Shinde for ITEM_SER__RG1 Request ID:[W15JSUN010] [End]
		}
		catch(Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			if(pstmt != null){pstmt.close();pstmt = null;}
			if(rs != null){rs.close();rs = null;}
		}
		return hm;
	}
	//change by Priyankac on 03JULY2017.[AwmsInterface return type should be changed..Start]
	public String updateAwmsInterface(ArrayList interfaceArrList,String siteCode,Connection connWms) throws ITMException, SQLException
	{
		String errString = "";
		System.out.println("Inside updateAwmsInterface");

		PreparedStatement interfacePstmt=null, interfaceWmsPstmt = null,pstmt=null;
		ResultSet rs = null;
		String interfaceSql = "",sql="";

		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;

		int caseCount = 0,caseCount1 = 0,cnt=0;
		Boolean isError = false;

		Timestamp tranDateAct = null,expDate = null,mfgDate = null,transactionDate = null;;
		String tranDate = "",expDt = "",mfgDt = "";

		String itemCode = "",lineNo = "",descr = "",unit = "",itemType = "",familyGrp = "",refSer = "",lotNo = "",refId = "",lotSl = "",quantity = "",
				palletNo = "",palletStatus = "",lockStat = "",qcType = "",stroPref = "",palletRej = "",palletRejDesc = "",confirmed = "",
				inOut = "",errCod = "",msgStat = "",transDate = "",errDesc = "";
		String totalQty ,qtyPerArt ;
		String transactionId = "",WMSSql = "";

		java.sql.Timestamp currDate = new java.sql.Timestamp( System.currentTimeMillis() );

		try
		{
			conn = connDriver.getConnectDB("DriverAWMS");
			conn.setAutoCommit(false);
			interfaceSql = "INSERT INTO HOST_TO_WMS (TRAN_ID,ITEM_CODE,DESCR,UNIT,ITEM_TYPE,"//Changed table name by wasim on 02-11-15, previous table name interface.
					+ "FAMILY_GRP,IN_OUT,REF_SER,REF_ID,TRAN_DATE,LOT_NO,"
					+ "LOT_SL,QUANTITY,QTY_PER_ART,TOTAL_QTY,EXP_DATE,MFG_DATE,"
					+ "PALLET_NO,PALLET_STATUS,MSG_STAT,LOCK_STAT,ERR_COD,ERR_DESC,"
					+ "QC_TYPE,TRANS_DT_ACK,STRO_PREF,LINE_NO) "
					+ "VALUES (?,?,?,?,?,?,"
					+ "?,?,?,?,?,?,"
					+ "?,?,?,?,?,?,"
					+ "?,?,?,?,?,?,?,?,?)";

			WMSSql = "INSERT INTO SWMS_TO_AWMS (TRAN_ID,ITEM_CODE,DESCR,UNIT,ITEM_TYPE,"//Changed table name by wasim on 02-11-15, previous table name interface2.
					+ "FAMILY_GRP,IN_OUT,REF_SER,REF_ID,TRAN_DATE,LOT_NO,"
					+ "LOT_SL,QUANTITY,QTY_PER_ART,TOTAL_QTY,EXP_DATE,MFG_DATE,"
					+ "PALLET_NO,PALLET_STATUS,MSG_STAT,LOCK_STAT,ERR_COD,ERR_DESC,"
					+ "QC_TYPE,TRANS_DT_ACK,STRO_PREF,LINE_NO,SCHEDULE_STATUS) "
					+ "VALUES (?,?,?,?,?,?,"
					+ "?,?,?,?,?,?,"
					+ "?,?,?,?,?,?,"
					+ "?,?,?,?,?,?,?,?,?,?)";

			Iterator itr=interfaceArrList.iterator();

			System.out.println("Array List size="+interfaceArrList.size());

			while(itr.hasNext())
			{  
				HashMap detail = new HashMap();

				detail = (HashMap) itr.next();

				transactionId = generateTranTd("w_interface2", currDate.toString(), siteCode, connWms);
				System.out.println("interface2TranId ::::::::::::: " + transactionId);

				inOut = (String) detail.get("IN_OUT");
				errCod = (String) detail.get("ERR_COD");
				msgStat = (String) detail.get("MSG_STAT");

				tranDate =  (String) detail.get("TRANS_DT_ACK");
				System.out.println("Tran Date is="+tranDate);
				if(tranDate != null && tranDate.trim().length() > 0 && !tranDate.equals("null"))
				{
					tranDateAct = Timestamp.valueOf((String) detail.get("TRANS_DT_ACK"));
				}

				transDate =  (String) detail.get("TRAN_DATE");
				System.out.println("Tran Date is="+tranDate);
				if(transDate != null && transDate.trim().length() > 0 && !transDate.equals("null"))
				{
					transactionDate = Timestamp.valueOf((String) detail.get("TRAN_DATE"));
				}
				System.out.println("transaction date::: " + transactionDate);
				System.out.println("ack date::: " + tranDateAct);

				//transactionId = (String) detail.get("TRAN_ID");
				itemCode = (String) detail.get("ITEM_CODE");
				descr = (String) detail.get("DESCR");
				unit = (String) detail.get("UNIT");
				itemType = (String) detail.get("ITEM_TYPE");
				familyGrp = (String) detail.get("FAMILY_GRP");
				refSer = (String) detail.get("REF_SER");
				lotNo = (String) detail.get("LOT_NO");
				refId = (String) detail.get("REF_ID");	
				lotSl = (String) detail.get("LOT_SL");
				quantity = (String) detail.get("QUANTITY");

				expDt =  (String) detail.get("EXP_DATE");
				System.out.println("Exp date"+expDt);
				if(expDt != null && expDt.trim().length() > 0 && !expDt.equals("null"))
				{
					expDate = Timestamp.valueOf((String) detail.get("EXP_DATE"));
				}

				mfgDt =  (String) detail.get("MFG_DATE");
				System.out.println("Mfg date"+mfgDt);
				if(mfgDt != null && mfgDt.trim().length() > 0 && !mfgDt.equals("null"))
				{
					mfgDate = Timestamp.valueOf((String) detail.get("MFG_DATE"));
				}
				palletNo = (String) detail.get("PALLET_NO");
				palletStatus = (String) detail.get("PALLET_STATUS");
				lockStat = (String) detail.get("LOCK_STAT");
				qcType = (String) detail.get("QC_TYPE");
				stroPref = (String) detail.get("STRO_PREF");
				lockStat = (String) detail.get("LOCK_STAT");
				qtyPerArt = (String) detail.get("QTY_PER_ART");
				totalQty = (String) detail.get("TOTAL_QTY");
				lineNo = (String) detail.get("LINE_NO");

				interfacePstmt = conn.prepareStatement(interfaceSql);
				interfacePstmt.setString(1, transactionId);
				interfacePstmt.setString(2, itemCode);
				interfacePstmt.setString(3, descr);
				interfacePstmt.setString(4, unit);
				interfacePstmt.setString(5, itemType);
				interfacePstmt.setString(6, familyGrp);
				interfacePstmt.setString(7, inOut);
				interfacePstmt.setString(8, refSer);
				interfacePstmt.setString(9, refId);
				interfacePstmt.setTimestamp(10, transactionDate);
				interfacePstmt.setString(11, lotNo);
				interfacePstmt.setString(12, lotSl);
				interfacePstmt.setString(13, quantity);
				interfacePstmt.setString(14, qtyPerArt);
				interfacePstmt.setString(15, totalQty);
				interfacePstmt.setTimestamp(16, expDate);
				interfacePstmt.setTimestamp(17, mfgDate);
				interfacePstmt.setString(18, palletNo);
				interfacePstmt.setString(19, palletStatus);
				interfacePstmt.setString(20, msgStat);
				interfacePstmt.setString(21, lockStat);
				interfacePstmt.setString(22, errCod);
				interfacePstmt.setString(23, errDesc);
				interfacePstmt.setString(24, qcType);
				interfacePstmt.setTimestamp(25, tranDateAct);
				interfacePstmt.setString(26, stroPref);
				interfacePstmt.setString(27, lineNo);

				interfaceWmsPstmt = connWms.prepareStatement(WMSSql);
				interfaceWmsPstmt.setString(1, transactionId);
				interfaceWmsPstmt.setString(2, itemCode);
				interfaceWmsPstmt.setString(3, descr);
				interfaceWmsPstmt.setString(4, unit);
				interfaceWmsPstmt.setString(5, itemType);
				interfaceWmsPstmt.setString(6, familyGrp);
				interfaceWmsPstmt.setString(7, inOut);
				interfaceWmsPstmt.setString(8, refSer);
				interfaceWmsPstmt.setString(9, refId);
				interfaceWmsPstmt.setTimestamp(10, transactionDate);
				interfaceWmsPstmt.setString(11, lotNo);
				interfaceWmsPstmt.setString(12, lotSl);
				interfaceWmsPstmt.setString(13, quantity);
				interfaceWmsPstmt.setString(14, qtyPerArt);
				interfaceWmsPstmt.setString(15, totalQty);
				interfaceWmsPstmt.setTimestamp(16, expDate);
				interfaceWmsPstmt.setTimestamp(17, mfgDate);
				interfaceWmsPstmt.setString(18, palletNo);
				interfaceWmsPstmt.setString(19, palletStatus);
				interfaceWmsPstmt.setString(20, msgStat);
				interfaceWmsPstmt.setString(21, lockStat);
				interfaceWmsPstmt.setString(22, errCod);
				interfaceWmsPstmt.setString(23, errDesc);
				interfaceWmsPstmt.setString(24, qcType);
				interfaceWmsPstmt.setTimestamp(25, tranDateAct);
				interfaceWmsPstmt.setString(26, stroPref);
				interfaceWmsPstmt.setString(27, lineNo);
				interfaceWmsPstmt.setString(28, "N");//Changed by wasim 26 -11-2015 to add schedule_status = 'N' by default

				caseCount1 += interfaceWmsPstmt.executeUpdate();
				interfaceWmsPstmt.close(); interfaceWmsPstmt = null;
				System.out.println("Update Count WMS= "+caseCount1);

				caseCount += interfacePstmt.executeUpdate();
				interfacePstmt.close(); interfacePstmt = null;
				System.out.println("Update Count AWMS= "+caseCount);
			}  
			//Added by saurabh for swms_to_Awms detail count should be match with pallet det[07/06/17|Start]
			if(caseCount!=interfaceArrList.size())
			{
				errString="COUNTNOTMATCH_HOST";
			}
			if(caseCount1!=interfaceArrList.size())
			{
				errString="COUNTNOTMATCH_SWMS";
			}
			if(caseCount1!=caseCount)
			{
				errString="INSERTCNTNOTMATCH";
			}
			//Added by saurabh for swms_to_Awms detail count should be match with pallet det[07/06/17|End]
		}
		catch(Exception e)
		{
			isError = true;
			errString = e.getMessage();
			throw new ITMException(e);

		}
		finally
		{
			System.out.println("updateAwmsInterface isError="+isError);
			if(isError)
			{
				conn.rollback();
			}
			else
			{
				conn.commit();
			}
			if(interfacePstmt != null){interfacePstmt.close();interfacePstmt = null;}
			if(interfaceWmsPstmt != null){interfaceWmsPstmt.close();interfaceWmsPstmt = null;}
			if(rs != null){rs.close();rs = null;}
			if(conn != null){conn.close();conn = null;}
		}
		return errString;
		/*{
		System.out.println("Inside updateAwmsInterface");

		PreparedStatement interfacePstmt=null, interfaceWmsPstmt = null;
		ResultSet rs = null;
		String interfaceSql = "";

		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;

		int caseCount = 0;
		Boolean isError = false;

		Timestamp tranDateAct = null,expDate = null,mfgDate = null,transactionDate = null;;
		String tranDate = "",expDt = "",mfgDt = "";

		String itemCode = "",lineNo = "",descr = "",unit = "",itemType = "",familyGrp = "",refSer = "",lotNo = "",refId = "",lotSl = "",quantity = "",
		palletNo = "",palletStatus = "",lockStat = "",qcType = "",stroPref = "",palletRej = "",palletRejDesc = "",confirmed = "",
		inOut = "",errCod = "",msgStat = "",transDate = "",errDesc = "";
		String totalQty ,qtyPerArt ;
		String transactionId = "",WMSSql = "";

		java.sql.Timestamp currDate = new java.sql.Timestamp( System.currentTimeMillis() );

		try
		{
			conn = connDriver.getConnectDB("DriverAWMS");
			conn.setAutoCommit(false);
			interfaceSql = "INSERT INTO HOST_TO_WMS (TRAN_ID,ITEM_CODE,DESCR,UNIT,ITEM_TYPE,"//Changed table name by wasim on 02-11-15, previous table name interface.
				+ "FAMILY_GRP,IN_OUT,REF_SER,REF_ID,TRAN_DATE,LOT_NO,"
				+ "LOT_SL,QUANTITY,QTY_PER_ART,TOTAL_QTY,EXP_DATE,MFG_DATE,"
				+ "PALLET_NO,PALLET_STATUS,MSG_STAT,LOCK_STAT,ERR_COD,ERR_DESC,"
				+ "QC_TYPE,TRANS_DT_ACK,STRO_PREF,LINE_NO) "
				+ "VALUES (?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?,?)";

			WMSSql = "INSERT INTO SWMS_TO_AWMS (TRAN_ID,ITEM_CODE,DESCR,UNIT,ITEM_TYPE,"//Changed table name by wasim on 02-11-15, previous table name interface2.
				+ "FAMILY_GRP,IN_OUT,REF_SER,REF_ID,TRAN_DATE,LOT_NO,"
				+ "LOT_SL,QUANTITY,QTY_PER_ART,TOTAL_QTY,EXP_DATE,MFG_DATE,"
				+ "PALLET_NO,PALLET_STATUS,MSG_STAT,LOCK_STAT,ERR_COD,ERR_DESC,"
				+ "QC_TYPE,TRANS_DT_ACK,STRO_PREF,LINE_NO,SCHEDULE_STATUS) "
				+ "VALUES (?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,"
				+ "?,?,?,?,?,?,?,?,?,?)";

			Iterator itr=interfaceArrList.iterator();

			System.out.println("Array List size="+interfaceArrList.size());

			while(itr.hasNext())
			{  
				HashMap detail = new HashMap();

				detail = (HashMap) itr.next();

				transactionId = generateTranTd("w_interface2", currDate.toString(), siteCode, connWms);
				System.out.println("interface2TranId ::::::::::::: " + transactionId);

				inOut = (String) detail.get("IN_OUT");
				errCod = (String) detail.get("ERR_COD");
				msgStat = (String) detail.get("MSG_STAT");

				tranDate =  (String) detail.get("TRANS_DT_ACK");
				System.out.println("Tran Date is="+tranDate);
				if(tranDate != null && tranDate.trim().length() > 0 && !tranDate.equals("null"))
				{
					tranDateAct = Timestamp.valueOf((String) detail.get("TRANS_DT_ACK"));
				}

				transDate =  (String) detail.get("TRAN_DATE");
				System.out.println("Tran Date is="+tranDate);
				if(transDate != null && transDate.trim().length() > 0 && !transDate.equals("null"))
				{
					transactionDate = Timestamp.valueOf((String) detail.get("TRAN_DATE"));
				}

				//transactionId = (String) detail.get("TRAN_ID");
				itemCode = (String) detail.get("ITEM_CODE");
				descr = (String) detail.get("DESCR");
				unit = (String) detail.get("UNIT");
				itemType = (String) detail.get("ITEM_TYPE");
				familyGrp = (String) detail.get("FAMILY_GRP");
				refSer = (String) detail.get("REF_SER");
				lotNo = (String) detail.get("LOT_NO");
				refId = (String) detail.get("REF_ID");	
				lotSl = (String) detail.get("LOT_SL");
				quantity = (String) detail.get("QUANTITY");

				expDt =  (String) detail.get("EXP_DATE");
				System.out.println("Exp date"+expDt);
				if(expDt != null && expDt.trim().length() > 0 && !expDt.equals("null"))
				{
					expDate = Timestamp.valueOf((String) detail.get("EXP_DATE"));
				}

				mfgDt =  (String) detail.get("MFG_DATE");
				System.out.println("Mfg date"+mfgDt);
				if(mfgDt != null && mfgDt.trim().length() > 0 && !mfgDt.equals("null"))
				{
					mfgDate = Timestamp.valueOf((String) detail.get("MFG_DATE"));
				}
				palletNo = (String) detail.get("PALLET_NO");
				palletStatus = (String) detail.get("PALLET_STATUS");
				lockStat = (String) detail.get("LOCK_STAT");
				qcType = (String) detail.get("QC_TYPE");
				stroPref = (String) detail.get("STRO_PREF");
				lockStat = (String) detail.get("LOCK_STAT");
				qtyPerArt = (String) detail.get("QTY_PER_ART");
				totalQty = (String) detail.get("TOTAL_QTY");
				lineNo = (String) detail.get("LINE_NO");

				interfacePstmt = conn.prepareStatement(interfaceSql);
				interfacePstmt.setString(1, transactionId);
				interfacePstmt.setString(2, itemCode);
				interfacePstmt.setString(3, descr);
				interfacePstmt.setString(4, unit);
				interfacePstmt.setString(5, itemType);
				interfacePstmt.setString(6, familyGrp);
				interfacePstmt.setString(7, inOut);
				interfacePstmt.setString(8, refSer);
				interfacePstmt.setString(9, refId);
				interfacePstmt.setTimestamp(10, transactionDate);
				interfacePstmt.setString(11, lotNo);
				interfacePstmt.setString(12, lotSl);
				interfacePstmt.setString(13, quantity);
				interfacePstmt.setString(14, qtyPerArt);
				interfacePstmt.setString(15, totalQty);
				interfacePstmt.setTimestamp(16, expDate);
				interfacePstmt.setTimestamp(17, mfgDate);
				interfacePstmt.setString(18, palletNo);
				interfacePstmt.setString(19, palletStatus);
				interfacePstmt.setString(20, msgStat);
				interfacePstmt.setString(21, lockStat);
				interfacePstmt.setString(22, errCod);
				interfacePstmt.setString(23, errDesc);
				interfacePstmt.setString(24, qcType);
				interfacePstmt.setTimestamp(25, tranDateAct);
				interfacePstmt.setString(26, stroPref);
				interfacePstmt.setString(27, lineNo);

				interfaceWmsPstmt = connWms.prepareStatement(WMSSql);
				interfaceWmsPstmt.setString(1, transactionId);
				interfaceWmsPstmt.setString(2, itemCode);
				interfaceWmsPstmt.setString(3, descr);
				interfaceWmsPstmt.setString(4, unit);
				interfaceWmsPstmt.setString(5, itemType);
				interfaceWmsPstmt.setString(6, familyGrp);
				interfaceWmsPstmt.setString(7, inOut);
				interfaceWmsPstmt.setString(8, refSer);
				interfaceWmsPstmt.setString(9, refId);
				interfaceWmsPstmt.setTimestamp(10, transactionDate);
				interfaceWmsPstmt.setString(11, lotNo);
				interfaceWmsPstmt.setString(12, lotSl);
				interfaceWmsPstmt.setString(13, quantity);
				interfaceWmsPstmt.setString(14, qtyPerArt);
				interfaceWmsPstmt.setString(15, totalQty);
				interfaceWmsPstmt.setTimestamp(16, expDate);
				interfaceWmsPstmt.setTimestamp(17, mfgDate);
				interfaceWmsPstmt.setString(18, palletNo);
				interfaceWmsPstmt.setString(19, palletStatus);
				interfaceWmsPstmt.setString(20, msgStat);
				interfaceWmsPstmt.setString(21, lockStat);
				interfaceWmsPstmt.setString(22, errCod);
				interfaceWmsPstmt.setString(23, errDesc);
				interfaceWmsPstmt.setString(24, qcType);
				interfaceWmsPstmt.setTimestamp(25, tranDateAct);
				interfaceWmsPstmt.setString(26, stroPref);
				interfaceWmsPstmt.setString(27, lineNo);
				interfaceWmsPstmt.setString(28, "N");//Changed by wasim 26 -11-2015 to add schedule_status = 'N' by default

				caseCount = interfaceWmsPstmt.executeUpdate();
				interfaceWmsPstmt.close(); interfaceWmsPstmt = null;
				System.out.println("Update Count WMS= "+caseCount);

				caseCount = interfacePstmt.executeUpdate();
				interfacePstmt.close(); interfacePstmt = null;
				System.out.println("Update Count AWMS= "+caseCount);
			}  
		}
		catch(Exception e)
		{
			isError = true;
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("updateAwmsInterface isError="+isError);
			if(isError)
			{
				conn.rollback();
			}
			else
			{
				conn.commit();
			}
			if(interfacePstmt != null){interfacePstmt.close();interfacePstmt = null;}
			if(interfaceWmsPstmt != null){interfaceWmsPstmt.close();interfaceWmsPstmt = null;}
			if(rs != null){rs.close();rs = null;}
			if(conn != null){conn.close();conn = null;}
		}
	}*/

	}
	//change by Priyankac on 03JULY2017.[AwmsInterface return type should be changed..END]

	public static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	//Changed by wasim on 09-10-15 to for AWMS interface2 table [END]

	// Changed by Sneha on 23-10-2015, for generation of transaction id [start]
	public String generateTranTd( String windowName, String tranDate, String siteCode, Connection  conn )throws ITMException, SQLException
	{		
		System.out.println("inside generateTranTd@@.........");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String tranId = "";
		String tranSer1 = "",keyString = "",keyCol = "";
		CommonConstants commonConstants = new CommonConstants();
		try
		{		 	
			sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, windowName);
			rs = pstmt.executeQuery();
			System.out.println("keyString :"+sql);

			if (rs.next())
			{
				keyString = rs.getString(1);
				keyCol = rs.getString(2);
				tranSer1 = rs.getString(3);
			}
			else
			{
				sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "GENERAL");
				rs = pstmt.executeQuery();
				System.out.println("keyString :"+sql);				
				if (rs.next())
				{
					keyString = rs.getString(1);
					keyCol = rs.getString(2);
					tranSer1 = rs.getString(3);
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer1 :"+tranSer1);
			String xmlValues = "";
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +	"<tran_id></tran_id>";
			xmlValues = xmlValues + "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues + "<tran_date>"+ tranDate + "</tran_date>";
			xmlValues = xmlValues + "<tran_type>"+"U"+"</tran_type>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", commonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer1, keyCol, keyString, conn);

			System.out.println("tranId ::"+tranId);
		}
		catch (SQLException ex)
		{			
			System.out.println("Exception ::" +sql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{		
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		return tranId;
	}

	public HashMap getItemVoumeMap(String itemCode,String lotNo,Connection con)throws Exception
	{
		double packSize = 0,itemSize = 0,lotSize = 0;
		PreparedStatement pstmt = null;
		String sql="",hazardous = "";
		String harmonizCode = "",harmonizDescr = "",originCountry = "";
		ResultSet rs = null;
		double itmLen = 0,itmWidth = 0,itmHeight = 0,itemWeight = 0,lotLen = 0 ,lotHeight = 0,lotWidth = 0,lotWeight = 0;
		HashMap dataVolumeMap = new HashMap();

		try
		{
			System.out.println("@@LOT NO["+lotNo+"]");

			sql = "SELECT I.LENGTH ITEM_LEN,I.WIDTH ITEM_WID,I.HEIGHT ITEM_HEIGHT,I.GROSS_WEIGHT ITEM_WEIGHT,I.HAZARDOUS HAZARD, " 
				+" I.HARMONIZATION_NO HARMONIZATION_NO,I.HARMONIZATION_DESCR HARMONIZATION_DESCR,I.COUNT_CODE__MFG ORIGIN_COUNTRY,"
				+" L.LENGTH LITEM_LEN,L.WIDTH LITEM_WID,L.HEIGHT LITEM_HEIGHT,L.SHIPPER_SIZE SHIPSIZE,L.GROSS_WEIGHT LOT_WEIGHT FROM"
				+" ITEM I,ITEM_LOT_PACKSIZE L"
				+" WHERE I.ITEM_CODE = L.ITEM_CODE"
				+" AND L.LOT_NO__FROM <= ? AND L.LOT_NO__TO >= ?"
				+" AND  I.ITEM_CODE = ?";
			pstmt = con.prepareStatement(sql);
			if(lotNo != null && (lotNo.trim()).length() > 0)
			{
				pstmt.setString(1, lotNo);
				pstmt.setString(2, lotNo);
			}
			else
			{
				return dataVolumeMap = getItemVoumeMap(itemCode, con);
			}
			pstmt.setString(3, itemCode);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				itmLen = rs.getDouble("ITEM_LEN");
				itmWidth = rs.getDouble("ITEM_WID");
				itmHeight = rs.getDouble("ITEM_HEIGHT");
				itemWeight = rs.getDouble("ITEM_WEIGHT");
				hazardous = rs.getString("HAZARD");
				lotLen = rs.getDouble("LITEM_LEN");
				lotWidth = rs.getDouble("LITEM_WID");
				lotHeight = rs.getDouble("LITEM_HEIGHT");				
				packSize = rs.getDouble("SHIPSIZE");				
				lotWeight = rs.getDouble("LOT_WEIGHT");
				harmonizCode = rs.getString("HARMONIZATION_NO");
				harmonizDescr = rs.getString("HARMONIZATION_DESCR");
				originCountry = rs.getString("ORIGIN_COUNTRY");
			}
			itemSize = itmLen * itmWidth * itmHeight;
			lotSize = lotHeight * lotWidth * lotLen;

			dataVolumeMap.put("PACK_SIZE", packSize);
			dataVolumeMap.put("ITEM_SIZE", itemSize);
			dataVolumeMap.put("LOT_SIZE", lotSize);
			dataVolumeMap.put("HAZARDOUS", hazardous);
			dataVolumeMap.put("ITEM_WEIGHT", itemWeight);
			dataVolumeMap.put("PACK_WEIGHT", lotWeight);
			dataVolumeMap.put("HARMONIZATION_NO", harmonizCode);
			dataVolumeMap.put("HARMONIZATION_DESCR", harmonizDescr);
			dataVolumeMap.put("ORIGIN_COUNTRY", originCountry);
			dataVolumeMap.put("ITEM_LEN", itmLen);
			dataVolumeMap.put("ITEM_WID", itmWidth);
			dataVolumeMap.put("ITEM_HEIGHT", itmHeight);
			dataVolumeMap.put("LITEM_LEN", lotLen);
			dataVolumeMap.put("LITEM_WID", lotWidth);
			dataVolumeMap.put("LITEM_HEIGHT", lotHeight);
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;

			}
			if(rs != null)
			{
				rs.close();
				rs = null;

			}

		} catch (Exception e) {
			throw e;
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;

				}
				if(rs != null)
				{
					rs.close();
					rs = null;

				}
			}
			catch(Exception e)
			{
				throw e;
			}
		}

		return dataVolumeMap;
	}

	private HashMap getItemVoumeMap(String itemCode,Connection con)throws Exception
	{
		double packSize = 0,itemSize = 0,lotSize = 0;
		PreparedStatement pstmt = null;
		String sql="",hazardous = "";
		String harmonizCode = "",harmonizDescr = "",originCountry = "";
		ResultSet rs = null;
		double itmLen = 0,itmWidth = 0,itmHeight = 0,itemWeight = 0,lotLen = 0 ,lotHeight = 0,lotWidth = 0,lotWeight = 0;
		HashMap dataVolumeMap = new HashMap();

		System.out.println("As Lot No Passed as Blank Calling Override method for getItemVoumeMap");
		try 
		{

			sql = "SELECT I.LENGTH ITEM_LEN,I.WIDTH ITEM_WID,I.HEIGHT ITEM_HEIGHT,I.GROSS_WEIGHT ITEM_WEIGHT,I.HAZARDOUS HAZARD, " 
				+" I.HARMONIZATION_NO HARMONIZATION_NO,I.HARMONIZATION_DESCR HARMONIZATION_DESCR,I.COUNT_CODE__MFG ORIGIN_COUNTRY,"
				+" L.LENGTH LITEM_LEN,L.WIDTH LITEM_WID,L.HEIGHT LITEM_HEIGHT,L.SHIPPER_SIZE SHIPSIZE,L.GROSS_WEIGHT LOT_WEIGHT FROM"
				+" ITEM I,ITEM_LOT_PACKSIZE L"
				+" WHERE I.ITEM_CODE = L.ITEM_CODE"
				+" AND L.LOT_NO__TO IN (SELECT MAX(LOT_NO__TO) FROM ITEM_LOT_PACKSIZE WHERE ITEM_CODE = ?)"
				+" AND  I.ITEM_CODE = ?";
			pstmt = con.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			pstmt.setString(2, itemCode);

			rs = pstmt.executeQuery();

			if(rs.next())
			{
				itmLen = rs.getDouble("ITEM_LEN");
				itmWidth = rs.getDouble("ITEM_WID");
				itmHeight = rs.getDouble("ITEM_HEIGHT");
				itemWeight = rs.getDouble("ITEM_WEIGHT");
				hazardous = rs.getString("HAZARD");
				lotLen = rs.getDouble("LITEM_LEN");
				lotWidth = rs.getDouble("LITEM_WID");
				lotHeight = rs.getDouble("LITEM_HEIGHT");				
				packSize = rs.getDouble("SHIPSIZE");				
				lotWeight = rs.getDouble("LOT_WEIGHT");
				harmonizCode = rs.getString("HARMONIZATION_NO");
				harmonizDescr = rs.getString("HARMONIZATION_DESCR");
				originCountry = rs.getString("ORIGIN_COUNTRY");
			}
			itemSize = itmLen * itmWidth * itmHeight;
			lotSize = lotHeight * lotWidth * lotLen;

			dataVolumeMap.put("PACK_SIZE", packSize);
			dataVolumeMap.put("ITEM_SIZE", itemSize);
			dataVolumeMap.put("LOT_SIZE", lotSize);
			dataVolumeMap.put("HAZARDOUS", hazardous);
			dataVolumeMap.put("ITEM_WEIGHT", itemWeight);
			dataVolumeMap.put("PACK_WEIGHT", lotWeight);
			dataVolumeMap.put("HARMONIZATION_NO", harmonizCode);
			dataVolumeMap.put("HARMONIZATION_DESCR", harmonizDescr);
			dataVolumeMap.put("ORIGIN_COUNTRY", originCountry);
			dataVolumeMap.put("ITEM_LEN", itmLen);
			dataVolumeMap.put("ITEM_WID", itmWidth);
			dataVolumeMap.put("ITEM_HEIGHT", itmHeight);
			dataVolumeMap.put("LITEM_LEN", lotLen);
			dataVolumeMap.put("LITEM_WID", lotWidth);
			dataVolumeMap.put("LITEM_HEIGHT", lotHeight);

			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;

			}
			if(rs != null)
			{
				rs.close();
				rs = null;

			}
		} catch (Exception e) {
			throw e;
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;

				}
				if(rs != null)
				{
					rs.close();
					rs = null;

				}
			}
			catch(Exception e)
			{
				throw e;
			}
		}

		return dataVolumeMap;
	}
	// Changed by Sneha on 23-10-2015, for generation of transaction id [end]

	// Changed by Manish on 28-10-2015 [start]
	public String getDDSalesConfig(String tagName)
	{
		CommonConstants objCommon =new CommonConstants();
		E12GenericUtility genericUtility=new E12GenericUtility();
		String fileName = null,xmlString = "",xmlFileName = "";
		Document dom=null;
		String sCurrentLine = "";
		String xmlFile="DDSalesConfig";
		String apiUrl = "";
		System.out.println("  in setDDSalesConfig -------------------------");
		System.out.println("CommonConstants.APPLICATION_CONTEXT-->>["+CommonConstants.APPLICATION_CONTEXT+"]");   
		System.out.println("CommonConstants.JBOSSHOME-->>["+CommonConstants.JBOSSHOME+"]");   
		if(CommonConstants.APPLICATION_CONTEXT != null)
		{
			xmlFileName = CommonConstants.APPLICATION_CONTEXT + "setting" + File.separator + "DDSalesConfig.xml";
		}
		else
		{
			xmlFileName = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator +"setting" + File.separator +"DDSalesConfig.xml";
		}

		//fileName = ".." + File.separator + "setting" + File.separator + xmlFile + ".xml";
		StringBuilder sb = new StringBuilder();
		System.out.println("xmlFileName-->>["+xmlFileName+"]");          
		try 
		{ 
			BufferedReader br = new BufferedReader(new FileReader(xmlFileName));
			while (( sCurrentLine = br.readLine()) != null)
			{
				sb.append(sCurrentLine);
			}
			xmlString =sb.toString();
			System.out.println("DDSalesConfig xmlString---->>["+xmlString+"]");            	 
			dom = genericUtility.parseString(xmlString);                 
			if(dom != null)
			{                	
				apiUrl = genericUtility.getColumnValue(tagName,dom);               	 
			}                 
		}
		catch(Exception e)
		{
			e.printStackTrace();
		} 
		return apiUrl;
	}

	public  int Call(Product product,String url, List<Integer> simpleProductIds) throws Exception 
	{

		try 
		{
			System.out.println("url111--->>["+url+"] ["+product.getSku()+"]");
			//Changed by samadhan on 24/12/2015 for stop product integration start
			if(url == null || url.length()==0)
			{
				return 0;
			}
			//Changed by samadhan on 24/12/2015 for stop product integration end
			StringBuilder urlParameters = new StringBuilder();
			urlParameters.append(GetUrlParameters(Product.class, product));
			/* String url = Config.apiUrl;
	            //Concat simple product ids in url parameter
			 */	            
			if(simpleProductIds != null && !simpleProductIds.isEmpty())
			{	            	
				urlParameters.append("simples=").append(AppendWithDelimeter(simpleProductIds,","));
				//    url = Config.apiConfigurableUrl; // if parameter available then call configurable api url

			}
			System.out.println("urlParameters----->>["+urlParameters.toString()+"]");
			try 
			{
				System.out.println("urlParametersDecode----->>["+URLDecoder.decode(urlParameters.toString(),"UTF-8")+"]");
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
			}
			//url = Config.apiUrl; //API url call, defined in config file
			URL obj = new URL(url);
			HttpURLConnection con = (HttpURLConnection) obj.openConnection();
			con.setRequestMethod("POST"); //Always do the POST method
			con.setRequestProperty("User-Agent", "Mozilla/5.0");
			con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
			con.setDoOutput(true);

			try
			{
				DataOutputStream wr = new DataOutputStream(con.getOutputStream());
				wr.writeBytes(urlParameters.toString());
				wr.flush();

			}
			catch(Exception e)
			{
				//Changed by samadhan D15AKAT003 on 18/05/2015 for throw exception. Start
				System.out.println("Exception in CommonWMS Util ::" + e.getMessage() + ":");
				e.printStackTrace();
				throw new Exception(e);
				//Changed by samadhan D15AKAT003 on 18/05/2015 for throw exception. End
			}

			int responseCode = con.getResponseCode();
			System.out.println("responseCode-------->>["+responseCode+"]");
			//Changed by samadhan on 29/12/2015 for throw exception when response code not 200 start
			if(responseCode != 200)
			{
				throw new Exception("Response Code="+responseCode);
			}
			//Changed by samadhan on 29/12/2015 for throw exception when response code not 200 end
			switch (responseCode) { //Capture the response code from server
			case 500:
				System.out.println("Unexpected server error.");
				break;
			case 404:
				System.out.println("Target not found. Either files is missing or moved.");
				break;
			case 200: // if call successful, it may return 0 in case of product exist
				StringBuilder response;

				try
				{
					BufferedReader in = new BufferedReader(
							new InputStreamReader(con.getInputStream()));
					String inputLine;
					response = new StringBuilder();
					while ((inputLine = in.readLine()) != null) {
						response.append(inputLine);
					}

					Map map = splitQuery(response.toString());
					System.out.println("response---->>: "+response.toString());
					//Changed by samadhan on 24/12/2015 for check status start
					String status = (String) map.get("status");
					String message = (String) map.get("message");
					System.out.println("Status: "+status);
					System.out.println("Message: "+message);

					if("FAIL".equalsIgnoreCase(checkNull(status)))
					{
						throw new Exception(message);
					}
					//Changed by samadhan on 24/12/2015 for check status end	                           
					String id =  map.get("id").toString();
					if(id != null)
					{
						return Integer.valueOf((String) map.get("id"));
					}
					else
					{
						return 0;
					}

				}
				catch(Exception e)
				{
					//Changed by samadhan D15AKAT003 on 18/05/2015 for throw exception. Start
					System.out.println("Exception in CommonWMS Util ::" + e.getMessage() + ":");
					e.printStackTrace();
					throw new Exception(e);
					//Changed by samadhan D15AKAT003 on 18/05/2015 for throw exception. End
				}
			}
		} catch (IOException e) 
		{
			//Changed by samadhan D15AKAT003 on 18/05/2015 for throw exception. Start
			System.out.println("Exception in CommonWMS Util ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new Exception(e);
			//Changed by samadhan D15AKAT003 on 18/05/2015 for throw exception. End
		}
		return 0;
	}

	static Map<String, String> splitQuery(String queryParam) throws UnsupportedEncodingException {
		Map<String, String> query_pairs = new LinkedHashMap<String, String>();

		String[] pairs = queryParam.split("&");
		for (String pair : pairs) {

			System.out.println("Current Pair["+pair+"]");	
			if(pair.indexOf("=") != -1)
			{
				int idx = pair.indexOf("=");
				if(pair != null)
				{
					if(pair.indexOf("%")!= -1)
					{
						System.out.println("Before pair--------->>["+pair+"]");	            	
						pair = URLEncoder.encode(pair.substring(0, idx), "UTF-8");
						System.out.println("After pair--------->>["+pair+"]");
					}
				}
				query_pairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
			}
		}
		return query_pairs;
	}

	//Changed By Pragyan 17-NOV-14 for Sage Pay Integration.start
	static <T> String GetUrlParameters(Class<T> oObject, SagePayParameters insObject) {
		try {
			Field[] fields = oObject.getDeclaredFields();
			SagePayParameters objProductInst = insObject;
			StringBuilder parameters = new StringBuilder();
			for (Field field : fields) {
				field.setAccessible(true);
				Object value = field.get(objProductInst);
				parameters.append(String.format("%s=%s&",
						//Modifier.toString(field.getModifiers()),
						//field.getType().getSimpleName(),
						field.getName(), value
				));
			}
			parameters.deleteCharAt(parameters.lastIndexOf("&"));
			return parameters.toString();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	static <T> String GetUrlParameters(Class<T> oObject, Product insObject) {
		try {
			System.out.println("GetUrlParameters@----->>"+insObject.getLongDescription());	        	
			Field[] fields = oObject.getDeclaredFields();
			Product objProductInst = insObject;
			StringBuilder parameters = new StringBuilder();
			for (Field field : fields) {
				field.setAccessible(true);
				Object value = field.get(objProductInst);
				parameters.append(String.format("%s=%s&",
						//Modifier.toString(field.getModifiers()),
						//field.getType().getSimpleName(),
						field.getName(), value
				));
			}
			return parameters.toString();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}



	//Changed by samadhan D15AKAT003 on 25/05/2015 for delete product. Start
	public  int CallDelete(String sku,String url) throws Exception 
	{	        
		String urlParameters = "";
		String responseString = "";

		System.out.println("Sku Params["+sku+"]");
		//Changed by samadhan on 19/01/2016 for add api key to urlParameter
		//urlParameters="skus="+sku+"";
		urlParameters="skus="+sku+"&apiKey="+getDDSalesConfig("API_KEY")+"";
		System.out.println("url["+url+"]");
		System.out.println("urlParameters: "+urlParameters);

		URL obj = new URL(url);
		HttpURLConnection con = (HttpURLConnection) obj.openConnection();


		con.setRequestMethod("POST"); //Always do the POST method
		con.setRequestProperty("User-Agent", "Mozilla/5.0");
		con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");

		con.setDoOutput(true);

		try
		{
			DataOutputStream wr = new DataOutputStream(con.getOutputStream());
			wr.writeBytes(urlParameters);
			wr.flush();
		}
		catch(Exception e)
		{
			System.out.println("Exception in CommonWMS Util :: callDelete ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new Exception(e);
		}

		int responseCode = con.getResponseCode();

		switch (responseCode) 
		{ //Capture the response code from server
		case 500:
			System.out.println("Unexpected server error.");
			break;
		case 404:
			System.out.println("Target not found. Either files is missing or moved.");
			break;
		case 200: // if call successful, it may return 0 in case of product exist
			StringBuilder response;

			try
			{
				BufferedReader in = new BufferedReader(
						new InputStreamReader(con.getInputStream()));
				String inputLine;
				response = new StringBuilder();
				while ((inputLine = in.readLine()) != null) 
				{
					response.append(inputLine);
				}
				System.out.println("Response From magento Server ["+response.toString()+"]");

			}
			catch(Exception e)
			{
				System.out.println("Exception in CommonWMS Util :: callDelete ::" + e.getMessage() + ":");
				e.printStackTrace();
				throw new Exception(e);
			}

		}
		return 0;
	} 
	//Changed by samadhan D15AKAT003 on 25/05/2015 for delete product. End

	//Changed By Samadhan 20 May 2015 for Attribute Integration.start
	static <T> String GetUrlParameters(Class<T> oObject, Attribute insObject) 
	{
		try 
		{
			Field[] fields = oObject.getDeclaredFields();
			Attribute objAttribInst = insObject;
			StringBuilder parameters = new StringBuilder();
			for (Field field : fields) {
				field.setAccessible(true);
				Object value = field.get(objAttribInst);
				parameters.append(String.format("%s=%s&",
						//Modifier.toString(field.getModifiers()),
						//field.getType().getSimpleName(),
						field.getName(), value
				));
			}
			parameters.deleteCharAt(parameters.lastIndexOf("&"));
			return parameters.toString();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public  int CallAttribute(Attribute objAttrib,String url) throws Exception 
	{	        
		String urlParameters = GetUrlParameters(Attribute.class, objAttrib);
		String responseString = "";

		System.out.println("Attribute Code Params["+objAttrib.getAttrName()+"]");
		System.out.println("Attribute Value Params["+objAttrib.getAttrValue()+"]");
		System.out.println("Attribute Label Params["+objAttrib.getAttrLabels()+"]");
		System.out.println("url["+url+"]");
		System.out.println("urlParameters["+urlParameters+"]");

		URL obj = new URL(url);
		HttpURLConnection con = (HttpURLConnection) obj.openConnection();


		con.setRequestMethod("POST"); //Always do the POST method
		con.setRequestProperty("User-Agent", "Mozilla/5.0");
		con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");

		con.setDoOutput(true);

		try
		{
			DataOutputStream wr = new DataOutputStream(con.getOutputStream());
			wr.writeBytes(urlParameters);
			wr.flush();
		}
		catch(Exception e)
		{
			System.out.println("Exception in CommonWMS Util :: Attribute ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new Exception(e);
		}

		int responseCode = con.getResponseCode();

		switch (responseCode) 
		{ //Capture the response code from server
		case 500:
			System.out.println("Unexpected server error.");
			break;
		case 404:
			System.out.println("Target not found. Either files is missing or moved.");
			break;
		case 200: // if call successful, it may return 0 in case of product exist
			StringBuilder response;

			try
			{
				BufferedReader in = new BufferedReader(
						new InputStreamReader(con.getInputStream()));
				String inputLine;
				response = new StringBuilder();
				while ((inputLine = in.readLine()) != null) 
				{
					response.append(inputLine);
				}
				System.out.println("Response From Server ["+response.toString()+"]");
				responseString = response.toString();
				return Integer.parseInt(responseString);
			}
			catch(Exception e)
			{
				System.out.println("Exception in CommonWMS Util :: Attribute ::" + e.getMessage() + ":");
				e.printStackTrace();
				throw new Exception(e);
			}

		}
		return 0;
	} 
	//Changed By Samadhan 20 May 2015 for Attribute Integration.End
	static String AppendWithDelimeter(List<Integer> intList, String delimeter) {
		//Iterator<Integer> i = intList.iterator();
		StringBuilder commaAppender = new StringBuilder();
		//Looping through the list
		for ( int i = 0; i< intList.size(); i++){
			//append the value into the builder
			commaAppender.append(intList.get(i));

			//if the value is not the last element of the list
			//then append the comma(,) as well
			if ( i != intList.size()-1){
				commaAppender.append(delimeter);
			}
		}
		//return intList.stream().map(number -> String.valueOf(number)).collect(toStringJoiner(delimeter));
		return commaAppender.toString();
	}
	// Changed by Manish on 28-10-2015 [end]


	//Changed By Samadhan D15BKAT005 26 May 2015 for Update Tracking Status from ERP to magento.start
	static <T> String GetUrlParameters(Class<T> oObject, ShipmentStatus insObject) 
	{
		try 
		{
			Field[] fields = oObject.getDeclaredFields();
			ShipmentStatus objShipInst = insObject;
			StringBuilder parameters = new StringBuilder();
			for (Field field : fields) {
				field.setAccessible(true);
				Object value = field.get(objShipInst);
				parameters.append(String.format("%s=%s&",
						//Modifier.toString(field.getModifiers()),
						//field.getType().getSimpleName(),
						field.getName(), value
				));
			}
			parameters.deleteCharAt(parameters.lastIndexOf("&"));
			return parameters.toString();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public  String CallTrackShipStatus(ShipmentStatus shipParams,String url) throws Exception 
	{
		String responseShipTrack = "";
		try
		{
			if(url != null && url.length() > 0)
			{
				String urlParameters = GetUrlParameters(ShipmentStatus.class, shipParams);

				System.out.println("URL: "+url);
				System.out.println("urlParameters: "+urlParameters);
				URL obj = new URL(url);
				HttpURLConnection con = (HttpURLConnection) obj.openConnection();

				//add reuqest header
				con.setRequestMethod("POST"); //Always do the POST method
				con.setRequestProperty("User-Agent", "Mozilla/5.0");
				con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");

				// Send post request
				con.setDoOutput(true);
				try
				{
					DataOutputStream wr = new DataOutputStream(con.getOutputStream());
					wr.writeBytes(urlParameters);
					wr.flush();
				}
				catch(Exception e)
				{
					System.out.println("Exception in CommonWMS Util :: CallTrackShipStatus ::" + e.getMessage() + ":");
					e.printStackTrace();
					throw new Exception(e);
				}

				int responseCode = con.getResponseCode();

				switch (responseCode) { //Capture the response code from server
				case 500:
					System.out.println("Unexpected server error.");
					break;
				case 404:
					System.out.println("Target not found. Either files is missing or moved.");
					break;
				case 200: // if call successful, it may return 0 in case of product exist
					StringBuilder response;

					try
					{
						System.out.println("@@@@ in try bilock===");
						BufferedReader in = new BufferedReader(
								new InputStreamReader(con.getInputStream()));
						String inputLine;
						response = new StringBuilder();
						while ((inputLine = in.readLine()) != null) 
						{
							System.out.println("@@@@ inputLine===");
							response.append(inputLine);
						}
						responseShipTrack = response.toString();
						System.out.println("Response From Ship Tracking Server ["+responseShipTrack+"]");
					}
					catch(Exception e)
					{
						System.out.println("Exception in CommonWMS Util :: CallTrackShipStatus ::" + e.getMessage() + ":");
						e.printStackTrace();
						throw new Exception(e);
					}

					break;
				}
			}

		}catch (Exception e)
		{
			System.out.println("Exception in CommonWMS Util :: CallTrackShipStatus ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new Exception(e);
		}
		return responseShipTrack;
	} 
	//Change by Manish on 20/10/16 for RVB2B [Start]
	public  String CallTrackShipStatusRvb2b(ShipmentStatus shipParams,String url,String login,String Password) throws Exception 
	{
		String responseShipTrack = "";
		try
		{
			if(url != null && url.length() > 0)
			{
				String urlParameters = GetUrlParameters(ShipmentStatus.class, shipParams);

				System.out.println("URL: "+url);
				System.out.println("urlParameters: "+urlParameters);
				URL obj = new URL(url);
				HttpURLConnection con = (HttpURLConnection) obj.openConnection();
				
				con.setRequestMethod("POST");
	            String loginPassword = login+ ":" + Password;
	            String encoded = new sun.misc.BASE64Encoder().encode (loginPassword.getBytes());
	            con.setRequestProperty ("Authorization", "Basic " + encoded);
				con.setRequestProperty("User-Agent", "Mozilla/5.0");
				con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
				con.setDoOutput(true);
				try
				{
					DataOutputStream wr = new DataOutputStream(con.getOutputStream());
					wr.writeBytes(urlParameters);
					wr.flush();
				}
				catch(Exception e)
				{
					System.out.println("Exception in CommonWMS Util :: CallTrackShipStatus ::" + e.getMessage() + ":");
					e.printStackTrace();
					throw new Exception(e);
				}

				int responseCode = con.getResponseCode();

				switch (responseCode) { //Capture the response code from server
				case 500:
					System.out.println("Unexpected server error.");
					break;
				case 404:
					System.out.println("Target not found. Either files is missing or moved.");
					break;
				case 200: // if call successful, it may return 0 in case of product exist
					StringBuilder response;

					try
					{
						System.out.println("@@@@ in try bilock===");
						BufferedReader in = new BufferedReader(
								new InputStreamReader(con.getInputStream()));
						String inputLine;
						response = new StringBuilder();
						while ((inputLine = in.readLine()) != null) 
						{
							System.out.println("@@@@ inputLine===");
							response.append(inputLine);
						}
						responseShipTrack = response.toString();
						
						System.out.println("Response From Ship Tracking Server ["+responseShipTrack+"]");
					}
					catch(Exception e)
					{
						System.out.println("Exception in CommonWMS Util :: CallTrackShipStatus ::" + e.getMessage() + ":");
						e.printStackTrace();
						throw new Exception(e);
					}

					break;
				}
			}

		}catch (Exception e)
		{
			System.out.println("Exception in CommonWMS Util :: CallTrackShipStatus ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new Exception(e);
		}
		return responseShipTrack;
	} 
	//Change by Manish on 20/10/16 for RVB2B [End]
	static <T> String GetUrlParameters(Class<T> oObject, Object insObject) {
		try {
			Field[] fields = oObject.getDeclaredFields();          
			StringBuilder parameters = new StringBuilder();
			for (Field field : fields) {
				field.setAccessible(true);
				Object value = null;
				if(insObject instanceof PaypalParameters)
					value = field.get((PaypalParameters)insObject);
				else
					value = field.get((PaypalRefundParams)insObject);

				parameters.append(String.format("%s=%s&",
						//Modifier.toString(field.getModifiers()),
						//field.getType().getSimpleName(),
						field.getName(), value
				));
			}
			parameters.deleteCharAt(parameters.lastIndexOf("&"));
			return parameters.toString();
		} catch (Exception e) {
			e.printStackTrace();

		}
		return null;
	}




	//Changed By Samadhan on 07/07/2015 D15CKAT015 for calling payPal Authorization End
	public String getTrackingNo(String ptcn, Connection conn) 
	{
		String sql="",trackNo="";
		PreparedStatement pstmt = null;
		ResultSet rs= null;
		try
		{
			sql="select tracking_no from carton_master where carton_type in ('A','N') and ptcn = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, ptcn);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				if(!checkNull(rs.getString(1)).equalsIgnoreCase(""))
				{
					trackNo = trackNo + checkNull(rs.getString(1))+",";
				}
			}
			if( rs != null)
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(!trackNo.equals(""))
			{
				//trackNo = trackNo.substring(1,trackNo.length()-1);
				trackNo = trackNo.substring(0,trackNo.length()-1);
				System.out.println("trackNo is["+trackNo+"]");
			}
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		finally
		{ 
			try
			{
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}catch (Exception e) {
				// TODO: handle exception
			}
		}
		return trackNo;
	}

	// Changed by Sneha on 03/07/2015 for finparm, Request ID: D15DKAT001
	public String getfinparm(String pCode, String varName, Connection conn) throws ITMException
	{
		String sql = "";
		String varValue = "";
		String addValue = "";
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		try
		{
			sql = "select var_value, addl_value from finparm where prd_code = ? and var_name = ?" ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,pCode);
			pstmt.setString(2,varName);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				varValue = rs.getString("var_value");
				addValue = rs.getString("addl_value");
			}
			//Changed by wasim on 15-03-2016 to close result set and addValue condition in try block [START]
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(addValue == null || addValue.trim().length() == 0)
			{
				return varValue;
			}
			else	
			{
				return varValue.trim()+";"+addValue.trim();
			}
			//Changed by wasim on 15-03-2016 to close result set and addValue condition in try block [END]
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		//Changed by wasim on 15-03-2016 to add finally block [START]
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		//Changed by wasim on 15-03-2016 to add finally block [END]
	}

	//End by Sneha on 03/07/2015 for finparm, Request ID: D15DKAT001

	public static Document getDDDom(String usrDefinefileName)throws ITMException,Exception
	{
		String dateFormatStr = null;
		String fileName = "DDSalesConfig";
		Document doc  = null;

		try
		{
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();

			if(usrDefinefileName != null && usrDefinefileName.trim().length() > 0)
			{
				fileName = usrDefinefileName;
			}

			doc = db.parse(CommonConstants.APPLICATION_CONTEXT + File.separator + "setting" + File.separator + fileName + ".xml");
		}
		catch(Exception e)
		{
			System.out.println("Exception :CommonWmsUtil :getDDDom :==>\n"+e);
			throw new ITMException(e);
		}
		return doc;
	}

	public static String AuthorizePayment(SagePayParameters sagePayParams,String url) throws MalformedURLException, IOException {
		String urlParameters = GetUrlParameters(SagePayParameters.class, sagePayParams);
		String responseString = "";
		System.out.println("sagePayParams["+sagePayParams.toString()+"]");

		System.out.println("sagePayParams["+sagePayParams.getAmount()+"]");

		System.out.println("url["+url+"]");
		//API url call, defined in config file
		// URL obj = new URL("https://test.sagepay.com/gateway/service/authorise.vsp");
		URL obj = new URL(url);
		HttpURLConnection con = (HttpURLConnection) obj.openConnection();

		//add reuqest header
		con.setRequestMethod("POST"); //Always do the POST method
		con.setRequestProperty("User-Agent", "Mozilla/5.0");
		con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");

		// Send post request
		con.setDoOutput(true);
		/* try (DataOutputStream wr = new DataOutputStream(con.getOutputStream())) {
	            wr.writeBytes(urlParameters);
	            wr.flush();
	        }*/
		try
		{
			DataOutputStream wr = new DataOutputStream(con.getOutputStream());
			wr.writeBytes(urlParameters);
			wr.flush();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		int responseCode = con.getResponseCode();

		switch (responseCode) { //Capture the response code from server
		case 500:
			System.out.println("Unexpected server error.");
			break;
		case 404:
			System.out.println("Target not found. Either files is missing or moved.");
			break;
		case 200: // if call successful, it may return 0 in case of product exist
			StringBuilder response;

			/*try (BufferedReader in = new BufferedReader(
	                        new InputStreamReader(con.getInputStream()))) {
	                    String inputLine;
	                    response = new StringBuilder();
	                    while ((inputLine = in.readLine()) != null) {
	                        response.append(inputLine);
	                    }
	                }*/

			try
			{
				BufferedReader in = new BufferedReader(
						new InputStreamReader(con.getInputStream()));
				String inputLine;
				response = new StringBuilder();
				while ((inputLine = in.readLine()) != null) 
				{
					response.append(inputLine);
				}
				System.out.println("Response From SagePay Server ["+response.toString()+"]");
				responseString = response.toString();
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}

			break;
		}
		return responseString;

	}

	public static String PaypalRefundPayment(String url,PaypalRefundParams paypalParams) throws Exception
	{
		String responseStr="";
		String urlParameters = GetUrlParameters(PaypalRefundParams.class, paypalParams);
		System.out.println(urlParameters);

		URL obj = new URL(url);

		// Create a trust manager that does not validate certificate chains
		TrustManager[] trustAllCerts = new TrustManager[] { 
				new X509TrustManager() {
					public X509Certificate[] getAcceptedIssuers() { 
						return new X509Certificate[0]; 
					}
					public void checkClientTrusted(X509Certificate[] certs, String authType) {}
					public void checkServerTrusted(X509Certificate[] certs, String authType) {}
				}};

		// Ignore differences between given hostname and certificate hostname
		HostnameVerifier hv = new HostnameVerifier() 
		{
			public boolean verify(String hostname, SSLSession session) { return true; }
		};

		SSLContext sc = SSLContext.getInstance("SSL");
		sc.init(null, trustAllCerts, new SecureRandom());
		HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
		HttpsURLConnection.setDefaultHostnameVerifier(hv);

		HttpsURLConnection con = (HttpsURLConnection) obj.openConnection();

		//add reuqest header
		con.setRequestMethod("POST"); //Always do the POST method
		con.setRequestProperty("User-Agent", "Mozilla/5.0");
		con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
		//con.setHostnameVerifier(new DummyHostnameVerifier());
		// Send post request
		con.setDoOutput(true);

		try
		{
			DataOutputStream wr = new DataOutputStream(con.getOutputStream());
			wr.writeBytes(urlParameters.toString());
			wr.flush();

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		int responseCode = con.getResponseCode();

		switch (responseCode) 
		{ //Capture the response code from server
		case 500:
			System.out.println("Unexpected server error.");
			break;
		case 404:
			System.out.println("Target not found. Either files is missing or moved.");
			break;
		case 200: // if call successful, it may return 0 in case of product exist
			StringBuilder response;              
			try
			{
				BufferedReader in = new BufferedReader(
						new InputStreamReader(con.getInputStream()));
				String inputLine;
				response = new StringBuilder();
				while ((inputLine = in.readLine()) != null) 
				{
					response.append(inputLine);
				}
				responseStr = URLDecoder.decode(response.toString());
				System.out.println(responseStr); 
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new Exception(e);
			} 
		}
		return responseStr;
	}


	//Changed By Samadhan on 07/07/2015 D15CKAT015 for calling payPal Authorization End

	public void sendMail(String mailFlag,String attachFlag,String formatCode,String attachPath,String errorString, UserInfoBean userInfo, Connection conn) throws Exception,SQLException   
	{
		System.out.println("----------in sendingMail--------------------");				
		StringBuffer commInfo = new StringBuffer();
		ResultSet rs=null;
		PreparedStatement pstmt=null;
		String sql="",sendTo="",copyTo="",bccTo="",subject="",bodyText="";

		EMail email = new EMail();
		try
		{	
			if("Y".equalsIgnoreCase(mailFlag) && formatCode != null && formatCode.length() > 0 )
			{
				sql="select send_to,copy_to,blind_copy,subject,body_text from mail_format where format_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, formatCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sendTo = checkNull(rs.getString(1));
					copyTo = checkNull(rs.getString(2));
					bccTo = checkNull(rs.getString(3));
					subject = checkNull(rs.getString(4));
					bodyText = checkNull(rs.getString(5));
				}
				rs.close();
				pstmt.close();
				rs=null;
				pstmt=null;
				System.out.println("mailFlag-------"+mailFlag);
				System.out.println("attachement Flag-------"+attachFlag);
				System.out.println("formatCode-------"+formatCode);
				System.out.println("attachPath-------"+attachPath);
				//bodyText = "bodyText \n"+errorString;
				commInfo.append("<ROOT>");
				commInfo.append("<MAILINFO>");
				commInfo.append("<EMAIL_TYPE>").append("page").append("</EMAIL_TYPE>");
				commInfo.append("<TO_ADD>").append("<![CDATA[" + sendTo + "]]>").append("</TO_ADD>");
				commInfo.append("<CC_ADD>").append("<![CDATA[" + copyTo + "]]>").append("</CC_ADD>");
				commInfo.append("<BCC_ADD>").append("<![CDATA[" + bccTo + "]]>").append("</BCC_ADD>");
				commInfo.append("<SUBJECT>").append("<![CDATA[" + subject + "]]>").append("</SUBJECT>");
				commInfo.append("<BODY_TEXT>").append("<![CDATA[" +  bodyText + "]]>").append("</BODY_TEXT>");
				if("Y".equalsIgnoreCase(attachFlag))
				{
					commInfo.append("<XML_DATA_FILE_PATH>").append("<![CDATA[" + attachPath + "]]>").append("</XML_DATA_FILE_PATH>");
				}

				commInfo.append("</MAILINFO>");
				commInfo.append("</ROOT>");		
				System.out.println(" calling sendMail  method()");
				email.sendMail(commInfo.toString(), "ITM", userInfo);
				System.out.println(" ********Email send succesfully ***********");
			}

		} 
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :SorderInsertSchedule :sendMail : " + e.getMessage());
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs=null;				
			}
			if(pstmt != null)
			{
				pstmt.close();				
				pstmt=null;
			}
		}
		email = null;

	}

	//Changed By Samadhan on 07/07/2015 D15CKAT015 for calling payPal Authorization Start
	public static String PaypalAuthorizePayment(String url,PaypalParameters paypalParams) throws Exception
	{
		String responseStr="";
		String urlParameters = GetUrlParameters(PaypalParameters.class, paypalParams);
		System.out.println(urlParameters);

		URL obj = new URL(url);

		// Create a trust manager that does not validate certificate chains
		TrustManager[] trustAllCerts = new TrustManager[] { 
				new X509TrustManager() {
					public X509Certificate[] getAcceptedIssuers() { 
						return new X509Certificate[0]; 
					}
					public void checkClientTrusted(X509Certificate[] certs, String authType) {}
					public void checkServerTrusted(X509Certificate[] certs, String authType) {}
				}};

		// Ignore differences between given hostname and certificate hostname
		HostnameVerifier hv = new HostnameVerifier() 
		{
			public boolean verify(String hostname, SSLSession session) { return true; }
		};

		SSLContext sc = SSLContext.getInstance("SSL");
		sc.init(null, trustAllCerts, new SecureRandom());
		HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
		HttpsURLConnection.setDefaultHostnameVerifier(hv);

		HttpsURLConnection con = (HttpsURLConnection) obj.openConnection();

		//add reuqest header
		con.setRequestMethod("POST"); //Always do the POST method
		con.setRequestProperty("User-Agent", "Mozilla/5.0");
		con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
		//con.setHostnameVerifier(new DummyHostnameVerifier());
		// Send post request
		con.setDoOutput(true);

		try
		{
			DataOutputStream wr = new DataOutputStream(con.getOutputStream());
			wr.writeBytes(urlParameters.toString());
			wr.flush();

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		int responseCode = con.getResponseCode();

		switch (responseCode) 
		{ //Capture the response code from server
		case 500:
			System.out.println("Unexpected server error.");
			break;
		case 404:
			System.out.println("Target not found. Either files is missing or moved.");
			break;
		case 200: // if call successful, it may return 0 in case of product exist
			StringBuilder response;              
			try
			{
				BufferedReader in = new BufferedReader(
						new InputStreamReader(con.getInputStream()));
				String inputLine;
				response = new StringBuilder();
				while ((inputLine = in.readLine()) != null) 
				{
					response.append(inputLine);
				}
				responseStr = URLDecoder.decode(response.toString());
				System.out.println(responseStr); 
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new Exception(e);
			} 
		}
		return responseStr;
	}
	//Changed by Samadhan on 28/11/2015 for finding full or partial pallet Start.
	public static String getFullOrPrtialPalletOut(String palletNo,String refSer,String tranId,String siteCode,Connection conn) throws Exception
	{
		String result="F";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sqlStr="";

		PreparedStatement pstmtChk = null;
		ResultSet rsChk = null;
		String sqlStrChk="";

		PreparedStatement pstChkDSO = null;
		ResultSet rsChkDSO = null;
		String sqlChkDSO="";
		int count = 0;

		ArrayList<HashMap<String, String>> stockList = new ArrayList<HashMap<String,String>>();

		System.out.println("getFullOrPrtialPalletOut::Pallet No:"+palletNo);
		System.out.println("getFullOrPrtialPalletOut::Ref Ser:"+refSer);
		System.out.println("getFullOrPrtialPalletOut::Tran Id:"+tranId);
		System.out.println("getFullOrPrtialPalletOut::Site Code:"+siteCode);


		try 
		{
			if("PR".equalsIgnoreCase(refSer))
			{
				result="F";
				return result;
			}
			sqlStr = "SELECT ITEM_CODE,LOT_NO,LOT_SL,QUANTITY FROM STOCK WHERE QUANTITY > 0 AND LOC_CODE = '"+palletNo+"' AND SITE_CODE = '"+siteCode+"' AND INV_STAT='AWMS' ";

			//sqlStr = "SELECT PALLET_NO,ITEM_CODE,LOT_NO,LOT_SL,QUANTITY FROM STOCK WHERE QUANTITY > 0 AND LOC_CODE = ? AND SITE_CODE = ? AND INV_STAT='AWMS' ";

			System.out.println("SQL:"+sqlStr);
			pstmt = conn.prepareStatement(sqlStr);
			//pstmt.setString(1, palletNo);
			//pstmt.setString(2, siteCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				HashMap<String,String> stockHashMap =  new HashMap<String, String>();

				stockHashMap.put("ITEM_CODE", rs.getString("ITEM_CODE").trim());
				stockHashMap.put("LOT_NO", rs.getString("LOT_NO").trim());
				stockHashMap.put("LOT_SL", rs.getString("LOT_SL").trim());
				stockHashMap.put("QUANTITY",String.valueOf(rs.getInt("QUANTITY")));
				stockList.add(stockHashMap);
			}
			pstmt.close();
			rs.close();
			if("PRS".equalsIgnoreCase(refSer))
			{
				for(Iterator<HashMap<String, String>> iter = stockList.iterator();iter.hasNext();)
				{
					HashMap<String, String> stock = iter.next();

					/*sqlStrChk = "select count (*) FROM PALLET_REQ_DET where tran_id = '"+tranId+"' " +
		                    "and PALLET_NO='"+palletNo+"' and " +
		                    "lot_sl = '"+stock.get("LOT_SL")+"' and " +
		                    "lot_no ='"+stock.get("LOT_NO")+"' and item_code='"+stock.get("ITEM_CODE")+"' and quantity ='"+stock.get("QUANTITY")+"'";
					 */
					sqlStrChk = "select count (*) FROM PALLET_REQ_DET where tran_id = ? " +
					"and PALLET_NO=? and lot_sl = ? and " +
					"lot_no =? and item_code=? and quantity = ?";

					System.out.println(sqlStrChk);            
					pstmtChk = conn.prepareStatement(sqlStrChk);
					pstmtChk.setString(1, tranId);
					pstmtChk.setString(2, palletNo);
					pstmtChk.setString(3, stock.get("LOT_SL"));
					pstmtChk.setString(4, stock.get("LOT_NO"));
					pstmtChk.setString(5, stock.get("ITEM_CODE"));
					pstmtChk.setString(6, stock.get("QUANTITY"));

					rsChk = pstmtChk.executeQuery();
					count=0;
					if(rsChk.next())
					{
						count = rsChk.getInt(1);
						if(count == 0)
						{
							result = "P";
							break;
						}
					}
					pstmtChk.close();
					rsChk.close();
				}
			}
			else if("D-SO".equalsIgnoreCase(refSer))
			{
				for(Iterator<HashMap<String, String>> iter = stockList.iterator();iter.hasNext();)
				{
					HashMap<String, String> stock = iter.next();

					/*sqlStrChk = "select sum(quantity) from distorder_alloc where dist_order = '"+tranId+"' " +
		                                "and loc_code = '"+palletNo+"' and item_code='"+stock.get("ITEM_CODE")+"' and " +
		                                "lot_no='"+stock.get("LOT_NO")+"' and lot_sl ='"+stock.get("LOT_SL")+"' group by " +
		                                "loc_code,item_code,lot_no,lot_sl";*/

					sqlStrChk = "select sum(quantity) from distorder_alloc where dist_order = ? " +
					"and loc_code = ? and item_code=? and lot_no=? and lot_sl =? " +
					"group by loc_code,item_code,lot_no,lot_sl";

					System.out.println(sqlStrChk);            
					pstmtChk = conn.prepareStatement(sqlStrChk);
					pstmtChk.setString(1, tranId);
					pstmtChk.setString(2, palletNo);
					pstmtChk.setString(3, stock.get("ITEM_CODE"));
					pstmtChk.setString(4, stock.get("LOT_NO"));
					pstmtChk.setString(5, stock.get("LOT_SL"));

					rsChk = pstmtChk.executeQuery();
					int stockQty = Integer.parseInt(stock.get("QUANTITY"));
					System.out.println("Stock Quantity:"+stockQty);
					if(rsChk.next())
					{
						int qnty = rsChk.getInt(1);
						System.out.println("distorder_alloc Quantity"+qnty);
						if(qnty != stockQty)
						{
							result ="P";
						}
					}
					else
					{
						/*sqlChkDSO = "select sum(quantity) from distord_issdet where dist_order = '"+tranId+"' " +
		                                    "and loc_code = '"+palletNo+"' and item_code='"+stock.get("ITEM_CODE")+"' and " +
		                                    "lot_no='"+stock.get("LOT_NO")+"' and lot_sl ='"+stock.get("LOT_SL")+"' group by " +
		                                    "loc_code,item_code,lot_no,lot_sl";*/

						sqlChkDSO = "select sum(quantity) from distord_issdet where dist_order = ? " +
						"and loc_code = ? and item_code= ? and lot_no=? and lot_sl =? " +
						"group by loc_code,item_code,lot_no,lot_sl";

						System.out.println(sqlChkDSO);            
						pstChkDSO = conn.prepareStatement(sqlChkDSO);
						pstChkDSO.setString(1, tranId);
						pstChkDSO.setString(2, palletNo);
						pstChkDSO.setString(3, stock.get("ITEM_CODE"));
						pstChkDSO.setString(4, stock.get("LOT_NO"));
						pstChkDSO.setString(5, stock.get("LOT_SL"));

						rsChkDSO = pstChkDSO.executeQuery();
						count=0;
						if(rsChkDSO.next())
						{
							int qnty = rsChkDSO.getInt(1);
							System.out.println("distord_issdet Quantity"+qnty);
							if(qnty != stockQty)
							{
								result ="P";
								break;
							}
						}
						else
						{
							result ="P";
							break;
						}
						pstChkDSO.close();
						rsChkDSO.close();    
					}
					pstmtChk.close();
					rsChk.close();
				}
			}
		} 
		catch (Exception e) 
		{

			throw e;
		}
		finally
		{
			if(pstmt !=null)
			{
				pstmt.close();
				pstChkDSO = null;
			}
			if(rs !=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmtChk !=null)
			{
				pstmtChk.close();
				pstmtChk = null;
			}
			if(rsChk !=null)
			{
				rsChk.close();
				rsChk = null;
			}
			if(pstChkDSO !=null)
			{
				pstChkDSO.close();
				pstChkDSO = null;
			}
			if(rsChkDSO !=null)
			{
				rsChkDSO.close();
				rsChkDSO = null;
			}
		}
		System.out.println("Result returning to Caller:" +result);
		return result;
	}
	//Changed by Samadhan on 28/11/2015 for finding full or partial pallet End.

		//Changed by Samadhan on 28/01/2016 for get column value from element node start
		public String getColumnValue(Node elementNode,String columnName)
		{
			String colValue="";
			String childNodeName = elementNode.getNodeName();
			NodeList nodeList = null;
			System.out.println("Node name --->> "+childNodeName);	
			if (elementNode.getNodeType() == Node.ELEMENT_NODE)
			{
				Element eElement = (Element) elementNode;					
				nodeList = eElement.getElementsByTagName(columnName);
				if(nodeList != null)
				{
					if(nodeList.item(0)!=null)
					{
						colValue =  checkNull(nodeList.item(0).getTextContent());
					}
				}
				System.out.println("Column value --->["+colValue+"]");					
			}
			else
			{
				System.out.println("Not a Element Node......");
			}
			
			return colValue;
		}
		//Changed by Samadhan on 28/01/2016 for get column value from element node start
}
